/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.cluster.Health;
import io.searchbox.cluster.NodesInfo;
import io.searchbox.cluster.PendingClusterTasks;
import io.searchbox.cluster.Stats;
import io.searchbox.core.Cat;
import io.searchbox.core.CatResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.storage.elasticsearch6.cluster.GetAllocationDiskSettings;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.cluster.ClusterAdapter;
import org.graylog2.indexer.cluster.PendingTasksStats;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettings;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettingsFactory;
import org.graylog2.indexer.cluster.health.NodeDiskUsageStats;
import org.graylog2.indexer.cluster.health.NodeFileDescriptorStats;
import org.graylog2.indexer.indices.HealthStatus;
import org.graylog2.rest.models.system.indexer.responses.ClusterHealth;
import org.graylog2.system.stats.elasticsearch.ClusterStats;
import org.graylog2.system.stats.elasticsearch.IndicesStats;
import org.graylog2.system.stats.elasticsearch.NodesStats;
import org.graylog2.system.stats.elasticsearch.ShardStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAdapterES6
implements ClusterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterAdapterES6.class);
    private final JestClient jestClient;
    private final Duration requestTimeout;

    @Inject
    public ClusterAdapterES6(JestClient jestClient, @Named(value="elasticsearch_socket_timeout") Duration requestTimeout) {
        this.jestClient = jestClient;
        this.requestTimeout = requestTimeout;
    }

    public Optional<HealthStatus> health(Collection<String> indices) {
        Optional<JsonNode> result = this.clusterHealth(indices);
        return result.map(this::extractHealthStatus);
    }

    private HealthStatus extractHealthStatus(JsonNode node) {
        String statusString = node.path("status").asText().toLowerCase(Locale.ENGLISH);
        return HealthStatus.fromString((String)statusString);
    }

    public Set<NodeFileDescriptorStats> fileDescriptorStats() {
        JsonNode nodes = this.catNodes("name", "host", "ip", "fileDescriptorMax");
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (JsonNode jsonElement : nodes) {
            if (!jsonElement.isObject()) continue;
            String name = jsonElement.path("name").asText();
            String host = jsonElement.path("host").asText(null);
            String ip = jsonElement.path("ip").asText();
            JsonNode fileDescriptorMax = jsonElement.path("fileDescriptorMax");
            Long maxFileDescriptors = fileDescriptorMax.isLong() ? Long.valueOf(fileDescriptorMax.asLong()) : null;
            setBuilder.add((Object)NodeFileDescriptorStats.create((String)name, (String)ip, (String)host, (Long)maxFileDescriptors));
        }
        return setBuilder.build();
    }

    public Set<NodeDiskUsageStats> diskUsageStats() {
        JsonNode nodes = this.catNodes("name", "role", "host", "ip", "diskUsed", "diskTotal", "diskUsedPercent");
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (JsonNode jsonElement : nodes) {
            if (!jsonElement.isObject()) continue;
            setBuilder.add((Object)NodeDiskUsageStats.create((String)jsonElement.path("name").asText(), (String)jsonElement.path("role").asText(), (String)jsonElement.path("ip").asText(), (String)jsonElement.path("host").asText(null), (String)jsonElement.path("diskUsed").asText(), (String)jsonElement.path("diskTotal").asText(), (Double)jsonElement.path("diskUsedPercent").asDouble(-1.0)));
        }
        return setBuilder.build();
    }

    public ClusterAllocationDiskSettings clusterAllocationDiskSettings() {
        GetAllocationDiskSettings request = new GetAllocationDiskSettings.Builder().build();
        JestResult response = JestUtils.execute(this.jestClient, request, () -> "Unable to read Elasticsearch cluster settings");
        JsonNode json = response.getJsonObject();
        JsonNode floodStageSetting = this.findEffectiveSettingInSettingsGroups(json, "flood_stage", true);
        return ClusterAllocationDiskSettingsFactory.create((boolean)this.findEffectiveSettingInSettingsGroups(json, "threshold_enabled", false).asBoolean(), (String)this.findEffectiveSettingInSettingsGroups(json, "low", false).asText(), (String)this.findEffectiveSettingInSettingsGroups(json, "high", false).asText(), (String)(floodStageSetting != null ? floodStageSetting.asText() : ""));
    }

    public Optional<String> nodeIdToName(String nodeId) {
        return Optional.ofNullable(this.getNodeInfo(nodeId).path("name").asText(null));
    }

    public Optional<String> nodeIdToHostName(String nodeId) {
        return Optional.ofNullable(this.getNodeInfo(nodeId).path("host").asText(null));
    }

    public boolean isConnected() {
        Health request = new Health.Builder().local().timeout(Ints.saturatedCast((long)this.requestTimeout.toSeconds())).build();
        try {
            JestResult result = JestUtils.execute(this.jestClient, request, () -> "Couldn't check connection status of Elasticsearch");
            int numberOfDataNodes = result.getJsonObject().path("number_of_data_nodes").asInt();
            return numberOfDataNodes > 0;
        }
        catch (ElasticsearchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public Optional<String> clusterName(Collection<String> indices) {
        return this.clusterHealth(indices).map(health -> health.path("cluster_name").asText("<unknown>"));
    }

    public Optional<ClusterHealth> clusterHealthStats(Collection<String> indices) {
        return this.clusterHealth(indices).map(health -> {
            ClusterHealth.ShardStatus shards = ClusterHealth.ShardStatus.create((int)health.path("active_shards").asInt(), (int)health.path("initializing_shards").asInt(), (int)health.path("relocating_shards").asInt(), (int)health.path("unassigned_shards").asInt());
            return ClusterHealth.create((String)health.path("status").asText().toLowerCase(Locale.ENGLISH), (ClusterHealth.ShardStatus)shards);
        });
    }

    public ShardStats shardStats(Collection<String> indices) {
        Health clusterHealthRequest = ((Health.Builder)new Health.Builder().addIndex(indices)).build();
        JestResult clusterHealthResponse = JestUtils.execute(this.jestClient, clusterHealthRequest, () -> "Couldn't read Elasticsearch cluster health");
        JsonNode clusterHealthJson = clusterHealthResponse.getJsonObject();
        return ShardStats.create((int)clusterHealthJson.path("number_of_nodes").asInt(-1), (int)clusterHealthJson.path("number_of_data_nodes").asInt(-1), (int)clusterHealthJson.path("active_shards").asInt(-1), (int)clusterHealthJson.path("relocating_shards").asInt(-1), (int)clusterHealthJson.path("active_primary_shards").asInt(-1), (int)clusterHealthJson.path("initializing_shards").asInt(-1), (int)clusterHealthJson.path("unassigned_shards").asInt(-1), (boolean)clusterHealthJson.path("timed_out").asBoolean());
    }

    public PendingTasksStats pendingTasks() {
        JestResult pendingClusterTasksResponse = JestUtils.execute(this.jestClient, new PendingClusterTasks.Builder().build(), () -> "Couldn't read Elasticsearch pending cluster tasks");
        JsonNode pendingClusterTasks = pendingClusterTasksResponse.getJsonObject().path("tasks");
        int pendingTasksSize = pendingClusterTasks.size();
        ArrayList pendingTasksTimeInQueue = Lists.newArrayListWithCapacity((int)pendingTasksSize);
        for (JsonNode jsonElement : pendingClusterTasks) {
            if (!jsonElement.has("time_in_queue_millis")) continue;
            pendingTasksTimeInQueue.add(jsonElement.get("time_in_queue_millis").asLong());
        }
        return PendingTasksStats.create((int)pendingTasksSize, (List)pendingTasksTimeInQueue);
    }

    public ClusterStats clusterStats() {
        ArrayNode versions;
        JsonNode versionNode;
        JestResult clusterStatsResponse = JestUtils.execute(this.jestClient, new Stats.Builder().build(), () -> "Couldn't read Elasticsearch cluster stats");
        JsonNode clusterStatsResponseJson = clusterStatsResponse.getJsonObject();
        String clusterName = clusterStatsResponseJson.path("cluster_name").asText();
        String clusterVersion = null;
        if (clusterStatsResponseJson.path("nodes").path("versions").isArray() && (versionNode = (versions = (ArrayNode)clusterStatsResponseJson.path("nodes").path("versions")).path(0)).getNodeType() != JsonNodeType.MISSING) {
            clusterVersion = versionNode.asText();
        }
        JsonNode countStats = clusterStatsResponseJson.path("nodes").path("count");
        NodesStats nodesStats = NodesStats.create((int)countStats.path("total").asInt(-1), (int)countStats.path("master_only").asInt(-1), (int)countStats.path("data_only").asInt(-1), (int)countStats.path("master_data").asInt(-1), (int)countStats.path("client").asInt(-1));
        JsonNode clusterIndicesStats = clusterStatsResponseJson.path("indices");
        IndicesStats indicesStats = IndicesStats.create((int)clusterIndicesStats.path("count").asInt(-1), (long)clusterIndicesStats.path("store").path("size_in_bytes").asLong(-1L), (long)clusterIndicesStats.path("fielddata").path("memory_size_in_bytes").asLong(-1L));
        return ClusterStats.create((String)clusterName, (String)clusterVersion, (NodesStats)nodesStats, (IndicesStats)indicesStats);
    }

    private JsonNode getNodeInfo(String nodeId) {
        if (nodeId == null || nodeId.isEmpty()) {
            return MissingNode.getInstance();
        }
        NodesInfo request = ((NodesInfo.Builder)new NodesInfo.Builder().addNode(nodeId)).build();
        JestResult result = JestUtils.execute(this.jestClient, request, () -> "Couldn't read information of Elasticsearch node " + nodeId);
        return result.getJsonObject().path("nodes").path(nodeId);
    }

    private JsonNode findEffectiveSettingInSettingsGroups(JsonNode jsonNode, String setting, boolean optional) {
        List<String> settingsGroup = Arrays.asList("transient", "persistent", "defaults");
        for (String group : settingsGroup) {
            JsonNode foundSetting;
            JsonNode foundGroup = jsonNode.findPath(group);
            if (foundGroup instanceof MissingNode || (foundSetting = foundGroup.findPath(setting)) instanceof MissingNode) continue;
            return foundSetting;
        }
        if (optional) {
            return null;
        }
        throw new IllegalStateException(String.format(Locale.ENGLISH, "Could not find setting %s in Elasticsearch response", setting));
    }

    private JsonNode catNodes(String ... fields) {
        String fieldNames = String.join((CharSequence)",", fields);
        Cat request = ((Cat.NodesBuilder)((Cat.NodesBuilder)((Cat.NodesBuilder)new Cat.NodesBuilder().setParameter("h", fieldNames)).setParameter("full_id", true)).setParameter("format", "json")).build();
        CatResult response = JestUtils.execute(this.jestClient, request, () -> "Unable to read Elasticsearch node information");
        return response.getJsonObject().path("result");
    }

    private Optional<JsonNode> clusterHealth(Collection<? extends String> indices) {
        Health request = ((Health.Builder)new Health.Builder().addIndex(indices)).timeout(Ints.saturatedCast((long)this.requestTimeout.toSeconds())).build();
        try {
            JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read cluster health for indices " + indices);
            return Optional.of(jestResult.getJsonObject());
        }
        catch (ElasticsearchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("{} ({})", new Object[]{e.getMessage(), Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("n/a"), e});
            } else {
                LOG.error("{} ({})", (Object)e.getMessage(), (Object)Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("n/a"));
            }
            return Optional.empty();
        }
    }
}

