/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.indices.mapping.GetMapping;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePollerAdapter;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFieldTypePollerAdapterES6
implements IndexFieldTypePollerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(IndexFieldTypePollerAdapterES6.class);
    private final JestClient jestClient;

    @Inject
    public IndexFieldTypePollerAdapterES6(JestClient jestClient) {
        this.jestClient = jestClient;
    }

    public Optional<Set<FieldTypeDTO>> pollIndex(String indexName, Timer pollTimer) {
        JestResult result;
        GetMapping getMapping = ((GetMapping.Builder)new GetMapping.Builder().addIndex(indexName)).build();
        try (Timer.Context ignored = pollTimer.time();){
            result = JestUtils.execute(this.jestClient, getMapping, () -> "Unable to get index mapping for index: " + indexName);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Couldn't get mapping for index <{}>", (Object)indexName, (Object)e);
            } else {
                LOG.error("Couldn't get mapping for index <{}>: {}", (Object)indexName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            return Optional.empty();
        }
        JsonNode properties = result.getJsonObject().path(indexName).path("mappings").path("message").path("properties");
        if (properties.isMissingNode()) {
            LOG.error("Invalid mapping response: {}", (Object)result.getJsonString());
            return Optional.empty();
        }
        Spliterator fieldSpliterator = Spliterators.spliteratorUnknownSize(properties.fields(), 1024);
        Map<String, String> fieldTypes = StreamSupport.stream(fieldSpliterator, false).collect(Collectors.toMap(Map.Entry::getKey, field -> ((JsonNode)field.getValue()).path("type").asText()));
        return Optional.of(fieldTypes.entrySet().stream().filter(field -> !((String)field.getValue()).isEmpty()).map(field -> FieldTypeDTO.create((String)((String)field.getKey()), (String)((String)field.getValue()))).collect(Collectors.toSet()));
    }
}

