/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.CardinalityAggregation;
import io.searchbox.core.search.aggregation.ExtendedStatsAggregation;
import io.searchbox.core.search.aggregation.ValueCountAggregation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.graylog.storage.elasticsearch6.MultiSearch;
import org.graylog.storage.elasticsearch6.Scroll;
import org.graylog.storage.elasticsearch6.SortOrderMapper;
import org.graylog.storage.elasticsearch6.TimeRangeQueryFactory;
import org.graylog2.Configuration;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.ScrollCommand;
import org.graylog2.indexer.searches.SearchesAdapter;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class SearchesAdapterES6
implements SearchesAdapter {
    private static final String DEFAULT_SCROLLTIME = "1m";
    private static final String AGG_CARDINALITY = "gl2_field_cardinality";
    private static final String AGG_EXTENDED_STATS = "gl2_extended_stats";
    private static final String AGG_FILTER = "gl2_filter";
    private static final String AGG_VALUE_COUNT = "gl2_value_count";
    private static final Sorting DEFAULT_SORTING = new Sorting("_doc", Sorting.Direction.ASC);
    private final Configuration configuration;
    private final MultiSearch multiSearch;
    private final Scroll scroll;
    private final SortOrderMapper sortOrderMapper;

    @Inject
    public SearchesAdapterES6(Configuration configuration, MultiSearch multiSearch, Scroll scroll, SortOrderMapper sortOrderMapper) {
        this.configuration = configuration;
        this.multiSearch = multiSearch;
        this.scroll = scroll;
        this.sortOrderMapper = sortOrderMapper;
    }

    public CountResult count(Set<String> affectedIndices, String query, TimeRange range, String filter) {
        String searchSource = this.standardSearchRequest(query, 0, -1, range, filter, null, false).toString();
        Search search = ((Search.Builder)new Search.Builder(searchSource).addIndex(affectedIndices)).build();
        SearchResult searchResult = this.multiSearch.wrap(search, () -> "Unable to perform count query");
        long tookMs = this.multiSearch.tookMsFromSearchResult(searchResult);
        return CountResult.create((long)searchResult.getTotal(), (long)tookMs);
    }

    public ScrollResult scroll(Set<String> indexWildcards, Sorting sorting, String filter, String query, TimeRange range, int limit, int offset, List<String> fields) {
        return this.scroll(ScrollCommand.builder().indices(indexWildcards).sorting(sorting).filter(filter).query(query).range(range).limit(limit).offset(offset).fields(fields).build());
    }

    public ScrollResult scroll(ScrollCommand scrollCommand) {
        String searchQuery = this.buildSearchRequest(scrollCommand).toString();
        Search.Builder initialSearchBuilder = this.scrollBuilder(searchQuery, scrollCommand.indices(), scrollCommand.batchSize().orElse(-1L));
        scrollCommand.fields().forEach(initialSearchBuilder::addSourceIncludePattern);
        return this.scroll.scroll(initialSearchBuilder.build(), () -> "Unable to perform scroll search", searchQuery, DEFAULT_SCROLLTIME, scrollCommand.fields(), scrollCommand.limit().orElse(-1));
    }

    public ScrollResult scroll(Set<String> indexWildcards, Sorting sorting, String filter, String query, int batchSize) {
        return this.scroll(ScrollCommand.builder().indices(indexWildcards).sorting(sorting).filter(filter).query(query).batchSize(batchSize).build());
    }

    private Search.Builder scrollBuilder(String query, Set<String> indices, long batchSize) {
        return (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(query).addType("message")).setParameter("scroll", DEFAULT_SCROLLTIME)).setParameter("size", batchSize)).addIndex(indices);
    }

    public org.graylog2.indexer.results.SearchResult search(Set<String> indices, Set<IndexRange> indexRanges, SearchesConfig config) {
        SearchSourceBuilder requestBuilder = this.searchRequest(config);
        if (indexRanges.isEmpty()) {
            return org.graylog2.indexer.results.SearchResult.empty((String)config.query(), (String)requestBuilder.toString());
        }
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)new Search.Builder(requestBuilder.toString()).addType("message")).addIndex(indices);
        SearchResult searchResult = this.multiSearch.wrap(searchBuilder.build(), () -> "Unable to perform search query");
        List hits = searchResult.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource((String)hit.id, (String)hit.index, (Map)((Map)hit.source), hit.highlight)).collect(Collectors.toList());
        return new org.graylog2.indexer.results.SearchResult(hits, searchResult.getTotal().longValue(), indexRanges, config.query(), requestBuilder.toString(), this.multiSearch.tookMsFromSearchResult(searchResult));
    }

    public FieldStatsResult fieldStats(String query, String filter, TimeRange range, Set<String> indices, String field, boolean includeCardinality, boolean includeStats, boolean includeCount) {
        SearchSourceBuilder searchSourceBuilder = filter == null ? this.standardSearchRequest(query, range) : this.filteredSearchRequest(query, filter, range);
        FilterAggregationBuilder filterBuilder = AggregationBuilders.filter(AGG_FILTER, this.standardAggregationFilters(range, filter));
        if (includeCount) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.count(AGG_VALUE_COUNT).field(field));
        }
        if (includeStats) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.extendedStats(AGG_EXTENDED_STATS).field(field));
        }
        if (includeCardinality) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.cardinality(AGG_CARDINALITY).field(field));
        }
        searchSourceBuilder.aggregation(filterBuilder);
        if (indices.isEmpty()) {
            return FieldStatsResult.empty((String)query, (String)searchSourceBuilder.toString());
        }
        Search searchRequest = ((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(indices)).build();
        SearchResult searchResponse = this.multiSearch.wrap(searchRequest, () -> "Unable to retrieve fields stats");
        List<ResultMessage> hits = searchResponse.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource((String)hit.id, (String)hit.index, (Map)((Map)hit.source))).collect(Collectors.toList());
        ExtendedStatsAggregation extendedStatsAggregation = searchResponse.getAggregations().getExtendedStatsAggregation(AGG_EXTENDED_STATS);
        ValueCountAggregation valueCountAggregation = searchResponse.getAggregations().getValueCountAggregation(AGG_VALUE_COUNT);
        CardinalityAggregation cardinalityAggregation = searchResponse.getAggregations().getCardinalityAggregation(AGG_CARDINALITY);
        return this.createFieldStatsResult(valueCountAggregation, extendedStatsAggregation, cardinalityAggregation, hits, query, searchSourceBuilder.toString(), this.multiSearch.tookMsFromSearchResult(searchResponse));
    }

    @VisibleForTesting
    FieldStatsResult createFieldStatsResult(ValueCountAggregation valueCountAggregation, ExtendedStatsAggregation extendedStatsAggregation, CardinalityAggregation cardinalityAggregation, List<ResultMessage> hits, String query, String builtQuery, long tookMs) {
        double stdDeviation;
        double variance;
        double max;
        double min;
        double mean;
        double sumOfSquares;
        double sum;
        long cardinality;
        long count = this.valueCountFromFieldStatsResults(valueCountAggregation, extendedStatsAggregation);
        long l = cardinality = cardinalityAggregation == null || cardinalityAggregation.getCardinality() == null ? Long.MIN_VALUE : cardinalityAggregation.getCardinality();
        if (extendedStatsAggregation != null) {
            sum = extendedStatsAggregation.getSum() != null ? extendedStatsAggregation.getSum() : Double.NaN;
            sumOfSquares = extendedStatsAggregation.getSumOfSquares() != null ? extendedStatsAggregation.getSumOfSquares() : Double.NaN;
            mean = extendedStatsAggregation.getAvg() != null ? extendedStatsAggregation.getAvg() : Double.NaN;
            min = extendedStatsAggregation.getMin() != null ? extendedStatsAggregation.getMin() : Double.NaN;
            max = extendedStatsAggregation.getMax() != null ? extendedStatsAggregation.getMax() : Double.NaN;
            variance = extendedStatsAggregation.getVariance() != null ? extendedStatsAggregation.getVariance() : Double.NaN;
            stdDeviation = extendedStatsAggregation.getStdDeviation() != null ? extendedStatsAggregation.getStdDeviation() : Double.NaN;
        } else {
            sum = Double.NaN;
            sumOfSquares = Double.NaN;
            mean = Double.NaN;
            min = Double.NaN;
            max = Double.NaN;
            variance = Double.NaN;
            stdDeviation = Double.NaN;
        }
        return FieldStatsResult.create((long)count, (double)sum, (double)sumOfSquares, (double)mean, (double)min, (double)max, (double)variance, (double)stdDeviation, (long)cardinality, hits, (String)query, (String)builtQuery, (long)tookMs);
    }

    private long valueCountFromFieldStatsResults(ValueCountAggregation valueCountAggregation, ExtendedStatsAggregation extendedStatsAggregation) {
        if (valueCountAggregation != null && valueCountAggregation.getValueCount() != null) {
            return valueCountAggregation.getValueCount();
        }
        if (extendedStatsAggregation != null && extendedStatsAggregation.getCount() != null) {
            return extendedStatsAggregation.getCount();
        }
        return Long.MIN_VALUE;
    }

    private QueryBuilder standardAggregationFilters(TimeRange range, String filter) {
        QueryBuilder filterBuilder = this.standardFilters(range, filter);
        if (filterBuilder == null) {
            throw new RuntimeException("Either range or filter must be set.");
        }
        return filterBuilder;
    }

    private SearchSourceBuilder searchRequest(SearchesConfig config) {
        SearchSourceBuilder request = config.filter() == null ? this.standardSearchRequest(config.query(), config.limit(), config.offset(), config.range(), config.sorting()) : this.filteredSearchRequest(config.query(), config.filter(), config.limit(), config.offset(), config.range(), config.sorting());
        List fields = config.fields();
        if (fields != null) {
            request.fetchSource(fields.toArray(new String[0]), org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings.EMPTY_ARRAY);
        }
        return request;
    }

    private SearchSourceBuilder standardSearchRequest(String query, TimeRange range) {
        return this.standardSearchRequest(query, 0, 0, range, null);
    }

    private SearchSourceBuilder standardSearchRequest(String query, int limit, int offset, TimeRange range, Sorting sort) {
        return this.standardSearchRequest(query, limit, offset, range, sort, true);
    }

    private SearchSourceBuilder standardSearchRequest(String query, int limit, int offset, TimeRange range, Sorting sort, boolean highlight) {
        return this.standardSearchRequest(query, limit, offset, range, null, sort, highlight);
    }

    private SearchSourceBuilder standardSearchRequest(String query, int limit, int offset, TimeRange range, String filter, Sorting sort, boolean highlight) {
        if (query == null || query.trim().isEmpty()) {
            query = "*";
        }
        AbstractQueryBuilder queryBuilder = "*".equals(query.trim()) ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(query).allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(QueryBuilders.boolQuery().must(queryBuilder).filter(this.standardFilters(range, filter)));
        if (offset >= 0) {
            searchSourceBuilder.from(offset);
        }
        if (limit > 0) {
            searchSourceBuilder.size(limit);
        }
        if (sort != null) {
            searchSourceBuilder.sort(sort.getField(), this.sortOrderMapper.fromSorting(sort));
        }
        if (highlight && this.configuration.isAllowHighlighting()) {
            HighlightBuilder highlightBuilder = (HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().requireFieldMatch(false)).field("*").fragmentSize(0)).numOfFragments(0);
            searchSourceBuilder.highlighter(highlightBuilder);
        }
        return searchSourceBuilder;
    }

    private SearchSourceBuilder buildSearchRequest(ScrollCommand scrollCommand) {
        String query = this.normalizeQuery(scrollCommand.query());
        MatchAllQueryBuilder queryBuilder = this.isWildcardQuery(query) ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(query).allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        Optional<BoolQueryBuilder> rangeQueryBuilder = scrollCommand.range().map(range -> QueryBuilders.boolQuery().must(TimeRangeQueryFactory.create(range)));
        Optional<BoolQueryBuilder> filterQueryBuilder = scrollCommand.filter().filter(filter -> !this.isWildcardQuery((String)filter)).map(QueryBuilders::queryStringQuery).map(filter -> rangeQueryBuilder.orElse(QueryBuilders.boolQuery()).must((QueryBuilder)filter));
        BoolQueryBuilder filteredQueryBuilder = QueryBuilders.boolQuery().must(queryBuilder);
        filterQueryBuilder.ifPresent(filteredQueryBuilder::filter);
        this.applyStreamsFilter(filteredQueryBuilder, scrollCommand);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(filteredQueryBuilder);
        this.applyPaginationIfPresent(searchSourceBuilder, scrollCommand);
        this.applySortingIfPresent(searchSourceBuilder, scrollCommand);
        this.applyHighlighting(searchSourceBuilder, scrollCommand);
        return searchSourceBuilder;
    }

    private void applyStreamsFilter(BoolQueryBuilder filteredQueryBuilder, ScrollCommand scrollCommand) {
        scrollCommand.streams().map(this::buildStreamIdFilter).ifPresent(filteredQueryBuilder::filter);
    }

    private BoolQueryBuilder buildStreamIdFilter(Set<String> streams) {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        if (streams.contains("000000000000000000000001")) {
            filterBuilder.should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("streams")));
        }
        filterBuilder.should(QueryBuilders.termsQuery("streams", streams));
        return filterBuilder;
    }

    private void applyPaginationIfPresent(SearchSourceBuilder searchSourceBuilder, ScrollCommand scrollCommand) {
        scrollCommand.offset().ifPresent(searchSourceBuilder::from);
        scrollCommand.limit().ifPresent(searchSourceBuilder::size);
    }

    private void applyHighlighting(SearchSourceBuilder searchSourceBuilder, ScrollCommand scrollCommand) {
        if (scrollCommand.highlight() && this.configuration.isAllowHighlighting()) {
            HighlightBuilder highlightBuilder = (HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().requireFieldMatch(false)).field("*").fragmentSize(0)).numOfFragments(0);
            searchSourceBuilder.highlighter(highlightBuilder);
        }
    }

    private void applySortingIfPresent(SearchSourceBuilder searchSourceBuilder, ScrollCommand scrollCommand) {
        Sorting sort = scrollCommand.sorting().orElse(DEFAULT_SORTING);
        searchSourceBuilder.sort(sort.getField(), this.sortOrderMapper.fromSorting(sort));
    }

    private boolean isWildcardQuery(String filter) {
        return this.normalizeQuery(filter).equals("*");
    }

    private String normalizeQuery(String query) {
        if (query == null || query.trim().isEmpty()) {
            return "*";
        }
        return query.trim();
    }

    private SearchSourceBuilder filteredSearchRequest(String query, String filter, TimeRange range) {
        return this.filteredSearchRequest(query, filter, 0, 0, range, null);
    }

    private SearchSourceBuilder filteredSearchRequest(String query, String filter, int limit, int offset, TimeRange range, Sorting sort) {
        return this.standardSearchRequest(query, limit, offset, range, filter, sort, true);
    }

    @Nullable
    private QueryBuilder standardFilters(TimeRange range, String filter) {
        BoolQueryBuilder bfb = null;
        if (range != null) {
            bfb = QueryBuilders.boolQuery().must(TimeRangeQueryFactory.create(range));
        }
        if (!Strings.isNullOrEmpty((String)filter) && !"*".equals(filter)) {
            if (bfb == null) {
                bfb = QueryBuilders.boolQuery();
            }
            bfb.must(QueryBuilders.queryStringQuery(filter));
        }
        return bfb;
    }
}

