/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.sphinx;

import com.typesafe.sbt.sphinx.CommandLineSphinxRunner$;
import com.typesafe.sbt.sphinx.SphinxInputs;
import com.typesafe.sbt.sphinx.SphinxRunner;
import java.io.File;
import sbt.ChangeReport;
import sbt.FileFilter;
import sbt.FileFunction$;
import sbt.FilesInfo$;
import sbt.IO$;
import sbt.Logger;
import sbt.Process$;
import sbt.ProcessLogger;
import sbt.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\u0001\u0003\u0001\tQ!aF\"p[6\fg\u000e\u001a'j]\u0016\u001c\u0006\u000f[5oqJ+hN\\3s\u0015\t\u0019A!\u0001\u0004ta\"Lg\u000e\u001f\u0006\u0003\u000b\u0019\t1a\u001d2u\u0015\t9\u0001\"\u0001\u0005usB,7/\u00194f\u0015\u0005I\u0011aA2p[N\u0019\u0001aC\t\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\t\u00112#D\u0001\u0003\u0013\t!\"A\u0001\u0007Ta\"Lg\u000e\u001f*v]:,'\u000fC\u0003\u0017\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGOP\u0002\u0001)\u0005I\u0002C\u0001\n\u0001\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u00039Ign\u001d;bY2\u0004\u0016mY6bO\u0016$B!\b\u0016-]A\u0011ad\n\b\u0003?\u0011r!\u0001I\u0012\u000e\u0003\u0005R!AI\f\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0013'\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!B\u0005\u0003Q%\u0012AAR5mK*\u0011QE\n\u0005\u0006Wi\u0001\r!H\u0001\u0004gJ\u001c\u0007\"B\u0017\u001b\u0001\u0004i\u0012A\u0002;be\u001e,G\u000fC\u000305\u0001\u0007\u0001'A\u0002m_\u001e\u0004\"!\r\u001a\u000e\u0003\u0019J!a\r\u0014\u0003\r1{wmZ3s\u0011\u0015)\u0004\u0001\"\u00017\u000319WM\\3sCR,\u0007\n^7m)\u0015ir\u0007P\u001f@\u0011\u0015AD\u00071\u0001:\u0003\u0019Ig\u000e];ugB\u0011!CO\u0005\u0003w\t\u0011Ab\u00159iS:D\u0018J\u001c9viNDQ!\f\u001bA\u0002uAQA\u0010\u001bA\u0002u\t\u0001bY1dQ\u0016$\u0015N\u001d\u0005\u0006_Q\u0002\r\u0001\r\u0005\u0006\u0003\u0002!\tAQ\u0001\fO\u0016tWM]1uKB#g\rF\u0003D\u00172ke\nE\u0002E\u0011vq!!R$\u000f\u0005\u00012\u0015\"\u0001\b\n\u0005\u0015j\u0011BA%K\u0005\r\u0019V-\u001d\u0006\u0003K5AQ\u0001\u000f!A\u0002eBQ!\f!A\u0002uAQA\u0010!A\u0002uAQa\f!A\u0002ABQ\u0001\u0015\u0001\u0005\u0002E\u000bAbZ3oKJ\fG/Z#qk\n$R!\b*T)VCQ\u0001O(A\u0002eBQ!L(A\u0002uAQAP(A\u0002uAQaL(A\u0002ABQa\u0016\u0001\u0005\na\u000b1\"Z1ts&s7\u000f^1mYR!Q$\u0017.]\u0011\u0015Yc\u000b1\u0001\u001e\u0011\u0015Yf\u000b1\u0001\u001e\u0003)\u0011\u0017m]3UCJ<W\r\u001e\u0005\u0006_Y\u0003\r\u0001\r\u0005\u0006=\u0002!IaX\u0001\fgBD\u0017N\u001c=Ck&dG\r\u0006\b\u001eA&Tw.\u001d:tqn\f\t!!\u0002\t\u000b\u0005l\u0006\u0019\u00012\u0002\u000f\t,\u0018\u000e\u001c3feB\u00111M\u001a\b\u0003\u0019\u0011L!!Z\u0007\u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003K6AQaK/A\u0002uAQa[/A\u00021\fq!\u001b8dYV$W\r\u0005\u00022[&\u0011aN\n\u0002\u000b\r&dWMR5mi\u0016\u0014\b\"\u00029^\u0001\u0004a\u0017aB3yG2,H-\u001a\u0005\u00067v\u0003\r!\b\u0005\u0006}u\u0003\r!\b\u0005\u0006iv\u0003\r!^\u0001\fS:\u001c'/Z7f]R\fG\u000e\u0005\u0002\rm&\u0011q/\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015IX\f1\u0001{\u0003\u0011!\u0018mZ:\u0011\u0007\u0011C%\rC\u0003};\u0002\u0007Q0\u0001\u0006qe>\u0004XM\u001d;jKN\u0004Ba\u0019@cE&\u0011q\u0010\u001b\u0002\u0004\u001b\u0006\u0004\bBBA\u0002;\u0002\u0007Q0A\u0002f]ZDQaL/A\u0002ABq!!\u0003\u0001\t\u0013\tY!A\u0004nC.,\u0007\u000b\u001a4\u0015\u000b\r\u000bi!!\u0005\t\u000f\u0005=\u0011q\u0001a\u0001;\u0005IA.\u0019;fq\n\u000b7/\u001a\u0005\u0007_\u0005\u001d\u0001\u0019\u0001\u0019\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\u0005a1\u000f\u001d5j]bdunZ4feR!\u0011\u0011DA\u001b%\u0015\tYbCA\u0010\r\u001d\ti\"a\u0005\u0001\u00033\u0011A\u0002\u0010:fM&tW-\\3oiz\u00022!MA\u0011\u0013\r\t\u0019C\n\u0002\u000e!J|7-Z:t\u0019><w-\u001a:\t\u0011\u0005\u001d\u00121\u0004C\u0001\u0003S\t\u0001B]3eSJ,7\r\u001e\u000b\u0005\u0003W\t\t\u0004E\u0002\r\u0003[I1!a\f\u000e\u0005\u0011)f.\u001b;\t\u000f\u0005M\u0012Q\u0005a\u0001E\u00069Q.Z:tC\u001e,\u0007BB\u0018\u0002\u0014\u0001\u0007\u0001\u0007")
public class CommandLineSphinxRunner
implements SphinxRunner {
    @Override
    public File installPackage(File src, File target, Logger log) {
        return this.easyInstall(src, target, log);
    }

    @Override
    public File generateHtml(SphinxInputs inputs, File target, File cacheDir, Logger log) {
        return this.sphinxBuild("html", inputs.src(), inputs.include(), inputs.exclude(), target, cacheDir, inputs.incremental(), inputs.tags(), inputs.properties(), inputs.env(), log);
    }

    @Override
    public Seq<File> generatePdf(SphinxInputs inputs, File target, File cacheDir, Logger log) {
        File latexOutput = this.sphinxBuild("latex", inputs.src(), inputs.include(), inputs.exclude(), target, cacheDir, inputs.incremental(), inputs.tags(), inputs.properties(), inputs.env(), log);
        return this.makePdf(latexOutput, log);
    }

    @Override
    public File generateEpub(SphinxInputs inputs, File target, File cacheDir, Logger log) {
        return this.sphinxBuild("epub", inputs.src(), inputs.include(), inputs.exclude(), target, cacheDir, inputs.incremental(), inputs.tags(), inputs.properties(), inputs.env(), log);
    }

    private File easyInstall(File src, File baseTarget, Logger log) {
        Object object;
        String name = src.getName();
        File target = package$.MODULE$.richFile(package$.MODULE$.richFile(baseTarget).$div("packages")).$div(name);
        boolean empty = package$.MODULE$.singleFileFinder(target).$times((FileFilter)package$.MODULE$.globFilter("*.egg")).get().isEmpty();
        if (empty) {
            log.info((Function0)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Installing Sphinx custom package '%s'...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
            object = IO$.MODULE$.withTemporaryDirectory((Function1)new Serializable(this, src, log, target){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CommandLineSphinxRunner $outer;
                private final File src$1;
                private final Logger log$1;
                public final File target$1;

                public final void apply(File tmp) {
                    IO$.MODULE$.copyDirectory(this.src$1, tmp, IO$.MODULE$.copyDirectory$default$3(), IO$.MODULE$.copyDirectory$default$4());
                    this.target$1.mkdirs();
                    ProcessLogger logger = this.$outer.com$typesafe$sbt$sphinx$CommandLineSphinxRunner$$sphinxLogger(this.log$1);
                    Seq command = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"easy_install", "--install-dir", package$.MODULE$.richFile(this.target$1).absolutePath(), package$.MODULE$.richFile(tmp).absolutePath()}));
                    Tuple2 env = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"PYTHONPATH"), (Object)package$.MODULE$.richFile(this.target$1).absolutePath());
                    this.log$1.debug((Function0)new Serializable(this, command){
                        public static final long serialVersionUID = 0L;
                        private final Seq command$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Command: ").append((Object)this.command$1.mkString(" ")).toString();
                        }
                        {
                            this.command$1 = command$1;
                        }
                    });
                    this.log$1.debug((Function0)new Serializable(this, env){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2 env$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Environment: ").append((Object)this.env$2).toString();
                        }
                        {
                            this.env$2 = env$2;
                        }
                    });
                    int exitCode = Process$.MODULE$.apply(command, tmp, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{env})).$bang(logger);
                    if (exitCode != 0) {
                        throw scala.sys.package$.MODULE$.error("Failed to install Sphinx custom package");
                    }
                    this.log$1.info((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$easyInstall$2 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Sphinx custom package installed: ").append((Object)this.$outer.target$1).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.src$1 = src$1;
                    this.log$1 = log$1;
                    this.target$1 = target$1;
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return target;
    }

    private File sphinxBuild(String builder, File src, FileFilter include, FileFilter exclude, File baseTarget, File cacheDir, boolean incremental, Seq<String> tags, Map<String, String> properties, Map<String, String> env, Logger log) {
        File target = package$.MODULE$.richFile(baseTarget).$div(builder);
        File doctrees = package$.MODULE$.richFile(package$.MODULE$.richFile(baseTarget).$div("doctrees")).$div(builder);
        File cache = package$.MODULE$.richFile(package$.MODULE$.richFile(cacheDir).$div("sphinx")).$div(builder);
        Function1 cached = FileFunction$.MODULE$.cached(cache, FilesInfo$.MODULE$.hash(), FilesInfo$.MODULE$.exists(), (Function2)new Serializable(this, builder, src, incremental, tags, properties, env, log, target, doctrees){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CommandLineSphinxRunner $outer;
            private final String builder$1;
            private final File src$2;
            private final boolean incremental$1;
            private final Seq tags$1;
            private final Map properties$1;
            public final Map env$1;
            private final Logger log$2;
            public final File target$2;
            private final File doctrees$1;

            public final Set<File> apply(ChangeReport<File> in, ChangeReport<File> out) {
                Set set;
                Set changes = in.modified();
                if (changes.nonEmpty()) {
                    String tagList = this.tags$1.isEmpty() ? "" : this.tags$1.mkString(" (", ", ", ")");
                    String desc = new StringOps(Predef$.MODULE$.augmentString("%s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.builder$1, tagList}));
                    this.log$2.info((Function0)new Serializable(this, desc){
                        public static final long serialVersionUID = 0L;
                        private final String desc$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Generating Sphinx %s documentation...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.desc$1}));
                        }
                        {
                            this.desc$1 = desc$1;
                        }
                    });
                    if (!this.incremental$1) {
                        IO$.MODULE$.delete(this.target$2);
                    }
                    ProcessLogger logger = this.$outer.com$typesafe$sbt$sphinx$CommandLineSphinxRunner$$sphinxLogger(this.log$2);
                    Seq buildOptions = this.incremental$1 ? (Seq)Seq$.MODULE$.empty() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-a", "-E"}));
                    Seq colourOptions = this.log$2.ansiCodesSupported() ? (Seq)Seq$.MODULE$.empty() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-N"}));
                    Seq tagOptions = (Seq)this.tags$1.flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<String> apply(String x$1) {
                            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-t", x$1}));
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq propertyOptions = ((TraversableOnce)this.properties$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, String> x0$1) {
                            Tuple2<String, String> tuple2 = x0$1;
                            if (tuple2 != null) {
                                String k = (String)tuple2._1();
                                String v = (String)tuple2._2();
                                String string = new StringOps(Predef$.MODULE$.augmentString("-D%s=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                    Seq command = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sphinx-build"}))).$plus$plus((GenTraversableOnce)buildOptions, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)colourOptions, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-b", this.builder$1, "-d", package$.MODULE$.richFile(this.doctrees$1).absolutePath()})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)tagOptions, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)propertyOptions, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$.MODULE$.richFile(this.src$2).absolutePath(), package$.MODULE$.richFile(this.target$2).absolutePath()})), Seq$.MODULE$.canBuildFrom());
                    this.log$2.debug((Function0)new Serializable(this, command){
                        public static final long serialVersionUID = 0L;
                        private final Seq command$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Command: ").append((Object)this.command$2.mkString(" ")).toString();
                        }
                        {
                            this.command$2 = command$2;
                        }
                    });
                    this.log$2.debug((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Environment: ").append((Object)this.$outer.env$1).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    int exitCode = Process$.MODULE$.apply(command, this.src$2, this.env$1.toSeq()).$bang(logger);
                    if (exitCode != 0) {
                        throw scala.sys.package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Failed to build Sphinx %s documentation.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                    }
                    this.log$2.info((Function0)new Serializable(this, desc){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;
                        private final String desc$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Sphinx %s documentation generated: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.desc$1, this.$outer.target$2}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.desc$1 = desc$1;
                        }
                    });
                    set = package$.MODULE$.singleFileFinder(this.target$2).$times$times$times().get().toSet();
                } else {
                    set = Predef$.MODULE$.Set().empty();
                }
                return set;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.builder$1 = builder$1;
                this.src$2 = src$2;
                this.incremental$1 = incremental$1;
                this.tags$1 = tags$1;
                this.properties$1 = properties$1;
                this.env$1 = env$1;
                this.log$2 = log$2;
                this.target$2 = target$2;
                this.doctrees$1 = doctrees$1;
            }
        });
        Set inputs = package$.MODULE$.singleFileFinder(src).descendantsExcept(include, exclude).get().toSet();
        cached.apply((Object)inputs);
        return target;
    }

    private Seq<File> makePdf(File latexBase, Logger log) {
        Seq pdfFiles;
        Seq texFiles = package$.MODULE$.singleFileFinder(latexBase).$times((FileFilter)package$.MODULE$.globFilter("*.tex")).get();
        boolean outofdate = Tuple2Zipped$.MODULE$.exists$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)texFiles, (Object)(pdfFiles = (Seq)texFiles.map((Function1)new Serializable(this, latexBase){
            public static final long serialVersionUID = 0L;
            private final File latexBase$1;

            public final File apply(File tex) {
                Tuple2 tuple2 = package$.MODULE$.richFile(tex).baseAndExt();
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String base = (String)tuple2._1();
                    String ext = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)base, (Object)ext);
                    String base2 = (String)tuple23._1();
                    String ext2 = (String)tuple23._2();
                    return package$.MODULE$.richFile(this.latexBase$1).$div(new StringBuilder().append((Object)base2).append((Object)".pdf").toString());
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.latexBase$1 = latexBase$1;
            }
        }, Seq$.MODULE$.canBuildFrom())))), (Function1)Predef$.MODULE$.conforms(), (Function1)Predef$.MODULE$.conforms()), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x0$2, File x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$1);
                if (tuple2 != null) {
                    File tex = (File)tuple2._1();
                    File pdf = (File)tuple2._2();
                    boolean bl = tex.lastModified() > pdf.lastModified();
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
        });
        if (outofdate) {
            log.info((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Generating Sphinx pdf documentation...";
                }
            });
            ProcessLogger logger = this.com$typesafe$sbt$sphinx$CommandLineSphinxRunner$$sphinxLogger(log);
            int exitCode = Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make", "all-pdf"})), latexBase, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(logger);
            if (exitCode != 0) {
                throw scala.sys.package$.MODULE$.error("Sphinx pdf generation failed.  See debug output for details.");
            }
            log.info((Function0)new Serializable(this, pdfFiles){
                public static final long serialVersionUID = 0L;
                private final Seq pdfFiles$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sphinx pdf documentation generated:\n\t%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pdfFiles$1.mkString("\n\t")}));
                }
                {
                    this.pdfFiles$1 = pdfFiles$1;
                }
            });
        }
        return pdfFiles;
    }

    public ProcessLogger com$typesafe$sbt$sphinx$CommandLineSphinxRunner$$sphinxLogger(Logger log) {
        return new ProcessLogger(this, log){
            private final Logger log$3;

            public void info(Function0<String> i) {
                this.redirect((String)i.apply());
            }

            public void error(Function0<String> e) {
                this.redirect((String)e.apply());
            }

            public <T> T buffer(Function0<T> f) {
                return (T)f.apply();
            }

            public void redirect(String message) {
                if (message.contains("ERROR")) {
                    this.log$3.error((Function0)new Serializable(this, message){
                        public static final long serialVersionUID = 0L;
                        private final String message$1;

                        public final String apply() {
                            return this.message$1;
                        }
                        {
                            this.message$1 = message$1;
                        }
                    });
                } else if (message.contains("WARNING")) {
                    this.log$3.warn((Function0)new Serializable(this, message){
                        public static final long serialVersionUID = 0L;
                        private final String message$1;

                        public final String apply() {
                            return this.message$1;
                        }
                        {
                            this.message$1 = message$1;
                        }
                    });
                } else {
                    this.log$3.debug((Function0)new Serializable(this, message){
                        public static final long serialVersionUID = 0L;
                        private final String message$1;

                        public final String apply() {
                            return this.message$1;
                        }
                        {
                            this.message$1 = message$1;
                        }
                    });
                }
            }
            {
                this.log$3 = log$3;
            }
        };
    }
}

