/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.BlockImpl;
import org.asciidoctor.ast.DocumentRuby;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.SectionImpl;
import org.asciidoctor.internal.RubyHashUtil;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.runtime.builtin.IRubyObject;

public class AbstractBlockImpl
implements AbstractBlock {
    private static final String BLOCK_CLASS = "Block";
    private static final String SECTION_CLASS = "Section";
    protected AbstractBlock delegate;
    protected Ruby runtime;

    public AbstractBlockImpl(AbstractBlock blockDelegate, Ruby runtime) {
        this.delegate = blockDelegate;
        this.runtime = runtime;
    }

    @Override
    public String id() {
        return this.delegate.id();
    }

    @Override
    public String title() {
        return this.delegate.title();
    }

    @Override
    public String role() {
        return this.delegate.role();
    }

    @Override
    public String style() {
        return this.delegate.style();
    }

    @Override
    public List<AbstractBlock> blocks() {
        List<AbstractBlock> rubyBlocks = this.delegate.blocks();
        for (int i = 0; i < rubyBlocks.size(); ++i) {
            AbstractBlock abstractBlock = rubyBlocks.get(i);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof Block) continue;
            RubyObject rubyObject = (RubyObject)abstractBlock;
            rubyBlocks.set(i, this.overrideRubyObjectToJavaObject(rubyObject));
        }
        return rubyBlocks;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.delegate.attributes();
    }

    @Override
    public Object content() {
        return this.delegate.content();
    }

    @Override
    public String convert() {
        return this.delegate.convert();
    }

    @Override
    public String context() {
        return this.delegate.context();
    }

    @Override
    public AbstractBlock delegate() {
        return this.delegate;
    }

    @Override
    public DocumentRuby document() {
        return this.delegate.document();
    }

    @Override
    public List<AbstractBlock> findBy(Map<Object, Object> selector) {
        List<AbstractBlock> findBy = this.delegate.findBy((Map<Object, Object>)RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(this.runtime, selector));
        for (int i = 0; i < findBy.size(); ++i) {
            AbstractBlock abstractBlock = findBy.get(i);
            if (abstractBlock instanceof RubyArray || abstractBlock instanceof AbstractBlock) continue;
            RubyObject rubyObject = (RubyObject)abstractBlock;
            findBy.set(i, this.overrideRubyObjectToJavaObject(rubyObject));
        }
        return findBy;
    }

    private AbstractBlock overrideRubyObjectToJavaObject(RubyObject rubyObject) {
        if (BLOCK_CLASS.equals(rubyObject.getMetaClass().getBaseName())) {
            Block blockRuby = RubyUtils.rubyToJava(this.runtime, (IRubyObject)rubyObject, Block.class);
            return new BlockImpl(blockRuby, this.runtime);
        }
        if (SECTION_CLASS.equals(rubyObject.getMetaClass().getBaseName())) {
            Section blockRuby = RubyUtils.rubyToJava(this.runtime, (IRubyObject)rubyObject, Section.class);
            return new SectionImpl(blockRuby, this.runtime);
        }
        AbstractBlock blockRuby = RubyUtils.rubyToJava(this.runtime, (IRubyObject)rubyObject, AbstractBlock.class);
        return new AbstractBlockImpl(blockRuby, this.runtime);
    }
}

