/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.Counter;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.ruby19.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ruby20.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ruby20.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockNoResultCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.IRStaticScope;
import org.jruby.parser.IRStaticScopeFactory;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Interpreter {
    private static IRCallSite callerSite = new IRCallSite();
    private static final Logger LOG = LoggerFactory.getLogger("Interpreter");
    private static int versionCount = 1;
    private static HashMap<IRScope, Integer> scopeVersionMap = new HashMap();
    private static int inlineCount = 0;
    private static int interpInstrsCount = 0;
    private static int codeModificationsCount = 0;
    private static int numCyclesWithNoModifications = 0;
    private static int globalThreadPollCount = 0;
    private static HashMap<IRScope, Counter> scopeThreadPollCounts = new HashMap();
    private static HashMap<Long, CallSiteProfile> callProfile = new HashMap();
    private static HashMap<Operation, Counter> opStats = new HashMap();

    private static IRScope getEvalContainerScope(Ruby runtime, StaticScope evalScope) {
        IRScope containingIRScope = ((IRStaticScope)evalScope.getEnclosingScope()).getIRScope();
        if (containingIRScope == null) {
            containingIRScope = ((IRStaticScope)evalScope.getEnclosingScope().getEnclosingScope()).getIRScope();
        }
        return containingIRScope;
    }

    public static IRubyObject interpretCommonEval(Ruby runtime, String file2, int lineNumber, String backtraceName, RootNode rootNode, IRubyObject self2, Block block) {
        boolean is_1_9 = runtime.is1_9();
        if (is_1_9) {
            IRBuilder.setRubyVersion("1.9");
        }
        StaticScope ss = rootNode.getStaticScope();
        IRScope containingIRScope = Interpreter.getEvalContainerScope(runtime, ss);
        IREvalScript evalScript = IRBuilder.createIRBuilder(runtime, runtime.getIRManager()).buildEvalRoot(ss, containingIRScope, file2, lineNumber, rootNode);
        evalScript.prepareForInterpretation(false);
        ThreadContext context = runtime.getCurrentContext();
        Interpreter.runBeginEndBlocks(evalScript.getBeginBlocks(), context, self2, null);
        IRubyObject rv = evalScript.call(context, self2, evalScript.getStaticScope().getModule(), rootNode.getScope(), block, backtraceName);
        Interpreter.runBeginEndBlocks(evalScript.getEndBlocks(), context, self2, null);
        return rv;
    }

    public static IRubyObject interpretSimpleEval(Ruby runtime, String file2, int lineNumber, String backtraceName, Node node, IRubyObject self2) {
        return Interpreter.interpretCommonEval(runtime, file2, lineNumber, backtraceName, (RootNode)node, self2, Block.NULL_BLOCK);
    }

    public static IRubyObject interpretBindingEval(Ruby runtime, String file2, int lineNumber, String backtraceName, Node node, IRubyObject self2, Block block) {
        return Interpreter.interpretCommonEval(runtime, file2, lineNumber, backtraceName, (RootNode)node, self2, block);
    }

    public static void runBeginEndBlocks(List<IRClosure> beBlocks, ThreadContext context, IRubyObject self2, Object[] temp) {
        if (beBlocks == null) {
            return;
        }
        for (IRClosure b : beBlocks) {
            b.prepareForInterpretation(false);
            Block blk = (Block)new WrappedIRClosure(b).retrieve(context, self2, context.getCurrentScope(), temp);
            blk.yield(context, null);
        }
    }

    public static IRubyObject interpret(Ruby runtime, Node rootNode, IRubyObject self2) {
        IRScriptBody root;
        if (runtime.is1_9()) {
            IRBuilder.setRubyVersion("1.9");
        }
        if ((root = (IRScriptBody)IRBuilder.createIRBuilder(runtime, runtime.getIRManager()).buildRoot((RootNode)rootNode)).getStaticScope().getModule() == null) {
            root.getStaticScope().setModule(runtime.getObject());
        }
        RubyModule currModule = root.getStaticScope().getModule();
        IRStaticScopeFactory.newIRLocalScope(null).setModule(currModule);
        ThreadContext context = runtime.getCurrentContext();
        try {
            Interpreter.runBeginEndBlocks(root.getBeginBlocks(), context, self2, null);
            InterpretedIRMethod method2 = new InterpretedIRMethod(root, currModule);
            IRubyObject rv = method2.call(context, self2, currModule, "(root)", IRubyObject.NULL_ARRAY);
            Interpreter.runBeginEndBlocks(root.getEndBlocks(), context, self2, null);
            if ((IRRuntimeHelpers.isDebug() || IRRuntimeHelpers.inProfileMode()) && interpInstrsCount > 10000) {
                LOG.info("-- Interpreted instructions: {}", interpInstrsCount);
            }
            return rv;
        }
        catch (IRBreakJump bj) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
    }

    private static void analyzeProfile() {
        ++versionCount;
        numCyclesWithNoModifications = codeModificationsCount == 0 ? ++numCyclesWithNoModifications : 0;
        codeModificationsCount = 0;
        if (numCyclesWithNoModifications < 3) {
            return;
        }
        HashMap<IRScope, Long> scopeCounts = new HashMap<IRScope, Long>();
        ArrayList<IRCallSite> callSites = new ArrayList<IRCallSite>();
        HashMap callSiteCounts = new HashMap();
        long total2 = 0L;
        for (Long id2 : callProfile.keySet()) {
            CallSite runtimeCS;
            CallSiteProfile csp = callProfile.get(id2);
            IRCallSite cs = csp.cs;
            if (cs.v != scopeVersionMap.get(cs.s)) continue;
            Set<IRScope> calledScopes = csp.counters.keySet();
            cs.count = 0L;
            for (IRScope s2 : calledScopes) {
                Long c = (Long)scopeCounts.get(s2);
                if (c == null) {
                    c = new Long(0L);
                    scopeCounts.put(s2, c);
                }
                long x = csp.counters.get((Object)s2).count;
                c = c + x;
                cs.count += x;
            }
            CallBase call2 = cs.call;
            if (calledScopes.size() == 1 && !call2.inliningBlocked() && (runtimeCS = call2.getCallSite()) != null && runtimeCS instanceof CachingCallSite) {
                CachingCallSite ccs = (CachingCallSite)runtimeCS;
                CacheEntry ce = ccs.getCache();
                if (!(ce.method instanceof InterpretedIRMethod)) continue;
                callSites.add(cs);
                cs.tgtM = (InterpretedIRMethod)ce.method;
            }
            total2 += cs.count;
        }
        Collections.sort(callSites, new Comparator<IRCallSite>(){

            @Override
            public int compare(IRCallSite a, IRCallSite b) {
                if (a.count == b.count) {
                    return 0;
                }
                return a.count < b.count ? 1 : -1;
            }
        });
        double freq = 0.0;
        int i2 = 0;
        boolean noInlining = true;
        HashSet<IRScope> inlinedScopes = new HashSet<IRScope>();
        for (IRCallSite ircs : callSites) {
            double contrib = (double)ircs.count * 100.0 / (double)total2;
            if (contrib < 1.0) break;
            if (++i2 == 100 || (freq += contrib) > 99.0) break;
            CallBase call3 = ircs.call;
            IRScope hs = ircs.s;
            boolean isHotClosure = hs instanceof IRClosure;
            IRScope hc = isHotClosure ? hs : null;
            IRScope iRScope = hs = isHotClosure ? hs.getLexicalParent() : hs;
            IRScope tgtMethod = ircs.tgtM.getIRMethod();
            Instr[] instrs = tgtMethod.getInstrsForInterpretation();
            if (instrs == null || instrs.length > 500) continue;
            RubyModule implClass = ircs.tgtM.getImplementationClass();
            int classToken = implClass.getGeneration();
            String n = tgtMethod.getName();
            boolean inlineCall = true;
            if (isHotClosure) {
                Operand clArg = call3.getClosureArg(null);
                boolean bl = inlineCall = clArg instanceof WrappedIRClosure && ((WrappedIRClosure)clArg).getClosure() == hc;
            }
            if (!inlineCall) continue;
            noInlining = false;
            long start2 = new Date().getTime();
            hs.inlineMethod(tgtMethod, implClass, classToken, null, call3);
            inlinedScopes.add(hs);
            long end2 = new Date().getTime();
            ++inlineCount;
        }
        for (IRScope x : inlinedScopes) {
            scopeVersionMap.put(x, versionCount);
        }
        codeModificationsCount = 0;
        callProfile = new HashMap();
        if (globalThreadPollCount % 1000000 == 0) {
            globalThreadPollCount = 0;
        }
    }

    private static void outputProfileStats() {
        ArrayList<IRScope> scopes = new ArrayList<IRScope>(scopeThreadPollCounts.keySet());
        Collections.sort(scopes, new Comparator<IRScope>(){

            @Override
            public int compare(IRScope a, IRScope b) {
                float bCount;
                float aCount;
                int bden;
                int aden = a.getThreadPollInstrsCount();
                if (aden == 0) {
                    aden = 1;
                }
                if ((bden = b.getThreadPollInstrsCount()) == 0) {
                    bden = 1;
                }
                if ((aCount = (float)((Counter)scopeThreadPollCounts.get((Object)a)).count * (1.0f * (float)a.getInstrsForInterpretation().length / (float)aden)) == (bCount = (float)((Counter)scopeThreadPollCounts.get((Object)b)).count * (1.0f * (float)b.getInstrsForInterpretation().length / (float)bden))) {
                    return 0;
                }
                return aCount < bCount ? 1 : -1;
            }
        });
        int i2 = 0;
        float f1 = 0.0f;
        for (IRScope s2 : scopes) {
            long n = Interpreter.scopeThreadPollCounts.get((Object)s2).count;
            float p1 = (float)(n * 1000L / (long)globalThreadPollCount) / 10.0f;
            String msg = i2 + ". " + s2 + " [file:" + s2.getFileName() + ":" + s2.getLineNumber() + "] = " + n + "; (" + p1 + "%)";
            if (s2 instanceof IRClosure) {
                IRMethod m = s2.getNearestMethod();
            }
            f1 += p1;
            if (++i2 != 20 && !((double)f1 >= 95.0)) continue;
            break;
        }
        codeModificationsCount = 0;
        if (globalThreadPollCount % 1000000 == 0) {
            scopeThreadPollCounts = new HashMap();
            globalThreadPollCount = 0;
        }
    }

    private static Integer initProfiling(IRScope scope) {
        Integer scopeVersion = scopeVersionMap.get(scope);
        if (scopeVersion == null) {
            scopeVersionMap.put(scope, versionCount);
            scopeVersion = new Integer(versionCount);
        }
        if (Interpreter.callerSite.call != null) {
            Counter csCount;
            Long id2 = Interpreter.callerSite.call.callSiteId;
            CallSiteProfile csp = callProfile.get(id2);
            if (csp == null) {
                csp = new CallSiteProfile(callerSite);
                callProfile.put(id2, csp);
            }
            if ((csCount = csp.counters.get(scope)) == null) {
                csCount = new Counter();
                csp.counters.put(scope, csCount);
            }
            ++csCount.count;
        }
        return scopeVersion;
    }

    private static void setResult(Object[] temp, DynamicScope currDynScope, Variable resultVar, Object result2) {
        if (resultVar instanceof TemporaryVariable) {
            temp[((TemporaryVariable)resultVar).offset] = result2;
        } else {
            LocalVariable lv = (LocalVariable)resultVar;
            currDynScope.setValue((IRubyObject)result2, lv.getLocation(), lv.getScopeDepth());
        }
    }

    private static void setResult(Object[] temp, DynamicScope currDynScope, Instr instr, Object result2) {
        if (instr instanceof ResultInstr) {
            Interpreter.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result2);
        }
    }

    private static Object retrieveOp(Operand r, ThreadContext context, IRubyObject self2, DynamicScope currDynScope, Object[] temp) {
        if (r instanceof Self) {
            return self2;
        }
        if (r instanceof TemporaryVariable) {
            Object res = temp[((TemporaryVariable)r).offset];
            return res == null ? context.nil : res;
        }
        if (r instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)r;
            IRubyObject res = currDynScope.getValue(lv.getLocation(), lv.getScopeDepth());
            return res == null ? context.nil : res;
        }
        return r.retrieve(context, self2, currDynScope, temp);
    }

    private static void updateCallSite(Instr instr, IRScope scope, Integer scopeVersion) {
        if (instr instanceof CallBase) {
            Interpreter.callerSite.s = scope;
            Interpreter.callerSite.v = scopeVersion;
            Interpreter.callerSite.call = (CallBase)instr;
        }
    }

    private static void receiveArg(ThreadContext context, Instr i2, Operation operation, IRubyObject[] args2, int kwArgHashCount, DynamicScope currDynScope, Object[] temp, Object exception2, Block block) {
        Object result2 = null;
        ResultInstr instr = (ResultInstr)((Object)i2);
        switch (operation) {
            case RECV_PRE_REQD_ARG: {
                int argIndex = ((ReceivePreReqdArgInstr)instr).getArgIndex();
                result2 = argIndex + kwArgHashCount < args2.length ? args2[argIndex] : context.nil;
                break;
            }
            case RECV_CLOSURE: {
                result2 = block == Block.NULL_BLOCK ? context.nil : context.runtime.newProc(Block.Type.PROC, block);
                break;
            }
            case RECV_OPT_ARG: {
                result2 = ((ReceiveOptArgInstr)instr).receiveOptArg(args2, kwArgHashCount);
                break;
            }
            case RECV_POST_REQD_ARG: {
                result2 = ((ReceivePostReqdArgInstr)instr).receivePostReqdArg(args2, kwArgHashCount);
                result2 = result2 == null ? context.nil : result2;
                break;
            }
            case RECV_REST_ARG: {
                result2 = ((ReceiveRestArgInstr)instr).receiveRestArg(context.runtime, args2, kwArgHashCount);
                break;
            }
            case RECV_KW_ARG: {
                result2 = ((ReceiveKeywordArgInstr)instr).receiveKWArg(context, kwArgHashCount, args2);
                break;
            }
            case RECV_KW_REST_ARG: {
                result2 = ((ReceiveKeywordRestArgInstr)instr).receiveKWArg(context, kwArgHashCount, args2);
                break;
            }
            case RECV_EXCEPTION: {
                ReceiveExceptionInstr rei = (ReceiveExceptionInstr)instr;
                result2 = exception2 instanceof RaiseException && rei.checkType ? ((RaiseException)exception2).getException() : exception2;
                break;
            }
        }
        Interpreter.setResult(temp, currDynScope, instr.getResult(), result2);
    }

    private static void processCall(ThreadContext context, Instr instr, Operation operation, IRScope scope, DynamicScope currDynScope, Object[] temp, IRubyObject self2, Block block, Block.Type blockType) {
        Object result2 = null;
        switch (operation) {
            case RUNTIME_HELPER: {
                RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                result2 = rhc.callHelper(context, currDynScope, self2, temp, scope, blockType);
                Interpreter.setResult(temp, currDynScope, rhc.getResult(), result2);
                break;
            }
            case CALL_1F: {
                OneFixnumArgNoBlockCallInstr call2 = (OneFixnumArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call2.getReceiver(), context, self2, currDynScope, temp);
                result2 = call2.getCallSite().call(context, self2, r, call2.getFixnumArg());
                Interpreter.setResult(temp, currDynScope, call2.getResult(), result2);
                break;
            }
            case CALL_1O: {
                OneOperandArgNoBlockCallInstr call3 = (OneOperandArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call3.getReceiver(), context, self2, currDynScope, temp);
                IRubyObject o = (IRubyObject)call3.getArg1().retrieve(context, self2, currDynScope, temp);
                result2 = call3.getCallSite().call(context, self2, r, o);
                Interpreter.setResult(temp, currDynScope, call3.getResult(), result2);
                break;
            }
            case CALL_0O: {
                ZeroOperandArgNoBlockCallInstr call4 = (ZeroOperandArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call4.getReceiver(), context, self2, currDynScope, temp);
                result2 = call4.getCallSite().call(context, self2, r);
                Interpreter.setResult(temp, currDynScope, call4.getResult(), result2);
                break;
            }
            case NORESULT_CALL_1O: {
                OneOperandArgNoBlockNoResultCallInstr call5 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call5.getReceiver(), context, self2, currDynScope, temp);
                IRubyObject o = (IRubyObject)call5.getArg1().retrieve(context, self2, currDynScope, temp);
                call5.getCallSite().call(context, self2, r, o);
                break;
            }
            case NORESULT_CALL: {
                instr.interpret(context, currDynScope, self2, temp, block);
                break;
            }
            default: {
                result2 = instr.interpret(context, currDynScope, self2, temp, block);
                Interpreter.setResult(temp, currDynScope, instr, result2);
            }
        }
    }

    private static IRubyObject interpret(ThreadContext context, IRubyObject self2, IRScope scope, Visibility visibility, RubyModule implClass, IRubyObject[] args2, Block block, Block.Type blockType) {
        int numTempVars;
        Instr[] instrs = scope.getInstrsForInterpretation();
        if (instrs == null) {
            instrs = scope.prepareForInterpretation(blockType == Block.Type.LAMBDA);
        }
        Object[] temp = (numTempVars = scope.getTemporaryVariableSize()) > 0 ? new Object[numTempVars] : null;
        int n = instrs.length;
        int ipc = 0;
        Instr instr = null;
        Throwable exception2 = null;
        int kwArgHashCount = scope.receivesKeywordArgs() && args2[args2.length - 1] instanceof RubyHash ? 1 : 0;
        DynamicScope currDynScope = context.getCurrentScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        boolean profile = IRRuntimeHelpers.inProfileMode();
        Integer scopeVersion = profile ? Interpreter.initProfiling(scope) : 0;
        while (ipc < n) {
            instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                LOG.info("I: {}", instr);
                ++interpInstrsCount;
            } else if (profile) {
                if (operation.modifiesCode()) {
                    ++codeModificationsCount;
                }
                ++interpInstrsCount;
            }
            try {
                block1 : switch (operation.opClass) {
                    case ARG_OP: {
                        Interpreter.receiveArg(context, instr, operation, args2, kwArgHashCount, currDynScope, temp, exception2, block);
                        break;
                    }
                    case BRANCH_OP: {
                        if (operation == Operation.JUMP) {
                            ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                            break;
                        }
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, self2, temp, ipc);
                        break;
                    }
                    case CALL_OP: {
                        if (profile) {
                            Interpreter.updateCallSite(instr, scope, scopeVersion);
                        }
                        Interpreter.processCall(context, instr, operation, scope, currDynScope, temp, self2, block, blockType);
                        break;
                    }
                    case BOOK_KEEPING_OP: {
                        switch (operation) {
                            case PUSH_FRAME: {
                                context.preMethodFrameAndClass(implClass, scope.getName(), self2, block, scope.getStaticScope());
                                context.setCurrentVisibility(visibility);
                                break block1;
                            }
                            case PUSH_BINDING: {
                                currDynScope = DynamicScope.newDynamicScope(scope.getStaticScope());
                                context.pushScope(currDynScope);
                                break block1;
                            }
                            case CHECK_ARITY: {
                                ((CheckArityInstr)instr).checkArity(context.runtime, args2.length);
                                break block1;
                            }
                            case POP_FRAME: {
                                context.popFrame();
                                context.popRubyClass();
                                break block1;
                            }
                            case POP_BINDING: {
                                context.popScope();
                                break block1;
                            }
                            case THREAD_POLL: {
                                if (profile && ++globalThreadPollCount % 20000 == 0) {
                                    Interpreter.analyzeProfile();
                                }
                                context.callThreadPoll();
                                break block1;
                            }
                            case LINE_NUM: {
                                context.setLine(((LineNumberInstr)instr).lineNumber);
                                break block1;
                            }
                            case RECORD_END_BLOCK: {
                                ((RecordEndBlockInstr)instr).interpret();
                            }
                        }
                        break;
                    }
                    case OTHER_OP: {
                        Object result2 = null;
                        switch (operation) {
                            case BREAK: {
                                BreakInstr bi = (BreakInstr)instr;
                                IRubyObject rv = (IRubyObject)bi.getReturnValue().retrieve(context, self2, currDynScope, temp);
                                return IRRuntimeHelpers.initiateBreak(context, scope, bi.getScopeToReturnTo().getScopeId(), rv, blockType);
                            }
                            case RETURN: {
                                return (IRubyObject)Interpreter.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, temp);
                            }
                            case NONLOCAL_RETURN: {
                                NonlocalReturnInstr ri = (NonlocalReturnInstr)instr;
                                IRubyObject rv = (IRubyObject)Interpreter.retrieveOp(ri.getReturnValue(), context, self2, currDynScope, temp);
                                ipc = n;
                                if (!IRRuntimeHelpers.inLambda(blockType)) {
                                    IRRuntimeHelpers.initiateNonLocalReturn(context, scope, ri.methodToReturnFrom, rv);
                                }
                                return rv;
                            }
                            case COPY: {
                                CopyInstr c = (CopyInstr)instr;
                                result2 = Interpreter.retrieveOp(c.getSource(), context, self2, currDynScope, temp);
                                Interpreter.setResult(temp, currDynScope, c.getResult(), result2);
                                break block1;
                            }
                            case GET_FIELD: {
                                GetFieldInstr gfi = (GetFieldInstr)instr;
                                IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currDynScope, temp);
                                VariableAccessor a = gfi.getAccessor(object);
                                Object object2 = result2 = a == null ? null : (IRubyObject)a.get(object);
                                if (result2 == null) {
                                    result2 = context.nil;
                                }
                                Interpreter.setResult(temp, currDynScope, gfi.getResult(), result2);
                                break block1;
                            }
                            case SEARCH_CONST: {
                                SearchConstInstr sci = (SearchConstInstr)instr;
                                result2 = sci.getCachedConst();
                                if (!sci.isCached(context, result2)) {
                                    result2 = sci.cache(context, currDynScope, self2, temp);
                                }
                                Interpreter.setResult(temp, currDynScope, sci.getResult(), result2);
                                break block1;
                            }
                        }
                        result2 = instr.interpret(context, currDynScope, self2, temp, block);
                        Interpreter.setResult(temp, currDynScope, instr, result2);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                if (debug) {
                    LOG.info("in scope: " + scope + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                }
                int n2 = ipc = t instanceof Unrescuable ? scope.getEnsurerPC(instr) : scope.getRescuerPC(instr);
                if (debug) {
                    LOG.info("ipc for rescuer/ensurer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(ThreadContext context, IRubyObject self2, IRScope scope, RubyModule clazz, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, scope, null, clazz, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(ThreadContext context, IRubyObject self2, IRScope scope, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, scope, null, null, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_METHOD(ThreadContext context, InterpretedIRMethod irMethod, IRubyObject self2, String name2, IRubyObject[] args2, Block block, Block.Type blockType, boolean isTraceable) {
        Ruby runtime = context.runtime;
        IRScope scope = irMethod.getIRMethod();
        RubyModule implClass = irMethod.getImplementationClass();
        Visibility viz = irMethod.getVisibility();
        boolean syntheticMethod = name2 == null || name2.equals("");
        try {
            if (!syntheticMethod) {
                ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            }
            if (isTraceable) {
                Interpreter.methodPreTrace(runtime, context, name2, implClass);
            }
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, scope, viz, implClass, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            if (isTraceable) {
                try {
                    Interpreter.methodPostTrace(runtime, context, name2, implClass);
                }
                finally {
                    if (!syntheticMethod) {
                        ThreadContext.popBacktrace(context);
                    }
                }
            } else if (!syntheticMethod) {
                ThreadContext.popBacktrace(context);
            }
        }
    }

    private static void methodPreTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.CALL, name2, implClass);
        }
    }

    private static void methodPostTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.RETURN, name2, implClass);
        }
    }

    private static class CallSiteProfile {
        IRCallSite cs;
        HashMap<IRScope, Counter> counters;

        public CallSiteProfile(IRCallSite cs) {
            this.cs = new IRCallSite(cs);
            this.counters = new HashMap();
        }
    }

    private static class IRCallSite {
        IRScope s;
        int v;
        CallBase call;
        long count;
        InterpretedIRMethod tgtM;

        public IRCallSite() {
        }

        public IRCallSite(IRCallSite cs) {
            this.s = cs.s;
            this.v = cs.v;
            this.call = cs.call;
            this.count = 0L;
        }

        public int hashCode() {
            return (int)this.call.callSiteId;
        }
    }
}

