/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.multipart.MultipartEncodingUtil;
import com.ning.http.multipart.Part;
import com.ning.http.multipart.RequestEntity;
import com.ning.http.util.MiscUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public class MultipartRequestEntity
implements RequestEntity {
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static byte[] MULTIPART_CHARS = MultipartEncodingUtil.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    protected final Part[] parts;
    private final byte[] multipartBoundary;
    private final String contentType;
    private final long contentLength;

    public static byte[] generateMultipartBoundary() {
        Random rand = new Random();
        byte[] bytes = new byte[rand.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    public MultipartRequestEntity(Part[] parts, FluentCaseInsensitiveStringsMap requestHeaders) {
        if (parts == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        this.parts = parts;
        String contentTypeHeader = requestHeaders.getFirstValue("Content-Type");
        if (MiscUtil.isNonEmpty(contentTypeHeader)) {
            int boundaryLocation = contentTypeHeader.indexOf("boundary=");
            if (boundaryLocation != -1) {
                this.contentType = contentTypeHeader;
                this.multipartBoundary = MultipartEncodingUtil.getAsciiBytes(contentTypeHeader.substring(boundaryLocation + "boundary=".length()).trim());
            } else {
                this.multipartBoundary = MultipartRequestEntity.generateMultipartBoundary();
                this.contentType = this.computeContentType(contentTypeHeader);
            }
        } else {
            this.multipartBoundary = MultipartRequestEntity.generateMultipartBoundary();
            this.contentType = this.computeContentType(MULTIPART_FORM_CONTENT_TYPE);
        }
        this.contentLength = Part.getLengthOfParts(parts, this.multipartBoundary);
    }

    private String computeContentType(String base) {
        StringBuilder buffer = new StringBuilder(base);
        if (!base.endsWith(";")) {
            buffer.append(";");
        }
        return buffer.append(" boundary=").append(MultipartEncodingUtil.getAsciiString(this.multipartBoundary)).toString();
    }

    protected byte[] getMultipartBoundary() {
        return this.multipartBoundary;
    }

    public void writeRequest(OutputStream out) throws IOException {
        Part.sendParts(out, this.parts, this.multipartBoundary);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }
}

