/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.classfile.UTF8Constant;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class ClassNameExtractor {
    private final String _constant;
    private int _index;
    private int _endIndex;
    private Set _classNames = new LinkedHashSet();
    private boolean _valid = true;

    static boolean isValid(String className) {
        boolean valid = true;
        boolean firstCharacter = true;
        int n = className.length();
        for (int i = 0; valid && i < n; ++i) {
            char c = className.charAt(i);
            if (firstCharacter) {
                firstCharacter = false;
                valid = Character.isJavaIdentifierStart(c);
                continue;
            }
            if (c == '.') {
                firstCharacter = true;
                continue;
            }
            valid = Character.isJavaIdentifierPart(c);
        }
        return valid && !firstCharacter;
    }

    ClassNameExtractor(UTF8Constant constant) {
        this._constant = constant.getString();
        this._endIndex = this._constant.length();
    }

    Set extract() {
        int numberOfTypes;
        if (this.getCurrentCharacter() == '<') {
            int ddIndex = this._constant.indexOf("::", this._index);
            if (ddIndex > 0) {
                this._index = ddIndex + 2;
                this.parseTypes(false);
                if (this.getCurrentCharacter() == '>') {
                    ++this._index;
                } else {
                    this.setInvalid();
                }
            } else {
                this.setInvalid();
            }
        }
        if (this.getCurrentCharacter() == '(') {
            int endIndex = this._constant.indexOf(41, this._index);
            if (endIndex > 0) {
                ++this._index;
                this._endIndex = endIndex;
                this.parseTypes(false);
                this._index = endIndex + 1;
                this._endIndex = this._constant.length();
            } else {
                this.setInvalid();
            }
        }
        if (this._valid && (numberOfTypes = this.parseTypes(false)) == 0) {
            this.setInvalid();
        }
        return this._valid ? this._classNames : Collections.EMPTY_SET;
    }

    private int parseTypes(boolean generics) {
        int numberOfTypes = 0;
        while (this._valid && !this.endOfTypes()) {
            this.parseType(generics);
            ++numberOfTypes;
        }
        return numberOfTypes;
    }

    private char getCurrentCharacter() {
        return this._index < this._endIndex ? this._constant.charAt(this._index) : (char)'\u0000';
    }

    private void setInvalid() {
        this._valid = false;
    }

    private boolean endOfTypes() {
        return this._index >= this._endIndex || this._constant.charAt(this._index) == '>';
    }

    private void parseType(boolean generics) {
        if (generics) {
            char currentCharacter = this.getCurrentCharacter();
            if (currentCharacter == '+') {
                ++this._index;
            } else if (currentCharacter == '*') {
                ++this._index;
                return;
            }
        }
        boolean arrayType = false;
        while (this.getCurrentCharacter() == '[') {
            arrayType = true;
            ++this._index;
        }
        if (arrayType && this.endOfTypes()) {
            this.setInvalid();
        } else {
            char c = this.getCurrentCharacter();
            ++this._index;
            if (c == 'L') {
                this.parseComplexType();
            } else if (c == 'T') {
                int index = this._constant.indexOf(59, this._index);
                if (index < 0) {
                    this.setInvalid();
                } else {
                    this._index = index + 1;
                }
            } else if ("BCDFIJSVZ".indexOf(c) < 0) {
                this.setInvalid();
            }
        }
    }

    private void parseComplexType() {
        int typeIndex = this._constant.indexOf(60, this._index);
        int endIndex = this._constant.indexOf(59, this._index);
        if (typeIndex >= 0 && typeIndex < endIndex) {
            this.extractClassName(typeIndex);
            this.parseTypes(true);
            this._index += 2;
        } else if (endIndex > 0) {
            this.extractClassName(endIndex);
        } else {
            this.setInvalid();
        }
    }

    private void extractClassName(int endIndex) {
        String className = this._constant.substring(this._index, endIndex);
        className = className.replace('/', '.');
        this._classNames.add(className);
        this._index = endIndex + 1;
        if (!ClassNameExtractor.isValid(className)) {
            this.setInvalid();
        }
    }
}

