/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.CyclesResult;
import classycle.dependency.DependencyPathRenderer;
import classycle.dependency.DependencyPathsRenderer;
import classycle.dependency.DependencyResult;
import classycle.dependency.Preference;
import classycle.dependency.PreferenceFactory;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.TextResult;
import classycle.graph.Attributes;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import classycle.renderer.AbstractStrongComponentRenderer;
import classycle.util.StringPattern;
import classycle.util.Text;
import java.util.List;
import java.util.Stack;

public class XMLResultRenderer
extends ResultRenderer {
    private static final String ELEMENT_DEPENDENCY_RESULT = "dependency-checking-results";
    private static final String ATTRIBUTE_STATEMENT = "statement";

    public PreferenceFactory getPreferenceFactory() {
        return new PreferenceFactory(){

            public Preference get(final String key) {
                return new Preference(){

                    public String getKey() {
                        return key;
                    }
                };
            }
        };
    }

    public void considerPreference(Preference preference) {
    }

    public Result getDescriptionOfCurrentPreferences() {
        return new TextResult("");
    }

    public String render(Result result) {
        XMLBuilder builder = new XMLBuilder();
        builder.begin(ELEMENT_DEPENDENCY_RESULT);
        this.addTo(builder, result);
        builder.end();
        return builder.toString();
    }

    private void addTo(XMLBuilder builder, Result result) {
        if (result instanceof CyclesResult) {
            this.addTo(builder, (CyclesResult)result);
        } else if (result instanceof DependencyResult) {
            this.addTo(builder, (DependencyResult)result);
        } else if (result instanceof ResultContainer) {
            this.addTo(builder, (ResultContainer)result);
        } else if (result instanceof TextResult) {
            this.addTo(builder, (TextResult)result);
        }
    }

    private void addTo(XMLBuilder builder, CyclesResult result) {
        builder.begin("cycles");
        builder.attribute(ATTRIBUTE_STATEMENT, result.getStatement());
        builder.attribute("vertex-type", result.isPackageCycle() ? "package" : "class");
        List<StrongComponent> cycles = result.getCycles();
        for (StrongComponent component : cycles) {
            builder.begin("cycle");
            builder.attribute("name", AbstractStrongComponentRenderer.createName(component));
            int n = component.getNumberOfVertices();
            for (int i = 0; i < n; ++i) {
                builder.begin("class");
                Attributes attributes = component.getVertex(i).getAttributes();
                if (attributes instanceof NameAttributes) {
                    builder.text(((NameAttributes)attributes).getName());
                }
                builder.end();
            }
            builder.end();
        }
        builder.end();
    }

    private void addTo(XMLBuilder builder, DependencyResult result) {
        builder.begin("unexpected-dependencies");
        builder.attribute(ATTRIBUTE_STATEMENT, result.getStatement());
        Vertex[] paths = result.getPaths();
        StringPattern startSet = result.getStartSet();
        StringPattern finalSet = result.getFinalSet();
        DependencyPathsRenderer renderer = new DependencyPathsRenderer(paths, startSet, finalSet);
        renderer.renderGraph(this.createPathRenderer(builder));
        builder.end();
    }

    private DependencyPathRenderer createPathRenderer(final XMLBuilder builder) {
        return new DependencyPathRenderer(){
            private int _level;
            private boolean _openTag;

            public void increaseIndentation() {
                this._openTag = false;
                ++this._level;
            }

            public void decreaseIndentation() {
                --this._level;
                if (this._openTag) {
                    builder.end();
                }
                this._openTag = false;
                builder.end();
            }

            public void add(String nodeName) {
                if (this._openTag) {
                    builder.end();
                }
                builder.begin("node");
                builder.attribute("name", nodeName);
                this._openTag = true;
            }
        };
    }

    private void addTo(XMLBuilder builder, ResultContainer result) {
        int numberOfResults = result.getNumberOfResults();
        for (int i = 0; i < numberOfResults; ++i) {
            this.addTo(builder, result.getResult(i));
        }
    }

    private void addTo(XMLBuilder builder, TextResult result) {
        if (!result.isOk() || result.toString().trim().length() > 0) {
            builder.begin(result.isOk() ? "info" : "checking-error");
            builder.text(result.toString());
            builder.end();
        }
    }

    private static final class XMLBuilder {
        private static final int INDENTATION_INCREMENT = 2;
        private final StringBuilder _builder = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>\n");
        private Stack<String> _stack = new Stack();
        private boolean _unfinishedStartTag;
        private boolean _textAdded;

        private XMLBuilder() {
        }

        void begin(String element) {
            if (this._unfinishedStartTag) {
                this._builder.append(">\n");
            }
            this.indent();
            this._builder.append("<").append(element);
            this._stack.push(element);
            this._unfinishedStartTag = true;
        }

        void attribute(String name, String value) {
            this._builder.append(' ').append(name).append("='").append(Text.excapeForXML(value)).append("'");
        }

        void text(String text) {
            this._builder.append(">").append(Text.excapeForXML(text));
            this._unfinishedStartTag = false;
            this._textAdded = true;
        }

        void end() {
            String element = this._stack.pop();
            if (this._unfinishedStartTag) {
                this._builder.append("/>\n");
                this._unfinishedStartTag = false;
            } else {
                if (!this._textAdded) {
                    this.indent();
                }
                this._textAdded = false;
                this._builder.append("</").append(element).append(">\n");
            }
        }

        private void indent() {
            for (int i = 0; i < this._stack.size() * 2; ++i) {
                this._builder.append(' ');
            }
        }

        public String toString() {
            return this._builder.toString();
        }
    }
}

