/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.fileinstall.FileInstall;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class DirectoryWatcher
extends Thread {
    static final String ALIAS_KEY = "_alias_factory_pid";
    public static final String POLL = "felix.fileinstall.poll";
    public static final String DIR = "felix.fileinstall.dir";
    public static final String DEBUG = "felix.fileinstall.debug";
    File watchedDirectory;
    long poll = 2000L;
    long debug;
    BundleContext context;
    boolean reported;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public DirectoryWatcher(Dictionary properties, BundleContext context) {
        super(properties.toString());
        this.context = context;
        this.poll = this.getLong(POLL, this.poll);
        this.debug = this.getLong(DEBUG, -1L);
        String dir = (String)properties.get(DIR);
        if (dir == null) {
            dir = "./load";
        }
        this.watchedDirectory = new File(dir);
        this.watchedDirectory.mkdirs();
    }

    public void run() {
        this.log("felix.fileinstall.poll  (ms)   " + this.poll, null);
        this.log("felix.fileinstall.dir            " + this.watchedDirectory.getAbsolutePath(), null);
        this.log("felix.fileinstall.debug          " + this.debug, null);
        HashMap currentManagedBundles = new HashMap();
        HashMap currentManagedConfigs = new HashMap();
        while (!DirectoryWatcher.interrupted()) {
            try {
                HashSet installed = new HashSet();
                HashSet configs = new HashSet();
                this.traverse(installed, configs, this.watchedDirectory);
                this.doInstalled(currentManagedBundles, installed);
                this.doConfigs(currentManagedConfigs, configs);
                Thread.sleep(this.poll);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                this.log("In main loop, we have serious trouble", e);
            }
        }
    }

    void doConfigs(Map current, Set discovered) {
        try {
            File f;
            String path;
            HashSet inactive = new HashSet(current.keySet());
            Iterator e = discovered.iterator();
            while (e.hasNext()) {
                path = (String)e.next();
                f = new File(path);
                if (!current.containsKey(path)) {
                    Long l = new Long(f.lastModified());
                    if (this.setConfig(f)) {
                        current.put(path, l);
                    }
                } else {
                    long lastModified = f.lastModified();
                    long oldTime = (Long)current.get(path);
                    if (oldTime < lastModified && this.setConfig(f)) {
                        current.put(path, new Long(lastModified));
                    }
                }
                inactive.remove(path);
            }
            e = inactive.iterator();
            while (e.hasNext()) {
                path = (String)e.next();
                f = new File(path);
                if (!this.deleteConfig(f)) continue;
                current.remove(path);
            }
        }
        catch (Exception ee) {
            this.log("Processing config: ", ee);
        }
    }

    boolean setConfig(File f) throws Exception {
        Configuration config;
        ConfigurationAdmin cm = (ConfigurationAdmin)FileInstall.cmTracker.getService();
        if (cm == null) {
            if (this.debug != 0L && !this.reported) {
                this.log("Can't find a Configuration Manager, configurations do not work", null);
                this.reported = true;
            }
            return false;
        }
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(f);
        p.load(in);
        ((InputStream)in).close();
        String[] pid = this.parsePid(f.getName());
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        ht.putAll(p);
        if (pid[1] != null) {
            ht.put(ALIAS_KEY, pid[1]);
        }
        if ((config = this.getConfiguration(pid[0], pid[1])).getBundleLocation() != null) {
            config.setBundleLocation(null);
        }
        config.update(ht);
        return true;
    }

    boolean deleteConfig(File f) throws Exception {
        String[] pid = this.parsePid(f.getName());
        Configuration config = this.getConfiguration(pid[0], pid[1]);
        config.delete();
        return true;
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.length() - 4);
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String pid, String factoryPid) throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)FileInstall.cmTracker.getService();
        if (factoryPid != null) {
            String filter = "(|(_alias_factory_pid=" + factoryPid + ")(.alias_factory_pid=" + factoryPid + "))";
            Configuration[] configs = cm.listConfigurations(filter);
            if (configs == null || configs.length == 0) {
                return cm.createFactoryConfiguration(pid, null);
            }
            return configs[0];
        }
        return cm.getConfiguration(pid, null);
    }

    void doInstalled(Map current, Set discovered) {
        File file;
        boolean refresh = false;
        Bundle[] bundles = this.context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            String location = bundle.getLocation();
            if (discovered.contains(location)) {
                long oldSize;
                discovered.remove(location);
                file = new File(location);
                long newSize = file.length();
                Long oldSizeObj = (Long)current.get(location);
                long l = oldSize = oldSizeObj == null ? 0L : oldSizeObj;
                if (file.lastModified() > bundle.getLastModified() + 4000L && oldSize != newSize) {
                    try {
                        current.put(location, new Long(newSize));
                        FileInputStream in = new FileInputStream(file);
                        bundle.update((InputStream)in);
                        refresh = true;
                        ((InputStream)in).close();
                        this.log("Updated " + location, null);
                    }
                    catch (Exception e) {
                        this.log("Failed to update bundle ", e);
                    }
                }
                if (this.isFragment(bundle)) continue;
                try {
                    bundle.start();
                }
                catch (Exception e) {
                    this.log("Fail to start bundle " + location, e);
                }
                continue;
            }
            if (!bundle.getLocation().startsWith(this.watchedDirectory.getAbsolutePath())) continue;
            try {
                bundle.uninstall();
                refresh = true;
                this.log("Uninstalled " + location, null);
                continue;
            }
            catch (Exception e) {
                this.log("failed to uninstall bundle: ", e);
            }
        }
        ArrayList<Bundle> starters = new ArrayList<Bundle>();
        Iterator it = discovered.iterator();
        while (it.hasNext()) {
            try {
                String path = (String)it.next();
                file = new File(path);
                FileInputStream in = new FileInputStream(file);
                Bundle bundle = this.context.installBundle(path, (InputStream)in);
                ((InputStream)in).close();
                starters.add(bundle);
                this.log("Installed " + file.getAbsolutePath(), null);
            }
            catch (Exception e) {
                this.log("failed to install/start bundle: ", e);
            }
        }
        if (refresh || starters.size() != 0) {
            this.refresh();
            Iterator b = starters.iterator();
            while (b.hasNext()) {
                Bundle bundle = (Bundle)b.next();
                if (this.isFragment(bundle)) continue;
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    this.log("Error while starting a newly installed bundle", e);
                }
            }
        }
    }

    void log(String message, Throwable e) {
        LogService log = this.getLogService();
        if (log == null) {
            System.out.println(message + (e == null ? "" : ": " + e));
        } else if (e == null) {
            log.log(1, message, e);
            if (this.debug > 0L && e != null) {
                e.printStackTrace();
            }
        } else {
            log.log(3, message);
        }
    }

    LogService getLogService() {
        ServiceReference ref = this.context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = DirectoryWatcher.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
        if (ref != null) {
            LogService log = (LogService)this.context.getService(ref);
            return log;
        }
        return null;
    }

    void traverse(Set jars, Set configs, File jardir) {
        String[] list = jardir.list();
        for (int i = 0; i < list.length; ++i) {
            File file = new File(jardir, list[i]);
            if (list[i].endsWith(".jar")) {
                jars.add(file.getAbsolutePath());
                continue;
            }
            if (!list[i].endsWith(".cfg")) continue;
            configs.add(file.getAbsolutePath());
        }
    }

    boolean isFragment(Bundle bundle) {
        if (FileInstall.padmin == null) {
            return false;
        }
        try {
            PackageAdmin padmin = (PackageAdmin)FileInstall.padmin.waitForService(10000L);
            if (padmin != null) {
                return padmin.getBundleType(bundle) == 1;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    void refresh() {
        try {
            PackageAdmin padmin = (PackageAdmin)FileInstall.padmin.waitForService(10000L);
            padmin.refreshPackages(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    long getLong(String property, long dflt) {
        String value = this.context.getProperty(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                this.log(property + " set, but not a long: " + value, null);
            }
        }
        return dflt;
    }

    public void close() {
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

