/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.bnd;

import aQute.maven.repo.api.Program;
import aQute.maven.repo.api.Revision;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class LocalRepoWatcher
implements Closeable {
    private final Path root;
    private final AtomicReference<Set<Program>> older = new AtomicReference<Set>(Collections.EMPTY_SET);
    private ProgramsChanged callback;
    private final ReentrantLock callbackLock = new ReentrantLock();
    private final AtomicBoolean busy = new AtomicBoolean();
    private ScheduledFuture<?> schedule;

    public LocalRepoWatcher(Path root, ProgramsChanged callback, Reporter reporter, ScheduledExecutorService executor, long timeoutinMs) throws Exception {
        Files.createDirectories(root, new FileAttribute[0]);
        this.root = root;
        this.callback = callback;
        if (executor != null) {
            this.setupScheduler(executor, timeoutinMs);
        }
    }

    void setupScheduler(ScheduledExecutorService executor, long timeoutinMs) {
        this.schedule = executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                block8: {
                    int priority = Thread.currentThread().getPriority();
                    try {
                        Thread.currentThread().setPriority(1);
                        if (LocalRepoWatcher.this.busy.getAndSet(true)) break block8;
                        try {
                            try {
                                LocalRepoWatcher.this.refresh();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                LocalRepoWatcher.this.busy.set(false);
                            }
                        }
                        finally {
                            LocalRepoWatcher.this.busy.set(false);
                        }
                    }
                    finally {
                        Thread.currentThread().setPriority(priority);
                    }
                }
            }
        }, timeoutinMs, timeoutinMs, TimeUnit.MILLISECONDS);
    }

    public void open() throws IOException {
        this.refresh();
    }

    public void refresh() throws IOException {
        HashSet<Program> newer = new HashSet<Program>();
        this.traverse(this.root, newer, 0);
        if (this.older != null && this.older.equals(newer)) {
            return;
        }
        HashSet<Program> added = new HashSet<Program>(newer);
        added.removeAll((Collection)this.older.get());
        HashSet<Program> removed = new HashSet<Program>((Collection)this.older.get());
        removed.removeAll(newer);
        this.older.set(newer);
        if (this.callback == null) {
            return;
        }
        this.callbackLock.lock();
        try {
            try {
                this.callback.changed(added, removed);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.callbackLock.unlock();
            }
        }
        finally {
            this.callbackLock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    void traverse(Path dir, Set<Program> programs, int depth) throws IOException {
        var4_4 = null;
        var5_6 = null;
        try {
            stream = Files.newDirectoryStream(dir);
            try {
                var8_9 = stream.iterator();
                while (true) {
                    path = var8_9.next();
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (depth >= 2) {
                            artifact = path.getName(path.getNameCount() - 2);
                            version = path.getName(path.getNameCount() - 1);
                            p = path.resolve(artifact + "-" + version + ".pom");
                            if (Files.isRegularFile(p, new LinkOption[0])) {
                                revisionDir = this.root.relativize(path);
                                r = Revision.fromProjectPath(revisionDir);
                                programs.add(r.program);
                                return;
                            }
                        }
                        this.traverse(path, programs, depth + 1);
                    }
                    break;
                }
            }
            finally {
                if (var8_9.hasNext()) ** continue;
            }
        }
        catch (Throwable var5_7) {
            if (var4_4 == null) {
                var4_4 = var5_7;
            } else if (var4_4 != var5_7) {
                var4_4.addSuppressed(var5_7);
            }
            throw var4_4;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.schedule != null) {
            this.schedule.cancel(true);
        }
    }

    public Set<Program> getLocalPrograms() {
        return this.older.get();
    }

    public static interface ProgramsChanged {
        public boolean changed(Set<Program> var1, Set<Program> var2) throws Exception;
    }
}

