/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Australia
extends DelegateCalendar {
    private static final Australia SETTLEMENT_CALENDAR = new Australia(Market.SETTLEMENT);
    private static final Australia EXCHANGE_CALENDAR = new Australia(Market.ASX);

    private Australia(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new AustraliaSettlementCalendar();
                break;
            }
            case ASX: {
                delegate = new AustraliaExchangeCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Australia getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case ASX: {
                return EXCHANGE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class AustraliaExchangeCalendar
    extends WesternCalendar {
        private AustraliaExchangeCalendar() {
        }

        @Override
        public String getName() {
            return "ASX";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || (d == 26 || (d == 27 || d == 28) && w == Weekday.MONDAY) && m == Month.JANUARY || dd == em - 3 || dd == em || (d == 25 || d == 26 && w == Weekday.MONDAY) && m == Month.APRIL || d > 7 && d <= 14 && w == Weekday.MONDAY && m == Month.JUNE || d <= 7 && w == Weekday.MONDAY && m == Month.AUGUST || d <= 7 && w == Weekday.MONDAY && m == Month.OCTOBER || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER) && (d != 26 && (d != 28 || w != Weekday.MONDAY && w != Weekday.TUESDAY) || m != Month.DECEMBER);
        }
    }

    private static final class AustraliaSettlementCalendar
    extends WesternCalendar {
        private AustraliaSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Australia";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || (d == 26 || (d == 27 || d == 28) && w == Weekday.MONDAY) && m == Month.JANUARY || dd == em - 3 || dd == em || (d == 25 || d == 26 && w == Weekday.MONDAY) && m == Month.APRIL || d > 7 && d <= 14 && w == Weekday.MONDAY && m == Month.JUNE || d <= 7 && w == Weekday.MONDAY && m == Month.AUGUST || d <= 7 && w == Weekday.MONDAY && m == Month.OCTOBER || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER) && (d != 26 && (d != 28 || w != Weekday.MONDAY && w != Weekday.TUESDAY) || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        SETTLEMENT,
        ASX;

    }
}

