/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FrameworkStartLevelImpl;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.ext.SecurityProvider;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleImpl
implements Bundle,
BundleRevisions {
    private final Felix __m_felix;
    private final BundleArchive m_archive;
    private final List<BundleRevision> m_revisions = new ArrayList<BundleRevision>(0);
    private volatile int m_state;
    private boolean m_useDeclaredActivationPolicy;
    private BundleActivator m_activator = null;
    private volatile BundleContext m_context = null;
    private final Map m_cachedHeaders = new HashMap();
    private long m_cachedHeadersTimestamp;
    private boolean m_stale = false;
    private int m_lockCount = 0;
    private Thread m_lockThread = null;
    private static final SecurityManagerEx m_smEx = new SecurityManagerEx();
    private static final ClassLoader m_classloader = (class$org$apache$felix$framework$Felix == null ? (class$org$apache$felix$framework$Felix = BundleImpl.class$("org.apache.felix.framework.Felix")) : class$org$apache$felix$framework$Felix).getClassLoader();
    static /* synthetic */ Class class$org$apache$felix$framework$BundleRevisionImpl;
    static /* synthetic */ Class class$org$apache$felix$framework$Felix;
    static /* synthetic */ Class class$org$osgi$framework$startlevel$BundleStartLevel;
    static /* synthetic */ Class class$org$apache$felix$framework$FrameworkStartLevelImpl;
    static /* synthetic */ Class class$org$osgi$framework$wiring$BundleRevision;
    static /* synthetic */ Class class$org$osgi$framework$wiring$BundleRevisions;
    static /* synthetic */ Class class$org$osgi$framework$wiring$BundleWiring;

    BundleImpl() {
        this.__m_felix = null;
        this.m_archive = null;
        this.m_state = 2;
        this.m_useDeclaredActivationPolicy = false;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
    }

    BundleImpl(Felix felix, BundleArchive archive) throws Exception {
        this.__m_felix = felix;
        this.m_archive = archive;
        this.m_state = 2;
        this.m_useDeclaredActivationPolicy = false;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
        BundleRevision revision = this.createRevision();
        this.addRevision(revision);
    }

    Felix getFramework() {
        return this.__m_felix;
    }

    BundleArchive getArchive() {
        return this.m_archive;
    }

    synchronized void close() {
        this.closeRevisions();
        try {
            this.m_archive.close();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Unable to close archive revisions.", (Throwable)ex);
        }
    }

    synchronized void closeAndDelete() throws Exception {
        this.m_stale = true;
        this.closeRevisions();
        this.m_archive.closeAndDelete();
    }

    private void closeRevisions() {
        for (BundleRevision br : this.m_revisions) {
            this.getFramework().getResolver().removeRevision(br);
            ((BundleRevisionImpl)br).close();
        }
    }

    synchronized void refresh() throws Exception {
        if (this.isExtension() && this.getFramework().getState() != 16) {
            this.getFramework().getLogger().log(this, 2, "Framework restart on extension bundle refresh not implemented.");
        } else {
            BundleRevisionImpl current = (BundleRevisionImpl)this.adapt(class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl);
            this.closeRevisions();
            this.m_revisions.clear();
            this.m_archive.purge();
            current.resetContent(this.m_archive.getCurrentRevision().getContent());
            this.addRevision(current);
            this.m_state = 2;
            this.m_stale = false;
            this.m_cachedHeaders.clear();
            this.m_cachedHeadersTimestamp = 0L;
        }
    }

    synchronized boolean isDeclaredActivationPolicyUsed() {
        return this.m_useDeclaredActivationPolicy;
    }

    synchronized void setDeclaredActivationPolicyUsed(boolean b) {
        this.m_useDeclaredActivationPolicy = b;
    }

    synchronized BundleActivator getActivator() {
        return this.m_activator;
    }

    synchronized void setActivator(BundleActivator activator) {
        this.m_activator = activator;
    }

    @Override
    public BundleContext getBundleContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "context"));
        }
        return this.m_context;
    }

    void setBundleContext(BundleContext context) {
        this.m_context = context;
    }

    @Override
    public long getBundleId() {
        try {
            return this.m_archive.getId();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error getting the identifier from bundle archive.", (Throwable)ex);
            return -1L;
        }
    }

    @Override
    public URL getEntry(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleEntry(this, name);
    }

    public Enumeration getEntryPaths(String path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleEntryPaths(this, path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().findBundleEntries((BundleRevision)this.adapt(class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl), path, filePattern, recurse);
    }

    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    public Dictionary getHeaders(String locale) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        return this.getFramework().getBundleHeaders(this, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getCurrentLocalizedHeader(String locale) {
        Map result = null;
        if (locale.length() == 0) {
            result = new StringMap(((BundleRevisionImpl)this.adapt(class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl)).getHeaders(), false);
        }
        if (result == null) {
            Map map = this.m_cachedHeaders;
            synchronized (map) {
                if (this.getState() == 1) {
                    result = (Map)this.m_cachedHeaders.values().iterator().next();
                } else if (this.getLastModified() > this.m_cachedHeadersTimestamp) {
                    this.m_cachedHeaders.clear();
                } else if (this.m_cachedHeaders.containsKey(locale)) {
                    result = (Map)this.m_cachedHeaders.get(locale);
                }
            }
        }
        if (result == null) {
            StringMap headers;
            result = headers = new StringMap(((BundleRevisionImpl)this.adapt(class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl)).getHeaders(), false);
            boolean localize = false;
            Iterator it = headers.values().iterator();
            while (!localize && it.hasNext()) {
                if (!((String)it.next()).startsWith("%")) continue;
                localize = true;
            }
            if (!localize) {
                this.updateHeaderCache(locale, headers);
            } else {
                String basename = (String)headers.get("Bundle-Localization");
                if (basename == null) {
                    basename = "OSGI-INF/l10n/bundle";
                }
                List<BundleRevision> revisionList = BundleImpl.createLocalizationRevisionList((BundleRevision)this.adapt(class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl));
                List<String> resourceList = BundleImpl.createLocalizationResourceList(basename, locale);
                boolean found = false;
                Properties mergedProperties = new Properties();
                for (BundleRevision bundleRevision : revisionList) {
                    for (String res : resourceList) {
                        URL temp = ((BundleRevisionImpl)bundleRevision).getEntry(new StringBuffer().append(res).append(".properties").toString());
                        if (temp == null) continue;
                        found = true;
                        try {
                            mergedProperties.load(temp.openConnection().getInputStream());
                        }
                        catch (IOException ex) {}
                    }
                }
                if (!found && !locale.equals(Locale.getDefault().toString())) {
                    result = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
                } else {
                    for (Map.Entry entry : headers.entrySet()) {
                        String value = (String)entry.getValue();
                        if (!value.startsWith("%")) continue;
                        String key = value.substring(value.indexOf("%") + 1);
                        String newvalue = mergedProperties.getProperty(key);
                        if (newvalue == null) {
                            newvalue = key;
                        }
                        entry.setValue(newvalue);
                    }
                    this.updateHeaderCache(locale, headers);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHeaderCache(String locale, Map localizedHeaders) {
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            this.m_cachedHeaders.put(locale, localizedHeaders);
            this.m_cachedHeadersTimestamp = System.currentTimeMillis();
        }
    }

    private static List<BundleRevision> createLocalizationRevisionList(BundleRevision br) {
        List<BundleRevision> fragments;
        List<BundleWire> hostWires;
        if (Util.isFragment(br) && br.getWiring() != null && (hostWires = br.getWiring().getRequiredWires(null)) != null && hostWires.size() > 0) {
            br = hostWires.get(0).getProviderWiring().getRevision();
            for (int hostIdx = 1; hostIdx < hostWires.size(); ++hostIdx) {
                if (br.getVersion().compareTo(hostWires.get(hostIdx).getProviderWiring().getRevision().getVersion()) >= 0) continue;
                br = hostWires.get(hostIdx).getProviderWiring().getRevision();
            }
        }
        ArrayList<BundleRevision> result = new ArrayList<BundleRevision>();
        result.add(br);
        BundleWiring wiring = br.getWiring();
        if (wiring != null && (fragments = Util.getFragments(wiring)) != null) {
            result.addAll(fragments);
        }
        return result;
    }

    private static List<String> createLocalizationResourceList(String basename, String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuffer tempLocale = new StringBuffer(basename);
        result.add(tempLocale.toString());
        if (locale.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locale, "_");
            while (tokens.hasMoreTokens()) {
                tempLocale.append("_").append(tokens.nextToken());
                result.add(tempLocale.toString());
            }
        }
        return result;
    }

    @Override
    public long getLastModified() {
        try {
            return this.m_archive.getLastModified();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error reading last modification time from bundle archive.", (Throwable)ex);
            return 0L;
        }
    }

    void setLastModified(long l) {
        try {
            this.m_archive.setLastModified(l);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error writing last modification time to bundle archive.", (Throwable)ex);
        }
    }

    @Override
    public String getLocation() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        return this._getLocation();
    }

    String _getLocation() {
        try {
            return this.m_archive.getLocation();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error getting location from bundle archive.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleResource(this, name);
    }

    public Enumeration getResources(String name) throws IOException {
        Enumeration e;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e2) {
                return null;
            }
        }
        return (e = this.getFramework().getBundleResources(this, name)) == null || !e.hasMoreElements() ? null : e;
    }

    public ServiceReference[] getRegisteredServices() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getFramework().getBundleRegisteredServices(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            for (int i = 0; i < refs.length; ++i) {
                try {
                    sm.checkPermission(new ServicePermission(refs[i], "get"));
                    result.add(refs[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getFramework().getBundleRegisteredServices(this);
    }

    public ServiceReference[] getServicesInUse() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getFramework().getBundleServicesInUse(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            for (int i = 0; i < refs.length; ++i) {
                try {
                    sm.checkPermission(new ServicePermission(refs[i], "get"));
                    result.add(refs[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getFramework().getBundleServicesInUse(this);
    }

    @Override
    public int getState() {
        return this.m_state;
    }

    void __setState(int i) {
        this.m_state = i;
    }

    int getPersistentState() {
        try {
            return this.m_archive.getPersistentState();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error reading persistent state from bundle archive.", (Throwable)ex);
            return 2;
        }
    }

    void setPersistentStateInactive() {
        try {
            this.m_archive.setPersistentState(2);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)ex);
        }
    }

    void setPersistentStateActive() {
        try {
            this.m_archive.setPersistentState(32);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)ex);
        }
    }

    void setPersistentStateStarting() {
        try {
            this.m_archive.setPersistentState(8);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)ex);
        }
    }

    void setPersistentStateUninstalled() {
        try {
            this.m_archive.setPersistentState(1);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error writing persistent state to bundle archive.", (Throwable)ex);
        }
    }

    int getStartLevel(int defaultLevel) {
        try {
            return this.m_archive.getStartLevel();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error reading start level from bundle archive.", (Throwable)ex);
            return defaultLevel;
        }
    }

    void setStartLevel(int i) {
        try {
            this.m_archive.setStartLevel(i);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(this, 1, "Error writing start level to bundle archive.", (Throwable)ex);
        }
    }

    synchronized boolean isStale() {
        return this.m_stale;
    }

    synchronized boolean isExtension() {
        for (BundleRevision revision : this.m_revisions) {
            if (!((BundleRevisionImpl)revision).isExtension()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSymbolicName() {
        return ((BundleRevisionImpl)this.adapt(class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl)).getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return ((BundleRevisionImpl)this.adapt(class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl)).getVersion();
    }

    @Override
    public boolean hasPermission(Object obj) {
        return this.getFramework().bundleHasPermission(this, obj);
    }

    public Map getSignerCertificates(int signersType) {
        return (Map)this.getFramework().getSignerMatcher(this, signersType);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.isExtension()) {
            throw new ClassNotFoundException("Extension bundles cannot load classes.");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "class"));
            }
            catch (Exception ex) {
                throw new ClassNotFoundException("No permission.", ex);
            }
        }
        return this.getFramework().loadBundleClass(this, name);
    }

    @Override
    public void start() throws BundleException {
        this.start(0);
    }

    @Override
    public void start(int options) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().startBundle(this, options);
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    @Override
    public void update(InputStream is) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        this.getFramework().updateBundle(this, is);
    }

    @Override
    public void stop() throws BundleException {
        this.stop(0);
    }

    @Override
    public void stop(int options) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().stopBundle(this, (options & 1) == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            if (this.m_cachedHeaders.size() > 1 || !this.m_cachedHeaders.containsKey(Locale.getDefault().toString())) {
                this.m_cachedHeaders.clear();
                Map map2 = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
            }
        }
        this.getFramework().uninstallBundle(this);
    }

    <A> void checkAdapt(Class<A> type) {
        Class caller;
        SecurityManager sm = System.getSecurityManager();
        if (!(sm == null || this.getFramework().getSecurityProvider() == null || Felix.m_secureAction.getClassLoader(caller = m_smEx.getClassContext()[3]) == m_classloader && caller.getName().startsWith("org.apache.felix.framework."))) {
            sm.checkPermission(new AdaptPermission(type.getName(), this, "adapt"));
        }
    }

    @Override
    public synchronized <A> A adapt(Class<A> type) {
        this.checkAdapt(type);
        if (type == (class$org$osgi$framework$startlevel$BundleStartLevel == null ? (class$org$osgi$framework$startlevel$BundleStartLevel = BundleImpl.class$("org.osgi.framework.startlevel.BundleStartLevel")) : class$org$osgi$framework$startlevel$BundleStartLevel)) {
            return (A)((FrameworkStartLevelImpl)this.getFramework().adapt(class$org$apache$felix$framework$FrameworkStartLevelImpl == null ? (class$org$apache$felix$framework$FrameworkStartLevelImpl = BundleImpl.class$("org.apache.felix.framework.FrameworkStartLevelImpl")) : class$org$apache$felix$framework$FrameworkStartLevelImpl)).createBundleStartLevel(this);
        }
        if (type == (class$org$osgi$framework$wiring$BundleRevision == null ? (class$org$osgi$framework$wiring$BundleRevision = BundleImpl.class$("org.osgi.framework.wiring.BundleRevision")) : class$org$osgi$framework$wiring$BundleRevision)) {
            if (this.m_state == 1) {
                return null;
            }
            return (A)this.m_revisions.get(0);
        }
        if (type == (class$org$apache$felix$framework$BundleRevisionImpl == null ? (class$org$apache$felix$framework$BundleRevisionImpl = BundleImpl.class$("org.apache.felix.framework.BundleRevisionImpl")) : class$org$apache$felix$framework$BundleRevisionImpl)) {
            return (A)this.m_revisions.get(0);
        }
        if (type == (class$org$osgi$framework$wiring$BundleRevisions == null ? (class$org$osgi$framework$wiring$BundleRevisions = BundleImpl.class$("org.osgi.framework.wiring.BundleRevisions")) : class$org$osgi$framework$wiring$BundleRevisions)) {
            return (A)this;
        }
        if (type == (class$org$osgi$framework$wiring$BundleWiring == null ? (class$org$osgi$framework$wiring$BundleWiring = BundleImpl.class$("org.osgi.framework.wiring.BundleWiring")) : class$org$osgi$framework$wiring$BundleWiring)) {
            if (this.m_state == 1) {
                return null;
            }
            return (A)this.m_revisions.get(0).getWiring();
        }
        return null;
    }

    @Override
    public File getDataFile(String filename) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int compareTo(Bundle t) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        String sym = this.getSymbolicName();
        if (sym != null) {
            return new StringBuffer().append(sym).append(" [").append(this.getBundleId()).append("]").toString();
        }
        return new StringBuffer().append("[").append(this.getBundleId()).append("]").toString();
    }

    synchronized boolean isRemovalPending() {
        return this.m_state == 1 || this.m_revisions.size() > 1 || this.m_stale;
    }

    @Override
    public Bundle getBundle() {
        return this;
    }

    @Override
    public synchronized List<BundleRevision> getRevisions() {
        return new ArrayList<BundleRevision>(this.m_revisions);
    }

    synchronized boolean hasRevision(BundleRevision revision) {
        return this.m_revisions.contains(revision);
    }

    synchronized void revise(String location, InputStream is) throws Exception {
        this.m_archive.revise(location, is);
        try {
            BundleRevision revision = this.createRevision();
            this.addRevision(revision);
        }
        catch (Exception ex) {
            this.m_archive.rollbackRevise();
            throw ex;
        }
    }

    synchronized boolean rollbackRevise() throws Exception {
        boolean isExtension = this.isExtension();
        BundleRevision br = this.m_revisions.remove(0);
        if (!isExtension) {
            this.getFramework().getResolver().removeRevision(br);
        }
        return this.m_archive.rollbackRevise();
    }

    synchronized void addRevision(BundleRevision revision) throws Exception {
        this.m_revisions.add(0, revision);
        ((BundleRevisionImpl)revision).setProtectionDomain(new BundleProtectionDomain(this.getFramework(), this));
        SecurityProvider sp = this.getFramework().getSecurityProvider();
        if (sp != null && System.getSecurityManager() != null) {
            try {
                sp.checkBundle(this);
            }
            catch (Exception ex) {
                this.m_revisions.remove(0);
                throw ex;
            }
        }
        if (!this.isExtension()) {
            this.getFramework().getResolver().addRevision(revision);
        }
    }

    private BundleRevision createRevision() throws Exception {
        Map headerMap = this.m_archive.getCurrentRevision().getManifestHeader();
        BundleRevisionImpl revision = new BundleRevisionImpl(this, new StringBuffer().append(Long.toString(this.getBundleId())).append(".").append(this.m_archive.getCurrentRevisionNumber().toString()).toString(), headerMap, this.m_archive.getCurrentRevision().getContent());
        String allowMultiple = (String)this.getFramework().getConfig().get("org.osgi.framework.bsnversion");
        String string = allowMultiple = allowMultiple == null ? "single" : allowMultiple;
        if (revision.getManifestVersion().equals("2") && !allowMultiple.equals("multiple")) {
            Version bundleVersion = revision.getVersion();
            bundleVersion = bundleVersion == null ? Version.emptyVersion : bundleVersion;
            String symName = revision.getSymbolicName();
            Bundle[] bundles = this.getFramework().getBundles();
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                long id = ((BundleImpl)bundles[i]).getBundleId();
                if (id == this.getBundleId()) continue;
                String sym = bundles[i].getSymbolicName();
                Version ver = bundles[i].getVersion();
                if (symName == null || sym == null || !symName.equals(sym) || !bundleVersion.equals(ver)) continue;
                throw new BundleException(new StringBuffer().append("Bundle symbolic name and version are not unique: ").append(sym).append(':').append(ver).toString(), 9);
            }
        }
        return revision;
    }

    synchronized ProtectionDomain getProtectionDomain() {
        ProtectionDomain pd = null;
        for (int i = this.m_revisions.size() - 1; i >= 0 && pd == null; --i) {
            pd = ((BundleRevisionImpl)this.m_revisions.get(i)).getProtectionDomain();
        }
        return pd;
    }

    synchronized boolean isLockable() {
        return this.m_lockCount == 0 || this.m_lockThread == Thread.currentThread();
    }

    synchronized Thread getLockingThread() {
        return this.m_lockThread;
    }

    synchronized void lock() {
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        ++this.m_lockCount;
        this.m_lockThread = Thread.currentThread();
    }

    synchronized void unlock() {
        if (this.m_lockCount == 0) {
            throw new IllegalStateException("Bundle is not locked.");
        }
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        --this.m_lockCount;
        if (this.m_lockCount == 0) {
            this.m_lockThread = null;
        }
    }

    BundleContext _getBundleContext() {
        return this.m_context;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Bundle)x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

