/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib;

import java.util.prefs.Preferences;
import org.jquantlib.lang.annotation.PackagePrivate;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;

public class Settings {
    private static boolean defaultTodaysPayments = false;
    private boolean todaysPayments;
    private boolean negativeRates;
    private Date evaluationDate;

    @PackagePrivate
    Settings() {
        this.setDefaults();
    }

    @PackagePrivate
    Settings(Preferences prefs) {
        if (prefs != null) {
            this.todaysPayments = prefs.getBoolean("TodaysPayments", defaultTodaysPayments);
            this.evaluationDate = DateFactory.getFactory().getTodaysDate();
        } else {
            this.setDefaults();
        }
    }

    private void setDefaults() {
        this.todaysPayments = defaultTodaysPayments;
        this.evaluationDate = DateFactory.getFactory().getTodaysDate();
    }

    public boolean isTodaysPayments() {
        return this.todaysPayments;
    }

    public boolean isNegativeRates() {
        return this.negativeRates;
    }

    public Date getEvaluationDate() {
        return this.evaluationDate;
    }

    public void setTodaysPayments(boolean todaysPayments) {
        this.todaysPayments = todaysPayments;
    }

    public void setEvaluationDate(Date evaluationDate) {
        this.evaluationDate.getUpdatable().update(evaluationDate);
    }
}

