/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.ds.Activator;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.parser.Parser;
import org.eclipse.equinox.ds.parser.XMLParserNotAvailableException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ComponentDescriptionCache {
    private static final String CACHE_FILE = "cdcache.ser";
    private static final String CACHE_XML_PROPERTY = "declarativeservices.cacheXML";
    private File cacheFile;
    private final boolean CACHE_XML;
    private Activator main;
    private Map cdCache;
    private Map lastModifiedTimes;
    private Parser parser;

    public ComponentDescriptionCache(Activator main) {
        this.main = main;
        this.parser = new Parser(main);
        this.CACHE_XML = Boolean.valueOf(System.getProperty(CACHE_XML_PROPERTY, "true"));
        this.cacheFile = main.context.getDataFile(CACHE_FILE);
        if (this.cacheFile.exists() && this.CACHE_XML) {
            try {
                FileInputStream in = new FileInputStream(this.cacheFile);
                ObjectInputStream cacheStream = new ObjectInputStream(in);
                this.cdCache = (Hashtable)cacheStream.readObject();
                this.lastModifiedTimes = (Hashtable)cacheStream.readObject();
                cacheStream.close();
                in.close();
            }
            catch (Exception e) {
                Log.log(2, "Could not read Service Component XML cache", e);
                this.cdCache = new Hashtable();
                this.lastModifiedTimes = new Hashtable();
            }
        } else {
            this.cdCache = new Hashtable();
            this.lastModifiedTimes = new Hashtable();
        }
    }

    public List getComponentDescriptions(BundleContext bundleContext) throws XMLParserNotAvailableException {
        Bundle bundle = bundleContext.getBundle();
        Long bundleId = new Long(bundle.getBundleId());
        Long cacheTime = (Long)this.lastModifiedTimes.get(bundleId);
        Long lastModified = new Long(bundle.getLastModified());
        List cds = null;
        if (cacheTime != null && cacheTime.equals(lastModified)) {
            cds = (List)this.cdCache.get(bundleId);
        } else {
            cds = this.parser.getComponentDescriptions(bundleContext);
            if (!cds.isEmpty()) {
                this.lastModifiedTimes.put(bundleId, lastModified);
                this.cdCache.put(bundleId, cds);
            }
        }
        Iterator it = cds.iterator();
        while (it.hasNext()) {
            ((ComponentDescription)it.next()).setBundleContext(bundleContext);
        }
        return cds;
    }

    public List getCachedComponentDescriptions(Bundle bundle) {
        Long bundleId = new Long(bundle.getBundleId());
        List cds = (List)this.cdCache.get(bundleId);
        return cds != null ? cds : Collections.EMPTY_LIST;
    }

    public void dispose() {
        this.parser.dispose();
        if (this.CACHE_XML) {
            Bundle[] installedBundles = this.main.context.getBundles();
            HashSet<Long> installedBundleIDs = new HashSet<Long>(installedBundles.length);
            int i = 0;
            while (i < installedBundles.length) {
                installedBundleIDs.add(new Long(installedBundles[i].getBundleId()));
                ++i;
            }
            this.cdCache.keySet().retainAll(installedBundleIDs);
            this.lastModifiedTimes.keySet().retainAll(installedBundleIDs);
            try {
                FileOutputStream out = new FileOutputStream(this.cacheFile);
                ObjectOutputStream cacheStream = new ObjectOutputStream(out);
                cacheStream.writeObject(this.cdCache);
                cacheStream.writeObject(this.lastModifiedTimes);
                cacheStream.flush();
                cacheStream.close();
                out.close();
            }
            catch (Exception e) {
                Log.log(2, "Could not write Service Component XML cache", e);
                try {
                    this.cacheFile.delete();
                }
                catch (Exception e2) {
                    Log.log(3, "Could not delete Service Component XML cache", e2);
                }
            }
        }
        this.cacheFile = null;
        this.cdCache = null;
        this.lastModifiedTimes = null;
    }
}

