/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.PropertyResourceDescription;
import org.eclipse.equinox.ds.parser.ComponentElement;
import org.eclipse.equinox.ds.parser.ElementHandler;
import org.eclipse.equinox.ds.parser.ParserHandler;
import org.xml.sax.Attributes;

class PropertiesElement
extends ElementHandler {
    private ComponentElement parent;
    private PropertyResourceDescription properties;

    PropertiesElement(ParserHandler root, ComponentElement parent, Attributes attributes) {
        this.root = root;
        this.parent = parent;
        this.properties = new PropertyResourceDescription();
        this.processAttributes(attributes);
        if (this.properties.getEntry() == null) {
            root.logError("properties entry not specified");
        }
    }

    protected void handleAttribute(String name, String value) {
        if (name.equals("entry")) {
            this.properties.setEntry(value);
            return;
        }
        this.root.logError("unrecognized properties element attribute: " + name);
    }

    public void endElement(String uri, String localName, String qName) {
        ComponentDescription component = this.parent.getComponentDescription();
        component.addPropertyDescription(this.properties);
        this.root.setHandler(this.parent);
    }

    protected String getElementName() {
        return "properties";
    }
}

