/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.architecture;

import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class InstanceDescription {
    private String m_name;
    private HandlerDescription[] m_handlers = new HandlerDescription[0];
    private String[] m_createdObjects = new String[0];
    private int m_state;
    private long m_bundleId;
    private ComponentTypeDescription m_type;
    private InstanceDescription[] m_containedInstances = new InstanceDescription[0];

    public InstanceDescription(String name, int state, long bundleId, ComponentTypeDescription desc) {
        this.m_name = name;
        this.m_state = state;
        this.m_createdObjects = new String[0];
        this.m_handlers = new HandlerDescription[0];
        this.m_containedInstances = new InstanceDescription[0];
        this.m_bundleId = bundleId;
        this.m_type = desc;
    }

    public String getName() {
        return this.m_name;
    }

    public String[] getCreatedObjects() {
        return this.m_createdObjects;
    }

    public void setCreatedObjects(String[] objects) {
        this.m_createdObjects = objects;
    }

    public ComponentTypeDescription getComponentDescription() {
        return this.m_type;
    }

    public HandlerDescription[] getHandlers() {
        return this.m_handlers;
    }

    public void addHandler(HandlerDescription desc) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            if (this.m_handlers[i] != desc) continue;
            return;
        }
        HandlerDescription[] newHd = new HandlerDescription[this.m_handlers.length + 1];
        System.arraycopy(this.m_handlers, 0, newHd, 0, this.m_handlers.length);
        newHd[this.m_handlers.length] = desc;
        this.m_handlers = newHd;
    }

    public void addInstance(InstanceDescription inst) {
        for (int i = 0; i < this.m_containedInstances.length; ++i) {
            if (!this.m_containedInstances[i].getName().equals(inst.getName())) continue;
            return;
        }
        InstanceDescription[] newCi = new InstanceDescription[this.m_containedInstances.length + 1];
        System.arraycopy(this.m_containedInstances, 0, newCi, 0, this.m_containedInstances.length);
        newCi[this.m_containedInstances.length] = inst;
        this.m_containedInstances = newCi;
    }

    public void setState(int state) {
        this.m_state = state;
    }

    public int getState() {
        return this.m_state;
    }

    public long getBundleId() {
        return this.m_bundleId;
    }

    public InstanceDescription[] getContainedInstances() {
        return this.m_containedInstances;
    }

    public Element getDescription() {
        int i;
        Element instance = new Element("Instance", "");
        instance.addAttribute(new Attribute("name", this.getName()));
        if (this.m_state == 0) {
            instance.addAttribute(new Attribute("state", "stopped"));
        }
        if (this.m_state == 2) {
            instance.addAttribute(new Attribute("state", "valid"));
        }
        if (this.m_state == 1) {
            instance.addAttribute(new Attribute("state", "invalid"));
        }
        if (this.m_state == -1) {
            instance.addAttribute(new Attribute("state", "disposed"));
        }
        instance.addAttribute(new Attribute("bundle", Long.toString(this.m_bundleId)));
        instance.addAttribute(new Attribute("component.type", this.m_type.getName()));
        for (i = 0; i < this.m_handlers.length; ++i) {
            instance.addElement(this.m_handlers[i].getHandlerInfo());
        }
        for (i = 0; i < this.m_createdObjects.length; ++i) {
            Element obj = new Element("Object", "");
            obj.addAttribute(new Attribute("name", this.m_createdObjects[i].toString()));
            instance.addElement(obj);
        }
        if (this.m_containedInstances.length > 0) {
            Element inst = new Element("ContainedInstances", "");
            for (int i2 = 0; i2 < this.m_containedInstances.length; ++i2) {
                inst.addElement(this.m_containedInstances[i2].getDescription());
                instance.addElement(inst);
            }
        }
        return instance;
    }
}

