/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.config;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class KeyStores {
    private KeyStores() {
        new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String location, String type) throws GeneralSecurityException, IOException {
        if (location == null) {
            throw new NullPointerException("location cannot be null");
        }
        InputStream in = null;
        try {
            try {
                URL url = new URL(location);
                in = url.openStream();
            }
            catch (MalformedURLException e) {
                in = new FileInputStream(location);
            }
            in = new BufferedInputStream(in);
            KeyStore keystore = KeyStore.getInstance(type != null ? type : KeyStore.getDefaultType());
            keystore.load(in, null);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static X500Principal getX500Principal(String alias, KeyStore keystore) throws KeyStoreException {
        if (alias == null) {
            throw new NullPointerException("alias is null");
        }
        if (keystore == null) {
            throw new NullPointerException("keystore is null");
        }
        Certificate cert = keystore.getCertificate(alias);
        if (cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getSubjectX500Principal();
        }
        return null;
    }
}

