/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata.query;

import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;

public class UpdateQuery
extends MatchQuery {
    private IInstallableUnit updateFrom;

    public UpdateQuery(IInstallableUnit updateFrom) {
        this.updateFrom = updateFrom;
    }

    public boolean isMatch(Object candidate) {
        if (candidate instanceof IInstallableUnitPatch && !(this.updateFrom instanceof IInstallableUnitPatch)) {
            IInstallableUnitPatch potentialPatch = (IInstallableUnitPatch)candidate;
            IRequiredCapability lifeCycle = potentialPatch.getLifeCycle();
            if (lifeCycle == null) {
                return false;
            }
            return this.updateFrom.satisfies(lifeCycle);
        }
        IInstallableUnit candidateIU = (IInstallableUnit)candidate;
        IUpdateDescriptor descriptor = candidateIU.getUpdateDescriptor();
        if (descriptor != null && descriptor.isUpdateOf(this.updateFrom)) {
            if (!this.updateFrom.getId().equals(candidateIU.getId())) {
                return true;
            }
            return this.updateFrom.getVersion().compareTo((Object)candidateIU.getVersion()) < 0;
        }
        return false;
    }
}

