/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.PropertiesStringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesStringLookupTest {
    private static final String DOC_PATH = "src/test/resources/org/apache/commons/text/document.properties";
    private static final String KEY = "mykey";
    private static final String KEY_PATH = PropertiesStringLookup.toPropertyKey((String)"src/test/resources/org/apache/commons/text/document.properties", (String)"mykey");

    @Test
    public void testInterpolator() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace("${properties:" + KEY_PATH + "}"));
    }

    @Test
    public void testInterpolatorNestedColon() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        String replaced = stringSubstitutor.replace("$${properties:${sys:user.dir}/" + KEY_PATH + "}");
        Assertions.assertEquals((Object)("${properties:" + System.getProperty("user.dir") + "/src/test/resources/org/apache/commons/text/document.properties::mykey}"), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    public void testInterpolatorWithParameterizedKey() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KeyIsHere", KEY);
        StringSubstitutor stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String replaced = stringSubstitutor.replace("$${properties:" + PropertiesStringLookup.toPropertyKey((String)DOC_PATH, (String)"${KeyIsHere}}"));
        Assertions.assertEquals((Object)("${properties:" + PropertiesStringLookup.toPropertyKey((String)DOC_PATH, (String)"mykey}")), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    public void testInterpolatorWithParameterizedKey2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KeyIsHere", KEY);
        StringSubstitutor stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(map));
        String replaced = stringSubstitutor.replace("$${properties:${sys:user.dir}/" + PropertiesStringLookup.toPropertyKey((String)DOC_PATH, (String)"${KeyIsHere}}"));
        Assertions.assertEquals((Object)("${properties:" + System.getProperty("user.dir") + "/" + PropertiesStringLookup.toPropertyKey((String)DOC_PATH, (String)"mykey}")), (Object)replaced);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringSubstitutor.replace(replaced));
    }

    @Test
    public void testMissingFile() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertiesStringLookup.INSTANCE.lookup("MissingFile"));
    }

    @Test
    public void testMissingFileWithKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertiesStringLookup.INSTANCE.lookup(PropertiesStringLookup.toPropertyKey((String)"MissingFile", (String)"AnyKey")));
    }

    @Test
    public void testMissingKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertiesStringLookup.INSTANCE.lookup(DOC_PATH));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)PropertiesStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() {
        Assertions.assertEquals((Object)"Hello World!", (Object)PropertiesStringLookup.INSTANCE.lookup(KEY_PATH));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)PropertiesStringLookup.INSTANCE.toString().isEmpty());
    }
}

