/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.commands;

import java.util.Enumeration;
import megamek.client.Client;
import megamek.client.commands.ClientCommand;
import megamek.common.Entity;

public class ShowEntityCommand
extends ClientCommand {
    public ShowEntityCommand(Client client) {
        super(client, "entity", "print the information about a entity into the chat window. Ussage: #entity 5 whih would show the details for the entity numbered 5. Also #entity 5 0 would show location 0 of entity 5.");
    }

    public String run(String[] stringArray) {
        if (this.client.game.getOptions().booleanOption("double_blind")) {
            return "Sorry, this command is disabled during double blind.";
        }
        if (stringArray.length == 1) {
            String string = "List of all entities.\n";
            Enumeration<Entity> enumeration = this.client.getEntities();
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                string = string + entity.getId() + " " + entity.getOwner().getName() + "'s " + entity.getDisplayName() + "\n";
            }
            return string;
        }
        try {
            int n = Integer.parseInt(stringArray[1]);
            Entity entity = this.client.getEntity(n);
            if (entity != null) {
                if (stringArray.length > 2) {
                    String string = "";
                    for (int i = 2; i < stringArray.length; ++i) {
                        string = string + entity.statusToString(stringArray[i]);
                    }
                    return string;
                }
                return entity.statusToString();
            }
            return "No such entity.";
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return "Error parsing the command.";
    }
}

