/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.BipedMech;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mech;

public class BipedMechEncoder {
    public static void encode(Entity entity, Writer writer) throws IOException {
        Mech mech = (Mech)entity;
        if (null == entity) {
            throw new IllegalArgumentException("The entity is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<mascTurns value=\"");
        int n = mech.getMASCTurns();
        writer.write(String.valueOf(n));
        writer.write("\" /><mascUsed value=\"");
        writer.write(mech.isMASCUsed() ? "true" : "false");
        writer.write("\" />");
    }

    public static Entity decode(ParsedXML parsedXML, IGame iGame) {
        BipedMech bipedMech = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The BipedMech node is null.");
        }
        String string = parsedXML.getAttribute("name");
        if (!parsedXML.getName().equals("class") || null == string || !string.equals("BipedMech")) {
            throw new IllegalStateException("Not passed a BipedMech node.");
        }
        bipedMech = new BipedMech();
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            String string2 = parsedXML2.getName();
            if (null == string2) continue;
            if (string2.equals("mascTurns")) {
                int n;
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode the mascTurns for a BipedMech unit.");
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                bipedMech.setMASCTurns(n);
                continue;
            }
            if (!string2.equals("mascUsed")) continue;
            string = parsedXML2.getAttribute("value");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode mascUsed for a BipedMech unit.");
            }
            if (!string.equals("true")) continue;
            bipedMech.setMASCUsed(true);
        }
        return bipedMech;
    }
}

