################################################################################
#
#    (C) Copyright IBM Corp. 2006 All Rights Reserved.
#
#    The source code for this program is not published or
#    otherwise divested of its trade secrets, irrespective of
#    what has been deposited with the U.S. Copyright Office.
#
################################################################################

function usage
{
  if [[ -n ${flag_debug} ]]
  then
    set -x
  fi

  echo "Usage: exposeFastBackSnapshot.sh -i [IP Address] -u [user name] -p [user password] "
  echo "                                 -T [target drive] -P [Policy name] -A [Snapshot date] -V [Snapshot Volume] "
  echo "                                 -S [Snapshot Server] -R [Repository] -t [iscsi target] "
  echo "                                 -D [Domain] -w [path] -U [User] -v -h -f [path/configFileName] "
  echo ""
  echo "  -i    [Required] IP Address of FastBackShell installation. "
  echo "  -u    [Required] FastBack User Name to authenticat with Fastback shell with. "
  echo "  -p    [Required] FastBack User Name password to authenticat with Fastback shell with. "
  echo "  -D    [Optional] FastBack Server Domain. Default is \"xpress-restore\". "
  echo "  -T    [Required or use -t ] Target Drive to mount the FastBack snapshot on. (ie G:\\) "
  echo "  -t    [Required or use -T ]ISCSI target to create"
  echo "  -P    [Required] Snapshot Policy Name "
  echo "  -A    [Required] Snapshot date (ie \"2009-Sep-01 15:00:01\")"
  echo "  -V    [Required] Snapshot Volume (ie C:\\)"
  echo "  -S    [Required] Snapshot Server. "
  echo "  -R    [Required] Snapshot repository. "
  echo "  -o    [Optional] stdout will also go to the filename specified."
  echo "  -f    [Optional] Path and filename of config file. If not set the default config file is used. "
  echo "  -w    [Optional] FastBackShell path. Default is \"/c/Program Files/Tivoli/TSM/FastBack/shell\". "
  echo "  -U    [Optional] Windows server User. Default is \"Administrator\". "
  echo "  -h    [Optional] Display this help. "
  echo "  -v    [Optional] Verbose. "
  echo ""
#  echo " EXIT Codes "
#  echo "========================= "
#  echo " 0   Success "
#  echo " 1   General Error Occured "
#  echo ""
}

function getTargetFromMountedSnapshot
{
  # Takes Snapshot info like: 'G:' is mount of [tc600-wi@workgroup]-['Policy First Policy'-'tc401-wi'-'C:' at 9/1/2009 3:00:01 PM]
  # and prints the Target like: G:

  infoToConvert=$1

  convertedRep=`echo ${infoToConvert} | awk -F "'" '{print $2}'`
  echo ${convertedRep}
}

function getReposFromMountedSnapshot
{
  # Takes Snapshot info like: 'G:' is mount of [tc600-wi@workgroup]-['Policy First Policy'-'tc401-wi'-'C:' at 9/1/2009 3:00:01 PM]
  # and prints the repository like: TC600-WI@WORKGROUP

  infoToConvert=$1

  typeset -u convertedRep
  convertedRep=`echo ${infoToConvert} | awk -F ']' '{print $1}' | awk -F '[' '{print $2}'`
  echo ${convertedRep}
}

function getPolicyFromMountedSnapshot
{
  # Takes Snapshot info like: 'G:' is mount of [tc600-wi@workgroup]-['Policy First Policy'-'tc401-wi'-'C:' at 9/1/2009 3:00:01 PM]
  # and prints the Policy like: POLICY FIRST POLICY

  infoToConvert=$1

  typeset -u convertedRep
  convertedRep=`echo ${infoToConvert} | awk -F "[" '{print $3}' | awk -F "'" '{print $2}'`
  echo ${convertedRep}
}

function getServerFromMountedSnapshot
{
  # Takes Snapshot info like: 'G:' is mount of [tc600-wi@workgroup]-['Policy First Policy'-'tc401-wi'-'C:' at 9/1/2009 3:00:01 PM]
  # and prints the Server like: TC401-WI

  infoToConvert=$1

  typeset -u convertedRep
  convertedRep=`echo ${infoToConvert} | awk -F "[" '{print $3}' | awk -F "'" '{print $4}'`
  echo ${convertedRep}
}

function getVolumeFromMountedSnapshot
{
  # Takes Snapshot info like: 'G:' is mount of [tc600-wi@workgroup]-['Policy First Policy'-'tc401-wi'-'C:' at 9/1/2009 3:00:01 PM]
  # and prints the Volume like: C:

  infoToConvert=$1

  typeset -u convertedRep
  convertedRep=`echo ${infoToConvert} | awk -F "[" '{print $3}' | awk -F "'" '{print $6}' | awk -F ":" '{print $1}'`
  echo ${convertedRep}
}

function getDateFromMountedSnapshot
{
  # Takes Snapshot info like: 'G:' is mount of [tc600-wi@workgroup]-['Policy First Policy'-'tc401-wi'-'C:' at 9/1/2009 3:00:01 PM]
  # and prints the Date like: 9/1/2009 3:00:01 PM

  infoToConvert=$1

  typeset -u convertedRep
  convertedRep=`echo ${infoToConvert} | awk -F "[" '{print $3}' | awk -F "'" '{print $7}' | awk -F "at" '{print $2}' | awk -F "]" '{print $1}'`
  date -d "${convertedRep}"
}

config_commandFile=`whence $0`
config_configFile=`dirname ${config_commandFile}`/configFile

. `dirname ${config_commandFile}`/commonFunctions

loadConfigFile

while getopts dhvi:u:p:T:t:P:A:V:S:R:D:Z:Q:o:f:w:U: c 2> /dev/null
do
  case $c in
    i) config_FBSIPAddr=${OPTARG};;
    u) config_FBSUserName=${OPTARG};;
    p) config_FBSUserNamePasswd=${OPTARG};;
    T) config_FBSSnapshotTarget=${OPTARG};;
    t) config_FBSISCSITarget=${OPTARG};;
    P) config_FBSSnapshotPolicy=${OPTARG};;
    A) config_FBSSnapshotDate=${OPTARG};;
    V) config_FBSSnapshotVolume=${OPTARG};;
    S) config_FBSSnapshotServer=${OPTARG};;
    R) config_FBSSnapshotRepos=${OPTARG};;
    D) config_FBSDomain=${OPTARG};;
    Z) config_shareRepository_forTSM=${OPTARG};;
    Q) config_shareRepName=${OPTARG};;
    d) set -x
       flag_debug=true;;
    h) usage
       exit;;
    v) flag_verbose=true;;
    o) config_outputFile=${OPTARG};;
    f) config_configFile=${OPTARG}
       loadConfigFile;;
    w) config_FBSDirectory=${OPTARG};;
    U) config_FBSWindowsUser=${OPTARG};;
    *) usage
       exit_print "Wrong Usage. Bad arg: $c" 1;;
  esac
done

if [[ -n ${config_outputFile} ]]
then
  if ! touch ${config_outputFile} > /dev/null 2>&1
  then
    exit_print " Output File ${config_outputFile} is not writable." 24
  fi
  if [[ -d ${config_outputFile} ]]
  then
    exit_print " Output File ${config_outputFile} is a existing directory." 49
  fi
  echo -e "" > ${config_outputFile}
fi

if [[ -z ${config_FBSIPAddr} ]]
then
  exit_print_wFile " You must provide a IP address of the FastBackShell Windows server." 20
fi

if [[ -z ${config_FBSUserName} ]]
then
  exit_print_wFile " You must provide a username for the FastBackShell Windows server." 21
fi

if [[ -z ${config_FBSUserNamePasswd} ]]
then
  exit_print_wFile " You must provide a username password for the FastBackShell Windows server." 22
fi

if [[ -z ${config_FBSSnapshotTarget} && -z ${config_FBSISCSITarget} ]]
then
  exit_print_wFile " You must provide a target disk or a ISCSI target name." 27
fi

if [[ -n ${config_FBSSnapshotTarget} && -n ${config_FBSISCSITarget} ]]
then
  exit_print_wFile " You must provide a target disk or a ISCSI target name. Not both" 28
fi

if [[ -z ${config_FBSSnapshotPolicy} ]]
then
  exit_print_wFile " You must provide a FastBack Snapshot Poicy Name" 29
fi

if [[ -z ${config_FBSSnapshotDate} ]]
then
  exit_print_wFile " You must provide a FastBack Snapshot Date" 30
fi

if [[ -z ${config_FBSSnapshotVolume} ]]
then
  exit_print_wFile " You must provide a FastBack Snapshot Volume" 31
fi

if [[ -z ${config_FBSSnapshotServer} ]]
then
  exit_print_wFile " You must provide a FastBack Snapshot Server" 32
fi

if [[ -n ${config_FBSSnapshotRepos} && -n ${config_shareRepository_forTSM} ]]
then
  exit print_wFile "You must provide either the -R or -Z option. Not both" 28
fi

if [[ -z ${config_FBSSnapshotRepos} && -z ${config_shareRepository_forTSM} ]]
then
  exit print_wFile "You must provide either the -R or -Z option." 28
fi

for i in `echo ${configVariableNameList}`
do
  export $i
done

verbose_print "Checking Local Dependancies"
config_OSPlatform=`getOSPlatform`
returnCode=$?
if [[ ${returnCode} = 10 ]]
then
  config_OSRedHat="true"
  config_MyInitiator=`cat /etc/iscsi/initiatorname.iscsi | grep -v ^# | grep InitiatorName= | head -n 1 | awk -F '=' '{print $2}'`
elif [[ ${returnCode} = 11 ]]
then
  config_OSSuSe10="true"
  config_MyInitiator=`cat /etc/iscsi/initiatorname.iscsi | grep -v ^# | grep InitiatorName= | head -n 1 | awk -F '=' '{print $2}'`
elif [[ ${returnCode} = 12 ]]
then
  config_OSSuSe11="true"
  config_MyInitiator=`cat /etc/iscsi/initiatorname.iscsi | grep -v ^# | grep InitiatorName= | head -n 1 | awk -F '=' '{print $2}'`
else
  exit_print_wFile "Unsupported OS Platform: ${config_OSPlatform}" 25
fi
checkLocalDependancies

verbose_print "Setting up r_FastBackShell.sh connection arguments"

variableList_connection="-i ${config_FBSIPAddr}"

if [[ -n ${flag_debug} ]]
then
  variableList_connection="${variableList} -d"
fi

if [[ -n ${flag_verbose} ]]
then
  variableList_connection="${variableList} -v"
fi

if [[ ! -z ${config_FBSWindowsUser} ]]
then
  variableList_connection="${variableList} -U ${config_FBSWindowsUser}"
fi

if [[ ! -z ${config_FBSDirectory} ]]
then
  variableList_conection="${variableList_connection} -w ${config_FBSDirectory}"
fi

commandDir=`dirname ${config_commandFile}`
command="${commandDir}/r_FastBackShell.sh ${variableList_connection} -c"

verbose_print "r_FastBackShell.sh connection arguments: ${command}"

if [[ -n ${config_FBSDomain} ]]
then
  fsbDomain=${config_FBSDomain}
else
  fsbDomain="xpress-restore"
fi

verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} set_connection mount_computer ${config_FBSIPAddr} \""
${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} set_connection mount_computer ${config_FBSIPAddr} "

verbose_print "Looking for previously mounted snapshot."
verbose_print "Requested Snapshot: ${config_FBSSnapshotRepos} ${config_FBSSnapshotPolicy} ${config_FBSSnapshotServer} ${config_FBSSnapshotVolume} ${config_FBSSnapshotDate}"

var_targetToMount=${config_FBSSnapshotTarget}
var_performMountOperation="true"

verbose_print "Checking if Last Snapshot was requested."
typeset -u var_tmpDate
var_tmpDate=${config_FBSSnapshotDate}
if [[ ${var_tmpDate} = "LAST SNAPSHOT" ]]
then
  verbose_print "Last Snapshot was requested. Getting real date."
  if [[ -n ${config_shareRepository_forTSM} ]]
  then
    dumpCommand="${commandDir}/getFastBackSnapshots.sh ${variableList_connection} -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -Q ${config_shareRepName} -Z \"\"${config_shareRepository_forTSM}\"\""
  else
    dumpCommand="${commandDir}/getFastBackSnapshots.sh ${variableList_connection} -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd}"
  fi
  verbose_print "Executing Command: \"${dumpCommand} \""
  ${dumpCommand} | {
    while read_null_lines
    do
      if echo ${REPLY} | grep -i "last snapshot" > /dev/null 2>&1
      then
        verbose_print "Found a Last SnapShot Line: ${REPLY}"
        verbose_print "Looking for Repository: ${config_FBSSnapshotRepos}"
        if echo ${REPLY} | grep "${config_FBSSnapshotRepos}" > /dev/null 2>&1
        then
          verbose_print "Repository: ${config_FBSSnapshotRepos} found in Line."
          verbose_print "Looking for Policy: ${config_FBSSnapshotPolicy}"
          if echo ${REPLY} | grep "${config_FBSSnapshotPolicy}" > /dev/null 2>&1
          then
            verbose_print "Policy: ${config_FBSSnapshotPolicy} found in Line."
            verbose_print "Looking for Server: ${config_FBSSnapshotServer}"
            if echo ${REPLY} | grep "${config_FBSSnapshotServer}" > /dev/null 2>&1
            then
              verbose_print "Server: ${config_FBSSnapshotServer} found in Line."
              verbose_print "Looking for Volume: ${config_FBSSnapshotVolume}"
              if echo ${REPLY} | grep "${config_FBSSnapshotVolume}" > /dev/null 2>&1
              then
                verbose_print "Volume: ${config_FBSSnapshotVolume} found in Line."
                config_FBSSnapshotDate=`echo ${REPLY} | awk '{print $(NF-3)" "$(NF-2)}'`
                verbose_print "Last SnapShot Date: ${config_FBSSnapshotDate}"
                tmpConfigVar_FoundLastSnapshotDate="true"
                break
              fi
            fi
          fi
        fi
      fi
    done

    if [[ -z ${tmpConfigVar_FoundLastSnapshotDate} ]]
    then
      exit_print_wFile " The requested snapshot does not exist  " 23
    fi
  }
fi

verbose_print "Executing FastbackShell Command to query mounted snapshots"

verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount view\""
${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount view" | {
  while read_null_lines
  do
    if echo ${REPLY} | grep "is mount of" > /dev/null 2>&1
    then
      verbose_print "Found Mounted Snapshot: ${REPLY}"
      verbose_print "  Mounted Repository: `getReposFromMountedSnapshot "${REPLY}"`"
      typeset -u tmpFBSSnapshotRepos
      tmpFBSSnapshotRepos=${config_FBSSnapshotRepos}
      verbose_print "Requested Repository: ${tmpFBSSnapshotRepos}"
      if [[ `getReposFromMountedSnapshot "${REPLY}"` = ${tmpFBSSnapshotRepos} ]]
      then
        verbose_print "Repository Matchced"
        verbose_print "  Mounted Policy: `getPolicyFromMountedSnapshot "${REPLY}"`"
        typeset -u tmpSnapshotPolicy
        tmpSnapshotPolicy=${config_FBSSnapshotPolicy}
        verbose_print "Requested Policy: ${tmpSnapshotPolicy}"
        if [[ `getPolicyFromMountedSnapshot "${REPLY}"` = ${tmpSnapshotPolicy} ]]
        then
          verbose_print "Policy Matchced"
          verbose_print "  Mounted Server: `getServerFromMountedSnapshot "${REPLY}"`"
          typeset -u tmpSnapshotServer
          tmpSnapshotServer=${config_FBSSnapshotServer}
          verbose_print "Requested Server: ${tmpSnapshotServer}"
          if [[ `getServerFromMountedSnapshot "${REPLY}"` = ${tmpSnapshotServer} ]]
          then
            verbose_print "Server Matchced"
            verbose_print "  Mounted Volume: `getVolumeFromMountedSnapshot "${REPLY}"`"
            typeset -u tmpSnapshotVolume
            tmpSnapshotVolume=`echo ${config_FBSSnapshotVolume} | awk -F ":" '{print $1}'`
            verbose_print "Requested Volume: ${tmpSnapshotVolume}"
            if [[ `getVolumeFromMountedSnapshot "${REPLY}"` = ${tmpSnapshotVolume} ]]
            then
              verbose_print "Volume Matched"
              verbose_print "  Mounted Date: `getDateFromMountedSnapshot "${REPLY}"`"
              tmpRequestedDate=`convertDate_one "${config_FBSSnapshotDate}"`
              verbose_print "Requested Date: `date -d "${tmpRequestedDate}"`"
              if [[ `getDateFromMountedSnapshot "${REPLY}"` = `date -d "${tmpRequestedDate}"` ]]
              then
                verbose_print "Date Matched"
                warn_print "The requested snapshot is already mounted on target: `getTargetFromMountedSnapshot "${REPLY}"`"
                var_targetToMount=`getTargetFromMountedSnapshot "${REPLY}"`
                var_performMountOperation="false"
              fi
            fi
          fi
        fi
      fi
    else
      verbose_print "Found informational output. Ignoring: ${REPLY}"
    fi
  done
}

if [[ ${var_performMountOperation} = "true" ]]
then
  verbose_print "Performing FastBack mount operation."
  verbose_print "Verify the requested target is not already in use."
  if [[ -z ${config_FBSDirectory} ]]
  then
    config_FBSDirectory="/c/Program Files/Tivoli/TSM/FastBack/shell"
    tmp_unset_config_FBSDirectory="true"
  fi
  if [[ -z ${config_FBSWindowsUser} ]]
  then
    config_FBSWindowsUser=Administrator
    tmp_unset_config_FBSWindowsUser="true"
  fi

  if ! executeRemoteCommand "mount" false
  then
    exit_print_wFile " \"mount\" command not sucessful on FastBack Server." 34
  fi

  executeRemoteCommand "mount" | {
    while read_null_lines
    do
      verbose_print "Found mounted file System: ${REPLY}"
      typeset -u mountedDrive
      mountedDrive=`echo ${REPLY} | awk -F ":" '{print $1}'`
      verbose_print "Found Mounted drive: ${mountedDrive}"
      typeset -u tmpSnapshotTarget
      tmpSnapshotVolume=`echo ${config_FBSSnapshotTarget} | awk -F ":" '{print $1}'`
      if [[ ${mountedDrive} = ${tmpSnapshotVolume} ]]
      then
        exit_print_wFile " The requested Snapshot Target: ${config_FBSSnapshotTarget} is already in use" 35
      fi
      verbose_print " Does not match requested target: ${config_FBSSnapshotTarget}"
    done
  }

  if [[ ! -z ${tmp_unset_config_FBSDirectory} ]]
  then
    unset config_FBSDirectory
  fi
  if [[ ! -z ${tmp_unset_config_FBSWindowsUser} ]]
  then
    unset config_FBSWindowsUser
  fi

  if [[ -n ${config_FBSISCSITarget} ]]
  then
    tmpTarget="\"ISCSI: target=${config_FBSISCSITarget} initiator=${config_MyInitiator}\""
  else
    tmpTarget=${config_FBSSnapshotTarget}
  fi

  verbose_print "Executing FastbackShell Command to mount snapshot"

  if [[ -n ${config_outputFile} ]]
  then
    if [[ -n ${config_shareRepository_forTSM} ]]
    then
    verbose_print "setting temp 1"
      tmpRepository="\"share: \\\\\\\\`echo ${config_shareRepository_forTSM} | awk '{print $1}'`\\\\${config_shareRepName} domain=`echo ${config_shareRepository_forTSM} | awk '{print $2}'`\""
      ${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount add -target ${tmpTarget} -policy \"${config_FBSSnapshotPolicy}\" -date \"${config_FBSSnapshotDate}\" -volume '${config_FBSSnapshotVolume}' -rep ${tmpRepository} -server ${config_FBSSnapshotServer} -login ${config_FBSUserName} -pass ${config_FBSUserNamePasswd} -domain ${fsbDomain} -ro" | tee ${config_outputFile}
      returnCode=$?
    else
    verbose_print "not setting temp 1"
      ${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount add -target ${tmpTarget} -policy \"${config_FBSSnapshotPolicy}\" -date \"${config_FBSSnapshotDate}\" -volume '${config_FBSSnapshotVolume}' -rep ${config_FBSSnapshotRepos} -server ${config_FBSSnapshotServer} -login ${config_FBSUserName} -pass ${config_FBSUserNamePasswd} -domain ${fsbDomain} -ro" | tee ${config_outputFile}
      returnCode=$?
    fi
  else
    if [[ -n ${config_shareRepository_forTSM} ]]
    then
     verbose_print "setting temp 2"
      tmpRepository="\"share: \\\\\\\\`echo ${config_shareRepository_forTSM} | awk '{print $1}'`\\\\${config_shareRepName}  domain=`echo ${config_shareRepository_forTSM} | awk '{print $2}'`\""
      ${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount add -target ${tmpTarget} -policy \"${config_FBSSnapshotPolicy}\" -date \"${config_FBSSnapshotDate}\" -volume '${config_FBSSnapshotVolume}' -rep ${tmpRepository} -server ${config_FBSSnapshotServer} -login ${config_FBSUserName} -pass ${config_FBSUserNamePasswd} -domain ${fsbDomain} -ro"
      returnCode=$?
    else
   verbose_print "Not setting temp 2"
      ${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount add -target ${tmpTarget} -policy \"${config_FBSSnapshotPolicy}\" -date \"${config_FBSSnapshotDate}\" -volume '${config_FBSSnapshotVolume}' -rep ${config_FBSSnapshotRepos} -server ${config_FBSSnapshotServer} -login ${config_FBSUserName} -pass ${config_FBSUserNamePasswd} -domain ${fsbDomain} -ro"
      returnCode=$?
    fi
  fi

  if [[ ! ${returnCode} = 0 ]]
  then
    exit_print_wFile " Error occured while Exposing Snapshots on FastBackServer. " ${returnCode}
  fi
fi

