/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.stream.Stream;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ParameterizedLevenshteinDistanceTest {
    public static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{0, "", "", 0}), Arguments.of((Object[])new Object[]{8, "aaapppp", "", 7}), Arguments.of((Object[])new Object[]{7, "aaapppp", "", 7}), Arguments.of((Object[])new Object[]{6, "aaapppp", "", -1}), Arguments.of((Object[])new Object[]{0, "b", "a", -1}), Arguments.of((Object[])new Object[]{0, "a", "b", -1}), Arguments.of((Object[])new Object[]{0, "aa", "aa", 0}), Arguments.of((Object[])new Object[]{2, "aa", "aa", 0}), Arguments.of((Object[])new Object[]{2, "aaa", "bbb", -1}), Arguments.of((Object[])new Object[]{3, "aaa", "bbb", 3}), Arguments.of((Object[])new Object[]{10, "aaaaaa", "b", 6}), Arguments.of((Object[])new Object[]{8, "aaapppp", "b", 7}), Arguments.of((Object[])new Object[]{4, "a", "bbb", 3}), Arguments.of((Object[])new Object[]{7, "aaapppp", "b", 7}), Arguments.of((Object[])new Object[]{3, "a", "bbb", 3}), Arguments.of((Object[])new Object[]{2, "a", "bbb", -1}), Arguments.of((Object[])new Object[]{2, "bbb", "a", -1}), Arguments.of((Object[])new Object[]{6, "aaapppp", "b", -1}), Arguments.of((Object[])new Object[]{1, "a", "bbb", -1}), Arguments.of((Object[])new Object[]{1, "bbb", "a", -1}), Arguments.of((Object[])new Object[]{1, "12345", "1234567", -1}), Arguments.of((Object[])new Object[]{1, "1234567", "12345", -1}), Arguments.of((Object[])new Object[]{1, "frog", "fog", 1}), Arguments.of((Object[])new Object[]{3, "fly", "ant", 3}), Arguments.of((Object[])new Object[]{7, "elephant", "hippo", 7}), Arguments.of((Object[])new Object[]{6, "elephant", "hippo", -1}), Arguments.of((Object[])new Object[]{7, "hippo", "elephant", 7}), Arguments.of((Object[])new Object[]{6, "hippo", "elephant", -1}), Arguments.of((Object[])new Object[]{8, "hippo", "zzzzzzzz", 8}), Arguments.of((Object[])new Object[]{8, "zzzzzzzz", "hippo", 8}), Arguments.of((Object[])new Object[]{1, "hello", "hallo", 1}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "frog", "fog", 1}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "fly", "ant", 3}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "elephant", "hippo", 7}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "hippo", "elephant", 7}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "hippo", "zzzzzzzz", 8}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "zzzzzzzz", "hippo", 8}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, "hello", "hallo", 1}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void test(Integer threshold, CharSequence left, CharSequence right, Integer distance) {
        Assertions.assertEquals((Integer)distance, (Integer)new LevenshteinDistance(threshold).apply(left, right));
    }
}

