/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MemberValuePair
extends ASTNode {
    public char[] name;
    public Expression value;
    public MethodBinding binding;

    public MemberValuePair(char[] token, int sourceStart, int sourceEnd, Expression value) {
        this.name = token;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.value = value;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        output.append(this.name).append(" = ");
        this.value.print(indent, output);
        return output;
    }

    public void resolveTypeExpecting(BlockScope scope, TypeBinding requiredType) {
        TypeBinding valueType;
        if (requiredType == null) {
            return;
        }
        if (this.value == null) {
            return;
        }
        this.value.setExpectedType(requiredType);
        if (this.value instanceof ArrayInitializer) {
            ArrayInitializer initializer = (ArrayInitializer)this.value;
            if (initializer.resolveTypeExpecting(scope, this.binding.returnType) != null) {
                initializer.binding = (ArrayBinding)this.binding.returnType;
                this.value.resolvedType = initializer.binding;
            }
        } else {
            this.value.resolveType(scope);
        }
        if ((valueType = this.value.resolvedType) == null) {
            return;
        }
        TypeBinding leafType = requiredType.leafComponentType();
        if (!(this.value.isConstantValueOfTypeAssignableToType(valueType, requiredType) || requiredType.isBaseType() && BaseTypeBinding.isWidening(requiredType.id, valueType.id) || valueType.isCompatibleWith(requiredType))) {
            if (!(requiredType.isArrayType() && requiredType.dimensions() == 1 && (this.value.isConstantValueOfTypeAssignableToType(valueType, leafType) || leafType.isBaseType() && BaseTypeBinding.isWidening(leafType.id, valueType.id)) || valueType.isCompatibleWith(leafType))) {
                scope.problemReporter().typeMismatchError(valueType, requiredType, this.value);
                return;
            }
        } else {
            scope.compilationUnitScope().recordTypeConversion(requiredType.leafComponentType(), valueType.leafComponentType());
            this.value.computeConversion(scope, requiredType, valueType);
        }
        switch (leafType.erasure().id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer initializer = (ArrayInitializer)this.value;
                    Expression[] expressions = initializer.expressions;
                    if (expressions == null) break;
                    int i = 0;
                    int max = expressions.length;
                    while (i < max) {
                        if (expressions[i].constant == ASTNode.NotAConstant) {
                            scope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expressions[i]);
                        }
                        ++i;
                    }
                    break;
                }
                if (this.value.constant != ASTNode.NotAConstant) break;
                scope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value);
                break;
            }
            case 16: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer initializer = (ArrayInitializer)this.value;
                    Expression[] expressions = initializer.expressions;
                    if (expressions == null) break;
                    int i = 0;
                    int max = expressions.length;
                    while (i < max) {
                        if (!(expressions[i] instanceof ClassLiteralAccess)) {
                            scope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, expressions[i]);
                        }
                        ++i;
                    }
                    break;
                }
                if (this.value instanceof ClassLiteralAccess) break;
                scope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, this.value);
                break;
            }
            default: {
                if (!leafType.isEnum() && !leafType.isAnnotationType()) break;
            }
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.value != null) {
            this.value.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope scope) {
        if (visitor.visit(this, scope) && this.value != null) {
            this.value.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

