/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.env;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;

public class AccessRestriction {
    private char[][] inclusionPatterns;
    private char[][] exclusionPatterns;
    protected String messageTemplate;
    AccessRestriction furtherRestriction;

    public AccessRestriction(String messageTemplate, char[][] inclusionPatterns, char[][] exclusionPatterns, AccessRestriction furtherRestriction) {
        this.messageTemplate = messageTemplate;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.furtherRestriction = furtherRestriction;
    }

    public boolean equals(Object object) {
        int i;
        int otherLength;
        int length;
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRestriction)) {
            return false;
        }
        AccessRestriction otherRestriction = (AccessRestriction)object;
        if (!this.messageTemplate.equals(otherRestriction.messageTemplate)) {
            return false;
        }
        if (this.inclusionPatterns != otherRestriction.inclusionPatterns) {
            length = this.inclusionPatterns == null ? 0 : this.inclusionPatterns.length;
            int n = otherLength = otherRestriction.inclusionPatterns == null ? 0 : otherRestriction.inclusionPatterns.length;
            if (length != otherLength) {
                return false;
            }
            i = 0;
            while (i < length) {
                if (!CharOperation.equals(this.inclusionPatterns[i], otherRestriction.inclusionPatterns[i])) {
                    return false;
                }
                ++i;
            }
        }
        if (this.exclusionPatterns != otherRestriction.exclusionPatterns) {
            length = this.exclusionPatterns == null ? 0 : this.exclusionPatterns.length;
            int n = otherLength = otherRestriction.exclusionPatterns == null ? 0 : otherRestriction.exclusionPatterns.length;
            if (length != otherLength) {
                return false;
            }
            i = 0;
            while (i < length) {
                if (!CharOperation.equals(this.exclusionPatterns[i], otherRestriction.exclusionPatterns[i])) {
                    return false;
                }
                ++i;
            }
        }
        if (this.furtherRestriction != otherRestriction.furtherRestriction) {
            if (this.furtherRestriction == null || otherRestriction.furtherRestriction == null) {
                return false;
            }
            if (!this.furtherRestriction.equals(otherRestriction.furtherRestriction)) {
                return false;
            }
        }
        return true;
    }

    public AccessRestriction getViolatedRestriction(char[] targetTypeName, char[] referringTypeName) {
        if ((this.inclusionPatterns != null || this.exclusionPatterns != null) && Util.isExcluded(targetTypeName, this.inclusionPatterns, this.exclusionPatterns, false)) {
            return this;
        }
        return this.furtherRestriction != null ? this.furtherRestriction.getViolatedRestriction(targetTypeName, referringTypeName) : null;
    }

    public char[][] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public char[][] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("AccessRestriction [includes:\"").append(CharOperation.concatWith(this.inclusionPatterns, '/')).append("\"][excludes:\"").append(CharOperation.concatWith(this.exclusionPatterns, '/')).append("\"][template:\"").append(this.messageTemplate).append("\"]");
        if (this.furtherRestriction != null) {
            buffer.append('\n').append(this.furtherRestriction);
        }
        return buffer.toString();
    }
}

