/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Unknown;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.generic.ClassGen;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.FieldGen;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.PUSH;
import org.aspectj.apache.bcel.generic.RETURN;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.annotation.AnnotationGen;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.CollectionUtil;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelShadow;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.Range;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.bcel.Utility;

public final class LazyClassGen {
    int highestLineNumber = 0;
    private SortedMap inlinedFiles = new TreeMap();
    private BcelObjectType myType;
    private ClassGen myGen;
    private ConstantPoolGen constantPoolGen;
    private List methodGens = new ArrayList();
    private List classGens = new ArrayList();
    private List annotations = new ArrayList();
    private int childCounter = 0;
    private InstructionFactory fact;
    private boolean isSerializable = false;
    private boolean hasSerialVersionUIDField = false;
    private boolean hasClinit = false;
    Map tjpFields = new HashMap();
    public static final ObjectType tjpType = new ObjectType("org.aspectj.lang.JoinPoint");
    public static final ObjectType staticTjpType = new ObjectType("org.aspectj.lang.JoinPoint$StaticPart");
    public static final ObjectType enclosingStaticTjpType = new ObjectType("org.aspectj.lang.JoinPoint$EnclosingStaticPart");
    private static final ObjectType sigType = new ObjectType("org.aspectj.lang.Signature");
    private static final ObjectType factoryType = new ObjectType("org.aspectj.runtime.reflect.Factory");
    private static final ObjectType classType = new ObjectType("java.lang.Class");

    void addInlinedSourceFileInfo(String fullpath, int highestLineNumber) {
        Object o = this.inlinedFiles.get(fullpath);
        if (o != null) {
            InlinedSourceFileInfo info = (InlinedSourceFileInfo)o;
            if (info.highestLineNumber < highestLineNumber) {
                info.highestLineNumber = highestLineNumber;
            }
        } else {
            this.inlinedFiles.put(fullpath, new InlinedSourceFileInfo(highestLineNumber));
        }
    }

    void calculateSourceDebugExtensionOffsets() {
        int i = LazyClassGen.roundUpToHundreds(this.highestLineNumber);
        Iterator iter = this.inlinedFiles.values().iterator();
        while (iter.hasNext()) {
            InlinedSourceFileInfo element = (InlinedSourceFileInfo)iter.next();
            element.offset = i;
            i = LazyClassGen.roundUpToHundreds(i + element.highestLineNumber);
        }
    }

    private static int roundUpToHundreds(int i) {
        return (i / 100 + 1) * 100;
    }

    int getSourceDebugExtensionOffset(String fullpath) {
        return ((InlinedSourceFileInfo)this.inlinedFiles.get((Object)fullpath)).offset;
    }

    private Unknown getSourceDebugExtensionAttribute() {
        int nameIndex = this.constantPoolGen.addUtf8("SourceDebugExtension");
        String data = this.getSourceDebugExtensionString();
        byte[] bytes = Utility.stringToUTF(data);
        int length = bytes.length;
        return new Unknown(nameIndex, length, bytes, this.constantPoolGen.getConstantPool());
    }

    private String getSourceDebugExtensionString() {
        Object element;
        StringBuffer out = new StringBuffer();
        String myFileName = this.getFileName();
        out.append("SMAP\n");
        out.append(myFileName);
        out.append("\nAspectJ\n");
        out.append("*S AspectJ\n");
        out.append("*F\n");
        out.append("1 ");
        out.append(myFileName);
        out.append("\n");
        int i = 2;
        Iterator<Object> iter = this.inlinedFiles.keySet().iterator();
        while (iter.hasNext()) {
            element = (String)iter.next();
            int ii = ((String)element).lastIndexOf(47);
            if (ii == -1) {
                out.append(i++);
                out.append(' ');
                out.append((String)element);
                out.append('\n');
                continue;
            }
            out.append("+ ");
            out.append(i++);
            out.append(' ');
            out.append(((String)element).substring(ii + 1));
            out.append('\n');
            out.append((String)element);
            out.append('\n');
        }
        out.append("*L\n");
        out.append("1#1,");
        out.append(this.highestLineNumber);
        out.append(":1,1\n");
        i = 2;
        iter = this.inlinedFiles.values().iterator();
        while (iter.hasNext()) {
            element = (InlinedSourceFileInfo)iter.next();
            out.append("1#");
            out.append(i++);
            out.append(',');
            out.append(((InlinedSourceFileInfo)element).highestLineNumber);
            out.append(":");
            out.append(((InlinedSourceFileInfo)element).offset + 1);
            out.append(",1\n");
        }
        out.append("*E\n");
        return out.toString();
    }

    public static void disassemble(String path, String name, PrintStream out) throws IOException {
        if (null == out) {
            return;
        }
        BcelWorld world = new BcelWorld(path);
        LazyClassGen clazz = new LazyClassGen(BcelWorld.getBcelObjectType(world.resolve(name)));
        clazz.print(out);
        out.println();
    }

    public int getNewGeneratedNameTag() {
        return this.childCounter++;
    }

    public LazyClassGen(String class_name, String super_class_name, String file_name, int access_flags, String[] interfaces) {
        this.myGen = new ClassGen(class_name, super_class_name, file_name, access_flags, interfaces);
        this.constantPoolGen = this.myGen.getConstantPool();
        this.fact = new InstructionFactory(this.myGen, this.constantPoolGen);
    }

    public LazyClassGen(BcelObjectType myType) {
        int i;
        Object[] methods;
        this.myGen = new ClassGen(myType.getJavaClass());
        this.constantPoolGen = this.myGen.getConstantPool();
        this.fact = new InstructionFactory(this.myGen, this.constantPoolGen);
        this.myType = myType;
        if (TypeX.SERIALIZABLE.isAssignableFrom(this.getType(), this.getType().getWorld())) {
            this.isSerializable = true;
            this.hasSerialVersionUIDField = LazyClassGen.hasSerialVersionUIDField(this.getType());
            methods = this.getType().getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                Object method = methods[i];
                if (!((Member)method).getName().equals("<clinit>")) continue;
                this.hasClinit = true;
            }
        }
        methods = this.myGen.getMethods();
        for (i = 0; i < methods.length; ++i) {
            this.addMethodGen(new LazyMethodGen((Method)methods[i], this));
        }
    }

    public static boolean hasSerialVersionUIDField(ResolvedTypeX type) {
        ResolvedMember[] fields = type.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            ResolvedMember field = fields[i];
            if (!field.getName().equals("serialVersionUID") || !field.isStatic() || !field.getType().equals(ResolvedTypeX.LONG)) continue;
            return true;
        }
        return false;
    }

    public String getInternalClassName() {
        return this.getConstantPoolGen().getConstantPool().getConstantString(this.myGen.getClassNameIndex(), (byte)7);
    }

    public String getInternalFileName() {
        String str = this.getInternalClassName();
        int index = str.lastIndexOf(47);
        if (index == -1) {
            return this.getFileName();
        }
        return str.substring(0, index + 1) + this.getFileName();
    }

    public File getPackagePath(File root) {
        String str = this.getInternalClassName();
        int index = str.lastIndexOf(47);
        if (index == -1) {
            return root;
        }
        return new File(root, str.substring(0, index));
    }

    public String getClassId() {
        String str = this.getInternalClassName();
        int index = str.lastIndexOf(47);
        if (index == -1) {
            return str;
        }
        return str.substring(index + 1);
    }

    public void addMethodGen(LazyMethodGen gen) {
        this.methodGens.add(gen);
        if (this.highestLineNumber < gen.highestLineNumber) {
            this.highestLineNumber = gen.highestLineNumber;
        }
    }

    public void addMethodGen(LazyMethodGen gen, ISourceLocation sourceLocation) {
        this.addMethodGen(gen);
        if (!gen.getMethod().isPrivate()) {
            this.warnOnAddedMethod(gen.getMethod(), sourceLocation);
        }
    }

    public void errorOnAddedField(Field field, ISourceLocation sourceLocation) {
        if (this.isSerializable && !this.hasSerialVersionUIDField) {
            this.getWorld().getLint().serialVersionUIDBroken.signal(new String[]{this.myType.getResolvedTypeX().getName().toString(), field.getName()}, sourceLocation, null);
        }
    }

    public void warnOnAddedInterface(String name, ISourceLocation sourceLocation) {
        this.warnOnModifiedSerialVersionUID(sourceLocation, "added interface " + name);
    }

    public void warnOnAddedMethod(Method method, ISourceLocation sourceLocation) {
        this.warnOnModifiedSerialVersionUID(sourceLocation, "added non-private method " + method.getName());
    }

    public void warnOnAddedStaticInitializer(Shadow shadow, ISourceLocation sourceLocation) {
        if (!this.hasClinit) {
            this.warnOnModifiedSerialVersionUID(sourceLocation, "added static initializer");
        }
    }

    public void warnOnModifiedSerialVersionUID(ISourceLocation sourceLocation, String reason) {
        if (this.isSerializable && !this.hasSerialVersionUIDField) {
            this.getWorld().getLint().needsSerialVersionUIDField.signal(new String[]{this.myType.getResolvedTypeX().getName().toString(), reason}, sourceLocation, null);
        }
    }

    public World getWorld() {
        return this.myType.getResolvedTypeX().getWorld();
    }

    public List getMethodGens() {
        return this.methodGens;
    }

    public Field[] getFieldGens() {
        return this.myGen.getFields();
    }

    public List getAnnotations() {
        return this.annotations;
    }

    private void writeBack(BcelWorld world) {
        if (this.getConstantPoolGen().getSize() > Short.MAX_VALUE) {
            this.reportClassTooBigProblem();
            return;
        }
        if (this.annotations.size() > 0) {
            Iterator iter = this.annotations.iterator();
            while (iter.hasNext()) {
                AnnotationGen element = (AnnotationGen)iter.next();
                this.myGen.addAnnotation(element);
            }
        }
        this.myGen.addAttribute(BcelAttributes.bcelAttribute(new AjAttribute.WeaverVersionInfo(), this.getConstantPoolGen()));
        if (this.myType != null && this.myType.getWeaverState() != null) {
            this.myGen.addAttribute(BcelAttributes.bcelAttribute(new AjAttribute.WeaverState(this.myType.getWeaverState()), this.getConstantPoolGen()));
        }
        this.addAjcInitializers();
        int len = this.methodGens.size();
        this.myGen.setMethods(new Method[0]);
        this.calculateSourceDebugExtensionOffsets();
        for (int i = 0; i < len; ++i) {
            LazyMethodGen gen = (LazyMethodGen)this.methodGens.get(i);
            if (this.isEmptyClinit(gen)) continue;
            this.myGen.addMethod(gen.getMethod());
        }
        if (this.inlinedFiles.size() != 0 && LazyClassGen.hasSourceDebugExtensionAttribute(this.myGen)) {
            world.showMessage(IMessage.WARNING, WeaverMessages.format("overwriteJSR45", this.getFileName()), null, null);
        }
    }

    private void reportClassTooBigProblem() {
        this.myGen = new ClassGen(this.myGen.getClassName(), this.myGen.getSuperclassName(), this.myGen.getFileName(), this.myGen.getAccessFlags(), this.myGen.getInterfaceNames());
        this.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("classTooBig", this.getClassName()), new SourceLocation(new File(this.myGen.getFileName()), 0), null);
    }

    private static boolean hasSourceDebugExtensionAttribute(ClassGen gen) {
        ConstantPoolGen pool = gen.getConstantPool();
        Attribute[] attrs = gen.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!"SourceDebugExtension".equals(((ConstantUtf8)pool.getConstant(attrs[i].getNameIndex())).getBytes())) continue;
            return true;
        }
        return false;
    }

    public JavaClass getJavaClass(BcelWorld world) {
        this.writeBack(world);
        return this.myGen.getJavaClass();
    }

    public void addGeneratedInner(LazyClassGen newClass) {
        this.classGens.add(newClass);
    }

    public void addInterface(TypeX typeX, ISourceLocation sourceLocation) {
        this.myGen.addInterface(typeX.getName());
        if (!typeX.equals(TypeX.SERIALIZABLE)) {
            this.warnOnAddedInterface(typeX.getName(), sourceLocation);
        }
    }

    public void setSuperClass(TypeX typeX) {
        this.myGen.setSuperclassName(typeX.getName());
    }

    public String getSuperClassname() {
        return this.myGen.getSuperclassName();
    }

    private List getClassGens() {
        ArrayList<LazyClassGen> ret = new ArrayList<LazyClassGen>();
        ret.add(this);
        ret.addAll(this.classGens);
        return ret;
    }

    public List getChildClasses(BcelWorld world) {
        if (this.classGens.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<UnwovenClassFile.ChildClass> ret = new ArrayList<UnwovenClassFile.ChildClass>();
        Iterator i = this.classGens.iterator();
        while (i.hasNext()) {
            LazyClassGen clazz = (LazyClassGen)i.next();
            byte[] bytes = clazz.getJavaClass(world).getBytes();
            String name = clazz.getName();
            int index = name.lastIndexOf(36);
            name = name.substring(index + 1);
            ret.add(new UnwovenClassFile.ChildClass(name, bytes));
        }
        return ret;
    }

    public String toString() {
        return this.toShortString();
    }

    public String toShortString() {
        String s = org.aspectj.apache.bcel.classfile.Utility.accessToString(this.myGen.getAccessFlags(), true);
        if (s != "") {
            s = s + " ";
        }
        s = s + org.aspectj.apache.bcel.classfile.Utility.classOrInterface(this.myGen.getAccessFlags());
        s = s + " ";
        s = s + this.myGen.getClassName();
        return s;
    }

    public String toLongString() {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        this.print(new PrintStream(s));
        return new String(s.toByteArray());
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        List classGens = this.getClassGens();
        Iterator iter = classGens.iterator();
        while (iter.hasNext()) {
            LazyClassGen element = (LazyClassGen)iter.next();
            element.printOne(out);
            if (!iter.hasNext()) continue;
            out.println();
        }
    }

    private void printOne(PrintStream out) {
        out.print(this.toShortString());
        out.print(" extends ");
        out.print(org.aspectj.apache.bcel.classfile.Utility.compactClassName(this.myGen.getSuperclassName(), false));
        int size = this.myGen.getInterfaces().length;
        if (size > 0) {
            out.print(" implements ");
            for (int i = 0; i < size; ++i) {
                out.print(this.myGen.getInterfaceNames()[i]);
                if (i >= size - 1) continue;
                out.print(", ");
            }
        }
        out.print(":");
        out.println();
        if (this.myType != null) {
            this.myType.printWackyStuff(out);
        }
        Field[] fields = this.myGen.getFields();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            out.print("  ");
            out.println(fields[i]);
        }
        List methodGens = this.getMethodGens();
        Iterator iter = methodGens.iterator();
        while (iter.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)iter.next();
            if (this.isEmptyClinit(gen)) continue;
            gen.print(out);
            if (!iter.hasNext()) continue;
            out.println();
        }
        out.println("end " + this.toShortString());
    }

    private boolean isEmptyClinit(LazyMethodGen gen) {
        if (!gen.getName().equals("<clinit>")) {
            return false;
        }
        for (InstructionHandle start = gen.getBody().getStart(); start != null; start = start.getNext()) {
            if (Range.isRangeHandle(start) || start.getInstruction() instanceof RETURN) {
                continue;
            }
            return false;
        }
        return true;
    }

    public ConstantPoolGen getConstantPoolGen() {
        return this.constantPoolGen;
    }

    public String getName() {
        return this.myGen.getClassName();
    }

    public boolean isWoven() {
        return this.myType.getWeaverState() != null;
    }

    public boolean isReweavable() {
        if (this.myType.getWeaverState() == null) {
            return false;
        }
        return this.myType.getWeaverState().isReweavable();
    }

    public Set getAspectsAffectingType() {
        if (this.myType.getWeaverState() == null) {
            return null;
        }
        return this.myType.getWeaverState().getAspectsAffectingType();
    }

    public WeaverStateInfo getOrCreateWeaverStateInfo() {
        WeaverStateInfo ret = this.myType.getWeaverState();
        if (ret != null) {
            return ret;
        }
        ret = new WeaverStateInfo();
        this.myType.setWeaverState(ret);
        return ret;
    }

    public InstructionFactory getFactory() {
        return this.fact;
    }

    public LazyMethodGen getStaticInitializer() {
        Iterator i = this.methodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)i.next();
            if (!gen.getName().equals("<clinit>")) continue;
            return gen;
        }
        LazyMethodGen clinit = new LazyMethodGen(8, Type.VOID, "<clinit>", new Type[0], CollectionUtil.NO_STRINGS, this);
        clinit.getBody().insert(InstructionConstants.RETURN);
        this.methodGens.add(clinit);
        return clinit;
    }

    public LazyMethodGen getAjcPreClinit() {
        Iterator i = this.methodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)i.next();
            if (!gen.getName().equals("ajc$preClinit")) continue;
            return gen;
        }
        LazyMethodGen ajcClinit = new LazyMethodGen(8, Type.VOID, "ajc$preClinit", new Type[0], CollectionUtil.NO_STRINGS, this);
        ajcClinit.getBody().insert(InstructionConstants.RETURN);
        this.methodGens.add(ajcClinit);
        this.getStaticInitializer().getBody().insert(Utility.createInvoke(this.getFactory(), ajcClinit));
        return ajcClinit;
    }

    public Field getTjpField(BcelShadow shadow, boolean isEnclosingJp) {
        Field ret = (Field)this.tjpFields.get(shadow);
        if (ret != null) {
            return ret;
        }
        int modifiers = 24;
        LazyMethodGen encMethod = shadow.getEnclosingMethod();
        boolean shadowIsInAroundAdvice = false;
        if (encMethod != null && encMethod.getName().startsWith("ajc$around")) {
            shadowIsInAroundAdvice = true;
        }
        modifiers = this.getType().isInterface() || shadowIsInAroundAdvice ? (modifiers |= 1) : (modifiers |= 2);
        ret = new FieldGen(modifiers, isEnclosingJp ? enclosingStaticTjpType : staticTjpType, "ajc$tjp_" + this.tjpFields.size(), this.getConstantPoolGen()).getField();
        this.addField(ret);
        this.tjpFields.put(shadow, ret);
        return ret;
    }

    private void addAjcInitializers() {
        if (this.tjpFields.size() == 0) {
            return;
        }
        InstructionList il = this.initializeAllTjps();
        this.getStaticInitializer().getBody().insert(il);
    }

    private InstructionList initializeAllTjps() {
        InstructionList list = new InstructionList();
        InstructionFactory fact = this.getFactory();
        list.append(fact.createNew(factoryType));
        list.append(InstructionFactory.createDup(1));
        list.append(new PUSH(this.getConstantPoolGen(), this.getFileName()));
        list.append(new PUSH(this.getConstantPoolGen(), this.getClassName()));
        list.append(fact.createInvoke("java.lang.Class", "forName", classType, new Type[]{Type.STRING}, (short)184));
        list.append(fact.createInvoke(factoryType.getClassName(), "<init>", Type.VOID, new Type[]{Type.STRING, classType}, (short)183));
        list.append(InstructionFactory.createStore(factoryType, 0));
        ArrayList entries = new ArrayList(this.tjpFields.entrySet());
        Collections.sort(entries, new Comparator(){

            public int compare(Object a, Object b) {
                Map.Entry ae = (Map.Entry)a;
                Map.Entry be = (Map.Entry)b;
                return ((Field)ae.getValue()).getName().compareTo(((Field)be.getValue()).getName());
            }
        });
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            this.initializeTjp(fact, list, (Field)entry.getValue(), (BcelShadow)entry.getKey());
        }
        return list;
    }

    private void initializeTjp(InstructionFactory fact, InstructionList list, Field field, BcelShadow shadow) {
        String factoryMethod;
        Member sig = shadow.getSignature();
        list.append(InstructionFactory.createLoad(factoryType, 0));
        list.append(new PUSH(this.getConstantPoolGen(), shadow.getKind().getName()));
        list.append(InstructionFactory.createLoad(factoryType, 0));
        list.append(new PUSH(this.getConstantPoolGen(), sig.getSignatureString(shadow.getWorld())));
        list.append(fact.createInvoke(factoryType.getClassName(), sig.getSignatureMakerName(), new ObjectType(sig.getSignatureType()), new Type[]{Type.STRING}, (short)182));
        list.append(Utility.createConstant(fact, shadow.getSourceLine()));
        if (staticTjpType.equals(field.getType())) {
            factoryMethod = "makeSJP";
        } else if (enclosingStaticTjpType.equals(field.getType())) {
            factoryMethod = "makeESJP";
        } else {
            throw new Error("should not happen");
        }
        list.append(fact.createInvoke(factoryType.getClassName(), factoryMethod, field.getType(), new Type[]{Type.STRING, sigType, Type.INT}, (short)182));
        list.append(fact.createFieldAccess(this.getClassName(), field.getName(), field.getType(), (short)179));
    }

    public ResolvedTypeX getType() {
        if (this.myType == null) {
            return null;
        }
        return this.myType.getResolvedTypeX();
    }

    public BcelObjectType getBcelObjectType() {
        return this.myType;
    }

    public String getFileName() {
        return this.myGen.getFileName();
    }

    private void addField(Field field) {
        this.myGen.addField(field);
    }

    public void addField(Field field, ISourceLocation sourceLocation) {
        this.addField(field);
        if (!field.isPrivate() || !field.isStatic() && !field.isTransient()) {
            this.errorOnAddedField(field, sourceLocation);
        }
    }

    public String getClassName() {
        return this.myGen.getClassName();
    }

    public boolean isInterface() {
        return this.myGen.isInterface();
    }

    public boolean isAbstract() {
        return this.myGen.isAbstract();
    }

    public LazyMethodGen getLazyMethodGen(Member m) {
        return this.getLazyMethodGen(m.getName(), m.getSignature());
    }

    public LazyMethodGen getLazyMethodGen(String name, String signature) {
        Iterator i = this.methodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)i.next();
            if (!gen.getName().equals(name) || !gen.getSignature().equals(signature)) continue;
            return gen;
        }
        throw new BCException("Class " + this.getName() + " does not have a method " + name + " with signature " + signature);
    }

    public void forcePublic() {
        this.myGen.setAccessFlags(Utility.makePublic(this.myGen.getAccessFlags()));
    }

    public boolean hasAnnotation(TypeX t) {
        AnnotationGen[] agens = this.myGen.getAnnotations();
        if (agens == null) {
            return false;
        }
        for (int i = 0; i < agens.length; ++i) {
            AnnotationGen gen = agens[i];
            if (!t.equals(TypeX.forSignature(gen.getTypeSignature()))) continue;
            return true;
        }
        return false;
    }

    public void addAnnotation(Annotation a) {
        if (!this.hasAnnotation(TypeX.forSignature(a.getTypeSignature()))) {
            this.annotations.add(new AnnotationGen(a, this.getConstantPoolGen(), true));
        }
    }

    static class InlinedSourceFileInfo {
        int highestLineNumber;
        int offset;

        InlinedSourceFileInfo(int highestLineNumber) {
            this.highestLineNumber = highestLineNumber;
        }
    }
}

