/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.osgi.framework.AdminPermission;

final class AdminPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 3226083842806530691L;
    private boolean hasElement = false;

    public void add(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.hasElement = true;
    }

    public boolean implies(Permission p) {
        return this.hasElement && p instanceof AdminPermission;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private boolean more;
            {
                this.more = AdminPermissionCollection.this.hasElement;
            }

            public boolean hasMoreElements() {
                return this.more;
            }

            public Object nextElement() {
                if (this.more) {
                    this.more = false;
                    return new AdminPermission();
                }
                throw new NoSuchElementException();
            }
        };
    }
}

