/**[txh]********************************************************************

  Copyright (c) 2001-2002 by Salvador E. Tropea

  Description: 
  That's the DOS low level mouse class.
  It have more than one driver inside that is selected externally.
  1) It can use a mouse callback or poll the mouse.
  2) It can let the mouse driver draw the cursor or do it in the class.
  
***************************************************************************/

#if defined(TVCompf_djgpp) && !defined(DOSMOUSE_HEADER_INCLUDED)
#define DOSMOUSE_HEADER_INCLUDED

class THWMouseDOS : public THWMouse
{
protected:
 THWMouseDOS() {};
 virtual ~THWMouseDOS();

 static void ShowDrv();
 static void HideDrv();
 static void ShowEmulate();
 static void HideEmulate();
 static void Suspend();
 static void Resume();
 static void GetEvent(MouseEventType &me);
 static void RegisterHandler(unsigned, void (*)());
 static void SetRange(ushort, ushort);
 static int  DrawMouseDummy(int x, int y);
 static int  DrawMouseEmulate(int x, int y);

 friend class TDisplayDOS;
 friend class TScreenDOS;

 // Specific for this driver:
 // Choose if the mouse will be emulated or the OS driver will draw it.
 // Must be called when mouse isn't visible.
 static void setEmulation(int emulate);
 // Sets the start of video memory (only needed for emulated mouse)
 static void setScreenBase(ulong base);
 // Functions used to draw the mouse in the driver
 static volatile void getMouseChar();
 static volatile void setMouseChar();
 static volatile void resetMouseChar();
 static volatile void showMouseChar();
 // Used to force a mouse draw by the driver when emulateMouse!=0
 //static volatile int  drawMouse(int x, int y);
 // Low level functions to save/restore mouse state of the OS
 static void biosRestoreState();
 static void biosSaveState();
 // Low level functions to save/restore "my" mouse state
 static int  biosRestoreMyState();
 static void biosSaveMyState();

 // Address of the start of video memory, use setScreenBase()
 static ulong  screenBase;
 // Variables needded to draw the mouse pointer in the driver:
 static ushort mouseChar;   // Character under pointer
 static int    lastX,lastY; // Position of the saved mouseChar
 static int    cols;        // Screen width, set by setRange
 // Variables used to save/restore mouse state
 static int    bufferSegment;
 static int    bufferSelector;
 static int    bufferSize;
 static int    bufferAllocated;
 static int    myBufferSegment;
 static int    myBufferSelector;
 static int    myBufferSize;
 static int    myBufferAllocated;
 // !=0 if the mouse will be drawn by the driver, use setEmulation()
 static char   emulateMouse;
 // Number of buttons, needed to restore it in resume
 static uchar  myButtonCount;

public:
 // Needed to initialize it.
 static void Init();
 static void DeInit();
 // Indicates if the initialization will install a Real Mode Callback to
 // hook the mouse. That's enabled by default when the OS isn't Win NT.
 // Set it to 0 before initialization to avoid hooking the mouse.
 static char   useMouseHandler;
 // This structure hold the mouse event generated by a mouse callback.
 static MouseEventType intEvent;
 // Nasty hack used by TEventQueue to read the interrupt information and
 // draw the mouse pointer
 static int getRMCB_InfoDraw(int &buttonPress);
};

#endif // DOSMOUSE_HEADER_INCLUDED


