/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ba extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ғәрәп";
        final String metaValue_hy = "әрмән";
        final String metaValue_bn = "бенгал";
        final String metaValue_ccp = "чакма";
        final String metaValue_chr = "чероки";
        final String metaValue_cop = "копт";
        final String metaValue_ka = "грузин";
        final String metaValue_el = "грек";
        final String metaValue_gu = "гуджарати";
        final String metaValue_jv = "ява";
        final String metaValue_ja = "япон";
        final String metaValue_km = "кхмер";
        final String metaValue_kn = "каннада";
        final String metaValue_ko = "корей";
        final String metaValue_lo = "лаос";
        final String metaValue_ml = "малаялам";
        final String metaValue_mn = "монгол";
        final String metaValue_nqo = "н’ко";
        final String metaValue_osa = "осейдж";
        final String metaValue_si = "сингал";
        final String metaValue_su = "сундан";
        final String metaValue_syr = "сүриә";
        final String metaValue_ta = "тамил";
        final String metaValue_te = "телугу";
        final String metaValue_th = "тай";
        final String metaValue_bo = "тибет";
        final String metaValue_vai = "ваи";
        final String metaValue_Zsye = "эмодзи";
        final Object[][] data = new Object[][] {
            { "001", "донъя" },
            { "002", "Африка" },
            { "003", "Төньяҡ Америка" },
            { "005", "Көньяҡ Америка" },
            { "009", "Океания" },
            { "011", "Көнбайыш Африка" },
            { "013", "Үҙәк Америка" },
            { "014", "Көнсығыш Африка" },
            { "015", "Төньяҡ Африка" },
            { "017", "Үҙәк Африка" },
            { "018", "Көньяҡ Африка" },
            { "019", "Америка" },
            { "021", "Төньяҡ Америка төбәге" },
            { "029", "Кариб бассейны" },
            { "030", "Көнсығыш Азия" },
            { "034", "Көньяҡ Азия" },
            { "035", "Көньяҡ-Көнсығыш Азия" },
            { "039", "Көньяҡ Европа" },
            { "053", "Австралазия" },
            { "054", "Меланезия" },
            { "057", "Микронезия төбәге" },
            { "061", "Полинезия" },
            { "142", "Азия" },
            { "143", "Үҙәк Азия" },
            { "145", "Көнбайыш Азия" },
            { "150", "Европа" },
            { "151", "Көнсығыш Европа" },
            { "154", "Төньяҡ Европа" },
            { "155", "Көнбайыш Европа" },
            { "202", "Тропик Африка" },
            { "419", "Латин Америка" },
            { "AC", "Асеншен утрауы" },
            { "AD", "Андорра" },
            { "AE", "Берләшкән Ғәрәп Әмирлектәре" },
            { "AF", "Афғанстан" },
            { "AG", "Антигуа һәм Барбуда" },
            { "AI", "Ангилья" },
            { "AL", "Албания" },
            { "AM", "Әрмәнстан" },
            { "AO", "Ангола" },
            { "AQ", "Антарктида" },
            { "AR", "Аргентина" },
            { "AS", "Америка Самоаһы" },
            { "AT", "Австрия" },
            { "AU", "Австралия" },
            { "AW", "Аруба" },
            { "AX", "Аланд утрауҙары" },
            { "AZ", "Әзербайжан" },
            { "BA", "Босния һәм Герцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Бельгия" },
            { "BF", "Буркина-Фасо" },
            { "BG", "Болгария" },
            { "BH", "Бәхрәйн" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Сен-Бартелеми" },
            { "BM", "Бермуд утрауҙары" },
            { "BN", "Бруней" },
            { "BO", "Боливия" },
            { "BQ", "Карибтағы Нидерланд" },
            { "BR", "Бразилия" },
            { "BS", "Багам утрауҙары" },
            { "BT", "Бутан" },
            { "BV", "Буве утрауы" },
            { "BW", "Ботсвана" },
            { "BY", "Беларусь" },
            { "BZ", "Белиз" },
            { "CA", "Канада" },
            { "CC", "Кокос утрауҙары" },
            { "CD", "Конго - Киншаса" },
            { "CF", "Үҙәк Африка Республикаһы" },
            { "CG", "Конго - Браззавиль" },
            { "CH", "Швейцария" },
            { "CI", "Кот-д’Ивуар" },
            { "CK", "Кук утрауҙары" },
            { "CL", "Чили" },
            { "CM", "Камерун" },
            { "CN", "Ҡытай" },
            { "CO", "Колумбия" },
            { "CP", "Клиппертон утрауы" },
            { "CQ", "Сарк" },
            { "CR", "Коста-Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо-Верде" },
            { "CW", "Кюрасао" },
            { "CX", "Раштыуа Утрауы" },
            { "CY", "Кипр" },
            { "CZ", "Чехия" },
            { "DE", "Германия" },
            { "DG", "Диего-Гарсия" },
            { "DJ", "Джибути" },
            { "DK", "Дания" },
            { "DM", "Доминика" },
            { "DO", "Доминикан Республикаһы" },
            { "DZ", "Алжир" },
            { "EA", "Сеута һәм Мелилья" },
            { "EC", "Эквадор" },
            { "EE", "Эстония" },
            { "EG", "Мысыр" },
            { "EH", "Көнбайыш Сахара" },
            { "ER", "Эритрея" },
            { "ES", "Испания" },
            { "ET", "Эфиопия" },
            { "EU", "Европа Берлеге" },
            { "EZ", "Еврозона" },
            { "FI", "Финляндия" },
            { "FJ", "Фиджи" },
            { "FK", "Фолкленд утрауҙары" },
            { "FM", "Микронезия" },
            { "FO", "Фарер утрауҙары" },
            { "FR", "Франция" },
            { "GA", "Габон" },
            { "GB", "Бөйөк Британия" },
            { "GD", "Гренада" },
            { "GE", "Грузия" },
            { "GF", "Француз Гвианаһы" },
            { "GG", "Гернси" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренландия" },
            { "GM", "Гамбия" },
            { "GN", "Гвинея" },
            { "GP", "Гваделупа" },
            { "GQ", "Экваториаль Гвинея" },
            { "GR", "Греция" },
            { "GS", "Көньяҡ Георгия һәм Көньяҡ Сандвич утрауҙары" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинея-Бисау" },
            { "GY", "Гайана" },
            { "HK", "Гонконг, Ҡытай МАР-ы" },
            { "HM", "Херд һәм Макдональд утрауҙары" },
            { "HN", "Гондурас" },
            { "HR", "Хорватия" },
            { "HT", "Гаити" },
            { "HU", "Венгрия" },
            { "IC", "Канар утрауҙары" },
            { "ID", "Индонезия" },
            { "IE", "Ирландия" },
            { "IL", "Израиль" },
            { "IM", "Мэн утрауы" },
            { "IN", "Һиндостан" },
            { "IO", "Британияның Һинд океанындағы биләмәһе" },
            { "IQ", "Ираҡ" },
            { "IR", "Иран" },
            { "IS", "Исландия" },
            { "IT", "Италия" },
            { "JE", "Джерси" },
            { "JM", "Ямайка" },
            { "JO", "Иордания" },
            { "JP", "Япония" },
            { "KE", "Кения" },
            { "KG", "Ҡырғыҙстан" },
            { "KH", "Камбоджа" },
            { "KI", "Кирибати" },
            { "KM", "Комор утрауҙары" },
            { "KN", "Сент-Китс һәм Невис" },
            { "KP", "Төньяҡ Корея" },
            { "KR", "Көньяҡ Корея" },
            { "KW", "Кувейт" },
            { "KY", "Кайман утрауҙары" },
            { "KZ", "Ҡаҙағстан" },
            { "LA", "Лаос" },
            { "LB", "Ливан" },
            { "LC", "Сент-Люсия" },
            { "LI", "Лихтенштейн" },
            { "LK", "Шри-Ланка" },
            { "LR", "Либерия" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латвия" },
            { "LY", "Ливия" },
            { "MA", "Марокко" },
            { "MC", "Монако" },
            { "MD", "Молдова" },
            { "ME", "Черногория" },
            { "MF", "Сен-Мартен" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалл утрауҙары" },
            { "MK", "Төньяҡ Македония" },
            { "ML", "Мали" },
            { "MM", "Мьянма (Бирма)" },
            { "MN", "Монголия" },
            { "MO", "Макао, Ҡытай МАР-ы" },
            { "MP", "Төньяҡ Мариан утрауҙары" },
            { "MQ", "Мартиника" },
            { "MR", "Мавритания" },
            { "MS", "Монтсеррат" },
            { "MT", "Мальта" },
            { "MU", "Маврикий" },
            { "MV", "Мальдив утрауҙары" },
            { "MW", "Малави" },
            { "MX", "Мексика" },
            { "MY", "Малайзия" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибия" },
            { "NC", "Яңы Каледония" },
            { "NE", "Нигер" },
            { "NF", "Норфолк утрауы" },
            { "NG", "Нигерия" },
            { "NI", "Никарагуа" },
            { "NL", "Нидерланд" },
            { "NO", "Норвегия" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуэ" },
            { "NZ", "Яңы Зеландия" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Француз Полинезияһы" },
            { "PG", "Папуа – Яңы Гвинея" },
            { "PH", "Филиппин" },
            { "PK", "Пакистан" },
            { "PL", "Польша" },
            { "PM", "Сен-Пьер һәм Микелон" },
            { "PN", "Питкэрн утрауҙары" },
            { "PR", "Пуэрто-Рико" },
            { "PS", "Фәләстин территориялары" },
            { "PT", "Португалия" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Тышҡы Океания" },
            { "RE", "Реюньон" },
            { "RO", "Румыния" },
            { "RS", "Сербия" },
            { "RU", "Рәсәй" },
            { "RW", "Руанда" },
            { "SA", "Сәғүд Ғәрәбстаны" },
            { "SB", "Соломон утрауҙары" },
            { "SC", "Сейшель утрауҙары" },
            { "SD", "Судан" },
            { "SE", "Швеция" },
            { "SG", "Сингапур" },
            { "SH", "Изге Елена утрауы" },
            { "SI", "Словения" },
            { "SJ", "Шпицберген һәм Ян-Майен" },
            { "SK", "Словакия" },
            { "SL", "Сьерра-Леоне" },
            { "SM", "Сан-Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомали" },
            { "SR", "Суринам" },
            { "SS", "Көньяҡ Судан" },
            { "ST", "Сан-Томе һәм Принсипи" },
            { "SV", "Сальвадор" },
            { "SX", "Синт-Мартен" },
            { "SY", "Сүриә" },
            { "SZ", "Эсватини" },
            { "TA", "Тристан-да-Кунья" },
            { "TC", "Төркс һәм Кайкос утрауҙары" },
            { "TD", "Чад" },
            { "TF", "Францияның Көньяҡ Биләмәләре" },
            { "TG", "Того" },
            { "TH", "Тайланд" },
            { "TJ", "Тажикстан" },
            { "TK", "Токелау" },
            { "TL", "Тимор-Лесте" },
            { "TM", "Төркмәнстан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Төркиә" },
            { "TT", "Тринидад һәм Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзания" },
            { "UA", "Украина" },
            { "UG", "Уганда" },
            { "UM", "АҠШ-ның ситтәге утрауҙары" },
            { "UN", "Берләшкән Милләттәр Ойошмаһы" },
            { "US", "Америка Ҡушма Штаттары" },
            { "UY", "Уругвай" },
            { "UZ", "Үзбәкстан" },
            { "VA", "Ватикан" },
            { "VC", "Сент-Винсент һәм Гренадиндар" },
            { "VE", "Венесуэла" },
            { "VG", "Британия Виргин утрауҙары" },
            { "VI", "АҠШ Виргин утрауҙары" },
            { "VN", "Вьетнам" },
            { "VU", "Вануату" },
            { "WF", "Уоллис һәм Футуна" },
            { "WS", "Самоа" },
            { "XA", "псевдоакценттар" },
            { "XB", "псевдо ике яҡлы" },
            { "XK", "Косово" },
            { "YE", "Йәмән" },
            { "YT", "Майотта" },
            { "ZA", "Көньяҡ Африка Республикаһы" },
            { "ZM", "Замбия" },
            { "ZW", "Зимбабве" },
            { "ZZ", "Билдәһеҙ төбәк" },
            { "aa", "афар" },
            { "ab", "абхаз" },
            { "af", "африкаанс" },
            { "ak", "акан" },
            { "am", "амхар" },
            { "an", "арагон" },
            { "ar", metaValue_ar },
            { "as", "ассам" },
            { "az", "әзербайжан" },
            { "ba", "башҡорт" },
            { "be", "белорус" },
            { "bg", "болгар" },
            { "bm", "бамбара" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "бретон" },
            { "bs", "босний" },
            { "ca", "каталан" },
            { "ce", "чечен" },
            { "co", "корсика" },
            { "cs", "чех" },
            { "cu", "сиркәү славян" },
            { "cv", "сыуаш" },
            { "cy", "валлий" },
            { "da", "дат" },
            { "de", "немец" },
            { "dv", "дивехи" },
            { "dz", "дзонг-кэ" },
            { "ee", "эве" },
            { "el", metaValue_el },
            { "en", "инглиз" },
            { "eo", "эсперанто" },
            { "es", "испан" },
            { "et", "эстон" },
            { "eu", "баск" },
            { "fa", "фарсы" },
            { "ff", "фула" },
            { "fi", "фин" },
            { "fo", "фарер" },
            { "fr", "француз" },
            { "fy", "көнбайыш фриз" },
            { "ga", "ирланд" },
            { "gd", "шотланд гэл" },
            { "gl", "галисий" },
            { "gn", "гуарани" },
            { "gu", metaValue_gu },
            { "gv", "мэн" },
            { "ha", "хауса" },
            { "he", "иврит" },
            { "hi", "һинди" },
            { "hr", "хорват" },
            { "ht", "гаити креол" },
            { "hu", "венгр" },
            { "hy", metaValue_hy },
            { "ia", "интерлингва" },
            { "id", "индонез" },
            { "ie", "интерлингве" },
            { "ig", "игбо" },
            { "ii", "сычуань и" },
            { "io", "идо" },
            { "is", "исланд" },
            { "it", "итальян" },
            { "iu", "инуктитут" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "ki", "кикуйю" },
            { "kk", "ҡаҙаҡ" },
            { "kl", "калааллисут" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "ks", "кашмири" },
            { "ku", "курманджи" },
            { "kw", "корн" },
            { "ky", "ҡырғыҙ" },
            { "la", "латин" },
            { "lb", "люксембург" },
            { "lg", "ганда" },
            { "ln", "лингала" },
            { "lo", metaValue_lo },
            { "lt", "литва" },
            { "lu", "луба-катанга" },
            { "lv", "латыш" },
            { "mg", "малагаси" },
            { "mi", "маори" },
            { "mk", "македон" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "маратхи" },
            { "ms", "малай" },
            { "mt", "мальта" },
            { "my", "бирма" },
            { "nb", "норвег букмол" },
            { "nd", "төньяҡ ндебеле" },
            { "ne", "непал" },
            { "nl", "нидерланд" },
            { "nn", "норвег нюнорск" },
            { "no", "норвег" },
            { "nr", "көньяҡ ндебеле" },
            { "nv", "навахо" },
            { "ny", "ньянджа" },
            { "oc", "окситан" },
            { "om", "оромо" },
            { "or", "одия" },
            { "os", "осетин" },
            { "pa", "панджаби" },
            { "pi", "пали" },
            { "pl", "поляк" },
            { "ps", "пушту" },
            { "pt", "португал" },
            { "qu", "кечуа" },
            { "rm", "романш" },
            { "rn", "рунди" },
            { "ro", "румын" },
            { "ru", "урыҫ" },
            { "rw", "киньяруанда" },
            { "sa", "санскрит" },
            { "sc", "сардин" },
            { "sd", "синдхи" },
            { "se", "төньяҡ саам" },
            { "sg", "санго" },
            { "si", metaValue_si },
            { "sk", "словак" },
            { "sl", "словен" },
            { "sn", "шона" },
            { "so", "сомали" },
            { "sq", "албан" },
            { "sr", "серб" },
            { "ss", "свати" },
            { "st", "көньяҡ сото" },
            { "su", metaValue_su },
            { "sv", "швед" },
            { "sw", "суахили" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "тажик" },
            { "th", metaValue_th },
            { "ti", "тигринья" },
            { "tk", "төркмән" },
            { "tn", "тсвана" },
            { "to", "тонга" },
            { "tr", "төрөк" },
            { "ts", "тсонга" },
            { "tt", "татар" },
            { "ug", "уйғыр" },
            { "uk", "украин" },
            { "ur", "урду" },
            { "uz", "үзбәк" },
            { "ve", "венда" },
            { "vi", "вьетнам" },
            { "vo", "волапюк" },
            { "wa", "валлон" },
            { "wo", "волоф" },
            { "xh", "коса" },
            { "yi", "идиш" },
            { "yo", "йоруба" },
            { "za", "чжуан" },
            { "zh", "ҡытай" },
            { "zu", "зулу" },
            { "agq", "агем" },
            { "ann", "оболо" },
            { "apc", "левант ғәрәп" },
            { "arn", "мапуче" },
            { "asa", "асу" },
            { "ast", "астурий" },
            { "bal", "балудж" },
            { "bas", "басаа" },
            { "bem", "бемба" },
            { "bew", "бетави" },
            { "bez", "бена" },
            { "bgc", "харьянви" },
            { "bgn", "көнбайыш белудж" },
            { "bho", "бходжпури" },
            { "blo", "ании" },
            { "blt", "тай дам" },
            { "bqi", "бәхтиәр" },
            { "brx", "бодо" },
            { "bss", "акоосе" },
            { "bua", "бүрәт" },
            { "byn", "блин" },
            { "cad", "каддо" },
            { "cch", "атсам" },
            { "ccp", metaValue_ccp },
            { "ceb", "себуано" },
            { "cgg", "чига" },
            { "cho", "чоктав" },
            { "chr", metaValue_chr },
            { "cic", "чикасо" },
            { "ckb", "үҙәк курд" },
            { "cop", metaValue_cop },
            { "csw", "һаҙлыҡлы кри" },
            { "dav", "таита" },
            { "dje", "зарма" },
            { "doi", "догри" },
            { "dsb", "түбәнге лужиц" },
            { "dua", "дуала" },
            { "dyo", "джола фоньи" },
            { "ebu", "эмбу" },
            { "ewo", "эвондо" },
            { "fil", "филиппин" },
            { "frc", "каджун француз" },
            { "frr", "төньяҡ фриз" },
            { "fur", "фриул" },
            { "gaa", "га" },
            { "gez", "геэз" },
            { "gsw", "швейцария немец" },
            { "guz", "гусии" },
            { "haw", "гавай" },
            { "hnj", "хмонг нджуа" },
            { "hsb", "үрге лужи" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "kaa", "ҡарағалпаҡ" },
            { "kab", "кабил" },
            { "kaj", "джу" },
            { "kam", "камба" },
            { "kcg", "тьяп" },
            { "kde", "маконде" },
            { "kea", "кабувердьяну" },
            { "kek", "кекчи" },
            { "ken", "кеньянг" },
            { "kgp", "каинганг" },
            { "khq", "койра Чиини" },
            { "kkj", "како" },
            { "kln", "календжин" },
            { "kok", "конкани" },
            { "kpe", "кпелле" },
            { "ksb", "шамбала" },
            { "ksf", "бафия" },
            { "ksh", "кёльн" },
            { "kxv", "куви" },
            { "lag", "ланги" },
            { "lij", "лигур" },
            { "lkt", "лакота" },
            { "lld", "ладин" },
            { "lmo", "ломбард" },
            { "lou", "луизиана креол" },
            { "lrc", "төньяҡ лури" },
            { "ltg", "латгал" },
            { "luo", "луо" },
            { "luy", "лухья" },
            { "lzz", "лаз" },
            { "mai", "майтхили" },
            { "mas", "масаи" },
            { "mdf", "мокша" },
            { "mer", "меру" },
            { "mfe", "морисьен" },
            { "mgh", "макуа-меетто" },
            { "mgo", "мета" },
            { "mhn", "мокено" },
            { "mic", "микмау" },
            { "mni", "манипури" },
            { "moh", "мохаук" },
            { "mua", "мунданг" },
            { "mul", "бер нисә тел" },
            { "mus", "мускоги" },
            { "mww", "хмонг дав" },
            { "myv", "эрзә" },
            { "mzn", "мазандеран" },
            { "nan", "мин нан ҡытай" },
            { "naq", "нама" },
            { "nds", "түбәнге немец" },
            { "nmg", "квасио" },
            { "nnh", "нгиембун" },
            { "nqo", metaValue_nqo },
            { "nso", "төньяҡ сото" },
            { "nus", "нуэр" },
            { "nyn", "ньянколе" },
            { "oka", "оканаган" },
            { "osa", metaValue_osa },
            { "pap", "папьяменто" },
            { "pcm", "нигерия пиджины" },
            { "pis", "пиджин" },
            { "pms", "пьемонт" },
            { "prg", "прус" },
            { "quc", "киче" },
            { "raj", "раджастхани" },
            { "rhg", "рохинджа" },
            { "rif", "риф" },
            { "rof", "ромбо" },
            { "rwk", "руа" },
            { "sah", "саха" },
            { "saq", "самбуру" },
            { "sat", "сантали" },
            { "sbp", "сангу" },
            { "scn", "сицилия" },
            { "sdh", "көньяҡ курд" },
            { "seh", "сена" },
            { "ses", "койраборо Сенни" },
            { "sgs", "самогит" },
            { "shi", "ташельхит" },
            { "shn", "шан" },
            { "sid", "сидамо" },
            { "skr", "сараиики" },
            { "sma", "көньяҡ саам" },
            { "smj", "луле саам" },
            { "smn", "инари саам" },
            { "sms", "сколт саам" },
            { "ssy", "сахо" },
            { "suz", "сунвар" },
            { "syr", metaValue_syr },
            { "szl", "силез" },
            { "teo", "тесо" },
            { "tig", "тигре" },
            { "tok", "токи пона" },
            { "tpi", "ток писин" },
            { "trv", "тароко" },
            { "trw", "торвали" },
            { "twq", "тасавак" },
            { "tyv", "тува" },
            { "tzm", "үҙәк атлас тамазигхт" },
            { "und", "билдәһеҙ тел" },
            { "vai", metaValue_vai },
            { "vec", "венет" },
            { "vmw", "макуа" },
            { "vun", "вунджо" },
            { "wae", "вальзер" },
            { "wal", "волайтта" },
            { "wbp", "вальпири" },
            { "xnr", "кангри" },
            { "xog", "сога" },
            { "yav", "янгбен" },
            { "yrl", "ньенгату" },
            { "yue", "кантональ" },
            { "zgh", "стандарт марокко тамазигхт" },
            { "zxx", "лингвистик йөкмәткеһеҙ" },
            { "Adlm", "адлам" },
            { "Aghb", "кавказ албан" },
            { "Ahom", "ахом" },
            { "Arab", metaValue_ar },
            { "Aran", "насталик" },
            { "Armi", "император арамей" },
            { "Armn", metaValue_hy },
            { "Avst", "авестий" },
            { "Bali", "бали" },
            { "Bamu", "бамум" },
            { "Bass", "басса Вах" },
            { "Batk", "батак" },
            { "Beng", metaValue_bn },
            { "Berf", "берия эрфе" },
            { "Bhks", "бхаиксуки" },
            { "Bopo", "бопомофо" },
            { "Brah", "брахми" },
            { "Brai", "брайль шрифты" },
            { "Bugi", "буги" },
            { "Buhd", "бухид" },
            { "Cakm", metaValue_ccp },
            { "Cans", "берҙәм Канада аборигендарҙың ижектәре" },
            { "Cari", "кари" },
            { "Cham", "чам" },
            { "Cher", metaValue_chr },
            { "Chrs", "хәрәзм" },
            { "Copt", metaValue_cop },
            { "Cpmn", "кипр-миной" },
            { "Cprt", "кипр" },
            { "Cyrl", "кириллица" },
            { "Cyrs", "иҫке сиркәү славян кириллицаһы" },
            { "Deva", "деванагари" },
            { "Diak", "дивес акуру" },
            { "Dogr", "догра" },
            { "Dsrt", "дезерет" },
            { "Dupl", "дюплойе ҡыҫҡа" },
            { "Egyp", "мысыр иероглифтары" },
            { "Elba", "эльбасан" },
            { "Elym", "элимай" },
            { "Ethi", "эфиоп" },
            { "Gara", "гараи" },
            { "Geor", metaValue_ka },
            { "Glag", "глаголица" },
            { "Gong", "гуньджала гонди" },
            { "Gonm", "масарам гонди" },
            { "Goth", "гот" },
            { "Gran", "грантха" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Gukh", "гурунг кхема" },
            { "Guru", "гурмукхи" },
            { "Hanb", "бопомофо менән хань" },
            { "Hang", "хангыль" },
            { "Hani", "хань (ҡытай иероглифтары)" },
            { "Hano", "хануну" },
            { "Hans", "ябайлаштырылған" },
            { "Hant", "традицион" },
            { "Hatr", "хатра" },
            { "Hebr", "йәһүд" },
            { "Hira", "хирагана" },
            { "Hluw", "анатолия иероглифтары" },
            { "Hmng", "пахау хмонг" },
            { "Hmnp", "ньякенг пуачуэ хмонг" },
            { "Hrkt", "япон ижектәре" },
            { "Hung", "иҫке венгр" },
            { "Ital", "иҫке итал" },
            { "Jamo", "джамо" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "кайа Ли" },
            { "Kana", "катакана" },
            { "Kawi", "кави" },
            { "Khar", "кхароштхи" },
            { "Khmr", metaValue_km },
            { "Khoj", "ходжки" },
            { "Kits", "кесе кидань" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Krai", "кират раи" },
            { "Kthi", "кайтхи" },
            { "Lana", "ланна" },
            { "Laoo", metaValue_lo },
            { "Latf", "фрактура латин" },
            { "Latg", "гэль латин" },
            { "Latn", "латиница" },
            { "Lepc", "лепча" },
            { "Limb", "лимбу" },
            { "Lina", "һыҙыҡлы А яҙмаһы" },
            { "Linb", "һыҙыҡлы Б яҙмаһы" },
            { "Lisu", "лису" },
            { "Lyci", "лики" },
            { "Lydi", "лидия" },
            { "Mahj", "махаджани" },
            { "Maka", "макасар" },
            { "Mand", "мандей" },
            { "Mani", "манихей" },
            { "Marc", "марсен" },
            { "Medf", "медефаидрин" },
            { "Mend", "менде" },
            { "Merc", "мероит курсивы" },
            { "Mero", "мероит" },
            { "Mlym", metaValue_ml },
            { "Modi", "моди" },
            { "Mong", metaValue_mn },
            { "Mroo", "мро" },
            { "Mtei", "мейтей майек" },
            { "Mult", "мултани" },
            { "Mymr", "мьянма" },
            { "Nagm", "наг мундари" },
            { "Nand", "нандинагари" },
            { "Narb", "иҫке төньяҡ ғәрәп" },
            { "Nbat", "набатей" },
            { "Newa", "нева" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "нюй-шу" },
            { "Ogam", "огам" },
            { "Olck", "ол чики" },
            { "Onao", "ол онал" },
            { "Orkh", "орхон" },
            { "Orya", "ория" },
            { "Osge", metaValue_osa },
            { "Osma", "осман" },
            { "Ougr", "боронғо уйғыр" },
            { "Palm", "пальмира" },
            { "Pauc", "пау чин хау" },
            { "Perm", "боронғо пермь" },
            { "Phag", "пагспа" },
            { "Phli", "пәһләүи" },
            { "Phlp", "псалтирь пәһләүи" },
            { "Phnx", "финикия" },
            { "Plrd", "поллард фонетикаһы" },
            { "Prti", "парфия" },
            { "Qaag", "завги" },
            { "Rjng", "реджанг" },
            { "Rohg", "ханифи" },
            { "Runr", "рун" },
            { "Samr", "самаритян" },
            { "Sarb", "иҫке Көньяҡ ғәрәп" },
            { "Saur", "саураштра" },
            { "Sgnw", "ым-ишара яҙыуы" },
            { "Shaw", "шавиан" },
            { "Shrd", "шарада" },
            { "Sidd", "сиддхам" },
            { "Sidt", "сидет" },
            { "Sind", "кхудавади" },
            { "Sinh", metaValue_si },
            { "Sogd", "соғҙи" },
            { "Sogo", "боронғо соғҙи" },
            { "Sora", "сора Сомпенг" },
            { "Soyo", "соёмбо" },
            { "Sund", metaValue_su },
            { "Sunu", "сунувар" },
            { "Sylo", "силоти Нагри" },
            { "Syrc", metaValue_syr },
            { "Syre", "эстрангело сүриә" },
            { "Syrj", "көнбайыш сүриә" },
            { "Syrn", "көнсығыш сүриә" },
            { "Tagb", "тагбанва" },
            { "Takr", "такри" },
            { "Tale", "тай Ле" },
            { "Talu", "яңы тай ле" },
            { "Taml", metaValue_ta },
            { "Tang", "тангут" },
            { "Tavt", "тай Вьет" },
            { "Tayo", "тай йо" },
            { "Telu", metaValue_te },
            { "Tfng", "тифинаг" },
            { "Tglg", "тагалог" },
            { "Thaa", "таана" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "тирхута" },
            { "Tnsa", "тангса" },
            { "Todr", "тодри" },
            { "Tols", "толонг сики" },
            { "Toto", "тото" },
            { "Tutg", "тулу-тигалари" },
            { "Ugar", "угарит" },
            { "Vaii", metaValue_vai },
            { "Vith", "виткучи" },
            { "Wara", "варанг кшити" },
            { "Wcho", "ванчо" },
            { "Xpeo", "иҫке фарсы" },
            { "Xsux", "шумер-аккад шына" },
            { "Yezi", "йәзид" },
            { "Yiii", "и" },
            { "Zanb", "занабазар" },
            { "Zinh", "вариҫләнгән" },
            { "Zmth", "математик билдәләү" },
            { "Zsye", metaValue_Zsye },
            { "Zsym", "символдар" },
            { "Zxxx", "яҙыуһыҙ" },
            { "Zyyy", "дөйөм" },
            { "Zzzz", "билдәһеҙ яҙыу" },
            { "de_AT", "немец (Австрия)" },
            { "de_CH", "немец (Швейцария)" },
            { "en_AU", "инглиз (Австралия)" },
            { "en_CA", "инглиз (Канада)" },
            { "en_GB", "инглиз (Британия)" },
            { "en_US", "инглиз (АҠШ)" },
            { "es_ES", "испан (Европа)" },
            { "es_MX", "испан (Мексика)" },
            { "fa_AF", "дари" },
            { "fr_CA", "француз (Канада)" },
            { "fr_CH", "француз (Швейцария)" },
            { "nl_BE", "фламанд" },
            { "pt_BR", "португал (Бразилия)" },
            { "pt_PT", "португал (Европа)" },
            { "ro_MD", "молдов" },
            { "sw_CD", "конго суахили" },
            { "%%1901", "традицион немец орфографияһы" },
            { "%%1994", "Стандартлаштырылған резия орфографияһы" },
            { "%%1996", "1996 йылғы немец орфографияһы" },
            { "ar_001", "әҙәби ғәрәп" },
            { "es_419", "испан (Латин Америкаһы)" },
            { "key.ca", "календарь" },
            { "key.cf", "валюта форматы" },
            { "key.co", "теҙеү тәртибе" },
            { "key.cu", "валюта" },
            { "key.em", "эмодзи күренеше" },
            { "key.hc", "сәғәт форматы (12 йәки 24 сәғәтлек)" },
            { "key.lb", "юл күсереү стиле" },
            { "key.lw", "һүҙҙәрҙе күсереү стиле" },
            { "key.ms", "үлсәү системаһы" },
            { "key.nu", "һандар" },
            { "key.ss", "ҡыҫҡартманан һуң һөйләмде бүлеү" },
            { "nds_NL", "түбәнге саксон" },
            { "%%BARLA", "Кабувердьяну (барлавенто диалект төркөмө)" },
            { "%%BISKE", "Сан-Джорджио/Била диалекты" },
            { "%%BOONT", "Бунтлинг" },
            { "%%KKCOR", "дөйөм орфография" },
            { "%%KSCOR", "Стандарт орфография" },
            { "%%LIPAW", "Резия (липоваз диалекты)" },
            { "%%NEDIS", "Натисоне диалекты" },
            { "%%NJIVA", "Гнива/Нива диалекты" },
            { "%%NULIK", "Хәҙерге волапюк" },
            { "%%OSOJS", "Осеакко/Осояне диалекты" },
            { "%%POSIX", "компьютер" },
            { "%%RIGIK", "Классик волапюк" },
            { "%%ROZAJ", "Резия" },
            { "%%SAAHO", "Сахо" },
            { "%%SOLBA", "столвиццо/солбица диалекты" },
            { "%%SOTAV", "Кабувердьяну (сотавенто диалект төркөмө)" },
            { "%%UCCOR", "берҙәм орфография" },
            { "hi_Latn", "һинди (латиница)" },
            { "zh_Hans", "ҡытай (ябайлаштырылған)" },
            { "zh_Hant", "ҡытай (традицион)" },
            { "%%NDYUKA", "Ндьюка диалекты" },
            { "%%PAMAKA", "Памака диалекты" },
            { "%%PINYIN", "пиньинь романизацияһы" },
            { "%%SCOUSE", "скаус" },
            { "%%TARASK", "тарашкевица орфографияһы" },
            { "%%UCRCOR", "берҙәм үҙгәртелгән орфография" },
            { "%%UNIFON", "унифон фонетик алфавиты" },
            { "%%ABL1943", "1943 йылғы орфографик формулировка" },
            { "%%BALANKA", "Ании (баланка диалекты)" },
            { "%%BOHORIC", "Богорич алфавиты" },
            { "%%HEPBURN", "Хепбёрн романлаштырыуы" },
            { "%%METELKO", "Метелько алфавиты" },
            { "%%MONOTON", "Монотоник" },
            { "%%POLYTON", "Политоник" },
            { "%%REVISED", "Үҙгәртелгән орфография" },
            { "%%1606NICT", "1606 йылға тиклемге һуңғы урта быуат француз теле" },
            { "%%1694ACAD", "Иртә яңы француз" },
            { "%%1959ACAD", "академик" },
            { "%%BAKU1926", "берҙәм төрки латин алфавиты" },
            { "%%IJEKAVSK", "Серб (иекав әйтелеше)" },
            { "%%OXENDICT", "Оксфорд инглиз һүҙлеге орфографияһы" },
            { "%%SCOTLAND", "шотланд стандарт инглиз теле" },
            { "%%VALENCIA", "Валенсия" },
            { "%%WADEGILE", "Уэйд-Джайлз романлаштырыуы" },
            { "type.ca.roc", "минго календары" },
            { "type.co.eor", "европа теҙеү ҡағиҙәләре" },
            { "type.hc.h11", "12 сәғәтлек формат (0–11)" },
            { "type.hc.h12", "12 сәғәтлек формат (1–12)" },
            { "type.hc.h23", "24 сәғәтлек формат (0–23)" },
            { "type.hc.h24", "24 сәғәтлек формат (1–24)" },
            { "type.nu.ahom", "ахом цифрҙары" },
            { "type.nu.arab", "ғәрәп-һинд цифрҙары" },
            { "type.nu.armn", "әрмән һандары" },
            { "type.nu.bali", "бали цифрҙары" },
            { "type.nu.beng", "бенгал цифрҙары" },
            { "type.nu.brah", "брахми цифрҙары" },
            { "type.nu.cakm", "чакма цифрҙары" },
            { "type.nu.cham", "чам цифрҙары" },
            { "type.nu.cyrl", "кириллица һандары" },
            { "type.nu.deva", "деванагари цифрҙары" },
            { "type.nu.diak", "дивес акуру цифрҙары" },
            { "type.nu.ethi", "эфиоп һандары" },
            { "type.nu.gara", "гарай цифрҙары" },
            { "type.nu.geor", "грузин цифрҙары" },
            { "type.nu.gong", "гунжала гонди цифрҙары" },
            { "type.nu.gonm", "масарам гонди цифрҙары" },
            { "type.nu.grek", "грек цифрҙары" },
            { "type.nu.gujr", "гуджарати цифрҙары" },
            { "type.nu.gukh", "гурунг кхема цифрҙары" },
            { "type.nu.guru", "гурмукхи цифрҙары" },
            { "type.nu.hans", "ябайлаштырылған ҡытай цифрҙары" },
            { "type.nu.hant", "традицион ҡытай һандары" },
            { "type.nu.hebr", "йәһүд һандары" },
            { "type.nu.hmng", "пахавх хмонг цифрҙары" },
            { "type.nu.hmnp", "ньякенг пуачуэ хмонг цифрҙары" },
            { "type.nu.java", "ява цифрҙары" },
            { "type.nu.jpan", "япон һандары" },
            { "type.nu.kali", "кайа ли цифрҙары" },
            { "type.nu.kawi", "кави цифрҙары" },
            { "type.nu.khmr", "кхмер цифрҙары" },
            { "type.nu.knda", "каннада цифрҙары" },
            { "type.nu.krai", "кират рай цифрҙары" },
            { "type.nu.lana", "тай тхам хора цифрҙары" },
            { "type.nu.laoo", "лаос цифрҙары" },
            { "type.nu.latn", "ғәрәп цифрҙары" },
            { "type.nu.lepc", "лепча цифрҙары" },
            { "type.nu.limb", "лимбу цифрҙары" },
            { "type.nu.mlym", "малаялам цифрҙары" },
            { "type.nu.modi", "моди цифрҙары" },
            { "type.nu.mong", "монгол цифрҙары" },
            { "type.nu.mroo", "мро цифрҙары" },
            { "type.nu.mtei", "мейтей майек цифрҙары" },
            { "type.nu.mymr", "мьянма цифрҙары" },
            { "type.nu.nagm", "наг мундари цифрҙары" },
            { "type.nu.nkoo", "н’ко цифрҙары" },
            { "type.nu.olck", "ол чики цифрҙары" },
            { "type.nu.onao", "ол онал цифрҙары" },
            { "type.nu.orya", "одиа цифрҙары" },
            { "type.nu.osma", "османия цифрҙары" },
            { "type.nu.rohg", "ханифи рохинджа цифрҙары" },
            { "type.nu.saur", "саураштра цифрҙары" },
            { "type.nu.shrd", "шарада цифрҙары" },
            { "type.nu.sind", "худавади цифрҙары" },
            { "type.nu.sinh", "сингал лит цифрҙары" },
            { "type.nu.sora", "сора сомпенг цифрҙары" },
            { "type.nu.sund", "сундан цифрҙары" },
            { "type.nu.sunu", "сунувар цифрҙары" },
            { "type.nu.takr", "такри цифрҙары" },
            { "type.nu.talu", "яңы тай луэ цифрҙары" },
            { "type.nu.taml", "традицион тамил цифрҙары" },
            { "type.nu.telu", "телугу цифрҙары" },
            { "type.nu.thai", "тай цифрҙары" },
            { "type.nu.tibt", "тибет цифрҙары" },
            { "type.nu.tirh", "тирхута цифрҙары" },
            { "type.nu.tnsa", "тангса цифрҙары" },
            { "type.nu.tols", "толонг сики цифрҙары" },
            { "type.nu.vaii", "ваи цифрҙары" },
            { "type.nu.wara", "варанг сити цифрҙары" },
            { "type.nu.wcho", "ванчо цифрҙары" },
            { "type.ca.dangi", "данги календары" },
            { "type.co.ducet", "Стандарт Unicode теҙеү тәртибе" },
            { "type.co.emoji", metaValue_Zsye },
            { "type.lb.loose", "йомшаҡ юл күсереү" },
            { "type.nu.roman", "рим һандары" },
            { "type.ca.coptic", "копт календары" },
            { "type.ca.hebrew", "йәһүд календары" },
            { "type.ca.indian", "Һиндостан милли календары" },
            { "type.co.compat", "элекке теҙеү тәртибе (ярашлылыҡ өсөн)" },
            { "type.co.pinyin", "пиньинь теҙеү тәртибе" },
            { "type.co.search", "дөйөм маҡсатлы эҙләү" },
            { "type.co.stroke", "һыҙыҡтар буйынса теҙеү тәртибе" },
            { "type.co.unihan", "радикал-һыҙыҡ теҙеү тәртибе" },
            { "type.co.zhuyin", "чжуинь теҙеү тәртибе" },
            { "type.lb.normal", "ғәҙәти юл күсереү" },
            { "type.lb.strict", "ҡаты юл күсереү" },
            { "type.ms.metric", "метрик система" },
            { "type.ca.chinese", "ҡытай календары" },
            { "type.ca.islamic", "һижри календарь" },
            { "type.ca.iso8601", "ISO-8601 календары" },
            { "type.ca.persian", "фарсы календары" },
            { "type.cf.account", "бухгалтер валюта форматы" },
            { "type.nu.arabext", "киңәйтелгән ғәрәп-һинд цифрҙары" },
            { "type.nu.armnlow", "әрмән бәләкәй һандары" },
            { "type.nu.greklow", "грек бәләкәй һандары" },
            { "type.nu.hanidec", "ҡытай унлы цифрҙары" },
            { "type.nu.hansfin", "ябайлаштырылған ҡытай финанс һандары" },
            { "type.nu.hantfin", "традицион ҡытай финанс һандары" },
            { "type.nu.jpanfin", "япон финанс һандары" },
            { "type.nu.mathdbl", "математик ике һыҙыҡлы цифрҙар" },
            { "type.nu.mymrpao", "мьянма пао цифрҙары" },
            { "type.nu.tamldec", "тамил цифрҙары" },
            { "type.ca.buddhist", "будда календары" },
            { "type.ca.ethiopic", "эфиоп календары" },
            { "type.ca.japanese", "япон календары" },
            { "type.cf.standard", "стандарт валюта форматы" },
            { "type.co.searchjl", "хангыль буйынса (баш тартынҡы менән) эҙләү" },
            { "type.co.standard", "ғәҙәти тәртип" },
            { "type.ms.uksystem", "Британия үлсәмдәр системаһы" },
            { "type.ms.ussystem", "АҠШ үлсәү системаһы" },
            { "type.nu.fullwide", "тулы киңлектәге һандар" },
            { "type.nu.lanatham", "тай тхам тхам цифрҙары" },
            { "type.nu.mathbold", "математик ҡалын цифрҙар" },
            { "type.nu.mathmono", "математик монокиңлектәге цифрҙар" },
            { "type.nu.mathsanb", "математик ҡырҡылмаған ҡалын цифрҙар" },
            { "type.nu.mathsans", "математик ҡырҡылмаған цифрҙар" },
            { "type.nu.mymrepka", "мьянма көнсығыш пво карен цифрҙары" },
            { "type.nu.mymrshan", "мьянма шан цифрҙары" },
            { "type.nu.mymrtlng", "мьянма тай лаинг цифрҙары" },
            { "type.nu.outlined", "контурлы цифрҙар" },
            { "type.nu.romanlow", "рим бәләкәй һандары" },
            { "type.ca.gregorian", "григориан календары" },
            { "type.co.phonebook", "телефон китабыса теҙеү тәртибе" },
            { "type.co.dictionary", "һүҙлексә теҙеү тәртибе" },
            { "type.co.traditional", "традицион теҙеү тәртибе" },
            { "type.ca.islamic-rgsa", "Һижри календарь (Сәғүд Ғәрәбстаны)" },
            { "type.ca.islamic-tbla", "һижри календарь (таблицалы, астрономик эпоха)" },
            { "type.ca.islamic-civil", "һижри календарь (таблицалы, граждандар эпохаһы)" },
            { "type.ca.islamic-umalqura", "һижри календарь (Үмм әл-Ҡура)" },
            { "type.ca.ethiopic-amete-alem", "эфиоп амете-алем календары" },
        };
        return data;
    }
}
