/*
 * Copyright (c) 2023 László Várady
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 */

#include "driver.h"
#include "cfg-parser.h"
#include "bigquery-grammar.h"

extern int bigquery_debug;

int bigquery_parse(CfgLexer *lexer, LogDriver **instance, gpointer arg);

static CfgLexerKeyword bigquery_keywords[] =
{
  { "bigquery", KW_BIGQUERY },
  { "url", KW_URL },
  { "project", KW_PROJECT },
  { "dataset", KW_DATASET },
  { "table", KW_TABLE },
  { "schema", KW_SCHEMA },
  { "protobuf_schema", KW_PROTOBUF_SCHEMA },
  { "batch_bytes", KW_BATCH_BYTES },
  { "compression", KW_COMPRESSION },
  { "keep_alive", KW_KEEP_ALIVE },
  { "time", KW_TIME },
  { "timeout", KW_TIMEOUT },
  { "max_pings_without_data", KW_MAX_PINGS_WITHOUT_DATA },
  { "channel_args", KW_CHANNEL_ARGS },
  { NULL }
};

CfgParser bigquery_parser =
{
#if SYSLOG_NG_ENABLE_DEBUG
  .debug_flag = &bigquery_debug,
#endif
  .name = "bigquery",
  .keywords = bigquery_keywords,
  .parse = (gint (*)(CfgLexer *, gpointer *, gpointer)) bigquery_parse,
  .cleanup = (void (*)(gpointer)) log_pipe_unref,
};

CFG_PARSER_IMPLEMENT_LEXER_BINDING(bigquery_, BIGQUERY_, LogDriver **)
