package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogMeta invokes the aegis.DescribeLogMeta API synchronously
// api document: https://help.aliyun.com/api/aegis/describelogmeta.html
func (client *Client) DescribeLogMeta(request *DescribeLogMetaRequest) (response *DescribeLogMetaResponse, err error) {
	response = CreateDescribeLogMetaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogMetaWithChan invokes the aegis.DescribeLogMeta API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelogmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogMetaWithChan(request *DescribeLogMetaRequest) (<-chan *DescribeLogMetaResponse, <-chan error) {
	responseChan := make(chan *DescribeLogMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogMetaWithCallback invokes the aegis.DescribeLogMeta API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelogmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogMetaWithCallback(request *DescribeLogMetaRequest, callback func(response *DescribeLogMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogMetaResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogMetaRequest is the request struct for api DescribeLogMeta
type DescribeLogMetaRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	From     string `position:"Query" name:"From"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeLogMetaResponse is the response struct for api DescribeLogMeta
type DescribeLogMetaResponse struct {
	*responses.BaseResponse
	RequestId   string    `json:"RequestId" xml:"RequestId"`
	TotalCount  int       `json:"TotalCount" xml:"TotalCount"`
	LogMetaList []LogMeta `json:"LogMetaList" xml:"LogMetaList"`
}

// CreateDescribeLogMetaRequest creates a request to invoke DescribeLogMeta API
func CreateDescribeLogMetaRequest() (request *DescribeLogMetaRequest) {
	request = &DescribeLogMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeLogMeta", "vipaegis", "openAPI")
	return
}

// CreateDescribeLogMetaResponse creates a response to parse from DescribeLogMeta response
func CreateDescribeLogMetaResponse() (response *DescribeLogMetaResponse) {
	response = &DescribeLogMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
