package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricOrganizations invokes the baas.DescribeFabricOrganizations API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizations.html
func (client *Client) DescribeFabricOrganizations(request *DescribeFabricOrganizationsRequest) (response *DescribeFabricOrganizationsResponse, err error) {
	response = CreateDescribeFabricOrganizationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricOrganizationsWithChan invokes the baas.DescribeFabricOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationsWithChan(request *DescribeFabricOrganizationsRequest) (<-chan *DescribeFabricOrganizationsResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricOrganizationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricOrganizations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricOrganizationsWithCallback invokes the baas.DescribeFabricOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationsWithCallback(request *DescribeFabricOrganizationsRequest, callback func(response *DescribeFabricOrganizationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricOrganizationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricOrganizations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricOrganizationsRequest is the request struct for api DescribeFabricOrganizations
type DescribeFabricOrganizationsRequest struct {
	*requests.RpcRequest
	Location string `position:"Body" name:"Location"`
}

// DescribeFabricOrganizationsResponse is the response struct for api DescribeFabricOrganizations
type DescribeFabricOrganizationsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeFabricOrganizationsRequest creates a request to invoke DescribeFabricOrganizations API
func CreateDescribeFabricOrganizationsRequest() (request *DescribeFabricOrganizationsRequest) {
	request = &DescribeFabricOrganizationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricOrganizations", "baas", "openAPI")
	return
}

// CreateDescribeFabricOrganizationsResponse creates a response to parse from DescribeFabricOrganizations response
func CreateDescribeFabricOrganizationsResponse() (response *DescribeFabricOrganizationsResponse) {
	response = &DescribeFabricOrganizationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
