package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentHDSky invokes the imageseg.SegmentHDSky API synchronously
func (client *Client) SegmentHDSky(request *SegmentHDSkyRequest) (response *SegmentHDSkyResponse, err error) {
	response = CreateSegmentHDSkyResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentHDSkyWithChan invokes the imageseg.SegmentHDSky API asynchronously
func (client *Client) SegmentHDSkyWithChan(request *SegmentHDSkyRequest) (<-chan *SegmentHDSkyResponse, <-chan error) {
	responseChan := make(chan *SegmentHDSkyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentHDSky(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentHDSkyWithCallback invokes the imageseg.SegmentHDSky API asynchronously
func (client *Client) SegmentHDSkyWithCallback(request *SegmentHDSkyRequest, callback func(response *SegmentHDSkyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentHDSkyResponse
		var err error
		defer close(result)
		response, err = client.SegmentHDSky(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentHDSkyRequest is the request struct for api SegmentHDSky
type SegmentHDSkyRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// SegmentHDSkyResponse is the response struct for api SegmentHDSky
type SegmentHDSkyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentHDSkyRequest creates a request to invoke SegmentHDSky API
func CreateSegmentHDSkyRequest() (request *SegmentHDSkyRequest) {
	request = &SegmentHDSkyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentHDSky", "imageseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentHDSkyResponse creates a response to parse from SegmentHDSky response
func CreateSegmentHDSkyResponse() (response *SegmentHDSkyResponse) {
	response = &SegmentHDSkyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
