package reid

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpcLiveAddress invokes the reid.DescribeIpcLiveAddress API synchronously
// api document: https://help.aliyun.com/api/reid/describeipcliveaddress.html
func (client *Client) DescribeIpcLiveAddress(request *DescribeIpcLiveAddressRequest) (response *DescribeIpcLiveAddressResponse, err error) {
	response = CreateDescribeIpcLiveAddressResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpcLiveAddressWithChan invokes the reid.DescribeIpcLiveAddress API asynchronously
// api document: https://help.aliyun.com/api/reid/describeipcliveaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeIpcLiveAddressWithChan(request *DescribeIpcLiveAddressRequest) (<-chan *DescribeIpcLiveAddressResponse, <-chan error) {
	responseChan := make(chan *DescribeIpcLiveAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpcLiveAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpcLiveAddressWithCallback invokes the reid.DescribeIpcLiveAddress API asynchronously
// api document: https://help.aliyun.com/api/reid/describeipcliveaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeIpcLiveAddressWithCallback(request *DescribeIpcLiveAddressRequest, callback func(response *DescribeIpcLiveAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpcLiveAddressResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpcLiveAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpcLiveAddressRequest is the request struct for api DescribeIpcLiveAddress
type DescribeIpcLiveAddressRequest struct {
	*requests.RpcRequest
	IpcId        requests.Integer `position:"Body" name:"IpcId"`
	StoreId      requests.Integer `position:"Body" name:"StoreId"`
	ProtocolType string           `position:"Body" name:"ProtocolType"`
}

// DescribeIpcLiveAddressResponse is the response struct for api DescribeIpcLiveAddress
type DescribeIpcLiveAddressResponse struct {
	*responses.BaseResponse
	RtmpUrl        string `json:"RtmpUrl" xml:"RtmpUrl"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Message        string `json:"Message" xml:"Message"`
	Code           string `json:"Code" xml:"Code"`
	ExpiredTime    string `json:"ExpiredTime" xml:"ExpiredTime"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	IpcId          int64  `json:"IpcId" xml:"IpcId"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateDescribeIpcLiveAddressRequest creates a request to invoke DescribeIpcLiveAddress API
func CreateDescribeIpcLiveAddressRequest() (request *DescribeIpcLiveAddressRequest) {
	request = &DescribeIpcLiveAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("reid", "2019-09-28", "DescribeIpcLiveAddress", "1.1.8.2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIpcLiveAddressResponse creates a response to parse from DescribeIpcLiveAddress response
func CreateDescribeIpcLiveAddressResponse() (response *DescribeIpcLiveAddressResponse) {
	response = &DescribeIpcLiveAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
