// Code generated by ./internal/gen/main.go. DO NOT EDIT.

//go:generate go run ./internal/gen/main.go

package encoder

var testCasesSingle = []testCase{
	{ // 0
		mask: EncodeZero,
		in:   "＊2π%ｊ８｜aｗ␄k%\x15β\x00σ\\τ７␟'R\f␀τ；β7７␇",
		out:  "＊2π%ｊ８｜aｗ␄k%\x15β␀σ\\τ７␟'R\f‛␀τ；β7７␇",
	}, { // 1
		mask: EncodeSlash,
		in:   "␄␅VＪｇ：Ｋ|\x10+\x10／φ｀/π\n\bρRα\x03ζ？＜VLν␗ｑ",
		out:  "␄␅VＪｇ：Ｋ|\x10+\x10‛／φ｀／π\n\bρRα\x03ζ？＜VLν␗ｑ",
	}, { // 2
		mask: EncodeSingleQuote,
		in:   "γ␅＇Ｐｎ\fχ\nε␍[υ\r␉］ζM2ω␘＇$\nＡＮ␄^'\\\x7f",
		out:  "γ␅‛＇Ｐｎ\fχ\nε␍[υ\r␉］ζM2ω␘‛＇$\nＡＮ␄^＇\\\x7f",
	}, { // 3
		mask: EncodeBackQuote,
		in:   "\x17＼θWfｃＲ␟(［｀\vＶ６τη\x1d［'mυ>：#｜βw｛`ρ",
		out:  "\x17＼θWfｃＲ␟(［‛｀\vＶ６τη\x1d［'mυ>：#｜βw｛｀ρ",
	}, { // 4
		mask: EncodeLtGt,
		in:   "４＞>ｏ\n\x1bＰι,␅Pυ\x0e＜\n＂！９tπ＞<␎\b(ης：oε",
		out:  "４‛＞＞ｏ\n\x1bＰι,␅Pυ\x0e‛＜\n＂！９tπ‛＞＜␎\b(ης：oε",
	}, { // 5
		mask: EncodeSquareBracket,
		in:   "␛␡\fενm\x1bρ[M+τ\x19\\\x04νw＾］＃␚ｑ．ψＩ0Ｘ＃［]",
		out:  "␛␡\fενm\x1bρ［M+τ\x19\\\x04νw＾‛］＃␚ｑ．ψＩ0Ｘ＃‛［］",
	}, { // 6
		mask: EncodeSemicolon,
		in:   "Rφ#'\x06\x13ςY｜ψ＞ｌ%；ｙｓｏ$;;ς␆ξ␗␚\x1b[＼ι＼",
		out:  "Rφ#'\x06\x13ςY｜ψ＞ｌ%‛；ｙｓｏ$；；ς␆ξ␗␚\x1b[＼ι＼",
	}, { // 7
		mask: EncodeExclamation,
		in:   "\x17!;Ｘτ\x02？^εE！π\x01＆＃␇␐＆ψ＊ι～␀:~/\"θ␎R",
		out:  "\x17！;Ｘτ\x02？^εE‛！π\x01＆＃␇␐＆ψ＊ι～‛␀:~/\"θ␎R",
	}, { // 8
		mask: EncodeDollar,
		in:   "ωQ＝λ␕γ␗＄＂ε／#Ｒ$!$␚\x1e:Ｙ\x1e８\x7f$π␇ν\x19␁=",
		out:  "ωQ＝λ␕γ␗‛＄＂ε／#Ｒ＄!＄␚\x1e:Ｙ\x1e８\x7f＄π␇ν\x19␁=",
	}, { // 9
		mask: EncodeDoubleQuote,
		in:   "χ␙ρ\x13\x15Ｅ\t\x0fＣ␈\x15３sος␙７␔νk!π＂␆o␎\"MＷ\x05",
		out:  "χ␙ρ\x13\x15Ｅ\t\x0fＣ␈\x15３sος␙７␔νk!π‛＂␆o␎＂MＷ\x05",
	}, { // 10
		mask: EncodeColon,
		in:   "\x1f\x18%～:／\x18Ｑ＋δω␆R｜：OζＩs␇\x7f／\x17?␊μτC；φ",
		out:  "\x1f\x18%～：／\x18Ｑ＋δω␆R｜‛：OζＩs␇\x7f／\x17?␊μτC；φ",
	}, { // 11
		mask: EncodeQuestion,
		in:   "Q␝Ｊａｌ？Vz\v␏␁\x16\x10?␛χκ?[␑ι\n＜␝ν\x15#βλＵ",
		out:  "Q␝Ｊａｌ‛？Vz\v␏␁\x16\x10？␛χκ？[␑ι\n＜␝ν\x15#βλＵ",
	}, { // 12
		mask: EncodeAsterisk,
		in:   "W=\x05ｘξβ＄\x1bmａε␡*␝!＊␡␊f\\\"␑Yｈｚτ\x1fδτｋ",
		out:  "W=\x05ｘξβ＄\x1bmａε␡＊␝!‛＊␡␊f\\\"␑Yｈｚτ\x1fδτｋ",
	}, { // 13
		mask: EncodePipe,
		in:   "#\x18␍␊Ｘ\x18␍ｋp＊λ\f:\aθｔg]｜ｋρ;|υο␎Oξ␍｀",
		out:  "#\x18␍␊Ｘ\x18␍ｋp＊λ\f:\aθｔg]‛｜ｋρ;｜υο␎Oξ␍｀",
	}, { // 14
		mask: EncodeHash,
		in:   "*［␄％μ$φ#$＄ｉδ%|␝ο＼χ\x1fxI）\x11yＧ＃！ςt９",
		out:  "*［␄％μ$φ＃$＄ｉδ%|␝ο＼χ\x1fxI）\x11yＧ‛＃！ςt９",
	}, { // 15
		mask: EncodePercent,
		in:   "DδＭ｀ξ␍\x06ρ␓ζ：＄Ｔ\x04␒φ!\x01Ｏ$%d%/γＷＪ\r％:",
		out:  "DδＭ｀ξ␍\x06ρ␓ζ：＄Ｔ\x04␒φ!\x01Ｏ$％d％/γＷＪ\r‛％:",
	}, { // 16
		mask: EncodeBackSlash,
		in:   "\x1aｌ^.\\ｘP␇ββσ\x10*\x01␓＼α＞\x16＊\":'／␄λ／ｅχＶ",
		out:  "\x1aｌ^.＼ｘP␇ββσ\x10*\x01␓‛＼α＞\x16＊\":'／␄λ／ｅχＶ",
	}, { // 17
		mask: EncodeCrLf,
		in:   "Fｇ！［␂π|\x0eY\nμ$＊0␊ν\x01VχI３␍＞\x00␐？δ\r␊ω",
		out:  "Fｇ！［␂π|\x0eY␊μ$＊0‛␊ν\x01VχI３‛␍＞␀␐？δ␍‛␊ω",
	}, { // 18
		mask: EncodeDel,
		in:   "ο␡：πς␓\x14ｏ␏*P:␙\x18d␊λδZ<;＆／\x7f\x00６［\x03Ｖδ",
		out:  "ο‛␡：πς␓\x14ｏ␏*P:␙\x18d␊λδZ<;＆／␡␀６［\x03Ｖδ",
	}, { // 19
		mask: EncodeCtl,
		in:   "␊\n␅␚ρ␉␄␈\x1f\\\x1bζ\x19␏ｔ␘\aφ\f\x11\x05␃－␒␁␙␟␔ξ#␄ＸN␜\b\r\x14\x04␋\x10＜␑2!\x18\x1c\t␆\x06␞{␍␐␎5␝\x12ｃ\x1a\x03␗\x0e␛\b\x15\x1eX␛␐␌\x01\x1d\x17\x02\x1d8？\x13␖␂\x18\v␕＾␙\x0fα␕␇;μ␓\x16",
		out:  "‛␊␊‛␅‛␚ρ‛␉‛␄‛␈␟\\␛ζ␙‛␏ｔ‛␘␇φ␌␑␅‛␃－‛␒‛␁‛␙‛␟‛␔ξ#‛␄ＸN‛␜␈␍␔␄‛␋␐＜‛␑2!␘␜␉‛␆␆‛␞{‛␍‛␐‛␎5‛␝␒ｃ␚␃‛␗␎‛␛␈␕␞X‛␛‛␐‛␌␁␝␗␂␝8？␓‛␖‛␂␘␋‛␕＾‛␙␏α‛␕‛␇;μ‛␓␖",
	},
}

var testCasesSingleEdge = []testCase{
	{ // 0
		mask: EncodeLeftSpace,
		in:   " ",
		out:  "␠",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
		out:  "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
		out:  "␠␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
		out:  "‛␠␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
	}, { // 4
		mask: EncodeZero | EncodeLeftSpace,
		in:   " Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
		out:  "␠Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
	}, { // 5
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
		out:  "‛␠Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
	}, { // 6
		mask: EncodeZero | EncodeLeftSpace,
		in:   " Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
		out:  "␠Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
	}, { // 7
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
		out:  "‛␠Qα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
	}, { // 8
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\f α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
		out:  "\f α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
	}, { // 9
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\f␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
		out:  "\f␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５μ",
	}, { // 10
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\f α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
		out:  "\f α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
	}, { // 11
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\f␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
		out:  "\f␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
	}, { // 12
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\f α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
		out:  "\f α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
	}, { // 13
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\f␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
		out:  "\f␠α␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
	}, { // 14
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊ μ",
		out:  "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊ μ",
	}, { // 15
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
		out:  "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠μ",
	}, { // 16
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊ ␠",
		out:  "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊ ␠",
	}, { // 17
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠␠",
		out:  "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊␠␠",
	}, { // 18
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５ ",
		out:  "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５ ",
	}, { // 19
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
		out:  "\fQα␃Ｊ\x04ψ␘Ｐζ ＇\x1a6θz｜$`?N：␜h>μ｀＊５␠",
	}, { // 20
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
		out:  "[\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
	}, { // 21
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ␠α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
		out:  "␠␠α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
	}, { // 22
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠␠α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
		out:  "‛␠␠α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
	}, { // 23
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " \"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
		out:  "␠\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
	}, { // 24
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
		out:  "‛␠\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
	}, { // 25
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " \"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
		out:  "␠\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
	}, { // 26
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
		out:  "‛␠\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
	}, { // 27
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[ α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
		out:  "[ α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
	}, { // 28
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[␠α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
		out:  "[␠α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␖",
	}, { // 29
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[ α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
		out:  "[ α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
	}, { // 30
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[␠α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
		out:  "[␠α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
	}, { // 31
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[ α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
		out:  "[ α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
	}, { // 32
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[␠α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
		out:  "[␠α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
	}, { // 33
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ ␖",
		out:  "[\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ ␖",
	}, { // 34
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
		out:  "[\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␖",
	}, { // 35
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ ␠",
		out:  "[\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ ␠",
	}, { // 36
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␠",
		out:  "[\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ␠␠",
	}, { // 37
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[ ",
		out:  "[\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[ ",
	}, { // 38
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "[\"α/／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
		out:  "[\"α／‛／ｓ］␎ｄ\x19 ９~ζＯ\n␍ντU*Ｔ\x0eπｍ<eλ[␠",
	}, { // 39
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1cw",
		out:  "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1cw",
	}, { // 40
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1cw",
		out:  "␠␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1cw",
	}, { // 41
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1cw",
		out:  "‛␠␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1cw",
	}, { // 42
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%␠w",
		out:  "␠␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%␠w",
	}, { // 43
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%␠w",
		out:  "‛␠␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%␠w",
	}, { // 44
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1c␠",
		out:  "␠␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1c␠",
	}, { // 45
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1c␠",
		out:  "‛␠␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1c␠",
	}, { // 46
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16 ３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1cw",
		out:  "\x16 ３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1cw",
	}, { // 47
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1cw",
		out:  "\x16␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1cw",
	}, { // 48
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16 ３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%␠w",
		out:  "\x16 ３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%␠w",
	}, { // 49
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%␠w",
		out:  "\x16␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%␠w",
	}, { // 50
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16 ３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1c␠",
		out:  "\x16 ３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1c␠",
	}, { // 51
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1c␠",
		out:  "\x16␠３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1c␠",
	}, { // 52
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι% w",
		out:  "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι% w",
	}, { // 53
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%␠w",
		out:  "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%␠w",
	}, { // 54
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι% ␠",
		out:  "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι% ␠",
	}, { // 55
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%␠␠",
		out:  "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%␠␠",
	}, { // 56
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1c ",
		out:  "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1c ",
	}, { // 57
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα'␐6Ｋ]\x17odι%\x1c␠",
		out:  "\x16␎３ςδ＋３ζ␃ξ \x19␁［t］ｐα＇␐6Ｋ]\x17odι%\x1c␠",
	}, { // 58
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
		out:  "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
	}, { // 59
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " ␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
		out:  "␠␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
	}, { // 60
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
		out:  "‛␠␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
	}, { // 61
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " ＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
		out:  "␠＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
	}, { // 62
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
		out:  "‛␠＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
	}, { // 63
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " ＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
		out:  "␠＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
	}, { // 64
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
		out:  "‛␠＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
	}, { // 65
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１ ＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
		out:  "１ ＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
	}, { // 66
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
		out:  "１␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ\x0f",
	}, { // 67
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１ ＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
		out:  "１ ＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
	}, { // 68
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
		out:  "１␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
	}, { // 69
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１ ＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
		out:  "１ ＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
	}, { // 70
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
		out:  "１␠＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
	}, { // 71
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04 \x0f",
		out:  "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04 \x0f",
	}, { // 72
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
		out:  "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠\x0f",
	}, { // 73
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04 ␠",
		out:  "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04 ␠",
	}, { // 74
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠␠",
		out:  "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04␠␠",
	}, { // 75
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ ",
		out:  "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ ",
	}, { // 76
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
		out:  "１＞＜\"ξ］\r\"&B ｑ␗␆σ；\t<␛b␑οF\x0eη）８\x04υ␠",
	}, { // 77
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
		out:  "‛＜～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
	}, { // 78
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ␠Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
		out:  "␠␠Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
	}, { // 79
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠␠Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
		out:  "‛␠␠Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
	}, { // 80
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
		out:  "␠～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
	}, { // 81
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
		out:  "‛␠～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
	}, { // 82
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
		out:  "␠～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
	}, { // 83
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
		out:  "‛␠～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
	}, { // 84
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜ Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
		out:  "‛＜ Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
	}, { // 85
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜␠Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
		out:  "‛＜␠Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1fδ",
	}, { // 86
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜ Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
		out:  "‛＜ Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
	}, { // 87
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜␠Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
		out:  "‛＜␠Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
	}, { // 88
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜ Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
		out:  "‛＜ Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
	}, { // 89
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜␠Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
		out:  "‛＜␠Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
	}, { // 90
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi' δ",
		out:  "‛＜～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi' δ",
	}, { // 91
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
		out:  "‛＜～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠δ",
	}, { // 92
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi' ␠",
		out:  "‛＜～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi' ␠",
	}, { // 93
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠␠",
		out:  "‛＜～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'␠␠",
	}, { // 94
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f ",
		out:  "‛＜～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f ",
	}, { // 95
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＜～Ｘ｛＃＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
		out:  "‛＜～Ｘ｛＃‛＞\x10\x19)\x1b ␏_␇κβＦχ␔]［νB（\x1aπi'\x1f␠",
	}, { // 96
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘ＢX",
		out:  "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘ＢX",
	}, { // 97
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " ␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘ＢX",
		out:  "␠␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘ＢX",
	}, { // 98
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘ＢX",
		out:  "‛␠␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘ＢX",
	}, { // 99
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘␠X",
		out:  "␠γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘␠X",
	}, { // 100
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘␠X",
		out:  "‛␠γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘␠X",
	}, { // 101
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘Ｂ␠",
		out:  "␠γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘Ｂ␠",
	}, { // 102
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘Ｂ␠",
		out:  "‛␠γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘Ｂ␠",
	}, { // 103
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "` \v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘ＢX",
		out:  "` \v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘ＢX",
	}, { // 104
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘ＢX",
		out:  "`␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘ＢX",
	}, { // 105
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "` \v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘␠X",
		out:  "` \v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘␠X",
	}, { // 106
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘␠X",
		out:  "`␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘␠X",
	}, { // 107
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "` \v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘Ｂ␠",
		out:  "` \v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘Ｂ␠",
	}, { // 108
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘Ｂ␠",
		out:  "`␠\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘Ｂ␠",
	}, { // 109
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘ X",
		out:  "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘ X",
	}, { // 110
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘␠X",
		out:  "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘␠X",
	}, { // 111
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘ ␠",
		out:  "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘ ␠",
	}, { // 112
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘␠␠",
		out:  "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘␠␠",
	}, { // 113
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘Ｂ ",
		out:  "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘Ｂ ",
	}, { // 114
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟␀␘Ｂ␠",
		out:  "`γ\v\x12Ｉ\vζ)＊！ αζ\x1f=τ\x04F％Ｃς;<␈Ｈ␟‛␀␘Ｂ␠",
	}, { // 115
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～φ",
		out:  "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～φ",
	}, { // 116
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   " ␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～φ",
		out:  "␠␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～φ",
	}, { // 117
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "␠␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～φ",
		out:  "‛␠␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～φ",
	}, { // 118
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   " %j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［␠φ",
		out:  "␠%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［␠φ",
	}, { // 119
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "␠%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［␠φ",
		out:  "‛␠%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［␠φ",
	}, { // 120
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   " %j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～␠",
		out:  "␠%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～␠",
	}, { // 121
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "␠%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～␠",
		out:  "‛␠%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～␠",
	}, { // 122
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/ j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～φ",
		out:  "/ j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～φ",
	}, { // 123
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～φ",
		out:  "/␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～φ",
	}, { // 124
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/ j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［␠φ",
		out:  "/ j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［␠φ",
	}, { // 125
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［␠φ",
		out:  "/␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［␠φ",
	}, { // 126
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/ j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～␠",
		out:  "/ j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～␠",
	}, { // 127
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～␠",
		out:  "/␠j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～␠",
	}, { // 128
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［ φ",
		out:  "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［ φ",
	}, { // 129
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［␠φ",
		out:  "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［␠φ",
	}, { // 130
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［ ␠",
		out:  "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［ ␠",
	}, { // 131
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［␠␠",
		out:  "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［␠␠",
	}, { // 132
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～ ",
		out:  "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～ ",
	}, { // 133
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10;＃:␀\rＨ2［～␠",
		out:  "/%j2ｒＢ｀␍'ｖ Dυ␁:οπφＬ\x10；＃:‛␀\rＨ2［～␠",
	}, { // 134
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
		out:  "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
	}, { // 135
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   " ␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
		out:  "␠␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
	}, { // 136
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "␠␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
		out:  "‛␠␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
	}, { // 137
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   " ␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
		out:  "␠␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
	}, { // 138
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "␠␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
		out:  "‛␠␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
	}, { // 139
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   " ␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
		out:  "␠␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
	}, { // 140
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "␠␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
		out:  "‛␠␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
	}, { // 141
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］ ，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
		out:  "］ ，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
	}, { // 142
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
		out:  "］␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌χ",
	}, { // 143
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］ ，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
		out:  "］ ，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
	}, { // 144
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
		out:  "］␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
	}, { // 145
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］ ，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
		out:  "］ ，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
	}, { // 146
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
		out:  "］␠，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
	}, { // 147
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16 χ",
		out:  "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16 χ",
	}, { // 148
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
		out:  "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠χ",
	}, { // 149
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16 ␠",
		out:  "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16 ␠",
	}, { // 150
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠␠",
		out:  "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␠␠",
	}, { // 151
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌ ",
		out:  "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌ ",
	}, { // 152
		mask: EncodeExclamation | EncodeLeftSpace,
		in:   "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
		out:  "］␟，χ％ι＄?]D 1εw\x14\x15Ｘη$␉>␟|ｕε；］\x16␌␠",
	}, { // 153
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
		out:  "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
	}, { // 154
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
		out:  "␠␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
	}, { // 155
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
		out:  "‛␠␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
	}, { // 156
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
		out:  "␠~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
	}, { // 157
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
		out:  "‛␠~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
	}, { // 158
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
		out:  "␠~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
	}, { // 159
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
		out:  "‛␠~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
	}, { // 160
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３ ?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
		out:  "３ ?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
	}, { // 161
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
		out:  "３␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρＦ",
	}, { // 162
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３ ?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
		out:  "３ ?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
	}, { // 163
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
		out:  "３␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
	}, { // 164
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３ ?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
		out:  "３ ?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
	}, { // 165
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
		out:  "３␠?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
	}, { // 166
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ Ｆ",
		out:  "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ Ｆ",
	}, { // 167
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
		out:  "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠Ｆ",
	}, { // 168
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ ␠",
		out:  "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ ␠",
	}, { // 169
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠␠",
		out:  "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜␠␠",
	}, { // 170
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ ",
		out:  "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ ",
	}, { // 171
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
		out:  "３~?ε␞\x14μO？ψ {ς＼８１\np<\"f␒\x1b␔Ｃ\x15␃｜ρ␠",
	}, { // 172
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
		out:  "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
	}, { // 173
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
		out:  "␠␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
	}, { // 174
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
		out:  "‛␠␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
	}, { // 175
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
		out:  "␠␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
	}, { // 176
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
		out:  "‛␠␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
	}, { // 177
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
		out:  "␠␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
	}, { // 178
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
		out:  "‛␠␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
	}, { // 179
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ :o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
		out:  "Ｊ :o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
	}, { // 180
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
		out:  "Ｊ␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*`",
	}, { // 181
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ :o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
		out:  "Ｊ :o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
	}, { // 182
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
		out:  "Ｊ␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
	}, { // 183
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ :o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
		out:  "Ｊ :o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
	}, { // 184
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
		out:  "Ｊ␠:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
	}, { // 185
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a `",
		out:  "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a `",
	}, { // 186
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
		out:  "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠`",
	}, { // 187
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a ␠",
		out:  "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a ␠",
	}, { // 188
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠␠",
		out:  "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a␠␠",
	}, { // 189
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a* ",
		out:  "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a* ",
	}, { // 190
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
		out:  "Ｊ␛:o\x02%␍Oε␈ τａ\uff00χＫ\x0f␛\x12｜>９ς]ξ␃Ｊ\a*␠",
	}, { // 191
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
		out:  "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
	}, { // 192
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
		out:  "␠␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
	}, { // 193
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
		out:  "‛␠␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
	}, { // 194
		mask: EncodeColon | EncodeLeftSpace,
		in:   " \x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
		out:  "␠\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
	}, { // 195
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
		out:  "‛␠\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
	}, { // 196
		mask: EncodeColon | EncodeLeftSpace,
		in:   " \x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
		out:  "␠\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
	}, { // 197
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
		out:  "‛␠\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
	}, { // 198
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖ λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
		out:  "␖ λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
	}, { // 199
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
		out:  "␖␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␒",
	}, { // 200
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖ λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
		out:  "␖ λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
	}, { // 201
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
		out:  "␖␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
	}, { // 202
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖ λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
		out:  "␖ λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
	}, { // 203
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
		out:  "␖␠λ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
	}, { // 204
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊  ␒",
		out:  "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊  ␒",
	}, { // 205
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
		out:  "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␒",
	}, { // 206
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊  ␠",
		out:  "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊  ␠",
	}, { // 207
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␠",
		out:  "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ ␠␠",
	}, { // 208
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S ",
		out:  "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S ",
	}, { // 209
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
		out:  "␖\x1fλ］␙νο\tμ1 2\x03\x1fｙ\x03ＸＰδ␅V%ν\x7fＷｑ＊ S␠",
	}, { // 210
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ＃",
		out:  "＊νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ＃",
	}, { // 211
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " ␠μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ＃",
		out:  "␠␠μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ＃",
	}, { // 212
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠␠μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ＃",
		out:  "‛␠␠μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ＃",
	}, { // 213
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ␠＃",
		out:  "␠νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ␠＃",
	}, { // 214
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ␠＃",
		out:  "‛␠νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ␠＃",
	}, { // 215
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ␠",
		out:  "␠νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ␠",
	}, { // 216
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ␠",
		out:  "‛␠νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ␠",
	}, { // 217
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊ μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ＃",
		out:  "＊ μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ＃",
	}, { // 218
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊␠μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ＃",
		out:  "＊␠μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ＃",
	}, { // 219
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊ μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ␠＃",
		out:  "＊ μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ␠＃",
	}, { // 220
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊␠μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ␠＃",
		out:  "＊␠μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ␠＃",
	}, { // 221
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊ μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ␠",
		out:  "＊ μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ␠",
	}, { // 222
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊␠μ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ␠",
		out:  "＊␠μ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ␠",
	}, { // 223
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ ＃",
		out:  "＊νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ ＃",
	}, { // 224
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ␠＃",
		out:  "＊νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ␠＃",
	}, { // 225
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ ␠",
		out:  "＊νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ ␠",
	}, { // 226
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔ␠␠",
		out:  "＊νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔ␠␠",
	}, { // 227
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ ",
		out:  "＊νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ ",
	}, { // 228
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "＊νμ␜V\x18\aｊθψ θSψU８2j\x01?␂`Ｐ\x17%！␕ｔｖ␠",
		out:  "＊νμ␜V\x18\aｊθψ θSψU８2j\x01？␂`Ｐ\x17%！␕ｔｖ␠",
	}, { // 229
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'Ｚ",
		out:  "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'Ｚ",
	}, { // 230
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'Ｚ",
		out:  "␠␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'Ｚ",
	}, { // 231
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'Ｚ",
		out:  "‛␠␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'Ｚ",
	}, { // 232
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00␠Ｚ",
		out:  "␠＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀␠Ｚ",
	}, { // 233
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00␠Ｚ",
		out:  "‛␠＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀␠Ｚ",
	}, { // 234
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'␠",
		out:  "␠＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'␠",
	}, { // 235
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'␠",
		out:  "‛␠＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'␠",
	}, { // 236
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５ ＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'Ｚ",
		out:  "５ ＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'Ｚ",
	}, { // 237
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'Ｚ",
		out:  "５␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'Ｚ",
	}, { // 238
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５ ＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00␠Ｚ",
		out:  "５ ＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀␠Ｚ",
	}, { // 239
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00␠Ｚ",
		out:  "５␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀␠Ｚ",
	}, { // 240
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５ ＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'␠",
		out:  "５ ＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'␠",
	}, { // 241
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'␠",
		out:  "５␠＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'␠",
	}, { // 242
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00 Ｚ",
		out:  "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀ Ｚ",
	}, { // 243
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00␠Ｚ",
		out:  "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀␠Ｚ",
	}, { // 244
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00 ␠",
		out:  "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀ ␠",
	}, { // 245
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00␠␠",
		out:  "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀␠␠",
	}, { // 246
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00' ",
		out:  "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀' ",
	}, { // 247
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r\x00'␠",
		out:  "５＂＾␅\x16␡ςＪM' ＇％AB␡；\x7fχπ７Dχ5!θ\r␀'␠",
	}, { // 248
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌σ",
		out:  "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌σ",
	}, { // 249
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌σ",
		out:  "␠␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌σ",
	}, { // 250
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌σ",
		out:  "‛␠␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌σ",
	}, { // 251
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␠σ",
		out:  "␠！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␠σ",
	}, { // 252
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␠σ",
		out:  "‛␠！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␠σ",
	}, { // 253
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌␠",
		out:  "␠！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌␠",
	}, { // 254
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌␠",
		out:  "‛␠！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌␠",
	}, { // 255
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y \x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌σ",
		out:  "Y \x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌σ",
	}, { // 256
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌σ",
		out:  "Y␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌σ",
	}, { // 257
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y \x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␠σ",
		out:  "Y \x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␠σ",
	}, { // 258
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␠σ",
		out:  "Y␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␠σ",
	}, { // 259
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y \x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌␠",
		out:  "Y \x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌␠",
	}, { // 260
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌␠",
		out:  "Y␠\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌␠",
	}, { // 261
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞ σ",
		out:  "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞ σ",
	}, { // 262
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␠σ",
		out:  "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␠σ",
	}, { // 263
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞ ␠",
		out:  "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞ ␠",
	}, { // 264
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␠␠",
		out:  "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␠␠",
	}, { // 265
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌ ",
		out:  "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌ ",
	}, { // 266
		mask: EncodePipe | EncodeLeftSpace,
		in:   "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*｜Rφ｀ψ/␞␌␠",
		out:  "Y！\x06␟ｏ！\x12＝！I λ＇α＆g\x16\x1bJν*‛｜Rφ｀ψ/␞␌␠",
	}, { // 267
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
		out:  "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
	}, { // 268
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
		out:  "␠␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
	}, { // 269
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
		out:  "‛␠␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
	}, { // 270
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
		out:  "␠␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
	}, { // 271
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
		out:  "‛␠␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
	}, { // 272
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
		out:  "␠␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
	}, { // 273
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
		out:  "‛␠␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
	}, { // 274
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
		out:  "\v φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
	}, { // 275
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
		out:  "\v␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ρ",
	}, { // 276
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
		out:  "\v φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
	}, { // 277
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
		out:  "\v␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
	}, { // 278
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
		out:  "\v φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
	}, { // 279
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
		out:  "\v␠φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
	}, { // 280
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r ρ",
		out:  "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r ρ",
	}, { // 281
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
		out:  "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠ρ",
	}, { // 282
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r ␠",
		out:  "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r ␠",
	}, { // 283
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠␠",
		out:  "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r␠␠",
	}, { // 284
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ ",
		out:  "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼ ",
	}, { // 285
		mask: EncodeHash | EncodeLeftSpace,
		in:   "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
		out:  "\v␊φ\x11\x0e｝ζ0Ｎ7 \x10(＋ηυ／C\x1b?γS＂｝␆＂␈\r＼␠",
	}, { // 286
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φg␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]>",
		out:  "φg␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]>",
	}, { // 287
		mask: EncodePercent | EncodeLeftSpace,
		in:   " ␠␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]>",
		out:  "␠␠␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]>",
	}, { // 288
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠␠␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]>",
		out:  "‛␠␠␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]>",
	}, { // 289
		mask: EncodePercent | EncodeLeftSpace,
		in:   " g␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅␠>",
		out:  "␠g␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅␠>",
	}, { // 290
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠g␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅␠>",
		out:  "‛␠g␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅␠>",
	}, { // 291
		mask: EncodePercent | EncodeLeftSpace,
		in:   " g␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]␠",
		out:  "␠g␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]␠",
	}, { // 292
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠g␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]␠",
		out:  "‛␠g␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]␠",
	}, { // 293
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φ ␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]>",
		out:  "φ ␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]>",
	}, { // 294
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φ␠␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]>",
		out:  "φ␠␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]>",
	}, { // 295
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φ ␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅␠>",
		out:  "φ ␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅␠>",
	}, { // 296
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φ␠␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅␠>",
		out:  "φ␠␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅␠>",
	}, { // 297
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φ ␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]␠",
		out:  "φ ␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]␠",
	}, { // 298
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φ␠␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]␠",
		out:  "φ␠␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]␠",
	}, { // 299
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φg␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅ >",
		out:  "φg␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅ >",
	}, { // 300
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φg␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅␠>",
		out:  "φg␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅␠>",
	}, { // 301
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φg␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅ ␠",
		out:  "φg␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅ ␠",
	}, { // 302
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φg␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅␠␠",
		out:  "φg␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅␠␠",
	}, { // 303
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φg␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅] ",
		out:  "φg␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅] ",
	}, { // 304
		mask: EncodePercent | EncodeLeftSpace,
		in:   "φg␕＋{<␚sＪ5 γν␔θ␟\x00．φ\x12[αuｎｄC␞␅]␠",
		out:  "φg␕＋{<␚sＪ5 γν␔θ␟␀．φ\x12[αuｎｄC␞␅]␠",
	}, { // 305
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
		out:  "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
	}, { // 306
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " ␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
		out:  "␠␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
	}, { // 307
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
		out:  "‛␠␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
	}, { // 308
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " \x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
		out:  "␠\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
	}, { // 309
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
		out:  "‛␠\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
	}, { // 310
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " \x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
		out:  "␠\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
	}, { // 311
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
		out:  "‛␠\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
	}, { // 312
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "． ␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
		out:  "． ␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
	}, { // 313
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
		out:  "．␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；ς",
	}, { // 314
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "． ␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
		out:  "． ␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
	}, { // 315
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
		out:  "．␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
	}, { // 316
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "． ␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
		out:  "． ␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
	}, { // 317
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
		out:  "．␠␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
	}, { // 318
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N ς",
		out:  "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N ς",
	}, { // 319
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
		out:  "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠ς",
	}, { // 320
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N ␠",
		out:  "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N ␠",
	}, { // 321
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠␠",
		out:  "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N␠␠",
	}, { // 322
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N； ",
		out:  "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N； ",
	}, { // 323
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
		out:  "．\x13␡ＭＵψ１J␆W ＂ςο\x18ｘ＊'<χｃυ?\x0e！50N；␠",
	}, { // 324
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκｇ",
		out:  "ε]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κｇ",
	}, { // 325
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ␠Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκｇ",
		out:  "␠␠Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κｇ",
	}, { // 326
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠␠Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκｇ",
		out:  "‛␠␠Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κｇ",
	}, { // 327
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r␠ｇ",
		out:  "␠]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍␠ｇ",
	}, { // 328
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r␠ｇ",
		out:  "‛␠]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍␠ｇ",
	}, { // 329
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκ␠",
		out:  "␠]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κ␠",
	}, { // 330
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκ␠",
		out:  "‛␠]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κ␠",
	}, { // 331
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκｇ",
		out:  "ε Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κｇ",
	}, { // 332
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε␠Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκｇ",
		out:  "ε␠Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κｇ",
	}, { // 333
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r␠ｇ",
		out:  "ε Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍␠ｇ",
	}, { // 334
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε␠Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r␠ｇ",
		out:  "ε␠Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍␠ｇ",
	}, { // 335
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκ␠",
		out:  "ε Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κ␠",
	}, { // 336
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε␠Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκ␠",
		out:  "ε␠Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κ␠",
	}, { // 337
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r ｇ",
		out:  "ε]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍ ｇ",
	}, { // 338
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r␠ｇ",
		out:  "ε]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍␠ｇ",
	}, { // 339
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r ␠",
		out:  "ε]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍ ␠",
	}, { // 340
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\r␠␠",
		out:  "ε]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍␠␠",
	}, { // 341
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκ ",
		out:  "ε]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κ ",
	}, { // 342
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ε]Ｎ)␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３\n#␖\rκ␠",
		out:  "ε]Ｎ)‛␍Ｅτ␙=／ \\\x19＄\x15｜␙ωＥξ1s%３␊#␖␍κ␠",
	}, { // 343
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
		out:  "\x14\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
	}, { // 344
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␠θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
		out:  "␠␠θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
	}, { // 345
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␠θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
		out:  "‛␠␠θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
	}, { // 346
		mask: EncodeDel | EncodeLeftSpace,
		in:   " \bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
		out:  "␠\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
	}, { // 347
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
		out:  "‛␠\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
	}, { // 348
		mask: EncodeDel | EncodeLeftSpace,
		in:   " \bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
		out:  "␠\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
	}, { // 349
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
		out:  "‛␠\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
	}, { // 350
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14 θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
		out:  "\x14 θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
	}, { // 351
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14␠θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
		out:  "\x14␠θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐eη",
	}, { // 352
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14 θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
		out:  "\x14 θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
	}, { // 353
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14␠θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
		out:  "\x14␠θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
	}, { // 354
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14 θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
		out:  "\x14 θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
	}, { // 355
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14␠θ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
		out:  "\x14␠θ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
	}, { // 356
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐ η",
		out:  "\x14\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐ η",
	}, { // 357
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
		out:  "\x14\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠η",
	}, { // 358
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐ ␠",
		out:  "\x14\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐ ␠",
	}, { // 359
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠␠",
		out:  "\x14\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐␠␠",
	}, { // 360
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e ",
		out:  "\x14\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e ",
	}, { // 361
		mask: EncodeDel | EncodeLeftSpace,
		in:   "\x14\bθ／^βδ␀a； H#＞\x00\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
		out:  "\x14\bθ／^βδ‛␀a； H#＞␀\x12␐／Ｍγ\x05␛ς＄Ｕ&Ｎ␐e␠",
	}, { // 362
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ]",
		out:  "‛␉B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ]",
	}, { // 363
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " ␠␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ]",
		out:  "␠␠‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ]",
	}, { // 364
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠␠␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ]",
		out:  "‛␠␠‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ]",
	}, { // 365
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{␠]",
		out:  "␠B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{␠]",
	}, { // 366
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{␠]",
		out:  "‛␠B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{␠]",
	}, { // 367
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ␠",
		out:  "␠B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ␠",
	}, { // 368
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ␠",
		out:  "‛␠B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ␠",
	}, { // 369
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉ ␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ]",
		out:  "‛␉ ‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ]",
	}, { // 370
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉␠␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ]",
		out:  "‛␉␠‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ]",
	}, { // 371
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉ ␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{␠]",
		out:  "‛␉ ‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{␠]",
	}, { // 372
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉␠␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{␠]",
		out:  "‛␉␠‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{␠]",
	}, { // 373
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉ ␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ␠",
		out:  "‛␉ ‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ␠",
	}, { // 374
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉␠␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ␠",
		out:  "‛␉␠‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ␠",
	}, { // 375
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ ]",
		out:  "‛␉B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ ]",
	}, { // 376
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{␠]",
		out:  "‛␉B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{␠]",
	}, { // 377
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ ␠",
		out:  "‛␉B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ ␠",
	}, { // 378
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{␠␠",
		out:  "‛␉B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{␠␠",
	}, { // 379
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ ",
		out:  "‛␉B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ ",
	}, { // 380
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␉B␑ｓ5}φｕｂ␉ \x0f\rξ@\x17βhι/＞\x18＼␈＜Ｍυ{ｉ␠",
		out:  "‛␉B‛␑ｓ5}φｕｂ‛␉ ␏␍ξ@␗βhι/＞␘＼‛␈＜Ｍυ{ｉ␠",
	}, { // 381
		mask: EncodeLeftPeriod,
		in:   ".",
		out:  "．",
	}, { // 382
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
		out:  "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
	}, { // 383
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
		out:  "．．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
	}, { // 384
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
		out:  "‛．．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
	}, { // 385
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
		out:  "．dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
	}, { // 386
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
		out:  "‛．dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
	}, { // 387
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
		out:  "．dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
	}, { // 388
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
		out:  "‛．dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
	}, { // 389
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05.α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
		out:  "\x05.α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
	}, { // 390
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
		out:  "\x05．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ3",
	}, { // 391
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05.α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
		out:  "\x05.α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
	}, { // 392
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
		out:  "\x05．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
	}, { // 393
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05.α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
		out:  "\x05.α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
	}, { // 394
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
		out:  "\x05．α␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
	}, { // 395
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ.3",
		out:  "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ.3",
	}, { // 396
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
		out:  "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．3",
	}, { // 397
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ.．",
		out:  "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ.．",
	}, { // 398
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．．",
		out:  "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂ．．",
	}, { // 399
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ.",
		out:  "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ.",
	}, { // 400
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
		out:  "\x05dα␕\\\x10νσ\t＼.E␊ｘｒρ␔ξ０30?6␑ｂ\x0e␎ｂξ．",
	}, { // 401
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
		out:  "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
	}, { // 402
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
		out:  "．．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
	}, { // 403
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
		out:  "‛．．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
	}, { // 404
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
		out:  "．－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
	}, { // 405
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
		out:  "‛．－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
	}, { // 406
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
		out:  "．－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
	}, { // 407
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
		out:  "‛．－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
	}, { // 408
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε.π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
		out:  "ε.π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
	}, { // 409
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
		out:  "ε．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡ＢG",
	}, { // 410
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε.π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
		out:  "ε.π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
	}, { // 411
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
		out:  "ε．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
	}, { // 412
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε.π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
		out:  "ε.π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
	}, { // 413
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
		out:  "ε．π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
	}, { // 414
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡.G",
		out:  "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡.G",
	}, { // 415
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
		out:  "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．G",
	}, { // 416
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡.．",
		out:  "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡.．",
	}, { // 417
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．．",
		out:  "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡．．",
	}, { // 418
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ.",
		out:  "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ.",
	}, { // 419
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
		out:  "ε－π␍ιＮX,Eα.＼*｜ι\x14Ｇ␒␚;*θV％Ｋ+]␡Ｂ．",
	}, { // 420
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
		out:  "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
	}, { // 421
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
		out:  "．．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
	}, { // 422
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
		out:  "‛．．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
	}, { // 423
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
		out:  "．:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
	}, { // 424
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
		out:  "‛．:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
	}, { // 425
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
		out:  "．:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
	}, { // 426
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
		out:  "‛．:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
	}, { // 427
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e.ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
		out:  "\x0e.ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
	}, { // 428
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
		out:  "\x0e．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs＄",
	}, { // 429
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e.ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
		out:  "\x0e.ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
	}, { // 430
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
		out:  "\x0e．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
	}, { // 431
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e.ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
		out:  "\x0e.ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
	}, { // 432
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
		out:  "\x0e．ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
	}, { // 433
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς.＄",
		out:  "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς.＄",
	}, { // 434
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
		out:  "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．＄",
	}, { // 435
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς.．",
		out:  "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς.．",
	}, { // 436
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．．",
		out:  "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ς．．",
	}, { // 437
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs.",
		out:  "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs.",
	}, { // 438
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
		out:  "\x0e:ｚπ９７␖ξ＼U.e#l\rξ%\nι\x1b／／１κｆ＃␔ςs．",
	}, { // 439
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
		out:  "／？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
	}, { // 440
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".．#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
		out:  "．．#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
	}, { // 441
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．．#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
		out:  "‛．．#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
	}, { // 442
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
		out:  "．？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
	}, { // 443
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
		out:  "‛．？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
	}, { // 444
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
		out:  "．？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
	}, { // 445
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
		out:  "‛．？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
	}, { // 446
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／.#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
		out:  "／.#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
	}, { // 447
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／．#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
		out:  "／．#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～：",
	}, { // 448
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／.#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
		out:  "／.#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
	}, { // 449
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／．#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
		out:  "／．#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
	}, { // 450
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／.#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
		out:  "／.#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
	}, { // 451
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／．#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
		out:  "／．#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
	}, { // 452
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0.：",
		out:  "／？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0.：",
	}, { // 453
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
		out:  "／？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0．：",
	}, { // 454
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0.．",
		out:  "／？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0.．",
	}, { // 455
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0．．",
		out:  "／？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0．．",
	}, { // 456
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～.",
		out:  "／？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～.",
	}, { // 457
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "／？#␅ ;␞␖\rO.lητ`ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
		out:  "／？#␅ ;␞␖\rO.lητ｀ｄｌ\x01]］ιψ＊\x12γ(ρ0～．",
	}, { // 458
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ'",
		out:  "Ｕ(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ'",
	}, { // 459
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".．!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ'",
		out:  "．．!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ'",
	}, { // 460
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．．!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ'",
		out:  "‛．．!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ'",
	}, { // 461
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃．'",
		out:  "．(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃．'",
	}, { // 462
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃．'",
		out:  "‛．(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃．'",
	}, { // 463
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ．",
		out:  "．(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ．",
	}, { // 464
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ．",
		out:  "‛．(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ．",
	}, { // 465
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ.!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ'",
		out:  "Ｕ.!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ'",
	}, { // 466
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ．!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ'",
		out:  "Ｕ．!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ'",
	}, { // 467
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ.!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃．'",
		out:  "Ｕ.!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃．'",
	}, { // 468
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ．!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃．'",
		out:  "Ｕ．!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃．'",
	}, { // 469
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ.!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ．",
		out:  "Ｕ.!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ．",
	}, { // 470
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ．!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ．",
		out:  "Ｕ．!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ．",
	}, { // 471
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃.'",
		out:  "Ｕ(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃.'",
	}, { // 472
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃．'",
		out:  "Ｕ(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃．'",
	}, { // 473
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃.．",
		out:  "Ｕ(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃.．",
	}, { // 474
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃．．",
		out:  "Ｕ(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃．．",
	}, { // 475
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ.",
		out:  "Ｕ(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ.",
	}, { // 476
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "Ｕ(!υ＇＃\x04sLρ.>'{ｘ\x05］␜␌Ｌτ＞\aυυ！｛＃σ．",
		out:  "Ｕ(!υ＇＃\x04sLρ.＞'{ｘ\x05］␜␌Ｌτ‛＞\aυυ！｛＃σ．",
	}, { // 477
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
		out:  "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
	}, { // 478
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
		out:  "．．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
	}, { // 479
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
		out:  "‛．．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
	}, { // 480
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
		out:  "．！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
	}, { // 481
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
		out:  "‛．！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
	}, { // 482
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
		out:  "．！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
	}, { // 483
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
		out:  "‛．！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
	}, { // 484
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V.\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
		out:  "V.\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
	}, { // 485
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
		out:  "V．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!｛",
	}, { // 486
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V.\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
		out:  "V.\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
	}, { // 487
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
		out:  "V．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
	}, { // 488
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V.\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
		out:  "V.\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
	}, { // 489
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
		out:  "V．\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
	}, { // 490
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊.｛",
		out:  "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊.｛",
	}, { // 491
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
		out:  "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．｛",
	}, { // 492
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊.．",
		out:  "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊.．",
	}, { // 493
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．．",
		out:  "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊．．",
	}, { // 494
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!.",
		out:  "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!.",
	}, { // 495
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
		out:  "V！\x0f＄␃\x1fλβｆ1.I；;/o？Wψｍ\rςζｂ!２␕␊!．",
	}, { // 496
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
		out:  "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
	}, { // 497
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   ".．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
		out:  "．．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
	}, { // 498
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "．．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
		out:  "‛．．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
	}, { // 499
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   ".␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
		out:  "．␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
	}, { // 500
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "．␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
		out:  "‛．␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
	}, { // 501
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   ".␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
		out:  "．␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
	}, { // 502
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "．␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
		out:  "‛．␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
	}, { // 503
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f.`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
		out:  "\x1f.`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
	}, { // 504
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
		out:  "\x1f．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１\x02",
	}, { // 505
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f.`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
		out:  "\x1f.`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
	}, { // 506
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
		out:  "\x1f．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
	}, { // 507
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f.`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
		out:  "\x1f.`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
	}, { // 508
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
		out:  "\x1f．`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
	}, { // 509
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ.\x02",
		out:  "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ.\x02",
	}, { // 510
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
		out:  "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．\x02",
	}, { // 511
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ.．",
		out:  "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ.．",
	}, { // 512
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．．",
		out:  "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ．．",
	}, { // 513
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１.",
		out:  "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１.",
	}, { // 514
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
		out:  "\x1f␔`４`ωＶζυ$.ν␛TｅAqw\x11␈θ\x17@ψｗ␙␗Ｓ１．",
	}, { // 515
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
		out:  "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
	}, { // 516
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   ".．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
		out:  "．．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
	}, { // 517
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "．．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
		out:  "‛．．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
	}, { // 518
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   ".)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
		out:  "．)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
	}, { // 519
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "．)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
		out:  "‛．)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
	}, { // 520
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   ".)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
		out:  "．)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
	}, { // 521
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "．)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
		out:  "‛．)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
	}, { // 522
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍.\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
		out:  "␍.\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
	}, { // 523
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
		out:  "␍．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`οφ",
	}, { // 524
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍.\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
		out:  "␍.\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
	}, { // 525
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
		out:  "␍．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
	}, { // 526
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍.\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
		out:  "␍.\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
	}, { // 527
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
		out:  "␍．\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
	}, { // 528
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`.φ",
		out:  "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`.φ",
	}, { // 529
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
		out:  "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．φ",
	}, { // 530
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`.．",
		out:  "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`.．",
	}, { // 531
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．．",
		out:  "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`．．",
	}, { // 532
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο.",
		out:  "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο.",
	}, { // 533
		mask: EncodeExclamation | EncodeLeftPeriod,
		in:   "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
		out:  "␍)\x1c＋␃ｌυ＄␙\r.δ／＇.*:\b␏δ？Ｗ␔$1τ?`ο．",
	}, { // 534
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ％",
		out:  "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ％",
	}, { // 535
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ％",
		out:  "．．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ％",
	}, { // 536
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ％",
		out:  "‛．．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ％",
	}, { // 537
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄．％",
		out:  "．)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄．％",
	}, { // 538
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄．％",
		out:  "‛．)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄．％",
	}, { // 539
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ．",
		out:  "．)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ．",
	}, { // 540
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ．",
		out:  "‛．)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ．",
	}, { // 541
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06.μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ％",
		out:  "\x06.μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ％",
	}, { // 542
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ％",
		out:  "\x06．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ％",
	}, { // 543
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06.μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄．％",
		out:  "\x06.μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄．％",
	}, { // 544
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄．％",
		out:  "\x06．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄．％",
	}, { // 545
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06.μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ．",
		out:  "\x06.μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ．",
	}, { // 546
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ．",
		out:  "\x06．μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ．",
	}, { // 547
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄.％",
		out:  "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄.％",
	}, { // 548
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄．％",
		out:  "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄．％",
	}, { // 549
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄.．",
		out:  "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄.．",
	}, { // 550
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄．．",
		out:  "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄．．",
	}, { // 551
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ.",
		out:  "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ.",
	}, { // 552
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ＄λ．",
		out:  "\x06)μk{␊＊９␊Ａ.\x04π\x1e\x0e␖ｍ＜\x1aｓ\x04Hσ-＂@χ‛＄λ．",
	}, { // 553
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη１",
		out:  "\x1d\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη１",
	}, { // 554
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".．sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη１",
		out:  "．．sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη１",
	}, { // 555
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．．sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη１",
		out:  "‛．．sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη１",
	}, { // 556
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs．１",
		out:  "．\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs．１",
	}, { // 557
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs．１",
		out:  "‛．\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs．１",
	}, { // 558
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη．",
		out:  "．\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη．",
	}, { // 559
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη．",
		out:  "‛．\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη．",
	}, { // 560
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d.sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη１",
		out:  "\x1d.sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη１",
	}, { // 561
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d．sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη１",
		out:  "\x1d．sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη１",
	}, { // 562
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d.sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs．１",
		out:  "\x1d.sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs．１",
	}, { // 563
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d．sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs．１",
		out:  "\x1d．sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs．１",
	}, { // 564
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d.sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη．",
		out:  "\x1d.sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη．",
	}, { // 565
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d．sG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη．",
		out:  "\x1d．sG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη．",
	}, { // 566
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs.１",
		out:  "\x1d\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs.１",
	}, { // 567
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs．１",
		out:  "\x1d\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs．１",
	}, { // 568
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs.．",
		out:  "\x1d\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs.．",
	}, { // 569
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οs．．",
		out:  "\x1d\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οs．．",
	}, { // 570
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη.",
		out:  "\x1d\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη.",
	}, { // 571
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "\x1d\asG#ο\v␋＄7.␡λ＂｀␌ν［５ω]＂\x00＂[～οsη．",
		out:  "\x1d\asG#ο\v␋＄7.␡λ‛＂｀␌ν［５ω]‛＂␀‛＂[～οsη．",
	}, { // 572
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a␌",
		out:  "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a␌",
	}, { // 573
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a␌",
		out:  "．．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a␌",
	}, { // 574
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a␌",
		out:  "‛．．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a␌",
	}, { // 575
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！．␌",
		out:  "．ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！．␌",
	}, { // 576
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！．␌",
		out:  "‛．ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！．␌",
	}, { // 577
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a．",
		out:  "．ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a．",
	}, { // 578
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a．",
		out:  "‛．ε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a．",
	}, { // 579
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ς.］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a␌",
		out:  "ς.］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a␌",
	}, { // 580
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ς．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a␌",
		out:  "ς．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a␌",
	}, { // 581
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ς.］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！．␌",
		out:  "ς.］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！．␌",
	}, { // 582
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ς．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！．␌",
		out:  "ς．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！．␌",
	}, { // 583
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ς.］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a．",
		out:  "ς.］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a．",
	}, { // 584
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ς．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a．",
		out:  "ς．］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a．",
	}, { // 585
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！.␌",
		out:  "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！.␌",
	}, { // 586
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！．␌",
		out:  "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！．␌",
	}, { // 587
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！.．",
		out:  "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！.．",
	}, { // 588
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！．．",
		out:  "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！．．",
	}, { // 589
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a.",
		out:  "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a.",
	}, { // 590
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι：\x01␟π｝！\a．",
		out:  "ςε］ｃV|␟5S␎.\rＣＬo␍\\π{\n\x1aι‛：\x01␟π｝！\a．",
	}, { // 591
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
		out:  "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
	}, { // 592
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
		out:  "．．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
	}, { // 593
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
		out:  "‛．．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
	}, { // 594
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
		out:  "．:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
	}, { // 595
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
		out:  "‛．:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
	}, { // 596
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
		out:  "．:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
	}, { // 597
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
		out:  "‛．:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
	}, { // 598
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒.W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
		out:  "␒.W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
	}, { // 599
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
		out:  "␒．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２␛",
	}, { // 600
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒.W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
		out:  "␒.W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
	}, { // 601
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
		out:  "␒．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
	}, { // 602
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒.W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
		out:  "␒.W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
	}, { // 603
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
		out:  "␒．W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
	}, { // 604
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔.␛",
		out:  "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔.␛",
	}, { // 605
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
		out:  "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．␛",
	}, { // 606
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔.．",
		out:  "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔.．",
	}, { // 607
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．．",
		out:  "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔．．",
	}, { // 608
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２.",
		out:  "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２.",
	}, { // 609
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
		out:  "␒:W%＆ξ（\x16␊ｒ.π\x06''Vξη^␆h＇D[τＰθ␔２．",
	}, { // 610
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
		out:  "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
	}, { // 611
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
		out:  "．．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
	}, { // 612
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
		out:  "‛．．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
	}, { // 613
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
		out:  "．υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
	}, { // 614
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
		out:  "‛．υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
	}, { // 615
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
		out:  "．υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
	}, { // 616
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
		out:  "‛．υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
	}, { // 617
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+.XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
		out:  "+.XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
	}, { // 618
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
		out:  "+．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!XρＷ",
	}, { // 619
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+.XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
		out:  "+.XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
	}, { // 620
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
		out:  "+．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
	}, { // 621
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+.XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
		out:  "+.XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
	}, { // 622
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
		out:  "+．XＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
	}, { // 623
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X.Ｗ",
		out:  "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X.Ｗ",
	}, { // 624
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
		out:  "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．Ｗ",
	}, { // 625
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X.．",
		out:  "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X.．",
	}, { // 626
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．．",
		out:  "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!X．．",
	}, { // 627
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ.",
		out:  "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ.",
	}, { // 628
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
		out:  "+υXＡξ\x04\\［␑\x05.␟＆Ｗζυ;／c\x02:ｎ␈８␖x!Xρ．",
	}, { // 629
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00!",
		out:  "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00!",
	}, { // 630
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00!",
		out:  "．．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00!",
	}, { // 631
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00!",
		out:  "‛．．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00!",
	}, { // 632
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'．!",
		out:  "．＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'．!",
	}, { // 633
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'．!",
		out:  "‛．＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'．!",
	}, { // 634
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00．",
		out:  "．＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00．",
	}, { // 635
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00．",
		out:  "‛．＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00．",
	}, { // 636
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ.␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00!",
		out:  "κ.␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00!",
	}, { // 637
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00!",
		out:  "κ．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00!",
	}, { // 638
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ.␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'．!",
		out:  "κ.␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'．!",
	}, { // 639
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'．!",
		out:  "κ．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'．!",
	}, { // 640
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ.␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00．",
		out:  "κ.␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00．",
	}, { // 641
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00．",
		out:  "κ．␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00．",
	}, { // 642
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'.!",
		out:  "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'.!",
	}, { // 643
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'．!",
		out:  "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'．!",
	}, { // 644
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'.．",
		out:  "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'.．",
	}, { // 645
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'．．",
		out:  "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'．．",
	}, { // 646
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00.",
		out:  "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00.",
	}, { // 647
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"\x00％Ｊ\td'\uff00．",
		out:  "κ＂␄␖␁a␕：V［.ι！μχ/!ς＊\x06ω\"␀％Ｊ\td'\uff00．",
	}, { // 648
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
		out:  "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
	}, { // 649
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
		out:  "．．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
	}, { // 650
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
		out:  "‛．．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
	}, { // 651
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
		out:  "．3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
	}, { // 652
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
		out:  "‛．3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
	}, { // 653
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
		out:  "．3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
	}, { // 654
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
		out:  "‛．3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
	}, { // 655
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!.\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
		out:  "!.\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
	}, { // 656
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
		out:  "!．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e␑",
	}, { // 657
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!.\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
		out:  "!.\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
	}, { // 658
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
		out:  "!．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
	}, { // 659
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!.\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
		out:  "!.\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
	}, { // 660
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
		out:  "!．\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
	}, { // 661
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!.␑",
		out:  "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!.␑",
	}, { // 662
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
		out:  "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．␑",
	}, { // 663
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!.．",
		out:  "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!.．",
	}, { // 664
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．．",
		out:  "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!．．",
	}, { // 665
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e.",
		out:  "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e.",
	}, { // 666
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
		out:  "!3\"j]Aｓσ␛␂.πＰｂξ@＜␐\x12θι＂Ｓ＊ο\x14H!\x1e．",
	}, { // 667
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］ｚ",
		out:  "τＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］ｚ",
	}, { // 668
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".．τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］ｚ",
		out:  "．．τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］ｚ",
	}, { // 669
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．．τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］ｚ",
		out:  "‛．．τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］ｚ",
	}, { // 670
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".ＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅．ｚ",
		out:  "．ＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅．ｚ",
	}, { // 671
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．ＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅．ｚ",
		out:  "‛．ＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅．ｚ",
	}, { // 672
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".ＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］．",
		out:  "．ＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］．",
	}, { // 673
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．ＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］．",
		out:  "‛．ＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］．",
	}, { // 674
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τ.τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］ｚ",
		out:  "τ.τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］ｚ",
	}, { // 675
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τ．τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］ｚ",
		out:  "τ．τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］ｚ",
	}, { // 676
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τ.τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅．ｚ",
		out:  "τ.τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅．ｚ",
	}, { // 677
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τ．τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅．ｚ",
		out:  "τ．τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅．ｚ",
	}, { // 678
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τ.τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］．",
		out:  "τ.τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］．",
	}, { // 679
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τ．τkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］．",
		out:  "τ．τkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］．",
	}, { // 680
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅.ｚ",
		out:  "τＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅.ｚ",
	}, { // 681
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅．ｚ",
		out:  "τＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅．ｚ",
	}, { // 682
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅.．",
		out:  "τＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅.．",
	}, { // 683
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅．．",
		out:  "τＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅．．",
	}, { // 684
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］.",
		out:  "τＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］.",
	}, { // 685
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "τＡτkＢ|␀γ$␎.＿\x7fμψ␀U\nτｂ\n4␖2?d␇␅］．",
		out:  "τＡτkＢ|‛␀γ$␎.＿\x7fμψ‛␀U\nτｂ\n4␖2?d␇␅］．",
	}, { // 686
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
		out:  "＼（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
	}, { // 687
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
		out:  "．．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
	}, { // 688
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
		out:  "‛．．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
	}, { // 689
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
		out:  "．（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
	}, { // 690
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
		out:  "‛．（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
	}, { // 691
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
		out:  "．（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
	}, { // 692
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
		out:  "‛．（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
	}, { // 693
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\.\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
		out:  "＼.\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
	}, { // 694
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
		out:  "＼．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:|",
	}, { // 695
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\.\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
		out:  "＼.\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
	}, { // 696
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
		out:  "＼．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
	}, { // 697
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\.\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
		out:  "＼.\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
	}, { // 698
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
		out:  "＼．\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
	}, { // 699
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ.|",
		out:  "＼（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ.|",
	}, { // 700
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
		out:  "＼（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．|",
	}, { // 701
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ.．",
		out:  "＼（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ.．",
	}, { // 702
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．．",
		out:  "＼（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ．．",
	}, { // 703
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:.",
		out:  "＼（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:.",
	}, { // 704
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "\\（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
		out:  "＼（\x02５␃I␜ｑ%N.\nZｐφ＜␃ζ\rχξτt'ｐ␊Ｃφ:．",
	}, { // 705
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
		out:  "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
	}, { // 706
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
		out:  "．．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
	}, { // 707
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
		out:  "‛．．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
	}, { // 708
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
		out:  "．:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
	}, { // 709
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
		out:  "‛．:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
	}, { // 710
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
		out:  "．:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
	}, { // 711
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
		out:  "‛．:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
	}, { // 712
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎.'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
		out:  "␎.'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
	}, { // 713
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
		out:  "␎．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+\x0e",
	}, { // 714
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎.'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
		out:  "␎.'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
	}, { // 715
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
		out:  "␎．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
	}, { // 716
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎.'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
		out:  "␎.'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
	}, { // 717
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
		out:  "␎．'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
	}, { // 718
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω.\x0e",
		out:  "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω.\x0e",
	}, { // 719
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
		out:  "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．\x0e",
	}, { // 720
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω.．",
		out:  "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω.．",
	}, { // 721
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．．",
		out:  "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω．．",
	}, { // 722
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+.",
		out:  "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+.",
	}, { // 723
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
		out:  "␎:'６\x03＆ξω\tｆ.θ␗6ρ\x1a␔＋\\ｕ％tIφ␏ｄKω+．",
	}, { // 724
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
		out:  "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
	}, { // 725
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
		out:  "．．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
	}, { // 726
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
		out:  "‛．．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
	}, { // 727
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
		out:  "．ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
	}, { // 728
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
		out:  "‛．ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
	}, { // 729
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
		out:  "．ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
	}, { // 730
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
		out:  "‛．ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
	}, { // 731
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓.Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
		out:  "␓.Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
	}, { // 732
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
		out:  "␓．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿UG",
	}, { // 733
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓.Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
		out:  "␓.Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
	}, { // 734
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
		out:  "␓．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
	}, { // 735
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓.Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
		out:  "␓.Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
	}, { // 736
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
		out:  "␓．Ｗ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
	}, { // 737
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿.G",
		out:  "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿.G",
	}, { // 738
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
		out:  "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．G",
	}, { // 739
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿.．",
		out:  "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿.．",
	}, { // 740
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．．",
		out:  "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿．．",
	}, { // 741
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U.",
		out:  "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U.",
	}, { // 742
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
		out:  "␓ＨＷ\tG\x1b＄\x1a＿B.␓ζφψω＜%\x01＄i＿＞'λ?ｇ＿U．",
	}, { // 743
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15D",
		out:  "U‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕D",
	}, { // 744
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".．\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15D",
		out:  "．．\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕D",
	}, { // 745
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．．\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15D",
		out:  "‛．．\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕D",
	}, { // 746
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο．D",
		out:  "．‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο．D",
	}, { // 747
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο．D",
		out:  "‛．‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο．D",
	}, { // 748
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15．",
		out:  "．‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕．",
	}, { // 749
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15．",
		out:  "‛．‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕．",
	}, { // 750
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U.\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15D",
		out:  "U.\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕D",
	}, { // 751
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U．\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15D",
		out:  "U．\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕D",
	}, { // 752
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U.\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο．D",
		out:  "U.\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο．D",
	}, { // 753
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U．\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο．D",
		out:  "U．\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο．D",
	}, { // 754
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U.\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15．",
		out:  "U.\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕．",
	}, { // 755
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U．\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15．",
		out:  "U．\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕．",
	}, { // 756
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο.D",
		out:  "U‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο.D",
	}, { // 757
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο．D",
		out:  "U‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο．D",
	}, { // 758
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο.．",
		out:  "U‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο.．",
	}, { // 759
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο．．",
		out:  "U‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο．．",
	}, { // 760
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15.",
		out:  "U‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕.",
	}, { // 761
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "U␔\x7f＊φｗζ\x12\x12␝.Ｂ\x18Uυ␀｜0ψ＄\x06＄\"s］＜βο\x15．",
		out:  "U‛␔\x7f＊φｗζ␒␒‛␝.Ｂ␘Uυ‛␀｜0ψ＄␆＄\"s］＜βο␕．",
	}, { // 762
		mask: EncodeLeftTilde,
		in:   "~",
		out:  "～",
	}, { // 763
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
	}, { // 764
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
		out:  "～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
	}, { // 765
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
		out:  "‛～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
	}, { // 766
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
		out:  "～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
	}, { // 767
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
		out:  "‛～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
	}, { // 768
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
		out:  "～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
	}, { // 769
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
		out:  "‛～～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
	}, { // 770
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η~｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
		out:  "η~｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
	}, { // 771
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇)",
	}, { // 772
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η~｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
		out:  "η~｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
	}, { // 773
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
	}, { // 774
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η~｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
		out:  "η~｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
	}, { // 775
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
	}, { // 776
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε~)",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε~)",
	}, { // 777
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～)",
	}, { // 778
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε~～",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε~～",
	}, { // 779
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～～",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε～～",
	}, { // 780
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇~",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇~",
	}, { // 781
		mask: EncodeZero | EncodeLeftTilde,
		in:   "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
		out:  "η～｜␑ｋ␐Ｚ＜ｐ＇~ζ{\x13|%Pψ\x15\x04］πξk\x18S｛ε＇～",
	}, { // 782
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
		out:  "%ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
	}, { // 783
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~～␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
		out:  "～～‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
	}, { // 784
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～～␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
		out:  "‛～～‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
	}, { // 785
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
		out:  "～ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
	}, { // 786
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
		out:  "‛～ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
	}, { // 787
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
		out:  "～ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
	}, { // 788
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
		out:  "‛～ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
	}, { // 789
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%~␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
		out:  "%~‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
	}, { // 790
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%～␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
		out:  "%～‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？?",
	}, { // 791
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%~␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
		out:  "%~‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
	}, { // 792
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%～␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
		out:  "%～‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
	}, { // 793
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%~␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
		out:  "%~‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
	}, { // 794
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%～␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
		out:  "%～‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
	}, { // 795
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e~?",
		out:  "%ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e~?",
	}, { // 796
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
		out:  "%ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～?",
	}, { // 797
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e~～",
		out:  "%ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e~～",
	}, { // 798
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～～",
		out:  "%ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e～～",
	}, { // 799
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？~",
		out:  "%ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？~",
	}, { // 800
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "%ｓ␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
		out:  "%ｓ‛␀\x0eψv＆ω＋#~␍ι＊Pe␊␚\x19\x1e＃Uρ＼υνＥ\x0e？～",
	}, { // 801
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
		out:  "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
	}, { // 802
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
		out:  "～～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
	}, { // 803
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
		out:  "‛～～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
	}, { // 804
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
		out:  "～␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
	}, { // 805
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
		out:  "‛～␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
	}, { // 806
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
		out:  "～␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
	}, { // 807
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
		out:  "‛～␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
	}, { // 808
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５~%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
		out:  "５~%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
	}, { // 809
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
		out:  "５～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ\r",
	}, { // 810
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５~%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
		out:  "５~%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
	}, { // 811
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
		out:  "５～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
	}, { // 812
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５~%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
		out:  "５~%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
	}, { // 813
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
		out:  "５～%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
	}, { // 814
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；~\r",
		out:  "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；~\r",
	}, { // 815
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
		out:  "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～\r",
	}, { // 816
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；~～",
		out:  "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；~～",
	}, { // 817
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～～",
		out:  "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；～～",
	}, { // 818
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ~",
		out:  "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ~",
	}, { // 819
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
		out:  "５␓%φφ％L＊\"\x1e~θv<τ１\\ηβ␋\x03ｄ␉x７␁\f；Ｋ～",
	}, { // 820
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε)",
		out:  "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε)",
	}, { // 821
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε)",
		out:  "～～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε)",
	}, { // 822
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε)",
		out:  "‛～～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε)",
	}, { // 823
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16～)",
		out:  "～\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16～)",
	}, { // 824
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16～)",
		out:  "‛～\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16～)",
	}, { // 825
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε～",
		out:  "～\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε～",
	}, { // 826
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε～",
		out:  "‛～\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε～",
	}, { // 827
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν~␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε)",
		out:  "ν~␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε)",
	}, { // 828
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε)",
		out:  "ν～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε)",
	}, { // 829
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν~␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16～)",
		out:  "ν~␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16～)",
	}, { // 830
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16～)",
		out:  "ν～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16～)",
	}, { // 831
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν~␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε～",
		out:  "ν~␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε～",
	}, { // 832
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε～",
		out:  "ν～␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε～",
	}, { // 833
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16~)",
		out:  "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16~)",
	}, { // 834
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16～)",
		out:  "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16～)",
	}, { // 835
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16~～",
		out:  "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16~～",
	}, { // 836
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16～～",
		out:  "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16～～",
	}, { // 837
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε~",
		out:  "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε~",
	}, { // 838
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄｀\x13\t-␍\x16ε～",
		out:  "ν\"␈6Ｕ<ｕξｈ｜~ｇｍπ\b␊οσ２3z␄‛｀\x13\t-␍\x16ε～",
	}, { // 839
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
		out:  "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
	}, { // 840
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
		out:  "～～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
	}, { // 841
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
		out:  "‛～～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
	}, { // 842
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
		out:  "～ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
	}, { // 843
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
		out:  "‛～ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
	}, { // 844
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
		out:  "～ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
	}, { // 845
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
		out:  "‛～ε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
	}, { // 846
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Y~\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
		out:  "Y~\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
	}, { // 847
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Y～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
		out:  "Y～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？u",
	}, { // 848
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Y~\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
		out:  "Y~\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
	}, { // 849
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Y～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
		out:  "Y～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
	}, { // 850
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Y~\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
		out:  "Y~\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
	}, { // 851
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Y～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
		out:  "Y～\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
	}, { // 852
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊~u",
		out:  "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊~u",
	}, { // 853
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
		out:  "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～u",
	}, { // 854
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊~～",
		out:  "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊~～",
	}, { // 855
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～～",
		out:  "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊～～",
	}, { // 856
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？~",
		out:  "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？~",
	}, { // 857
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
		out:  "Yε\x10m\x1f＇vｓCφ~｜ｗｇδ\r7ξ:\n\\＊␉Ｌμｋｆ␊？～",
	}, { // 858
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾␉",
		out:  ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾␉",
	}, { // 859
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~～κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾␉",
		out:  "～～κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾␉",
	}, { // 860
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～～κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾␉",
		out:  "‛～～κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾␉",
	}, { // 861
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ～␉",
		out:  "～\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ～␉",
	}, { // 862
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ～␉",
		out:  "‛～\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ～␉",
	}, { // 863
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾～",
		out:  "～\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾～",
	}, { // 864
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾～",
		out:  "‛～\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾～",
	}, { // 865
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">~κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾␉",
		out:  ">~κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾␉",
	}, { // 866
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">～κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾␉",
		out:  ">～κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾␉",
	}, { // 867
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">~κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ～␉",
		out:  ">~κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ～␉",
	}, { // 868
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">～κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ～␉",
		out:  ">～κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ～␉",
	}, { // 869
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">~κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾～",
		out:  ">~κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾～",
	}, { // 870
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">～κ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾～",
		out:  ">～κ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾～",
	}, { // 871
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ~␉",
		out:  ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ~␉",
	}, { // 872
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ～␉",
		out:  ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ～␉",
	}, { // 873
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ~～",
		out:  ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ~～",
	}, { // 874
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ～～",
		out:  ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ～～",
	}, { // 875
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾~",
		out:  ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾~",
	}, { // 876
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ[V/Ｎ␇ψ｜%\rμ＞μ＾～",
		out:  ">\x1cκ␐␜Eω\x03dλ~＜␎z\x1cＸ［V/Ｎ␇ψ｜%\rμ＞μ＾～",
	}, { // 877
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
		out:  "␝␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
	}, { // 878
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "~～ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
		out:  "～～ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
	}, { // 879
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "～～ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
		out:  "‛～～ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
	}, { // 880
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "~␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
		out:  "～␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
	}, { // 881
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "～␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
		out:  "‛～␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
	}, { // 882
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "~␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
		out:  "～␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
	}, { // 883
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "～␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
		out:  "‛～␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
	}, { // 884
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝~ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
		out:  "␝~ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
	}, { // 885
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝～ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
		out:  "␝～ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ)",
	}, { // 886
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝~ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
		out:  "␝~ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
	}, { // 887
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝～ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
		out:  "␝～ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
	}, { // 888
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝~ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
		out:  "␝~ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
	}, { // 889
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝～ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
		out:  "␝～ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
	}, { // 890
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5~)",
		out:  "␝␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5~)",
	}, { // 891
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
		out:  "␝␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～)",
	}, { // 892
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5~～",
		out:  "␝␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5~～",
	}, { // 893
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～～",
		out:  "␝␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5～～",
	}, { // 894
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ~",
		out:  "␝␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ~",
	}, { // 895
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "␝␊ｍ<；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
		out:  "␝␊ｍ<‛；\uff001δj␏~Ｊ$γzRρ：%６\x04:\a␡ιψ␏5χ～",
	}, { // 896
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
		out:  "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
	}, { // 897
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "~～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
		out:  "～～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
	}, { // 898
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "～～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
		out:  "‛～～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
	}, { // 899
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "~＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
		out:  "～＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
	}, { // 900
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "～＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
		out:  "‛～＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
	}, { // 901
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "~＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
		out:  "～＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
	}, { // 902
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "～＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
		out:  "‛～＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
	}, { // 903
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'~ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
		out:  "'~ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
	}, { // 904
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
		out:  "'～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗a",
	}, { // 905
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'~ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
		out:  "'~ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
	}, { // 906
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
		out:  "'～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
	}, { // 907
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'~ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
		out:  "'~ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
	}, { // 908
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
		out:  "'～ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
	}, { // 909
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β~a",
		out:  "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β~a",
	}, { // 910
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
		out:  "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～a",
	}, { // 911
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β~～",
		out:  "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β~～",
	}, { // 912
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～～",
		out:  "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β～～",
	}, { // 913
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗~",
		out:  "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗~",
	}, { // 914
		mask: EncodeExclamation | EncodeLeftTilde,
		in:   "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
		out:  "'＄ζ>υ＃W\r]σ~f␉+/）\x10␄η<［ｒ；ς＼\x18８β␗～",
	}, { // 915
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
		out:  "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
	}, { // 916
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
		out:  "～～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
	}, { // 917
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
		out:  "‛～～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
	}, { // 918
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
		out:  "～＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
	}, { // 919
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
		out:  "‛～＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
	}, { // 920
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
		out:  "～＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
	}, { // 921
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
		out:  "‛～＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
	}, { // 922
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ~χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
		out:  "σ~χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
	}, { // 923
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
		out:  "σ～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ␇",
	}, { // 924
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ~χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
		out:  "σ~χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
	}, { // 925
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
		out:  "σ～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
	}, { // 926
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ~χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
		out:  "σ~χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
	}, { // 927
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
		out:  "σ～χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
	}, { // 928
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e~␇",
		out:  "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e~␇",
	}, { // 929
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
		out:  "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～␇",
	}, { // 930
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e~～",
		out:  "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e~～",
	}, { // 931
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～～",
		out:  "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0e～～",
	}, { // 932
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ~",
		out:  "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ~",
	}, { // 933
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
		out:  "σ＜χ*ω␒ｘ）{␂~\x03αUｈ|σｇ39␆y\x181\x01β␖\x0eｃ～",
	}, { // 934
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
		out:  "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
	}, { // 935
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
		out:  "～～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
	}, { // 936
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
		out:  "‛～～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
	}, { // 937
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
		out:  "～␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
	}, { // 938
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
		out:  "‛～␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
	}, { // 939
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
		out:  "～␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
	}, { // 940
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
		out:  "‛～␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
	}, { // 941
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|~ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
		out:  "|~ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
	}, { // 942
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
		out:  "|～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／+",
	}, { // 943
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|~ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
		out:  "|~ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
	}, { // 944
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
		out:  "|～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
	}, { // 945
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|~ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
		out:  "|~ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
	}, { // 946
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
		out:  "|～ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
	}, { // 947
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟~+",
		out:  "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟~+",
	}, { // 948
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
		out:  "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～+",
	}, { // 949
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟~～",
		out:  "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟~～",
	}, { // 950
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～～",
		out:  "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟～～",
	}, { // 951
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／~",
		out:  "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／~",
	}, { // 952
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
		out:  "|␒ｒＬφνu[:\x1c~ρｉPιd#␎｀ｐｂ␅σ\x19Mβ\x15␟／～",
	}, { // 953
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉κ",
		out:  "␜；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉κ",
	}, { // 954
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~～:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉κ",
		out:  "～～：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉κ",
	}, { // 955
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～～:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉κ",
		out:  "‛～～：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉κ",
	}, { // 956
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc～κ",
		out:  "～；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc～κ",
	}, { // 957
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc～κ",
		out:  "‛～；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc～κ",
	}, { // 958
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉～",
		out:  "～；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉～",
	}, { // 959
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉～",
		out:  "‛～；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉～",
	}, { // 960
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜~:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉κ",
		out:  "␜~：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉κ",
	}, { // 961
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜～:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉κ",
		out:  "␜～：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉κ",
	}, { // 962
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜~:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc～κ",
		out:  "␜~：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc～κ",
	}, { // 963
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜～:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc～κ",
		out:  "␜～：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc～κ",
	}, { // 964
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜~:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉～",
		out:  "␜~：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉～",
	}, { // 965
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜～:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉～",
		out:  "␜～：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉～",
	}, { // 966
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc~κ",
		out:  "␜；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc~κ",
	}, { // 967
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc～κ",
		out:  "␜；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc～κ",
	}, { // 968
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc~～",
		out:  "␜；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc~～",
	}, { // 969
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc～～",
		out:  "␜；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc～～",
	}, { // 970
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉~",
		out:  "␜；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉~",
	}, { // 971
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␜；:υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％\x00υ\x0f；Dc␉～",
		out:  "␜；：υφ\x11χζ{ｃ~␔-６＂\x04\bＳ]＠0％␀υ\x0f；Dc␉～",
	}, { // 972
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
		out:  "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
	}, { // 973
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
		out:  "～～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
	}, { // 974
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
		out:  "‛～～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
	}, { // 975
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
		out:  "～F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
	}, { // 976
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
		out:  "‛～F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
	}, { // 977
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
		out:  "～F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
	}, { // 978
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
		out:  "‛～F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
	}, { // 979
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖~'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
		out:  "␖~'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
	}, { // 980
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
		out:  "␖～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε␚",
	}, { // 981
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖~'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
		out:  "␖~'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
	}, { // 982
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
		out:  "␖～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
	}, { // 983
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖~'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
		out:  "␖~'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
	}, { // 984
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
		out:  "␖～'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
	}, { // 985
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς~␚",
		out:  "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς~␚",
	}, { // 986
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
		out:  "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～␚",
	}, { // 987
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς~～",
		out:  "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς~～",
	}, { // 988
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～～",
		out:  "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ς～～",
	}, { // 989
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε~",
		out:  "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε~",
	}, { // 990
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
		out:  "␖F'／Ｐ/Kπ/ｎ~ｃδ␜`ε$＞，-\aλ\x05CW＾␄ςε～",
	}, { // 991
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
		out:  "！␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
	}, { // 992
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~～W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
		out:  "～～W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
	}, { // 993
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～～W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
		out:  "‛～～W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
	}, { // 994
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
		out:  "～␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
	}, { // 995
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
		out:  "‛～␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
	}, { // 996
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
		out:  "～␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
	}, { // 997
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
		out:  "‛～␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
	}, { // 998
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！~W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
		out:  "！~W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
	}, { // 999
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！～W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
		out:  "！～W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／ｍ",
	}, { // 1000
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！~W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
		out:  "！~W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
	}, { // 1001
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！～W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
		out:  "！～W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
	}, { // 1002
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！~W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
		out:  "！~W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
	}, { // 1003
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！～W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
		out:  "！～W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
	}, { // 1004
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"~ｍ",
		out:  "！␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"~ｍ",
	}, { // 1005
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
		out:  "！␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～ｍ",
	}, { // 1006
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"~～",
		out:  "！␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"~～",
	}, { // 1007
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～～",
		out:  "！␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"～～",
	}, { // 1008
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／~",
		out:  "！␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／~",
	}, { // 1009
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "！␙W␈7φ`ｌεζ~␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
		out:  "！␙W␈7φ`ｌεζ~‛␀（zａ`\x1bo|ｅＵν␄\r;rσ\"／～",
	}, { // 1010
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
		out:  "\x16Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
	}, { // 1011
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~～ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
		out:  "～～ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
	}, { // 1012
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～～ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
		out:  "‛～～ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
	}, { // 1013
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
		out:  "～Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
	}, { // 1014
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
		out:  "‛～Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
	}, { // 1015
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
		out:  "～Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
	}, { // 1016
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
		out:  "‛～Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
	}, { // 1017
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16~ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
		out:  "\x16~ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
	}, { // 1018
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16～ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
		out:  "\x16～ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02␛",
	}, { // 1019
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16~ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
		out:  "\x16~ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
	}, { // 1020
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16～ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
		out:  "\x16～ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
	}, { // 1021
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16~ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
		out:  "\x16~ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
	}, { // 1022
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16～ρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
		out:  "\x16～ρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
	}, { // 1023
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊~␛",
		out:  "\x16Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊~␛",
	}, { // 1024
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
		out:  "\x16Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊～␛",
	}, { // 1025
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊~～",
		out:  "\x16Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊~～",
	}, { // 1026
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊～～",
		out:  "\x16Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊～～",
	}, { // 1027
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02~",
		out:  "\x16Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02~",
	}, { // 1028
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\x16Ｌρ\x1eρＴ␐%\x00␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
		out:  "\x16Ｌρ\x1eρＴ␐%␀␓~QL␆\vM␘;\x16αθＹι．γ，a＊\x02～",
	}, { // 1029
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ\x00",
		out:  "]％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ␀",
	}, { // 1030
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~～␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ\x00",
		out:  "～～␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ␀",
	}, { // 1031
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～～␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ\x00",
		out:  "‛～～␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ␀",
	}, { // 1032
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２～\x00",
		out:  "～％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２～␀",
	}, { // 1033
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２～\x00",
		out:  "‛～％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２～␀",
	}, { // 1034
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ～",
		out:  "～％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ～",
	}, { // 1035
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ～",
		out:  "‛～％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ～",
	}, { // 1036
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]~␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ\x00",
		out:  "]~␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ␀",
	}, { // 1037
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]～␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ\x00",
		out:  "]～␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ␀",
	}, { // 1038
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]~␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２～\x00",
		out:  "]~␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２～␀",
	}, { // 1039
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]～␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２～\x00",
		out:  "]～␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２～␀",
	}, { // 1040
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]~␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ～",
		out:  "]~␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ～",
	}, { // 1041
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]～␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ～",
		out:  "]～␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ～",
	}, { // 1042
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２~\x00",
		out:  "]％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２~␀",
	}, { // 1043
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２～\x00",
		out:  "]％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２～␀",
	}, { // 1044
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２~～",
		out:  "]％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２~～",
	}, { // 1045
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２～～",
		out:  "]％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２～～",
	}, { // 1046
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ~",
		out:  "]％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ~",
	}, { // 1047
		mask: EncodeHash | EncodeLeftTilde,
		in:   "]％␛e*b＜U#␌~\x1b\x17δ；Ｉ␕␁_\x12\t＃σςＢξω２ρ～",
		out:  "]％␛e*b＜U＃␌~\x1b\x17δ；Ｉ␕␁_\x12\t‛＃σςＢξω２ρ～",
	}, { // 1048
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
		out:  "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
	}, { // 1049
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
		out:  "～～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
	}, { // 1050
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
		out:  "‛～～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
	}, { // 1051
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
		out:  "～ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
	}, { // 1052
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
		out:  "‛～ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
	}, { // 1053
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
		out:  "～ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
	}, { // 1054
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
		out:  "‛～ν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
	}, { // 1055
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Z~\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
		out:  "Z~\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
	}, { // 1056
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Z～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
		out:  "Z～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y␓",
	}, { // 1057
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Z~\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
		out:  "Z~\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
	}, { // 1058
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Z～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
		out:  "Z～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
	}, { // 1059
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Z~\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
		out:  "Z~\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
	}, { // 1060
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Z～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
		out:  "Z～\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
	}, { // 1061
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:~␓",
		out:  "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:~␓",
	}, { // 1062
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
		out:  "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～␓",
	}, { // 1063
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:~～",
		out:  "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:~～",
	}, { // 1064
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～～",
		out:  "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:～～",
	}, { // 1065
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y~",
		out:  "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y~",
	}, { // 1066
		mask: EncodePercent | EncodeLeftTilde,
		in:   "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
		out:  "Zν\x05␂\"␂O!ρｊ~ε\x18ωνｒ\x1bn＿ψＥ3ｗ␞F␍ｓ:y～",
	}, { // 1067
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
		out:  "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
	}, { // 1068
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
		out:  "～～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
	}, { // 1069
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
		out:  "‛～～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
	}, { // 1070
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
		out:  "～＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
	}, { // 1071
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
		out:  "‛～＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
	}, { // 1072
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
		out:  "～＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
	}, { // 1073
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
		out:  "‛～＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
	}, { // 1074
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η~(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
		out:  "η~(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
	}, { // 1075
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
		out:  "η～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄＊",
	}, { // 1076
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η~(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
		out:  "η~(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
	}, { // 1077
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
		out:  "η～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
	}, { // 1078
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η~(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
		out:  "η~(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
	}, { // 1079
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
		out:  "η～(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
	}, { // 1080
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ~＊",
		out:  "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ~＊",
	}, { // 1081
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
		out:  "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～＊",
	}, { // 1082
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ~～",
		out:  "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ~～",
	}, { // 1083
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～～",
		out:  "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ～～",
	}, { // 1084
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄~",
		out:  "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄~",
	}, { // 1085
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
		out:  "η＋(?γz|ｔａv~λ␗\x19\x05␘␒\x11＄ω８＂'!ε*）ψ␄～",
	}, { // 1086
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u8",
		out:  "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u8",
	}, { // 1087
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u8",
		out:  "～～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u8",
	}, { // 1088
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u8",
		out:  "‛～～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u8",
	}, { // 1089
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&～8",
		out:  "～υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&～8",
	}, { // 1090
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&～8",
		out:  "‛～υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&～8",
	}, { // 1091
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u～",
		out:  "～υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u～",
	}, { // 1092
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u～",
		out:  "‛～υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u～",
	}, { // 1093
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃~t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u8",
		out:  "＃~t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u8",
	}, { // 1094
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u8",
		out:  "＃～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u8",
	}, { // 1095
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃~t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&～8",
		out:  "＃~t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&～8",
	}, { // 1096
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&～8",
		out:  "＃～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&～8",
	}, { // 1097
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃~t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u～",
		out:  "＃~t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u～",
	}, { // 1098
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u～",
		out:  "＃～t␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u～",
	}, { // 1099
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&~8",
		out:  "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&~8",
	}, { // 1100
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&～8",
		out:  "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&～8",
	}, { // 1101
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&~～",
		out:  "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&~～",
	}, { // 1102
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&～～",
		out:  "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&～～",
	}, { // 1103
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u~",
		out:  "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u~",
	}, { // 1104
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓␀\x00\x1fHιψ\x06φ&u～",
		out:  "＃υt␑［␝\x0fｏ␇λ~Ｗφ，%]＞!␓‛␀␀\x1fHιψ\x06φ&u～",
	}, { // 1105
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
		out:  "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
	}, { // 1106
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
		out:  "～～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
	}, { // 1107
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
		out:  "‛～～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
	}, { // 1108
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
		out:  "～νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
	}, { // 1109
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
		out:  "‛～νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
	}, { // 1110
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
		out:  "～νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
	}, { // 1111
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
		out:  "‛～νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
	}, { // 1112
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|~Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
		out:  "|~Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
	}, { // 1113
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
		out:  "|～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n␍",
	}, { // 1114
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|~Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
		out:  "|~Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
	}, { // 1115
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
		out:  "|～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
	}, { // 1116
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|~Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
		out:  "|~Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
	}, { // 1117
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
		out:  "|～Ｊ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
	}, { // 1118
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f~␍",
		out:  "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f~␍",
	}, { // 1119
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
		out:  "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～␍",
	}, { // 1120
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f~～",
		out:  "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f~～",
	}, { // 1121
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～～",
		out:  "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f～～",
	}, { // 1122
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n~",
		out:  "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n~",
	}, { // 1123
		mask: EncodeDel | EncodeLeftTilde,
		in:   "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
		out:  "|νＪ＝?␑＞γ／σ~#σｗl\x1bfπl$ｎ２T␍␟＜B\x1f\n～",
	}, { // 1124
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<＼",
		out:  "␔Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<＼",
	}, { // 1125
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~～＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<＼",
		out:  "～～＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<＼",
	}, { // 1126
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～～＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<＼",
		out:  "‛～～＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<＼",
	}, { // 1127
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ～＼",
		out:  "～Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ～＼",
	}, { // 1128
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ～＼",
		out:  "‛～Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ～＼",
	}, { // 1129
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<～",
		out:  "～Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<～",
	}, { // 1130
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<～",
		out:  "‛～Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<～",
	}, { // 1131
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14~＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<＼",
		out:  "␔~＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<＼",
	}, { // 1132
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14～＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<＼",
		out:  "␔～＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<＼",
	}, { // 1133
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14~＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ～＼",
		out:  "␔~＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ～＼",
	}, { // 1134
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14～＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ～＼",
		out:  "␔～＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ～＼",
	}, { // 1135
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14~＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<～",
		out:  "␔~＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<～",
	}, { // 1136
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14～＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<～",
		out:  "␔～＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<～",
	}, { // 1137
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ~＼",
		out:  "␔Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ~＼",
	}, { // 1138
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ～＼",
		out:  "␔Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ～＼",
	}, { // 1139
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ~～",
		out:  "␔Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ~～",
	}, { // 1140
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ～～",
		out:  "␔Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ～～",
	}, { // 1141
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<~",
		out:  "␔Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<~",
	}, { // 1142
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "\x14Ｓ＊１Ｑ␍[_ζ|~τ\rδＵ␗␆jξ\x1cνYＨＶ>%␂ζ<～",
		out:  "␔Ｓ＊１Ｑ‛␍[_ζ|~τ␍δＵ‛␗‛␆jξ␜νYＨＶ>%‛␂ζ<～",
	}, { // 1143
		mask: EncodeLeftCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 1144
		mask: EncodeLeftCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 1145
		mask: EncodeLeftCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 1146
		mask: EncodeLeftCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 1147
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
		out:  "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
	}, { // 1148
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
		out:  "␉␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
	}, { // 1149
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
		out:  "‛␉␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
	}, { // 1150
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
		out:  "␉？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
	}, { // 1151
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
		out:  "‛␉？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
	}, { // 1152
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
		out:  "␉？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
	}, { // 1153
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
		out:  "‛␉？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
	}, { // 1154
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"\t␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
		out:  "\"\t␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
	}, { // 1155
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
		out:  "\"␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␅",
	}, { // 1156
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"\t␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
		out:  "\"\t␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
	}, { // 1157
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
		out:  "\"␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
	}, { // 1158
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"\t␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
		out:  "\"\t␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
	}, { // 1159
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
		out:  "\"␉␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
	}, { // 1160
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ\t␅",
		out:  "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ\t␅",
	}, { // 1161
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
		out:  "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␅",
	}, { // 1162
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ\t␉",
		out:  "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ\t␉",
	}, { // 1163
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␉",
		out:  "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａ␉␉",
	}, { // 1164
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη\t",
		out:  "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη\t",
	}, { // 1165
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
		out:  "\"？␒>｜\x1fκUＲ\x15\t＞'λ\x1b：ＡｌRＩωοRC＇φ/Ａη␉",
	}, { // 1166
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
		out:  "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
	}, { // 1167
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\n␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
		out:  "␊␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
	}, { // 1168
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
		out:  "‛␊␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
	}, { // 1169
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\nu%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
		out:  "␊u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
	}, { // 1170
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
		out:  "‛␊u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
	}, { // 1171
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\nu%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
		out:  "␊u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
	}, { // 1172
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
		out:  "‛␊u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
	}, { // 1173
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17\n%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
		out:  "\x17\n%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
	}, { // 1174
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
		out:  "\x17␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π＂",
	}, { // 1175
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17\n%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
		out:  "\x17\n%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
	}, { // 1176
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
		out:  "\x17␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
	}, { // 1177
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17\n%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
		out:  "\x17\n%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
	}, { // 1178
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
		out:  "\x17␊%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
	}, { // 1179
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕\n＂",
		out:  "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕\n＂",
	}, { // 1180
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
		out:  "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊＂",
	}, { // 1181
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕\n␊",
		out:  "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕\n␊",
	}, { // 1182
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊␊",
		out:  "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕␊␊",
	}, { // 1183
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π\n",
		out:  "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π\n",
	}, { // 1184
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
		out:  "\x17u%χＤς［ＨM：\n1kψν！\b\x15␍k＇;Ｉ｀\x12θo␕π␊",
	}, { // 1185
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
		out:  ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
	}, { // 1186
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
		out:  "␋␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
	}, { // 1187
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
		out:  "‛␋␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
	}, { // 1188
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\vι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
		out:  "␋ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
	}, { // 1189
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
		out:  "‛␋ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
	}, { // 1190
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\vι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
		out:  "␋ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
	}, { // 1191
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
		out:  "‛␋ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
	}, { // 1192
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";\v５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
		out:  ";\v５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
	}, { // 1193
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
		out:  ";␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L；",
	}, { // 1194
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";\v５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
		out:  ";\v５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
	}, { // 1195
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
		out:  ";␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
	}, { // 1196
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";\v５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
		out:  ";\v５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
	}, { // 1197
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
		out:  ";␋５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
	}, { // 1198
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐\v；",
		out:  ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐\v；",
	}, { // 1199
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
		out:  ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋；",
	}, { // 1200
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐\v␋",
		out:  ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐\v␋",
	}, { // 1201
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋␋",
		out:  ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐␋␋",
	}, { // 1202
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L\v",
		out:  ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L\v",
	}, { // 1203
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
		out:  ";ι５:ω␚␂!ξ\x13\v\x05\nυ３␔Ｇ３␊aε/Dｄ\x1dσH␐L␋",
	}, { // 1204
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "οδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|/",
		out:  "οδξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|/",
	}, { // 1205
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r␍ξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|/",
		out:  "␍␍ξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|/",
	}, { // 1206
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍␍ξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|/",
		out:  "‛␍␍ξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|/",
	}, { // 1207
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\rδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ␍/",
		out:  "␍δξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ␍/",
	}, { // 1208
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍δξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ␍/",
		out:  "‛␍δξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ␍/",
	}, { // 1209
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\rδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|␍",
		out:  "␍δξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|␍",
	}, { // 1210
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍δξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|␍",
		out:  "‛␍δξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|␍",
	}, { // 1211
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ο\rξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|/",
		out:  "ο\rξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|/",
	}, { // 1212
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ο␍ξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|/",
		out:  "ο␍ξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|/",
	}, { // 1213
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ο\rξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ␍/",
		out:  "ο\rξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ␍/",
	}, { // 1214
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ο␍ξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ␍/",
		out:  "ο␍ξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ␍/",
	}, { // 1215
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ο\rξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|␍",
		out:  "ο\rξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|␍",
	}, { // 1216
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ο␍ξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|␍",
		out:  "ο␍ξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|␍",
	}, { // 1217
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "οδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ\r/",
		out:  "οδξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ\r/",
	}, { // 1218
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "οδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ␍/",
		out:  "οδξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ␍/",
	}, { // 1219
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "οδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ\r␍",
		out:  "οδξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ\r␍",
	}, { // 1220
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "οδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ␍␍",
		out:  "οδξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ␍␍",
	}, { // 1221
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "οδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|\r",
		out:  "οδξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|\r",
	}, { // 1222
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "οδξ␜＇qςwψｑ\r␌␚\x00V␀ωｙ\f\x00＃Ｍ\v%Ｎ２Wｏ|␍",
		out:  "οδξ␜＇qςwψｑ\r␌␚␀V‛␀ωｙ\f␀＃Ｍ\v%Ｎ２Wｏ|␍",
	}, { // 1223
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
		out:  "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
	}, { // 1224
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
		out:  "␉␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
	}, { // 1225
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
		out:  "‛␉␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
	}, { // 1226
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\tQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
		out:  "␉Q␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
	}, { // 1227
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉Q␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
		out:  "‛␉Q␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
	}, { // 1228
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\tQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
		out:  "␉Q␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
	}, { // 1229
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉Q␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
		out:  "‛␉Q␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
	}, { // 1230
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χ\t␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
		out:  "χ\t␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
	}, { // 1231
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χ␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
		out:  "χ␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\x15",
	}, { // 1232
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χ\t␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
		out:  "χ\t␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
	}, { // 1233
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χ␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
		out:  "χ␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
	}, { // 1234
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χ\t␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
		out:  "χ\t␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
	}, { // 1235
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χ␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
		out:  "χ␉␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
	}, { // 1236
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀\t\x15",
		out:  "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀\t\x15",
	}, { // 1237
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
		out:  "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉\x15",
	}, { // 1238
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀\t␉",
		out:  "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀\t␉",
	}, { // 1239
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉␉",
		out:  "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀␉␉",
	}, { // 1240
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\t",
		out:  "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊\t",
	}, { // 1241
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
		out:  "χQ␙\"ξ\n＝SＰ%\tκβ\aφzW\x1d␆ｉ\"␍␛5）τ６｀＊␉",
	}, { // 1242
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
		out:  "＜|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
	}, { // 1243
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
		out:  "␊␊＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
	}, { // 1244
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
		out:  "‛␊␊＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
	}, { // 1245
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
		out:  "␊|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
	}, { // 1246
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
		out:  "‛␊|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
	}, { // 1247
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
		out:  "␊|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
	}, { // 1248
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
		out:  "‛␊|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
	}, { // 1249
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜\n＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
		out:  "＜\n＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
	}, { // 1250
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜␊＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
		out:  "＜␊＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾wδ",
	}, { // 1251
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜\n＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
		out:  "＜\n＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
	}, { // 1252
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜␊＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
		out:  "＜␊＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
	}, { // 1253
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜\n＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
		out:  "＜\n＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
	}, { // 1254
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜␊＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
		out:  "＜␊＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
	}, { // 1255
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾\nδ",
		out:  "＜|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾\nδ",
	}, { // 1256
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
		out:  "＜|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾␊δ",
	}, { // 1257
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾\n␊",
		out:  "＜|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾\n␊",
	}, { // 1258
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾␊␊",
		out:  "＜|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾␊␊",
	}, { // 1259
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾w\n",
		out:  "＜|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾w\n",
	}, { // 1260
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "＜|＞φ＞.\x1d＼ｉG\nξ\v␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
		out:  "＜|＞φ＞.\x1d＼ｉG\nξ\v‛␀%[ρθ：\x06?｀␄P;σ＿＾w␊",
	}, { // 1261
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４ψ",
		out:  "␉␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４ψ",
	}, { // 1262
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４ψ",
		out:  "␋␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４ψ",
	}, { // 1263
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４ψ",
		out:  "‛␋␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４ψ",
	}, { // 1264
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ␋ψ",
		out:  "␋␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ␋ψ",
	}, { // 1265
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ␋ψ",
		out:  "‛␋␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ␋ψ",
	}, { // 1266
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４␋",
		out:  "␋␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４␋",
	}, { // 1267
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４␋",
		out:  "‛␋␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４␋",
	}, { // 1268
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t\v％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４ψ",
		out:  "␉\v％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４ψ",
	}, { // 1269
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４ψ",
		out:  "␉␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４ψ",
	}, { // 1270
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t\v％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ␋ψ",
		out:  "␉\v％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ␋ψ",
	}, { // 1271
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ␋ψ",
		out:  "␉␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ␋ψ",
	}, { // 1272
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t\v％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４␋",
		out:  "␉\v％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４␋",
	}, { // 1273
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４␋",
		out:  "␉␋％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４␋",
	}, { // 1274
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ\vψ",
		out:  "␉␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ\vψ",
	}, { // 1275
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ␋ψ",
		out:  "␉␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ␋ψ",
	}, { // 1276
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ\v␋",
		out:  "␉␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ\v␋",
	}, { // 1277
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ␋␋",
		out:  "␉␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ␋␋",
	}, { // 1278
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４\v",
		out:  "␉␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４\v",
	}, { // 1279
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ/ｎ４␋",
		out:  "␉␑％␞ς$\v＇␋:\vλ␞ｚ␊f|８\x02DςRρ&ξＯ／ｎ４␋",
	}, { // 1280
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:{",
		out:  "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:{",
	}, { // 1281
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:{",
		out:  "␍␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:{",
	}, { // 1282
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:{",
		out:  "‛␍␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:{",
	}, { // 1283
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n␍{",
		out:  "␍）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n␍{",
	}, { // 1284
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n␍{",
		out:  "‛␍）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n␍{",
	}, { // 1285
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:␍",
		out:  "␍）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:␍",
	}, { // 1286
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:␍",
		out:  "‛␍）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:␍",
	}, { // 1287
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ\rζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:{",
		out:  "ψ\rζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:{",
	}, { // 1288
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:{",
		out:  "ψ␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:{",
	}, { // 1289
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ\rζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n␍{",
		out:  "ψ\rζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n␍{",
	}, { // 1290
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n␍{",
		out:  "ψ␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n␍{",
	}, { // 1291
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ\rζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:␍",
		out:  "ψ\rζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:␍",
	}, { // 1292
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:␍",
		out:  "ψ␍ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:␍",
	}, { // 1293
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n\r{",
		out:  "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n\r{",
	}, { // 1294
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n␍{",
		out:  "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n␍{",
	}, { // 1295
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n\r␍",
		out:  "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n\r␍",
	}, { // 1296
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n␍␍",
		out:  "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n␍␍",
	}, { // 1297
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:\r",
		out:  "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:\r",
	}, { // 1298
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r／␘␙）ω!ψ１？\n:␍",
		out:  "ψ）ζ<␕a－7\x15\x0e\r＊＆ρＣ$τ\r‛／␘␙）ω!ψ１？\n:␍",
	}, { // 1299
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
		out:  "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
	}, { // 1300
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
		out:  "␉␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
	}, { // 1301
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
		out:  "‛␉␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
	}, { // 1302
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
		out:  "␉␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
	}, { // 1303
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
		out:  "‛␉␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
	}, { // 1304
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
		out:  "␉␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
	}, { // 1305
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
		out:  "‛␉␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
	}, { // 1306
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β\t&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
		out:  "β\t&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
	}, { // 1307
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
		out:  "β␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐη",
	}, { // 1308
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β\t&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
		out:  "β\t&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
	}, { // 1309
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
		out:  "β␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
	}, { // 1310
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β\t&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
		out:  "β\t&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
	}, { // 1311
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
		out:  "β␉&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
	}, { // 1312
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ\tη",
		out:  "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ\tη",
	}, { // 1313
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
		out:  "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉η",
	}, { // 1314
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ\t␉",
		out:  "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ\t␉",
	}, { // 1315
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉␉",
		out:  "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵ␉␉",
	}, { // 1316
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ\t",
		out:  "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ\t",
	}, { // 1317
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
		out:  "β␙&Ｊ＿］;ｉτθ\t\x0eN␗Ｉ\x16aβ␈\x16＞>＄\x0e\a_αＵｐ␉",
	}, { // 1318
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμη",
		out:  "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμη",
	}, { // 1319
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμη",
		out:  "␊␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμη",
	}, { // 1320
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμη",
		out:  "‛␊␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμη",
	}, { // 1321
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\nI_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H␊η",
		out:  "␊I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H␊η",
	}, { // 1322
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H␊η",
		out:  "‛␊I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H␊η",
	}, { // 1323
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\nI_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμ␊",
		out:  "␊I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμ␊",
	}, { // 1324
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμ␊",
		out:  "‛␊I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμ␊",
	}, { // 1325
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|\n_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμη",
		out:  "|\n_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμη",
	}, { // 1326
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμη",
		out:  "|␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμη",
	}, { // 1327
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|\n_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H␊η",
		out:  "|\n_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H␊η",
	}, { // 1328
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H␊η",
		out:  "|␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H␊η",
	}, { // 1329
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|\n_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμ␊",
		out:  "|\n_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμ␊",
	}, { // 1330
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμ␊",
		out:  "|␊_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμ␊",
	}, { // 1331
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H\nη",
		out:  "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H\nη",
	}, { // 1332
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H␊η",
		out:  "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H␊η",
	}, { // 1333
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H\n␊",
		out:  "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H\n␊",
	}, { // 1334
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$H␊␊",
		out:  "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$H␊␊",
	}, { // 1335
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμ\n",
		out:  "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμ\n",
	}, { // 1336
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ＇$Hμ␊",
		out:  "|I_υｂ␙＝␟＞\x17\n]␅ｙ(␉␘\v\x1cＩξ$\x04υγ‛＇$Hμ␊",
	}, { // 1337
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
		out:  "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
	}, { // 1338
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
		out:  "␋␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
	}, { // 1339
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
		out:  "‛␋␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
	}, { // 1340
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\vＫη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
		out:  "␋Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
	}, { // 1341
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
		out:  "‛␋Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
	}, { // 1342
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\vＫη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
		out:  "␋Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
	}, { // 1343
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
		out:  "‛␋Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
	}, { // 1344
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘\vη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
		out:  "␘\vη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
	}, { // 1345
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
		out:  "␘␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉＸ",
	}, { // 1346
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘\vη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
		out:  "␘\vη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
	}, { // 1347
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
		out:  "␘␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
	}, { // 1348
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘\vη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
		out:  "␘\vη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
	}, { // 1349
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
		out:  "␘␋η／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
	}, { // 1350
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[\vＸ",
		out:  "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[\vＸ",
	}, { // 1351
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
		out:  "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋Ｘ",
	}, { // 1352
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[\v␋",
		out:  "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[\v␋",
	}, { // 1353
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋␋",
		out:  "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[␋␋",
	}, { // 1354
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ\v",
		out:  "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ\v",
	}, { // 1355
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
		out:  "␘Ｋη／ο｛W_␜Ｋ\v\x14%\x13／s{!ρ］?␄rωγ｝\x0e[ｉ␋",
	}, { // 1356
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσTO",
		out:  "：ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσTO",
	}, { // 1357
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσTO",
		out:  "␍␍|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσTO",
	}, { // 1358
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσTO",
		out:  "‛␍␍|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσTO",
	}, { // 1359
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\rρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
		out:  "␍ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
	}, { // 1360
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
		out:  "‛␍ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
	}, { // 1361
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\rρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
		out:  "␍ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
	}, { // 1362
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
		out:  "‛␍ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
	}, { // 1363
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：\r|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσTO",
		out:  "：\r|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσTO",
	}, { // 1364
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：␍|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσTO",
		out:  "：␍|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσTO",
	}, { // 1365
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：\r|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
		out:  "：\r|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
	}, { // 1366
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：␍|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
		out:  "：␍|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
	}, { // 1367
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：\r|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
		out:  "：\r|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
	}, { // 1368
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：␍|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
		out:  "：␍|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
	}, { // 1369
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ\rO",
		out:  "：ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ\rO",
	}, { // 1370
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
		out:  "：ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ␍O",
	}, { // 1371
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ\r␍",
		out:  "：ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ\r␍",
	}, { // 1372
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσ␍␍",
		out:  "：ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσ␍␍",
	}, { // 1373
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσT\r",
		out:  "：ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσT\r",
	}, { // 1374
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "：ρ|#~ςT␃ｗ␐\r\x05φ＄／＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
		out:  "：ρ|#~ςT␃ｗ␐\r\x05φ＄／‛＇ｑτ#？\b\f␃\x1bｉτＶσT␍",
	}, { // 1375
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "GD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτdφ",
		out:  "GD［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτdφ",
	}, { // 1376
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτdφ",
		out:  "␉␉［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτdφ",
	}, { // 1377
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτdφ",
		out:  "‛␉␉［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτdφ",
	}, { // 1378
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\tD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ␉φ",
		out:  "␉D［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ␉φ",
	}, { // 1379
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉D［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ␉φ",
		out:  "‛␉D［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ␉φ",
	}, { // 1380
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\tD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτd␉",
		out:  "␉D［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτd␉",
	}, { // 1381
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉D［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτd␉",
		out:  "‛␉D［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτd␉",
	}, { // 1382
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "G\t［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτdφ",
		out:  "G\t［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτdφ",
	}, { // 1383
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "G␉［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτdφ",
		out:  "G␉［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτdφ",
	}, { // 1384
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "G\t［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ␉φ",
		out:  "G\t［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ␉φ",
	}, { // 1385
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "G␉［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ␉φ",
		out:  "G␉［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ␉φ",
	}, { // 1386
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "G\t［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτd␉",
		out:  "G\t［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτd␉",
	}, { // 1387
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "G␉［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτd␉",
		out:  "G␉［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτd␉",
	}, { // 1388
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "GD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ\tφ",
		out:  "GD［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ\tφ",
	}, { // 1389
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "GD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ␉φ",
		out:  "GD［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ␉φ",
	}, { // 1390
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "GD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ\t␉",
		out:  "GD［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ\t␉",
	}, { // 1391
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "GD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτ␉␉",
		out:  "GD［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτ␉␉",
	}, { // 1392
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "GD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτd\t",
		out:  "GD［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτd\t",
	}, { // 1393
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "GD［\v＃Ｔ＃σ>％\tmθ␝I～？\x00ｚｎλ\x06\x0f␉␞<υτd␉",
		out:  "GD［\v＃Ｔ＃σ>％\tmθ␝I～？␀ｚｎλ\x06\x0f␉␞<υτd␉",
	}, { // 1394
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
		out:  "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
	}, { // 1395
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
		out:  "␊␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
	}, { // 1396
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
		out:  "‛␊␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
	}, { // 1397
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\nVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
		out:  "␊Vχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
	}, { // 1398
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊Vχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
		out:  "‛␊Vχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
	}, { // 1399
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\nVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
		out:  "␊Vχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
	}, { // 1400
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊Vχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
		out:  "‛␊Vχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
	}, { // 1401
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξ\nχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
		out:  "ξ\nχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
	}, { // 1402
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξ␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
		out:  "ξ␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU％",
	}, { // 1403
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξ\nχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
		out:  "ξ\nχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
	}, { // 1404
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξ␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
		out:  "ξ␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
	}, { // 1405
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξ\nχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
		out:  "ξ\nχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
	}, { // 1406
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξ␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
		out:  "ξ␊χκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
	}, { // 1407
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ\n％",
		out:  "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ\n％",
	}, { // 1408
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
		out:  "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊％",
	}, { // 1409
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ\n␊",
		out:  "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ\n␊",
	}, { // 1410
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊␊",
		out:  "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδ␊␊",
	}, { // 1411
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU\n",
		out:  "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU\n",
	}, { // 1412
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
		out:  "ξVχκγ \x01u\b＼\n#４␉YＡ＂␗＂/ｋι\x05＇\x13\bＡδU␊",
	}, { // 1413
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
		out:  "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
	}, { // 1414
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
		out:  "␋␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
	}, { // 1415
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
		out:  "‛␋␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
	}, { // 1416
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
		out:  "␋␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
	}, { // 1417
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
		out:  "‛␋␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
	}, { // 1418
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
		out:  "␋␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
	}, { // 1419
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
		out:  "‛␋␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
	}, { // 1420
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚\v(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
		out:  "␚\v(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
	}, { // 1421
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
		out:  "␚␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃ρ",
	}, { // 1422
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚\v(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
		out:  "␚\v(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
	}, { // 1423
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
		out:  "␚␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
	}, { // 1424
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚\v(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
		out:  "␚\v(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
	}, { // 1425
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
		out:  "␚␋(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
	}, { // 1426
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>\vρ",
		out:  "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>\vρ",
	}, { // 1427
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
		out:  "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋ρ",
	}, { // 1428
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>\v␋",
		out:  "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>\v␋",
	}, { // 1429
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋␋",
		out:  "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␋␋",
	}, { // 1430
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃\v",
		out:  "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃\v",
	}, { // 1431
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
		out:  "␚␝(nευＺｏ；\x1a\v＊;r␓\x01X３|\"＞%␞σ\x0fπＺ>␃␋",
	}, { // 1432
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
		out:  "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
	}, { // 1433
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
		out:  "␍␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
	}, { // 1434
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
		out:  "‛␍␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
	}, { // 1435
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
		out:  "␍␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
	}, { // 1436
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
		out:  "‛␍␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
	}, { // 1437
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
		out:  "␍␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
	}, { // 1438
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
		out:  "‛␍␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
	}, { // 1439
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ\r／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
		out:  "Ｕ\r／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
	}, { // 1440
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
		out:  "Ｕ␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι＄",
	}, { // 1441
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ\r／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
		out:  "Ｕ\r／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
	}, { // 1442
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
		out:  "Ｕ␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
	}, { // 1443
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ\r／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
		out:  "Ｕ\r／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
	}, { // 1444
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
		out:  "Ｕ␍／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
	}, { // 1445
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04\r＄",
		out:  "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04\r＄",
	}, { // 1446
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
		out:  "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍＄",
	}, { // 1447
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04\r␍",
		out:  "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04\r␍",
	}, { // 1448
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍␍",
		out:  "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04␍␍",
	}, { // 1449
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι\r",
		out:  "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι\r",
	}, { // 1450
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
		out:  "Ｕ␅／ς\x17Ｃς＞Ｐ\x01\r#␔/\x1cＱ%％!β\x03＾６ψ IB\x04ι␍",
	}, { // 1451
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
		out:  "?`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
	}, { // 1452
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t␉δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
		out:  "␉␉δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
	}, { // 1453
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉␉δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
		out:  "‛␉␉δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
	}, { // 1454
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
		out:  "␉`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
	}, { // 1455
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
		out:  "‛␉`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
	}, { // 1456
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
		out:  "␉`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
	}, { // 1457
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
		out:  "‛␉`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
	}, { // 1458
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?\tδＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
		out:  "?\tδＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
	}, { // 1459
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?␉δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
		out:  "?␉δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;xπ",
	}, { // 1460
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?\tδＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
		out:  "?\tδＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
	}, { // 1461
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?␉δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
		out:  "?␉δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
	}, { // 1462
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?\tδＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
		out:  "?\tδＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
	}, { // 1463
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?␉δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
		out:  "?␉δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
	}, { // 1464
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;\tπ",
		out:  "?`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;\tπ",
	}, { // 1465
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
		out:  "?`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉π",
	}, { // 1466
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;\t␉",
		out:  "?`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;\t␉",
	}, { // 1467
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉␉",
		out:  "?`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;␉␉",
	}, { // 1468
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x\t",
		out:  "?`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x\t",
	}, { // 1469
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "?`δＣπ\x00；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
		out:  "?`δＣπ␀；γ␗３\t␜％］/ｑιｌN␃\x06#ρ4Ｐ9␖;x␉",
	}, { // 1470
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
		out:  "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
	}, { // 1471
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
		out:  "␊␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
	}, { // 1472
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
		out:  "‛␊␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
	}, { // 1473
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
		out:  "␊］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
	}, { // 1474
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
		out:  "‛␊］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
	}, { // 1475
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
		out:  "␊］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
	}, { // 1476
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
		out:  "‛␊］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
	}, { // 1477
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10\nφυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
		out:  "\x10\nφυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
	}, { // 1478
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
		out:  "\x10␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ5",
	}, { // 1479
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10\nφυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
		out:  "\x10\nφυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
	}, { // 1480
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
		out:  "\x10␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
	}, { // 1481
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10\nφυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
		out:  "\x10\nφυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
	}, { // 1482
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
		out:  "\x10␊φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
	}, { // 1483
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!\n5",
		out:  "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!\n5",
	}, { // 1484
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
		out:  "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊5",
	}, { // 1485
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!\n␊",
		out:  "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!\n␊",
	}, { // 1486
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊␊",
		out:  "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!␊␊",
	}, { // 1487
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ\n",
		out:  "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ\n",
	}, { // 1488
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
		out:  "\x10］φυρ＃9ξb'\n␍␍\x17^＇␊ｙｉαφ␇O2Ｆ\r\x11!ｍ␊",
	}, { // 1489
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒`",
		out:  "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒`",
	}, { // 1490
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\v␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒`",
		out:  "␋␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒`",
	}, { // 1491
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒`",
		out:  "‛␋␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒`",
	}, { // 1492
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\vＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␋`",
		out:  "␋ＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␋`",
	}, { // 1493
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋ＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␋`",
		out:  "‛␋ＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␋`",
	}, { // 1494
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\vＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒␋",
		out:  "␋ＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒␋",
	}, { // 1495
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋ＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒␋",
		out:  "‛␋ＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒␋",
	}, { // 1496
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "u\vｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒`",
		out:  "u\vｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒`",
	}, { // 1497
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "u␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒`",
		out:  "u␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒`",
	}, { // 1498
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "u\vｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␋`",
		out:  "u\vｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␋`",
	}, { // 1499
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "u␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␋`",
		out:  "u␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␋`",
	}, { // 1500
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "u\vｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒␋",
		out:  "u\vｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒␋",
	}, { // 1501
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "u␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒␋",
		out:  "u␋ｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒␋",
	}, { // 1502
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ\v`",
		out:  "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ\v`",
	}, { // 1503
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␋`",
		out:  "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␋`",
	}, { // 1504
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ\v␋",
		out:  "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ\v␋",
	}, { // 1505
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␋␋",
		out:  "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␋␋",
	}, { // 1506
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒\v",
		out:  "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒\v",
	}, { // 1507
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛␀βｄ/γ␚\x13ｙ␒␋",
		out:  "uＣｚβJς\n␟Ｄ:\vυδI␟．\x06\x18]␛‛␀βｄ/γ␚\x13ｙ␒␋",
	}, { // 1508
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
		out:  "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
	}, { // 1509
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\r␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
		out:  "␍␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
	}, { // 1510
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
		out:  "‛␍␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
	}, { // 1511
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\rＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
		out:  "␍ＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
	}, { // 1512
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍ＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
		out:  "‛␍ＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
	}, { // 1513
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\rＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
		out:  "␍ＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
	}, { // 1514
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍ＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
		out:  "‛␍ＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
	}, { // 1515
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "H\rJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
		out:  "H\rJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
	}, { // 1516
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "H␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
		out:  "H␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00πυ",
	}, { // 1517
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "H\rJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
		out:  "H\rJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
	}, { // 1518
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "H␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
		out:  "H␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
	}, { // 1519
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "H\rJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
		out:  "H\rJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
	}, { // 1520
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "H␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
		out:  "H␍J$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
	}, { // 1521
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00\rυ",
		out:  "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00\rυ",
	}, { // 1522
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
		out:  "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍υ",
	}, { // 1523
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00\r␍",
		out:  "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00\r␍",
	}, { // 1524
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍␍",
		out:  "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00␍␍",
	}, { // 1525
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π\r",
		out:  "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π\r",
	}, { // 1526
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
		out:  "HＶJ$␔Ｔ;σ␘Y\r／␌＊a\x1f｛␐ζｑ`χ!'#Ｙθ\uff00π␍",
	}, { // 1527
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
		out:  "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
	}, { // 1528
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\t␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
		out:  "␉␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
	}, { // 1529
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
		out:  "‛␉␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
	}, { // 1530
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\tｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
		out:  "␉ｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
	}, { // 1531
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉ｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
		out:  "‛␉ｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
	}, { // 1532
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\tｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
		out:  "␉ｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
	}, { // 1533
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉ｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
		out:  "‛␉ｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
	}, { // 1534
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δ\tＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
		out:  "δ\tＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
	}, { // 1535
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δ␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
		out:  "δ␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\n",
	}, { // 1536
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δ\tＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
		out:  "δ\tＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
	}, { // 1537
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δ␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
		out:  "δ␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
	}, { // 1538
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δ\tＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
		out:  "δ\tＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
	}, { // 1539
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δ␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
		out:  "δ␉Ｂ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
	}, { // 1540
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b\t\n",
		out:  "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b\t\n",
	}, { // 1541
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
		out:  "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉\n",
	}, { // 1542
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b\t␉",
		out:  "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b\t␉",
	}, { // 1543
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉␉",
		out:  "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\b␉␉",
	}, { // 1544
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\t",
		out:  "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ\t",
	}, { // 1545
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
		out:  "δｆＢ/？ηyξ\x1aυ\t+␍＜␉＿\x14␗5%！θ␋eG>Ｘ\bκ␉",
	}, { // 1546
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␏",
		out:  "␀χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␏",
	}, { // 1547
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\n␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␏",
		out:  "␊␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␏",
	}, { // 1548
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␏",
		out:  "‛␊␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␏",
	}, { // 1549
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\nχξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠␊␏",
		out:  "␊χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠␊␏",
	}, { // 1550
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠␊␏",
		out:  "‛␊χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠␊␏",
	}, { // 1551
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\nχξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␊",
		out:  "␊χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␊",
	}, { // 1552
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␊",
		out:  "‛␊χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␊",
	}, { // 1553
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00\nξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␏",
		out:  "␀\nξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␏",
	}, { // 1554
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␏",
		out:  "␀␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␏",
	}, { // 1555
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00\nξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠␊␏",
		out:  "␀\nξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠␊␏",
	}, { // 1556
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠␊␏",
		out:  "␀␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠␊␏",
	}, { // 1557
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00\nξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␊",
		out:  "␀\nξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␊",
	}, { // 1558
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␊",
		out:  "␀␊ξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␊",
	}, { // 1559
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\n␏",
		out:  "␀χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\n␏",
	}, { // 1560
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠␊␏",
		out:  "␀χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠␊␏",
	}, { // 1561
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\n␊",
		out:  "␀χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\n␊",
	}, { // 1562
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠␊␊",
		out:  "␀χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠␊␊",
	}, { // 1563
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a\n",
		out:  "␀χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a\n",
	}, { // 1564
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\x00χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.］␖＃＞ｏψ＠\a␊",
		out:  "␀χξ?␌\x1f\x1buβ－\nπγ$？tsｊ＜4.‛］␖＃＞ｏψ＠\a␊",
	}, { // 1565
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞κ",
		out:  "X␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞κ",
	}, { // 1566
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\v␋Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞κ",
		out:  "␋␋Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞κ",
	}, { // 1567
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋␋Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞κ",
		out:  "‛␋␋Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞κ",
	}, { // 1568
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\v␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊␋κ",
		out:  "␋␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊␋κ",
	}, { // 1569
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊␋κ",
		out:  "‛␋␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊␋κ",
	}, { // 1570
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\v␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞␋",
		out:  "␋␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞␋",
	}, { // 1571
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞␋",
		out:  "‛␋␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞␋",
	}, { // 1572
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X\vUpη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞κ",
		out:  "X\vUpη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞κ",
	}, { // 1573
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␋Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞κ",
		out:  "X␋Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞κ",
	}, { // 1574
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X\vUpη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊␋κ",
		out:  "X\vUpη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊␋κ",
	}, { // 1575
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␋Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊␋κ",
		out:  "X␋Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊␋κ",
	}, { // 1576
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X\vUpη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞␋",
		out:  "X\vUpη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞␋",
	}, { // 1577
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␋Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞␋",
		out:  "X␋Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞␋",
	}, { // 1578
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊\vκ",
		out:  "X␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊\vκ",
	}, { // 1579
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊␋κ",
		out:  "X␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊␋κ",
	}, { // 1580
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊\v␋",
		out:  "X␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊\v␋",
	}, { // 1581
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊␋␋",
		out:  "X␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊␋␋",
	}, { // 1582
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞\v",
		out:  "X␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞\v",
	}, { // 1583
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "X␛Upη␝\f＇\x00A\vＹψｘ␍ｈηＴ\x15\x057\x00␛ψ2Ｄ[＊＞␋",
		out:  "X␛Upη␝\f＇␀A\vＹψｘ␍ｈηＴ\x15\x057␀␛ψ2Ｄ［＊＞␋",
	}, { // 1584
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
		out:  "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
	}, { // 1585
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\r␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
		out:  "␍␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
	}, { // 1586
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
		out:  "‛␍␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
	}, { // 1587
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\rβ8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
		out:  "␍β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
	}, { // 1588
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
		out:  "‛␍β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
	}, { // 1589
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\rβ8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
		out:  "␍β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
	}, { // 1590
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
		out:  "‛␍β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
	}, { // 1591
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／\r8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
		out:  "／\r8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
	}, { // 1592
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
		out:  "／␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZc",
	}, { // 1593
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／\r8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
		out:  "／\r8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
	}, { // 1594
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
		out:  "／␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
	}, { // 1595
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／\r8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
		out:  "／\r8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
	}, { // 1596
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
		out:  "／␍8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
	}, { // 1597
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ\rc",
		out:  "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ\rc",
	}, { // 1598
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
		out:  "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍c",
	}, { // 1599
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ\r␍",
		out:  "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ\r␍",
	}, { // 1600
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍␍",
		out:  "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθ␍␍",
	}, { // 1601
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ\r",
		out:  "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ\r",
	}, { // 1602
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
		out:  "／β8\x17r␈␉χ\x11\x10\r｛␏｝␆ζψ\x0f\"8％１\aＫ｛ξｅθZ␍",
	}, { // 1603
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␀",
		out:  "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ‛␀",
	}, { // 1604
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\t␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␀",
		out:  "␉␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ‛␀",
	}, { // 1605
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␉␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␀",
		out:  "‛␉␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ‛␀",
	}, { // 1606
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\t＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉␀",
		out:  "␉＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉‛␀",
	}, { // 1607
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␉＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉␀",
		out:  "‛␉＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉‛␀",
	}, { // 1608
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\t＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
		out:  "␉＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
	}, { // 1609
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␉＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
		out:  "‛␉＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
	}, { // 1610
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[\t9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␀",
		out:  "[\t9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ‛␀",
	}, { // 1611
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␀",
		out:  "[␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ‛␀",
	}, { // 1612
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[\t9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉␀",
		out:  "[\t9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉‛␀",
	}, { // 1613
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉␀",
		out:  "[␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉‛␀",
	}, { // 1614
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[\t9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
		out:  "[\t9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
	}, { // 1615
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
		out:  "[␉9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
	}, { // 1616
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM\t␀",
		out:  "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM\t‛␀",
	}, { // 1617
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉␀",
		out:  "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉‛␀",
	}, { // 1618
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM\t␉",
		out:  "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM\t␉",
	}, { // 1619
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉␉",
		out:  "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τM␉␉",
	}, { // 1620
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ\t",
		out:  "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ\t",
	}, { // 1621
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
		out:  "[＊9？Fφ␃ｆＶη\t␈＞\t\x16δｋ*#ψ３\x11O␁\x05｀τMρ␉",
	}, { // 1622
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
		out:  "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
	}, { // 1623
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\n␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
		out:  "␊␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
	}, { // 1624
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␊␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
		out:  "‛␊␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
	}, { // 1625
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\n#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
		out:  "␊#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
	}, { // 1626
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␊#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
		out:  "‛␊#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
	}, { // 1627
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\n#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
		out:  "␊#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
	}, { // 1628
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␊#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
		out:  "‛␊#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
	}, { // 1629
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς\nδ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
		out:  "ς\nδ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
	}, { // 1630
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
		out:  "ς␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␄",
	}, { // 1631
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς\nδ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
		out:  "ς\nδ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
	}, { // 1632
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
		out:  "ς␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
	}, { // 1633
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς\nδ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
		out:  "ς\nδ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
	}, { // 1634
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
		out:  "ς␊δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
	}, { // 1635
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ\n␄",
		out:  "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ\n␄",
	}, { // 1636
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
		out:  "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␄",
	}, { // 1637
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ\n␊",
		out:  "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ\n␊",
	}, { // 1638
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␊",
		out:  "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15Ｐ␊␊",
	}, { // 1639
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU\n",
		out:  "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU\n",
	}, { // 1640
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
		out:  "ς#δ␝␁\x18Ｖφ＊]\n？␘\">R␈ｒRν\x01＿ζψｉC\x15ＰU␊",
	}, { // 1641
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
		out:  "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
	}, { // 1642
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\v␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
		out:  "␋␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
	}, { // 1643
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␋␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
		out:  "‛␋␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
	}, { // 1644
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\v!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
		out:  "␋!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
	}, { // 1645
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␋!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
		out:  "‛␋!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
	}, { // 1646
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\v!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
		out:  "␋!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
	}, { // 1647
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␋!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
		out:  "‛␋!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
	}, { // 1648
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι\v？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
		out:  "ι\v？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
	}, { // 1649
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
		out:  "ι␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10？",
	}, { // 1650
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι\v？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
		out:  "ι\v？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
	}, { // 1651
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
		out:  "ι␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
	}, { // 1652
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι\v？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
		out:  "ι\v？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
	}, { // 1653
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
		out:  "ι␋？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
	}, { // 1654
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\v？",
		out:  "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\v？",
	}, { // 1655
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
		out:  "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋？",
	}, { // 1656
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\v␋",
		out:  "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\v␋",
	}, { // 1657
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋␋",
		out:  "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A␋␋",
	}, { // 1658
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10\v",
		out:  "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10\v",
	}, { // 1659
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
		out:  "ι!？θ\fλ*␕\x1f␂\vＭGUζ␋(`Ｘｌｅ\x12ａδκ＃␡A\x10␋",
	}, { // 1660
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
		out:  "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
	}, { // 1661
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\r␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
		out:  "␍␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
	}, { // 1662
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␍␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
		out:  "‛␍␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
	}, { // 1663
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\rχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
		out:  "␍χZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
	}, { // 1664
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␍χZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
		out:  "‛␍χZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
	}, { // 1665
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\rχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
		out:  "␍χZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
	}, { // 1666
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␍χZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
		out:  "‛␍χZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
	}, { // 1667
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "a\rZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
		out:  "a\rZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
	}, { // 1668
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "a␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
		out:  "a␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9Uν",
	}, { // 1669
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "a\rZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
		out:  "a\rZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
	}, { // 1670
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "a␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
		out:  "a␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
	}, { // 1671
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "a\rZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
		out:  "a\rZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
	}, { // 1672
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "a␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
		out:  "a␍Z\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
	}, { // 1673
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9\rν",
		out:  "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9\rν",
	}, { // 1674
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
		out:  "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍ν",
	}, { // 1675
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9\r␍",
		out:  "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9\r␍",
	}, { // 1676
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍␍",
		out:  "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9␍␍",
	}, { // 1677
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U\r",
		out:  "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U\r",
	}, { // 1678
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
		out:  "aχZ\x06＇\nｑλ ７\r８ψ＇：\nω\\α＄ｓＪ␌ｐ％\x1b?9U␍",
	}, { // 1679
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
		out:  "␎C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
	}, { // 1680
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\t␉6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
		out:  "␉␉6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
	}, { // 1681
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␉␉6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
		out:  "‛␉␉6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
	}, { // 1682
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\tC6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
		out:  "␉C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
	}, { // 1683
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␉C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
		out:  "‛␉C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
	}, { // 1684
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\tC6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
		out:  "␉C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
	}, { // 1685
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␉C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
		out:  "‛␉C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
	}, { // 1686
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎\t6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
		out:  "␎\t6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
	}, { // 1687
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎␉6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
		out:  "␎␉6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\x0f",
	}, { // 1688
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎\t6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
		out:  "␎\t6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
	}, { // 1689
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎␉6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
		out:  "␎␉6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
	}, { // 1690
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎\t6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
		out:  "␎\t6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
	}, { // 1691
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎␉6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
		out:  "␎␉6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
	}, { // 1692
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\t\x0f",
		out:  "␎C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\t\x0f",
	}, { // 1693
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
		out:  "␎C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉\x0f",
	}, { // 1694
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\t␉",
		out:  "␎C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\t␉",
	}, { // 1695
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉␉",
		out:  "␎C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ␉␉",
	}, { // 1696
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\t",
		out:  "␎C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02\t",
	}, { // 1697
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␎C6*Tａ！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
		out:  "␎C6*Tａ‛！πζκ\tｏ]ζ＄ε^Ｙ／Ｔ\"\x1fS＼τ\nＡＵ\x02␉",
	}, { // 1698
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
		out:  "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
	}, { // 1699
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\n␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
		out:  "␊␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
	}, { // 1700
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␊␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
		out:  "‛␊␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
	}, { // 1701
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\n/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
		out:  "␊/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
	}, { // 1702
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␊/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
		out:  "‛␊/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
	}, { // 1703
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\n/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
		out:  "␊/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
	}, { // 1704
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␊/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
		out:  "‛␊/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
	}, { // 1705
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο\nWTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
		out:  "ο\nWTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
	}, { // 1706
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
		out:  "ο␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f１",
	}, { // 1707
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο\nWTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
		out:  "ο\nWTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
	}, { // 1708
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
		out:  "ο␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
	}, { // 1709
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο\nWTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
		out:  "ο\nWTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
	}, { // 1710
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
		out:  "ο␊WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
	}, { // 1711
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\n１",
		out:  "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\n１",
	}, { // 1712
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
		out:  "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊１",
	}, { // 1713
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\n␊",
		out:  "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\n␊",
	}, { // 1714
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊␊",
		out:  "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z␊␊",
	}, { // 1715
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f\n",
		out:  "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f\n",
	}, { // 1716
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
		out:  "ο/WTｍ｝＜␚␖ｍ\nｉ\x18＃\x1dXWφυ2\fλ\vρψ＼］z\x0f␊",
	}, { // 1717
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
		out:  "ζ]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
	}, { // 1718
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\v␋ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
		out:  "␋␋ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
	}, { // 1719
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␋␋ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
		out:  "‛␋␋ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
	}, { // 1720
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\v]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
		out:  "␋]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
	}, { // 1721
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␋]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
		out:  "‛␋]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
	}, { // 1722
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\v]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
		out:  "␋]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
	}, { // 1723
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␋]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
		out:  "‛␋]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
	}, { // 1724
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ\vｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
		out:  "ζ\vｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
	}, { // 1725
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ␋ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
		out:  "ζ␋ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）Mm",
	}, { // 1726
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ\vｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
		out:  "ζ\vｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
	}, { // 1727
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ␋ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
		out:  "ζ␋ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
	}, { // 1728
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ\vｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
		out:  "ζ\vｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
	}, { // 1729
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ␋ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
		out:  "ζ␋ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
	}, { // 1730
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）\vm",
		out:  "ζ]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）\vm",
	}, { // 1731
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
		out:  "ζ]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋m",
	}, { // 1732
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）\v␋",
		out:  "ζ]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）\v␋",
	}, { // 1733
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋␋",
		out:  "ζ]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）␋␋",
	}, { // 1734
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M\v",
		out:  "ζ]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M\v",
	}, { // 1735
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "ζ]ｚ␗␡␗！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
		out:  "ζ]ｚ␗␡␗‛！［␍>\v7ｈh／\x1e？νθCχ（ψδ\x03\x1b/）M␋",
	}, { // 1736
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
		out:  "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
	}, { // 1737
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\r␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
		out:  "␍␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
	}, { // 1738
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␍␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
		out:  "‛␍␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
	}, { // 1739
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\rvξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
		out:  "␍vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
	}, { // 1740
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␍vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
		out:  "‛␍vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
	}, { // 1741
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "\rvξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
		out:  "␍vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
	}, { // 1742
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "␍vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
		out:  "‛␍vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
	}, { // 1743
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3\rξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
		out:  "3\rξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
	}, { // 1744
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
		out:  "3␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑μ",
	}, { // 1745
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3\rξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
		out:  "3\rξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
	}, { // 1746
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
		out:  "3␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
	}, { // 1747
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3\rξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
		out:  "3\rξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
	}, { // 1748
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
		out:  "3␍ξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
	}, { // 1749
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏\rμ",
		out:  "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏\rμ",
	}, { // 1750
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
		out:  "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍μ",
	}, { // 1751
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏\r␍",
		out:  "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏\r␍",
	}, { // 1752
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍␍",
		out:  "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␍␍",
	}, { // 1753
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑\r",
		out:  "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑\r",
	}, { // 1754
		mask: EncodeExclamation | EncodeLeftCrLfHtVt,
		in:   "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
		out:  "3vξ＂\x05χ\x14\x1a␒?\r０ψ？φ\x1b＃＇Ｏκｓ]\x16OEＡ＆␏␑␍",
	}, { // 1755
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
		out:  "‛␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
	}, { // 1756
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
		out:  "␉␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
	}, { // 1757
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
		out:  "‛␉␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
	}, { // 1758
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\tρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
		out:  "␉ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
	}, { // 1759
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
		out:  "‛␉ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
	}, { // 1760
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\tρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
		out:  "␉ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
	}, { // 1761
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
		out:  "‛␉ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
	}, { // 1762
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊\tW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
		out:  "‛␊\tW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
	}, { // 1763
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
		out:  "‛␊␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/4",
	}, { // 1764
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊\tW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
		out:  "‛␊\tW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
	}, { // 1765
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
		out:  "‛␊␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
	}, { // 1766
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊\tW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
		out:  "‛␊\tW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
	}, { // 1767
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
		out:  "‛␊␉W\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
	}, { // 1768
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ\t4",
		out:  "‛␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ\t4",
	}, { // 1769
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
		out:  "‛␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉4",
	}, { // 1770
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ\t␉",
		out:  "‛␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ\t␉",
	}, { // 1771
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉␉",
		out:  "‛␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ␉␉",
	}, { // 1772
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/\t",
		out:  "‛␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/\t",
	}, { // 1773
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
		out:  "‛␊ρW\tＦ－/τ！５\t␑\x12)ψ＜ｎ\x7f&nＡ>!␁ωπ？δ/␉",
	}, { // 1774
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
		out:  "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
	}, { // 1775
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
		out:  "␊␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
	}, { // 1776
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
		out:  "‛␊␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
	}, { // 1777
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
		out:  "␊#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
	}, { // 1778
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
		out:  "‛␊#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
	}, { // 1779
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
		out:  "␊#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
	}, { // 1780
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
		out:  "‛␊#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
	}, { // 1781
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"\n,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
		out:  "\"\n,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
	}, { // 1782
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
		out:  "\"␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␘",
	}, { // 1783
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"\n,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
		out:  "\"\n,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
	}, { // 1784
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
		out:  "\"␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
	}, { // 1785
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"\n,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
		out:  "\"\n,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
	}, { // 1786
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
		out:  "\"␊,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
	}, { // 1787
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB\n␘",
		out:  "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB\n␘",
	}, { // 1788
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
		out:  "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␘",
	}, { // 1789
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB\n␊",
		out:  "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB\n␊",
	}, { // 1790
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␊",
		out:  "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB␊␊",
	}, { // 1791
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)\n",
		out:  "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)\n",
	}, { // 1792
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
		out:  "\"#,７ｐ０ｋ>\x0e;\n␚␐χ１ρ>χ␆␗δDＷ］|ηβB)␊",
	}, { // 1793
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
		out:  "_ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
	}, { // 1794
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␋＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
		out:  "␋␋＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
	}, { // 1795
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␋＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
		out:  "‛␋␋＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
	}, { // 1796
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\vι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
		out:  "␋ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
	}, { // 1797
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
		out:  "‛␋ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
	}, { // 1798
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\vι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
		out:  "␋ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
	}, { // 1799
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
		out:  "‛␋ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
	}, { // 1800
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_\v＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
		out:  "_\v＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
	}, { // 1801
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_␋＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
		out:  "_␋＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυm",
	}, { // 1802
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_\v＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
		out:  "_\v＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
	}, { // 1803
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_␋＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
		out:  "_␋＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
	}, { // 1804
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_\v＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
		out:  "_\v＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
	}, { // 1805
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_␋＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
		out:  "_␋＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
	}, { // 1806
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν\vm",
		out:  "_ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν\vm",
	}, { // 1807
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
		out:  "_ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋m",
	}, { // 1808
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν\v␋",
		out:  "_ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν\v␋",
	}, { // 1809
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋␋",
		out:  "_ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂ν␋␋",
	}, { // 1810
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ\v",
		out:  "_ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ\v",
	}, { // 1811
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "_ι＃␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
		out:  "_ι＃‛␀＞η>;２\x04\v[／－ο?｜＂\x7f[␊＼OE`ι＂νυ␋",
	}, { // 1812
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
		out:  "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
	}, { // 1813
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\r␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
		out:  "␍␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
	}, { // 1814
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
		out:  "‛␍␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
	}, { // 1815
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\rγＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
		out:  "␍γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
	}, { // 1816
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
		out:  "‛␍γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
	}, { // 1817
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\rγＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
		out:  "␍γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
	}, { // 1818
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
		out:  "‛␍γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
	}, { // 1819
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒\rＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
		out:  "␒\rＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
	}, { // 1820
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
		out:  "␒␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16γ",
	}, { // 1821
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒\rＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
		out:  "␒\rＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
	}, { // 1822
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
		out:  "␒␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
	}, { // 1823
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒\rＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
		out:  "␒\rＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
	}, { // 1824
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
		out:  "␒␍Ｖ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
	}, { // 1825
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\rγ",
		out:  "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\rγ",
	}, { // 1826
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
		out:  "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍γ",
	}, { // 1827
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\r␍",
		out:  "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\r␍",
	}, { // 1828
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍␍",
		out:  "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`␍␍",
	}, { // 1829
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16\r",
		out:  "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16\r",
	}, { // 1830
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
		out:  "␒γＶ␌［ρＨ␍\x16υ\r％＜pS\"x/ξE｜ξ`｜-Ｘ４`\x16␍",
	}, { // 1831
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
		out:  "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
	}, { // 1832
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
		out:  "␉␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
	}, { // 1833
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
		out:  "‛␉␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
	}, { // 1834
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
		out:  "␉＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
	}, { // 1835
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
		out:  "‛␉＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
	}, { // 1836
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
		out:  "␉＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
	}, { // 1837
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
		out:  "‛␉＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
	}, { // 1838
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ\t\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
		out:  "σ\t\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
	}, { // 1839
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
		out:  "σ␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ωλ",
	}, { // 1840
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ\t\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
		out:  "σ\t\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
	}, { // 1841
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
		out:  "σ␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
	}, { // 1842
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ\t\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
		out:  "σ\t\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
	}, { // 1843
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
		out:  "σ␉\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
	}, { // 1844
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00\tλ",
		out:  "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00\tλ",
	}, { // 1845
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
		out:  "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉λ",
	}, { // 1846
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00\t␉",
		out:  "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00\t␉",
	}, { // 1847
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉␉",
		out:  "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00␉␉",
	}, { // 1848
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω\t",
		out:  "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω\t",
	}, { // 1849
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
		out:  "σ＃\n#４GV%ζχ\tP\b␍␌@ω␚［\n␟␊＆[２<D\uff00ω␉",
	}, { // 1850
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
		out:  "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
	}, { // 1851
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
		out:  "␊␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
	}, { // 1852
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
		out:  "‛␊␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
	}, { // 1853
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\nυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
		out:  "␊υ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
	}, { // 1854
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊υ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
		out:  "‛␊υ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
	}, { // 1855
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\nυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
		out:  "␊υ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
	}, { // 1856
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊υ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
		out:  "‛␊υ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
	}, { // 1857
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃ\n\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
		out:  "ｃ\n\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
	}, { // 1858
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃ␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
		out:  "ｃ␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;2",
	}, { // 1859
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃ\n\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
		out:  "ｃ\n\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
	}, { // 1860
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃ␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
		out:  "ｃ␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
	}, { // 1861
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃ\n\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
		out:  "ｃ\n\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
	}, { // 1862
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃ␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
		out:  "ｃ␊\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
	}, { // 1863
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π\n2",
		out:  "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π\n2",
	}, { // 1864
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
		out:  "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊2",
	}, { // 1865
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π\n␊",
		out:  "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π\n␊",
	}, { // 1866
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊␊",
		out:  "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π␊␊",
	}, { // 1867
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;\n",
		out:  "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;\n",
	}, { // 1868
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
		out:  "ｃυ\x0f\x7fαｈwυ[＄\n＼vB\x1a␏κ％␝/λ＾␊Ｘ]０␛π;␊",
	}, { // 1869
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
		out:  "␍！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
	}, { // 1870
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
		out:  "␋␋\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
	}, { // 1871
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
		out:  "‛␋␋\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
	}, { // 1872
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
		out:  "␋！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
	}, { // 1873
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
		out:  "‛␋！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
	}, { // 1874
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
		out:  "␋！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
	}, { // 1875
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
		out:  "‛␋！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
	}, { // 1876
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\v\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
		out:  "␍\v\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
	}, { // 1877
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␋\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
		out:  "␍␋\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␑",
	}, { // 1878
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\v\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
		out:  "␍\v\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
	}, { // 1879
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␋\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
		out:  "␍␋\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
	}, { // 1880
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\v\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
		out:  "␍\v\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
	}, { // 1881
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␋\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
		out:  "␍␋\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
	}, { // 1882
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15\v␑",
		out:  "␍！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15\v␑",
	}, { // 1883
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
		out:  "␍！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␑",
	}, { // 1884
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15\v␋",
		out:  "␍！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15\v␋",
	}, { // 1885
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␋",
		out:  "␍！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15␋␋",
	}, { // 1886
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！\v",
		out:  "␍！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！\v",
	}, { // 1887
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r！\x0fC＃τｊＹ／\x00\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
		out:  "␍！\x0fC＃τｊＹ／␀\v␞!δB\\π␞ρI=ν␄␜\uff00λ1\x15！␋",
	}, { // 1888
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
		out:  "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
	}, { // 1889
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
		out:  "␍␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
	}, { // 1890
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
		out:  "‛␍␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
	}, { // 1891
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
		out:  "␍␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
	}, { // 1892
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
		out:  "‛␍␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
	}, { // 1893
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
		out:  "␍␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
	}, { // 1894
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
		out:  "‛␍␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
	}, { // 1895
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ\rl０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
		out:  "σ\rl０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
	}, { // 1896
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
		out:  "σ␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fος",
	}, { // 1897
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ\rl０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
		out:  "σ\rl０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
	}, { // 1898
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
		out:  "σ␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
	}, { // 1899
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ\rl０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
		out:  "σ\rl０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
	}, { // 1900
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
		out:  "σ␍l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
	}, { // 1901
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f\rς",
		out:  "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f\rς",
	}, { // 1902
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
		out:  "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍ς",
	}, { // 1903
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f\r␍",
		out:  "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f\r␍",
	}, { // 1904
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍␍",
		out:  "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7f␍␍",
	}, { // 1905
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο\r",
		out:  "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο\r",
	}, { // 1906
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
		out:  "σ␑l０=\aＴ%␐＠\r␊Ｄω^ｚw#␇\x12θ␁>ζ３<＄\x7fο␍",
	}, { // 1907
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
		out:  "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
	}, { // 1908
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
		out:  "␉␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
	}, { // 1909
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
		out:  "‛␉␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
	}, { // 1910
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\tＹ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
		out:  "␉Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
	}, { // 1911
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
		out:  "‛␉Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
	}, { // 1912
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\tＹ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
		out:  "␉Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
	}, { // 1913
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
		out:  "‛␉Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
	}, { // 1914
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；\t\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
		out:  "；\t\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
	}, { // 1915
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
		out:  "；␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγι",
	}, { // 1916
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；\t\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
		out:  "；\t\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
	}, { // 1917
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
		out:  "；␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
	}, { // 1918
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；\t\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
		out:  "；\t\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
	}, { // 1919
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
		out:  "；␉\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
	}, { // 1920
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn\tι",
		out:  "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn\tι",
	}, { // 1921
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
		out:  "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉ι",
	}, { // 1922
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn\t␉",
		out:  "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn\t␉",
	}, { // 1923
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉␉",
		out:  "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩn␉␉",
	}, { // 1924
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ\t",
		out:  "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ\t",
	}, { // 1925
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
		out:  "；Ｙ\x10␍＇NＭ?␡4\tχ％β\vG\x02\x15ξ␍？ωAQ\x12ｉＩnγ␉",
	}, { // 1926
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
		out:  "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
	}, { // 1927
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
		out:  "␊␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
	}, { // 1928
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
		out:  "‛␊␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
	}, { // 1929
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
		out:  "␊␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
	}, { // 1930
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
		out:  "‛␊␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
	}, { // 1931
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
		out:  "␊␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
	}, { // 1932
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
		out:  "‛␊␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
	}, { // 1933
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～\n\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
		out:  "～\n\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
	}, { // 1934
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
		out:  "～␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９L",
	}, { // 1935
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～\n\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
		out:  "～\n\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
	}, { // 1936
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
		out:  "～␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
	}, { // 1937
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～\n\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
		out:  "～\n\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
	}, { // 1938
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
		out:  "～␊\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
	}, { // 1939
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ\nL",
		out:  "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ\nL",
	}, { // 1940
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
		out:  "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊L",
	}, { // 1941
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ\n␊",
		out:  "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ\n␊",
	}, { // 1942
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊␊",
		out:  "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ␊␊",
	}, { // 1943
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９\n",
		out:  "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９\n",
	}, { // 1944
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
		out:  "～␜\nｎ]\x0e\x1eτG＋\niτ␔␟ο␂+\x03λoＳ␕*ｚ␁νλ９␊",
	}, { // 1945
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
		out:  "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
	}, { // 1946
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
		out:  "␋␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
	}, { // 1947
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
		out:  "‛␋␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
	}, { // 1948
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
		out:  "␋␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
	}, { // 1949
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
		out:  "‛␋␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
	}, { // 1950
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
		out:  "␋␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
	}, { // 1951
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
		out:  "‛␋␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
	}, { // 1952
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13\vｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
		out:  "\x13\vｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
	}, { // 1953
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
		out:  "\x13␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔κ",
	}, { // 1954
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13\vｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
		out:  "\x13\vｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
	}, { // 1955
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
		out:  "\x13␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
	}, { // 1956
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13\vｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
		out:  "\x13\vｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
	}, { // 1957
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
		out:  "\x13␋ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
	}, { // 1958
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈\vκ",
		out:  "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈\vκ",
	}, { // 1959
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
		out:  "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋κ",
	}, { // 1960
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈\v␋",
		out:  "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈\v␋",
	}, { // 1961
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋␋",
		out:  "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␋␋",
	}, { // 1962
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔\v",
		out:  "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔\v",
	}, { // 1963
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
		out:  "\x13␈ｏr\x19γd␑\x15F\vWγιν\x1c＠.␙β6Ｙ␖－Ｖ/５␈␔␋",
	}, { // 1964
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
		out:  "␋\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
	}, { // 1965
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
		out:  "␍␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
	}, { // 1966
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
		out:  "‛␍␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
	}, { // 1967
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
		out:  "␍\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
	}, { // 1968
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
		out:  "‛␍\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
	}, { // 1969
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
		out:  "␍\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
	}, { // 1970
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
		out:  "‛␍\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
	}, { // 1971
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\rφt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
		out:  "␋\rφt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
	}, { // 1972
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
		out:  "␋␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␃",
	}, { // 1973
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\rφt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
		out:  "␋\rφt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
	}, { // 1974
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
		out:  "␋␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
	}, { // 1975
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\rφt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
		out:  "␋\rφt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
	}, { // 1976
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
		out:  "␋␍φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
	}, { // 1977
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz\r␃",
		out:  "␋\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz\r␃",
	}, { // 1978
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
		out:  "␋\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␃",
	}, { // 1979
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz\r␍",
		out:  "␋\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz\r␍",
	}, { // 1980
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␍",
		out:  "␋\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz␍␍",
	}, { // 1981
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀\r",
		out:  "␋\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀\r",
	}, { // 1982
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
		out:  "␋\x10φt(｜␂δι｀\r？MＷμ５！ｓ<7\x1b>］σ'Fωz｀␍",
	}, { // 1983
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
	}, { // 1984
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
		out:  "␉␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
	}, { // 1985
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
		out:  "‛␉␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
	}, { // 1986
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
		out:  "␉\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
	}, { // 1987
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
		out:  "‛␉\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
	}, { // 1988
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
		out:  "␉\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
	}, { // 1989
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
		out:  "‛␉\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
	}, { // 1990
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
	}, { // 1991
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
		out:  "ε␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD－",
	}, { // 1992
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
	}, { // 1993
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
		out:  "ε␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
	}, { // 1994
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
	}, { // 1995
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
		out:  "ε␉␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
	}, { // 1996
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ\t－",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ\t－",
	}, { // 1997
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉－",
	}, { // 1998
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ\t␉",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ\t␉",
	}, { // 1999
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉␉",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯ␉␉",
	}, { // 2000
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD\t",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD\t",
	}, { // 2001
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
		out:  "ε\t␚［\x1fιq！8ｚ\tｓ\nｅjb`\x12η␊␅\x05％χ\x12ＯοＯD␉",
	}, { // 2002
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␞",
		out:  "‛␉‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␞",
	}, { // 2003
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n␊␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␞",
		out:  "␊␊␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␞",
	}, { // 2004
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊␊␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␞",
		out:  "‛␊␊␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␞",
	}, { // 2005
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
		out:  "␊‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
	}, { // 2006
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
		out:  "‛␊‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
	}, { // 2007
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␊",
		out:  "␊‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␊",
	}, { // 2008
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␊",
		out:  "‛␊‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␊",
	}, { // 2009
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉\n␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␞",
		out:  "‛␉\n␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␞",
	}, { // 2010
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␊␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␞",
		out:  "‛␉␊␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␞",
	}, { // 2011
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉\n␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
		out:  "‛␉\n␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
	}, { // 2012
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␊␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
		out:  "‛␉␊␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
	}, { // 2013
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉\n␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␊",
		out:  "‛␉\n␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␊",
	}, { // 2014
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␊␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␊",
		out:  "‛␉␊␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␊",
	}, { // 2015
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ\n␞",
		out:  "‛␉‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ\n␞",
	}, { // 2016
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
		out:  "‛␉‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ␊␞",
	}, { // 2017
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ\n␊",
		out:  "‛␉‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ\n␊",
	}, { // 2018
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ␊␊",
		out:  "‛␉‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ␊␊",
	}, { // 2019
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7\n",
		out:  "‛␉‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7\n",
	}, { // 2020
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉？␎␁θ\x01%\x06␝＂\nπ\x7f？＊ｘ'RυBυａε\nYj\x0eρ7␊",
		out:  "‛␉‛？␎␁θ\x01%\x06␝＂\nπ\x7f‛？＊ｘ'RυBυａε\nYj\x0eρ7␊",
	}, { // 2021
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈t",
		out:  "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈t",
	}, { // 2022
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈t",
		out:  "␋␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈t",
	}, { // 2023
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈t",
		out:  "‛␋␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈t",
	}, { // 2024
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\vnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␋t",
		out:  "␋nＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␋t",
	}, { // 2025
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋nＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␋t",
		out:  "‛␋nＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␋t",
	}, { // 2026
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\vnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈␋",
		out:  "␋nＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈␋",
	}, { // 2027
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋nＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈␋",
		out:  "‛␋nＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈␋",
	}, { // 2028
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "h\vＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈t",
		out:  "h\vＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈t",
	}, { // 2029
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "h␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈t",
		out:  "h␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈t",
	}, { // 2030
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "h\vＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␋t",
		out:  "h\vＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␋t",
	}, { // 2031
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "h␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␋t",
		out:  "h␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␋t",
	}, { // 2032
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "h\vＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈␋",
		out:  "h\vＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈␋",
	}, { // 2033
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "h␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈␋",
		out:  "h␋Ｑ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈␋",
	}, { // 2034
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀\vt",
		out:  "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀\vt",
	}, { // 2035
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␋t",
		out:  "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␋t",
	}, { // 2036
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀\v␋",
		out:  "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀\v␋",
	}, { // 2037
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␋␋",
		out:  "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␋␋",
	}, { // 2038
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈\v",
		out:  "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈\v",
	}, { // 2039
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝␀δ\x1cθγ\x1e\r｀␈␋",
		out:  "hnＱ１＃\x02!λo#\v␃，␛ｕb｛!α＝‛␀δ\x1cθγ\x1e\r｀␈␋",
	}, { // 2040
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
		out:  "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
	}, { // 2041
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
		out:  "␍␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
	}, { // 2042
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
		out:  "‛␍␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
	}, { // 2043
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
		out:  "␍＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
	}, { // 2044
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
		out:  "‛␍＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
	}, { // 2045
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
		out:  "␍＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
	}, { // 2046
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
		out:  "‛␍＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
	}, { // 2047
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐\r\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
		out:  "␐\r\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
	}, { // 2048
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
		out:  "␐␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`αζ",
	}, { // 2049
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐\r\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
		out:  "␐\r\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
	}, { // 2050
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
		out:  "␐␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
	}, { // 2051
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐\r\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
		out:  "␐\r\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
	}, { // 2052
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
		out:  "␐␍\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
	}, { // 2053
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`\rζ",
		out:  "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`\rζ",
	}, { // 2054
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
		out:  "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍ζ",
	}, { // 2055
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`\r␍",
		out:  "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`\r␍",
	}, { // 2056
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍␍",
		out:  "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`␍␍",
	}, { // 2057
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α\r",
		out:  "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α\r",
	}, { // 2058
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
		out:  "␐＾\x1eＳz␊␖θＯ\r\r␇VＩξ4P\x152$␗Ｎaυ␛αｆ`α␍",
	}, { // 2059
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02p",
		out:  "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02p",
	}, { // 2060
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02p",
		out:  "␉␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02p",
	}, { // 2061
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02p",
		out:  "‛␉␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02p",
	}, { // 2062
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN␉p",
		out:  "␉\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN␉p",
	}, { // 2063
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN␉p",
		out:  "‛␉\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN␉p",
	}, { // 2064
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02␉",
		out:  "␉\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02␉",
	}, { // 2065
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02␉",
		out:  "‛␉\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02␉",
	}, { // 2066
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\tｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02p",
		out:  "8\tｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02p",
	}, { // 2067
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02p",
		out:  "8␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02p",
	}, { // 2068
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\tｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN␉p",
		out:  "8\tｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN␉p",
	}, { // 2069
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN␉p",
		out:  "8␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN␉p",
	}, { // 2070
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\tｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02␉",
		out:  "8\tｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02␉",
	}, { // 2071
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02␉",
		out:  "8␉ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02␉",
	}, { // 2072
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\tp",
		out:  "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\tp",
	}, { // 2073
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN␉p",
		out:  "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN␉p",
	}, { // 2074
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\t␉",
		out:  "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\t␉",
	}, { // 2075
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN␉␉",
		out:  "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN␉␉",
	}, { // 2076
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02\t",
		out:  "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02\t",
	}, { // 2077
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓␀φω\x17␡␑4ηJνN\x02␉",
		out:  "8\x03ｅDς␘φ\x05－\x14\t＼Ｖ\x1d␋＾␓‛␀φω\x17␡␑4ηJνN\x02␉",
	}, { // 2078
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
		out:  "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
	}, { // 2079
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
		out:  "␊␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
	}, { // 2080
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
		out:  "‛␊␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
	}, { // 2081
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
		out:  "␊\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
	}, { // 2082
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
		out:  "‛␊\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
	}, { // 2083
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
		out:  "␊\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
	}, { // 2084
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
		out:  "‛␊\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
	}, { // 2085
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\n？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
		out:  "＂\n？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
	}, { // 2086
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
		out:  "＂␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␔",
	}, { // 2087
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\n？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
		out:  "＂\n？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
	}, { // 2088
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
		out:  "＂␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
	}, { // 2089
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\n？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
		out:  "＂\n？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
	}, { // 2090
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
		out:  "＂␊？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
	}, { // 2091
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ\n␔",
		out:  "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ\n␔",
	}, { // 2092
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
		out:  "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␔",
	}, { // 2093
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ\n␊",
		out:  "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ\n␊",
	}, { // 2094
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␊",
		out:  "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ␊␊",
	}, { // 2095
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$\n",
		out:  "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$\n",
	}, { // 2096
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
		out:  "＂\x02？6/C#ρυz\nο\x03ｎ［Ｓ␓ζ␛θν＾\nｏF␞mｊ$␊",
	}, { // 2097
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "πｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
		out:  "πｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
	}, { // 2098
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\v␋］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
		out:  "␋␋］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
	}, { // 2099
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋␋］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
		out:  "‛␋␋］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
	}, { // 2100
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\vｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G␋\x0f",
		out:  "␋ｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G␋\x0f",
	}, { // 2101
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋ｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G␋\x0f",
		out:  "‛␋ｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G␋\x0f",
	}, { // 2102
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\vｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ␋",
		out:  "␋ｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ␋",
	}, { // 2103
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋ｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ␋",
		out:  "‛␋ｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ␋",
	}, { // 2104
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "π\v］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
		out:  "π\v］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
	}, { // 2105
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "π␋］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
		out:  "π␋］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ\x0f",
	}, { // 2106
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "π\v］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G␋\x0f",
		out:  "π\v］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G␋\x0f",
	}, { // 2107
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "π␋］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G␋\x0f",
		out:  "π␋］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G␋\x0f",
	}, { // 2108
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "π\v］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ␋",
		out:  "π\v］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ␋",
	}, { // 2109
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "π␋］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ␋",
		out:  "π␋］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ␋",
	}, { // 2110
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "πｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G\v\x0f",
		out:  "πｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G\v\x0f",
	}, { // 2111
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "πｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G␋\x0f",
		out:  "πｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G␋\x0f",
	}, { // 2112
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "πｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G\v␋",
		out:  "πｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G\v␋",
	}, { // 2113
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "πｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01G␋␋",
		out:  "πｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01G␋␋",
	}, { // 2114
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "πｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ\v",
		out:  "πｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ\v",
	}, { // 2115
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "πｓ］＜Ｒ`η␅πU\vγ＜：2␙＊#AZ`＝β]ｚＤ\x01Gθ␋",
		out:  "πｓ］＜Ｒ`η␅πU\vγ＜：2␙‛＊#AZ`＝β]ｚＤ\x01Gθ␋",
	}, { // 2116
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
		out:  "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
	}, { // 2117
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
		out:  "␍␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
	}, { // 2118
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
		out:  "‛␍␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
	}, { // 2119
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\rh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
		out:  "␍h`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
	}, { // 2120
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍h`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
		out:  "‛␍h`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
	}, { // 2121
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\rh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
		out:  "␍h`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
	}, { // 2122
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍h`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
		out:  "‛␍h`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
	}, { // 2123
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑ\r`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
		out:  "ｑ\r`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
	}, { // 2124
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑ␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
		out:  "ｑ␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆dβ",
	}, { // 2125
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑ\r`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
		out:  "ｑ\r`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
	}, { // 2126
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑ␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
		out:  "ｑ␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
	}, { // 2127
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑ\r`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
		out:  "ｑ\r`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
	}, { // 2128
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑ␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
		out:  "ｑ␍`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
	}, { // 2129
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆\rβ",
		out:  "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆\rβ",
	}, { // 2130
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
		out:  "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍β",
	}, { // 2131
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆\r␍",
		out:  "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆\r␍",
	}, { // 2132
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍␍",
		out:  "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆␍␍",
	}, { // 2133
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d\r",
		out:  "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d\r",
	}, { // 2134
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
		out:  "ｑh`DＧ1␊␘␕＝\r\x11ｇ␖＞υωνs␌λω\x18/C\b|␆d␍",
	}, { // 2135
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
		out:  "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
	}, { // 2136
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
		out:  "␉␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
	}, { // 2137
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
		out:  "‛␉␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
	}, { // 2138
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
		out:  "␉␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
	}, { // 2139
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
		out:  "‛␉␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
	}, { // 2140
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
		out:  "␉␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
	}, { // 2141
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
		out:  "‛␉␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
	}, { // 2142
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓\tＷ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
		out:  "␓\tＷ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
	}, { // 2143
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
		out:  "␓␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ＿",
	}, { // 2144
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓\tＷ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
		out:  "␓\tＷ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
	}, { // 2145
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
		out:  "␓␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
	}, { // 2146
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓\tＷ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
		out:  "␓\tＷ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
	}, { // 2147
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
		out:  "␓␉Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
	}, { // 2148
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ\t＿",
		out:  "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ\t＿",
	}, { // 2149
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
		out:  "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉＿",
	}, { // 2150
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ\t␉",
		out:  "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ\t␉",
	}, { // 2151
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉␉",
		out:  "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θ␉␉",
	}, { // 2152
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ\t",
		out:  "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ\t",
	}, { // 2153
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
		out:  "␓␟Ｗ␊δω8$\x1dＤ\tH␈\x1f\"μ＇Q␞/ｆω#β\x12[\x03θｇ␉",
	}, { // 2154
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
		out:  "τ＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
	}, { // 2155
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
		out:  "␊␊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
	}, { // 2156
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊␊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
		out:  "‛␊␊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
	}, { // 2157
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
		out:  "␊＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
	}, { // 2158
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
		out:  "‛␊＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
	}, { // 2159
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
		out:  "␊＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
	}, { // 2160
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
		out:  "‛␊＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
	}, { // 2161
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ\nq\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
		out:  "τ\nq\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
	}, { // 2162
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ␊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
		out:  "τ␊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␄",
	}, { // 2163
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ\nq\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
		out:  "τ\nq\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
	}, { // 2164
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ␊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
		out:  "τ␊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
	}, { // 2165
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ\nq\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
		out:  "τ\nq\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
	}, { // 2166
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ␊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
		out:  "τ␊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
	}, { // 2167
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\n␄",
		out:  "τ＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\n␄",
	}, { // 2168
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
		out:  "τ＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␄",
	}, { // 2169
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\n␊",
		out:  "τ＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\n␊",
	}, { // 2170
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␊",
		out:  "τ＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e␊␊",
	}, { // 2171
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03\n",
		out:  "τ＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03\n",
	}, { // 2172
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "τ＊q\x19␐␃｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
		out:  "τ＊q\x19␐␃‛｜\nξφ\n＊μＳm\x0e␝5ｐs?τ\x13δｄ５2\x1e\x03␊",
	}, { // 2173
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
		out:  "}u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
	}, { // 2174
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\v␋`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
		out:  "␋␋`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
	}, { // 2175
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋␋`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
		out:  "‛␋␋`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
	}, { // 2176
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vu`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
		out:  "␋u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
	}, { // 2177
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
		out:  "‛␋u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
	}, { // 2178
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vu`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
		out:  "␋u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
	}, { // 2179
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
		out:  "‛␋u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
	}, { // 2180
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}\v`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
		out:  "}\v`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
	}, { // 2181
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}␋`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
		out:  "}␋`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ＇",
	}, { // 2182
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}\v`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
		out:  "}\v`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
	}, { // 2183
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}␋`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
		out:  "}␋`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
	}, { // 2184
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}\v`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
		out:  "}\v`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
	}, { // 2185
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}␋`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
		out:  "}␋`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
	}, { // 2186
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*\v＇",
		out:  "}u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*\v＇",
	}, { // 2187
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
		out:  "}u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋＇",
	}, { // 2188
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*\v␋",
		out:  "}u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*\v␋",
	}, { // 2189
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋␋",
		out:  "}u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*␋␋",
	}, { // 2190
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ\v",
		out:  "}u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ\v",
	}, { // 2191
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "}u`｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
		out:  "}u`‛｜５2γψθθ\vl\x7fτｂ>␍ωＥｈ\x11␡ｇ\\；3\x16*ｙ␋",
	}, { // 2192
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
		out:  "\x17Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
	}, { // 2193
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r␍βυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
		out:  "␍␍βυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
	}, { // 2194
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍␍βυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
		out:  "‛␍␍βυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
	}, { // 2195
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\rＫβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
		out:  "␍Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
	}, { // 2196
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
		out:  "‛␍Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
	}, { // 2197
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\rＫβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
		out:  "␍Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
	}, { // 2198
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
		out:  "‛␍Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
	}, { // 2199
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17\rβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
		out:  "\x17\rβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
	}, { // 2200
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17␍βυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
		out:  "\x17␍βυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛／",
	}, { // 2201
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17\rβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
		out:  "\x17\rβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
	}, { // 2202
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17␍βυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
		out:  "\x17␍βυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
	}, { // 2203
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17\rβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
		out:  "\x17\rβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
	}, { // 2204
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17␍βυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
		out:  "\x17␍βυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
	}, { // 2205
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒\r／",
		out:  "\x17Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒\r／",
	}, { // 2206
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
		out:  "\x17Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍／",
	}, { // 2207
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒\r␍",
		out:  "\x17Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒\r␍",
	}, { // 2208
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍␍",
		out:  "\x17Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␍␍",
	}, { // 2209
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛\r",
		out:  "\x17Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛\r",
	}, { // 2210
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\x17Ｋβυγμφ␀\x12<\rＬ'|h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
		out:  "\x17Ｋβυγμφ‛␀\x12<\rＬ'｜h␇／Ｊ\x18pｍｎιｌ\x1dQ\x19␒␛␍",
	}, { // 2211
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
	}, { // 2212
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
		out:  "␉␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
	}, { // 2213
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
		out:  "‛␉␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
	}, { // 2214
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
		out:  "␉\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
	}, { // 2215
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
		out:  "‛␉\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
	}, { // 2216
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
		out:  "␉\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
	}, { // 2217
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
		out:  "‛␉\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
	}, { // 2218
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
	}, { // 2219
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
		out:  "\b␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\rZ",
	}, { // 2220
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
	}, { // 2221
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
		out:  "\b␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
	}, { // 2222
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
	}, { // 2223
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
		out:  "\b␉φU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
	}, { // 2224
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\tZ",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\tZ",
	}, { // 2225
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉Z",
	}, { // 2226
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\t␉",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\t␉",
	}, { // 2227
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉␉",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏␉␉",
	}, { // 2228
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r\t",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r\t",
	}, { // 2229
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
		out:  "\b\tφU␖］｜{Ｘγ\tθημ（ＵlT\x0fπ`␖ｑｚ｀；]␏\r␉",
	}, { // 2230
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；\f",
		out:  "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；\f",
	}, { // 2231
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；\f",
		out:  "␊␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；\f",
	}, { // 2232
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；\f",
		out:  "‛␊␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；\f",
	}, { // 2233
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#␊\f",
		out:  "␊９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃␊\f",
	}, { // 2234
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#␊\f",
		out:  "‛␊９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃␊\f",
	}, { // 2235
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；␊",
		out:  "␊９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；␊",
	}, { // 2236
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；␊",
		out:  "‛␊９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；␊",
	}, { // 2237
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4\n\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；\f",
		out:  "4\n\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；\f",
	}, { // 2238
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；\f",
		out:  "4␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；\f",
	}, { // 2239
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4\n\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#␊\f",
		out:  "4\n\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃␊\f",
	}, { // 2240
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#␊\f",
		out:  "4␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃␊\f",
	}, { // 2241
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4\n\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；␊",
		out:  "4\n\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；␊",
	}, { // 2242
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；␊",
		out:  "4␊\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；␊",
	}, { // 2243
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#\n\f",
		out:  "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃\n\f",
	}, { // 2244
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#␊\f",
		out:  "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃␊\f",
	}, { // 2245
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#\n␊",
		out:  "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃\n␊",
	}, { // 2246
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#␊␊",
		out:  "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃␊␊",
	}, { // 2247
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；\n",
		out:  "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；\n",
	}, { // 2248
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ␀ｆ#；␊",
		out:  "4９\x03α\x01(O\x18Q＜\n，/ζ␃.\nα␋ｒψα］␗Ｗ‛␀ｆ＃；␊",
	}, { // 2249
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
		out:  "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
	}, { // 2250
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
		out:  "␋␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
	}, { // 2251
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
		out:  "‛␋␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
	}, { // 2252
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\vＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
		out:  "␋ＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
	}, { // 2253
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋ＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
		out:  "‛␋ＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
	}, { // 2254
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\vＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
		out:  "␋ＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
	}, { // 2255
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋ＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
		out:  "‛␋ＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
	}, { // 2256
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\vψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
		out:  "ω\vψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
	}, { // 2257
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
		out:  "ω␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1fρ",
	}, { // 2258
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\vψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
		out:  "ω\vψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
	}, { // 2259
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
		out:  "ω␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
	}, { // 2260
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω\vψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
		out:  "ω\vψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
	}, { // 2261
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ω␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
		out:  "ω␋ψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
	}, { // 2262
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\vρ",
		out:  "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\vρ",
	}, { // 2263
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
		out:  "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋ρ",
	}, { // 2264
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\v␋",
		out:  "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\v␋",
	}, { // 2265
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋␋",
		out:  "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［␋␋",
	}, { // 2266
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f\v",
		out:  "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f\v",
	}, { // 2267
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
		out:  "ωＸψＰ\x19\"Ｍβ％%\v＼5␖ｙ／χ\x16\r␟|m^\nＶοn［\x1f␋",
	}, { // 2268
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄τ",
		out:  "D‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄τ",
	}, { // 2269
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄τ",
		out:  "␍␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄τ",
	}, { // 2270
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄τ",
		out:  "‛␍␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄τ",
	}, { // 2271
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␍τ",
		out:  "␍‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␍τ",
	}, { // 2272
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␍τ",
		out:  "‛␍‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␍τ",
	}, { // 2273
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄␍",
		out:  "␍‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄␍",
	}, { // 2274
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄␍",
		out:  "‛␍‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄␍",
	}, { // 2275
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D\r/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄τ",
		out:  "D\r/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄τ",
	}, { // 2276
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄τ",
		out:  "D␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄τ",
	}, { // 2277
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D\r/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␍τ",
		out:  "D\r/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␍τ",
	}, { // 2278
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␍τ",
		out:  "D␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␍τ",
	}, { // 2279
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D\r/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄␍",
		out:  "D\r/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄␍",
	}, { // 2280
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄␍",
		out:  "D␍/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄␍",
	}, { // 2281
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14\rτ",
		out:  "D‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14\rτ",
	}, { // 2282
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␍τ",
		out:  "D‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␍τ",
	}, { // 2283
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14\r␍",
		out:  "D‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14\r␍",
	}, { // 2284
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␍␍",
		out:  "D‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␍␍",
	}, { // 2285
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄\r",
		out:  "D‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄\r",
	}, { // 2286
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "D␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa␀ση␡\f\x14␄␍",
		out:  "D‛␀/Mυ＄ｉＭ＿'\r␇v\x15３Ｆ?ζF␜σa‛␀ση␡\f\x14␄␍",
	}, { // 2287
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%p",
		out:  "‛␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％p",
	}, { // 2288
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%p",
		out:  "␉␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％p",
	}, { // 2289
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%p",
		out:  "‛␉␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％p",
	}, { // 2290
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾␉p",
		out:  "␉;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾␉p",
	}, { // 2291
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾␉p",
		out:  "‛␉;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾␉p",
	}, { // 2292
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%␉",
		out:  "␉;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％␉",
	}, { // 2293
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%␉",
		out:  "‛␉;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％␉",
	}, { // 2294
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊\tａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%p",
		out:  "‛␊\tａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％p",
	}, { // 2295
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%p",
		out:  "‛␊␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％p",
	}, { // 2296
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊\tａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾␉p",
		out:  "‛␊\tａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾␉p",
	}, { // 2297
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾␉p",
		out:  "‛␊␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾␉p",
	}, { // 2298
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊\tａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%␉",
		out:  "‛␊\tａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％␉",
	}, { // 2299
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%␉",
		out:  "‛␊␉ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％␉",
	}, { // 2300
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾\tp",
		out:  "‛␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾\tp",
	}, { // 2301
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾␉p",
		out:  "‛␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾␉p",
	}, { // 2302
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾\t␉",
		out:  "‛␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾\t␉",
	}, { // 2303
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾␉␉",
		out:  "‛␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾␉␉",
	}, { // 2304
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%\t",
		out:  "‛␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％\t",
	}, { // 2305
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ\x00ｖB\"␡θ＾%␉",
		out:  "‛␊;ａ>κ␜␘\x05@δ\tυＥ＃\aj＊｜γξＧ␀ｖB\"␡θ＾％␉",
	}, { // 2306
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
	}, { // 2307
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
		out:  "␊␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
	}, { // 2308
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
		out:  "‛␊␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
	}, { // 2309
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
	}, { // 2310
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
		out:  "‛␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
	}, { // 2311
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
	}, { // 2312
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
		out:  "‛␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
	}, { // 2313
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n\nυ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
		out:  "␊\nυ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
	}, { // 2314
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
		out:  "␊␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγγ",
	}, { // 2315
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n\nυ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
		out:  "␊\nυ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
	}, { // 2316
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
		out:  "␊␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
	}, { // 2317
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n\nυ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
		out:  "␊\nυ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
	}, { // 2318
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
		out:  "␊␊υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
	}, { // 2319
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς\nγ",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς\nγ",
	}, { // 2320
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊γ",
	}, { // 2321
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς\n␊",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς\n␊",
	}, { // 2322
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊␊",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ς␊␊",
	}, { // 2323
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ\n",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ\n",
	}, { // 2324
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
		out:  "␊｜υ＜Ｄ_＝␙:｜\n\x0e>C．ｈ\x7fa\"␜κq␓＄ｉ#\x15ςγ␊",
	}, { // 2325
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
		out:  "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
	}, { // 2326
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
		out:  "␋␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
	}, { // 2327
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
		out:  "‛␋␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
	}, { // 2328
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
		out:  "␋/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
	}, { // 2329
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
		out:  "‛␋/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
	}, { // 2330
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
		out:  "␋/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
	}, { // 2331
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
		out:  "‛␋/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
	}, { // 2332
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ\vς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
		out:  "χ\vς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
	}, { // 2333
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
		out:  "χ␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ0",
	}, { // 2334
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ\vς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
		out:  "χ\vς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
	}, { // 2335
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
		out:  "χ␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
	}, { // 2336
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ\vς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
		out:  "χ\vς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
	}, { // 2337
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
		out:  "χ␋ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
	}, { // 2338
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14\v0",
		out:  "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14\v0",
	}, { // 2339
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
		out:  "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋0",
	}, { // 2340
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14\v␋",
		out:  "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14\v␋",
	}, { // 2341
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋␋",
		out:  "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14␋␋",
	}, { // 2342
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ\v",
		out:  "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ\v",
	}, { // 2343
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
		out:  "χ/ς␊ηλ?＜｛O\v␆'␆.ｐＱδk｀！α␎␍j\x1d\x17\x14Ｕ␋",
	}, { // 2344
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
		out:  "：o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
	}, { // 2345
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\r␍５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
		out:  "␍␍５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
	}, { // 2346
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍␍５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
		out:  "‛␍␍５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
	}, { // 2347
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\ro５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
		out:  "␍o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
	}, { // 2348
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
		out:  "‛␍o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
	}, { // 2349
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\ro５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
		out:  "␍o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
	}, { // 2350
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
		out:  "‛␍o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
	}, { // 2351
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：\r５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
		out:  "：\r５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
	}, { // 2352
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：␍５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
		out:  "：␍５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\t",
	}, { // 2353
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：\r５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
		out:  "：\r５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
	}, { // 2354
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：␍５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
		out:  "：␍５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
	}, { // 2355
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：\r５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
		out:  "：\r５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
	}, { // 2356
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：␍５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
		out:  "：␍５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
	}, { // 2357
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\r\t",
		out:  "：o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\r\t",
	}, { // 2358
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
		out:  "：o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π␍\t",
	}, { // 2359
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\r␍",
		out:  "：o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\r␍",
	}, { // 2360
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π␍␍",
		out:  "：o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π␍␍",
	}, { // 2361
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\r",
		out:  "：o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c\r",
	}, { // 2362
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "：o５0ｏK␅＃␟ε\r＇Hχ%ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
		out:  "：o５0ｏK␅＃␟ε\r＇Hχ％ｂφ\t\x1fpｊυaｔ\"υ＊π\x1c␍",
	}, { // 2363
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
	}, { // 2364
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
		out:  "␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
	}, { // 2365
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
		out:  "‛␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
	}, { // 2366
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
		out:  "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
	}, { // 2367
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
	}, { // 2368
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
		out:  "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
	}, { // 2369
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
	}, { // 2370
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\tνλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
		out:  "‛␉\tνλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
	}, { // 2371
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
		out:  "‛␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφd",
	}, { // 2372
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\tνλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
		out:  "‛␉\tνλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
	}, { // 2373
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
		out:  "‛␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
	}, { // 2374
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\tνλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
		out:  "‛␉\tνλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
	}, { // 2375
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
		out:  "‛␉␉νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
	}, { // 2376
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e\td",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e\td",
	}, { // 2377
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉d",
	}, { // 2378
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e\t␉",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e\t␉",
	}, { // 2379
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉␉",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1e␉␉",
	}, { // 2380
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ\t",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ\t",
	}, { // 2381
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
		out:  "‛␉\x12νλ#α６*S5\t／␁:ｕｌ\bφ␗␘␎?＆ω＾\x10Q\x1eφ␉",
	}, { // 2382
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
		out:  "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
	}, { // 2383
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
		out:  "␊␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
	}, { // 2384
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
		out:  "‛␊␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
	}, { // 2385
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\n(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
		out:  "␊(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
	}, { // 2386
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
		out:  "‛␊(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
	}, { // 2387
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\n(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
		out:  "␊(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
	}, { // 2388
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
		out:  "‛␊(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
	}, { // 2389
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ\n␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
		out:  "Ｃ\n␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
	}, { // 2390
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
		out:  "Ｃ␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξεπ",
	}, { // 2391
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ\n␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
		out:  "Ｃ\n␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
	}, { // 2392
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
		out:  "Ｃ␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
	}, { // 2393
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ\n␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
		out:  "Ｃ\n␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
	}, { // 2394
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
		out:  "Ｃ␊␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
	}, { // 2395
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ\nπ",
		out:  "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ\nπ",
	}, { // 2396
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
		out:  "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊π",
	}, { // 2397
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ\n␊",
		out:  "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ\n␊",
	}, { // 2398
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊␊",
		out:  "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξ␊␊",
	}, { // 2399
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε\n",
		out:  "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε\n",
	}, { // 2400
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
		out:  "Ｃ(␍ＮＥ＞␄δ\x14＄\n]｀K－ν\x02Ｗψ`R-␇>*％\x1cξε␊",
	}, { // 2401
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
		out:  "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
	}, { // 2402
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
		out:  "␋␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
	}, { // 2403
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
		out:  "‛␋␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
	}, { // 2404
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\vλ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
		out:  "␋λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
	}, { // 2405
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
		out:  "‛␋λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
	}, { // 2406
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\vλ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
		out:  "␋λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
	}, { // 2407
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
		out:  "‛␋λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
	}, { // 2408
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%\v～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
		out:  "%\v～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
	}, { // 2409
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
		out:  "%␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␜",
	}, { // 2410
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%\v～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
		out:  "%\v～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
	}, { // 2411
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
		out:  "%␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
	}, { // 2412
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%\v～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
		out:  "%\v～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
	}, { // 2413
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
		out:  "%␋～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
	}, { // 2414
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ\v␜",
		out:  "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ\v␜",
	}, { // 2415
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
		out:  "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␜",
	}, { // 2416
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ\v␋",
		out:  "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ\v␋",
	}, { // 2417
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␋",
		out:  "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖ␋␋",
	}, { // 2418
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα\v",
		out:  "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα\v",
	}, { // 2419
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
		out:  "%λ～␊＄\x19c／βσ\vRfε／\x12２\nιD＋\x06Ｗ=␍`>ｖα␋",
	}, { // 2420
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
		out:  "D␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
	}, { // 2421
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
		out:  "␍␍ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
	}, { // 2422
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
		out:  "‛␍␍ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
	}, { // 2423
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
		out:  "␍␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
	}, { // 2424
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
		out:  "‛␍␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
	}, { // 2425
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
		out:  "␍␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
	}, { // 2426
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
		out:  "‛␍␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
	}, { // 2427
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D\rＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
		out:  "D\rＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
	}, { // 2428
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␍ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
		out:  "D␍ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␘",
	}, { // 2429
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D\rＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
		out:  "D\rＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
	}, { // 2430
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␍ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
		out:  "D␍ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
	}, { // 2431
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D\rＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
		out:  "D\rＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
	}, { // 2432
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␍ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
		out:  "D␍ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
	}, { // 2433
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'\r␘",
		out:  "D␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'\r␘",
	}, { // 2434
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
		out:  "D␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␘",
	}, { // 2435
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'\r␍",
		out:  "D␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'\r␍",
	}, { // 2436
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␍",
		out:  "D␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'␍␍",
	}, { // 2437
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν\r",
		out:  "D␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν\r",
	}, { // 2438
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "D␅ＳＶS_*ξｈｘ\rλ\\；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
		out:  "D␅ＳＶS_*ξｈｘ\rλ＼；！Ｄ/ｘρπ*s␛\x1b␐\x1eQ'ν␍",
	}, { // 2439
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
		out:  "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
	}, { // 2440
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
		out:  "␉␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
	}, { // 2441
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
		out:  "‛␉␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
	}, { // 2442
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\tｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
		out:  "␉ｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
	}, { // 2443
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉ｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
		out:  "‛␉ｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
	}, { // 2444
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\tｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
		out:  "␉ｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
	}, { // 2445
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉ｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
		out:  "‛␉ｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
	}, { // 2446
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "V\t\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
		out:  "V\t\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
	}, { // 2447
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "V␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
		out:  "V␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␊",
	}, { // 2448
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "V\t\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
		out:  "V\t\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
	}, { // 2449
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "V␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
		out:  "V␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
	}, { // 2450
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "V\t\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
		out:  "V\t\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
	}, { // 2451
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "V␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
		out:  "V␉\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
	}, { // 2452
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂\t␊",
		out:  "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂\t␊",
	}, { // 2453
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
		out:  "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␊",
	}, { // 2454
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂\t␉",
		out:  "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂\t␉",
	}, { // 2455
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␉",
		out:  "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂␉␉",
	}, { // 2456
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ\t",
		out:  "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ\t",
	}, { // 2457
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
		out:  "Vｊ\x05Ｂ[＾＆␗α\x1b\tζｃ!␒λ␍\x16ιｑ$␞#i%ω@␂ρ␉",
	}, { // 2458
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
		out:  "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
	}, { // 2459
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
		out:  "␊␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
	}, { // 2460
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
		out:  "‛␊␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
	}, { // 2461
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\nτW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
		out:  "␊τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
	}, { // 2462
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
		out:  "‛␊τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
	}, { // 2463
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\nτW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
		out:  "␊τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
	}, { // 2464
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
		out:  "‛␊τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
	}, { // 2465
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{\nW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
		out:  "{\nW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
	}, { // 2466
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
		out:  "{␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$!",
	}, { // 2467
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{\nW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
		out:  "{\nW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
	}, { // 2468
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
		out:  "{␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
	}, { // 2469
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{\nW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
		out:  "{\nW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
	}, { // 2470
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
		out:  "{␊W／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
	}, { // 2471
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r\n!",
		out:  "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r\n!",
	}, { // 2472
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
		out:  "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊!",
	}, { // 2473
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r\n␊",
		out:  "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r\n␊",
	}, { // 2474
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊␊",
		out:  "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r␊␊",
	}, { // 2475
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$\n",
		out:  "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$\n",
	}, { // 2476
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
		out:  "{τW／*ν\x1e８＊／\nπ␜Ｎ％］8θＯ\"ｌς\x01ο,␕*\r$␊",
	}, { // 2477
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
		out:  "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
	}, { // 2478
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
		out:  "␋␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
	}, { // 2479
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
		out:  "‛␋␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
	}, { // 2480
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\vＮ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
		out:  "␋Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
	}, { // 2481
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
		out:  "‛␋Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
	}, { // 2482
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\vＮ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
		out:  "␋Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
	}, { // 2483
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
		out:  "‛␋Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
	}, { // 2484
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`\v\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
		out:  "`\v\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
	}, { // 2485
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
		out:  "`␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/o",
	}, { // 2486
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`\v\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
		out:  "`\v\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
	}, { // 2487
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
		out:  "`␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
	}, { // 2488
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`\v\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
		out:  "`\v\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
	}, { // 2489
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
		out:  "`␋\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
	}, { // 2490
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜\vo",
		out:  "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜\vo",
	}, { // 2491
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
		out:  "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋o",
	}, { // 2492
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜\v␋",
		out:  "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜\v␋",
	}, { // 2493
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋␋",
		out:  "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜␋␋",
	}, { // 2494
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/\v",
		out:  "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/\v",
	}, { // 2495
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
		out:  "`Ｎ\\␎σ␚ＦDｅμ\v\x1c␗ＡA５␈ω[xfＫυ#\x12ς＜␜/␋",
	}, { // 2496
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
		out:  "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
	}, { // 2497
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\r␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
		out:  "␍␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
	}, { // 2498
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
		out:  "‛␍␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
	}, { // 2499
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\r\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
		out:  "␍\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
	}, { // 2500
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
		out:  "‛␍\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
	}, { // 2501
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\r\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
		out:  "␍\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
	}, { // 2502
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
		out:  "‛␍\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
	}, { // 2503
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\rκC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
		out:  "n\rκC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
	}, { // 2504
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
		out:  "n␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠｝",
	}, { // 2505
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\rκC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
		out:  "n\rκC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
	}, { // 2506
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
		out:  "n␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
	}, { // 2507
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\rκC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
		out:  "n\rκC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
	}, { // 2508
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
		out:  "n␍κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
	}, { // 2509
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ\r｝",
		out:  "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ\r｝",
	}, { // 2510
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
		out:  "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍｝",
	}, { // 2511
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ\r␍",
		out:  "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ\r␍",
	}, { // 2512
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍␍",
		out:  "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ␍␍",
	}, { // 2513
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠\r",
		out:  "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠\r",
	}, { // 2514
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
		out:  "n\uff00κC␈]\\／＞␂\r%ｔk␏？βδF!/ｌ?8\x16σασ＠␍",
	}, { // 2515
		mask: EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 2516
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
		out:  "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
	}, { // 2517
		mask: EncodeZero | EncodeRightSpace,
		in:   " ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
		out:  " ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
	}, { // 2518
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
		out:  "␠␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
	}, { // 2519
		mask: EncodeZero | EncodeRightSpace,
		in:   " λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
		out:  " λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
	}, { // 2520
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
		out:  "␠λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
	}, { // 2521
		mask: EncodeZero | EncodeRightSpace,
		in:   " λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅␠",
		out:  " λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅‛␠",
	}, { // 2522
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅␠",
		out:  "␠λM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅‛␠",
	}, { // 2523
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐ M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
		out:  "ｐ M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
	}, { // 2524
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
		out:  "ｐ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ｏ",
	}, { // 2525
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐ M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
		out:  "ｐ M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
	}, { // 2526
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
		out:  "ｐ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
	}, { // 2527
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐ M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅␠",
		out:  "ｐ M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅‛␠",
	}, { // 2528
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅␠",
		out:  "ｐ␠M ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅‛␠",
	}, { // 2529
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19 ｏ",
		out:  "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19 ｏ",
	}, { // 2530
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
		out:  "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠ｏ",
	}, { // 2531
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19 ␠",
		out:  "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19 ‛␠",
	}, { // 2532
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠␠",
		out:  "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␠‛␠",
	}, { // 2533
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅ ",
		out:  "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅␠",
	}, { // 2534
		mask: EncodeZero | EncodeRightSpace,
		in:   "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅␠",
		out:  "ｐλM ␉DZ\x10␒Ｍ ３\x19κ＇\nｐτ_χπ\rYρ／␡%\x19␅‛␠",
	}, { // 2535
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
		out:  "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
	}, { // 2536
		mask: EncodeSlash | EncodeRightSpace,
		in:   " ␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
		out:  " ␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
	}, { // 2537
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
		out:  "␠␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
	}, { // 2538
		mask: EncodeSlash | EncodeRightSpace,
		in:   " >␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
		out:  " >␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
	}, { // 2539
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
		out:  "␠>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
	}, { // 2540
		mask: EncodeSlash | EncodeRightSpace,
		in:   " >␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞␠",
		out:  " >␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞‛␠",
	}, { // 2541
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞␠",
		out:  "␠>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞‛␠",
	}, { // 2542
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑ ␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
		out:  "␑ ␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
	}, { // 2543
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
		out:  "␑␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ｚ",
	}, { // 2544
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑ ␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
		out:  "␑ ␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
	}, { // 2545
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
		out:  "␑␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
	}, { // 2546
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑ ␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞␠",
		out:  "␑ ␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞‛␠",
	}, { // 2547
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞␠",
		out:  "␑␠␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞‛␠",
	}, { // 2548
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍ ｚ",
		out:  "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍ ｚ",
	}, { // 2549
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
		out:  "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠ｚ",
	}, { // 2550
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍ ␠",
		out:  "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍ ‛␠",
	}, { // 2551
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠␠",
		out:  "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍␠‛␠",
	}, { // 2552
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞ ",
		out:  "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞␠",
	}, { // 2553
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞␠",
		out:  "␑>␒ｚ␌ｏｓσ\x0fζ X\"#)η8ρ␉#λ1\v]＾ο9␍＞‛␠",
	}, { // 2554
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␎",
		out:  "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{␎",
	}, { // 2555
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␎",
		out:  " ␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{␎",
	}, { // 2556
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␎",
		out:  "␠␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{␎",
	}, { // 2557
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋␠␎",
		out:  " Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋␠␎",
	}, { // 2558
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋␠␎",
		out:  "␠Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋␠␎",
	}, { // 2559
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␠",
		out:  " Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{‛␠",
	}, { // 2560
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␠",
		out:  "␠Ｋi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{‛␠",
	}, { // 2561
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\r i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␎",
		out:  "\r i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{␎",
	}, { // 2562
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\r␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␎",
		out:  "\r␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{␎",
	}, { // 2563
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\r i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋␠␎",
		out:  "\r i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋␠␎",
	}, { // 2564
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\r␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋␠␎",
		out:  "\r␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋␠␎",
	}, { // 2565
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\r i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␠",
		out:  "\r i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{‛␠",
	}, { // 2566
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\r␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␠",
		out:  "\r␠i2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{‛␠",
	}, { // 2567
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋ ␎",
		out:  "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋ ␎",
	}, { // 2568
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋␠␎",
		out:  "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋␠␎",
	}, { // 2569
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋ ␠",
		out:  "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋ ‛␠",
	}, { // 2570
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋␠␠",
		out:  "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋␠‛␠",
	}, { // 2571
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{ ",
		out:  "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{␠",
	}, { // 2572
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍␀７ψcＫ␋{␠",
		out:  "\rＫi2\rI^ξ␊% \x19ιｅγγ␆３ηｈ\x0f␍‛␀７ψcＫ␋{‛␠",
	}, { // 2573
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
		out:  "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
	}, { // 2574
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
		out:  " ␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
	}, { // 2575
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
		out:  "␠␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
	}, { // 2576
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
		out:  " ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
	}, { // 2577
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
		out:  "␠ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
	}, { // 2578
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␠",
		out:  " ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c‛␠",
	}, { // 2579
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␠",
		out:  "␠ｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c‛␠",
	}, { // 2580
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "n \"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
		out:  "n \"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
	}, { // 2581
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "n␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
		out:  "n␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␈",
	}, { // 2582
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "n \"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
		out:  "n \"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
	}, { // 2583
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "n␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
		out:  "n␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
	}, { // 2584
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "n \"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␠",
		out:  "n \"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c‛␠",
	}, { // 2585
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "n␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␠",
		out:  "n␠\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c‛␠",
	}, { // 2586
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ ␈",
		out:  "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ ␈",
	}, { // 2587
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
		out:  "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␈",
	}, { // 2588
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ ␠",
		out:  "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ ‛␠",
	}, { // 2589
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠␠",
		out:  "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ␠‛␠",
	}, { // 2590
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c ",
		out:  "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␠",
	}, { // 2591
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c␠",
		out:  "nｒ\"@β／ｃOρ～ \x16␐κκ␍gｒ␒\x19\r\x1d％６Q5ζυ\x1c‛␠",
	}, { // 2592
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜\x01",
		out:  "＠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜\x01",
	}, { // 2593
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ␠φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜\x01",
		out:  " ␠φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜\x01",
	}, { // 2594
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠␠φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜\x01",
		out:  "␠␠φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜\x01",
	}, { // 2595
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v␠\x01",
		out:  " ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v␠\x01",
	}, { // 2596
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v␠\x01",
		out:  "␠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v␠\x01",
	}, { // 2597
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜␠",
		out:  " ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜‛␠",
	}, { // 2598
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜␠",
		out:  "␠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜‛␠",
	}, { // 2599
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜\x01",
		out:  "＠ φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜\x01",
	}, { // 2600
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠␠φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜\x01",
		out:  "＠␠φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜\x01",
	}, { // 2601
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v␠\x01",
		out:  "＠ φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v␠\x01",
	}, { // 2602
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠␠φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v␠\x01",
		out:  "＠␠φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v␠\x01",
	}, { // 2603
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜␠",
		out:  "＠ φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜‛␠",
	}, { // 2604
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠␠φη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜␠",
		out:  "＠␠φη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜‛␠",
	}, { // 2605
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v \x01",
		out:  "＠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v \x01",
	}, { // 2606
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v␠\x01",
		out:  "＠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v␠\x01",
	}, { // 2607
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v ␠",
		out:  "＠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v ‛␠",
	}, { // 2608
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v␠␠",
		out:  "＠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v␠‛␠",
	}, { // 2609
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜ ",
		out:  "＠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜␠",
	}, { // 2610
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "＠ｂφη;␈fＬlＣ φ［γZ＄␚＞＊:α,：\"ι{,\v｜␠",
		out:  "＠ｂφη;␈fＬlＣ φ［γZ＄␚‛＞＊:α,：\"ι{,\v｜‛␠",
	}, { // 2611
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
		out:  "＊ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
	}, { // 2612
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " ␠\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
		out:  " ␠\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
	}, { // 2613
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠␠\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
		out:  "␠␠\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
	}, { // 2614
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
		out:  " ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
	}, { // 2615
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
		out:  "␠ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
	}, { // 2616
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS␠",
		out:  " ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS‛␠",
	}, { // 2617
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS␠",
		out:  "␠ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS‛␠",
	}, { // 2618
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ \n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
		out:  "＊ \n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
	}, { // 2619
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊␠\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
		out:  "＊␠\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS<",
	}, { // 2620
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ \n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
		out:  "＊ \n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
	}, { // 2621
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊␠\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
		out:  "＊␠\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
	}, { // 2622
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ \n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS␠",
		out:  "＊ \n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS‛␠",
	}, { // 2623
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊␠\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS␠",
		out:  "＊␠\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS‛␠",
	}, { // 2624
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ <",
		out:  "＊ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ <",
	}, { // 2625
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
		out:  "＊ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠<",
	}, { // 2626
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ ␠",
		out:  "＊ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ ‛␠",
	}, { // 2627
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠␠",
		out:  "＊ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌ␠‛␠",
	}, { // 2628
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS ",
		out:  "＊ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS␠",
	}, { // 2629
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "＊ｔ\n1\r｜χ␞［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS␠",
		out:  "＊ｔ\n1\r｜χ␞‛［\x16 ;9ｐgδωυ`Fｆｃ％χ＃｜\x16ｌS‛␠",
	}, { // 2630
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９>",
		out:  "␆\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９>",
	}, { // 2631
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   " ␠?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９>",
		out:  " ␠?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９>",
	}, { // 2632
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␠␠?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９>",
		out:  "␠␠?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９>",
	}, { // 2633
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   " \x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜␠>",
		out:  " \x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜␠>",
	}, { // 2634
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␠\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜␠>",
		out:  "␠\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜␠>",
	}, { // 2635
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   " \x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９␠",
		out:  " \x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９‛␠",
	}, { // 2636
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␠\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９␠",
		out:  "␠\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９‛␠",
	}, { // 2637
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆ ?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９>",
		out:  "␆ ?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９>",
	}, { // 2638
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆␠?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９>",
		out:  "␆␠?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９>",
	}, { // 2639
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆ ?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜␠>",
		out:  "␆ ?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜␠>",
	}, { // 2640
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆␠?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜␠>",
		out:  "␆␠?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜␠>",
	}, { // 2641
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆ ?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９␠",
		out:  "␆ ?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９‛␠",
	}, { // 2642
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆␠?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９␠",
		out:  "␆␠?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９‛␠",
	}, { // 2643
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜ >",
		out:  "␆\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜ >",
	}, { // 2644
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜␠>",
		out:  "␆\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜␠>",
	}, { // 2645
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜ ␠",
		out:  "␆\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜ ‛␠",
	}, { // 2646
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜␠␠",
		out:  "␆\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜␠‛␠",
	}, { // 2647
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９ ",
		out:  "␆\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９␠",
	}, { // 2648
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␆\x05?␞w<\fσ␇５ sκω／；H␉␐－ξUφλ_＼p｜９␠",
		out:  "␆\x05?␞w<\fσ␇５ sκω／‛；H␉␐－ξUφλ_＼p｜９‛␠",
	}, { // 2649
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
		out:  "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
	}, { // 2650
		mask: EncodeExclamation | EncodeRightSpace,
		in:   " ␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
		out:  " ␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
	}, { // 2651
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "␠␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
		out:  "␠␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
	}, { // 2652
		mask: EncodeExclamation | EncodeRightSpace,
		in:   " ０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
		out:  " ０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
	}, { // 2653
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "␠０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
		out:  "␠０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
	}, { // 2654
		mask: EncodeExclamation | EncodeRightSpace,
		in:   " ０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［␠",
		out:  " ０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［‛␠",
	}, { // 2655
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "␠０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［␠",
		out:  "␠０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［‛␠",
	}, { // 2656
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t ｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
		out:  "\t ｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
	}, { // 2657
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
		out:  "\t␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ｈ",
	}, { // 2658
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t ｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
		out:  "\t ｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
	}, { // 2659
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
		out:  "\t␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
	}, { // 2660
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t ｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［␠",
		out:  "\t ｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［‛␠",
	}, { // 2661
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［␠",
		out:  "\t␠｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［‛␠",
	}, { // 2662
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν ｈ",
		out:  "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν ｈ",
	}, { // 2663
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
		out:  "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠ｈ",
	}, { // 2664
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν ␠",
		out:  "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν ‛␠",
	}, { // 2665
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠␠",
		out:  "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν␠‛␠",
	}, { // 2666
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［ ",
		out:  "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［␠",
	}, { // 2667
		mask: EncodeExclamation | EncodeRightSpace,
		in:   "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［␠",
		out:  "\t０｜\x11ｏ\vςδjＰ πξ；DE␐9\x18η9＝［\x1cU\x1e␏ν［‛␠",
	}, { // 2668
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
		out:  "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
	}, { // 2669
		mask: EncodeDollar | EncodeRightSpace,
		in:   " ␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
		out:  " ␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
	}, { // 2670
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
		out:  "␠␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
	}, { // 2671
		mask: EncodeDollar | EncodeRightSpace,
		in:   " ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
		out:  " ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
	}, { // 2672
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
		out:  "␠ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
	}, { // 2673
		mask: EncodeDollar | EncodeRightSpace,
		in:   " ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ␠",
		out:  " ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ‛␠",
	}, { // 2674
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ␠",
		out:  "␠ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ‛␠",
	}, { // 2675
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ \tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
		out:  "－ \tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
	}, { // 2676
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
		out:  "－␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ\x01",
	}, { // 2677
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ \tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
		out:  "－ \tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
	}, { // 2678
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
		out:  "－␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
	}, { // 2679
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ \tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ␠",
		out:  "－ \tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ‛␠",
	}, { // 2680
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ␠",
		out:  "－␠\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ‛␠",
	}, { // 2681
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ \x01",
		out:  "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ \x01",
	}, { // 2682
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
		out:  "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠\x01",
	}, { // 2683
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ ␠",
		out:  "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ ‛␠",
	}, { // 2684
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠␠",
		out:  "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κ␠‛␠",
	}, { // 2685
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ ",
		out:  "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ␠",
	}, { // 2686
		mask: EncodeDollar | EncodeRightSpace,
		in:   "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ␠",
		out:  "－ς\tIＮ␎？＼ζ｀ 6＠?：nW␅τTι\x19？␑␇!!κθ‛␠",
	}, { // 2687
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
		out:  "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
	}, { // 2688
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
		out:  " ␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
	}, { // 2689
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
		out:  "␠␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
	}, { // 2690
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
		out:  " IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
	}, { // 2691
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
		out:  "␠IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
	}, { // 2692
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12␠",
		out:  " IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12‛␠",
	}, { // 2693
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12␠",
		out:  "␠IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12‛␠",
	}, { // 2694
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝ Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
		out:  "␝ Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
	}, { // 2695
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
		out:  "␝␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12\x01",
	}, { // 2696
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝ Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
		out:  "␝ Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
	}, { // 2697
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
		out:  "␝␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
	}, { // 2698
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝ Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12␠",
		out:  "␝ Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12‛␠",
	}, { // 2699
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12␠",
		out:  "␝␠Vｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12‛␠",
	}, { // 2700
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee \x01",
		out:  "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee \x01",
	}, { // 2701
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
		out:  "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠\x01",
	}, { // 2702
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee ␠",
		out:  "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee ‛␠",
	}, { // 2703
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠␠",
		out:  "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee␠‛␠",
	}, { // 2704
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12 ",
		out:  "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12␠",
	}, { // 2705
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12␠",
		out:  "␝IVｅ0%\x7f３κｅ !\x0fθζυ␟／＃：ＦπUβＧ␌\x1ee\x12‛␠",
	}, { // 2706
		mask: EncodeColon | EncodeRightSpace,
		in:   ":］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
		out:  "：］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
	}, { // 2707
		mask: EncodeColon | EncodeRightSpace,
		in:   " ␠χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
		out:  " ␠χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
	}, { // 2708
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠␠χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
		out:  "␠␠χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
	}, { // 2709
		mask: EncodeColon | EncodeRightSpace,
		in:   " ］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
		out:  " ］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
	}, { // 2710
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
		out:  "␠］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
	}, { // 2711
		mask: EncodeColon | EncodeRightSpace,
		in:   " ］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␠",
		out:  " ］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι‛␠",
	}, { // 2712
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␠",
		out:  "␠］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι‛␠",
	}, { // 2713
		mask: EncodeColon | EncodeRightSpace,
		in:   ": χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
		out:  "： χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
	}, { // 2714
		mask: EncodeColon | EncodeRightSpace,
		in:   ":␠χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
		out:  "：␠χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␗",
	}, { // 2715
		mask: EncodeColon | EncodeRightSpace,
		in:   ": χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
		out:  "： χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
	}, { // 2716
		mask: EncodeColon | EncodeRightSpace,
		in:   ":␠χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
		out:  "：␠χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
	}, { // 2717
		mask: EncodeColon | EncodeRightSpace,
		in:   ": χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␠",
		out:  "： χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι‛␠",
	}, { // 2718
		mask: EncodeColon | EncodeRightSpace,
		in:   ":␠χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␠",
		out:  "：␠χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι‛␠",
	}, { // 2719
		mask: EncodeColon | EncodeRightSpace,
		in:   ":］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`. ␗",
		out:  "：］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`. ␗",
	}, { // 2720
		mask: EncodeColon | EncodeRightSpace,
		in:   ":］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
		out:  "：］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␗",
	}, { // 2721
		mask: EncodeColon | EncodeRightSpace,
		in:   ":］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`. ␠",
		out:  "：］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`. ‛␠",
	}, { // 2722
		mask: EncodeColon | EncodeRightSpace,
		in:   ":］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠␠",
		out:  "：］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.␠‛␠",
	}, { // 2723
		mask: EncodeColon | EncodeRightSpace,
		in:   ":］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι ",
		out:  "：］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␠",
	}, { // 2724
		mask: EncodeColon | EncodeRightSpace,
		in:   ":］χJｎＴ:η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι␠",
		out:  "：］χJｎＴ：η［ε ο\n~\x06␒Ｕ＊pι␒p␙＆\vＥ`.ι‛␠",
	}, { // 2725
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{*",
		out:  "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{*",
	}, { // 2726
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{*",
		out:  " ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{*",
	}, { // 2727
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{*",
		out:  "␠␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{*",
	}, { // 2728
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " \x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,␠*",
		out:  " \x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,␠*",
	}, { // 2729
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,␠*",
		out:  "␠\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,␠*",
	}, { // 2730
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " \x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{␠",
		out:  " \x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{‛␠",
	}, { // 2731
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{␠",
		out:  "␠\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{‛␠",
	}, { // 2732
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ ＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{*",
		out:  "Ｕ ＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{*",
	}, { // 2733
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{*",
		out:  "Ｕ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{*",
	}, { // 2734
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ ＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,␠*",
		out:  "Ｕ ＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,␠*",
	}, { // 2735
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,␠*",
		out:  "Ｕ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,␠*",
	}, { // 2736
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ ＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{␠",
		out:  "Ｕ ＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{‛␠",
	}, { // 2737
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{␠",
		out:  "Ｕ␠＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{‛␠",
	}, { // 2738
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ, *",
		out:  "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ, *",
	}, { // 2739
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,␠*",
		out:  "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,␠*",
	}, { // 2740
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ, ␠",
		out:  "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ, ‛␠",
	}, { // 2741
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,␠␠",
		out:  "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,␠‛␠",
	}, { // 2742
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{ ",
		out:  "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{␠",
	}, { // 2743
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉\x00␉ａσ,{␠",
		out:  "Ｕ\x15＋＆υ␡／\x1bμς # π␘|z\"／\x19ｙＥ␉␀␉ａσ,{‛␠",
	}, { // 2744
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχγ",
		out:  "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχγ",
	}, { // 2745
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχγ",
		out:  " ␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχγ",
	}, { // 2746
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχγ",
		out:  "␠␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχγ",
	}, { // 2747
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r␠γ",
		out:  " ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r␠γ",
	}, { // 2748
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r␠γ",
		out:  "␠ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r␠γ",
	}, { // 2749
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχ␠",
		out:  " ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχ‛␠",
	}, { // 2750
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχ␠",
		out:  "␠ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχ‛␠",
	}, { // 2751
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχγ",
		out:  "＞ Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχγ",
	}, { // 2752
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχγ",
		out:  "＞␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχγ",
	}, { // 2753
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r␠γ",
		out:  "＞ Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r␠γ",
	}, { // 2754
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r␠γ",
		out:  "＞␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r␠γ",
	}, { // 2755
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχ␠",
		out:  "＞ Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχ‛␠",
	}, { // 2756
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχ␠",
		out:  "＞␠Ｔm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχ‛␠",
	}, { // 2757
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r γ",
		out:  "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r γ",
	}, { // 2758
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r␠γ",
		out:  "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r␠γ",
	}, { // 2759
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r ␠",
		out:  "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r ‛␠",
	}, { // 2760
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\r␠␠",
		out:  "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\r␠‛␠",
	}, { // 2761
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχ ",
		out:  "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχ␠",
	}, { // 2762
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊␀2eρ\fｌγ\rχ␠",
		out:  "＞ｔＴm␁\x18Yεσ１ ␎6\x10！＜]E␌␊‛␀2eρ\fｌγ\rχ‛␠",
	}, { // 2763
		mask: EncodePipe | EncodeRightSpace,
		in:   "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
		out:  "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
	}, { // 2764
		mask: EncodePipe | EncodeRightSpace,
		in:   " ␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
		out:  " ␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
	}, { // 2765
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
		out:  "␠␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
	}, { // 2766
		mask: EncodePipe | EncodeRightSpace,
		in:   " \x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
		out:  " \x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
	}, { // 2767
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
		out:  "␠\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
	}, { // 2768
		mask: EncodePipe | EncodeRightSpace,
		in:   " \x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖␠",
		out:  " \x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖‛␠",
	}, { // 2769
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖␠",
		out:  "␠\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖‛␠",
	}, { // 2770
		mask: EncodePipe | EncodeRightSpace,
		in:   "６ Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
		out:  "６ Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
	}, { // 2771
		mask: EncodePipe | EncodeRightSpace,
		in:   "６␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
		out:  "６␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖\x15",
	}, { // 2772
		mask: EncodePipe | EncodeRightSpace,
		in:   "６ Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
		out:  "６ Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
	}, { // 2773
		mask: EncodePipe | EncodeRightSpace,
		in:   "６␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
		out:  "６␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
	}, { // 2774
		mask: EncodePipe | EncodeRightSpace,
		in:   "６ Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖␠",
		out:  "６ Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖‛␠",
	}, { // 2775
		mask: EncodePipe | EncodeRightSpace,
		in:   "６␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖␠",
		out:  "６␠Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖‛␠",
	}, { // 2776
		mask: EncodePipe | EncodeRightSpace,
		in:   "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０ \x15",
		out:  "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０ \x15",
	}, { // 2777
		mask: EncodePipe | EncodeRightSpace,
		in:   "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
		out:  "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠\x15",
	}, { // 2778
		mask: EncodePipe | EncodeRightSpace,
		in:   "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０ ␠",
		out:  "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０ ‛␠",
	}, { // 2779
		mask: EncodePipe | EncodeRightSpace,
		in:   "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠␠",
		out:  "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␠‛␠",
	}, { // 2780
		mask: EncodePipe | EncodeRightSpace,
		in:   "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖ ",
		out:  "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖␠",
	}, { // 2781
		mask: EncodePipe | EncodeRightSpace,
		in:   "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖␠",
		out:  "６\x02Lς\x1cλＥ\x05<\x05 ：␎γν^␕&ｑ\r␅*χ４ψo␉０␖‛␠",
	}, { // 2782
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
		out:  "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
	}, { // 2783
		mask: EncodeHash | EncodeRightSpace,
		in:   " ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
		out:  " ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
	}, { // 2784
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
		out:  "␠␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
	}, { // 2785
		mask: EncodeHash | EncodeRightSpace,
		in:   " ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
		out:  " ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
	}, { // 2786
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
		out:  "␠␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
	}, { // 2787
		mask: EncodeHash | EncodeRightSpace,
		in:   " ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）␠",
		out:  " ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）‛␠",
	}, { // 2788
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）␠",
		out:  "␠␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）‛␠",
	}, { // 2789
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ ｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
		out:  "γ ｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
	}, { // 2790
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
		out:  "γ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）Ｋ",
	}, { // 2791
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ ｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
		out:  "γ ｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
	}, { // 2792
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
		out:  "γ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
	}, { // 2793
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ ｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）␠",
		out:  "γ ｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）‛␠",
	}, { // 2794
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）␠",
		out:  "γ␠｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）‛␠",
	}, { // 2795
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏ Ｋ",
		out:  "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏ Ｋ",
	}, { // 2796
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
		out:  "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠Ｋ",
	}, { // 2797
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏ ␠",
		out:  "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏ ‛␠",
	}, { // 2798
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠␠",
		out:  "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏␠‛␠",
	}, { // 2799
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏） ",
		out:  "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）␠",
	}, { // 2800
		mask: EncodeHash | EncodeRightSpace,
		in:   "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）␠",
		out:  "γ␍｀θβζ\x7f/␔O Kω\x14?␋\x0e～Ｉ\x16;>ψ＄poＢ␏）‛␠",
	}, { // 2801
		mask: EncodePercent | EncodeRightSpace,
		in:   "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
		out:  "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
	}, { // 2802
		mask: EncodePercent | EncodeRightSpace,
		in:   " ␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
		out:  " ␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
	}, { // 2803
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
		out:  "␠␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
	}, { // 2804
		mask: EncodePercent | EncodeRightSpace,
		in:   " μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
		out:  " μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
	}, { // 2805
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
		out:  "␠μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
	}, { // 2806
		mask: EncodePercent | EncodeRightSpace,
		in:   " μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P␠",
		out:  " μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P‛␠",
	}, { // 2807
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P␠",
		out:  "␠μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P‛␠",
	}, { // 2808
		mask: EncodePercent | EncodeRightSpace,
		in:   "- ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
		out:  "- ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
	}, { // 2809
		mask: EncodePercent | EncodeRightSpace,
		in:   "-␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
		out:  "-␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅PＦ",
	}, { // 2810
		mask: EncodePercent | EncodeRightSpace,
		in:   "- ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
		out:  "- ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
	}, { // 2811
		mask: EncodePercent | EncodeRightSpace,
		in:   "-␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
		out:  "-␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
	}, { // 2812
		mask: EncodePercent | EncodeRightSpace,
		in:   "- ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P␠",
		out:  "- ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P‛␠",
	}, { // 2813
		mask: EncodePercent | EncodeRightSpace,
		in:   "-␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P␠",
		out:  "-␠␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P‛␠",
	}, { // 2814
		mask: EncodePercent | EncodeRightSpace,
		in:   "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅ Ｆ",
		out:  "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅ Ｆ",
	}, { // 2815
		mask: EncodePercent | EncodeRightSpace,
		in:   "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
		out:  "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠Ｆ",
	}, { // 2816
		mask: EncodePercent | EncodeRightSpace,
		in:   "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅ ␠",
		out:  "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅ ‛␠",
	}, { // 2817
		mask: EncodePercent | EncodeRightSpace,
		in:   "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠␠",
		out:  "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅␠‛␠",
	}, { // 2818
		mask: EncodePercent | EncodeRightSpace,
		in:   "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P ",
		out:  "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P␠",
	}, { // 2819
		mask: EncodePercent | EncodeRightSpace,
		in:   "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P␠",
		out:  "-μ␁Ｅζi`/Ｕ? ␊Ｕ\x18␚␇gZππ１β\x1f*；Vθ␅P‛␠",
	}, { // 2820
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
		out:  "␛＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
	}, { // 2821
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " ␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
		out:  " ␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
	}, { // 2822
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
		out:  "␠␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
	}, { // 2823
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " \\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
		out:  " ＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
	}, { // 2824
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
		out:  "␠＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
	}, { // 2825
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " \\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ␠",
		out:  " ＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ‛␠",
	}, { // 2826
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ␠",
		out:  "␠＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ‛␠",
	}, { // 2827
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛ Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
		out:  "␛ Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
	}, { // 2828
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
		out:  "␛␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａｕ",
	}, { // 2829
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛ Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
		out:  "␛ Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
	}, { // 2830
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
		out:  "␛␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
	}, { // 2831
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛ Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ␠",
		out:  "␛ Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ‛␠",
	}, { // 2832
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ␠",
		out:  "␛␠Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ‛␠",
	}, { // 2833
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ ｕ",
		out:  "␛＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ ｕ",
	}, { // 2834
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
		out:  "␛＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠ｕ",
	}, { // 2835
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ ␠",
		out:  "␛＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ ‛␠",
	}, { // 2836
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠␠",
		out:  "␛＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓␠‛␠",
	}, { // 2837
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ ",
		out:  "␛＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ␠",
	}, { // 2838
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␛\\Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ␠",
		out:  "␛＼Rς␟\x14%θＴω ｒ\f；b\"yε%:␔\x06␘５ｃδ/␓ａ‛␠",
	}, { // 2839
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
		out:  "‛␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
	}, { // 2840
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
		out:  " ␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
	}, { // 2841
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
		out:  "␠␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
	}, { // 2842
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
		out:  " ３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
	}, { // 2843
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
		out:  "␠３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
	}, { // 2844
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a␠",
		out:  " ３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a‛␠",
	}, { // 2845
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a␠",
		out:  "␠３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a‛␠",
	}, { // 2846
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊ ␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
		out:  "‛␊ ␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
	}, { // 2847
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
		out:  "‛␊␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|aL",
	}, { // 2848
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊ ␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
		out:  "‛␊ ␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
	}, { // 2849
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
		out:  "‛␊␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
	}, { // 2850
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊ ␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a␠",
		out:  "‛␊ ␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a‛␠",
	}, { // 2851
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a␠",
		out:  "‛␊␠␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a‛␠",
	}, { // 2852
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞| L",
		out:  "‛␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞| L",
	}, { // 2853
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
		out:  "‛␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠L",
	}, { // 2854
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞| ␠",
		out:  "‛␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞| ‛␠",
	}, { // 2855
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠␠",
		out:  "‛␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|␠‛␠",
	}, { // 2856
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a ",
		out:  "‛␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a␠",
	}, { // 2857
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a␠",
		out:  "‛␊３␜h\\\vＺσθ］ \x13'＂<ｈ［Ｙσ␂\v`ｌθυτ＞|a‛␠",
	}, { // 2858
		mask: EncodeDel | EncodeRightSpace,
		in:   "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
		out:  "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
	}, { // 2859
		mask: EncodeDel | EncodeRightSpace,
		in:   " ␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
		out:  " ␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
	}, { // 2860
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
		out:  "␠␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
	}, { // 2861
		mask: EncodeDel | EncodeRightSpace,
		in:   " β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
		out:  " β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
	}, { // 2862
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
		out:  "␠β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
	}, { // 2863
		mask: EncodeDel | EncodeRightSpace,
		in:   " β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r␠",
		out:  " β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r‛␠",
	}, { // 2864
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r␠",
		out:  "␠β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r‛␠",
	}, { // 2865
		mask: EncodeDel | EncodeRightSpace,
		in:   "4 ％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
		out:  "4 ％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
	}, { // 2866
		mask: EncodeDel | EncodeRightSpace,
		in:   "4␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
		out:  "4␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r>",
	}, { // 2867
		mask: EncodeDel | EncodeRightSpace,
		in:   "4 ％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
		out:  "4 ％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
	}, { // 2868
		mask: EncodeDel | EncodeRightSpace,
		in:   "4␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
		out:  "4␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
	}, { // 2869
		mask: EncodeDel | EncodeRightSpace,
		in:   "4 ％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r␠",
		out:  "4 ％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r‛␠",
	}, { // 2870
		mask: EncodeDel | EncodeRightSpace,
		in:   "4␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r␠",
		out:  "4␠％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r‛␠",
	}, { // 2871
		mask: EncodeDel | EncodeRightSpace,
		in:   "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜ >",
		out:  "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜ >",
	}, { // 2872
		mask: EncodeDel | EncodeRightSpace,
		in:   "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
		out:  "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠>",
	}, { // 2873
		mask: EncodeDel | EncodeRightSpace,
		in:   "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜ ␠",
		out:  "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜ ‛␠",
	}, { // 2874
		mask: EncodeDel | EncodeRightSpace,
		in:   "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠␠",
		out:  "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜␠‛␠",
	}, { // 2875
		mask: EncodeDel | EncodeRightSpace,
		in:   "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r ",
		out:  "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r␠",
	}, { // 2876
		mask: EncodeDel | EncodeRightSpace,
		in:   "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r␠",
		out:  "4β％␝ｈ．␘;!C `π␊␐υ＼\x18：\\ςｐ\aq`θ％｜\r‛␠",
	}, { // 2877
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ+",
		out:  "ｑ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ+",
	}, { // 2878
		mask: EncodeCtl | EncodeRightSpace,
		in:   " ␠Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ+",
		out:  " ␠Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ+",
	}, { // 2879
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠␠Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ+",
		out:  "␠␠Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ+",
	}, { // 2880
		mask: EncodeCtl | EncodeRightSpace,
		in:   " \rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！␠+",
		out:  " ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！␠+",
	}, { // 2881
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！␠+",
		out:  "␠␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！␠+",
	}, { // 2882
		mask: EncodeCtl | EncodeRightSpace,
		in:   " \rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ␠",
		out:  " ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ‛␠",
	}, { // 2883
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ␠",
		out:  "␠␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ‛␠",
	}, { // 2884
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ+",
		out:  "ｑ Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ+",
	}, { // 2885
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ␠Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ+",
		out:  "ｑ␠Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ+",
	}, { // 2886
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！␠+",
		out:  "ｑ Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！␠+",
	}, { // 2887
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ␠Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！␠+",
		out:  "ｑ␠Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！␠+",
	}, { // 2888
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ␠",
		out:  "ｑ Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ‛␠",
	}, { // 2889
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ␠Ｃ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ␠",
		out:  "ｑ␠Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ‛␠",
	}, { // 2890
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ +",
		out:  "ｑ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ +",
	}, { // 2891
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！␠+",
		out:  "ｑ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！␠+",
	}, { // 2892
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ ␠",
		out:  "ｑ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ ‛␠",
	}, { // 2893
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！␠␠",
		out:  "ｑ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！␠‛␠",
	}, { // 2894
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ ",
		out:  "ｑ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ␠",
	}, { // 2895
		mask: EncodeCtl | EncodeRightSpace,
		in:   "ｑ\rＣ!#－?rβｖ ς%␘␅δ＊θ␇σ␡␌%π4nS！ｆ␠",
		out:  "ｑ␍Ｃ!#－?rβｖ ς%‛␘‛␅δ＊θ‛␇σ␡‛␌%π4nS！ｆ‛␠",
	}, { // 2896
		mask: EncodeRightPeriod,
		in:   ".",
		out:  "．",
	}, { // 2897
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
		out:  "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
	}, { // 2898
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
		out:  ".．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
	}, { // 2899
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
		out:  "．．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
	}, { // 2900
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
		out:  ".^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
	}, { // 2901
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
		out:  "．^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
	}, { // 2902
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r．",
		out:  ".^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r‛．",
	}, { // 2903
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r．",
		out:  "．^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r‛．",
	}, { // 2904
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙.εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
		out:  "␙.εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
	}, { // 2905
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
		out:  "␙．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r／",
	}, { // 2906
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙.εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
		out:  "␙.εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
	}, { // 2907
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
		out:  "␙．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
	}, { // 2908
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙.εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r．",
		out:  "␙.εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r‛．",
	}, { // 2909
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r．",
		out:  "␙．εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r‛．",
	}, { // 2910
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ.／",
		out:  "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ.／",
	}, { // 2911
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
		out:  "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．／",
	}, { // 2912
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ.．",
		out:  "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ.‛．",
	}, { // 2913
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．．",
		out:  "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ．‛．",
	}, { // 2914
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r.",
		out:  "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r．",
	}, { // 2915
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r．",
		out:  "␙^εχ＜ρ>\x05␘ｂ.λ！\x1c␘κｆ␜ｃ％Gy*\x1ae+\rＧ\r‛．",
	}, { // 2916
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
		out:  ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
	}, { // 2917
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
		out:  ".．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
	}, { // 2918
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
		out:  "．．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
	}, { // 2919
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
		out:  ".［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
	}, { // 2920
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
		out:  "．［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
	}, { // 2921
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ．",
		out:  ".［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ‛．",
	}, { // 2922
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ．",
		out:  "．［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ‛．",
	}, { // 2923
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":.\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
		out:  ":.\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
	}, { // 2924
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
		out:  ":．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ[",
	}, { // 2925
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":.\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
		out:  ":.\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
	}, { // 2926
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
		out:  ":．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
	}, { // 2927
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":.\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ．",
		out:  ":.\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ‛．",
	}, { // 2928
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ．",
		out:  ":．\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ‛．",
	}, { // 2929
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］.[",
		out:  ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］.[",
	}, { // 2930
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
		out:  ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．[",
	}, { // 2931
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］.．",
		out:  ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］.‛．",
	}, { // 2932
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．．",
		out:  ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］．‛．",
	}, { // 2933
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ.",
		out:  ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ．",
	}, { // 2934
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ．",
		out:  ":［\x1e44νS\\!y.ｄκ［η\x0e；Ｚ｛ｏ␊α␊ς␇λf］ｙ‛．",
	}, { // 2935
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
		out:  "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
	}, { // 2936
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
		out:  ".．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
	}, { // 2937
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
		out:  "．．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
	}, { // 2938
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
		out:  ".;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
	}, { // 2939
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
		out:  "．;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
	}, { // 2940
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜．",
		out:  ".;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜‛．",
	}, { // 2941
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜．",
		out:  "．;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜‛．",
	}, { // 2942
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（.ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
		out:  "（.ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
	}, { // 2943
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
		out:  "（．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜\x1e",
	}, { // 2944
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（.ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
		out:  "（.ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
	}, { // 2945
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
		out:  "（．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
	}, { // 2946
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（.ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜．",
		out:  "（.ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜‛．",
	}, { // 2947
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜．",
		out:  "（．ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜‛．",
	}, { // 2948
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍.\x1e",
		out:  "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍.\x1e",
	}, { // 2949
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
		out:  "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．\x1e",
	}, { // 2950
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍.．",
		out:  "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍.‛．",
	}, { // 2951
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．．",
		out:  "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍．‛．",
	}, { // 2952
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜.",
		out:  "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜．",
	}, { // 2953
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜．",
		out:  "（;ηＦυ＞ν␘+＄.o\x12ｙ％\x05D？2ψ\x15H［ζι␚\x18␍＜‛．",
	}, { // 2954
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
		out:  "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
	}, { // 2955
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
		out:  ".．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
	}, { // 2956
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
		out:  "．．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
	}, { // 2957
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
		out:  ".$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
	}, { // 2958
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
		out:  "．$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
	}, { // 2959
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c．",
		out:  ".$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c‛．",
	}, { // 2960
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c．",
		out:  "．$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c‛．",
	}, { // 2961
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β.bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
		out:  "β.bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
	}, { // 2962
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
		out:  "β．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1cφ",
	}, { // 2963
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β.bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
		out:  "β.bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
	}, { // 2964
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
		out:  "β．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
	}, { // 2965
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β.bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c．",
		out:  "β.bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c‛．",
	}, { // 2966
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c．",
		out:  "β．bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c‛．",
	}, { // 2967
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε.φ",
		out:  "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε.φ",
	}, { // 2968
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
		out:  "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．φ",
	}, { // 2969
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε.．",
		out:  "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε.‛．",
	}, { // 2970
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．．",
		out:  "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε．‛．",
	}, { // 2971
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c.",
		out:  "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c．",
	}, { // 2972
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c．",
		out:  "β$bUτＤ|／}\x1e.ｐ␅；]χD␖＜4␄\aｍ\x12ｄＬνε\x1c‛．",
	}, { // 2973
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
		out:  "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
	}, { // 2974
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
		out:  ".．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
	}, { // 2975
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
		out:  "．．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
	}, { // 2976
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
		out:  ".#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
	}, { // 2977
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
		out:  "．#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
	}, { // 2978
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ．",
		out:  ".#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ‛．",
	}, { // 2979
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ．",
		out:  "．#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ‛．",
	}, { // 2980
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠.＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
		out:  "＠.＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
	}, { // 2981
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
		out:  "＠．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ␜",
	}, { // 2982
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠.＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
		out:  "＠.＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
	}, { // 2983
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
		out:  "＠．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
	}, { // 2984
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠.＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ．",
		out:  "＠.＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ‛．",
	}, { // 2985
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ．",
		out:  "＠．＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ‛．",
	}, { // 2986
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|.␜",
		out:  "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|.␜",
	}, { // 2987
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
		out:  "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．␜",
	}, { // 2988
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|.．",
		out:  "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|.‛．",
	}, { // 2989
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．．",
		out:  "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|．‛．",
	}, { // 2990
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ.",
		out:  "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ．",
	}, { // 2991
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ．",
		out:  "＠#＂␊\x1cｈθｂGχ.␑Ｖςα␐L\x13ｍ\f1;μ␇2_\x1e|ｋ‛．",
	}, { // 2992
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
		out:  "#\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
	}, { // 2993
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".．α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
		out:  ".．α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
	}, { // 2994
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．．α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
		out:  "．．α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
	}, { // 2995
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
		out:  ".\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
	}, { // 2996
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
		out:  "．\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
	}, { // 2997
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}．",
		out:  ".\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}‛．",
	}, { // 2998
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}．",
		out:  "．\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}‛．",
	}, { // 2999
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#.α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
		out:  "#.α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
	}, { // 3000
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#．α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
		out:  "#．α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}％",
	}, { // 3001
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#.α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
		out:  "#.α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
	}, { // 3002
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#．α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
		out:  "#．α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
	}, { // 3003
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#.α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}．",
		out:  "#.α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}‛．",
	}, { // 3004
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#．α＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}．",
		out:  "#．α＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}‛．",
	}, { // 3005
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18.％",
		out:  "#\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18.％",
	}, { // 3006
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
		out:  "#\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．％",
	}, { // 3007
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18.．",
		out:  "#\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18.‛．",
	}, { // 3008
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．．",
		out:  "#\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18．‛．",
	}, { // 3009
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}.",
		out:  "#\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}．",
	}, { // 3010
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "#\x1cα＇\x13θ！＞ κ.␅［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}．",
		out:  "#\x1cα＇\x13θ！＞ κ.␅‛［uε\x17１，ｗ0＼＇７θJ\x7f}\x18}‛．",
	}, { // 3011
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
		out:  "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
	}, { // 3012
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ".．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
		out:  ".．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
	}, { // 3013
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "．．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
		out:  "．．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
	}, { // 3014
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ".λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
		out:  ".λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
	}, { // 3015
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "．λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
		out:  "．λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
	}, { // 3016
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ".λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ．",
		out:  ".λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ‛．",
	}, { // 3017
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "．λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ．",
		out:  "．λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ‛．",
	}, { // 3018
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆.u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
		out:  "␆.u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
	}, { // 3019
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
		out:  "␆．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲJ",
	}, { // 3020
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆.u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
		out:  "␆.u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
	}, { // 3021
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
		out:  "␆．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
	}, { // 3022
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆.u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ．",
		out:  "␆.u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ‛．",
	}, { // 3023
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ．",
		out:  "␆．u！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ‛．",
	}, { // 3024
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf.J",
		out:  "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf.J",
	}, { // 3025
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
		out:  "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．J",
	}, { // 3026
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf.．",
		out:  "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf.‛．",
	}, { // 3027
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．．",
		out:  "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοf．‛．",
	}, { // 3028
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ.",
		out:  "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ．",
	}, { // 3029
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ．",
		out:  "␆λu！ξＳf\x02:␆.θχＳ＝}＄η␏ｘ[:ｒ[\x1f\nοfＲ‛．",
	}, { // 3030
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨｅ",
		out:  "‛␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨｅ",
	}, { // 3031
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   ".．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨｅ",
		out:  ".．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨｅ",
	}, { // 3032
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "．．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨｅ",
		out:  "．．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨｅ",
	}, { // 3033
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   ".␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ．ｅ",
		out:  ".␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ．ｅ",
	}, { // 3034
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "．␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ．ｅ",
		out:  "．␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ．ｅ",
	}, { // 3035
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   ".␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨ．",
		out:  ".␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨ‛．",
	}, { // 3036
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "．␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨ．",
		out:  "．␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨ‛．",
	}, { // 3037
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀.βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨｅ",
		out:  "‛␀.βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨｅ",
	}, { // 3038
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨｅ",
		out:  "‛␀．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨｅ",
	}, { // 3039
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀.βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ．ｅ",
		out:  "‛␀.βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ．ｅ",
	}, { // 3040
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ．ｅ",
		out:  "‛␀．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ．ｅ",
	}, { // 3041
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀.βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨ．",
		out:  "‛␀.βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨ‛．",
	}, { // 3042
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨ．",
		out:  "‛␀．βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨ‛．",
	}, { // 3043
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ.ｅ",
		out:  "‛␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ.ｅ",
	}, { // 3044
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ．ｅ",
		out:  "‛␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ．ｅ",
	}, { // 3045
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ.．",
		out:  "‛␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ.‛．",
	}, { // 3046
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κ．．",
		out:  "‛␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κ．‛．",
	}, { // 3047
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨ.",
		out:  "‛␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨ．",
	}, { // 3048
		mask: EncodeExclamation | EncodeRightPeriod,
		in:   "␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊␀κＨ．",
		out:  "‛␀␆βο\\%\x180ς:.3οk＆ｐｒDg\x1dＵ␎\tI＇␊‛␀κＨ‛．",
	}, { // 3049
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
		out:  "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
	}, { // 3050
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
		out:  ".．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
	}, { // 3051
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
		out:  "．．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
	}, { // 3052
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
		out:  ".[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
	}, { // 3053
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
		out:  "．[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
	}, { // 3054
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ．",
		out:  ".[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ‛．",
	}, { // 3055
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ．",
		out:  "．[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ‛．",
	}, { // 3056
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖.ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
		out:  "␖.ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
	}, { // 3057
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
		out:  "␖．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σＵ",
	}, { // 3058
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖.ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
		out:  "␖.ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
	}, { // 3059
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
		out:  "␖．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
	}, { // 3060
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖.ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ．",
		out:  "␖.ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ‛．",
	}, { // 3061
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ．",
		out:  "␖．ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ‛．",
	}, { // 3062
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏.Ｕ",
		out:  "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏.Ｕ",
	}, { // 3063
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
		out:  "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．Ｕ",
	}, { // 3064
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏.．",
		out:  "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏.‛．",
	}, { // 3065
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．．",
		out:  "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏．‛．",
	}, { // 3066
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ.",
		out:  "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ．",
	}, { // 3067
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ．",
		out:  "␖[ηυz\v␒/｛␛.βｎ!L␅MK\x17\nNＡRλ５＂δ␏σ‛．",
	}, { // 3068
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
		out:  "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
	}, { // 3069
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
		out:  ".．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
	}, { // 3070
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
		out:  "．．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
	}, { // 3071
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
		out:  ".ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
	}, { // 3072
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
		out:  "．ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
	}, { // 3073
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h．",
		out:  ".ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h‛．",
	}, { // 3074
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h．",
		out:  "．ｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h‛．",
	}, { // 3075
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "β.B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
		out:  "β.B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
	}, { // 3076
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "β．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
		out:  "β．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h\v",
	}, { // 3077
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "β.B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
		out:  "β.B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
	}, { // 3078
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "β．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
		out:  "β．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
	}, { // 3079
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "β.B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h．",
		out:  "β.B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h‛．",
	}, { // 3080
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "β．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h．",
		out:  "β．B＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h‛．",
	}, { // 3081
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃.\v",
		out:  "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃.\v",
	}, { // 3082
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
		out:  "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．\v",
	}, { // 3083
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃.．",
		out:  "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃.‛．",
	}, { // 3084
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．．",
		out:  "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃．‛．",
	}, { // 3085
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h.",
		out:  "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h．",
	}, { // 3086
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h．",
		out:  "βｉB＼␙\x15␙；η].~λｃ>σ␓\x05ωcｙｖθ␌％_k＃h‛．",
	}, { // 3087
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
		out:  "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
	}, { // 3088
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
		out:  ".．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
	}, { // 3089
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
		out:  "．．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
	}, { // 3090
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
		out:  ".\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
	}, { // 3091
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
		out:  "．\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
	}, { // 3092
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'．",
		out:  ".\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'‛．",
	}, { // 3093
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'．",
		out:  "．\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'‛．",
	}, { // 3094
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z.ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
		out:  "z.ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
	}, { // 3095
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
		out:  "z．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'\x12",
	}, { // 3096
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z.ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
		out:  "z.ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
	}, { // 3097
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
		out:  "z．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
	}, { // 3098
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z.ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'．",
		out:  "z.ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'‛．",
	}, { // 3099
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'．",
		out:  "z．ｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'‛．",
	}, { // 3100
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ.\x12",
		out:  "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ.\x12",
	}, { // 3101
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
		out:  "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．\x12",
	}, { // 3102
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ.．",
		out:  "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ.‛．",
	}, { // 3103
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．．",
		out:  "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ．‛．",
	}, { // 3104
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'.",
		out:  "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'．",
	}, { // 3105
		mask: EncodeColon | EncodeRightPeriod,
		in:   "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'．",
		out:  "z\x1aｐ？%［iｕ\vx.␆␍α）␉［^γＣ;κ\x11␜β］ηζ'‛．",
	}, { // 3106
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
		out:  "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
	}, { // 3107
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
		out:  ".．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
	}, { // 3108
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
		out:  "．．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
	}, { // 3109
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
		out:  ".D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
	}, { // 3110
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
		out:  "．D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
	}, { // 3111
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_．",
		out:  ".D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_‛．",
	}, { // 3112
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_．",
		out:  "．D％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_‛．",
	}, { // 3113
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1c.％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
		out:  "\x1c.％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
	}, { // 3114
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1c．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
		out:  "\x1c．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_＜",
	}, { // 3115
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1c.％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
		out:  "\x1c.％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
	}, { // 3116
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1c．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
		out:  "\x1c．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
	}, { // 3117
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1c.％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_．",
		out:  "\x1c.％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_‛．",
	}, { // 3118
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1c．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_．",
		out:  "\x1c．％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_‛．",
	}, { // 3119
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞.＜",
		out:  "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞.＜",
	}, { // 3120
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
		out:  "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．＜",
	}, { // 3121
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞.．",
		out:  "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞.‛．",
	}, { // 3122
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．．",
		out:  "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞．‛．",
	}, { // 3123
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_.",
		out:  "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_．",
	}, { // 3124
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_．",
		out:  "\x1cD％␎|βκθυS.\x1eｍτ␆\x1f\bK\b\f＊Ｐ＠＝␊Ｂη＞_‛．",
	}, { // 3125
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
		out:  "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
	}, { // 3126
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
		out:  ".．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
	}, { // 3127
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
		out:  "．．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
	}, { // 3128
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
		out:  ".＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
	}, { // 3129
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
		out:  "．＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
	}, { // 3130
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ．",
		out:  ".＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ‛．",
	}, { // 3131
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ．",
		out:  "．＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ‛．",
	}, { // 3132
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y.｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
		out:  "y.｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
	}, { // 3133
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
		out:  "y．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳT",
	}, { // 3134
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y.｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
		out:  "y.｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
	}, { // 3135
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
		out:  "y．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
	}, { // 3136
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y.｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ．",
		out:  "y.｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ‛．",
	}, { // 3137
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ．",
		out:  "y．｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ‛．",
	}, { // 3138
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν.T",
		out:  "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν.T",
	}, { // 3139
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
		out:  "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．T",
	}, { // 3140
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν.．",
		out:  "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν.‛．",
	}, { // 3141
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．．",
		out:  "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=ν．‛．",
	}, { // 3142
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ.",
		out:  "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ．",
	}, { // 3143
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ．",
		out:  "y＇｀\x7fθ\x1cｅ␔Ｑ\x13.tb\x02\x19ξ，＋%ξ␍␏;␅ζρ=νＳ‛．",
	}, { // 3144
		mask: EncodePipe | EncodeRightPeriod,
		in:   "xφ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
		out:  "xφ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
	}, { // 3145
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".．：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
		out:  ".．：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
	}, { // 3146
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．．：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
		out:  "．．：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
	}, { // 3147
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".φ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
		out:  ".φ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
	}, { // 3148
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．φ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
		out:  "．φ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
	}, { // 3149
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".φ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ．",
		out:  ".φ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ‛．",
	}, { // 3150
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．φ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ．",
		out:  "．φ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ‛．",
	}, { // 3151
		mask: EncodePipe | EncodeRightPeriod,
		in:   "x.：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
		out:  "x.：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
	}, { // 3152
		mask: EncodePipe | EncodeRightPeriod,
		in:   "x．：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
		out:  "x．：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ;",
	}, { // 3153
		mask: EncodePipe | EncodeRightPeriod,
		in:   "x.：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
		out:  "x.：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
	}, { // 3154
		mask: EncodePipe | EncodeRightPeriod,
		in:   "x．：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
		out:  "x．：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
	}, { // 3155
		mask: EncodePipe | EncodeRightPeriod,
		in:   "x.：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ．",
		out:  "x.：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ‛．",
	}, { // 3156
		mask: EncodePipe | EncodeRightPeriod,
		in:   "x．：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ．",
		out:  "x．：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ‛．",
	}, { // 3157
		mask: EncodePipe | EncodeRightPeriod,
		in:   "xφ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(.;",
		out:  "xφ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(.;",
	}, { // 3158
		mask: EncodePipe | EncodeRightPeriod,
		in:   "xφ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
		out:  "xφ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．;",
	}, { // 3159
		mask: EncodePipe | EncodeRightPeriod,
		in:   "xφ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(.．",
		out:  "xφ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(.‛．",
	}, { // 3160
		mask: EncodePipe | EncodeRightPeriod,
		in:   "xφ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．．",
		out:  "xφ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(．‛．",
	}, { // 3161
		mask: EncodePipe | EncodeRightPeriod,
		in:   "xφ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ.",
		out:  "xφ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ．",
	}, { // 3162
		mask: EncodePipe | EncodeRightPeriod,
		in:   "xφ：［!\x00Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ．",
		out:  "xφ：［!␀Ｊ;λ␉.６ζ7;qＺ＆？ω␔␏\nςｖ\r！(σ‛．",
	}, { // 3163
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
		out:  "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
	}, { // 3164
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
		out:  ".．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
	}, { // 3165
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
		out:  "．．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
	}, { // 3166
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
		out:  ".␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
	}, { // 3167
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
		out:  "．␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
	}, { // 3168
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ．",
		out:  ".␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ‛．",
	}, { // 3169
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ．",
		out:  "．␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ‛．",
	}, { // 3170
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/.｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
		out:  "/.｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
	}, { // 3171
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
		out:  "/．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ５",
	}, { // 3172
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/.｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
		out:  "/.｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
	}, { // 3173
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
		out:  "/．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
	}, { // 3174
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/.｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ．",
		out:  "/.｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ‛．",
	}, { // 3175
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ．",
		out:  "/．｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ‛．",
	}, { // 3176
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ.５",
		out:  "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ.５",
	}, { // 3177
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
		out:  "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．５",
	}, { // 3178
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ.．",
		out:  "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ.‛．",
	}, { // 3179
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．．",
		out:  "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψ．‛．",
	}, { // 3180
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ.",
		out:  "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ．",
	}, { // 3181
		mask: EncodeHash | EncodeRightPeriod,
		in:   "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ．",
		out:  "/␁｝\x13␂）y\x04D＂.U&ｆ\x16␞\nω␔\x05φｓ２ν␋<χψγ‛．",
	}, { // 3182
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
		out:  "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
	}, { // 3183
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
		out:  ".．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
	}, { // 3184
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
		out:  "．．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
	}, { // 3185
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
		out:  ".αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
	}, { // 3186
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
		out:  "．αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
	}, { // 3187
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b．",
		out:  ".αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b‛．",
	}, { // 3188
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b．",
		out:  "．αyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b‛．",
	}, { // 3189
		mask: EncodePercent | EncodeRightPeriod,
		in:   "α.yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
		out:  "α.yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
	}, { // 3190
		mask: EncodePercent | EncodeRightPeriod,
		in:   "α．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
		out:  "α．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b\x1a",
	}, { // 3191
		mask: EncodePercent | EncodeRightPeriod,
		in:   "α.yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
		out:  "α.yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
	}, { // 3192
		mask: EncodePercent | EncodeRightPeriod,
		in:   "α．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
		out:  "α．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
	}, { // 3193
		mask: EncodePercent | EncodeRightPeriod,
		in:   "α.yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b．",
		out:  "α.yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b‛．",
	}, { // 3194
		mask: EncodePercent | EncodeRightPeriod,
		in:   "α．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b．",
		out:  "α．yς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b‛．",
	}, { // 3195
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ.\x1a",
		out:  "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ.\x1a",
	}, { // 3196
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
		out:  "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．\x1a",
	}, { // 3197
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ.．",
		out:  "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ.‛．",
	}, { // 3198
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．．",
		out:  "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ．‛．",
	}, { // 3199
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b.",
		out:  "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b．",
	}, { // 3200
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b．",
		out:  "ααyς␘\x13␟Rι＜.Ｇχｇｉ\r␊κ6\x18Y>RＤ␒ｂ␔Ｃ\x1b‛．",
	}, { // 3201
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
		out:  "␗％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
	}, { // 3202
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".．\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
		out:  ".．␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
	}, { // 3203
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．．\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
		out:  "．．␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
	}, { // 3204
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
		out:  ".％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
	}, { // 3205
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
		out:  "．％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
	}, { // 3206
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀．",
		out:  ".％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀‛．",
	}, { // 3207
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀．",
		out:  "．％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀‛．",
	}, { // 3208
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗.\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
		out:  "␗.␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
	}, { // 3209
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗．\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
		out:  "␗．␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀␃",
	}, { // 3210
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗.\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
		out:  "␗.␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
	}, { // 3211
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗．\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
		out:  "␗．␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
	}, { // 3212
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗.\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀．",
		out:  "␗.␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀‛．",
	}, { // 3213
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗．\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀．",
		out:  "␗．␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀‛．",
	}, { // 3214
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN.␃",
		out:  "␗％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN.␃",
	}, { // 3215
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
		out:  "␗％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．␃",
	}, { // 3216
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN.．",
		out:  "␗％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN.‛．",
	}, { // 3217
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．．",
		out:  "␗％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN．‛．",
	}, { // 3218
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀.",
		out:  "␗％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀．",
	}, { // 3219
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␗％\x00*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀．",
		out:  "␗％␀*η\x0e：ισ*.:P:f[ｋｚＣ％３］<βＧξςN｀‛．",
	}, { // 3220
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ\b",
		out:  "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ\b",
	}, { // 3221
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ\b",
		out:  ".．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ\b",
	}, { // 3222
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ\b",
		out:  "．．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ\b",
	}, { // 3223
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ．\b",
		out:  ".ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ．\b",
	}, { // 3224
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ．\b",
		out:  "．ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ．\b",
	}, { // 3225
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ．",
		out:  ".ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ‛．",
	}, { // 3226
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ．",
		out:  "．ＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ‛．",
	}, { // 3227
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρ.Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ\b",
		out:  "ρ.Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ\b",
	}, { // 3228
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρ．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ\b",
		out:  "ρ．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ\b",
	}, { // 3229
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρ.Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ．\b",
		out:  "ρ.Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ．\b",
	}, { // 3230
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρ．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ．\b",
		out:  "ρ．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ．\b",
	}, { // 3231
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρ.Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ．",
		out:  "ρ.Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ‛．",
	}, { // 3232
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρ．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ．",
		out:  "ρ．Ｒ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ‛．",
	}, { // 3233
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ.\b",
		out:  "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ.\b",
	}, { // 3234
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ．\b",
		out:  "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ．\b",
	}, { // 3235
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ.．",
		out:  "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ.‛．",
	}, { // 3236
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄ．．",
		out:  "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄ．‛．",
	}, { // 3237
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ.",
		out:  "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ．",
	}, { // 3238
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜␀λ$ιG\n$\rｄｓ．",
		out:  "ρＭＲ␑DπwＳ＄\x03.B␝␁$␇λβ␜‛␀λ$ιG␊$␍ｄｓ‛．",
	}, { // 3239
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
		out:  "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
	}, { // 3240
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
		out:  ".．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
	}, { // 3241
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
		out:  "．．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
	}, { // 3242
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
		out:  ".y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
	}, { // 3243
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
		out:  "．y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
	}, { // 3244
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼．",
		out:  ".y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼‛．",
	}, { // 3245
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼．",
		out:  "．y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼‛．",
	}, { // 3246
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［.`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
		out:  "［.`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
	}, { // 3247
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
		out:  "［．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼τ",
	}, { // 3248
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［.`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
		out:  "［.`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
	}, { // 3249
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
		out:  "［．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
	}, { // 3250
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［.`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼．",
		out:  "［.`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼‛．",
	}, { // 3251
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼．",
		out:  "［．`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼‛．",
	}, { // 3252
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５.τ",
		out:  "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５.τ",
	}, { // 3253
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
		out:  "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．τ",
	}, { // 3254
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５.．",
		out:  "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５.‛．",
	}, { // 3255
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．．",
		out:  "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５．‛．",
	}, { // 3256
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼.",
		out:  "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼．",
	}, { // 3257
		mask: EncodeDel | EncodeRightPeriod,
		in:   "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼．",
		out:  "［y`ο␛υ^\n\x1d：.！υ＜\x16＝\nμ\x02βＩｊ!］＇~;５＼‛．",
	}, { // 3258
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ\x16",
		out:  "␑‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ␖",
	}, { // 3259
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".．＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ\x16",
		out:  ".．＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ␖",
	}, { // 3260
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．．＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ\x16",
		out:  "．．＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ␖",
	}, { // 3261
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f．\x16",
		out:  ".‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏．␖",
	}, { // 3262
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f．\x16",
		out:  "．‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏．␖",
	}, { // 3263
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ．",
		out:  ".‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ‛．",
	}, { // 3264
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ．",
		out:  "．‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ‛．",
	}, { // 3265
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11.＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ\x16",
		out:  "␑.＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ␖",
	}, { // 3266
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11．＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ\x16",
		out:  "␑．＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ␖",
	}, { // 3267
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11.＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f．\x16",
		out:  "␑.＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏．␖",
	}, { // 3268
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11．＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f．\x16",
		out:  "␑．＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏．␖",
	}, { // 3269
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11.＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ．",
		out:  "␑.＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ‛．",
	}, { // 3270
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11．＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ．",
		out:  "␑．＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ‛．",
	}, { // 3271
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f.\x16",
		out:  "␑‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏.␖",
	}, { // 3272
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f．\x16",
		out:  "␑‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏．␖",
	}, { // 3273
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f.．",
		out:  "␑‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏.‛．",
	}, { // 3274
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0f．．",
		out:  "␑‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏．‛．",
	}, { // 3275
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ.",
		out:  "␑‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ．",
	}, { // 3276
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "\x11␌＞β␔#'ｗσ０.a@jａφ␔τvFＭκ␡ τ；ｌ\x0fｍ．",
		out:  "␑‛␌＞β‛␔#'ｗσ０.a@jａφ‛␔τvFＭκ␡ τ；ｌ␏ｍ‛．",
	}, { // 3277
		mask: EncodeRightCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 3278
		mask: EncodeRightCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 3279
		mask: EncodeRightCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 3280
		mask: EncodeRightCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 3281
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
		out:  "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
	}, { // 3282
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
		out:  "\t␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
	}, { // 3283
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
		out:  "␉␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
	}, { // 3284
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
		out:  "\t␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
	}, { // 3285
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
		out:  "␉␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
	}, { // 3286
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ␉",
		out:  "\t␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ‛␉",
	}, { // 3287
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ␉",
		out:  "␉␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ‛␉",
	}, { // 3288
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘\tημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
		out:  "␘\tημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
	}, { // 3289
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
		out:  "␘␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ；",
	}, { // 3290
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘\tημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
		out:  "␘\tημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
	}, { // 3291
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
		out:  "␘␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
	}, { // 3292
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘\tημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ␉",
		out:  "␘\tημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ‛␉",
	}, { // 3293
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ␉",
		out:  "␘␉ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ‛␉",
	}, { // 3294
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU\t；",
		out:  "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU\t；",
	}, { // 3295
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
		out:  "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉；",
	}, { // 3296
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU\t␉",
		out:  "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU\t‛␉",
	}, { // 3297
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉␉",
		out:  "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbU␉‛␉",
	}, { // 3298
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ\t",
		out:  "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ␉",
	}, { // 3299
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ␉",
		out:  "␘␡ημ␈\x03gｄ?χ\t#␛\n：＼Ｍπψ/\n<：I>ＢbUυ‛␉",
	}, { // 3300
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
		out:  "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
	}, { // 3301
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
		out:  "\n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
	}, { // 3302
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
		out:  "␊␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
	}, { // 3303
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
		out:  "\n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
	}, { // 3304
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
		out:  "␊\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
	}, { // 3305
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）␊",
		out:  "\n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）‛␊",
	}, { // 3306
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）␊",
		out:  "␊\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）‛␊",
	}, { // 3307
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\n%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
		out:  "n\n%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
	}, { // 3308
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
		out:  "n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）9",
	}, { // 3309
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\n%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
		out:  "n\n%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
	}, { // 3310
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
		out:  "n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
	}, { // 3311
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\n%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）␊",
		out:  "n\n%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）‛␊",
	}, { // 3312
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）␊",
		out:  "n␊%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）‛␊",
	}, { // 3313
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅\n9",
		out:  "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅\n9",
	}, { // 3314
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
		out:  "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊9",
	}, { // 3315
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅\n␊",
		out:  "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅\n‛␊",
	}, { // 3316
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊␊",
		out:  "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅␊‛␊",
	}, { // 3317
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）\n",
		out:  "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）␊",
	}, { // 3318
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）␊",
		out:  "n\x0f%πη？\x1b＇␈τ\n\"uτｋ（␡\x17οh\x04\x1df␞θ：９␅）‛␊",
	}, { // 3319
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！Ｓ",
		out:  "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！Ｓ",
	}, { // 3320
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！Ｓ",
		out:  "\v␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！Ｓ",
	}, { // 3321
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！Ｓ",
		out:  "␋␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！Ｓ",
	}, { // 3322
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\vＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*␋Ｓ",
		out:  "\vＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*␋Ｓ",
	}, { // 3323
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋Ｒ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*␋Ｓ",
		out:  "␋Ｒ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*␋Ｓ",
	}, { // 3324
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\vＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！␋",
		out:  "\vＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！‛␋",
	}, { // 3325
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋Ｒ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！␋",
		out:  "␋Ｒ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！‛␋",
	}, { // 3326
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "r\v＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！Ｓ",
		out:  "r\v＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！Ｓ",
	}, { // 3327
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "r␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！Ｓ",
		out:  "r␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！Ｓ",
	}, { // 3328
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "r\v＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*␋Ｓ",
		out:  "r\v＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*␋Ｓ",
	}, { // 3329
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "r␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*␋Ｓ",
		out:  "r␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*␋Ｓ",
	}, { // 3330
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "r\v＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！␋",
		out:  "r\v＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！‛␋",
	}, { // 3331
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "r␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！␋",
		out:  "r␋＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！‛␋",
	}, { // 3332
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*\vＳ",
		out:  "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*\vＳ",
	}, { // 3333
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*␋Ｓ",
		out:  "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*␋Ｓ",
	}, { // 3334
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*\v␋",
		out:  "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*\v‛␋",
	}, { // 3335
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*␋␋",
		out:  "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*␋‛␋",
	}, { // 3336
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！\v",
		out:  "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！␋",
	}, { // 3337
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o␀3＂π']]*！␋",
		out:  "rＲ＇5]wλ\r;ｌ\v＼？ｄθ３δκ␍o‛␀3＂π']]*！‛␋",
	}, { // 3338
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
		out:  "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
	}, { // 3339
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
		out:  "\r␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
	}, { // 3340
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
		out:  "␍␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
	}, { // 3341
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\rｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
		out:  "\rｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
	}, { // 3342
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍ｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
		out:  "␍ｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
	}, { // 3343
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\rｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃␍",
		out:  "\rｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃‛␍",
	}, { // 3344
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍ｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃␍",
		out:  "␍ｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃‛␍",
	}, { // 3345
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n\r0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
		out:  "\n\r0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
	}, { // 3346
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
		out:  "\n␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃5",
	}, { // 3347
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n\r0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
		out:  "\n\r0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
	}, { // 3348
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
		out:  "\n␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
	}, { // 3349
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n\r0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃␍",
		out:  "\n\r0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃‛␍",
	}, { // 3350
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃␍",
		out:  "\n␍0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃‛␍",
	}, { // 3351
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19\r5",
		out:  "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19\r5",
	}, { // 3352
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
		out:  "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍5",
	}, { // 3353
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19\r␍",
		out:  "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19\r‛␍",
	}, { // 3354
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍␍",
		out:  "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␍‛␍",
	}, { // 3355
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃\r",
		out:  "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃␍",
	}, { // 3356
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃␍",
		out:  "\nｙ0@Ｏ\x1aF:␞␉\r;κξξｉ%\"Ｂυσ７Ｐ␓␔3ζ\x19␃‛␍",
	}, { // 3357
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c\v",
		out:  "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c␋",
	}, { // 3358
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c\v",
		out:  "\t␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c␋",
	}, { // 3359
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c\v",
		out:  "␉␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c␋",
	}, { // 3360
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go␉\v",
		out:  "\t␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go␉␋",
	}, { // 3361
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go␉\v",
		out:  "␉␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go␉␋",
	}, { // 3362
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c␉",
		out:  "\t␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c‛␉",
	}, { // 3363
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c␉",
		out:  "␉␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c‛␉",
	}, { // 3364
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H\tχＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c\v",
		out:  "H\tχＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c␋",
	}, { // 3365
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c\v",
		out:  "H␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c␋",
	}, { // 3366
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H\tχＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go␉\v",
		out:  "H\tχＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go␉␋",
	}, { // 3367
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go␉\v",
		out:  "H␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go␉␋",
	}, { // 3368
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H\tχＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c␉",
		out:  "H\tχＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c‛␉",
	}, { // 3369
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c␉",
		out:  "H␉χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c‛␉",
	}, { // 3370
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\t\v",
		out:  "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\t␋",
	}, { // 3371
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go␉\v",
		out:  "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go␉␋",
	}, { // 3372
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\t␉",
		out:  "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\t‛␉",
	}, { // 3373
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go␉␉",
		out:  "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go␉‛␉",
	}, { // 3374
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c\t",
		out:  "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c␉",
	}, { // 3375
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ／|υ．␅go\x1c␉",
		out:  "H␅χＵQ␋Ａ␔ωχ\t\nοε\x0eＫｍ\x02␁|Ａ‛／|υ．␅go\x1c‛␉",
	}, { // 3376
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
		out:  "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
	}, { // 3377
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
		out:  "\n␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
	}, { // 3378
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
		out:  "␊␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
	}, { // 3379
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
		out:  "\n>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
	}, { // 3380
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
		out:  "␊>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
	}, { // 3381
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ␊",
		out:  "\n>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ‛␊",
	}, { // 3382
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ␊",
		out:  "␊>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ‛␊",
	}, { // 3383
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ\n␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
		out:  "φ\n␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
	}, { // 3384
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
		out:  "φ␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ＇",
	}, { // 3385
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ\n␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
		out:  "φ\n␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
	}, { // 3386
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
		out:  "φ␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
	}, { // 3387
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ\n␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ␊",
		out:  "φ\n␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ‛␊",
	}, { // 3388
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ␊",
		out:  "φ␊␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ‛␊",
	}, { // 3389
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR\n＇",
		out:  "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR\n＇",
	}, { // 3390
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
		out:  "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊＇",
	}, { // 3391
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR\n␊",
		out:  "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR\n‛␊",
	}, { // 3392
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊␊",
		out:  "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fR␊‛␊",
	}, { // 3393
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ\n",
		out:  "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ␊",
	}, { // 3394
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ␊",
		out:  "φ>␕7αA\"；πζ\n%␚\fＰfＣ｀ε\x05＼＜␅Ｋ␔\n\fRξ‛␊",
	}, { // 3395
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
		out:  "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
	}, { // 3396
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
		out:  "\v␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
	}, { // 3397
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
		out:  "␋␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
	}, { // 3398
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
		out:  "\v\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
	}, { // 3399
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
		out:  "␋\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
	}, { // 3400
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：␋",
		out:  "\v\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：‛␋",
	}, { // 3401
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：␋",
		out:  "␋\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：‛␋",
	}, { // 3402
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\v\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
		out:  "G\v\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
	}, { // 3403
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
		out:  "G␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：Ｓ",
	}, { // 3404
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\v\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
		out:  "G\v\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
	}, { // 3405
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
		out:  "G␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
	}, { // 3406
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\v\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：␋",
		out:  "G\v\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：‛␋",
	}, { // 3407
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：␋",
		out:  "G␋\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：‛␋",
	}, { // 3408
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%\vＳ",
		out:  "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%\vＳ",
	}, { // 3409
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
		out:  "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋Ｓ",
	}, { // 3410
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%\v␋",
		out:  "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%\v‛␋",
	}, { // 3411
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋␋",
		out:  "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%␋‛␋",
	}, { // 3412
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：\v",
		out:  "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：␋",
	}, { // 3413
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：␋",
		out:  "G\t\nＱso␍：＜＼\vγιλ;ω_πθ％Ｘ\n＼\x13m\f␘%：‛␋",
	}, { // 3414
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
		out:  "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
	}, { // 3415
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\r␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
		out:  "\r␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
	}, { // 3416
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
		out:  "␍␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
	}, { // 3417
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\r｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
		out:  "\r｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
	}, { // 3418
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
		out:  "␍｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
	}, { // 3419
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\r｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v␍",
		out:  "\r｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v‛␍",
	}, { // 3420
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v␍",
		out:  "␍｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v‛␍",
	}, { // 3421
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ\r\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
		out:  "Ｖ\r\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
	}, { // 3422
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
		out:  "Ｖ␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v＊",
	}, { // 3423
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ\r\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
		out:  "Ｖ\r\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
	}, { // 3424
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
		out:  "Ｖ␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
	}, { // 3425
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ\r\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v␍",
		out:  "Ｖ\r\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v‛␍",
	}, { // 3426
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v␍",
		out:  "Ｖ␍\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v‛␍",
	}, { // 3427
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\r＊",
		out:  "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\r＊",
	}, { // 3428
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
		out:  "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍＊",
	}, { // 3429
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\r␍",
		out:  "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\r‛␍",
	}, { // 3430
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍␍",
		out:  "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ␍‛␍",
	}, { // 3431
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v\r",
		out:  "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v␍",
	}, { // 3432
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v␍",
		out:  "Ｖ｀\aQ:｀\x1eσ␛％\r␐\x16δ8'０N␍α＠:ηβ9␙␓λ\v‛␍",
	}, { // 3433
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
		out:  "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
	}, { // 3434
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
		out:  "\t␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
	}, { // 3435
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
		out:  "␉␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
	}, { // 3436
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
		out:  "\t＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
	}, { // 3437
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
		out:  "␉＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
	}, { // 3438
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`␉",
		out:  "\t＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`‛␉",
	}, { // 3439
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`␉",
		out:  "␉＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`‛␉",
	}, { // 3440
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜\t␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
		out:  "｜\t␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
	}, { // 3441
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
		out:  "｜␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`>",
	}, { // 3442
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜\t␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
		out:  "｜\t␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
	}, { // 3443
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
		out:  "｜␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
	}, { // 3444
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜\t␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`␉",
		out:  "｜\t␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`‛␉",
	}, { // 3445
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`␉",
		out:  "｜␉␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`‛␉",
	}, { // 3446
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02\t>",
		out:  "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02\t>",
	}, { // 3447
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
		out:  "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉>",
	}, { // 3448
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02\t␉",
		out:  "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02\t‛␉",
	}, { // 3449
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉␉",
		out:  "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02␉‛␉",
	}, { // 3450
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`\t",
		out:  "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`␉",
	}, { // 3451
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`␉",
		out:  "｜＆␃␄；\x02＞ζfχ\t，<υτc`τ␞2[６＃％n\rθ\x02`‛␉",
	}, { // 3452
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
		out:  "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
	}, { // 3453
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
		out:  "\n␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
	}, { // 3454
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
		out:  "␊␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
	}, { // 3455
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
		out:  "\n>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
	}, { // 3456
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
		out:  "␊>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
	}, { // 3457
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ␊",
		out:  "\n>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ‛␊",
	}, { // 3458
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ␊",
		out:  "␊>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ‛␊",
	}, { // 3459
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎\n\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
		out:  "␎\n\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
	}, { // 3460
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
		out:  "␎␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκV",
	}, { // 3461
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎\n\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
		out:  "␎\n\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
	}, { // 3462
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
		out:  "␎␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
	}, { // 3463
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎\n\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ␊",
		out:  "␎\n\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ‛␊",
	}, { // 3464
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ␊",
		out:  "␎␊\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ‛␊",
	}, { // 3465
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB\nV",
		out:  "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB\nV",
	}, { // 3466
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
		out:  "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊V",
	}, { // 3467
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB\n␊",
		out:  "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB\n‛␊",
	}, { // 3468
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊␊",
		out:  "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎB␊‛␊",
	}, { // 3469
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ\n",
		out:  "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ␊",
	}, { // 3470
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ␊",
		out:  "␎>\\ｊ:：δｖχh\n＃(ψＬ\f\x01／\x1b␛｜N！νν５ｎBκ‛␊",
	}, { // 3471
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16μ",
		out:  "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16μ",
	}, { // 3472
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16μ",
		out:  "\v␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16μ",
	}, { // 3473
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16μ",
		out:  "␋␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16μ",
	}, { // 3474
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\vＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00␋μ",
		out:  "\vＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀␋μ",
	}, { // 3475
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋Ｅ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00␋μ",
		out:  "␋Ｅ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀␋μ",
	}, { // 3476
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\vＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16␋",
		out:  "\vＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16‛␋",
	}, { // 3477
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋Ｅ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16␋",
		out:  "␋Ｅ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16‛␋",
	}, { // 3478
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "Ｄ\v\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16μ",
		out:  "Ｄ\v\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16μ",
	}, { // 3479
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "Ｄ␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16μ",
		out:  "Ｄ␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16μ",
	}, { // 3480
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "Ｄ\v\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00␋μ",
		out:  "Ｄ\v\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀␋μ",
	}, { // 3481
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "Ｄ␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00␋μ",
		out:  "Ｄ␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀␋μ",
	}, { // 3482
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "Ｄ\v\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16␋",
		out:  "Ｄ\v\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16‛␋",
	}, { // 3483
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "Ｄ␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16␋",
		out:  "Ｄ␋\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16‛␋",
	}, { // 3484
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\vμ",
		out:  "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\vμ",
	}, { // 3485
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00␋μ",
		out:  "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀␋μ",
	}, { // 3486
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\v␋",
		out:  "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\v‛␋",
	}, { // 3487
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00␋␋",
		out:  "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀␋‛␋",
	}, { // 3488
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16\v",
		out:  "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16␋",
	}, { // 3489
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜\x00\x16␋",
		out:  "ＤＥ\x13<ＵV␊θωＹ\v)ω|｜\x15φ␟ｍAN␔ξ\rR｜＜␀\x16‛␋",
	}, { // 3490
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
		out:  "L␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
	}, { // 3491
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
		out:  "\r␍fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
	}, { // 3492
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
		out:  "␍␍fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
	}, { // 3493
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\r␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
		out:  "\r␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
	}, { // 3494
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
		out:  "␍␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
	}, { // 3495
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\r␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ␍",
		out:  "\r␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ‛␍",
	}, { // 3496
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ␍",
		out:  "␍␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ‛␍",
	}, { // 3497
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L\rfσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
		out:  "L\rfσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
	}, { // 3498
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␍fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
		out:  "L␍fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δＫ",
	}, { // 3499
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L\rfσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
		out:  "L\rfσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
	}, { // 3500
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␍fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
		out:  "L␍fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
	}, { // 3501
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L\rfσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ␍",
		out:  "L\rfσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ‛␍",
	}, { // 3502
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␍fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ␍",
		out:  "L␍fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ‛␍",
	}, { // 3503
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_\rＫ",
		out:  "L␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_\rＫ",
	}, { // 3504
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
		out:  "L␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍Ｋ",
	}, { // 3505
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_\r␍",
		out:  "L␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_\r‛␍",
	}, { // 3506
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍␍",
		out:  "L␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_␍‛␍",
	}, { // 3507
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ\r",
		out:  "L␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ␍",
	}, { // 3508
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "L␐fσ\rw␛␛＇\x01\r␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ␍",
		out:  "L␐fσ\rw␛␛‛＇\x01\r‛␀ν；ｔ\x10πσ\x0e|｀Ｏm:>ｘυ_δ‛␍",
	}, { // 3509
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
		out:  "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
	}, { // 3510
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
		out:  "\t␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
	}, { // 3511
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
		out:  "␉␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
	}, { // 3512
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\tβ［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
		out:  "\tβ［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
	}, { // 3513
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
		out:  "␉β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
	}, { // 3514
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\tβ［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆␉",
		out:  "\tβ［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆‛␉",
	}, { // 3515
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆␉",
		out:  "␉β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆‛␉",
	}, { // 3516
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇\t［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
		out:  "＇\t［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
	}, { // 3517
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
		out:  "＇␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆＃",
	}, { // 3518
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇\t［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
		out:  "＇\t［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
	}, { // 3519
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
		out:  "＇␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
	}, { // 3520
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇\t［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆␉",
		out:  "＇\t［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆‛␉",
	}, { // 3521
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆␉",
		out:  "＇␉［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆‛␉",
	}, { // 3522
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς\t＃",
		out:  "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς\t＃",
	}, { // 3523
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
		out:  "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉＃",
	}, { // 3524
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς\t␉",
		out:  "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς\t‛␉",
	}, { // 3525
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉␉",
		out:  "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␉‛␉",
	}, { // 3526
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆\t",
		out:  "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆␉",
	}, { // 3527
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆␉",
		out:  "＇β［／\x15␗＝␇\x11&\t＇ςＡβG+\x04␃\x12␝\x03\rwO$τς␆‛␉",
	}, { // 3528
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
		out:  "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
	}, { // 3529
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
		out:  "\n␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
	}, { // 3530
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
		out:  "␊␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
	}, { // 3531
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
		out:  "\n\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
	}, { // 3532
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
		out:  "␊\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
	}, { // 3533
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃␊",
		out:  "\n\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃‛␊",
	}, { // 3534
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃␊",
		out:  "␊\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃‛␊",
	}, { // 3535
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\nｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
		out:  "τ\nｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
	}, { // 3536
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
		out:  "τ␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃Z",
	}, { // 3537
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\nｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
		out:  "τ\nｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
	}, { // 3538
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
		out:  "τ␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
	}, { // 3539
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\nｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃␊",
		out:  "τ\nｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃‛␊",
	}, { // 3540
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃␊",
		out:  "τ␊ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃‛␊",
	}, { // 3541
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v\nZ",
		out:  "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v\nZ",
	}, { // 3542
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
		out:  "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊Z",
	}, { // 3543
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v\n␊",
		out:  "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v\n‛␊",
	}, { // 3544
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊␊",
		out:  "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␊‛␊",
	}, { // 3545
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃\n",
		out:  "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃␊",
	}, { // 3546
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃␊",
		out:  "τ\x04ｇ␕τ\thεPz\n\x14>３πω／␔\x05Ｄ＊␂*!␇ｋｅ\v␃‛␊",
	}, { // 3547
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␐",
		out:  "ε<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌␐",
	}, { // 3548
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v␋δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␐",
		out:  "\v␋δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌␐",
	}, { // 3549
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋␋δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␐",
		out:  "␋␋δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌␐",
	}, { // 3550
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␋␐",
		out:  "\v<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␋␐",
	}, { // 3551
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␋␐",
		out:  "␋<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␋␐",
	}, { // 3552
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␋",
		out:  "\v<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌‛␋",
	}, { // 3553
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␋",
		out:  "␋<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌‛␋",
	}, { // 3554
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε\vδ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␐",
		out:  "ε\vδ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌␐",
	}, { // 3555
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε␋δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␐",
		out:  "ε␋δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌␐",
	}, { // 3556
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε\vδ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␋␐",
		out:  "ε\vδ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␋␐",
	}, { // 3557
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε␋δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␋␐",
		out:  "ε␋δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␋␐",
	}, { // 3558
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε\vδ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␋",
		out:  "ε\vδ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌‛␋",
	}, { // 3559
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε␋δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␋",
		out:  "ε␋δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌‛␋",
	}, { // 3560
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#\v␐",
		out:  "ε<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#\v␐",
	}, { // 3561
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␋␐",
		out:  "ε<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␋␐",
	}, { // 3562
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#\v␋",
		out:  "ε<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#\v‛␋",
	}, { // 3563
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␋␋",
		out:  "ε<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␋‛␋",
	}, { // 3564
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌\v",
		out:  "ε<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌␋",
	}, { // 3565
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ε<δ␕｜\x01ωπNＫ\v５f～\x00？␎X0Ｋ\x7fCσ\x00＂；+#␌␋",
		out:  "ε<δ␕｜\x01ωπNＫ\v５f～␀？␎X0Ｋ\x7fCσ␀＂；+#␌‛␋",
	}, { // 3566
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ９",
		out:  "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ９",
	}, { // 3567
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\r␍κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ９",
		out:  "\r␍κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ９",
	}, { // 3568
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍␍κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ９",
		out:  "␍␍κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ９",
	}, { // 3569
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\r|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<␍９",
		out:  "\r|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<␍９",
	}, { // 3570
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<␍９",
		out:  "␍|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<␍９",
	}, { // 3571
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\r|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ␍",
		out:  "\r|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ‛␍",
	}, { // 3572
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ␍",
		out:  "␍|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ‛␍",
	}, { // 3573
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ\rκ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ９",
		out:  "Ｇ\rκ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ９",
	}, { // 3574
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ␍κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ９",
		out:  "Ｇ␍κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ９",
	}, { // 3575
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ\rκ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<␍９",
		out:  "Ｇ\rκ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<␍９",
	}, { // 3576
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ␍κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<␍９",
		out:  "Ｇ␍κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<␍９",
	}, { // 3577
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ\rκ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ␍",
		out:  "Ｇ\rκ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ‛␍",
	}, { // 3578
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ␍κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ␍",
		out:  "Ｇ␍κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ‛␍",
	}, { // 3579
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<\r９",
		out:  "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<\r９",
	}, { // 3580
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<␍９",
		out:  "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<␍９",
	}, { // 3581
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<\r␍",
		out:  "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<\r‛␍",
	}, { // 3582
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<␍␍",
		out:  "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<␍‛␍",
	}, { // 3583
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ\r",
		out:  "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ␍",
	}, { // 3584
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[`ξ\x11＜\n＼］ονＴ<Ｍ␍",
		out:  "Ｇ|κ␐uGZυ␙␝\r＄-j\x1b␗[｀ξ\x11＜\n＼］ονＴ<Ｍ‛␍",
	}, { // 3585
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04Q",
		out:  "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04Q",
	}, { // 3586
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04Q",
		out:  "\t␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04Q",
	}, { // 3587
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04Q",
		out:  "␉␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04Q",
	}, { // 3588
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛␉Q",
		out:  "\t ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛␉Q",
	}, { // 3589
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉ ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛␉Q",
		out:  "␉ ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛␉Q",
	}, { // 3590
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04␉",
		out:  "\t ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04‛␉",
	}, { // 3591
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉ ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04␉",
		out:  "␉ ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04‛␉",
	}, { // 3592
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16\t␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04Q",
		out:  "\x16\t␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04Q",
	}, { // 3593
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04Q",
		out:  "\x16␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04Q",
	}, { // 3594
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16\t␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛␉Q",
		out:  "\x16\t␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛␉Q",
	}, { // 3595
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛␉Q",
		out:  "\x16␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛␉Q",
	}, { // 3596
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16\t␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04␉",
		out:  "\x16\t␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04‛␉",
	}, { // 3597
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04␉",
		out:  "\x16␉␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04‛␉",
	}, { // 3598
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\tQ",
		out:  "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\tQ",
	}, { // 3599
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛␉Q",
		out:  "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛␉Q",
	}, { // 3600
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\t␉",
		out:  "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\t‛␉",
	}, { // 3601
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛␉␉",
		out:  "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛␉‛␉",
	}, { // 3602
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04\t",
		out:  "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04␉",
	}, { // 3603
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ＞\x1eκ\x1f:%｛\x04␉",
		out:  "\x16 ␟ζ8ｋｓζ［？\t\x1c＄Ｘ：␅0ω＂$φ‛＞\x1eκ\x1f:%｛\x04‛␉",
	}, { // 3604
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
		out:  "␌６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
	}, { // 3605
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n␊τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
		out:  "\n␊τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
	}, { // 3606
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊␊τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
		out:  "␊␊τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
	}, { // 3607
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
		out:  "\n６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
	}, { // 3608
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
		out:  "␊６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
	}, { // 3609
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]␊",
		out:  "\n６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]‛␊",
	}, { // 3610
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]␊",
		out:  "␊６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]‛␊",
	}, { // 3611
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌\nτH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
		out:  "␌\nτH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
	}, { // 3612
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌␊τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
		out:  "␌␊τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]８",
	}, { // 3613
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌\nτH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
		out:  "␌\nτH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
	}, { // 3614
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌␊τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
		out:  "␌␊τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
	}, { // 3615
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌\nτH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]␊",
		out:  "␌\nτH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]‛␊",
	}, { // 3616
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌␊τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]␊",
		out:  "␌␊τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]‛␊",
	}, { // 3617
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ\n８",
		out:  "␌６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ\n８",
	}, { // 3618
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
		out:  "␌６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊８",
	}, { // 3619
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ\n␊",
		out:  "␌６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ\n‛␊",
	}, { // 3620
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊␊",
		out:  "␌６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ␊‛␊",
	}, { // 3621
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]\n",
		out:  "␌６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]␊",
	}, { // 3622
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␌６τH<␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]␊",
		out:  "␌６τH＜␘ＤＩεj\n)υaμ␆／␡ξ\x11\x1c␖␖9κ\rEＱ]‛␊",
	}, { // 3623
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
		out:  "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
	}, { // 3624
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
		out:  "\v␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
	}, { // 3625
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
		out:  "␋␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
	}, { // 3626
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
		out:  "\v/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
	}, { // 3627
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
		out:  "␋/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
	}, { // 3628
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８␋",
		out:  "\v/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８‛␋",
	}, { // 3629
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８␋",
		out:  "␋/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８‛␋",
	}, { // 3630
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠\vｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
		out:  "＠\vｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
	}, { // 3631
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
		out:  "＠␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８／",
	}, { // 3632
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠\vｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
		out:  "＠\vｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
	}, { // 3633
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
		out:  "＠␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
	}, { // 3634
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠\vｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８␋",
		out:  "＠\vｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８‛␋",
	}, { // 3635
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８␋",
		out:  "＠␋ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８‛␋",
	}, { // 3636
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:\v／",
		out:  "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:\v／",
	}, { // 3637
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
		out:  "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋／",
	}, { // 3638
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:\v␋",
		out:  "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:\v‛␋",
	}, { // 3639
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋␋",
		out:  "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:␋‛␋",
	}, { // 3640
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８\v",
		out:  "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８␋",
	}, { // 3641
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８␋",
		out:  "＠/ｆ)ζｒ＾E␓＇\v␒σ\x1d␏'w\x0e[εα/eKεＪ␟:８‛␋",
	}, { // 3642
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
		out:  "-＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
	}, { // 3643
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r␍Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
		out:  "\r␍Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
	}, { // 3644
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍␍Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
		out:  "␍␍Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
	}, { // 3645
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
		out:  "\r＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
	}, { // 3646
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
		out:  "␍＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
	}, { // 3647
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR␍",
		out:  "\r＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR‛␍",
	}, { // 3648
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR␍",
		out:  "␍＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR‛␍",
	}, { // 3649
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-\rＲ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
		out:  "-\rＲ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
	}, { // 3650
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-␍Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
		out:  "-␍Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR;",
	}, { // 3651
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-\rＲ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
		out:  "-\rＲ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
	}, { // 3652
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-␍Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
		out:  "-␍Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
	}, { // 3653
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-\rＲ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR␍",
		out:  "-\rＲ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR‛␍",
	}, { // 3654
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-␍Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR␍",
		out:  "-␍Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR‛␍",
	}, { // 3655
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f\r;",
		out:  "-＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f\r;",
	}, { // 3656
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
		out:  "-＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f␍;",
	}, { // 3657
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f\r␍",
		out:  "-＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f\r‛␍",
	}, { // 3658
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1f␍␍",
		out:  "-＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1f␍‛␍",
	}, { // 3659
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR\r",
		out:  "-＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR␍",
	}, { // 3660
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "-＃Ｒ^)＜:［＜＇\rιηＮ\x00\nτ｜＼＂Cｐeυκ\x04ς\x1fR␍",
		out:  "-＃Ｒ^)‛＜:［‛＜＇\rιηＮ␀\nτ｜＼＂Cｐeυκ\x04ς\x1fR‛␍",
	}, { // 3661
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆\x01",
		out:  "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆\x01",
	}, { // 3662
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆\x01",
		out:  "\t␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆\x01",
	}, { // 3663
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆\x01",
		out:  "␉␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆\x01",
	}, { // 3664
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`␉\x01",
		out:  "\t：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`␉\x01",
	}, { // 3665
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`␉\x01",
		out:  "␉：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`␉\x01",
	}, { // 3666
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆␉",
		out:  "\t：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆‛␉",
	}, { // 3667
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆␉",
		out:  "␉：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆‛␉",
	}, { // 3668
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j\t：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆\x01",
		out:  "j\t：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆\x01",
	}, { // 3669
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆\x01",
		out:  "j␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆\x01",
	}, { // 3670
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j\t：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`␉\x01",
		out:  "j\t：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`␉\x01",
	}, { // 3671
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`␉\x01",
		out:  "j␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`␉\x01",
	}, { // 3672
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j\t：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆␉",
		out:  "j\t：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆‛␉",
	}, { // 3673
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆␉",
		out:  "j␉：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆‛␉",
	}, { // 3674
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`\t\x01",
		out:  "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`\t\x01",
	}, { // 3675
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`␉\x01",
		out:  "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`␉\x01",
	}, { // 3676
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`\t␉",
		out:  "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`\t‛␉",
	}, { // 3677
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`␉␉",
		out:  "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`␉‛␉",
	}, { // 3678
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆\t",
		out:  "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆␉",
	}, { // 3679
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ␀\x0e！ＴhX\x03Z＜`＆␉",
		out:  "j：：Wχ;χ４\x047\tιｃ␞ψ␃Ａβ‛␀\x0e！ＴhX\x03Z＜`＆‛␉",
	}, { // 3680
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␏",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?␏",
	}, { // 3681
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␏",
		out:  "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?␏",
	}, { // 3682
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␏",
		out:  "␊␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?␏",
	}, { // 3683
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa␊␏",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa␊␏",
	}, { // 3684
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa␊␏",
		out:  "␊＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa␊␏",
	}, { // 3685
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␊",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?‛␊",
	}, { // 3686
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␊",
		out:  "␊＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?‛␊",
	}, { // 3687
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n\nχ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␏",
		out:  "\n\nχ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?␏",
	}, { // 3688
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␏",
		out:  "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?␏",
	}, { // 3689
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n\nχ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa␊␏",
		out:  "\n\nχ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa␊␏",
	}, { // 3690
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa␊␏",
		out:  "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa␊␏",
	}, { // 3691
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n\nχ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␊",
		out:  "\n\nχ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?‛␊",
	}, { // 3692
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␊",
		out:  "\n␊χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?‛␊",
	}, { // 3693
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa\n␏",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa\n␏",
	}, { // 3694
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa␊␏",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa␊␏",
	}, { // 3695
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa\n␊",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa\n‛␊",
	}, { // 3696
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa␊␊",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa␊‛␊",
	}, { // 3697
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?\n",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?␊",
	}, { // 3698
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O]ξ４/␛／＼ωNa?␊",
		out:  "\n＾χ␊～␈toψφ\n ６\x1b\x1aｓ␂O］ξ４/␛／＼ωNa?‛␊",
	}, { // 3699
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
		out:  "Ｘ\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
	}, { // 3700
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\v␋［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
		out:  "\v␋‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
	}, { // 3701
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋␋［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
		out:  "␋␋‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
	}, { // 3702
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\v\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
		out:  "\v\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
	}, { // 3703
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
		out:  "␋\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
	}, { // 3704
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\v\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ␋",
		out:  "\v\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ‛␋",
	}, { // 3705
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ␋",
		out:  "␋\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ‛␋",
	}, { // 3706
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\v［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
		out:  "Ｘ\v‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
	}, { // 3707
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ␋［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
		out:  "Ｘ␋‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβｎ",
	}, { // 3708
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\v［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
		out:  "Ｘ\v‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
	}, { // 3709
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ␋［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
		out:  "Ｘ␋‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
	}, { // 3710
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\v［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ␋",
		out:  "Ｘ\v‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ‛␋",
	}, { // 3711
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ␋［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ␋",
		out:  "Ｘ␋‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ‛␋",
	}, { // 3712
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v\vｎ",
		out:  "Ｘ\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v\vｎ",
	}, { // 3713
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
		out:  "Ｘ\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋ｎ",
	}, { // 3714
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v\v␋",
		out:  "Ｘ\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v\v‛␋",
	}, { // 3715
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋␋",
		out:  "Ｘ\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\v␋‛␋",
	}, { // 3716
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ\v",
		out:  "Ｘ\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ␋",
	}, { // 3717
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "Ｘ\x16［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ␋",
		out:  "Ｘ\x16‛［N␊\x1bψ␔␜ς\v０υ␑␑!#+8\uff00e\x0e#:：κν\vβ‛␋",
	}, { // 3718
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
	}, { // 3719
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\r␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
		out:  "\r␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
	}, { // 3720
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
		out:  "␍␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
	}, { // 3721
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\r␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
		out:  "\r␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
	}, { // 3722
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
		out:  "␍␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
	}, { // 3723
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\r␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β␍",
		out:  "\r␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β‛␍",
	}, { // 3724
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β␍",
		out:  "␍␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β‛␍",
	}, { // 3725
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο\rＣx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
		out:  "ο\rＣx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
	}, { // 3726
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^βη",
	}, { // 3727
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο\rＣx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
		out:  "ο\rＣx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
	}, { // 3728
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
	}, { // 3729
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο\rＣx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β␍",
		out:  "ο\rＣx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β‛␍",
	}, { // 3730
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β␍",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β‛␍",
	}, { // 3731
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^\rη",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^\rη",
	}, { // 3732
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍η",
	}, { // 3733
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^\r␍",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^\r‛␍",
	}, { // 3734
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍␍",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^␍‛␍",
	}, { // 3735
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β\r",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β␍",
	}, { // 3736
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "ο␍Ｃx!］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β␍",
		out:  "ο␍Ｃx!‛］\x14φ\x10␂\rτεｕ\x03%ｚ␛Ｆ ␐－~ｗ$\r\a^β‛␍",
	}, { // 3737
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
		out:  "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
	}, { // 3738
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\t␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
		out:  "\t␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
	}, { // 3739
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␉␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
		out:  "␉␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
	}, { // 3740
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\tｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
		out:  "\tｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
	}, { // 3741
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␉ｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
		out:  "␉ｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
	}, { // 3742
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\tｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk␉",
		out:  "\tｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk‛␉",
	}, { // 3743
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␉ｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk␉",
		out:  "␉ｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk‛␉",
	}, { // 3744
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "i\tpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
		out:  "i\tpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
	}, { // 3745
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "i␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
		out:  "i␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bkμ",
	}, { // 3746
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "i\tpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
		out:  "i\tpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
	}, { // 3747
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "i␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
		out:  "i␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
	}, { // 3748
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "i\tpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk␉",
		out:  "i\tpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk‛␉",
	}, { // 3749
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "i␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk␉",
		out:  "i␉pX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk‛␉",
	}, { // 3750
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b\tμ",
		out:  "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b\tμ",
	}, { // 3751
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
		out:  "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉μ",
	}, { // 3752
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b\t␉",
		out:  "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b\t‛␉",
	}, { // 3753
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉␉",
		out:  "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\b␉‛␉",
	}, { // 3754
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk\t",
		out:  "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk␉",
	}, { // 3755
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk␉",
		out:  "iｆpX.\x03ηａ＇␍\tＰορ␑λ?%\r&␋ＧρＺ␑\x16２\bk‛␉",
	}, { // 3756
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
		out:  "ψＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
	}, { // 3757
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\n␊；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
		out:  "\n␊‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
	}, { // 3758
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␊␊；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
		out:  "␊␊‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
	}, { // 3759
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\nＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
		out:  "\nＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
	}, { // 3760
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␊Ｈ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
		out:  "␊Ｈ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
	}, { // 3761
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\nＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:␊",
		out:  "\nＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:‛␊",
	}, { // 3762
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␊Ｈ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:␊",
		out:  "␊Ｈ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:‛␊",
	}, { // 3763
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψ\n；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
		out:  "ψ\n‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
	}, { // 3764
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψ␊；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
		out:  "ψ␊‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\uff00",
	}, { // 3765
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψ\n；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
		out:  "ψ\n‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
	}, { // 3766
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψ␊；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
		out:  "ψ␊‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
	}, { // 3767
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψ\n；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:␊",
		out:  "ψ\n‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:‛␊",
	}, { // 3768
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψ␊；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:␊",
		out:  "ψ␊‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:‛␊",
	}, { // 3769
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼\n\uff00",
		out:  "ψＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼\n\uff00",
	}, { // 3770
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
		out:  "ψＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊\uff00",
	}, { // 3771
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼\n␊",
		out:  "ψＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼\n‛␊",
	}, { // 3772
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊␊",
		out:  "ψＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼␊‛␊",
	}, { // 3773
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:\n",
		out:  "ψＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:␊",
	}, { // 3774
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ψＨ；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:␊",
		out:  "ψＨ‛；^L␄＊ωｔ?\n␝\x112\x1e\x01ετA\x1f１\x0e\tＢｏ＊ψ＼:‛␊",
	}, { // 3775
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
		out:  "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
	}, { // 3776
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\v␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
		out:  "\v␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
	}, { // 3777
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␋␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
		out:  "␋␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
	}, { // 3778
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\v％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
		out:  "\v％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
	}, { // 3779
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␋％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
		out:  "␋％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
	}, { // 3780
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\v％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!␋",
		out:  "\v％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!‛␋",
	}, { // 3781
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␋％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!␋",
		out:  "␋％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!‛␋",
	}, { // 3782
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ\v\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
		out:  "Ａ\v\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
	}, { // 3783
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
		out:  "Ａ␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!Ｆ",
	}, { // 3784
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ\v\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
		out:  "Ａ\v\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
	}, { // 3785
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
		out:  "Ａ␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
	}, { // 3786
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ\v\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!␋",
		out:  "Ａ\v\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!‛␋",
	}, { // 3787
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!␋",
		out:  "Ａ␋\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!‛␋",
	}, { // 3788
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂\vＦ",
		out:  "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂\vＦ",
	}, { // 3789
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
		out:  "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋Ｆ",
	}, { // 3790
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂\v␋",
		out:  "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂\v‛␋",
	}, { // 3791
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋␋",
		out:  "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂␋‛␋",
	}, { // 3792
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!\v",
		out:  "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!␋",
	}, { // 3793
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!␋",
		out:  "Ａ％\rTυ\x06␏wＦ␅\v\x1e%␉9l␈νβκZ'ο\x13ζｈ␡␂!‛␋",
	}, { // 3794
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
		out:  "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
	}, { // 3795
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\r␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
		out:  "\r␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
	}, { // 3796
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␍␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
		out:  "␍␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
	}, { // 3797
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\r\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
		out:  "\r\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
	}, { // 3798
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␍\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
		out:  "␍\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
	}, { // 3799
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\r\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a␍",
		out:  "\r\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a‛␍",
	}, { // 3800
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␍\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a␍",
		out:  "␍\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a‛␍",
	}, { // 3801
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\r␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
		out:  "K\r␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
	}, { // 3802
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
		out:  "K␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1aφ",
	}, { // 3803
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\r␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
		out:  "K\r␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
	}, { // 3804
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
		out:  "K␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
	}, { // 3805
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\r␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a␍",
		out:  "K\r␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a‛␍",
	}, { // 3806
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a␍",
		out:  "K␍␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a‛␍",
	}, { // 3807
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\rφ",
		out:  "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\rφ",
	}, { // 3808
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
		out:  "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍φ",
	}, { // 3809
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\r␍",
		out:  "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\r‛␍",
	}, { // 3810
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍␍",
		out:  "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０␍‛␍",
	}, { // 3811
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a\r",
		out:  "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a␍",
	}, { // 3812
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a␍",
		out:  "K\x04␏␏\"φλ\x1e\x14＜\rζ[\nＱＣνλoV＊\x03｜Ｎ␈␡p０\x1a‛␍",
	}, { // 3813
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
		out:  "ｅ.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
	}, { // 3814
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\t␉＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
		out:  "\t␉＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
	}, { // 3815
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␉␉＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
		out:  "␉␉＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
	}, { // 3816
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\t.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
		out:  "\t.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
	}, { // 3817
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␉.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
		out:  "␉.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
	}, { // 3818
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\t.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b␉",
		out:  "\t.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b‛␉",
	}, { // 3819
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␉.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b␉",
		out:  "␉.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b‛␉",
	}, { // 3820
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ\t＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
		out:  "ｅ\t＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
	}, { // 3821
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ␉＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
		out:  "ｅ␉＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\\",
	}, { // 3822
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ\t＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
		out:  "ｅ\t＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
	}, { // 3823
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ␉＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
		out:  "ｅ␉＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
	}, { // 3824
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ\t＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b␉",
		out:  "ｅ\t＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b‛␉",
	}, { // 3825
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ␉＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b␉",
		out:  "ｅ␉＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b‛␉",
	}, { // 3826
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\t\\",
		out:  "ｅ.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\t\\",
	}, { // 3827
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
		out:  "ｅ.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉\\",
	}, { // 3828
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\t␉",
		out:  "ｅ.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\t‛␉",
	}, { // 3829
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉␉",
		out:  "ｅ.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01␉‛␉",
	}, { // 3830
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b\t",
		out:  "ｅ.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b␉",
	}, { // 3831
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "ｅ.＇\x00B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b␉",
		out:  "ｅ.＇␀B␗(πｕ$\t％␆μα［Ｆｃ&０β[＊\rςξＳ\x01\b‛␉",
	}, { // 3832
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␘",
		out:  "\x11‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡␘",
	}, { // 3833
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\n␊ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␘",
		out:  "\n␊ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡␘",
	}, { // 3834
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␊␊ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␘",
		out:  "␊␊ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡␘",
	}, { // 3835
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\n！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␊␘",
		out:  "\n‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␊␘",
	}, { // 3836
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␊！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␊␘",
		out:  "␊‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␊␘",
	}, { // 3837
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\n！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␊",
		out:  "\n‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡‛␊",
	}, { // 3838
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␊！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␊",
		out:  "␊‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡‛␊",
	}, { // 3839
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11\nｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␘",
		out:  "\x11\nｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡␘",
	}, { // 3840
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11␊ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␘",
		out:  "\x11␊ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡␘",
	}, { // 3841
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11\nｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␊␘",
		out:  "\x11\nｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␊␘",
	}, { // 3842
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11␊ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␊␘",
		out:  "\x11␊ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␊␘",
	}, { // 3843
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11\nｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␊",
		out:  "\x11\nｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡‛␊",
	}, { // 3844
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11␊ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␊",
		out:  "\x11␊ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡‛␊",
	}, { // 3845
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04\n␘",
		out:  "\x11‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04\n␘",
	}, { // 3846
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␊␘",
		out:  "\x11‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␊␘",
	}, { // 3847
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04\n␊",
		out:  "\x11‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04\n‛␊",
	}, { // 3848
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␊␊",
		out:  "\x11‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␊‛␊",
	}, { // 3849
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡\n",
		out:  "\x11‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡␊",
	}, { // 3850
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\x11！ｘ!ｚ␃&ι＂５\nｐσI（！#~η<φι4E\x03Ｂ\x17\x04␡␊",
		out:  "\x11‛！ｘ！ｚ␃&ι＂５\nｐσI（‛！#~η<φι4E\x03Ｂ\x17\x04␡‛␊",
	}, { // 3851
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆\x1e",
		out:  "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆\x1e",
	}, { // 3852
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\v␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆\x1e",
		out:  "\v␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆\x1e",
	}, { // 3853
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␋␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆\x1e",
		out:  "␋␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆\x1e",
	}, { // 3854
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\v␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␋\x1e",
		out:  "\v␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␋\x1e",
	}, { // 3855
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␋␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␋\x1e",
		out:  "␋␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␋\x1e",
	}, { // 3856
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\v␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆␋",
		out:  "\v␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆‛␋",
	}, { // 3857
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␋␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆␋",
		out:  "␋␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆‛␋",
	}, { // 3858
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜\vσχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆\x1e",
		out:  "＜\vσχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆\x1e",
	}, { // 3859
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆\x1e",
		out:  "＜␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆\x1e",
	}, { // 3860
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜\vσχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␋\x1e",
		out:  "＜\vσχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␋\x1e",
	}, { // 3861
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␋\x1e",
		out:  "＜␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␋\x1e",
	}, { // 3862
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜\vσχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆␋",
		out:  "＜\vσχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆‛␋",
	}, { // 3863
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆␋",
		out:  "＜␋σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆‛␋",
	}, { // 3864
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ\v\x1e",
		out:  "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ\v\x1e",
	}, { // 3865
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␋\x1e",
		out:  "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␋\x1e",
	}, { // 3866
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ\v␋",
		out:  "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ\v‛␋",
	}, { // 3867
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␋␋",
		out:  "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␋‛␋",
	}, { // 3868
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆\v",
		out:  "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆␋",
	}, { // 3869
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；!]}␊\x1dε=␊Ｋπ␆␋",
		out:  "＜␊σχ\x1fｃiω␉g\v~μＩ\x04Ｓ＋；！]}␊\x1dε=␊Ｋπ␆‛␋",
	}, { // 3870
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
		out:  "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
	}, { // 3871
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\r␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
		out:  "\r␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
	}, { // 3872
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␍␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
		out:  "␍␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
	}, { // 3873
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\r）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
		out:  "\r）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
	}, { // 3874
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␍）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
		out:  "␍）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
	}, { // 3875
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "\r）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄␍",
		out:  "\r）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄‛␍",
	}, { // 3876
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "␍）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄␍",
		out:  "␍）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄‛␍",
	}, { // 3877
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8\r␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
		out:  "8\r␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
	}, { // 3878
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
		out:  "8␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄δ",
	}, { // 3879
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8\r␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
		out:  "8\r␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
	}, { // 3880
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
		out:  "8␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
	}, { // 3881
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8\r␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄␍",
		out:  "8\r␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄‛␍",
	}, { // 3882
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄␍",
		out:  "8␍␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄‛␍",
	}, { // 3883
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<\rδ",
		out:  "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<\rδ",
	}, { // 3884
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
		out:  "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍δ",
	}, { // 3885
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<\r␍",
		out:  "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<\r‛␍",
	}, { // 3886
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍␍",
		out:  "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<␍‛␍",
	}, { // 3887
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄\r",
		out:  "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄␍",
	}, { // 3888
		mask: EncodeExclamation | EncodeRightCrLfHtVt,
		in:   "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄␍",
		out:  "8）␑＇？ρφ／a\x11\rσA８:\a␈\x17␁*＄＞<#zων<＄‛␍",
	}, { // 3889
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
		out:  "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
	}, { // 3890
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
		out:  "\t␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
	}, { // 3891
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
		out:  "␉␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
	}, { // 3892
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
		out:  "\t<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
	}, { // 3893
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
		out:  "␉<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
	}, { // 3894
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5␉",
		out:  "\t<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5‛␉",
	}, { // 3895
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5␉",
		out:  "␉<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5‛␉",
	}, { // 3896
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂\t｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
		out:  "＂\t｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
	}, { // 3897
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
		out:  "＂␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5μ",
	}, { // 3898
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂\t｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
		out:  "＂\t｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
	}, { // 3899
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
		out:  "＂␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
	}, { // 3900
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂\t｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5␉",
		out:  "＂\t｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5‛␉",
	}, { // 3901
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5␉",
		out:  "＂␉｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5‛␉",
	}, { // 3902
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y\tμ",
		out:  "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y\tμ",
	}, { // 3903
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
		out:  "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉μ",
	}, { // 3904
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y\t␉",
		out:  "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y\t‛␉",
	}, { // 3905
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉␉",
		out:  "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y␉‛␉",
	}, { // 3906
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5\t",
		out:  "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5␉",
	}, { // 3907
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5␉",
		out:  "＂<｀Q/κ#θ\"␐\t\x17［%␜Ｎ␊Ｂ:；？:␁φξν|y5‛␉",
	}, { // 3908
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
		out:  "Ｇυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
	}, { // 3909
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n␊３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
		out:  "\n␊３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
	}, { // 3910
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊␊３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
		out:  "␊␊３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
	}, { // 3911
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\nυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
		out:  "\nυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
	}, { // 3912
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊υ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
		out:  "␊υ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
	}, { // 3913
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\nυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{␊",
		out:  "\nυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{‛␊",
	}, { // 3914
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊υ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{␊",
		out:  "␊υ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{‛␊",
	}, { // 3915
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇ\n３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
		out:  "Ｇ\n３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
	}, { // 3916
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇ␊３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
		out:  "Ｇ␊３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{－",
	}, { // 3917
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇ\n３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
		out:  "Ｇ\n３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
	}, { // 3918
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇ␊３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
		out:  "Ｇ␊３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
	}, { // 3919
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇ\n３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{␊",
		out:  "Ｇ\n３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{‛␊",
	}, { // 3920
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇ␊３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{␊",
		out:  "Ｇ␊３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{‛␊",
	}, { // 3921
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７\n－",
		out:  "Ｇυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７\n－",
	}, { // 3922
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
		out:  "Ｇυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊－",
	}, { // 3923
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７\n␊",
		out:  "Ｇυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７\n‛␊",
	}, { // 3924
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊␊",
		out:  "Ｇυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７␊‛␊",
	}, { // 3925
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{\n",
		out:  "Ｇυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{␊",
	}, { // 3926
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "Ｇυ３\x00␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{␊",
		out:  "Ｇυ３␀␗＆\x16ω\x01[\nＲλCο｜␚ι\f?ξ␉/;c␌R７{‛␊",
	}, { // 3927
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－\x03",
		out:  "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－\x03",
	}, { // 3928
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v␋I\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－\x03",
		out:  "\v␋I\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－\x03",
	}, { // 3929
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋␋I\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－\x03",
		out:  "␋␋I\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－\x03",
	}, { // 3930
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\vｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH␋\x03",
		out:  "\vｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH␋\x03",
	}, { // 3931
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋ｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH␋\x03",
		out:  "␋ｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH␋\x03",
	}, { // 3932
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\vｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－␋",
		out:  "\vｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－‛␋",
	}, { // 3933
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋ｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－␋",
		out:  "␋ｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－‛␋",
	}, { // 3934
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t\vI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－\x03",
		out:  "\t\vI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－\x03",
	}, { // 3935
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t␋I\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－\x03",
		out:  "\t␋I\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－\x03",
	}, { // 3936
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t\vI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH␋\x03",
		out:  "\t\vI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH␋\x03",
	}, { // 3937
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t␋I\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH␋\x03",
		out:  "\t␋I\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH␋\x03",
	}, { // 3938
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t\vI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－␋",
		out:  "\t\vI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－‛␋",
	}, { // 3939
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t␋I\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－␋",
		out:  "\t␋I\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－‛␋",
	}, { // 3940
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH\v\x03",
		out:  "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH\v\x03",
	}, { // 3941
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH␋\x03",
		out:  "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH␋\x03",
	}, { // 3942
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH\v␋",
		out:  "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH\v‛␋",
	}, { // 3943
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH␋␋",
		out:  "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH␋‛␋",
	}, { // 3944
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－\v",
		out:  "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－␋",
	}, { // 3945
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ\x00ｆι␀$\t｛Ｒ␂)υμH－␋",
		out:  "\tｒI\x0ea␜ψ␃\f␎\v␓κζｐ␀ｆι‛␀＄\t｛Ｒ␂)υμH－‛␋",
	}, { // 3946
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υBＺ",
		out:  "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υBＺ",
	}, { // 3947
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υBＺ",
		out:  "\r␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υBＺ",
	}, { // 3948
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υBＺ",
		out:  "␍␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υBＺ",
	}, { // 3949
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\rο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ␍Ｚ",
		out:  "\rο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ␍Ｚ",
	}, { // 3950
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ␍Ｚ",
		out:  "␍ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ␍Ｚ",
	}, { // 3951
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\rο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υB␍",
		out:  "\rο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υB‛␍",
	}, { // 3952
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υB␍",
		out:  "␍ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υB‛␍",
	}, { // 3953
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?\r␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υBＺ",
		out:  "?\r␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υBＺ",
	}, { // 3954
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υBＺ",
		out:  "?␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υBＺ",
	}, { // 3955
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?\r␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ␍Ｚ",
		out:  "?\r␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ␍Ｚ",
	}, { // 3956
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ␍Ｚ",
		out:  "?␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ␍Ｚ",
	}, { // 3957
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?\r␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υB␍",
		out:  "?\r␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υB‛␍",
	}, { // 3958
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υB␍",
		out:  "?␍␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υB‛␍",
	}, { // 3959
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ\rＺ",
		out:  "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ\rＺ",
	}, { // 3960
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ␍Ｚ",
		out:  "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ␍Ｚ",
	}, { // 3961
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ\r␍",
		out:  "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ\r‛␍",
	}, { // 3962
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υ␍␍",
		out:  "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υ␍‛␍",
	}, { // 3963
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υB\r",
		out:  "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υB␍",
	}, { // 3964
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\＄␀υB␍",
		out:  "?ο␃％ςｊB(d\x05\r␕␐\f７\b␕DρＥ０!\x03μ\\‛＄‛␀υB‛␍",
	}, { // 3965
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
		out:  "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
	}, { // 3966
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
		out:  "\t␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
	}, { // 3967
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
		out:  "␉␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
	}, { // 3968
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
		out:  "\t&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
	}, { // 3969
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
		out:  "␉&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
	}, { // 3970
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␉",
		out:  "\t&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ‛␉",
	}, { // 3971
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␉",
		out:  "␉&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ‛␉",
	}, { // 3972
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$\t！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
		out:  "$\t！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
	}, { // 3973
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
		out:  "$␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␅",
	}, { // 3974
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$\t！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
		out:  "$\t！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
	}, { // 3975
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
		out:  "$␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
	}, { // 3976
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$\t！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␉",
		out:  "$\t！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ‛␉",
	}, { // 3977
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␉",
		out:  "$␉！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ‛␉",
	}, { // 3978
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ\t␅",
		out:  "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ\t␅",
	}, { // 3979
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
		out:  "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␅",
	}, { // 3980
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ\t␉",
		out:  "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ\t‛␉",
	}, { // 3981
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉␉",
		out:  "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂ␉‛␉",
	}, { // 3982
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ\t",
		out:  "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␉",
	}, { // 3983
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ␉",
		out:  "$&！\x16％\x06δ%~ω\t｀β\x1b/ψe␁v／τ#ν［：）␕Ｂｗ‛␉",
	}, { // 3984
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
		out:  "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
	}, { // 3985
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
		out:  "\n␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
	}, { // 3986
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
		out:  "␊␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
	}, { // 3987
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
		out:  "\n\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
	}, { // 3988
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
		out:  "␊\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
	}, { // 3989
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@␊",
		out:  "\n\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@‛␊",
	}, { // 3990
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@␊",
		out:  "␊\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@‛␊",
	}, { // 3991
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\n]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
		out:  "ｈ\n]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
	}, { // 3992
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
		out:  "ｈ␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@Ｐ",
	}, { // 3993
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\n]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
		out:  "ｈ\n]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
	}, { // 3994
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
		out:  "ｈ␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
	}, { // 3995
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\n]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@␊",
		out:  "ｈ\n]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@‛␊",
	}, { // 3996
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@␊",
		out:  "ｈ␊]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@‛␊",
	}, { // 3997
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11\nＰ",
		out:  "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11\nＰ",
	}, { // 3998
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
		out:  "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊Ｐ",
	}, { // 3999
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11\n␊",
		out:  "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11\n‛␊",
	}, { // 4000
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊␊",
		out:  "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11␊‛␊",
	}, { // 4001
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@\n",
		out:  "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@␊",
	}, { // 4002
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@␊",
		out:  "ｈ\x1f]Ｋζ␗>ｋS｜\n［νωo；/␆␈ξ：ι\x10υ\x1by?\x11@‛␊",
	}, { // 4003
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
		out:  "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
	}, { // 4004
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
		out:  "\v␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
	}, { // 4005
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
		out:  "␋␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
	}, { // 4006
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\vuκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
		out:  "\vuκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
	}, { // 4007
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
		out:  "␋uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
	}, { // 4008
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\vuκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙␋",
		out:  "\vuκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙‛␋",
	}, { // 4009
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙␋",
		out:  "␋uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙‛␋",
	}, { // 4010
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄\vκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
		out:  "␄\vκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
	}, { // 4011
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
		out:  "␄␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\x17",
	}, { // 4012
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄\vκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
		out:  "␄\vκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
	}, { // 4013
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
		out:  "␄␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
	}, { // 4014
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄\vκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙␋",
		out:  "␄\vκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙‛␋",
	}, { // 4015
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙␋",
		out:  "␄␋κ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙‛␋",
	}, { // 4016
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι\v\x17",
		out:  "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι\v\x17",
	}, { // 4017
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
		out:  "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋\x17",
	}, { // 4018
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι\v␋",
		out:  "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι\v‛␋",
	}, { // 4019
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋␋",
		out:  "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␋‛␋",
	}, { // 4020
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙\v",
		out:  "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙␋",
	}, { // 4021
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙␋",
		out:  "␄uκ␕␚&/＝μＰ\v０␡_\nωδKＣ+｜,\aλ\x0f:ｈι␙‛␋",
	}, { // 4022
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
		out:  "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
	}, { // 4023
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
		out:  "\r␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
	}, { // 4024
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
		out:  "␍␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
	}, { // 4025
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
		out:  "\r；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
	}, { // 4026
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
		out:  "␍；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
	}, { // 4027
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␍",
		out:  "\r；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃‛␍",
	}, { // 4028
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␍",
		out:  "␍；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃‛␍",
	}, { // 4029
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k\r｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
		out:  "k\r｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
	}, { // 4030
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
		out:  "k␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␎",
	}, { // 4031
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k\r｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
		out:  "k\r｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
	}, { // 4032
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
		out:  "k␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
	}, { // 4033
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k\r｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␍",
		out:  "k\r｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃‛␍",
	}, { // 4034
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␍",
		out:  "k␍｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃‛␍",
	}, { // 4035
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'\r␎",
		out:  "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'\r␎",
	}, { // 4036
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
		out:  "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␎",
	}, { // 4037
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'\r␍",
		out:  "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'\r‛␍",
	}, { // 4038
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍␍",
		out:  "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'␍‛␍",
	}, { // 4039
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃\r",
		out:  "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␍",
	}, { // 4040
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃␍",
		out:  "k；｜ｅ!ςπλ］ο\rA\r␡ｃ｀␓}ο \x04\x06*\x1e\x12λｊ'＃‛␍",
	}, { // 4041
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
		out:  "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
	}, { // 4042
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
		out:  "\t␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
	}, { // 4043
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
		out:  "␉␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
	}, { // 4044
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
		out:  "\t*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
	}, { // 4045
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
		out:  "␉*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
	}, { // 4046
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ␉",
		out:  "\t*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ‛␉",
	}, { // 4047
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ␉",
		out:  "␉*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ‛␉",
	}, { // 4048
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ\tＵε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
		out:  "φ\tＵε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
	}, { // 4049
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
		out:  "φ␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18ＰV",
	}, { // 4050
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ\tＵε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
		out:  "φ\tＵε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
	}, { // 4051
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
		out:  "φ␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
	}, { // 4052
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ\tＵε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ␉",
		out:  "φ\tＵε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ‛␉",
	}, { // 4053
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ␉",
		out:  "φ␉Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ‛␉",
	}, { // 4054
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18\tV",
		out:  "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18\tV",
	}, { // 4055
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
		out:  "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉V",
	}, { // 4056
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18\t␉",
		out:  "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18\t‛␉",
	}, { // 4057
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉␉",
		out:  "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18␉‛␉",
	}, { // 4058
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ\t",
		out:  "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ␉",
	}, { // 4059
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ␉",
		out:  "φ*Ｕε\x04,\x05ｖ␘＼\t?␇τσ#（␉␊\x0fφ␐I/;ｎｏ\x18Ｐ‛␉",
	}, { // 4060
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␒",
		out:  "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f␒",
	}, { // 4061
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\n␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␒",
		out:  "\n␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f␒",
	}, { // 4062
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␒",
		out:  "␊␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f␒",
	}, { // 4063
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\n＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊␊␒",
		out:  "\n＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊␊␒",
	}, { // 4064
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊␊␒",
		out:  "␊＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊␊␒",
	}, { // 4065
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\n＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␊",
		out:  "\n＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f‛␊",
	}, { // 4066
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␊",
		out:  "␊＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f‛␊",
	}, { // 4067
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８\nο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␒",
		out:  "８\nο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f␒",
	}, { // 4068
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␒",
		out:  "８␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f␒",
	}, { // 4069
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８\nο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊␊␒",
		out:  "８\nο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊␊␒",
	}, { // 4070
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊␊␒",
		out:  "８␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊␊␒",
	}, { // 4071
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８\nο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␊",
		out:  "８\nο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f‛␊",
	}, { // 4072
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␊",
		out:  "８␊ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f‛␊",
	}, { // 4073
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\n␒",
		out:  "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\n␒",
	}, { // 4074
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊␊␒",
		out:  "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊␊␒",
	}, { // 4075
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\n␊",
		out:  "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\n‛␊",
	}, { // 4076
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊␊␊",
		out:  "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊␊‛␊",
	}, { // 4077
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f\n",
		out:  "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f␊",
	}, { // 4078
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο：␎｛Kε\n＊\f␊",
		out:  "８＃ο>＊ν%/{Ｑ\njＡ＃␍`\x19γκ<ο‛：␎｛Kε\n＊\f‛␊",
	}, { // 4079
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
		out:  "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
	}, { // 4080
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\v␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
		out:  "\v␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
	}, { // 4081
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
		out:  "␋␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
	}, { // 4082
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
		out:  "\vβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
	}, { // 4083
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋β＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
		out:  "␋β＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
	}, { // 4084
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␋",
		out:  "\vβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v‛␋",
	}, { // 4085
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋β＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␋",
		out:  "␋β＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v‛␋",
	}, { // 4086
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο\v＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
		out:  "ο\v＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
	}, { // 4087
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
		out:  "ο␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␒",
	}, { // 4088
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο\v＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
		out:  "ο\v＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
	}, { // 4089
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
		out:  "ο␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
	}, { // 4090
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο\v＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␋",
		out:  "ο\v＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v‛␋",
	}, { // 4091
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "ο␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␋",
		out:  "ο␋＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v‛␋",
	}, { // 4092
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%\v␒",
		out:  "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%\v␒",
	}, { // 4093
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
		out:  "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␒",
	}, { // 4094
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%\v␋",
		out:  "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%\v‛␋",
	}, { // 4095
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋␋",
		out:  "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%␋‛␋",
	}, { // 4096
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v\v",
		out:  "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␋",
	}, { // 4097
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v␋",
		out:  "οβ＞>［π\x13/＆5\vφ␁）f＊\x1c^［＃γξ\tＭＮ(a%v‛␋",
	}, { // 4098
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
		out:  "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
	}, { // 4099
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\r␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
		out:  "\r␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
	}, { // 4100
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
		out:  "␍␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
	}, { // 4101
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\r＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
		out:  "\r＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
	}, { // 4102
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
		out:  "␍＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
	}, { // 4103
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\r＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ␍",
		out:  "\r＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ‛␍",
	}, { // 4104
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ␍",
		out:  "␍＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ‛␍",
	}, { // 4105
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚\rσ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
		out:  "␚\rσ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
	}, { // 4106
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
		out:  "␚␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦＵ",
	}, { // 4107
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚\rσ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
		out:  "␚\rσ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
	}, { // 4108
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
		out:  "␚␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
	}, { // 4109
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚\rσ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ␍",
		out:  "␚\rσ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ‛␍",
	}, { // 4110
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ␍",
		out:  "␚␍σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ‛␍",
	}, { // 4111
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o\rＵ",
		out:  "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o\rＵ",
	}, { // 4112
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
		out:  "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍Ｕ",
	}, { // 4113
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o\r␍",
		out:  "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o\r‛␍",
	}, { // 4114
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍␍",
		out:  "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/o␍‛␍",
	}, { // 4115
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ\r",
		out:  "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ␍",
	}, { // 4116
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ␍",
		out:  "␚＼σ\x15τ\r3ψｊ␑\r␑a\x14␇\x1fυς｜ＷSο}\".Ｘ/oＦ‛␍",
	}, { // 4117
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
		out:  "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
	}, { // 4118
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
		out:  "\t␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
	}, { // 4119
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
		out:  "␉␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
	}, { // 4120
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\tＢ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
		out:  "\tＢ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
	}, { // 4121
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
		out:  "␉Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
	}, { // 4122
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\tＢ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊␉",
		out:  "\tＢ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊‛␉",
	}, { // 4123
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊␉",
		out:  "␉Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊‛␉",
	}, { // 4124
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆\t\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
		out:  "␆\t\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
	}, { // 4125
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
		out:  "␆␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊＇",
	}, { // 4126
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆\t\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
		out:  "␆\t\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
	}, { // 4127
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
		out:  "␆␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
	}, { // 4128
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆\t\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊␉",
		out:  "␆\t\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊‛␉",
	}, { // 4129
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊␉",
		out:  "␆␉\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊‛␉",
	}, { // 4130
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂\t＇",
		out:  "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂\t＇",
	}, { // 4131
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
		out:  "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉＇",
	}, { // 4132
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂\t␉",
		out:  "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂\t‛␉",
	}, { // 4133
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉␉",
		out:  "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␉‛␉",
	}, { // 4134
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊\t",
		out:  "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊␉",
	}, { // 4135
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊␉",
		out:  "␆Ｂ\x11\x0eｋ\\=␉ｍψ\tπ\x19␉(␊y`）σ\x1aυＺyFπw␂␊‛␉",
	}, { // 4136
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
		out:  "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
	}, { // 4137
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␊ν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
		out:  "\n␊ν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
	}, { // 4138
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␊ν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
		out:  "␊␊ν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
	}, { // 4139
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
		out:  "\n\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
	}, { // 4140
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
		out:  "␊\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
	}, { // 4141
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖο␊",
		out:  "\n\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖο‛␊",
	}, { // 4142
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖο␊",
		out:  "␊\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖο‛␊",
	}, { // 4143
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\nν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
		out:  "\r\nν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
	}, { // 4144
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␊ν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
		out:  "\r␊ν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖοｍ",
	}, { // 4145
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\nν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
		out:  "\r\nν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
	}, { // 4146
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␊ν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
		out:  "\r␊ν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
	}, { // 4147
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\nν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖο␊",
		out:  "\r\nν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖο‛␊",
	}, { // 4148
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␊ν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖο␊",
		out:  "\r␊ν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖο‛␊",
	}, { // 4149
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ\nｍ",
		out:  "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ\nｍ",
	}, { // 4150
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
		out:  "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ␊ｍ",
	}, { // 4151
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ\n␊",
		out:  "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ\n‛␊",
	}, { // 4152
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖ␊␊",
		out:  "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖ␊‛␊",
	}, { // 4153
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖο\n",
		out:  "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖο␊",
	}, { // 4154
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ?＆μ␞τ/＃q［Ｕ\x1eｖο␊",
		out:  "\r\x1eν␕/␗ｘ␟9P\nｙ#γ\rρ？＆μ␞τ/＃q［Ｕ\x1eｖο‛␊",
	}, { // 4155
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
		out:  "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
	}, { // 4156
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
		out:  "\v␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
	}, { // 4157
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
		out:  "␋␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
	}, { // 4158
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\vf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
		out:  "\vf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
	}, { // 4159
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋f␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
		out:  "␋f␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
	}, { // 4160
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\vf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ␋",
		out:  "\vf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ‛␋",
	}, { // 4161
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋f␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ␋",
		out:  "␋f␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ‛␋",
	}, { // 4162
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌ\v␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
		out:  "ｌ\v␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
	}, { // 4163
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌ␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
		out:  "ｌ␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ#",
	}, { // 4164
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌ\v␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
		out:  "ｌ\v␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
	}, { // 4165
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌ␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
		out:  "ｌ␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
	}, { // 4166
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌ\v␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ␋",
		out:  "ｌ\v␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ‛␋",
	}, { // 4167
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌ␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ␋",
		out:  "ｌ␋␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ‛␋",
	}, { // 4168
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04\v#",
		out:  "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04\v#",
	}, { // 4169
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
		out:  "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋#",
	}, { // 4170
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04\v␋",
		out:  "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04\v‛␋",
	}, { // 4171
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋␋",
		out:  "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04␋‛␋",
	}, { // 4172
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ\v",
		out:  "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ␋",
	}, { // 4173
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ␋",
		out:  "ｌf␉＇m\nｌβ\\φ\v τＶ@＜σ/ｋ／＊oη\x13＄yλ\x04Ｈ‛␋",
	}, { // 4174
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
		out:  "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
	}, { // 4175
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
		out:  "\r␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
	}, { // 4176
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
		out:  "␍␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
	}, { // 4177
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
		out:  "\r\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
	}, { // 4178
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
		out:  "␍\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
	}, { // 4179
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８␍",
		out:  "\r\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８‛␍",
	}, { // 4180
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８␍",
		out:  "␍\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８‛␍",
	}, { // 4181
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\r\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
		out:  "␏\r\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
	}, { // 4182
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
		out:  "␏␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８q",
	}, { // 4183
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\r\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
		out:  "␏\r\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
	}, { // 4184
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
		out:  "␏␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
	}, { // 4185
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\r\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８␍",
		out:  "␏\r\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８‛␍",
	}, { // 4186
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８␍",
		out:  "␏␍\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８‛␍",
	}, { // 4187
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ\rq",
		out:  "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ\rq",
	}, { // 4188
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
		out:  "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍q",
	}, { // 4189
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ\r␍",
		out:  "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ\r‛␍",
	}, { // 4190
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍␍",
		out:  "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ␍‛␍",
	}, { // 4191
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８\r",
		out:  "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８␍",
	}, { // 4192
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８␍",
		out:  "␏\x1f\x15υ@ｗψkＸψ\r;\x1c＊\x03＄ζ␚\x01οＯX␚！-␋Lｘ８‛␍",
	}, { // 4193
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15[",
		out:  "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15[",
	}, { // 4194
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t␉α␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15[",
		out:  "\t␉α␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15[",
	}, { // 4195
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉␉α␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15[",
		out:  "␉␉α␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15[",
	}, { // 4196
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\tMα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]␉[",
		out:  "\tMα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]␉[",
	}, { // 4197
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]␉[",
		out:  "␉Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]␉[",
	}, { // 4198
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\tMα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15␉",
		out:  "\tMα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15‛␉",
	}, { // 4199
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15␉",
		out:  "␉Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15‛␉",
	}, { // 4200
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；\tα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15[",
		out:  "；\tα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15[",
	}, { // 4201
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；␉α␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15[",
		out:  "；␉α␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15[",
	}, { // 4202
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；\tα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]␉[",
		out:  "；\tα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]␉[",
	}, { // 4203
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；␉α␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]␉[",
		out:  "；␉α␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]␉[",
	}, { // 4204
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；\tα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15␉",
		out:  "；\tα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15‛␉",
	}, { // 4205
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；␉α␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15␉",
		out:  "；␉α␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15‛␉",
	}, { // 4206
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\t[",
		out:  "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\t[",
	}, { // 4207
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]␉[",
		out:  "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]␉[",
	}, { // 4208
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\t␉",
		out:  "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\t‛␉",
	}, { // 4209
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]␉␉",
		out:  "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]␉‛␉",
	}, { // 4210
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15\t",
		out:  "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15␉",
	}, { // 4211
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#␀＠y＂δ3!ρ｜AＴ]\x15␉",
		out:  "；Mα␗／␑υ:\x13；\tοａ\x16ｉ#‛␀＠y＂δ3!ρ｜AＴ]\x15‛␉",
	}, { // 4212
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
		out:  "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
	}, { // 4213
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
		out:  "\n␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
	}, { // 4214
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
		out:  "␊␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
	}, { // 4215
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
		out:  "\n94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
	}, { // 4216
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
		out:  "␊94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
	}, { // 4217
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05␊",
		out:  "\n94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05‛␊",
	}, { // 4218
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05␊",
		out:  "␊94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05‛␊",
	}, { // 4219
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；\n4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
		out:  "；\n4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
	}, { // 4220
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
		out:  "；␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05％",
	}, { // 4221
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；\n4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
		out:  "；\n4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
	}, { // 4222
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
		out:  "；␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
	}, { // 4223
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；\n4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05␊",
		out:  "；\n4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05‛␊",
	}, { // 4224
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05␊",
		out:  "；␊4\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05‛␊",
	}, { // 4225
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\n％",
		out:  "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\n％",
	}, { // 4226
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
		out:  "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊％",
	}, { // 4227
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\n␊",
		out:  "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\n‛␊",
	}, { // 4228
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊␊",
		out:  "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛␊‛␊",
	}, { // 4229
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05\n",
		out:  "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05␊",
	}, { // 4230
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05␊",
		out:  "；94\x05ｃπC］\x10␅\nρ\"（␂%0γ３\x12ν＄ω｀hχ␗｛\x05‛␊",
	}, { // 4231
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？O",
		out:  "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？O",
	}, { // 4232
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\v␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？O",
		out:  "\v␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？O",
	}, { // 4233
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？O",
		out:  "␋␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？O",
	}, { // 4234
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈␋O",
		out:  "\vｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈␋O",
	}, { // 4235
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈␋O",
		out:  "␋ｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈␋O",
	}, { // 4236
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？␋",
		out:  "\vｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？‛␋",
	}, { // 4237
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？␋",
		out:  "␋ｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？‛␋",
	}, { // 4238
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φ\v\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？O",
		out:  "φ\v\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？O",
	}, { // 4239
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φ␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？O",
		out:  "φ␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？O",
	}, { // 4240
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φ\v\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈␋O",
		out:  "φ\v\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈␋O",
	}, { // 4241
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φ␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈␋O",
		out:  "φ␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈␋O",
	}, { // 4242
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φ\v\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？␋",
		out:  "φ\v\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？‛␋",
	}, { // 4243
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φ␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？␋",
		out:  "φ␋\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？‛␋",
	}, { // 4244
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈\vO",
		out:  "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈\vO",
	}, { // 4245
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈␋O",
		out:  "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈␋O",
	}, { // 4246
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈\v␋",
		out:  "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈\v‛␋",
	}, { // 4247
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈␋␋",
		out:  "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈␋‛␋",
	}, { // 4248
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？\v",
		out:  "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？␋",
	}, { // 4249
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ*y＇R␈？␋",
		out:  "φｋ\x1e；γ）j>`]\v|'｜＇N４βＪθρＪλ＊y＇R␈？‛␋",
	}, { // 4250
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
		out:  "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
	}, { // 4251
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
		out:  "\r␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
	}, { // 4252
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
		out:  "␍␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
	}, { // 4253
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\rχ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
		out:  "\rχ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
	}, { // 4254
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
		out:  "␍χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
	}, { // 4255
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\rχ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=␍",
		out:  "\rχ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=‛␍",
	}, { // 4256
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=␍",
		out:  "␍χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=‛␍",
	}, { // 4257
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[\r␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
		out:  "[\r␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
	}, { // 4258
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
		out:  "[␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=＞",
	}, { // 4259
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[\r␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
		out:  "[\r␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
	}, { // 4260
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
		out:  "[␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
	}, { // 4261
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[\r␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=␍",
		out:  "[\r␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=‛␍",
	}, { // 4262
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=␍",
		out:  "[␍␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=‛␍",
	}, { // 4263
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/\r＞",
		out:  "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/\r＞",
	}, { // 4264
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
		out:  "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍＞",
	}, { // 4265
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/\r␍",
		out:  "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/\r‛␍",
	}, { // 4266
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍␍",
		out:  "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/␍‛␍",
	}, { // 4267
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=\r",
		out:  "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=␍",
	}, { // 4268
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=␍",
		out:  "[χ␃ＣαK＞␜,Ｂ\rμＵρVIμ\"ω\b\"７｜＄h␚\x18/=‛␍",
	}, { // 4269
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
		out:  "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
	}, { // 4270
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\t␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
		out:  "\t␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
	}, { // 4271
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
		out:  "␉␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
	}, { // 4272
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\tγιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
		out:  "\tγιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
	}, { // 4273
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
		out:  "␉γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
	}, { // 4274
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\tγιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␉",
		out:  "\tγιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)‛␉",
	}, { // 4275
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␉",
		out:  "␉γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)‛␉",
	}, { // 4276
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$\tιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
		out:  "$\tιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
	}, { // 4277
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
		out:  "$␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␝",
	}, { // 4278
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$\tιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
		out:  "$\tιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
	}, { // 4279
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
		out:  "$␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
	}, { // 4280
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$\tιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␉",
		out:  "$\tιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)‛␉",
	}, { // 4281
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␉",
		out:  "$␉ιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)‛␉",
	}, { // 4282
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!\t␝",
		out:  "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!\t␝",
	}, { // 4283
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
		out:  "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␝",
	}, { // 4284
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!\t␉",
		out:  "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!\t‛␉",
	}, { // 4285
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉␉",
		out:  "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!␉‛␉",
	}, { // 4286
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)\t",
		out:  "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␉",
	}, { // 4287
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)␉",
		out:  "$γιＺ２ｑ␡\x04ｎ␋\t\x11\b1ζ\x17？ｌ,ςｏκ␆Pρ｀\t!)‛␉",
	}, { // 4288
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎\f",
		out:  "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎\f",
	}, { // 4289
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎\f",
		out:  "\n␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎\f",
	}, { // 4290
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎\f",
		out:  "␊␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎\f",
	}, { // 4291
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␊\f",
		out:  "\n~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␊\f",
	}, { // 4292
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␊\f",
		out:  "␊~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␊\f",
	}, { // 4293
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎␊",
		out:  "\n~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎‛␊",
	}, { // 4294
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎␊",
		out:  "␊~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎‛␊",
	}, { // 4295
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ\n．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎\f",
		out:  "ψ\n．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎\f",
	}, { // 4296
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎\f",
		out:  "ψ␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎\f",
	}, { // 4297
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ\n．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␊\f",
		out:  "ψ\n．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␊\f",
	}, { // 4298
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␊\f",
		out:  "ψ␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␊\f",
	}, { // 4299
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ\n．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎␊",
		out:  "ψ\n．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎‛␊",
	}, { // 4300
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎␊",
		out:  "ψ␊．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎‛␊",
	}, { // 4301
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ\n\f",
		out:  "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ\n\f",
	}, { // 4302
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␊\f",
		out:  "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␊\f",
	}, { // 4303
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ\n␊",
		out:  "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ\n‛␊",
	}, { // 4304
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␊␊",
		out:  "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␊‛␊",
	}, { // 4305
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎\n",
		out:  "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎␊",
	}, { // 4306
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ\x00Ｘξ␎␊",
		out:  "ψ~．\"ＮI␊\"␍ι\nＪ％｀ςJ␉O␍\fξ*\x7fsｙ␀Ｘξ␎‛␊",
	}, { // 4307
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!Ｍ",
		out:  "3␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!Ｍ",
	}, { // 4308
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v␋\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!Ｍ",
		out:  "\v␋\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!Ｍ",
	}, { // 4309
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋␋\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!Ｍ",
		out:  "␋␋\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!Ｍ",
	}, { // 4310
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
		out:  "\v␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
	}, { // 4311
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
		out:  "␋␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
	}, { // 4312
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!␋",
		out:  "\v␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!‛␋",
	}, { // 4313
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!␋",
		out:  "␋␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!‛␋",
	}, { // 4314
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3\v\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!Ｍ",
		out:  "3\v\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!Ｍ",
	}, { // 4315
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␋\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!Ｍ",
		out:  "3␋\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!Ｍ",
	}, { // 4316
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3\v\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
		out:  "3\v\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
	}, { // 4317
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␋\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
		out:  "3␋\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
	}, { // 4318
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3\v\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!␋",
		out:  "3\v\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!‛␋",
	}, { // 4319
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␋\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!␋",
		out:  "3␋\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!‛␋",
	}, { // 4320
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο\vＭ",
		out:  "3␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο\vＭ",
	}, { // 4321
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
		out:  "3␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο␋Ｍ",
	}, { // 4322
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο\v␋",
		out:  "3␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο\v‛␋",
	}, { // 4323
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο␋␋",
		out:  "3␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο␋‛␋",
	}, { // 4324
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!\v",
		out:  "3␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!␋",
	}, { // 4325
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "3␘\vＷνη␇７μ｝\vα}␑|９［␄>ν\"␎wA\x0fBＰο!␋",
		out:  "3␘\vＷνη␇７μ｝\vα}␑｜９［␄>ν\"␎wA\x0fBＰο!‛␋",
	}, { // 4326
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
		out:  "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
	}, { // 4327
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
		out:  "\r␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
	}, { // 4328
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
		out:  "␍␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
	}, { // 4329
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
		out:  "\r；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
	}, { // 4330
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
		out:  "␍；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
	}, { // 4331
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇␍",
		out:  "\r；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇‛␍",
	}, { // 4332
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇␍",
		out:  "␍；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇‛␍",
	}, { // 4333
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V\r␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
		out:  "V\r␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
	}, { // 4334
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
		out:  "V␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇%",
	}, { // 4335
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V\r␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
		out:  "V\r␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
	}, { // 4336
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
		out:  "V␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
	}, { // 4337
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V\r␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇␍",
		out:  "V\r␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇‛␍",
	}, { // 4338
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇␍",
		out:  "V␍␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇‛␍",
	}, { // 4339
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a\r%",
		out:  "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a\r%",
	}, { // 4340
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
		out:  "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍%",
	}, { // 4341
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a\r␍",
		out:  "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a\r‛␍",
	}, { // 4342
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍␍",
		out:  "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a␍‛␍",
	}, { // 4343
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇\r",
		out:  "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇␍",
	}, { // 4344
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇␍",
		out:  "V；␚δπκF1]␆\rλ\bεlｚ.φ！v０␜␉␊ｈ］\x1b\x1a＇‛␍",
	}, { // 4345
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
		out:  "\x16＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
	}, { // 4346
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
		out:  "\t␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
	}, { // 4347
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
		out:  "␉␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
	}, { // 4348
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
		out:  "\t＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
	}, { // 4349
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
		out:  "␉＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
	}, { // 4350
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG␉",
		out:  "\t＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG‛␉",
	}, { // 4351
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG␉",
		out:  "␉＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG‛␉",
	}, { // 4352
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16\ttψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
		out:  "\x16\ttψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
	}, { // 4353
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
		out:  "\x16␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\f",
	}, { // 4354
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16\ttψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
		out:  "\x16\ttψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
	}, { // 4355
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
		out:  "\x16␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
	}, { // 4356
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16\ttψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG␉",
		out:  "\x16\ttψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG‛␉",
	}, { // 4357
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG␉",
		out:  "\x16␉tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG‛␉",
	}, { // 4358
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν\t\f",
		out:  "\x16＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν\t\f",
	}, { // 4359
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
		out:  "\x16＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉\f",
	}, { // 4360
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν\t␉",
		out:  "\x16＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν\t‛␉",
	}, { // 4361
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉␉",
		out:  "\x16＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154ν␉‛␉",
	}, { // 4362
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG\t",
		out:  "\x16＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG␉",
	}, { // 4363
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x16#tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG␉",
		out:  "\x16＃tψｐ␎␊ｏ$χ\t␗ｐ％ω␡/μ\tb３Ｓ␁T８\x154νG‛␉",
	}, { // 4364
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
		out:  "ｔ‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
	}, { // 4365
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
		out:  "\n␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
	}, { // 4366
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
		out:  "␊␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
	}, { // 4367
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
		out:  "\n‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
	}, { // 4368
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
		out:  "␊‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
	}, { // 4369
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！␊",
		out:  "\n‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！‛␊",
	}, { // 4370
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！␊",
		out:  "␊‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！‛␊",
	}, { // 4371
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ\n\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
		out:  "ｔ\n\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
	}, { // 4372
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
		out:  "ｔ␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！ψ",
	}, { // 4373
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ\n\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
		out:  "ｔ\n\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
	}, { // 4374
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
		out:  "ｔ␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
	}, { // 4375
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ\n\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！␊",
		out:  "ｔ\n\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！‛␊",
	}, { // 4376
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！␊",
		out:  "ｔ␊\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！‛␊",
	}, { // 4377
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ\nψ",
		out:  "ｔ‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ\nψ",
	}, { // 4378
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
		out:  "ｔ‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊ψ",
	}, { // 4379
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ\n␊",
		out:  "ｔ‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ\n‛␊",
	}, { // 4380
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊␊",
		out:  "ｔ‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ␊‛␊",
	}, { // 4381
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！\n",
		out:  "ｔ‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！␊",
	}, { // 4382
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｔ＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！␊",
		out:  "ｔ‛＃\x1bT\x18σ＂η!x\nＺ\x1eλ␡－\x7f␌｜Ｌ\x18Kτ-ｚI;ρ！‛␊",
	}, { // 4383
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
		out:  "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
	}, { // 4384
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
		out:  "\v␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
	}, { // 4385
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
		out:  "␋␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
	}, { // 4386
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\vφυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
		out:  "\vφυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
	}, { // 4387
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
		out:  "␋φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
	}, { // 4388
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\vφυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ␋",
		out:  "\vφυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ‛␋",
	}, { // 4389
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ␋",
		out:  "␋φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ‛␋",
	}, { // 4390
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\\vυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
		out:  "\\\vυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
	}, { // 4391
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
		out:  "\\␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇｎ",
	}, { // 4392
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\\vυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
		out:  "\\\vυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
	}, { // 4393
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
		out:  "\\␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
	}, { // 4394
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\\vυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ␋",
		out:  "\\\vυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ‛␋",
	}, { // 4395
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ␋",
		out:  "\\␋υ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ‛␋",
	}, { // 4396
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［\vｎ",
		out:  "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［\vｎ",
	}, { // 4397
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
		out:  "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋ｎ",
	}, { // 4398
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［\v␋",
		out:  "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［\v‛␋",
	}, { // 4399
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋␋",
		out:  "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［␋‛␋",
	}, { // 4400
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ\v",
		out:  "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ␋",
	}, { // 4401
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ␋",
		out:  "\\φυ␝ω｜η<9τ\v\x12＜9ｋ％5(ｍ]％␁]*μ\x15Ｎ［ｇ‛␋",
	}, { // 4402
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
		out:  "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
	}, { // 4403
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
		out:  "\r␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
	}, { // 4404
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
		out:  "␍␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
	}, { // 4405
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
		out:  "\r＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
	}, { // 4406
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
		out:  "␍＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
	}, { // 4407
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁␍",
		out:  "\r＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁‛␍",
	}, { // 4408
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁␍",
		out:  "␍＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁‛␍",
	}, { // 4409
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ\r\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
		out:  "ｏ\r\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
	}, { // 4410
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
		out:  "ｏ␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁２",
	}, { // 4411
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ\r\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
		out:  "ｏ\r\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
	}, { // 4412
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
		out:  "ｏ␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
	}, { // 4413
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ\r\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁␍",
		out:  "ｏ\r\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁‛␍",
	}, { // 4414
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁␍",
		out:  "ｏ␍\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁‛␍",
	}, { // 4415
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ\r２",
		out:  "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ\r２",
	}, { // 4416
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
		out:  "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍２",
	}, { // 4417
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ\r␍",
		out:  "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ\r‛␍",
	}, { // 4418
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍␍",
		out:  "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␍‛␍",
	}, { // 4419
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁\r",
		out:  "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁␍",
	}, { // 4420
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁␍",
		out:  "ｏ＼\"０\x10!ρ２\x1d␖\rTι\x01cχf␍u]！ω␜\x19\x0e＜␑υ␁‛␍",
	}, { // 4421
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
		out:  "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
	}, { // 4422
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
		out:  "\t␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
	}, { // 4423
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
		out:  "␉␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
	}, { // 4424
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
		out:  "\t+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
	}, { // 4425
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
		out:  "␉+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
	}, { // 4426
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11␉",
		out:  "\t+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11‛␉",
	}, { // 4427
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11␉",
		out:  "␉+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11‛␉",
	}, { // 4428
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒\t/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
		out:  "␒\t/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
	}, { // 4429
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
		out:  "␒␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\x15",
	}, { // 4430
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒\t/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
		out:  "␒\t/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
	}, { // 4431
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
		out:  "␒␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
	}, { // 4432
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒\t/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11␉",
		out:  "␒\t/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11‛␉",
	}, { // 4433
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11␉",
		out:  "␒␉/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11‛␉",
	}, { // 4434
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\t\x15",
		out:  "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\t\x15",
	}, { // 4435
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
		out:  "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉\x15",
	}, { // 4436
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\t␉",
		out:  "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\t‛␉",
	}, { // 4437
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉␉",
		out:  "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi␉‛␉",
	}, { // 4438
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11\t",
		out:  "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11␉",
	}, { // 4439
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11␉",
		out:  "␒+/ｖ␡␄ｈθ８[\t)＊ｃ\"χω0␇γZχp\x15ｇ␎χi\x11‛␉",
	}, { // 4440
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
		out:  "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
	}, { // 4441
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
		out:  "\n␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
	}, { // 4442
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
		out:  "␊␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
	}, { // 4443
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
		out:  "\n\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
	}, { // 4444
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
		out:  "␊\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
	}, { // 4445
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X␊",
		out:  "\n\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X‛␊",
	}, { // 4446
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X␊",
		out:  "␊\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X‛␊",
	}, { // 4447
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\n\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
		out:  "γ\n\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
	}, { // 4448
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
		out:  "γ␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14Xｇ",
	}, { // 4449
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\n\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
		out:  "γ\n\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
	}, { // 4450
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
		out:  "γ␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
	}, { // 4451
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\n\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X␊",
		out:  "γ\n\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X‛␊",
	}, { // 4452
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X␊",
		out:  "γ␊\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X‛␊",
	}, { // 4453
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14\nｇ",
		out:  "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14\nｇ",
	}, { // 4454
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
		out:  "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊ｇ",
	}, { // 4455
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14\n␊",
		out:  "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14\n‛␊",
	}, { // 4456
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊␊",
		out:  "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14␊‛␊",
	}, { // 4457
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X\n",
		out:  "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X␊",
	}, { // 4458
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X␊",
		out:  "γ\x1a\x1f␋;␛␙Ｉ8L\n␈φφKf\x15Oπε８η␂７Ｂ␋\x14\x14X‛␊",
	}, { // 4459
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
		out:  "τ3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
	}, { // 4460
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v␋fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
		out:  "\v␋fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
	}, { // 4461
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋␋fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
		out:  "␋␋fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
	}, { // 4462
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
		out:  "\v3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
	}, { // 4463
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
		out:  "␋3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
	}, { // 4464
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂␋",
		out:  "\v3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂‛␋",
	}, { // 4465
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂␋",
		out:  "␋3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂‛␋",
	}, { // 4466
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ\vfχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
		out:  "τ\vfχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
	}, { // 4467
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ␋fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
		out:  "τ␋fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂τ",
	}, { // 4468
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ\vfχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
		out:  "τ\vfχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
	}, { // 4469
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ␋fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
		out:  "τ␋fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
	}, { // 4470
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ\vfχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂␋",
		out:  "τ\vfχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂‛␋",
	}, { // 4471
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ␋fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂␋",
		out:  "τ␋fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂‛␋",
	}, { // 4472
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)\vτ",
		out:  "τ3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)\vτ",
	}, { // 4473
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
		out:  "τ3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋τ",
	}, { // 4474
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)\v␋",
		out:  "τ3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)\v‛␋",
	}, { // 4475
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋␋",
		out:  "τ3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)␋‛␋",
	}, { // 4476
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂\v",
		out:  "τ3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂␋",
	}, { // 4477
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "τ3fχｖ％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂␋",
		out:  "τ3fχｖ‛％yχ\a\"\v␒ｃιｏ＞X\f＜␉␝\x01\"Ｍν\x1e␟)＂‛␋",
	}, { // 4478
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
		out:  "9␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
	}, { // 4479
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r␍ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
		out:  "\r␍ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
	}, { // 4480
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍␍ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
		out:  "␍␍ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
	}, { // 4481
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
		out:  "\r␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
	}, { // 4482
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
		out:  "␍␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
	}, { // 4483
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏␍",
		out:  "\r␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏‛␍",
	}, { // 4484
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏␍",
		out:  "␍␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏‛␍",
	}, { // 4485
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9\rε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
		out:  "9\rε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
	}, { // 4486
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␍ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
		out:  "9␍ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏ｙ",
	}, { // 4487
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9\rε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
		out:  "9\rε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
	}, { // 4488
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␍ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
		out:  "9␍ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
	}, { // 4489
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9\rε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏␍",
		out:  "9\rε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏‛␍",
	}, { // 4490
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␍ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏␍",
		out:  "9␍ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏‛␍",
	}, { // 4491
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S\rｙ",
		out:  "9␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S\rｙ",
	}, { // 4492
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
		out:  "9␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍ｙ",
	}, { // 4493
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S\r␍",
		out:  "9␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S\r‛␍",
	}, { // 4494
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍␍",
		out:  "9␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␍‛␍",
	}, { // 4495
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏\r",
		out:  "9␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏␍",
	}, { // 4496
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "9␛ε０ωμ␘%ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏␍",
		out:  "9␛ε０ωμ␘％ＱＪ\r＠\b］.nπς\x0f\x1eＣ\x1a ␆(\x1a＜S␏‛␍",
	}, { // 4497
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
		out:  "*‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
	}, { // 4498
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t␉π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
		out:  "\t␉π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
	}, { // 4499
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉␉π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
		out:  "␉␉π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
	}, { // 4500
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
		out:  "\t‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
	}, { // 4501
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
		out:  "␉‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
	}, { // 4502
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ␉",
		out:  "\t‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ‛␉",
	}, { // 4503
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ␉",
		out:  "␉‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ‛␉",
	}, { // 4504
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*\tπ\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
		out:  "*\tπ\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
	}, { // 4505
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*␉π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
		out:  "*␉π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂｈ",
	}, { // 4506
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*\tπ\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
		out:  "*\tπ\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
	}, { // 4507
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*␉π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
		out:  "*␉π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
	}, { // 4508
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*\tπ\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ␉",
		out:  "*\tπ\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ‛␉",
	}, { // 4509
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*␉π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ␉",
		out:  "*␉π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ‛␉",
	}, { // 4510
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗\tｈ",
		out:  "*‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗\tｈ",
	}, { // 4511
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
		out:  "*‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉ｈ",
	}, { // 4512
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗\t␉",
		out:  "*‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗\t‛␉",
	}, { // 4513
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉␉",
		out:  "*‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗␉‛␉",
	}, { // 4514
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ\t",
		out:  "*‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ␉",
	}, { // 4515
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "*＼π\"１Ｋ␖＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ␉",
		out:  "*‛＼π\"１Ｋ␖‛＼Hｐ\t`τςN\x14ω␏␝'λ\n\x1d2ｄHF␗Ｂ‛␉",
	}, { // 4516
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/`",
		out:  "θｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/`",
	}, { // 4517
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n␊3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/`",
		out:  "\n␊3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/`",
	}, { // 4518
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊␊3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/`",
		out:  "␊␊3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/`",
	}, { // 4519
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\nｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ␊`",
		out:  "\nｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ␊`",
	}, { // 4520
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊ｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ␊`",
		out:  "␊ｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ␊`",
	}, { // 4521
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\nｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/␊",
		out:  "\nｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/‛␊",
	}, { // 4522
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊ｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/␊",
		out:  "␊ｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/‛␊",
	}, { // 4523
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θ\n3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/`",
		out:  "θ\n3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/`",
	}, { // 4524
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θ␊3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/`",
		out:  "θ␊3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/`",
	}, { // 4525
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θ\n3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ␊`",
		out:  "θ\n3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ␊`",
	}, { // 4526
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θ␊3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ␊`",
		out:  "θ␊3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ␊`",
	}, { // 4527
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θ\n3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/␊",
		out:  "θ\n3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/‛␊",
	}, { // 4528
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θ␊3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/␊",
		out:  "θ␊3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/‛␊",
	}, { // 4529
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ\n`",
		out:  "θｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ\n`",
	}, { // 4530
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ␊`",
		out:  "θｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ␊`",
	}, { // 4531
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ\n␊",
		out:  "θｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ\n‛␊",
	}, { // 4532
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ␊␊",
		out:  "θｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ␊‛␊",
	}, { // 4533
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/\n",
		out:  "θｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/␊",
	}, { // 4534
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "θｑ3４ｙ［γ\x00\rＥ\n␊BＺ/␕␈\rβρβ\\；Pτr␝Ｙ/␊",
		out:  "θｑ3４ｙ［γ␀\rＥ\n␊BＺ/␕␈\rβρβ＼；Pτr␝Ｙ/‛␊",
	}, { // 4535
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb\x15",
		out:  "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb\x15",
	}, { // 4536
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb\x15",
		out:  "\v␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb\x15",
	}, { // 4537
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb\x15",
		out:  "␋␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb\x15",
	}, { // 4538
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ␋\x15",
		out:  "\v\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ␋\x15",
	}, { // 4539
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ␋\x15",
		out:  "␋\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ␋\x15",
	}, { // 4540
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb␋",
		out:  "\v\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb‛␋",
	}, { // 4541
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb␋",
		out:  "␋\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb‛␋",
	}, { // 4542
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\v＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb\x15",
		out:  "o\v＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb\x15",
	}, { // 4543
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb\x15",
		out:  "o␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb\x15",
	}, { // 4544
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\v＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ␋\x15",
		out:  "o\v＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ␋\x15",
	}, { // 4545
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ␋\x15",
		out:  "o␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ␋\x15",
	}, { // 4546
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\v＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb␋",
		out:  "o\v＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb‛␋",
	}, { // 4547
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb␋",
		out:  "o␋＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb‛␋",
	}, { // 4548
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ\v\x15",
		out:  "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ\v\x15",
	}, { // 4549
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ␋\x15",
		out:  "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ␋\x15",
	}, { // 4550
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ\v␋",
		out:  "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ\v‛␋",
	}, { // 4551
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχ␋␋",
		out:  "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχ␋‛␋",
	}, { // 4552
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb\v",
		out:  "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb␋",
	}, { // 4553
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞\x00␓<ψKχb␋",
		out:  "o\x0f＿ψ\aπ＇ＱｊＹ\vφ［Ｈ\nＱ)␛φfA＞␀␓<ψKχb‛␋",
	}, { // 4554
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
	}, { // 4555
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
		out:  "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
	}, { // 4556
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
		out:  "␍␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
	}, { // 4557
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
	}, { // 4558
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
		out:  "␍１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
	}, { // 4559
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␍",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19‛␍",
	}, { // 4560
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␍",
		out:  "␍１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19‛␍",
	}, { // 4561
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r\rπbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
		out:  "\r\rπbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
	}, { // 4562
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
		out:  "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␗",
	}, { // 4563
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r\rπbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
		out:  "\r\rπbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
	}, { // 4564
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
		out:  "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
	}, { // 4565
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r\rπbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␍",
		out:  "\r\rπbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19‛␍",
	}, { // 4566
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␍",
		out:  "\r␍πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19‛␍",
	}, { // 4567
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\r␗",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\r␗",
	}, { // 4568
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␗",
	}, { // 4569
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\r␍",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\r‛␍",
	}, { // 4570
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍␍",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ␍‛␍",
	}, { // 4571
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19\r",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␍",
	}, { // 4572
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19␍",
		out:  "\r１πbζX～$ｙ␖\rh＂\"／Ｎ#ζ５␖Ｍκςy␘k\x19υ\x19‛␍",
	}, { // 4573
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
		out:  "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
	}, { // 4574
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
		out:  "\t␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
	}, { // 4575
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
		out:  "␉␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
	}, { // 4576
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
		out:  "\t３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
	}, { // 4577
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
		out:  "␉３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
	}, { // 4578
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈␉",
		out:  "\t３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈‛␉",
	}, { // 4579
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈␉",
		out:  "␉３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈‛␉",
	}, { // 4580
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］\tιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
		out:  "］\tιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
	}, { // 4581
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
		out:  "］␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈δ",
	}, { // 4582
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］\tιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
		out:  "］\tιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
	}, { // 4583
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
		out:  "］␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
	}, { // 4584
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］\tιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈␉",
		out:  "］\tιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈‛␉",
	}, { // 4585
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈␉",
		out:  "］␉ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈‛␉",
	}, { // 4586
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅\tδ",
		out:  "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅\tδ",
	}, { // 4587
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
		out:  "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉δ",
	}, { // 4588
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅\t␉",
		out:  "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅\t‛␉",
	}, { // 4589
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉␉",
		out:  "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␉‛␉",
	}, { // 4590
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈\t",
		out:  "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈␉",
	}, { // 4591
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈␉",
		out:  "］３ιφ*，?]\x0fυ\t％dX)Sγω／<␂\uff00␋\a２\n\r␅␈‛␉",
	}, { // 4592
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
		out:  "␎␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
	}, { // 4593
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
		out:  "\n␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
	}, { // 4594
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
		out:  "␊␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
	}, { // 4595
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
		out:  "\n␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
	}, { // 4596
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
		out:  "␊␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
	}, { // 4597
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝␊",
		out:  "\n␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝‛␊",
	}, { // 4598
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝␊",
		out:  "␊␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝‛␊",
	}, { // 4599
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\n\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
		out:  "␎\n\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
	}, { // 4600
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
		out:  "␎␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝ο",
	}, { // 4601
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\n\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
		out:  "␎\n\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
	}, { // 4602
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
		out:  "␎␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
	}, { // 4603
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\n\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝␊",
		out:  "␎\n\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝‛␊",
	}, { // 4604
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝␊",
		out:  "␎␊\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝‛␊",
	}, { // 4605
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄\nο",
		out:  "␎␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄\nο",
	}, { // 4606
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
		out:  "␎␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊ο",
	}, { // 4607
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄\n␊",
		out:  "␎␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄\n‛␊",
	}, { // 4608
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊␊",
		out:  "␎␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄␊‛␊",
	}, { // 4609
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝\n",
		out:  "␎␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝␊",
	}, { // 4610
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␎\x7f\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝␊",
		out:  "␎␡\a＿ｈaMζρο\nεO％␄\x10１[yρ␕/␇c\x03␊,＄＝‛␊",
	}, { // 4611
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
		out:  "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
	}, { // 4612
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
		out:  "\v␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
	}, { // 4613
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
		out:  "␋␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
	}, { // 4614
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
		out:  "\v␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
	}, { // 4615
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
		out:  "␋␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
	}, { // 4616
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␋",
		out:  "\v␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f‛␋",
	}, { // 4617
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␋",
		out:  "␋␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f‛␋",
	}, { // 4618
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ\v/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
		out:  "ｏ\v/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
	}, { // 4619
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
		out:  "ｏ␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␃",
	}, { // 4620
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ\v/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
		out:  "ｏ\v/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
	}, { // 4621
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
		out:  "ｏ␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
	}, { // 4622
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ\v/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␋",
		out:  "ｏ\v/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f‛␋",
	}, { // 4623
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␋",
		out:  "ｏ␋/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f‛␋",
	}, { // 4624
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\v␃",
		out:  "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\v␃",
	}, { // 4625
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
		out:  "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␃",
	}, { // 4626
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\v␋",
		out:  "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\v‛␋",
	}, { // 4627
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋␋",
		out:  "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π␋‛␋",
	}, { // 4628
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f\v",
		out:  "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␋",
	}, { // 4629
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f␋",
		out:  "ｏ␜/＄＄ιｓξＵ\a\vε|T#ｔpＬ4␑␛WζφＦ\x13\x19π\x0f‛␋",
	}, { // 4630
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␁",
		out:  "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ␁",
	}, { // 4631
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␁",
		out:  "\r␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ␁",
	}, { // 4632
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␁",
		out:  "␍␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ␁",
	}, { // 4633
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\rｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$␍␁",
		out:  "\rｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$␍␁",
	}, { // 4634
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍ｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$␍␁",
		out:  "␍ｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$␍␁",
	}, { // 4635
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\rｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␍",
		out:  "\rｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ‛␍",
	}, { // 4636
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍ｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␍",
		out:  "␍ｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ‛␍",
	}, { // 4637
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Q\r=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␁",
		out:  "Q\r=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ␁",
	}, { // 4638
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Q␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␁",
		out:  "Q␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ␁",
	}, { // 4639
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Q\r=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$␍␁",
		out:  "Q\r=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$␍␁",
	}, { // 4640
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Q␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$␍␁",
		out:  "Q␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$␍␁",
	}, { // 4641
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Q\r=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␍",
		out:  "Q\r=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ‛␍",
	}, { // 4642
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Q␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␍",
		out:  "Q␍=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ‛␍",
	}, { // 4643
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$\r␁",
		out:  "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$\r␁",
	}, { // 4644
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$␍␁",
		out:  "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$␍␁",
	}, { // 4645
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$\r␍",
		out:  "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$\r‛␍",
	}, { // 4646
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$␍␍",
		out:  "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$␍‛␍",
	}, { // 4647
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ\r",
		out:  "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ␍",
	}, { // 4648
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ\x00␊ｄ$ζ␍",
		out:  "Qｎ=πα\x1b\x0f␑#＾\rσ␖π＾\x02\x14R␇?υ_；ｅ␀␊ｄ$ζ‛␍",
	}, { // 4649
		mask: EncodeLeftSpace,
		in:   "  ",
		out:  "␠ ",
	}, { // 4650
		mask: EncodeLeftPeriod,
		in:   "..",
		out:  "．.",
	}, { // 4651
		mask: EncodeLeftTilde,
		in:   "~~",
		out:  "～~",
	}, { // 4652
		mask: EncodeRightSpace,
		in:   "  ",
		out:  " ␠",
	}, { // 4653
		mask: EncodeRightPeriod,
		in:   "..",
		out:  ".．",
	}, { // 4654
		mask: EncodeLeftSpace | EncodeRightPeriod,
		in:   " .",
		out:  "␠．",
	}, { // 4655
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 4656
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "  ",
		out:  "␠␠",
	}, { // 4657
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "   ",
		out:  "␠ ␠",
	}, { // 4658
		mask: EncodeLeftPeriod | EncodeRightPeriod,
		in:   "...",
		out:  "．.．",
	}, { // 4659
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a. ",
		out:  "a.␠",
	}, { // 4660
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a .",
		out:  "a ．",
	},
}

var testCasesDoubleEdge = []testCase{
	{ // 0
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .／ｌｃ６>\"␃@οκｖ\tu␀#Ｔκ␉\n＞E\x0eW＃gχ.π",
		out:  "␠.／ｌｃ６>\"␃@οκｖ\tu‛␀#Ｔκ␉\n＞E\x0eW＃gχ.π",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.／ｌｃ６>\"␃@οκｖ\tu␀#Ｔκ␉\n＞E\x0eW＃gχ.π",
		out:  "‛␠.／ｌｃ６>\"␃@οκｖ\tu‛␀#Ｔκ␉\n＞E\x0eW＃gχ.π",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "$.／ｌｃ６>\"␃@οκｖ\tu␀#Ｔκ␉\n＞E\x0eW＃gχ. ",
		out:  "$.／ｌｃ６>\"␃@οκｖ\tu‛␀#Ｔκ␉\n＞E\x0eW＃gχ. ",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "$.／ｌｃ６>\"␃@οκｖ\tu␀#Ｔκ␉\n＞E\x0eW＃gχ.␠",
		out:  "$.／ｌｃ６>\"␃@οκｖ\tu‛␀#Ｔκ␉\n＞E\x0eW＃gχ.␠",
	}, { // 4
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\n\x1eδＶ2␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs.｝",
		out:  "␠.\n\x1eδＶ2‛␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs.｝",
	}, { // 5
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\n\x1eδＶ2␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs.｝",
		out:  "‛␠.\n\x1eδＶ2‛␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs.｝",
	}, { // 6
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "C.\n\x1eδＶ2␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs. ",
		out:  "C.\n\x1eδＶ2‛␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs. ",
	}, { // 7
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "C.\n\x1eδＶ2␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs.␠",
		out:  "C.\n\x1eδＶ2‛␀t；!␐ＫＯsφ\x7fＱ␛@？'\x03␔σξＹs.␠",
	}, { // 8
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：␀ε\x01Gμ␃υW␈A.ｏ",
		out:  "␠.ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：‛␀ε\x01Gμ␃υW␈A.ｏ",
	}, { // 9
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：␀ε\x01Gμ␃υW␈A.ｏ",
		out:  "‛␠.ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：‛␀ε\x01Gμ␃υW␈A.ｏ",
	}, { // 10
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x02.ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：␀ε\x01Gμ␃υW␈A. ",
		out:  "\x02.ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：‛␀ε\x01Gμ␃υW␈A. ",
	}, { // 11
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x02.ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：␀ε\x01Gμ␃υW␈A.␠",
		out:  "\x02.ｘ：$ξ|␋m＂γ！５A\a\x19ｌ：‛␀ε\x01Gμ␃υW␈A.␠",
	}, { // 12
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .I\x00＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+.９",
		out:  "␠.I␀＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+.９",
	}, { // 13
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.I\x00＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+.９",
		out:  "‛␠.I␀＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+.９",
	}, { // 14
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "α.I\x00＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+. ",
		out:  "α.I␀＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+. ",
	}, { // 15
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "α.I\x00＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+.␠",
		out:  "α.I␀＝｝σ＃π＂#＿>?\x17\x18␁␄＇;οh␃Ｘ\x0es／+.␠",
	}, { // 16
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␀ζWγ}ａ\x18<#χ]ψβ␘＞\x13␗＝M␘λ\"：%␘#.'",
		out:  "␠.‛␀ζWγ}ａ\x18＜#χ]ψβ␘‛＞\x13␗＝M␘λ\"：%␘#.'",
	}, { // 17
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␀ζWγ}ａ\x18<#χ]ψβ␘＞\x13␗＝M␘λ\"：%␘#.'",
		out:  "‛␠.‛␀ζWγ}ａ\x18＜#χ]ψβ␘‛＞\x13␗＝M␘λ\"：%␘#.'",
	}, { // 18
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␊.␀ζWγ}ａ\x18<#χ]ψβ␘＞\x13␗＝M␘λ\"：%␘#. ",
		out:  "␊.‛␀ζWγ}ａ\x18＜#χ]ψβ␘‛＞\x13␗＝M␘λ\"：%␘#. ",
	}, { // 19
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␊.␀ζWγ}ａ\x18<#χ]ψβ␘＞\x13␗＝M␘λ\"：%␘#.␠",
		out:  "␊.‛␀ζWγ}ａ\x18＜#χ]ψβ␘‛＞\x13␗＝M␘λ\"：%␘#.␠",
	}, { // 20
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16.\t",
		out:  "␠.ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16.\t",
	}, { // 21
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16.\t",
		out:  "‛␠.ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16.\t",
	}, { // 22
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "｝.ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16. ",
		out:  "｝.ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16. ",
	}, { // 23
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "｝.ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16.␠",
		out:  "｝.ασs$␖ＮXπ\x06｜ＥUm？χＹη␓；\"␟Ｈ\bDι\x16.␠",
	}, { // 24
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃␀ζｖ␆ｉ／.h",
		out:  "␠.\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃‛␀ζｖ␆ｉ／.h",
	}, { // 25
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃␀ζｖ␆ｉ／.h",
		out:  "‛␠.\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃‛␀ζｖ␆ｉ／.h",
	}, { // 26
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "*.\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃␀ζｖ␆ｉ／. ",
		out:  "*.\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃‛␀ζｖ␆ｉ／. ",
	}, { // 27
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "*.\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃␀ζｖ␆ｉ／.␠",
		out:  "*.\vγ.p>\\ρ－η}␄Ｉσ\x1eＤ<ｆο｜␃‛␀ζｖ␆ｉ／.␠",
	}, { // 28
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ.ｕ",
		out:  "␠.＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ.ｕ",
	}, { // 29
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ.ｕ",
		out:  "‛␠.＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ.ｕ",
	}, { // 30
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␎.＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ. ",
		out:  "␎.＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ. ",
	}, { // 31
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␎.＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ.␠",
		out:  "␎.＼＼｜］ψ>6\x18５*\vδ\nυ^>１a％\x7fγψ［M\x01κ.␠",
	}, { // 32
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8.␓",
		out:  "␠.］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8.␓",
	}, { // 33
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8.␓",
		out:  "‛␠.］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8.␓",
	}, { // 34
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "|.］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8. ",
		out:  "|.］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8. ",
	}, { // 35
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "|.］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8.␠",
		out:  "|.］γ]'）ς9φ␎＞\x04Ｈ\rW␏[s␅␊\x1cｃμ\x02，μ8.␠",
	}, { // 36
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^.～",
		out:  "␠.␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^.～",
	}, { // 37
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^.～",
		out:  "‛␠.␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^.～",
	}, { // 38
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＞.␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^. ",
		out:  "＞.␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^. ",
	}, { // 39
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＞.␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^.␠",
		out:  "＞.␕%ι?ｇ＼.／θ$ｕγ／αν\x06%␈HιJＷU\x0e\x16^.␠",
	}, { // 40
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .Ｑμ>５γＪ\x00μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ.g",
		out:  "␠.Ｑμ>５γＪ␀μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ.g",
	}, { // 41
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.Ｑμ>５γＪ\x00μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ.g",
		out:  "‛␠.Ｑμ>５γＪ␀μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ.g",
	}, { // 42
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␕.Ｑμ>５γＪ\x00μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ. ",
		out:  "␕.Ｑμ>５γＪ␀μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ. ",
	}, { // 43
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␕.Ｑμ>５γＪ\x00μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ.␠",
		out:  "␕.Ｑμ>５γＪ␀μ␍Ｗ␙␁Su␛mJ\x18ςsＳβ\x05[λＸ.␠",
	}, { // 44
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<.［",
		out:  "␠.Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<.［",
	}, { // 45
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<.［",
		out:  "‛␠.Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<.［",
	}, { // 46
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "s.Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<. ",
		out:  "s.Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<. ",
	}, { // 47
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "s.Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<.␠",
		out:  "s.Iｈ\a８！$ψ＄N％τｆ␘ρ｀\x1d\x7f\x1bςς{␋５␖\x11<.␠",
	}, { // 48
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε␀＾?.␝",
		out:  "␠.ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε‛␀＾?.␝",
	}, { // 49
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε␀＾?.␝",
		out:  "‛␠.ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε‛␀＾?.␝",
	}, { // 50
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "!.ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε␀＾?. ",
		out:  "!.ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε‛␀＾?. ",
	}, { // 51
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "!.ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε␀＾?.␠",
		out:  "!.ｂ)ω［＂α\x06$\v\x1cｕ｜!ｒοV␉ηφ?ｄ｜ε‛␀＾?.␠",
	}, { // 52
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e.ｇ",
		out:  "␠.␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e.ｇ",
	}, { // 53
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e.ｇ",
		out:  "‛␠.␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e.ｇ",
	}, { // 54
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␈.␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e. ",
		out:  "␈.␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e. ",
	}, { // 55
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␈.␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e.␠",
		out:  "␈.␍␚␇\x04\x05％\tςχζ?W␆ＴL｛ρωπI0Ｎ>fL\x0e.␠",
	}, { // 56
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃.Ｘ",
		out:  "␠.ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃.Ｘ",
	}, { // 57
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃.Ｘ",
		out:  "‛␠.ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃.Ｘ",
	}, { // 58
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␛.ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃. ",
		out:  "␛.ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃. ",
	}, { // 59
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␛.ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃.␠",
		out:  "␛.ｒδI\t\x7fuδＤ3ω␙ｇY\b１σ\x15γ␞e*\x06␘＼ω␃.␠",
	}, { // 60
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v.J",
		out:  "␠.κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v.J",
	}, { // 61
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v.J",
		out:  "‛␠.κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v.J",
	}, { // 62
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "φ.κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v. ",
		out:  "φ.κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v. ",
	}, { // 63
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "φ.κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v.␠",
		out:  "φ.κ＜＼␈\x15\x0f］\x15ερ：，τＸq␒eC␛\x1bｚ.G！ｓ\v.␠",
	}, { // 64
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:.ｋ",
		out:  "␠.ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:.ｋ",
	}, { // 65
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:.ｋ",
		out:  "‛␠.ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:.ｋ",
	}, { // 66
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "/.ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:. ",
		out:  "/.ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:. ",
	}, { // 67
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "/.ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:.␠",
		out:  "/.ρ！Ｘβ␄1␕ＯfM␍Ｂ/\a\x14ωMηｂ#ο％\x06，ε:.␠",
	}, { // 68
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq.\x19",
		out:  "␠.\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq.\x19",
	}, { // 69
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq.\x19",
		out:  "‛␠.\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq.\x19",
	}, { // 70
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1b.\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq. ",
		out:  "\x1b.\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq. ",
	}, { // 71
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x1b.\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq.␠",
		out:  "\x1b.\vχ\x13ω；．λ＜／3pS␚τ\vＷ␂ｈρEγ｜␗ＸＳq.␠",
	}, { // 72
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃.\x1b",
		out:  "␠.#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃.\x1b",
	}, { // 73
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃.\x1b",
		out:  "‛␠.#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃.\x1b",
	}, { // 74
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "$.#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃. ",
		out:  "$.#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃. ",
	}, { // 75
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "$.#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃.␠",
		out:  "$.#＄υ␈dλＺ,\vωｚ\x18Ｋ！\v＃ςL｜＊\x0f:␙οτ＃.␠",
	}, { // 76
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .Ｓτ␉lSOγ␑\x01ψ\x11８＾␟］γ~>Lκηc\n\x1f｀Ｙ.＄",
		out:  "␠.Ｓτ‛␉lSOγ‛␑␁ψ␑８＾‛␟］γ~>Lκηc␊␟｀Ｙ.＄",
	}, { // 77
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.Ｓτ␉lSOγ␑\x01ψ\x11８＾␟］γ~>Lκηc\n\x1f｀Ｙ.＄",
		out:  "‛␠.Ｓτ‛␉lSOγ‛␑␁ψ␑８＾‛␟］γ~>Lκηc␊␟｀Ｙ.＄",
	}, { // 78
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x16.Ｓτ␉lSOγ␑\x01ψ\x11８＾␟］γ~>Lκηc\n\x1f｀Ｙ. ",
		out:  "␖.Ｓτ‛␉lSOγ‛␑␁ψ␑８＾‛␟］γ~>Lκηc␊␟｀Ｙ. ",
	}, { // 79
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x16.Ｓτ␉lSOγ␑\x01ψ\x11８＾␟］γ~>Lκηc\n\x1f｀Ｙ.␠",
		out:  "␖.Ｓτ‛␉lSOγ‛␑␁ψ␑８＾‛␟］γ~>Lκηc␊␟｀Ｙ.␠",
	}, { // 80
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~ｚ",
		out:  "␠~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~ｚ",
	}, { // 81
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~ｚ",
		out:  "‛␠~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~ｚ",
	}, { // 82
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ξ~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~ ",
		out:  "ξ~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~ ",
	}, { // 83
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ξ~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~␠",
		out:  "ξ~r7φλQ｜Ｑ＜␃ρ␊\x1e\x0fu＊\uff00＊␚～␛ζ!\x1f\x16;ψ~␠",
	}, { // 84
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ＰY%yＣ=［＿ς\x1c␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔/J~ο",
		out:  "␠~ＰY%yＣ=［＿ς\x1c‛␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔／J~ο",
	}, { // 85
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ＰY%yＣ=［＿ς\x1c␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔/J~ο",
		out:  "‛␠~ＰY%yＣ=［＿ς\x1c‛␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔／J~ο",
	}, { // 86
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｅ~ＰY%yＣ=［＿ς\x1c␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔/J~ ",
		out:  "ｅ~ＰY%yＣ=［＿ς\x1c‛␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔／J~ ",
	}, { // 87
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｅ~ＰY%yＣ=［＿ς\x1c␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔/J~␠",
		out:  "ｅ~ＰY%yＣ=［＿ς\x1c‛␀８\x1e␊\bbＪψ\x13␊\x18ςτ␔／J~␠",
	}, { // 88
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~]",
		out:  "␠~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~]",
	}, { // 89
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~]",
		out:  "‛␠~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~]",
	}, { // 90
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｈ~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~ ",
		out:  "Ｈ~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~ ",
	}, { // 91
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｈ~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~␠",
		out:  "Ｈ~ψκ.␕ω␛\x05␝z＃ν\rＫ|}ＷＭ␇\b\x11␄.３／αδ~␠",
	}, { // 92
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~\x7f",
		out:  "␠~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~\x7f",
	}, { // 93
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~\x7f",
		out:  "‛␠~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~\x7f",
	}, { // 94
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "８~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~ ",
		out:  "８~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~ ",
	}, { // 95
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "８~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~␠",
		out:  "８~＃？οβ＊Ａα＂kgＫ＼λj!␊\x17θ＿:\x1c\x04\x1b␝Y␅~␠",
	}, { // 96
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~αξ／\x02\x06０␕2［␍ｖ＜\x11\x1e␃`ξt`/，κ>｝/@~σ",
		out:  "␠~αξ／\x02\x06０␕2［␍ｖ‛＜\x11\x1e␃`ξt`/，κ＞｝/@~σ",
	}, { // 97
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~αξ／\x02\x06０␕2［␍ｖ＜\x11\x1e␃`ξt`/，κ>｝/@~σ",
		out:  "‛␠~αξ／\x02\x06０␕2［␍ｖ‛＜\x11\x1e␃`ξt`/，κ＞｝/@~σ",
	}, { // 98
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＃~αξ／\x02\x06０␕2［␍ｖ＜\x11\x1e␃`ξt`/，κ>｝/@~ ",
		out:  "＃~αξ／\x02\x06０␕2［␍ｖ‛＜\x11\x1e␃`ξt`/，κ＞｝/@~ ",
	}, { // 99
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＃~αξ／\x02\x06０␕2［␍ｖ＜\x11\x1e␃`ξt`/，κ>｝/@~␠",
		out:  "＃~αξ／\x02\x06０␕2［␍ｖ‛＜\x11\x1e␃`ξt`/，κ＞｝/@~␠",
	}, { // 100
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ｑy：X'\x00␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~７",
		out:  "␠~ｑy：X'␀␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~７",
	}, { // 101
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ｑy：X'\x00␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~７",
		out:  "‛␠~ｑy：X'␀␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~７",
	}, { // 102
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ν~ｑy：X'\x00␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~ ",
		out:  "ν~ｑy：X'␀␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~ ",
	}, { // 103
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ν~ｑy：X'\x00␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~␠",
		out:  "ν~ｑy：X'␀␉｜O\x15>\r'ｎα!␂␉$（＂<βγ␜ζ~␠",
	}, { // 104
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~␐",
		out:  "␠~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~␐",
	}, { // 105
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~␐",
		out:  "‛␠~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~␐",
	}, { // 106
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␟~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~ ",
		out:  "␟~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~ ",
	}, { // 107
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␟~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~␠",
		out:  "␟~␔$＊ｓｚφJζ#␁Eη9␌οτ?αHc/，Ｇｋ＃\r~␠",
	}, { // 108
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ｓωｃδσF］/！％９␡[φd\rｋςｗ␔b|\x14G2＇~ξ",
		out:  "␠~ｓωｃδσF］/‛！％９␡[φd\rｋςｗ␔b|\x14G2＇~ξ",
	}, { // 109
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ｓωｃδσF］/！％９␡[φd\rｋςｗ␔b|\x14G2＇~ξ",
		out:  "‛␠~ｓωｃδσF］/‛！％９␡[φd\rｋςｗ␔b|\x14G2＇~ξ",
	}, { // 110
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＜~ｓωｃδσF］/！％９␡[φd\rｋςｗ␔b|\x14G2＇~ ",
		out:  "＜~ｓωｃδσF］/‛！％９␡[φd\rｋςｗ␔b|\x14G2＇~ ",
	}, { // 111
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＜~ｓωｃδσF］/！％９␡[φd\rｋςｗ␔b|\x14G2＇~␠",
		out:  "＜~ｓωｃδσF］/‛！％９␡[φd\rｋςｗ␔b|\x14G2＇~␠",
	}, { // 112
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~\n",
		out:  "␠~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~\n",
	}, { // 113
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~\n",
		out:  "‛␠~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~\n",
	}, { // 114
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｑ~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~ ",
		out:  "Ｑ~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~ ",
	}, { // 115
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｑ~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~␠",
		out:  "Ｑ~!l␍\x04]βXγ－␃Ｋ␗␑>l３φ␉\aβｑ＇φ１σ+~␠",
	}, { // 116
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~\r",
		out:  "␠~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~\r",
	}, { // 117
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~\r",
		out:  "‛␠~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~\r",
	}, { // 118
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＃~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~ ",
		out:  "＃~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~ ",
	}, { // 119
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＃~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~␠",
		out:  "＃~：\rｍ%／\x14␆］ｍβ␄␌A？θａ9ν|>RAkςο␟~␠",
	}, { // 120
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~\x1f",
		out:  "␠~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~\x1f",
	}, { // 121
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~\x1f",
		out:  "‛␠~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~\x1f",
	}, { // 122
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｖ~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~ ",
		out:  "ｖ~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~ ",
	}, { // 123
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｖ~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~␠",
		out:  "ｖ~ｌ7Ｕv＇H\x15＋t＊！Ｓβω\r>␉␗ζυξ\x0eX\x7f\f␄~␠",
	}, { // 124
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~η",
		out:  "␠~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~η",
	}, { // 125
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~η",
		out:  "‛␠~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~η",
	}, { // 126
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␍~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~ ",
		out:  "␍~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~ ",
	}, { // 127
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␍~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~␠",
		out:  "␍~Uuｊ␓`␕␉＝τP␉ｕο\x14Ｘ\x10\v／βγ'!＼ξ}L~␠",
	}, { // 128
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ*\x1e>};%θγ~N~Ｄ",
		out:  "␠~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ＊\x1e>};%θγ~N~Ｄ",
	}, { // 129
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ*\x1e>};%θγ~N~Ｄ",
		out:  "‛␠~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ＊\x1e>};%θγ~N~Ｄ",
	}, { // 130
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "f~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ*\x1e>};%θγ~N~ ",
		out:  "f~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ＊\x1e>};%θγ~N~ ",
	}, { // 131
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "f~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ*\x1e>};%θγ~N~␠",
		out:  "f~␗ω：＇Ｆ␋|＇＞␓]νεｅｗＦ＊\x1e>};%θγ~N~␠",
	}, { // 132
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~␃",
		out:  "␠~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~␃",
	}, { // 133
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~␃",
		out:  "‛␠~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~␃",
	}, { // 134
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "β~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~ ",
		out:  "β~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~ ",
	}, { // 135
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "β~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~␠",
		out:  "β~␁\x18κP~␉ＱsＩτ<ｋ␘ｐωξ/A＂Ｖ［v'α␐5~␠",
	}, { // 136
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~σ",
		out:  "␠~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~σ",
	}, { // 137
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~σ",
		out:  "‛␠~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~σ",
	}, { // 138
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｌ~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~ ",
		out:  "Ｌ~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~ ",
	}, { // 139
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ｌ~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~␠",
		out:  "Ｌ~Cν?\\＼\x03ψ␂Ｎς＂j＞/`\x12ψN\nπＬ␐␂[｛］~␠",
	}, { // 140
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'％Ｋz~8",
		out:  "␠~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'‛％Ｋz~8",
	}, { // 141
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'％Ｋz~8",
		out:  "‛␠~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'‛％Ｋz~8",
	}, { // 142
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␊~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'％Ｋz~ ",
		out:  "␊~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'‛％Ｋz~ ",
	}, { // 143
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␊~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'％Ｋz~␠",
		out:  "␊~μ␘＂zL`\x19θοε８␚␙Ｗβ＄\r/μLoｍ'‛％Ｋz~␠",
	}, { // 144
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~␍",
		out:  "␠~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~␍",
	}, { // 145
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~␍",
		out:  "‛␠~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~␍",
	}, { // 146
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x1d~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~ ",
		out:  "\x1d~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~ ",
	}, { // 147
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x1d~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~␠",
		out:  "\x1d~!γＶIｆκ␜｛EＬπＪ␐2\x7fＶζφ＇␂|gPι'\r~␠",
	}, { // 148
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~␞",
		out:  "␠~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~␞",
	}, { // 149
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~␞",
		out:  "‛␠~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~␞",
	}, { // 150
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "&~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~ ",
		out:  "&~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~ ",
	}, { // 151
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "&~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~␠",
		out:  "&~ζｌE$dBι｜`␒ｄ＇tｇ␅％*ο？φβψx％］\v~␠",
	}, { // 152
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~κ",
		out:  "␠~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~κ",
	}, { // 153
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~κ",
		out:  "‛␠~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~κ",
	}, { // 154
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   ":~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~ ",
		out:  ":~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~ ",
	}, { // 155
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   ":~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~␠",
		out:  ":~８)D/\bｍν\\］bε␗'\nξ}Ｔ␊：ｆτ␛␋ｕ?λ~␠",
	}, { // 156
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~`－：／␆μδL］␏τ｀%Ｒ[n␔γ\rZ＼:μ｛\x18S~/",
		out:  "␠~`－：／‛␆μδL］‛␏τ｀%Ｒ[n‛␔γ␍Z＼:μ｛␘S~/",
	}, { // 157
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~`－：／␆μδL］␏τ｀%Ｒ[n␔γ\rZ＼:μ｛\x18S~/",
		out:  "‛␠~`－：／‛␆μδL］‛␏τ｀%Ｒ[n‛␔γ␍Z＼:μ｛␘S~/",
	}, { // 158
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "d~`－：／␆μδL］␏τ｀%Ｒ[n␔γ\rZ＼:μ｛\x18S~ ",
		out:  "d~`－：／‛␆μδL］‛␏τ｀%Ｒ[n‛␔γ␍Z＼:μ｛␘S~ ",
	}, { // 159
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "d~`－：／␆μδL］␏τ｀%Ｒ[n␔γ\rZ＼:μ｛\x18S~␠",
		out:  "d~`－：／‛␆μδL］‛␏τ｀%Ｒ[n‛␔γ␍Z＼:μ｛␘S~␠",
	}, { // 160
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t＊",
		out:  "␠\t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t＊",
	}, { // 161
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t＊",
		out:  "‛␠\t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t＊",
	}, { // 162
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n＊",
		out:  "␠\n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n＊",
	}, { // 163
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n＊",
		out:  "‛␠\n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n＊",
	}, { // 164
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v＊",
		out:  "␠\v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v＊",
	}, { // 165
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v＊",
		out:  "‛␠\v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v＊",
	}, { // 166
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r＊",
		out:  "␠\r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r＊",
	}, { // 167
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r＊",
		out:  "‛␠\r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r＊",
	}, { // 168
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t ",
		out:  "ρ\t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t ",
	}, { // 169
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t␠",
		out:  "ρ\t＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\t␠",
	}, { // 170
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n ",
		out:  "ρ\n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n ",
	}, { // 171
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n␠",
		out:  "ρ\n＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\n␠",
	}, { // 172
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v ",
		out:  "ρ\v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v ",
	}, { // 173
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v␠",
		out:  "ρ\v＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\v␠",
	}, { // 174
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r ",
		out:  "ρ\r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r ",
	}, { // 175
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ρ\r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r␠",
		out:  "ρ\r＄ｘ/$｀Frη`|］＝␇␝λ\x1bδ\x12ζ\"␋␊υ；\tW\r␠",
	}, { // 176
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\ty",
		out:  "␠\tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\ty",
	}, { // 177
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\ty",
		out:  "‛␠\tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\ty",
	}, { // 178
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\ny",
		out:  "␠\nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\ny",
	}, { // 179
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\ny",
		out:  "‛␠\nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\ny",
	}, { // 180
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\vy",
		out:  "␠\vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\vy",
	}, { // 181
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\vy",
		out:  "‛␠\vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\vy",
	}, { // 182
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\ry",
		out:  "␠\rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\ry",
	}, { // 183
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\ry",
		out:  "‛␠\rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\ry",
	}, { // 184
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\t ",
		out:  "l\tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\t ",
	}, { // 185
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\t␠",
		out:  "l\tｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\t␠",
	}, { // 186
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\n ",
		out:  "l\nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\n ",
	}, { // 187
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\n␠",
		out:  "l\nｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\n␠",
	}, { // 188
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\v ",
		out:  "l\vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\v ",
	}, { // 189
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\v␠",
		out:  "l\vｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\v␠",
	}, { // 190
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\r ",
		out:  "l\rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\r ",
	}, { // 191
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "l\rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅／/\r␠",
		out:  "l\rｃ［ι\x01'ιｆ[｝eG｝␝Aηψκ\x12␛＂\f{＊␅‛／／\r␠",
	}, { // 192
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\tG",
		out:  "␠\t\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\tG",
	}, { // 193
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\tG",
		out:  "‛␠\t\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\tG",
	}, { // 194
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\nG",
		out:  "␠\n\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\nG",
	}, { // 195
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\nG",
		out:  "‛␠\n\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\nG",
	}, { // 196
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\vG",
		out:  "␠\v\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\vG",
	}, { // 197
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\vG",
		out:  "‛␠\v\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\vG",
	}, { // 198
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\rG",
		out:  "␠\r\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\rG",
	}, { // 199
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\rG",
		out:  "‛␠\r\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\rG",
	}, { // 200
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\t\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\t ",
		out:  "｜\t\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\t ",
	}, { // 201
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\t\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\t␠",
		out:  "｜\t\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\t␠",
	}, { // 202
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\n\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\n ",
		out:  "｜\n\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\n ",
	}, { // 203
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\n\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\n␠",
		out:  "｜\n\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\n␠",
	}, { // 204
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\v\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\v ",
		out:  "｜\v\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\v ",
	}, { // 205
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\v\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\v␠",
		out:  "｜\v\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\v␠",
	}, { // 206
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\r\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\r ",
		out:  "｜\r\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\r ",
	}, { // 207
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "｜\r\"\x1a＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\r␠",
		out:  "｜\r\"\x1a‛＇7>＝＜sιθ４\x14\x17g␉^␓␂_ιｇγ！Ｊ␙ο\r␠",
	}, { // 208
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t７",
		out:  "␠\t‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t７",
	}, { // 209
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t７",
		out:  "‛␠\t‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t７",
	}, { // 210
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n７",
		out:  "␠\n‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n７",
	}, { // 211
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n７",
		out:  "‛␠\n‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n７",
	}, { // 212
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v７",
		out:  "␠\v‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v７",
	}, { // 213
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v７",
		out:  "‛␠\v‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v７",
	}, { // 214
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r７",
		out:  "␠\r‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r７",
	}, { // 215
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r７",
		out:  "‛␠\r‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r７",
	}, { // 216
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\t｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t ",
		out:  "σ\t‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t ",
	}, { // 217
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\t｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t␠",
		out:  "σ\t‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\t␠",
	}, { // 218
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\n｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n ",
		out:  "σ\n‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n ",
	}, { // 219
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\n｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n␠",
		out:  "σ\n‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\n␠",
	}, { // 220
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\v｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v ",
		out:  "σ\v‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v ",
	}, { // 221
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\v｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v␠",
		out:  "σ\v‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\v␠",
	}, { // 222
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\r｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r ",
		out:  "σ\r‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r ",
	}, { // 223
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "σ\r｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r␠",
		out:  "σ\r‛｀<Ｓ\uff009}\rξυ␛＂θλ[/\x19$Ｏ９f␑␏τ?P&\r␠",
	}, { // 224
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\tψ",
		out:  "␠\t\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\tψ",
	}, { // 225
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\tψ",
		out:  "‛␠\t\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\tψ",
	}, { // 226
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\nψ",
		out:  "␠\n\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\nψ",
	}, { // 227
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\nψ",
		out:  "‛␠\n\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\nψ",
	}, { // 228
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\vψ",
		out:  "␠\v\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\vψ",
	}, { // 229
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\vψ",
		out:  "‛␠\v\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\vψ",
	}, { // 230
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\rψ",
		out:  "␠\r\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\rψ",
	}, { // 231
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\rψ",
		out:  "‛␠\r\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\rψ",
	}, { // 232
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\t\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\t ",
		out:  "/\t\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\t ",
	}, { // 233
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\t\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\t␠",
		out:  "/\t\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\t␠",
	}, { // 234
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\n\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\n ",
		out:  "/\n\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\n ",
	}, { // 235
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\n\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\n␠",
		out:  "/\n\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\n␠",
	}, { // 236
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\v\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\v ",
		out:  "/\v\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\v ",
	}, { // 237
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\v\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\v␠",
		out:  "/\v\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\v␠",
	}, { // 238
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\r\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\r ",
		out:  "/\r\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\r ",
	}, { // 239
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\r\r␁ο\x06/␚Ｌ］8Ｈ{＞C3φＶφ␛O＇α＞０\\\x14\x0e\r␠",
		out:  "/\r\r␁ο\x06/␚Ｌ］8Ｈ{‛＞C3φＶφ␛O＇α‛＞０\\\x14\x0e\r␠",
	}, { // 240
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\t\r",
		out:  "␠\tελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\t\r",
	}, { // 241
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\t\r",
		out:  "‛␠\tελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\t\r",
	}, { // 242
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\n\r",
		out:  "␠\nελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\n\r",
	}, { // 243
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\n\r",
		out:  "‛␠\nελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\n\r",
	}, { // 244
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\v\r",
		out:  "␠\vελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\v\r",
	}, { // 245
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\v\r",
		out:  "‛␠\vελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\v\r",
	}, { // 246
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\r\r",
		out:  "␠\rελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\r\r",
	}, { // 247
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\r\r",
		out:  "‛␠\rελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\r\r",
	}, { // 248
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\tελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\t ",
		out:  "‛␊\tελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\t ",
	}, { // 249
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\tελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\t␠",
		out:  "‛␊\tελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\t␠",
	}, { // 250
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\nελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\n ",
		out:  "‛␊\nελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\n ",
	}, { // 251
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\nελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\n␠",
		out:  "‛␊\nελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\n␠",
	}, { // 252
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\vελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\v ",
		out:  "‛␊\vελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\v ",
	}, { // 253
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\vελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\v␠",
		out:  "‛␊\vελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\v␠",
	}, { // 254
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\rελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\r ",
		out:  "‛␊\rελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\r ",
	}, { // 255
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\rελ\aiN␝３7#Z］ｃ[^／ε＿␔␀␂?␚χＦς\x19\r␠",
		out:  "‛␊\rελ\aiN␝３7#Z‛］ｃ［^／ε＿␔‛␀␂?␚χＦς\x19\r␠",
	}, { // 256
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\tζ",
		out:  "␠\ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\tζ",
	}, { // 257
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\tζ",
		out:  "‛␠\ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\tζ",
	}, { // 258
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\nζ",
		out:  "␠\ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\nζ",
	}, { // 259
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\nζ",
		out:  "‛␠\ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\nζ",
	}, { // 260
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\vζ",
		out:  "␠\vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\vζ",
	}, { // 261
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\vζ",
		out:  "‛␠\vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\vζ",
	}, { // 262
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\rζ",
		out:  "␠\rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\rζ",
	}, { // 263
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\rζ",
		out:  "‛␠\rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\rζ",
	}, { // 264
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\t ",
		out:  "χ\ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\t ",
	}, { // 265
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\t␠",
		out:  "χ\ts\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\t␠",
	}, { // 266
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\n ",
		out:  "χ\ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\n ",
	}, { // 267
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\n␠",
		out:  "χ\ns\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\n␠",
	}, { // 268
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\v ",
		out:  "χ\vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\v ",
	}, { // 269
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\v␠",
		out:  "χ\vs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\v␠",
	}, { // 270
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\r ",
		out:  "χ\rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\r ",
	}, { // 271
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "χ\rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\r␠",
		out:  "χ\rs\tb｜␑ν）␗k(π␜，A!Ｄ\uff00\x1c２\x7f|\a＼αο\x14\r␠",
	}, { // 272
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t`",
		out:  "␠\tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t`",
	}, { // 273
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t`",
		out:  "‛␠\tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t`",
	}, { // 274
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n`",
		out:  "␠\nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n`",
	}, { // 275
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n`",
		out:  "‛␠\nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n`",
	}, { // 276
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v`",
		out:  "␠\vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v`",
	}, { // 277
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v`",
		out:  "‛␠\vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v`",
	}, { // 278
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r`",
		out:  "␠\rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r`",
	}, { // 279
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r`",
		out:  "‛␠\rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r`",
	}, { // 280
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t ",
		out:  "␍\tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t ",
	}, { // 281
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t␠",
		out:  "␍\tγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\t␠",
	}, { // 282
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n ",
		out:  "␍\nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n ",
	}, { // 283
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n␠",
		out:  "␍\nγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\n␠",
	}, { // 284
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v ",
		out:  "␍\vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v ",
	}, { // 285
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v␠",
		out:  "␍\vγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\v␠",
	}, { // 286
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r ",
		out:  "␍\rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r ",
	}, { // 287
		mask: EncodeExclamation | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\r\rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r␠",
		out:  "␍\rγ＞␁Ｂ＊３␌␆\v２＼\x1dκ<τｖＭc<&<BWκσρ\r␠",
	}, { // 288
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t＜",
		out:  "␠\t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t＜",
	}, { // 289
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t＜",
		out:  "‛␠\t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t＜",
	}, { // 290
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n＜",
		out:  "␠\n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n＜",
	}, { // 291
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n＜",
		out:  "‛␠\n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n＜",
	}, { // 292
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v＜",
		out:  "␠\v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v＜",
	}, { // 293
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v＜",
		out:  "‛␠\v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v＜",
	}, { // 294
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r＜",
		out:  "␠\r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r＜",
	}, { // 295
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r＜",
		out:  "‛␠\r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r＜",
	}, { // 296
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t ",
		out:  "<\t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t ",
	}, { // 297
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t␠",
		out:  "<\t＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\t␠",
	}, { // 298
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n ",
		out:  "<\n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n ",
	}, { // 299
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n␠",
		out:  "<\n＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\n␠",
	}, { // 300
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v ",
		out:  "<\v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v ",
	}, { // 301
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v␠",
		out:  "<\v＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\v␠",
	}, { // 302
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r ",
		out:  "<\r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r ",
	}, { // 303
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "<\r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r␠",
		out:  "<\r＼＼\v\f！FXι␉␏＞ς\x0f\x1aε␛%ζＮ_Iγ'Ｈmγ\r␠",
	}, { // 304
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t]",
		out:  "␠\tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t]",
	}, { // 305
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t]",
		out:  "‛␠\tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t]",
	}, { // 306
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n]",
		out:  "␠\nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n]",
	}, { // 307
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n]",
		out:  "‛␠\nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n]",
	}, { // 308
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v]",
		out:  "␠\vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v]",
	}, { // 309
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v]",
		out:  "‛␠\vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v]",
	}, { // 310
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r]",
		out:  "␠\rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r]",
	}, { // 311
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r]",
		out:  "‛␠\rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r]",
	}, { // 312
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t ",
		out:  "8\tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t ",
	}, { // 313
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t␠",
		out:  "8\tς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\t␠",
	}, { // 314
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n ",
		out:  "8\nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n ",
	}, { // 315
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n␠",
		out:  "8\nς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\n␠",
	}, { // 316
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v ",
		out:  "8\vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v ",
	}, { // 317
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v␠",
		out:  "8\vς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\v␠",
	}, { // 318
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r ",
		out:  "8\rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r ",
	}, { // 319
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "8\rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r␠",
		out:  "8\rς;\x10\vq＞^ξ＼␓␎␑\v％Ｉο%７'ａ[1Ｐφακ\r␠",
	}, { // 320
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\t'",
		out:  "␠\tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\t'",
	}, { // 321
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\t'",
		out:  "‛␠\tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\t'",
	}, { // 322
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\n'",
		out:  "␠\nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\n'",
	}, { // 323
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\n'",
		out:  "‛␠\nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\n'",
	}, { // 324
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\v'",
		out:  "␠\vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\v'",
	}, { // 325
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\v'",
		out:  "‛␠\vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\v'",
	}, { // 326
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\r'",
		out:  "␠\rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\r'",
	}, { // 327
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\r'",
		out:  "‛␠\rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\r'",
	}, { // 328
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\t ",
		out:  "\b\tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\t ",
	}, { // 329
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\t␠",
		out:  "\b\tｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\t␠",
	}, { // 330
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\n ",
		out:  "\b\nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\n ",
	}, { // 331
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\n␠",
		out:  "\b\nｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\n␠",
	}, { // 332
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\v ",
		out:  "\b\vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\v ",
	}, { // 333
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\v␠",
		out:  "\b\vｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\v␠",
	}, { // 334
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\r ",
		out:  "\b\rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\r ",
	}, { // 335
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\b\rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ:\x0f9oο\r␠",
		out:  "\b\rｐ＋ξ.\\\x13７４@ρ%＼␅␟␛χν[Ｐ␍ψ：\x0f9oο\r␠",
	}, { // 336
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t␐",
		out:  "␠\tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t␐",
	}, { // 337
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t␐",
		out:  "‛␠\tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t␐",
	}, { // 338
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n␐",
		out:  "␠\nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n␐",
	}, { // 339
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n␐",
		out:  "‛␠\nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n␐",
	}, { // 340
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v␐",
		out:  "␠\vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v␐",
	}, { // 341
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v␐",
		out:  "‛␠\vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v␐",
	}, { // 342
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r␐",
		out:  "␠\rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r␐",
	}, { // 343
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r␐",
		out:  "‛␠\rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r␐",
	}, { // 344
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t ",
		out:  "＜\tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t ",
	}, { // 345
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t␠",
		out:  "＜\tf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\t␠",
	}, { // 346
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n ",
		out:  "＜\nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n ",
	}, { // 347
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n␠",
		out:  "＜\nf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\n␠",
	}, { // 348
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v ",
		out:  "＜\vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v ",
	}, { // 349
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v␠",
		out:  "＜\vf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\v␠",
	}, { // 350
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r ",
		out:  "＜\rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r ",
	}, { // 351
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "＜\rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r␠",
		out:  "＜\rf．`Ｃ！φ\fιｉ\n/υ\x1ey␆ζ％\"％%3ｋ␘\x15ιT\r␠",
	}, { // 352
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t２",
		out:  "␠\t/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t２",
	}, { // 353
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t２",
		out:  "‛␠\t/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t２",
	}, { // 354
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n２",
		out:  "␠\n/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n２",
	}, { // 355
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n２",
		out:  "‛␠\n/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n２",
	}, { // 356
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v２",
		out:  "␠\v/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v２",
	}, { // 357
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v２",
		out:  "‛␠\v/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v２",
	}, { // 358
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r２",
		out:  "␠\r/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r２",
	}, { // 359
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r２",
		out:  "‛␠\r/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r２",
	}, { // 360
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\t/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t ",
		out:  "\x1d\t/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t ",
	}, { // 361
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\t/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t␠",
		out:  "\x1d\t/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\t␠",
	}, { // 362
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\n/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n ",
		out:  "\x1d\n/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n ",
	}, { // 363
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\n/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n␠",
		out:  "\x1d\n/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\n␠",
	}, { // 364
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\v/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v ",
		out:  "\x1d\v/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v ",
	}, { // 365
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\v/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v␠",
		out:  "\x1d\v/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\v␠",
	}, { // 366
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\r/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r ",
		out:  "\x1d\r/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r ",
	}, { // 367
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x1d\r/ακ＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r␠",
		out:  "\x1d\r/ακ‛＊[！3＄␘δ\x0e␝\r␍b\x154␏\v␘y：Ｔβγε\r␠",
	}, { // 368
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t＇",
		out:  "␠\tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t＇",
	}, { // 369
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t＇",
		out:  "‛␠\tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t＇",
	}, { // 370
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n＇",
		out:  "␠\nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n＇",
	}, { // 371
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n＇",
		out:  "‛␠\nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n＇",
	}, { // 372
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v＇",
		out:  "␠\vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v＇",
	}, { // 373
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v＇",
		out:  "‛␠\vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v＇",
	}, { // 374
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r＇",
		out:  "␠\rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r＇",
	}, { // 375
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r＇",
		out:  "‛␠\rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r＇",
	}, { // 376
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t ",
		out:  "␅\tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t ",
	}, { // 377
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t␠",
		out:  "␅\tｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\t␠",
	}, { // 378
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n ",
		out:  "␅\nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n ",
	}, { // 379
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n␠",
		out:  "␅\nｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\n␠",
	}, { // 380
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v ",
		out:  "␅\vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v ",
	}, { // 381
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v␠",
		out:  "␅\vｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\v␠",
	}, { // 382
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r ",
		out:  "␅\rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r ",
	}, { // 383
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␅\rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r␠",
		out:  "␅\rｍＣ␍μx＾\x13dοτ／Ｋξ\x14８/\x16\x1ab ～：Zν｀>\r␠",
	}, { // 384
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\tｊ",
		out:  "␠\t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\tｊ",
	}, { // 385
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\tｊ",
		out:  "‛␠\t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\tｊ",
	}, { // 386
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\nｊ",
		out:  "␠\n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\nｊ",
	}, { // 387
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\nｊ",
		out:  "‛␠\n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\nｊ",
	}, { // 388
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\vｊ",
		out:  "␠\v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\vｊ",
	}, { // 389
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\vｊ",
		out:  "‛␠\v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\vｊ",
	}, { // 390
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\rｊ",
		out:  "␠\r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\rｊ",
	}, { // 391
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\rｊ",
		out:  "‛␠\r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\rｊ",
	}, { // 392
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\t ",
		out:  "␒\t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\t ",
	}, { // 393
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\t␠",
		out:  "␒\t␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\t␠",
	}, { // 394
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\n ",
		out:  "␒\n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\n ",
	}, { // 395
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\n␠",
		out:  "␒\n␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\n␠",
	}, { // 396
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\v ",
		out:  "␒\v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\v ",
	}, { // 397
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\v␠",
		out:  "␒\v␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\v␠",
	}, { // 398
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\r ",
		out:  "␒\r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\r ",
	}, { // 399
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␒\r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\r␠",
		out:  "␒\r␊\t｝υ\r８>Z␒δ=\x14％＜｀：\x13ι`ＮFφq\x1aGδ\r␠",
	}, { // 400
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t␞",
		out:  "␠\t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t␞",
	}, { // 401
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t␞",
		out:  "‛␠\t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t␞",
	}, { // 402
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n␞",
		out:  "␠\n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n␞",
	}, { // 403
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n␞",
		out:  "‛␠\n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n␞",
	}, { // 404
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v␞",
		out:  "␠\v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v␞",
	}, { // 405
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v␞",
		out:  "‛␠\v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v␞",
	}, { // 406
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r␞",
		out:  "␠\r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r␞",
	}, { // 407
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r␞",
		out:  "‛␠\r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r␞",
	}, { // 408
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t ",
		out:  "β\t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t ",
	}, { // 409
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t␠",
		out:  "β\t\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\t␠",
	}, { // 410
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n ",
		out:  "β\n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n ",
	}, { // 411
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n␠",
		out:  "β\n\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\n␠",
	}, { // 412
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v ",
		out:  "β\v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v ",
	}, { // 413
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v␠",
		out:  "β\v\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\v␠",
	}, { // 414
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r ",
		out:  "β\r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r ",
	}, { // 415
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r␠",
		out:  "β\r\x12ZＨ\x1aς>３．τ｀␕8γｄγ\\_9Ｋ\x1c'Z␘␕β'\r␠",
	}, { // 416
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\t\n",
		out:  "␠\t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\t\n",
	}, { // 417
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\t\n",
		out:  "‛␠\t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\t\n",
	}, { // 418
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\n\n",
		out:  "␠\n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\n\n",
	}, { // 419
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\n\n",
		out:  "‛␠\n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\n\n",
	}, { // 420
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\v\n",
		out:  "␠\v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\v\n",
	}, { // 421
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\v\n",
		out:  "‛␠\v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\v\n",
	}, { // 422
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\r\n",
		out:  "␠\r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\r\n",
	}, { // 423
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\r\n",
		out:  "‛␠\r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\r\n",
	}, { // 424
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\t ",
		out:  "ς\t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\t ",
	}, { // 425
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\t␠",
		out:  "ς\t\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\t␠",
	}, { // 426
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\n ",
		out:  "ς\n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\n ",
	}, { // 427
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\n␠",
		out:  "ς\n\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\n␠",
	}, { // 428
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\v ",
		out:  "ς\v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\v ",
	}, { // 429
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\v␠",
		out:  "ς\v\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\v␠",
	}, { // 430
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\r ",
		out:  "ς\r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\r ",
	}, { // 431
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ς\r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄＼␞\x16<␓\r␠",
		out:  "ς\r\x17\x06?＂η~θ\x1d.｜D␕ｍζ１π？␡Ｏω␄‛＼␞\x16<␓\r␠",
	}, { // 432
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t：",
		out:  "␠\t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t：",
	}, { // 433
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t：",
		out:  "‛␠\t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t：",
	}, { // 434
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n：",
		out:  "␠\n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n：",
	}, { // 435
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n：",
		out:  "‛␠\n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n：",
	}, { // 436
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v：",
		out:  "␠\v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v：",
	}, { // 437
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v：",
		out:  "‛␠\v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v：",
	}, { // 438
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r：",
		out:  "␠\r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r：",
	}, { // 439
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r：",
		out:  "‛␠\r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r：",
	}, { // 440
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t ",
		out:  "‛␊\t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t ",
	}, { // 441
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t␠",
		out:  "‛␊\t␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\t␠",
	}, { // 442
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n ",
		out:  "‛␊\n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n ",
	}, { // 443
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n␠",
		out:  "‛␊\n␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\n␠",
	}, { // 444
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v ",
		out:  "‛␊\v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v ",
	}, { // 445
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v␠",
		out:  "‛␊\v␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\v␠",
	}, { // 446
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r ",
		out:  "‛␊\r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r ",
	}, { // 447
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r␠",
		out:  "‛␊\r␟］6λ{j；＋/␆<\nξ/(␈σＩｒ/；δ－#Fχ\r␠",
	}, { // 448
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[ ␙",
		out:  "␠ ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[ ␙",
	}, { // 449
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[ ␙",
		out:  "‛␠ ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[ ␙",
	}, { // 450
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "ο ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[  ",
		out:  "ο ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[ ␠",
	}, { // 451
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "ο ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[ ␠",
		out:  "ο ｉTζ␌\a８\vＥ;ｔς␕］vhα␆/\x10[eφ＞κｎ[ ‛␠",
	}, { // 452
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ １",
		out:  "␠ α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ １",
	}, { // 453
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ １",
		out:  "‛␠ α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ １",
	}, { // 454
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "\v α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ  ",
		out:  "\v α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ ␠",
	}, { // 455
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "\v α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ ␠",
		out:  "\v α␕@Zτｅ\"λt\x0e\x02ς␊␜ε␜5␍{\x14Ｆmσ\x14␙Ｌ ‛␠",
	}, { // 456
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx /",
		out:  "␠ ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx /",
	}, { // 457
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx /",
		out:  "‛␠ ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx /",
	}, { // 458
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x04 ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx  ",
		out:  "\x04 ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx ␠",
	}, { // 459
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x04 ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx ␠",
		out:  "\x04 ␈ｖ＂␐ψ\x18Qβｆq\\U␘|a!６ζ>φ␝Ｆｗ␌σx ‛␠",
	}, { // 460
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04 '",
		out:  "␠ #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04 '",
	}, { // 461
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04 '",
		out:  "‛␠ #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04 '",
	}, { // 462
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "α #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04  ",
		out:  "α #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04 ␠",
	}, { // 463
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "α #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04 ␠",
		out:  "α #κ~␂␄␗a=γ＄α７χ\uff00Ｔ３I\x1cC'\x11Ｊ,／β\x04 ‛␠",
	}, { // 464
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x19\x0f␃ｎｗ\x00＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ Ｐ",
		out:  "␠ \x19\x0f␃ｎｗ␀＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ Ｐ",
	}, { // 465
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x19\x0f␃ｎｗ\x00＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ Ｐ",
		out:  "‛␠ \x19\x0f␃ｎｗ␀＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ Ｐ",
	}, { // 466
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "␉ \x19\x0f␃ｎｗ\x00＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ  ",
		out:  "␉ \x19\x0f␃ｎｗ␀＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ ␠",
	}, { // 467
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "␉ \x19\x0f␃ｎｗ\x00＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ ␠",
		out:  "␉ \x19\x0f␃ｎｗ␀＼ε（η\n5`2\x10：␅＿XVη␙␁βτδ ‛␠",
	}, { // 468
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｍκε6␇？s\x14ς7ψ%ζ@#[２＃\vｏ｀％A\"ω7 ␉",
		out:  "␠ ｍκε6␇？s\x14ς7ψ%ζ@#［２＃\vｏ｀％A\"ω7 ␉",
	}, { // 469
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｍκε6␇？s\x14ς7ψ%ζ@#[２＃\vｏ｀％A\"ω7 ␉",
		out:  "‛␠ ｍκε6␇？s\x14ς7ψ%ζ@#［２＃\vｏ｀％A\"ω7 ␉",
	}, { // 470
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "␆ ｍκε6␇？s\x14ς7ψ%ζ@#[２＃\vｏ｀％A\"ω7  ",
		out:  "␆ ｍκε6␇？s\x14ς7ψ%ζ@#［２＃\vｏ｀％A\"ω7 ␠",
	}, { // 471
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "␆ ｍκε6␇？s\x14ς7ψ%ζ@#[２＃\vｏ｀％A\"ω7 ␠",
		out:  "␆ ｍκε6␇？s\x14ς7ψ%ζ@#［２＃\vｏ｀％A\"ω7 ‛␠",
	}, { // 472
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ＂2Y４α;πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓ \n",
		out:  "␠ ＂2Y４α；πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓ \n",
	}, { // 473
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ＂2Y４α;πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓ \n",
		out:  "‛␠ ＂2Y４α；πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓ \n",
	}, { // 474
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␘ ＂2Y４α;πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓  ",
		out:  "␘ ＂2Y４α；πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓ ␠",
	}, { // 475
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␘ ＂2Y４α;πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓ ␠",
		out:  "␘ ＂2Y４α；πγ w｛ｇＫｙπ[\"［χβ␝\b␕\t\\␓ ‛␠",
	}, { // 476
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ s",
		out:  "␠ \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ s",
	}, { // 477
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ s",
		out:  "‛␠ \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ s",
	}, { // 478
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x06 \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ  ",
		out:  "\x06 \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ ␠",
	}, { // 479
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x06 \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ ␠",
		out:  "\x06 \x05␜θ｜␞k'`␖ＷλＦ\r\rτta_η［／θω＂\x01ｈ ‛␠",
	}, { // 480
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r> γ",
		out:  "␠ ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r> γ",
	}, { // 481
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r> γ",
		out:  "‛␠ ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r> γ",
	}, { // 482
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "η ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r>  ",
		out:  "η ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r> ␠",
	}, { // 483
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "η ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r> ␠",
		out:  "η ␁～＊␁］-8C＿２␕ω␑q'=?\x02␍νεｓ/｝\r> ‛␠",
	}, { // 484
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10␀ξκ␕I／e n",
		out:  "␠ ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10‛␀ξκ␕I／e n",
	}, { // 485
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10␀ξκ␕I／e n",
		out:  "‛␠ ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10‛␀ξκ␕I／e n",
	}, { // 486
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␂ ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10␀ξκ␕I／e  ",
		out:  "␂ ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10‛␀ξκ␕I／e ␠",
	}, { // 487
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␂ ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10␀ξκ␕I／e ␠",
		out:  "␂ ３\x02＄ｙλ[fＹY\x0e？πς␆［7Ｋ\r\x10‛␀ξκ␕I／e ‛␠",
	}, { // 488
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ \b",
		out:  "␠ ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ \b",
	}, { // 489
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ \b",
		out:  "‛␠ ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ \b",
	}, { // 490
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｆ ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ  ",
		out:  "ｆ ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ ␠",
	}, { // 491
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｆ ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ ␠",
		out:  "ｆ ␚ａ＼εsK&＃ｇＭω？T！\x06ς%＇\x1e␅!ｏφ|\nυ ‛␠",
	}, { // 492
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ χ",
		out:  "␠ \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ χ",
	}, { // 493
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ χ",
		out:  "‛␠ \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ χ",
	}, { // 494
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "δ \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ  ",
		out:  "δ \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ ␠",
	}, { // 495
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "δ \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ ␠",
		out:  "δ \x19+ｇ%\x16*ZM３␝，␍\n␞δ~f\x19［δκＶ｜ｙγＴ ‛␠",
	}, { // 496
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "  α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u $",
		out:  "␠ α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u $",
	}, { // 497
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u $",
		out:  "‛␠ α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u $",
	}, { // 498
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "y α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u  ",
		out:  "y α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u ␠",
	}, { // 499
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "y α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u ␠",
		out:  "y α；!\x1eφ\f＂２␌\x12/εｕ＇x９］aζ␔σ<␔ｖ｀u ‛␠",
	}, { // 500
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O \\",
		out:  "␠ ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O \\",
	}, { // 501
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O \\",
		out:  "‛␠ ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O \\",
	}, { // 502
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｉ ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O  ",
		out:  "ｉ ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O ␠",
	}, { // 503
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｉ ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O ␠",
		out:  "ｉ ␉;χ}ｗOσ＇KJＳ＜＊\"F\x15\x18\x14ηθ␑␕：ρ４O ‛␠",
	}, { // 504
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ ␇",
		out:  "␠ ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ ␇",
	}, { // 505
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ ␇",
		out:  "‛␠ ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ ␇",
	}, { // 506
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "ς ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ  ",
		out:  "ς ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ ␠",
	}, { // 507
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "ς ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ ␠",
		out:  "ς ｆ＿␟κυ｜/z3Ｕπ:␕␎\x10／｀\x03rψ?%uｆ\nＨ ‛␠",
	}, { // 508
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "  π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂％βZN'ι␔＂\x10ｖ ！",
		out:  "␠ π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂‛％βZN'ι␔＂\x10ｖ ！",
	}, { // 509
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂％βZN'ι␔＂\x10ｖ ！",
		out:  "‛␠ π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂‛％βZN'ι␔＂\x10ｖ ！",
	}, { // 510
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "_ π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂％βZN'ι␔＂\x10ｖ  ",
		out:  "_ π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂‛％βZN'ι␔＂\x10ｖ ␠",
	}, { // 511
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "_ π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂％βZN'ι␔＂\x10ｖ ␠",
		out:  "_ π\x04ρ\x02\x10ｏ\x0e？ｊ`cφ␒Ｋς␂‛％βZN'ι␔＂\x10ｖ ‛␠",
	}, { // 512
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06 Ｒ",
		out:  "␠ ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06 Ｒ",
	}, { // 513
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06 Ｒ",
		out:  "‛␠ ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06 Ｒ",
	}, { // 514
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "η ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06  ",
		out:  "η ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06 ␠",
	}, { // 515
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "η ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06 ␠",
		out:  "η ν0\x10ｕ:β＂ε？５␞～\nw＝␏\"％α|Q＂'φ␈\x06 ‛␠",
	}, { // 516
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "  φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ ␅",
		out:  "␠ φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ ␅",
	}, { // 517
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ ␅",
		out:  "‛␠ φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ ␅",
	}, { // 518
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "␗ φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ  ",
		out:  "␗ φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ ␠",
	}, { // 519
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "␗ φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ ␠",
		out:  "␗ φιH\x17＃ι\x18\x19ς␎λA\\Ｉ\x11/Ｉ\bＥG＊?６-␕ｂ ‛␠",
	}, { // 520
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω% δ",
		out:  "␠ ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω% δ",
	}, { // 521
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω% δ",
		out:  "‛␠ ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω% δ",
	}, { // 522
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x17 ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω%  ",
		out:  "\x17 ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω% ␠",
	}, { // 523
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x17 ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω% ␠",
		out:  "\x17 ｙ％␇␂<%Ｎ／％Ｉｘ＼/ξτ\x03O;\x0f\x1aιu␟1ω% ‛␠",
	}, { // 524
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x03\rς－eφLMb␄␅␈Ｊ｀＠φο4\x15\x12␖ｕ／\x10;␟ ／",
		out:  "␠ ␃␍ς－eφLMb‛␄‛␅‛␈Ｊ｀＠φο4␕␒‛␖ｕ／␐;‛␟ ／",
	}, { // 525
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x03\rς－eφLMb␄␅␈Ｊ｀＠φο4\x15\x12␖ｕ／\x10;␟ ／",
		out:  "‛␠ ␃␍ς－eφLMb‛␄‛␅‛␈Ｊ｀＠φο4␕␒‛␖ｕ／␐;‛␟ ／",
	}, { // 526
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "τ \x03\rς－eφLMb␄␅␈Ｊ｀＠φο4\x15\x12␖ｕ／\x10;␟  ",
		out:  "τ ␃␍ς－eφLMb‛␄‛␅‛␈Ｊ｀＠φο4␕␒‛␖ｕ／␐;‛␟ ␠",
	}, { // 527
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "τ \x03\rς－eφLMb␄␅␈Ｊ｀＠φο4\x15\x12␖ｕ／\x10;␟ ␠",
		out:  "τ ␃␍ς－eφLMb‛␄‛␅‛␈Ｊ｀＠φο4␕␒‛␖ｕ／␐;‛␟ ‛␠",
	}, { // 528
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／.D",
		out:  "␠.χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／.D",
	}, { // 529
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／.D",
		out:  "‛␠.χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／.D",
	}, { // 530
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␃.χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／. ",
		out:  "␃.χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／. ",
	}, { // 531
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␃.χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／.␠",
		out:  "␃.χ␕␜'}7Ｊ␞γωYB>｀κ＋\b＊σ\x01\x1e０\r＇;／.␠",
	}, { // 532
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " ._␇\f\x14(\x17π\vψｖＨｌυ／δＵ?bcb７␋％ω?`.␋",
		out:  "␠._␇\f\x14(\x17π\vψｖＨｌυ‛／δＵ?bcb７␋％ω?`.␋",
	}, { // 533
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠._␇\f\x14(\x17π\vψｖＨｌυ／δＵ?bcb７␋％ω?`.␋",
		out:  "‛␠._␇\f\x14(\x17π\vψｖＨｌυ‛／δＵ?bcb７␋％ω?`.␋",
	}, { // 534
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␛._␇\f\x14(\x17π\vψｖＨｌυ／δＵ?bcb７␋％ω?`. ",
		out:  "␛._␇\f\x14(\x17π\vψｖＨｌυ‛／δＵ?bcb７␋％ω?`. ",
	}, { // 535
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␛._␇\f\x14(\x17π\vψｖＨｌυ／δＵ?bcb７␋％ω?`.␠",
		out:  "␛._␇\f\x14(\x17π\vψｖＨｌυ‛／δＵ?bcb７␋％ω?`.␠",
	}, { // 536
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e.\x03",
		out:  "␠.＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e.\x03",
	}, { // 537
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e.\x03",
		out:  "‛␠.＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e.\x03",
	}, { // 538
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＊.＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e. ",
		out:  "＊.＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e. ",
	}, { // 539
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＊.＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e.␠",
		out:  "＊.＼\x13＆γＦε\x10ｗ␟χ\b␍γξ／^{D3␛9ψ＼ｂA\x1e.␠",
	}, { // 540
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕.＾",
		out:  "␠.μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕.＾",
	}, { // 541
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕.＾",
		out:  "‛␠.μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕.＾",
	}, { // 542
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "X.μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕. ",
		out:  "X.μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕. ",
	}, { // 543
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "X.μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕.␠",
		out:  "X.μ␈i＠］\x13␓－␊\t／8ｋφς９3κｓ\x17J1\x16υ\n␕.␠",
	}, { // 544
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .＊λｓｓ\x05＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］.S",
		out:  "␠.＊λｓｓ\x05‛＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］.S",
	}, { // 545
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.＊λｓｓ\x05＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］.S",
		out:  "‛␠.＊λｓｓ\x05‛＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］.S",
	}, { // 546
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "：.＊λｓｓ\x05＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］. ",
		out:  "：.＊λｓｓ\x05‛＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］. ",
	}, { // 547
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "：.＊λｓｓ\x05＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］.␠",
		out:  "：.＊λｓｓ\x05‛＜*_␊?＂\x17\x02`\x15｀ξεβＡζ␓Ｓ@\n］.␠",
	}, { // 548
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␅␆ｋσｂ`\n[␞qｑ\f7｀␀␔/,]νκ|Ｔ\x15<ψ.χ",
		out:  "␠.␅␆ｋσｂ`\n［␞qｑ\f7｀‛␀␔/,］νκ|Ｔ\x15<ψ.χ",
	}, { // 549
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␅␆ｋσｂ`\n[␞qｑ\f7｀␀␔/,]νκ|Ｔ\x15<ψ.χ",
		out:  "‛␠.␅␆ｋσｂ`\n［␞qｑ\f7｀‛␀␔/,］νκ|Ｔ\x15<ψ.χ",
	}, { // 550
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ς.␅␆ｋσｂ`\n[␞qｑ\f7｀␀␔/,]νκ|Ｔ\x15<ψ. ",
		out:  "ς.␅␆ｋσｂ`\n［␞qｑ\f7｀‛␀␔/,］νκ|Ｔ\x15<ψ. ",
	}, { // 551
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ς.␅␆ｋσｂ`\n[␞qｑ\f7｀␀␔/,]νκ|Ｔ\x15<ψ.␠",
		out:  "ς.␅␆ｋσｂ`\n［␞qｑ\f7｀‛␀␔/,］νκ|Ｔ\x15<ψ.␠",
	}, { // 552
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ｓ␃\x1f␗;＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！.w",
		out:  "␠.ｓ␃\x1f␗；＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！.w",
	}, { // 553
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ｓ␃\x1f␗;＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！.w",
		out:  "‛␠.ｓ␃\x1f␗；＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！.w",
	}, { // 554
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ψ.ｓ␃\x1f␗;＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！. ",
		out:  "ψ.ｓ␃\x1f␗；＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！. ",
	}, { // 555
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ψ.ｓ␃\x1f␗;＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！.␠",
		out:  "ψ.ｓ␃\x1f␗；＠y@\x02LφςRπ\x7fαB␒ν␞␃\x11Ｊ\x18␚！.␠",
	}, { // 556
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ＡF(␂␒ηV?ｖvμ＃ω\x10τ\x00?␊\a！１\x7fρ/\uff00␈.［",
		out:  "␠.ＡF(␂␒ηV?ｖvμ＃ω\x10τ␀?␊\a‛！１\x7fρ/\uff00␈.［",
	}, { // 557
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ＡF(␂␒ηV?ｖvμ＃ω\x10τ\x00?␊\a！１\x7fρ/\uff00␈.［",
		out:  "‛␠.ＡF(␂␒ηV?ｖvμ＃ω\x10τ␀?␊\a‛！１\x7fρ/\uff00␈.［",
	}, { // 558
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightPeriod,
		in:   "；.ＡF(␂␒ηV?ｖvμ＃ω\x10τ\x00?␊\a！１\x7fρ/\uff00␈. ",
		out:  "；.ＡF(␂␒ηV?ｖvμ＃ω\x10τ␀?␊\a‛！１\x7fρ/\uff00␈. ",
	}, { // 559
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightPeriod,
		in:   "；.ＡF(␂␒ηV?ｖvμ＃ω\x10τ\x00?␊\a！１\x7fρ/\uff00␈.␠",
		out:  "；.ＡF(␂␒ηV?ｖvμ＃ω\x10τ␀?␊\a‛！１\x7fρ/\uff00␈.␠",
	}, { // 560
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％.b",
		out:  "␠.␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％.b",
	}, { // 561
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％.b",
		out:  "‛␠.␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％.b",
	}, { // 562
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "$.␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％. ",
		out:  "＄.␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％. ",
	}, { // 563
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "$.␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％.␠",
		out:  "＄.␑ο#１ψ␟υｏ\bG/\"ｏ／\"μ｜οＢ;␘\x0eNι｀％.␠",
	}, { // 564
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖\x00R\x15{.ｇ",
		out:  "␠.＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖␀R\x15{.ｇ",
	}, { // 565
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖\x00R\x15{.ｇ",
		out:  "‛␠.＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖␀R\x15{.ｇ",
	}, { // 566
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ο.＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖\x00R\x15{. ",
		out:  "ο.＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖␀R\x15{. ",
	}, { // 567
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ο.＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖\x00R\x15{.␠",
		out:  "ο.＄＆ψ'＃，j：？ω［kπ␎M%␝\x1fh\x16γ␖␀R\x15{.␠",
	}, { // 568
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ.ｇ",
		out:  "␠.ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ.ｇ",
	}, { // 569
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ.ｇ",
		out:  "‛␠.ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ.ｇ",
	}, { // 570
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "T.ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ. ",
		out:  "T.ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ. ",
	}, { // 571
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "T.ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ.␠",
		out:  "T.ιυz␆\x19AＣ／\n!\x7f\x11A％γＤ（␓␂Vπδ␍\x0e｜ｃ.␠",
	}, { // 572
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05.υ",
		out:  "␠.␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05.υ",
	}, { // 573
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05.υ",
		out:  "‛␠.␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05.υ",
	}, { // 574
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＃.␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05. ",
		out:  "＃.␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05. ",
	}, { // 575
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＃.␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05.␠",
		out:  "＃.␗`ｒ␛xｕMθ␇\x01$\\On\x03␁φδ６␙␡８＃=χ\x05.␠",
	}, { // 576
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇\x00␕\b␎［X..ν",
		out:  "␠.o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇␀␕\b␎［X..ν",
	}, { // 577
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇\x00␕\b␎［X..ν",
		out:  "‛␠.o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇␀␕\b␎［X..ν",
	}, { // 578
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "z.o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇\x00␕\b␎［X.. ",
		out:  "z.o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇␀␕\b␎［X.. ",
	}, { // 579
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "z.o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇\x00␕\b␎［X..␠",
		out:  "z.o␊0－␙＋ｅσk＇ψｔψｆ\x1aλζ\x10␇␀␕\b␎［X..␠",
	}, { // 580
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍.μ",
		out:  "␠.πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍.μ",
	}, { // 581
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍.μ",
		out:  "‛␠.πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍.μ",
	}, { // 582
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x16.πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍. ",
		out:  "\x16.πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍. ",
	}, { // 583
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x16.πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍.␠",
		out:  "\x16.πξｃＧ#\x1b＃ｂιxaＰδθ\b␔␄\rR７＄<！pＡ␍.␠",
	}, { // 584
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02.\r",
		out:  "␠.${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02.\r",
	}, { // 585
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02.\r",
		out:  "‛␠.${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02.\r",
	}, { // 586
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｚ.${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02. ",
		out:  "Ｚ.${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02. ",
	}, { // 587
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｚ.${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02.␠",
		out:  "Ｚ.${␗δγｅ]\x1b}Ｒθ＼β7␍＞␏～σ\b.ξ␇＇／\x02.␠",
	}, { // 588
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␔␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４.\x1b",
		out:  "␠.␔‛␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４.\x1b",
	}, { // 589
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␔␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４.\x1b",
		out:  "‛␠.␔‛␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４.\x1b",
	}, { // 590
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｚ.␔␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４. ",
		out:  "Ｚ.␔‛␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４. ",
	}, { // 591
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｚ.␔␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４.␠",
		out:  "Ｚ.␔‛␀␊η\x1bι＂Ｉ\x7f．␛-7／Z{ｖε\x1a:κεuβ\x03４.␠",
	}, { // 592
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .Ｗ␝ν,ＸR\r１S＂\r\x7f␀\x1aqνlＸυ；Jιυ\"\aｃ.＄",
		out:  "␠.Ｗ␝ν,ＸR\r１S＂\r\x7f‛␀\x1aqνlＸυ；Jιυ\"\aｃ.＄",
	}, { // 593
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.Ｗ␝ν,ＸR\r１S＂\r\x7f␀\x1aqνlＸυ；Jιυ\"\aｃ.＄",
		out:  "‛␠.Ｗ␝ν,ＸR\r１S＂\r\x7f‛␀\x1aqνlＸυ；Jιυ\"\aｃ.＄",
	}, { // 594
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "υ.Ｗ␝ν,ＸR\r１S＂\r\x7f␀\x1aqνlＸυ；Jιυ\"\aｃ. ",
		out:  "υ.Ｗ␝ν,ＸR\r１S＂\r\x7f‛␀\x1aqνlＸυ；Jιυ\"\aｃ. ",
	}, { // 595
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "υ.Ｗ␝ν,ＸR\r１S＂\r\x7f␀\x1aqνlＸυ；Jιυ\"\aｃ.␠",
		out:  "υ.Ｗ␝ν,ＸR\r１S＂\r\x7f‛␀\x1aqνlＸυ；Jιυ\"\aｃ.␠",
	}, { // 596
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f.;",
		out:  "␠.ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f.;",
	}, { // 597
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f.;",
		out:  "‛␠.ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f.;",
	}, { // 598
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "－.ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f. ",
		out:  "－.ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f. ",
	}, { // 599
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "－.ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f.␠",
		out:  "－.ρ#ｌ\vβw？␒␘］␏\x1157＋εκ\x1eｏν^／～Z＄\f.␠",
	}, { // 600
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈.e",
		out:  "␠.［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈.e",
	}, { // 601
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈.e",
		out:  "‛␠.［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈.e",
	}, { // 602
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "］.［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈. ",
		out:  "］.［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈. ",
	}, { // 603
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "］.［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈.␠",
		out:  "］.［4｜｜\rh\n␎\x02ｉαμυ3［αχ␈/δ\b&０p␜␈.␠",
	}, { // 604
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .Ｄ?ＲＯJE␟␚\x10␍%␝κτ\x19\x02O\x1d␔｝UＨ1υ１α.ξ",
		out:  "␠.Ｄ?ＲＯJE‛␟‛␚␐‛␍%‛␝κτ␙␂O␝‛␔｝UＨ1υ１α.ξ",
	}, { // 605
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.Ｄ?ＲＯJE␟␚\x10␍%␝κτ\x19\x02O\x1d␔｝UＨ1υ１α.ξ",
		out:  "‛␠.Ｄ?ＲＯJE‛␟‛␚␐‛␍%‛␝κτ␙␂O␝‛␔｝UＨ1υ１α.ξ",
	}, { // 606
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ξ.Ｄ?ＲＯJE␟␚\x10␍%␝κτ\x19\x02O\x1d␔｝UＨ1υ１α. ",
		out:  "ξ.Ｄ?ＲＯJE‛␟‛␚␐‛␍%‛␝κτ␙␂O␝‛␔｝UＨ1υ１α. ",
	}, { // 607
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ξ.Ｄ?ＲＯJE␟␚\x10␍%␝κτ\x19\x02O\x1d␔｝UＨ1υ１α.␠",
		out:  "ξ.Ｄ?ＲＯJE‛␟‛␚␐‛␍%‛␝κτ␙␂O␝‛␔｝UＨ1υ１α.␠",
	}, { // 608
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\tε",
		out:  "␠\t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\tε",
	}, { // 609
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\tε",
		out:  "‛␠\t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\tε",
	}, { // 610
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\nε",
		out:  "␠\n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\nε",
	}, { // 611
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\nε",
		out:  "‛␠\n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\nε",
	}, { // 612
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\vε",
		out:  "␠\v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\vε",
	}, { // 613
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\vε",
		out:  "‛␠\v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\vε",
	}, { // 614
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\rε",
		out:  "␠\r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\rε",
	}, { // 615
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\rε",
		out:  "‛␠\r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\rε",
	}, { // 616
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\t ",
		out:  "\a\t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\t ",
	}, { // 617
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\t␠",
		out:  "\a\t␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\t␠",
	}, { // 618
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\n ",
		out:  "\a\n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\n ",
	}, { // 619
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\n␠",
		out:  "\a\n␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\n␠",
	}, { // 620
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\v ",
		out:  "\a\v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\v ",
	}, { // 621
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\v␠",
		out:  "\a\v␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\v␠",
	}, { // 622
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\r ",
		out:  "\a\r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\r ",
	}, { // 623
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\a\r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\r␠",
		out:  "\a\r␊｜＇ω\r＄η{～\"δ␙＜`\x1fν！Ｑ1_φ␁9ｂ\x12V\r␠",
	}, { // 624
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t$",
		out:  "␠\t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t$",
	}, { // 625
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t$",
		out:  "‛␠\t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t$",
	}, { // 626
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n$",
		out:  "␠\n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n$",
	}, { // 627
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n$",
		out:  "‛␠\n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n$",
	}, { // 628
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v$",
		out:  "␠\v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v$",
	}, { // 629
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v$",
		out:  "‛␠\v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v$",
	}, { // 630
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r$",
		out:  "␠\r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r$",
	}, { // 631
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r$",
		out:  "‛␠\r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r$",
	}, { // 632
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t ",
		out:  "\x0e\t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t ",
	}, { // 633
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t␠",
		out:  "\x0e\t！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\t␠",
	}, { // 634
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n ",
		out:  "\x0e\n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n ",
	}, { // 635
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n␠",
		out:  "\x0e\n！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\n␠",
	}, { // 636
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v ",
		out:  "\x0e\v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v ",
	}, { // 637
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v␠",
		out:  "\x0e\v！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\v␠",
	}, { // 638
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r ",
		out:  "\x0e\r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r ",
	}, { // 639
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x0e\r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r␠",
		out:  "\x0e\r！u|J[］：Ｋ＝λ４fοηｊ\"Ｅ\x1eπ␍tς\x15；ｒ｀\r␠",
	}, { // 640
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\tD",
		out:  "␠\t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\tD",
	}, { // 641
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\tD",
		out:  "‛␠\t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\tD",
	}, { // 642
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\nD",
		out:  "␠\n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\nD",
	}, { // 643
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\nD",
		out:  "‛␠\n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\nD",
	}, { // 644
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\vD",
		out:  "␠\v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\vD",
	}, { // 645
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\vD",
		out:  "‛␠\v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\vD",
	}, { // 646
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\rD",
		out:  "␠\r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\rD",
	}, { // 647
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\rD",
		out:  "‛␠\r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\rD",
	}, { // 648
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\t ",
		out:  "Ｑ\t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\t ",
	}, { // 649
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\t␠",
		out:  "Ｑ\t%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\t␠",
	}, { // 650
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\n ",
		out:  "Ｑ\n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\n ",
	}, { // 651
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\n␠",
		out:  "Ｑ\n%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\n␠",
	}, { // 652
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\v ",
		out:  "Ｑ\v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\v ",
	}, { // 653
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\v␠",
		out:  "Ｑ\v%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\v␠",
	}, { // 654
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\r ",
		out:  "Ｑ\r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\r ",
	}, { // 655
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｑ\r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\r␠",
		out:  "Ｑ\r%（+ｈ［ＰD~θζ／πομ％␃*/]\bU\x1e␇ｍ␈／\r␠",
	}, { // 656
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\t＆",
		out:  "␠\tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\t＆",
	}, { // 657
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\t＆",
		out:  "‛␠\tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\t＆",
	}, { // 658
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\n＆",
		out:  "␠\nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\n＆",
	}, { // 659
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\n＆",
		out:  "‛␠\nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\n＆",
	}, { // 660
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\v＆",
		out:  "␠\vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\v＆",
	}, { // 661
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\v＆",
		out:  "‛␠\vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\v＆",
	}, { // 662
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\r＆",
		out:  "␠\rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\r＆",
	}, { // 663
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\r＆",
		out:  "‛␠\rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\r＆",
	}, { // 664
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\t ",
		out:  "λ\tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\t ",
	}, { // 665
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\t␠",
		out:  "λ\tｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\t␠",
	}, { // 666
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\n ",
		out:  "λ\nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\n ",
	}, { // 667
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\n␠",
		out:  "λ\nｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\n␠",
	}, { // 668
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\v ",
		out:  "λ\vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\v ",
	}, { // 669
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\v␠",
		out:  "λ\vｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\v␠",
	}, { // 670
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\r ",
		out:  "λ\rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\r ",
	}, { // 671
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "λ\rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a\x00\x18\"␔␊\r␠",
		out:  "λ\rｂς␜α0*:\aPTＬζ［＊B␍）＂κ３\a␀\x18\"␔␊\r␠",
	}, { // 672
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t＂",
		out:  "␠\t］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t＂",
	}, { // 673
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t＂",
		out:  "‛␠\t］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t＂",
	}, { // 674
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n＂",
		out:  "␠\n］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n＂",
	}, { // 675
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n＂",
		out:  "‛␠\n］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n＂",
	}, { // 676
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v＂",
		out:  "␠\v］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v＂",
	}, { // 677
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v＂",
		out:  "‛␠\v］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v＂",
	}, { // 678
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r＂",
		out:  "␠\r］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r＂",
	}, { // 679
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r＂",
		out:  "‛␠\r］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r＂",
	}, { // 680
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\t］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t ",
		out:  "\x15\t］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t ",
	}, { // 681
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\t］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t␠",
		out:  "\x15\t］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\t␠",
	}, { // 682
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\n］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n ",
		out:  "\x15\n］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n ",
	}, { // 683
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\n］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n␠",
		out:  "\x15\n］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\n␠",
	}, { // 684
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\v］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v ",
		out:  "\x15\v］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v ",
	}, { // 685
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\v］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v␠",
		out:  "\x15\v］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\v␠",
	}, { // 686
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\r］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r ",
		out:  "\x15\r］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r ",
	}, { // 687
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x15\r］␖ρ＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r␠",
		out:  "\x15\r］␖ρ‛＞\x04～／\x1fｈψ\x02!｀ηIθ；ι2-\x15｀Ｔn$λ\r␠",
	}, { // 688
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\t\x02",
		out:  "␠\tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\t\x02",
	}, { // 689
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\t\x02",
		out:  "‛␠\tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\t\x02",
	}, { // 690
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\n\x02",
		out:  "␠\nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\n\x02",
	}, { // 691
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\n\x02",
		out:  "‛␠\nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\n\x02",
	}, { // 692
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\v\x02",
		out:  "␠\vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\v\x02",
	}, { // 693
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\v\x02",
		out:  "‛␠\vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\v\x02",
	}, { // 694
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\r\x02",
		out:  "␠\rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\r\x02",
	}, { // 695
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\r\x02",
		out:  "‛␠\rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\r\x02",
	}, { // 696
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\t ",
		out:  "｝\tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\t ",
	}, { // 697
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\t␠",
		out:  "｝\tｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\t␠",
	}, { // 698
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\n ",
		out:  "｝\nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\n ",
	}, { // 699
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\n␠",
		out:  "｝\nｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\n␠",
	}, { // 700
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\v ",
		out:  "｝\vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\v ",
	}, { // 701
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\v␠",
		out:  "｝\vｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\v␠",
	}, { // 702
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\r ",
		out:  "｝\rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\r ",
	}, { // 703
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$］ｙ\x0f?p\r␠",
		out:  "｝\rｘ␜i８@κｄwπ\x11␅␜αψ\nτ＃\n4Ｆ$‛］ｙ\x0f?p\r␠",
	}, { // 704
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\tβ",
		out:  "␠\t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\tβ",
	}, { // 705
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\tβ",
		out:  "‛␠\t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\tβ",
	}, { // 706
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\nβ",
		out:  "␠\n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\nβ",
	}, { // 707
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\nβ",
		out:  "‛␠\n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\nβ",
	}, { // 708
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\vβ",
		out:  "␠\v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\vβ",
	}, { // 709
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\vβ",
		out:  "‛␠\v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\vβ",
	}, { // 710
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\rβ",
		out:  "␠\r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\rβ",
	}, { // 711
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\rβ",
		out:  "‛␠\r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\rβ",
	}, { // 712
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\t ",
		out:  "'\t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\t ",
	}, { // 713
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\t␠",
		out:  "'\t␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\t␠",
	}, { // 714
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\n ",
		out:  "'\n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\n ",
	}, { // 715
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\n␠",
		out:  "'\n␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\n␠",
	}, { // 716
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\v ",
		out:  "'\v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\v ",
	}, { // 717
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\v␠",
		out:  "'\v␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\v␠",
	}, { // 718
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\r ",
		out:  "'\r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\r ",
	}, { // 719
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "'\r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)␀ｅyα\"＞`\r␠",
		out:  "'\r␑α-N\t\x12\r７＠）＂qπι！␕ζ！)‛␀ｅyα\"＞`\r␠",
	}, { // 720
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\tο",
		out:  "␠\t５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\tο",
	}, { // 721
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\tο",
		out:  "‛␠\t５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\tο",
	}, { // 722
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\nο",
		out:  "␠\n５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\nο",
	}, { // 723
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\nο",
		out:  "‛␠\n５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\nο",
	}, { // 724
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\vο",
		out:  "␠\v５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\vο",
	}, { // 725
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\vο",
		out:  "‛␠\v５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\vο",
	}, { // 726
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\rο",
		out:  "␠\r５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\rο",
	}, { // 727
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\rο",
		out:  "‛␠\r５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\rο",
	}, { // 728
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\t５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\t ",
		out:  ",\t５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\t ",
	}, { // 729
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\t５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\t␠",
		out:  ",\t５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\t␠",
	}, { // 730
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\n５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\n ",
		out:  ",\n５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\n ",
	}, { // 731
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\n５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\n␠",
		out:  ",\n５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\n␠",
	}, { // 732
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\v５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\v ",
		out:  ",\v５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\v ",
	}, { // 733
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\v５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\v␠",
		out:  ",\v５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\v␠",
	}, { // 734
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\r５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\r ",
		out:  ",\r５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\r ",
	}, { // 735
		mask: EncodeExclamation | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   ",\r５␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞\x00␡ςＪ\x00\t\r␠",
		out:  ",\r５‛␀)$ι＄ψζ3N\x04ｇ｝γQ２`␈ｉ␞␀␡ςＪ␀\t\r␠",
	}, { // 736
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\tｍ",
		out:  "␠\t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\tｍ",
	}, { // 737
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\tｍ",
		out:  "‛␠\t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\tｍ",
	}, { // 738
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\nｍ",
		out:  "␠\n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\nｍ",
	}, { // 739
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\nｍ",
		out:  "‛␠\n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\nｍ",
	}, { // 740
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\vｍ",
		out:  "␠\v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\vｍ",
	}, { // 741
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\vｍ",
		out:  "‛␠\v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\vｍ",
	}, { // 742
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\rｍ",
		out:  "␠\r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\rｍ",
	}, { // 743
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\rｍ",
		out:  "‛␠\r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\rｍ",
	}, { // 744
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\t ",
		out:  "\r\t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\t ",
	}, { // 745
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\t␠",
		out:  "\r\t␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\t␠",
	}, { // 746
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\n ",
		out:  "\r\n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\n ",
	}, { // 747
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\n␠",
		out:  "\r\n␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\n␠",
	}, { // 748
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\v ",
		out:  "\r\v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\v ",
	}, { // 749
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\v␠",
		out:  "\r\v␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\v␠",
	}, { // 750
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\r ",
		out:  "\r\r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\r ",
	}, { // 751
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\r\r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\r␠",
		out:  "\r\r␑ｈθ\x02\x01\\7␡3ιＹδ１\x13Ｒ␒κ\x06\x11＼ξυ␙Ｅ:／\r␠",
	}, { // 752
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\tι",
		out:  "␠\tνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\tι",
	}, { // 753
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\tι",
		out:  "‛␠\tνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\tι",
	}, { // 754
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\nι",
		out:  "␠\nνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\nι",
	}, { // 755
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\nι",
		out:  "‛␠\nνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\nι",
	}, { // 756
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\vι",
		out:  "␠\vνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\vι",
	}, { // 757
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\vι",
		out:  "‛␠\vνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\vι",
	}, { // 758
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\rι",
		out:  "␠\rνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\rι",
	}, { // 759
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\rι",
		out:  "‛␠\rνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\rι",
	}, { // 760
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\tνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\t ",
		out:  "Ｏ\tνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\t ",
	}, { // 761
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\tνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\t␠",
		out:  "Ｏ\tνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\t␠",
	}, { // 762
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\nνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\n ",
		out:  "Ｏ\nνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\n ",
	}, { // 763
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\nνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\n␠",
		out:  "Ｏ\nνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\n␠",
	}, { // 764
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\vνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\v ",
		out:  "Ｏ\vνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\v ",
	}, { // 765
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\vνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\v␠",
		out:  "Ｏ\vνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\v␠",
	}, { // 766
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\rνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\r ",
		out:  "Ｏ\rνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\r ",
	}, { // 767
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ｏ\rνｙ{\x13］π\r＂\"\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\r␠",
		out:  "Ｏ\rνｙ{\x13］π\r‛＂＂\x0fδｗμ␈␔\x03；PD␞＠␏L＇ιk\r␠",
	}, { // 768
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \t␕",
		out:  "␠\t\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \t␕",
	}, { // 769
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \t␕",
		out:  "‛␠\t\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \t␕",
	}, { // 770
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \n␕",
		out:  "␠\n\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \n␕",
	}, { // 771
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \n␕",
		out:  "‛␠\n\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \n␕",
	}, { // 772
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \v␕",
		out:  "␠\v\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \v␕",
	}, { // 773
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \v␕",
		out:  "‛␠\v\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \v␕",
	}, { // 774
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \r␕",
		out:  "␠\r\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \r␕",
	}, { // 775
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \r␕",
		out:  "‛␠\r\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \r␕",
	}, { // 776
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\t\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \t ",
		out:  "␀\t\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \t ",
	}, { // 777
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\t\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \t␠",
		out:  "␀\t\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \t␠",
	}, { // 778
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\n\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \n ",
		out:  "␀\n\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \n ",
	}, { // 779
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\n\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \n␠",
		out:  "␀\n\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \n␠",
	}, { // 780
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\v\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \v ",
		out:  "␀\v\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \v ",
	}, { // 781
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\v\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \v␠",
		out:  "␀\v\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \v␠",
	}, { // 782
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\r\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \r ",
		out:  "␀\r\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \r ",
	}, { // 783
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\r\x1b␉Ａrｄθ\n\x1dγａζ␝:＃ ：τ\x1fCαｒO｜\"Ｋ \r␠",
		out:  "␀\r\x1b␉Ａrｄθ\n\x1dγａζ␝：＃ ‛：τ\x1fCαｒO｜\"Ｋ \r␠",
	}, { // 784
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t:",
		out:  "␠\t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t:",
	}, { // 785
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t:",
		out:  "‛␠\t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t:",
	}, { // 786
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n:",
		out:  "␠\n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n:",
	}, { // 787
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n:",
		out:  "‛␠\n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n:",
	}, { // 788
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v:",
		out:  "␠\v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v:",
	}, { // 789
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v:",
		out:  "‛␠\v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v:",
	}, { // 790
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r:",
		out:  "␠\r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r:",
	}, { // 791
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r:",
		out:  "‛␠\r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r:",
	}, { // 792
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t ",
		out:  "＜\t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t ",
	}, { // 793
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t␠",
		out:  "＜\t［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\t␠",
	}, { // 794
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n ",
		out:  "＜\n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n ",
	}, { // 795
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n␠",
		out:  "＜\n［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\n␠",
	}, { // 796
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v ",
		out:  "＜\v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v ",
	}, { // 797
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v␠",
		out:  "＜\v［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\v␠",
	}, { // 798
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r ",
		out:  "＜\r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r ",
	}, { // 799
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＜\r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r␠",
		out:  "＜\r［＊α␑υ\n=W\x06σｘ＇\uff00␛\r\b\x1bKλεο␝U[＼＆\r␠",
	}, { // 800
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\tＷ",
		out:  "␠\tζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\tＷ",
	}, { // 801
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\tＷ",
		out:  "‛␠\tζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\tＷ",
	}, { // 802
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\nＷ",
		out:  "␠\nζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\nＷ",
	}, { // 803
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\nＷ",
		out:  "‛␠\nζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\nＷ",
	}, { // 804
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\vＷ",
		out:  "␠\vζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\vＷ",
	}, { // 805
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\vＷ",
		out:  "‛␠\vζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\vＷ",
	}, { // 806
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\rＷ",
		out:  "␠\rζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\rＷ",
	}, { // 807
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\rＷ",
		out:  "‛␠\rζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\rＷ",
	}, { // 808
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\tζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\t ",
		out:  "［\tζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\t ",
	}, { // 809
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\tζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\t␠",
		out:  "［\tζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\t␠",
	}, { // 810
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\nζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\n ",
		out:  "［\nζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\n ",
	}, { // 811
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\nζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\n␠",
		out:  "［\nζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\n␠",
	}, { // 812
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\vζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\v ",
		out:  "［\vζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\v ",
	}, { // 813
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\vζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\v␠",
		out:  "［\vζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\v␠",
	}, { // 814
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\rζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\r ",
		out:  "［\rζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\r ",
	}, { // 815
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "［\rζ␀#［\x1a␓θr４:ｓω␍*Zρ－:␛Aｋ␓`\x1aFξ\r␠",
		out:  "［\rζ‛␀#［\x1a␓θr４:ｓω␍＊Zρ－:␛Aｋ␓`\x1aFξ\r␠",
	}, { // 816
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\tb",
		out:  "␠\tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\tb",
	}, { // 817
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\tb",
		out:  "‛␠\tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\tb",
	}, { // 818
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\nb",
		out:  "␠\nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\nb",
	}, { // 819
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\nb",
		out:  "‛␠\nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\nb",
	}, { // 820
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\vb",
		out:  "␠\vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\vb",
	}, { // 821
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\vb",
		out:  "‛␠\vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\vb",
	}, { // 822
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\rb",
		out:  "␠\rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\rb",
	}, { // 823
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\rb",
		out:  "‛␠\rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\rb",
	}, { // 824
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\t ",
		out:  "ζ\tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\t ",
	}, { // 825
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\t␠",
		out:  "ζ\tＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\t␠",
	}, { // 826
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\n ",
		out:  "ζ\nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\n ",
	}, { // 827
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\n␠",
		out:  "ζ\nＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\n␠",
	}, { // 828
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\v ",
		out:  "ζ\vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\v ",
	}, { // 829
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\v␠",
		out:  "ζ\vＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\v␠",
	}, { // 830
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\r ",
		out:  "ζ\rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\r ",
	}, { // 831
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\r␠",
		out:  "ζ\rＲ\x0eγ／＂␗＼W／\x11\x14｝＼η_］\x13\x17ςδ ω␈K[1\r␠",
	}, { // 832
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t\x1e",
		out:  "␠\t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t\x1e",
	}, { // 833
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t\x1e",
		out:  "‛␠\t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t\x1e",
	}, { // 834
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n\x1e",
		out:  "␠\n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n\x1e",
	}, { // 835
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n\x1e",
		out:  "‛␠\n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n\x1e",
	}, { // 836
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v\x1e",
		out:  "␠\v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v\x1e",
	}, { // 837
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v\x1e",
		out:  "‛␠\v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v\x1e",
	}, { // 838
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r\x1e",
		out:  "␠\r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r\x1e",
	}, { // 839
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r\x1e",
		out:  "‛␠\r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r\x1e",
	}, { // 840
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t ",
		out:  "｝\t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t ",
	}, { // 841
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t␠",
		out:  "｝\t＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\t␠",
	}, { // 842
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n ",
		out:  "｝\n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n ",
	}, { // 843
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n␠",
		out:  "｝\n＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\n␠",
	}, { // 844
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v ",
		out:  "｝\v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v ",
	}, { // 845
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v␠",
		out:  "｝\v＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\v␠",
	}, { // 846
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r ",
		out:  "｝\r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r ",
	}, { // 847
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "｝\r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r␠",
		out:  "｝\r＼C!j\nρ\x18／␒ｗa＞wε=τ！ρ＊\n｜ｓω｀I\x7f\r␠",
	}, { // 848
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t＃",
		out:  "␠\t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t＃",
	}, { // 849
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t＃",
		out:  "‛␠\t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t＃",
	}, { // 850
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n＃",
		out:  "␠\n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n＃",
	}, { // 851
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n＃",
		out:  "‛␠\n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n＃",
	}, { // 852
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v＃",
		out:  "␠\v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v＃",
	}, { // 853
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v＃",
		out:  "‛␠\v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v＃",
	}, { // 854
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r＃",
		out:  "␠\r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r＃",
	}, { // 855
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r＃",
		out:  "‛␠\r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r＃",
	}, { // 856
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t ",
		out:  "w\t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t ",
	}, { // 857
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t␠",
		out:  "w\t/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\t␠",
	}, { // 858
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n ",
		out:  "w\n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n ",
	}, { // 859
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n␠",
		out:  "w\n/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\n␠",
	}, { // 860
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v ",
		out:  "w\v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v ",
	}, { // 861
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v␠",
		out:  "w\v/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\v␠",
	}, { // 862
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r ",
		out:  "w\r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r ",
	}, { // 863
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "w\r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r␠",
		out:  "w\r/ＺｓＦξ␐<φ}\\：ｒ\x174ψ[θ|＃ο\f␔ｏ␋σ`\r␠",
	}, { // 864
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\tt",
		out:  "␠\t＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\tt",
	}, { // 865
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\tt",
		out:  "‛␠\t＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\tt",
	}, { // 866
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\nt",
		out:  "␠\n＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\nt",
	}, { // 867
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\nt",
		out:  "‛␠\n＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\nt",
	}, { // 868
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\vt",
		out:  "␠\v＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\vt",
	}, { // 869
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\vt",
		out:  "‛␠\v＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\vt",
	}, { // 870
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\rt",
		out:  "␠\r＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\rt",
	}, { // 871
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\rt",
		out:  "‛␠\r＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\rt",
	}, { // 872
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\t＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\t ",
		out:  "σ\t＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\t ",
	}, { // 873
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\t＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\t␠",
		out:  "σ\t＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\t␠",
	}, { // 874
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\n＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\n ",
		out:  "σ\n＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\n ",
	}, { // 875
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\n＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\n␠",
		out:  "σ\n＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\n␠",
	}, { // 876
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\v＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\v ",
		out:  "σ\v＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\v ",
	}, { // 877
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\v＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\v␠",
		out:  "σ\v＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\v␠",
	}, { // 878
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\r＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\r ",
		out:  "σ\r＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\r ",
	}, { // 879
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "σ\r＊␟\x1a'θσO\nψＲ／\\␏␞ｅδ␛uθ％／２\x02\x0eＯt\r␠",
		out:  "σ\r＊␟\x1a'θσO\nψＲ／＼␏␞ｅδ␛uθ％／２\x02\x0eＯt\r␠",
	}, { // 880
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\tc",
		out:  "␠\t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\tc",
	}, { // 881
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\tc",
		out:  "‛␠\t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\tc",
	}, { // 882
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\nc",
		out:  "␠\n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\nc",
	}, { // 883
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\nc",
		out:  "‛␠\n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\nc",
	}, { // 884
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\vc",
		out:  "␠\v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\vc",
	}, { // 885
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\vc",
		out:  "‛␠\v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\vc",
	}, { // 886
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\rc",
		out:  "␠\r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\rc",
	}, { // 887
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\rc",
		out:  "‛␠\r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\rc",
	}, { // 888
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\t ",
		out:  "Ａ\t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\t ",
	}, { // 889
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\t␠",
		out:  "Ａ\t␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\t␠",
	}, { // 890
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\n ",
		out:  "Ａ\n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\n ",
	}, { // 891
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\n␠",
		out:  "Ａ\n␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\n␠",
	}, { // 892
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\v ",
		out:  "Ａ\v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\v ",
	}, { // 893
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\v␠",
		out:  "Ａ\v␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\v␠",
	}, { // 894
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\r ",
		out:  "Ａ\r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\r ",
	}, { // 895
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "Ａ\r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\r␠",
		out:  "Ａ\r␈Ｅ；％␋␑\x11φn｜\x02␂ιξＵＵ[T<\x11VλU\x10θ＋\r␠",
	}, { // 896
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". δU\x00８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ ＄",
		out:  "． δU␀８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ ＄",
	}, { // 897
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． δU\x00８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ ＄",
		out:  "‛． δU␀８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ ＄",
	}, { // 898
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␍ δU\x00８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ .",
		out:  "␍ δU␀８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ .",
	}, { // 899
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␍ δU\x00８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ ．",
		out:  "␍ δU␀８＋＃\x02υ\nｈ\r７/＾ζ！'ν}\x16j［[ρ␙＂ ．",
	}, { // 900
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% \"",
		out:  "． ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% \"",
	}, { // 901
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% \"",
		out:  "‛． ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% \"",
	}, { // 902
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "! ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% .",
		out:  "! ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% .",
	}, { // 903
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "! ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% ．",
		out:  "! ｜ψ\x10␁ｚ＄＞σ＼␋^\a?^ｊ\x1aχ\fE␡λ\aξＵφ% ．",
	}, { // 904
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s ␛",
		out:  "． ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s ␛",
	}, { // 905
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s ␛",
		out:  "‛． ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s ␛",
	}, { // 906
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "J ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s .",
		out:  "J ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s .",
	}, { // 907
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "J ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s ．",
		out:  "J ␂μ｀\x0e４U␄/β７␓\x03＞αθ～\x03);＄，ιｃZ<s ．",
	}, { // 908
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ φ",
		out:  "． ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ φ",
	}, { // 909
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ φ",
		out:  "‛． ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ φ",
	}, { // 910
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\x1a ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ .",
		out:  "\x1a ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ .",
	}, { // 911
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\x1a ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ ．",
		out:  "\x1a ＃ρG＼η\x014φ␍-ｕk\nｃη::βｄ␞p！ａ|␞␃ ．",
	}, { // 912
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a ␁",
		out:  "． ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a ␁",
	}, { // 913
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a ␁",
		out:  "‛． ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a ␁",
	}, { // 914
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｍ ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a .",
		out:  "Ｍ ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a .",
	}, { // 915
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｍ ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a ．",
		out:  "Ｍ ␂!␔\x1a\x05!ν␈．ηｖ␆[αｆ)+2Oα％μ:＼F\a ．",
	}, { // 916
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm]Ｊνｎy␓λ \x06",
		out:  "． π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm］Ｊνｎy␓λ \x06",
	}, { // 917
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm]Ｊνｎy␓λ \x06",
		out:  "‛． π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm］Ｊνｎy␓λ \x06",
	}, { // 918
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Q π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm]Ｊνｎy␓λ .",
		out:  "Q π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm］Ｊνｎy␓λ .",
	}, { // 919
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Q π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm]Ｊνｎy␓λ ．",
		out:  "Q π␉,οｔ'F␌３\x01ｏ#ς␂ｓ␍3ψm］Ｊνｎy␓λ ．",
	}, { // 920
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". Ｈ＠；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘; ␖",
		out:  "． Ｈ＠‛；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘； ␖",
	}, { // 921
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． Ｈ＠；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘; ␖",
		out:  "‛． Ｈ＠‛；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘； ␖",
	}, { // 922
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␘ Ｈ＠；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘; .",
		out:  "␘ Ｈ＠‛；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘； .",
	}, { // 923
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␘ Ｈ＠；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘; ．",
		out:  "␘ Ｈ＠‛；[ελμ\x04λ`v）+\x1b\x10ｚ␒｝Uπeς\x15␘␘； ．",
	}, { // 924
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: |",
		out:  "． γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: |",
	}, { // 925
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: |",
		out:  "‛． γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: |",
	}, { // 926
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␏ γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: .",
		out:  "␏ γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: .",
	}, { // 927
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␏ γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: ．",
		out:  "␏ γω'κｏ\x01ｊ０θ\x1c\rQ␞＃λ`\x02？－ηI␊\x10４␏: ．",
	}, { // 928
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 λ",
		out:  "． ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 λ",
	}, { // 929
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 λ",
		out:  "‛． ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 λ",
	}, { // 930
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\" ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 .",
		out:  "\" ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 .",
	}, { // 931
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\" ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 ．",
		out:  "\" ]-３f␍Ｔ␏}７\x13|␙＝␒Ｔ４␍\aθ␊Hμψψm\x15 ．",
	}, { // 932
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ χ",
		out:  "． ‛␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ χ",
	}, { // 933
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ χ",
		out:  "‛． ‛␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ χ",
	}, { // 934
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "｛ ␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ .",
		out:  "｛ ‛␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ .",
	}, { // 935
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "｛ ␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ ．",
		out:  "｛ ‛␀rＫκ␛␔_\x01{$ｂ/βλ\x1e\bρE\x10AＤ␑［６␞σ ．",
	}, { // 936
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＝!-ＯC｛␒␏η;σβ:π␋\x04␏\x05５\x02；\b␘2I\b μ",
		out:  "． ＝!-ＯC｛␒␏η;σβ：π␋\x04␏\x05５\x02；\b␘2I\b μ",
	}, { // 937
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＝!-ＯC｛␒␏η;σβ:π␋\x04␏\x05５\x02；\b␘2I\b μ",
		out:  "‛． ＝!-ＯC｛␒␏η;σβ：π␋\x04␏\x05５\x02；\b␘2I\b μ",
	}, { // 938
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "！ ＝!-ＯC｛␒␏η;σβ:π␋\x04␏\x05５\x02；\b␘2I\b .",
		out:  "！ ＝!-ＯC｛␒␏η;σβ：π␋\x04␏\x05５\x02；\b␘2I\b .",
	}, { // 939
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "！ ＝!-ＯC｛␒␏η;σβ:π␋\x04␏\x05５\x02；\b␘2I\b ．",
		out:  "！ ＝!-ＯC｛␒␏η;σβ：π␋\x04␏\x05５\x02；\b␘2I\b ．",
	}, { // 940
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ ＄",
		out:  "． /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ ＄",
	}, { // 941
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ ＄",
		out:  "‛． /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ ＄",
	}, { // 942
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␊ /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ .",
		out:  "␊ /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ .",
	}, { // 943
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␊ /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ ．",
		out:  "␊ /;\nωzν␊Ｃζςςｇ)\x10␃␏！\x10\x19k^t␆ψ_｀ ．",
	}, { // 944
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ v",
		out:  "． ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ v",
	}, { // 945
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ v",
		out:  "‛． ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ v",
	}, { // 946
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␝ ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ .",
		out:  "␝ ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ .",
	}, { // 947
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␝ ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ ．",
		out:  "␝ ␕\x11ωωDｘｖ\x1cＢ\x12ωψ;Lh＿\x17␉\\βι[␌６＜␉ ．",
	}, { // 948
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A ＃",
		out:  "． （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A ＃",
	}, { // 949
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A ＃",
		out:  "‛． （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A ＃",
	}, { // 950
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｓ （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A .",
		out:  "ｓ （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A .",
	}, { // 951
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｓ （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A ．",
		out:  "ｓ （φ\x04υσｄ－ι\nA$SＦφｃ␄WP/␂␛］？\x05[A ．",
	}, { // 952
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ][Ｍ␔Cζ\f␑τ␇α]γ␘␀ω［＼dρＣTw３2\x1f [",
		out:  "． ][Ｍ␔Cζ\f␑τ␇α]γ␘‛␀ω［＼dρＣTw３2\x1f [",
	}, { // 953
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ][Ｍ␔Cζ\f␑τ␇α]γ␘␀ω［＼dρＣTw３2\x1f [",
		out:  "‛． ][Ｍ␔Cζ\f␑τ␇α]γ␘‛␀ω［＼dρＣTw３2\x1f [",
	}, { // 954
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "| ][Ｍ␔Cζ\f␑τ␇α]γ␘␀ω［＼dρＣTw３2\x1f .",
		out:  "| ][Ｍ␔Cζ\f␑τ␇α]γ␘‛␀ω［＼dρＣTw３2\x1f .",
	}, { // 955
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "| ][Ｍ␔Cζ\f␑τ␇α]γ␘␀ω［＼dρＣTw３2\x1f ．",
		out:  "| ][Ｍ␔Cζ\f␑τ␇α]γ␘‛␀ω［＼dρＣTw３2\x1f ．",
	}, { // 956
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ％r；kＬV \x7f",
		out:  "． ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ‛％r；kＬV \x7f",
	}, { // 957
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ％r；kＬV \x7f",
		out:  "‛． ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ‛％r；kＬV \x7f",
	}, { // 958
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\r ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ％r；kＬV .",
		out:  "\r ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ‛％r；kＬV .",
	}, { // 959
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\r ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ％r；kＬV ．",
		out:  "\r ηmςｐ7βＭ\x1dυV␙４；\x1a␓ς\x16\r␞Ｍ‛％r；kＬV ．",
	}, { // 960
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE /",
		out:  "． ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE /",
	}, { // 961
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE /",
		out:  "‛． ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE /",
	}, { // 962
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｎ ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE .",
		out:  "ｎ ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE .",
	}, { // 963
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ｎ ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE ．",
		out:  "ｎ ＨｕSθp␙\x16␊␓\x12｜\x0f␘Ｘυ=ρε\r*]%ＩυωE ．",
	}, { // 964
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＞\x03Ｃυ＜ζ！；θ＞ＲXτ␍␌\x7f'］Z\x02o*ξ｝#τ Ｍ",
		out:  "． ＞\x03Ｃυ＜ζ！；θ＞ＲXτ‛␍␌\x7f'］Z\x02o*ξ｝#τ Ｍ",
	}, { // 965
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＞\x03Ｃυ＜ζ！；θ＞ＲXτ␍␌\x7f'］Z\x02o*ξ｝#τ Ｍ",
		out:  "‛． ＞\x03Ｃυ＜ζ！；θ＞ＲXτ‛␍␌\x7f'］Z\x02o*ξ｝#τ Ｍ",
	}, { // 966
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "! ＞\x03Ｃυ＜ζ！；θ＞ＲXτ␍␌\x7f'］Z\x02o*ξ｝#τ .",
		out:  "! ＞\x03Ｃυ＜ζ！；θ＞ＲXτ‛␍␌\x7f'］Z\x02o*ξ｝#τ .",
	}, { // 967
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "! ＞\x03Ｃυ＜ζ！；θ＞ＲXτ␍␌\x7f'］Z\x02o*ξ｝#τ ．",
		out:  "! ＞\x03Ｃυ＜ζ！；θ＞ＲXτ‛␍␌\x7f'］Z\x02o*ξ｝#τ ．",
	}, { // 968
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ ｐ",
		out:  "． <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ ｐ",
	}, { // 969
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ ｐ",
		out:  "‛． <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ ｐ",
	}, { // 970
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "H <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ .",
		out:  "H <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ .",
	}, { // 971
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "H <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ ．",
		out:  "H <\x19[ｓ!\r[Ｍα＃［␐χξｙμ\x06E／＼$μ．b＼ｚ ．",
	}, { // 972
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". φ（␆bＰs＄␙Ｔνα␔２\x12*ｙｊ^}ζY\x03\x10\x1eι： θ",
		out:  "． φ（‛␆bＰs＄‛␙Ｔνα‛␔２␒*ｙｊ^}ζY␃␐␞ι： θ",
	}, { // 973
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． φ（␆bＰs＄␙Ｔνα␔２\x12*ｙｊ^}ζY\x03\x10\x1eι： θ",
		out:  "‛． φ（‛␆bＰs＄‛␙Ｔνα‛␔２␒*ｙｊ^}ζY␃␐␞ι： θ",
	}, { // 974
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "G φ（␆bＰs＄␙Ｔνα␔２\x12*ｙｊ^}ζY\x03\x10\x1eι： .",
		out:  "G φ（‛␆bＰs＄‛␙Ｔνα‛␔２␒*ｙｊ^}ζY␃␐␞ι： .",
	}, { // 975
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "G φ（␆bＰs＄␙Ｔνα␔２\x12*ｙｊ^}ζY\x03\x10\x1eι： ．",
		out:  "G φ（‛␆bＰs＄‛␙Ｔνα‛␔２␒*ｙｊ^}ζY␃␐␞ι： ．",
	}, { // 976
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~／",
		out:  "．~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~／",
	}, { // 977
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~／",
		out:  "‛．~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~／",
	}, { // 978
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␍~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~.",
		out:  "␍~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~.",
	}, { // 979
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␍~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~．",
		out:  "␍~\x11bSπ；ε␗ε\x17N]S␙％λ＆＇ｍ＼;:ν\x19e＃σ~．",
	}, { // 980
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~α",
		out:  "．~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~α",
	}, { // 981
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~α",
		out:  "‛．~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~α",
	}, { // 982
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "J~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~.",
		out:  "J~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~.",
	}, { // 983
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "J~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~．",
		out:  "J~Ｍｗ␖␇lχM␗｛\x01s␞ｆρ|ξ␝＜ｖμu\x02\vＸY\x12~．",
	}, { // 984
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~[z-π／ξ␎ｇνπ0_t\x00Ｄｃ％>τＫ>\x1d␀o␃η~＠",
		out:  "．~[z-π／ξ␎ｇνπ0_t␀Ｄｃ％>τＫ>\x1d‛␀o␃η~＠",
	}, { // 985
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~[z-π／ξ␎ｇνπ0_t\x00Ｄｃ％>τＫ>\x1d␀o␃η~＠",
		out:  "‛．~[z-π／ξ␎ｇνπ0_t␀Ｄｃ％>τＫ>\x1d‛␀o␃η~＠",
	}, { // 986
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "＼~[z-π／ξ␎ｇνπ0_t\x00Ｄｃ％>τＫ>\x1d␀o␃η~.",
		out:  "＼~[z-π／ξ␎ｇνπ0_t␀Ｄｃ％>τＫ>\x1d‛␀o␃η~.",
	}, { // 987
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "＼~[z-π／ξ␎ｇνπ0_t\x00Ｄｃ％>τＫ>\x1d␀o␃η~．",
		out:  "＼~[z-π／ξ␎ｇνπ0_t␀Ｄｃ％>τＫ>\x1d‛␀o␃η~．",
	}, { // 988
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~β",
		out:  "．~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~β",
	}, { // 989
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~β",
		out:  "‛．~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~β",
	}, { // 990
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ξ~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~.",
		out:  "ξ~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~.",
	}, { // 991
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ξ~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~．",
		out:  "ξ~\x14ς\x14！α␍Ｗ＊θＵt\x06λ～Y８1␞＋\a\x1cuｄg␟N~．",
	}, { // 992
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ\x00~\x02",
		out:  "．~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ␀~\x02",
	}, { // 993
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ\x00~\x02",
		out:  "‛．~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ␀~\x02",
	}, { // 994
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "q~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ\x00~.",
		out:  "q~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ␀~.",
	}, { // 995
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "q~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ\x00~．",
		out:  "q~\x1eρυ\x05１E\x1fwd␊F␐Ｌξ：＄５uｆ\x1aοω／）δ␀~．",
	}, { // 996
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚]<\x0e~#",
		out:  "．~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚］<\x0e~#",
	}, { // 997
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚]<\x0e~#",
		out:  "‛．~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚］<\x0e~#",
	}, { // 998
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␗~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚]<\x0e~.",
		out:  "␗~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚］<\x0e~.",
	}, { // 999
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␗~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚]<\x0e~．",
		out:  "␗~ς＞γ<-K＃２πα\x01ο␈nＥ␟\x18>␛｛+ｏ␚］<\x0e~．",
	}, { // 1000
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~␇",
		out:  "．~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~␇",
	}, { // 1001
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~␇",
		out:  "‛．~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~␇",
	}, { // 1002
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␊~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~.",
		out:  "␊~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~.",
	}, { // 1003
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␊~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~．",
		out:  "␊~\x17σ␉／θ\tχ８D␜χ|)ｒ␍ｏｓ\x16σDｑ!\x1a\x10μ\x01~．",
	}, { // 1004
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ε␡ζ␞｛｜ε\x02φ］５\x10␀\f\uff00␄F＋\aα＞ｓ\x18b]G~+",
		out:  "．~ε␡ζ␞｛｜ε\x02φ］５\x10‛␀\f\uff00␄F＋\aα＞ｓ\x18b]G~+",
	}, { // 1005
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ε␡ζ␞｛｜ε\x02φ］５\x10␀\f\uff00␄F＋\aα＞ｓ\x18b]G~+",
		out:  "‛．~ε␡ζ␞｛｜ε\x02φ］５\x10‛␀\f\uff00␄F＋\aα＞ｓ\x18b]G~+",
	}, { // 1006
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "τ~ε␡ζ␞｛｜ε\x02φ］５\x10␀\f\uff00␄F＋\aα＞ｓ\x18b]G~.",
		out:  "τ~ε␡ζ␞｛｜ε\x02φ］５\x10‛␀\f\uff00␄F＋\aα＞ｓ\x18b]G~.",
	}, { // 1007
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "τ~ε␡ζ␞｛｜ε\x02φ］５\x10␀\f\uff00␄F＋\aα＞ｓ\x18b]G~．",
		out:  "τ~ε␡ζ␞｛｜ε\x02φ］５\x10‛␀\f\uff00␄F＋\aα＞ｓ\x18b]G~．",
	}, { // 1008
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~～ｗ｜\x06＊Ｎi:＇\"!δ］*␀θι\x1dg␞ς9＋πo*~e",
		out:  "．~～ｗ｜\x06＊Ｎi:＇\"!δ］*‛␀θι\x1dg␞ς9＋πo*~e",
	}, { // 1009
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~～ｗ｜\x06＊Ｎi:＇\"!δ］*␀θι\x1dg␞ς9＋πo*~e",
		out:  "‛．~～ｗ｜\x06＊Ｎi:＇\"!δ］*‛␀θι\x1dg␞ς9＋πo*~e",
	}, { // 1010
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "；~～ｗ｜\x06＊Ｎi:＇\"!δ］*␀θι\x1dg␞ς9＋πo*~.",
		out:  "；~～ｗ｜\x06＊Ｎi:＇\"!δ］*‛␀θι\x1dg␞ς9＋πo*~.",
	}, { // 1011
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "；~～ｗ｜\x06＊Ｎi:＇\"!δ］*␀θι\x1dg␞ς9＋πo*~．",
		out:  "；~～ｗ｜\x06＊Ｎi:＇\"!δ］*‛␀θι\x1dg␞ς9＋πo*~．",
	}, { // 1012
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~\x01",
		out:  "．~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~\x01",
	}, { // 1013
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~\x01",
		out:  "‛．~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~\x01",
	}, { // 1014
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\b~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~.",
		out:  "\b~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~.",
	}, { // 1015
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\b~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~．",
		out:  "\b~μ\x19νκ>␂x｝,Ｚ\x1d␝＿␍Oλ，␅＋Dς＄ｇμ␌.~．",
	}, { // 1016
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~ｃ",
		out:  "．~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~ｃ",
	}, { // 1017
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~ｃ",
		out:  "‛．~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~ｃ",
	}, { // 1018
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␊~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~.",
		out:  "␊~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~.",
	}, { // 1019
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␊~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~．",
		out:  "␊~＿γi\x1c（τ\b␙\x1fχρ␌\x1aＱκ＿zＣ；?Kiξ'+␂~．",
	}, { // 1020
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~g",
		out:  "．~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~g",
	}, { // 1021
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~g",
		out:  "‛．~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~g",
	}, { // 1022
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "Ｃ~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~.",
		out:  "Ｃ~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~.",
	}, { // 1023
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "Ｃ~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~．",
		out:  "Ｃ~\x04Ａ>ς␌.\b␏\n␇．ε␘｝ιＭ|\rεu*ｄ7␇\x1c␒~．",
	}, { // 1024
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ*κ[/~\x00",
		out:  "．~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ＊κ[/~␀",
	}, { // 1025
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ*κ[/~\x00",
		out:  "‛．~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ＊κ[/~␀",
	}, { // 1026
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␐~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ*κ[/~.",
		out:  "␐~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ＊κ[/~.",
	}, { // 1027
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "␐~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ*κ[/~．",
		out:  "␐~ρN\x01＂␡5ｋ␘？；\"％δγωP<<［␁\nＲ＊κ[/~．",
	}, { // 1028
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~x",
		out:  "．~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~x",
	}, { // 1029
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~x",
		out:  "‛．~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~x",
	}, { // 1030
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\r~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~.",
		out:  "\r~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~.",
	}, { // 1031
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\r~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~．",
		out:  "\r~/｀\x18Ｅζ␊rγι\x16␓Ａ5\x13ｕ，ｘ9ω＂$␓θ␘κ~~．",
	}, { // 1032
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~(",
		out:  "．~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~(",
	}, { // 1033
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~(",
		out:  "‛．~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~(",
	}, { // 1034
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\t~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~.",
		out:  "\t~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~.",
	}, { // 1035
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\t~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~．",
		out:  "\t~？／␔ｄｏm＠f０␜σ\n\x01␍eοβ[:ζｗψτ␑\r\x02~．",
	}, { // 1036
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~f",
		out:  "．~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~f",
	}, { // 1037
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~f",
		out:  "‛．~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~f",
	}, { // 1038
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "（~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~.",
		out:  "（~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~.",
	}, { // 1039
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "（~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~．",
		out:  "（~＜␉ο\x011λ\x1c\x7fι\x1aδ＞；\\［｛m\n｀9ＵX␔＇>γ~．",
	}, { // 1040
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~/",
		out:  "．~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~/",
	}, { // 1041
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~/",
		out:  "‛．~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~/",
	}, { // 1042
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\n~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~.",
		out:  "\n~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~.",
	}, { // 1043
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\n~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~．",
		out:  "\n~␝@␏ｌτ␊\x1a３dω\x12／η>ςｊ\x19／␒：～J；,:ζ~．",
	}, { // 1044
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~*\n｀ν＃\a␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈\nυ␞~λ",
		out:  "．~*␊｀ν＃\a‛␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈␊υ␞~λ",
	}, { // 1045
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~*\n｀ν＃\a␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈\nυ␞~λ",
		out:  "‛．~*␊｀ν＃\a‛␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈␊υ␞~λ",
	}, { // 1046
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   " ~*\n｀ν＃\a␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈\nυ␞~.",
		out:  " ~*␊｀ν＃\a‛␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈␊υ␞~.",
	}, { // 1047
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   " ~*\n｀ν＃\a␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈\nυ␞~．",
		out:  " ~*␊｀ν＃\a‛␊＊Bｒ\x03q.ωＹ0␌␋θU４>␈␊υ␞~．",
	}, { // 1048
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~Ｈ",
		out:  "．~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~Ｈ",
	}, { // 1049
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~Ｈ",
		out:  "‛．~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~Ｈ",
	}, { // 1050
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x12~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~.",
		out:  "\x12~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~.",
	}, { // 1051
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x12~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~．",
		out:  "\x12~\x01|σ/α␙＄>S␂r␔\x11ｖ\x10ａzＬφ4η（η␃␌{~．",
	}, { // 1052
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\\'χ5␕χ＜zψ\x18ＫH\x1c\x15\tＣ␍｀␜χ%κ／\x1eＬ␛~＂",
		out:  "．~\\'χ5‛␕χ＜zψ␘ＫH␜␕␉Ｃ‛␍｀‛␜χ%κ／␞Ｌ‛␛~＂",
	}, { // 1053
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\\'χ5␕χ＜zψ\x18ＫH\x1c\x15\tＣ␍｀␜χ%κ／\x1eＬ␛~＂",
		out:  "‛．~\\'χ5‛␕χ＜zψ␘ＫH␜␕␉Ｃ‛␍｀‛␜χ%κ／␞Ｌ‛␛~＂",
	}, { // 1054
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "π~\\'χ5␕χ＜zψ\x18ＫH\x1c\x15\tＣ␍｀␜χ%κ／\x1eＬ␛~.",
		out:  "π~\\'χ5‛␕χ＜zψ␘ＫH␜␕␉Ｃ‛␍｀‛␜χ%κ／␞Ｌ‛␛~.",
	}, { // 1055
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "π~\\'χ5␕χ＜zψ\x18ＫH\x1c\x15\tＣ␍｀␜χ%κ／\x1eＬ␛~．",
		out:  "π~\\'χ5‛␕χ＜zψ␘ＫH␜␕␉Ｃ‛␍｀‛␜χ%κ／␞Ｌ‛␛~．",
	}, { // 1056
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\tε",
		out:  "．\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\tε",
	}, { // 1057
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\tε",
		out:  "‛．\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\tε",
	}, { // 1058
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\nε",
		out:  "．\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\nε",
	}, { // 1059
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\nε",
		out:  "‛．\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\nε",
	}, { // 1060
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\vε",
		out:  "．\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\vε",
	}, { // 1061
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\vε",
		out:  "‛．\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\vε",
	}, { // 1062
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\rε",
		out:  "．\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\rε",
	}, { // 1063
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\rε",
		out:  "‛．\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\rε",
	}, { // 1064
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\t.",
		out:  "A\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\t.",
	}, { // 1065
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\t．",
		out:  "A\t\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\t．",
	}, { // 1066
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\n.",
		out:  "A\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\n.",
	}, { // 1067
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\n．",
		out:  "A\n\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\n．",
	}, { // 1068
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\v.",
		out:  "A\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\v.",
	}, { // 1069
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\v．",
		out:  "A\v\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\v．",
	}, { // 1070
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\r.",
		out:  "A\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\r.",
	}, { // 1071
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "A\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\r．",
		out:  "A\r\r'σＯT｀\x1a['\x7f＂{dz．ν＜φ７\x11ψδ␌␘８｜\r．",
	}, { // 1072
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\tO",
		out:  "．\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\tO",
	}, { // 1073
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\tO",
		out:  "‛．\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\tO",
	}, { // 1074
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\nO",
		out:  "．\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\nO",
	}, { // 1075
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\nO",
		out:  "‛．\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\nO",
	}, { // 1076
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\vO",
		out:  "．\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\vO",
	}, { // 1077
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\vO",
		out:  "‛．\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\vO",
	}, { // 1078
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\rO",
		out:  "．\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\rO",
	}, { // 1079
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\rO",
		out:  "‛．\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\rO",
	}, { // 1080
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\t.",
		out:  "＄\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\t.",
	}, { // 1081
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\t．",
		out:  "＄\tＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\t．",
	}, { // 1082
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\n.",
		out:  "＄\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\n.",
	}, { // 1083
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\n．",
		out:  "＄\nＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\n．",
	}, { // 1084
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\v.",
		out:  "＄\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\v.",
	}, { // 1085
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\v．",
		out:  "＄\vＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\v．",
	}, { // 1086
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\r.",
		out:  "＄\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\r.",
	}, { // 1087
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＄\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\r．",
		out:  "＄\rＥ\n␂τE\x18ωVＹησ␁␟ｎ␇␙`＿ρ．Ｐn\"υ\x19<\r．",
	}, { // 1088
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\t\x1b",
		out:  "．\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\t\x1b",
	}, { // 1089
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\t\x1b",
		out:  "‛．\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\t\x1b",
	}, { // 1090
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\n\x1b",
		out:  "．\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\n\x1b",
	}, { // 1091
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\n\x1b",
		out:  "‛．\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\n\x1b",
	}, { // 1092
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\v\x1b",
		out:  "．\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\v\x1b",
	}, { // 1093
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\v\x1b",
		out:  "‛．\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\v\x1b",
	}, { // 1094
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\r\x1b",
		out:  "．\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\r\x1b",
	}, { // 1095
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\r\x1b",
		out:  "‛．\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\r\x1b",
	}, { // 1096
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\t.",
		out:  "ρ\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\t.",
	}, { // 1097
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\t．",
		out:  "ρ\t＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\t．",
	}, { // 1098
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\n.",
		out:  "ρ\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\n.",
	}, { // 1099
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\n．",
		out:  "ρ\n＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\n．",
	}, { // 1100
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\v.",
		out:  "ρ\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\v.",
	}, { // 1101
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\v．",
		out:  "ρ\v＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\v．",
	}, { // 1102
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\r.",
		out:  "ρ\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\r.",
	}, { // 1103
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ρ\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!␀␁Ｔα！␖＂\r．",
		out:  "ρ\r＆/+\r}τμ␌ｐ_ｚxχοL\x12＋D!‛␀␁Ｔα！␖＂\r．",
	}, { // 1104
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t␇",
		out:  "．\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t␇",
	}, { // 1105
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t␇",
		out:  "‛．\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t␇",
	}, { // 1106
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n␇",
		out:  "．\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n␇",
	}, { // 1107
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n␇",
		out:  "‛．\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n␇",
	}, { // 1108
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v␇",
		out:  "．\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v␇",
	}, { // 1109
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v␇",
		out:  "‛．\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v␇",
	}, { // 1110
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r␇",
		out:  "．\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r␇",
	}, { // 1111
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r␇",
		out:  "‛．\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r␇",
	}, { // 1112
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t.",
		out:  "ω\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t.",
	}, { // 1113
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t．",
		out:  "ω\t␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\t．",
	}, { // 1114
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n.",
		out:  "ω\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n.",
	}, { // 1115
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n．",
		out:  "ω\n␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\n．",
	}, { // 1116
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v.",
		out:  "ω\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v.",
	}, { // 1117
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v．",
		out:  "ω\v␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\v．",
	}, { // 1118
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r.",
		out:  "ω\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r.",
	}, { // 1119
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ω\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r．",
		out:  "ω\r␌\rｙ␄␜>\nη[>τε｛\v\\(iｏ\x1c－Ｌ４υγ␒!\r．",
	}, { // 1120
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t␏",
		out:  "．\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t␏",
	}, { // 1121
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t␏",
		out:  "‛．\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t␏",
	}, { // 1122
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n␏",
		out:  "．\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n␏",
	}, { // 1123
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n␏",
		out:  "‛．\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n␏",
	}, { // 1124
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v␏",
		out:  "．\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v␏",
	}, { // 1125
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v␏",
		out:  "‛．\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v␏",
	}, { // 1126
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r␏",
		out:  "．\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r␏",
	}, { // 1127
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r␏",
		out:  "‛．\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r␏",
	}, { // 1128
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t.",
		out:  "σ\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t.",
	}, { // 1129
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t．",
		out:  "σ\tδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\t．",
	}, { // 1130
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n.",
		out:  "σ\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n.",
	}, { // 1131
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n．",
		out:  "σ\nδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\n．",
	}, { // 1132
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v.",
		out:  "σ\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v.",
	}, { // 1133
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v．",
		out:  "σ\vδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\v．",
	}, { // 1134
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r.",
		out:  "σ\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r.",
	}, { // 1135
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "σ\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r．",
		out:  "σ\rδY\x0fψ＼P\x06Ｗ␘w␞E\tｌδ\x03|␒␘␍ｒδ５C\x05σ\r．",
	}, { // 1136
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t\x17",
		out:  "．\t\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t\x17",
	}, { // 1137
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t\x17",
		out:  "‛．\t\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t\x17",
	}, { // 1138
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n\x17",
		out:  "．\n\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n\x17",
	}, { // 1139
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n\x17",
		out:  "‛．\n\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n\x17",
	}, { // 1140
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v\x17",
		out:  "．\v\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v\x17",
	}, { // 1141
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v\x17",
		out:  "‛．\v\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v\x17",
	}, { // 1142
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r\x17",
		out:  "．\r\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r\x17",
	}, { // 1143
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r\x17",
		out:  "‛．\r\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r\x17",
	}, { // 1144
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\t\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t.",
		out:  "α\t\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t.",
	}, { // 1145
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\t\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t．",
		out:  "α\t\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\t．",
	}, { // 1146
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\n\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n.",
		out:  "α\n\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n.",
	}, { // 1147
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\n\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n．",
		out:  "α\n\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\n．",
	}, { // 1148
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\v\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v.",
		out:  "α\v\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v.",
	}, { // 1149
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\v\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v．",
		out:  "α\v\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\v．",
	}, { // 1150
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\r\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r.",
		out:  "α\r\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r.",
	}, { // 1151
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "α\r\r=］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r．",
		out:  "α\r\r=‛］*Ｅτ｀Jρ\x12 ／\x13｛ｎ:␎&\x11␇φ９＞Hψι\r．",
	}, { // 1152
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t５",
		out:  "．\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t５",
	}, { // 1153
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t５",
		out:  "‛．\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t５",
	}, { // 1154
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n５",
		out:  "．\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n５",
	}, { // 1155
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n５",
		out:  "‛．\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n５",
	}, { // 1156
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v５",
		out:  "．\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v５",
	}, { // 1157
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v５",
		out:  "‛．\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v５",
	}, { // 1158
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r５",
		out:  "．\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r５",
	}, { // 1159
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r５",
		out:  "‛．\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r５",
	}, { // 1160
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t.",
		out:  "，\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t.",
	}, { // 1161
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t．",
		out:  "，\tＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\t．",
	}, { // 1162
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n.",
		out:  "，\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n.",
	}, { // 1163
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n．",
		out:  "，\nＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\n．",
	}, { // 1164
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v.",
		out:  "，\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v.",
	}, { // 1165
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v．",
		out:  "，\vＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\v．",
	}, { // 1166
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r.",
		out:  "，\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r.",
	}, { // 1167
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "，\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r．",
		out:  "，\rＦ|\x1co'\x15γξ.δｚ!ςθ/ＹＵ␐\x101％υ␝␒␂[\r．",
	}, { // 1168
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\tτ",
		out:  "．\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\tτ",
	}, { // 1169
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\tτ",
		out:  "‛．\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\tτ",
	}, { // 1170
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\nτ",
		out:  "．\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\nτ",
	}, { // 1171
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\nτ",
		out:  "‛．\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\nτ",
	}, { // 1172
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\vτ",
		out:  "．\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\vτ",
	}, { // 1173
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\vτ",
		out:  "‛．\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\vτ",
	}, { // 1174
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\rτ",
		out:  "．\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\rτ",
	}, { // 1175
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\rτ",
		out:  "‛．\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\rτ",
	}, { // 1176
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\t.",
		out:  "\x06\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\t.",
	}, { // 1177
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\t．",
		out:  "\x06\tizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\t．",
	}, { // 1178
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\n.",
		out:  "\x06\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\n.",
	}, { // 1179
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\n．",
		out:  "\x06\nizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\n．",
	}, { // 1180
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\v.",
		out:  "\x06\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\v.",
	}, { // 1181
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\v．",
		out:  "\x06\vizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\v．",
	}, { // 1182
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\r.",
		out:  "\x06\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\r.",
	}, { // 1183
		mask: EncodeExclamation | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\r．",
		out:  "\x06\rizξ＋'．/＇ｌκ\a＃（？\uff00\x19υ｜1ο<γ␗6\x15␍\r．",
	}, { // 1184
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t␟",
		out:  "．\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t␟",
	}, { // 1185
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t␟",
		out:  "‛．\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t␟",
	}, { // 1186
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n␟",
		out:  "．\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n␟",
	}, { // 1187
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n␟",
		out:  "‛．\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n␟",
	}, { // 1188
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v␟",
		out:  "．\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v␟",
	}, { // 1189
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v␟",
		out:  "‛．\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v␟",
	}, { // 1190
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r␟",
		out:  "．\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r␟",
	}, { // 1191
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r␟",
		out:  "‛．\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r␟",
	}, { // 1192
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t.",
		out:  "ａ\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t.",
	}, { // 1193
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t．",
		out:  "ａ\t\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\t．",
	}, { // 1194
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n.",
		out:  "ａ\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n.",
	}, { // 1195
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n．",
		out:  "ａ\n\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\n．",
	}, { // 1196
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v.",
		out:  "ａ\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v.",
	}, { // 1197
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v．",
		out:  "ａ\v\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\v．",
	}, { // 1198
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r.",
		out:  "ａ\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r.",
	}, { // 1199
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ａ\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r．",
		out:  "ａ\r\x01t６/ｋχ２τG␛␕\nσI］Dκθ*Ｎ␅ｈ<［\x0e_\r．",
	}, { // 1200
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t␐",
		out:  "．\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t␐",
	}, { // 1201
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t␐",
		out:  "‛．\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t␐",
	}, { // 1202
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n␐",
		out:  "．\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n␐",
	}, { // 1203
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n␐",
		out:  "‛．\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n␐",
	}, { // 1204
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v␐",
		out:  "．\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v␐",
	}, { // 1205
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v␐",
		out:  "‛．\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v␐",
	}, { // 1206
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r␐",
		out:  "．\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r␐",
	}, { // 1207
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r␐",
		out:  "‛．\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r␐",
	}, { // 1208
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t.",
		out:  "＇\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t.",
	}, { // 1209
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t．",
		out:  "＇\tοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\t．",
	}, { // 1210
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n.",
		out:  "＇\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n.",
	}, { // 1211
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n．",
		out:  "＇\nοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\n．",
	}, { // 1212
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v.",
		out:  "＇\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v.",
	}, { // 1213
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v．",
		out:  "＇\vοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\v．",
	}, { // 1214
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r.",
		out:  "＇\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r.",
	}, { // 1215
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＇\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r．",
		out:  "＇\rοφ␕2\b/Ｆ\x1f，\\␏1}τY\x17ι＾Ｏ\x13Ｈ\nｑ／ι␅\r．",
	}, { // 1216
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\tM",
		out:  "．\tσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\tM",
	}, { // 1217
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\tM",
		out:  "‛．\tσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\tM",
	}, { // 1218
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\nM",
		out:  "．\nσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\nM",
	}, { // 1219
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\nM",
		out:  "‛．\nσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\nM",
	}, { // 1220
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\vM",
		out:  "．\vσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\vM",
	}, { // 1221
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\vM",
		out:  "‛．\vσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\vM",
	}, { // 1222
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\rM",
		out:  "．\rσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\rM",
	}, { // 1223
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\rM",
		out:  "‛．\rσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\rM",
	}, { // 1224
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\tσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\t.",
		out:  "ξ\tσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\t.",
	}, { // 1225
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\tσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\t．",
		out:  "ξ\tσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\t．",
	}, { // 1226
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\nσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\n.",
		out:  "ξ\nσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\n.",
	}, { // 1227
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\nσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\n．",
		out:  "ξ\nσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\n．",
	}, { // 1228
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\vσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\v.",
		out:  "ξ\vσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\v.",
	}, { // 1229
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\vσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\v．",
		out:  "ξ\vσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\v．",
	}, { // 1230
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\rσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\r.",
		out:  "ξ\rσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\r.",
	}, { // 1231
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\rσw:Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\r．",
		out:  "ξ\rσw：Ｄ(O$］ω\bχδI？\x1c␊\nζＰ␏␊＋␒ｏ\x01）\r．",
	}, { // 1232
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\tａ",
		out:  "．\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\tａ",
	}, { // 1233
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\tａ",
		out:  "‛．\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\tａ",
	}, { // 1234
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\nａ",
		out:  "．\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\nａ",
	}, { // 1235
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\nａ",
		out:  "‛．\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\nａ",
	}, { // 1236
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\vａ",
		out:  "．\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\vａ",
	}, { // 1237
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\vａ",
		out:  "‛．\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\vａ",
	}, { // 1238
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\rａ",
		out:  "．\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\rａ",
	}, { // 1239
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\rａ",
		out:  "‛．\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\rａ",
	}, { // 1240
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\t.",
		out:  ">\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\t.",
	}, { // 1241
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\t．",
		out:  ">\tκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\t．",
	}, { // 1242
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\n.",
		out:  ">\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\n.",
	}, { // 1243
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\n．",
		out:  ">\nκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\n．",
	}, { // 1244
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\v.",
		out:  ">\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\v.",
	}, { // 1245
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\v．",
		out:  ">\vκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\v．",
	}, { // 1246
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\r.",
		out:  ">\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\r.",
	}, { // 1247
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ">\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα␀\r．",
		out:  ">\rκψ␂χκ\x15７RυU*Ｊ␐V␁\x10\fＹｙ３＄_␘Dα‛␀\r．",
	}, { // 1248
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t／",
		out:  "．\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t／",
	}, { // 1249
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t／",
		out:  "‛．\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t／",
	}, { // 1250
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n／",
		out:  "．\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n／",
	}, { // 1251
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n／",
		out:  "‛．\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n／",
	}, { // 1252
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v／",
		out:  "．\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v／",
	}, { // 1253
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v／",
		out:  "‛．\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v／",
	}, { // 1254
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r／",
		out:  "．\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r／",
	}, { // 1255
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r／",
		out:  "‛．\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r／",
	}, { // 1256
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t.",
		out:  "␁\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t.",
	}, { // 1257
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t．",
		out:  "␁\tκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\t．",
	}, { // 1258
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n.",
		out:  "␁\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n.",
	}, { // 1259
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n．",
		out:  "␁\nκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\n．",
	}, { // 1260
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v.",
		out:  "␁\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v.",
	}, { // 1261
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v．",
		out:  "␁\vκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\v．",
	}, { // 1262
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r.",
		out:  "␁\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r.",
	}, { // 1263
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r．",
		out:  "␁\rκ␎ωｅ[!i␃\t２λχθ␆χ\n^＞\\ｍＨQ\x0f\\ｘ\"\r．",
	}, { // 1264
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\tψ",
		out:  "．\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\tψ",
	}, { // 1265
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\tψ",
		out:  "‛．\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\tψ",
	}, { // 1266
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\nψ",
		out:  "．\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\nψ",
	}, { // 1267
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\nψ",
		out:  "‛．\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\nψ",
	}, { // 1268
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\vψ",
		out:  "．\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\vψ",
	}, { // 1269
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\vψ",
		out:  "‛．\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\vψ",
	}, { // 1270
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\rψ",
		out:  "．\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\rψ",
	}, { // 1271
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\rψ",
		out:  "‛．\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\rψ",
	}, { // 1272
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\t.",
		out:  "＠\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\t.",
	}, { // 1273
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\t．",
		out:  "＠\tG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\t．",
	}, { // 1274
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\n.",
		out:  "＠\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\n.",
	}, { // 1275
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\n．",
		out:  "＠\nG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\n．",
	}, { // 1276
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\v.",
		out:  "＠\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\v.",
	}, { // 1277
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\v．",
		out:  "＠\vG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\v．",
	}, { // 1278
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\r.",
		out:  "＠\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\r.",
	}, { // 1279
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "＠\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\r．",
		out:  "＠\rG8Ｘ6ψκM#%\x10χ＊␍γ\x1f\x02␒８]／U）γ＜：＂\r．",
	}, { // 1280
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t#",
		out:  "．\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t＃",
	}, { // 1281
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t#",
		out:  "‛．\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t＃",
	}, { // 1282
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n#",
		out:  "．\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n＃",
	}, { // 1283
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n#",
		out:  "‛．\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n＃",
	}, { // 1284
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v#",
		out:  "．\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v＃",
	}, { // 1285
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v#",
		out:  "‛．\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v＃",
	}, { // 1286
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r#",
		out:  "．\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r＃",
	}, { // 1287
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r#",
		out:  "‛．\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r＃",
	}, { // 1288
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t.",
		out:  "κ\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t.",
	}, { // 1289
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t．",
		out:  "κ\t＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\t．",
	}, { // 1290
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n.",
		out:  "κ\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n.",
	}, { // 1291
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n．",
		out:  "κ\n＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\n．",
	}, { // 1292
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v.",
		out:  "κ\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v.",
	}, { // 1293
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v．",
		out:  "κ\v＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\v．",
	}, { // 1294
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r.",
		out:  "κ\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r.",
	}, { // 1295
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "κ\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r．",
		out:  "κ\r＂\x11]RWξＰ\n\x1dι3９＠＂θ}Ａ␍␍␇␉πδ\a:＞\r．",
	}, { // 1296
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t2",
		out:  "．\tι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t2",
	}, { // 1297
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t2",
		out:  "‛．\tι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t2",
	}, { // 1298
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n2",
		out:  "．\nι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n2",
	}, { // 1299
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n2",
		out:  "‛．\nι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n2",
	}, { // 1300
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v2",
		out:  "．\vι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v2",
	}, { // 1301
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v2",
		out:  "‛．\vι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v2",
	}, { // 1302
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r2",
		out:  "．\rι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r2",
	}, { // 1303
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r2",
		out:  "‛．\rι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r2",
	}, { // 1304
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\tι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t.",
		out:  "a\tι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t.",
	}, { // 1305
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\tι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t．",
		out:  "a\tι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\t．",
	}, { // 1306
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\nι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n.",
		out:  "a\nι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n.",
	}, { // 1307
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\nι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n．",
		out:  "a\nι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\n．",
	}, { // 1308
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\vι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v.",
		out:  "a\vι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v.",
	}, { // 1309
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\vι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v．",
		out:  "a\vι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\v．",
	}, { // 1310
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\rι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r.",
		out:  "a\rι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r.",
	}, { // 1311
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "a\rι␀ｋ␉τ\x16ｓ％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r．",
		out:  "a\rι‛␀ｋ␉τ\x16ｓ‛％９Ｑh*iγψＨ\x11>>*␡␂>␅οv\r．",
	}, { // 1312
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\tρ",
		out:  "．\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\tρ",
	}, { // 1313
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\tρ",
		out:  "‛．\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\tρ",
	}, { // 1314
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\nρ",
		out:  "．\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\nρ",
	}, { // 1315
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\nρ",
		out:  "‛．\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\nρ",
	}, { // 1316
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\vρ",
		out:  "．\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\vρ",
	}, { // 1317
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\vρ",
		out:  "‛．\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\vρ",
	}, { // 1318
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\rρ",
		out:  "．\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\rρ",
	}, { // 1319
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\rρ",
		out:  "‛．\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\rρ",
	}, { // 1320
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\t.",
		out:  "␃\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\t.",
	}, { // 1321
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\t．",
		out:  "␃\tχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\t．",
	}, { // 1322
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\n.",
		out:  "␃\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\n.",
	}, { // 1323
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\n．",
		out:  "␃\nχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\n．",
	}, { // 1324
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\v.",
		out:  "␃\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\v.",
	}, { // 1325
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\v．",
		out:  "␃\vχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\v．",
	}, { // 1326
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\r.",
		out:  "␃\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\r.",
	}, { // 1327
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␃\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\r．",
		out:  "␃\rχ｀*Ｅ4Mｉ\rｉ:?φ\x15？ζ／Ｖ␃\uff00}＃\">9ο␌\r．",
	}, { // 1328
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\tD",
		out:  "．\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\tD",
	}, { // 1329
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\tD",
		out:  "‛．\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\tD",
	}, { // 1330
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\nD",
		out:  "．\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\nD",
	}, { // 1331
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\nD",
		out:  "‛．\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\nD",
	}, { // 1332
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\vD",
		out:  "．\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\vD",
	}, { // 1333
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\vD",
		out:  "‛．\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\vD",
	}, { // 1334
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\rD",
		out:  "．\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\rD",
	}, { // 1335
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\rD",
		out:  "‛．\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\rD",
	}, { // 1336
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\t.",
		out:  "i\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\t.",
	}, { // 1337
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\t．",
		out:  "i\tκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\t．",
	}, { // 1338
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\n.",
		out:  "i\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\n.",
	}, { // 1339
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\n．",
		out:  "i\nκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\n．",
	}, { // 1340
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\v.",
		out:  "i\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\v.",
	}, { // 1341
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\v．",
		out:  "i\vκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\v．",
	}, { // 1342
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\r.",
		out:  "i\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\r.",
	}, { // 1343
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "i\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\r．",
		out:  "i\rκ␎５δq｀＜\x18Ｋ\x02σσ｀１b／μ＇␊7C?\x10$Ｐｆ\r．",
	}, { // 1344
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". |＜＋\x00％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P \x14",
		out:  "． |＜＋␀％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P \x14",
	}, { // 1345
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． |＜＋\x00％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P \x14",
		out:  "‛． |＜＋␀％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P \x14",
	}, { // 1346
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␃ |＜＋\x00％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P .",
		out:  "␃ |＜＋␀％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P .",
	}, { // 1347
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␃ |＜＋\x00％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P ．",
		out:  "␃ |＜＋␀％ｉ？KS^κ;$Ｎαυυ｛<\v％ｊ＊κ\x12P ．",
	}, { // 1348
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ ι",
		out:  "． γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ ι",
	}, { // 1349
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ ι",
		out:  "‛． γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ ι",
	}, { // 1350
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "－ γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ .",
		out:  "－ γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ .",
	}, { // 1351
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "－ γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ ．",
		out:  "－ γsｌ＜L]␗ξ8␈(\\ｃ＞ο;ω␅\x16\x1a＄｝ｊ\nβ+ ．",
	}, { // 1352
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ δ",
		out:  "． θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ δ",
	}, { // 1353
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ δ",
		out:  "‛． θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ δ",
	}, { // 1354
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␀ θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ .",
		out:  "‛␀ θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ .",
	}, { // 1355
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␀ θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ ．",
		out:  "‛␀ θ|ｑＺκＩ％\x7f[␙;υω$␑GX＂\x1dς＋1０}\x18＼ ．",
	}, { // 1356
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n ＇",
		out:  "． pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n ＇",
	}, { // 1357
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n ＇",
		out:  "‛． pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n ＇",
	}, { // 1358
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "v pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n .",
		out:  "v pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n .",
	}, { // 1359
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "v pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n ．",
		out:  "v pｓ\x01＃\x13Ｈ␔N\tＪｊω␂ρ␚␁ρθ␍Ｏqκ[υ\"\n ．",
	}, { // 1360
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r ／",
		out:  "． Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r ／",
	}, { // 1361
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r ／",
		out:  "‛． Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r ／",
	}, { // 1362
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ｊ Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r .",
		out:  "ｊ Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r .",
	}, { // 1363
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ｊ Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r ．",
		out:  "ｊ Ｃ*τ%#\x1d\x17！dD␉τ|／␗＇ψsＦＦνH8ς｀\r ．",
	}, { // 1364
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␎\x12Z-／δ+C\x00\"＿;μιξ＃ς［Ｒ\x1eC\x03＾␁｜β Ａ",
		out:  "． ␎\x12Z-／δ+C␀\"＿;μιξ＃ς‛［Ｒ\x1eC\x03＾␁｜β Ａ",
	}, { // 1365
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␎\x12Z-／δ+C\x00\"＿;μιξ＃ς［Ｒ\x1eC\x03＾␁｜β Ａ",
		out:  "‛． ␎\x12Z-／δ+C␀\"＿;μιξ＃ς‛［Ｒ\x1eC\x03＾␁｜β Ａ",
	}, { // 1366
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␚ ␎\x12Z-／δ+C\x00\"＿;μιξ＃