/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     Y_cast = 258,
     Y_const_ENG = 259,
     Y_declare = 260,
     Y_define = 261,
     Y_dynamic = 262,
     Y_explain = 263,
     Y_help = 264,
     Y_no = 265,
     Y_quit = 266,
     Y_reinterpret = 267,
     Y_set = 268,
     Y_show = 269,
     Y_aligned = 270,
     Y_all = 271,
     Y_array = 272,
     Y_as = 273,
     Y_bit = 274,
     Y_bit_precise = 275,
     Y_bits = 276,
     Y_by = 277,
     Y_bytes = 278,
     Y_capturing = 279,
     Y_commands = 280,
     Y_constructor = 281,
     Y_conversion = 282,
     Y_copy = 283,
     Y_defined = 284,
     Y_destructor = 285,
     Y_english = 286,
     Y_evaluation = 287,
     Y_expression = 288,
     Y_floating = 289,
     Y_function = 290,
     Y_initialization = 291,
     Y_into = 292,
     Y_lambda = 293,
     Y_length = 294,
     Y_linkage = 295,
     Y_literal = 296,
     Y_member = 297,
     Y_non_member = 298,
     Y_of = 299,
     Y_options = 300,
     Y_point = 301,
     Y_pointer = 302,
     Y_precise = 303,
     Y_precision = 304,
     Y_predefined = 305,
     Y_pure = 306,
     Y_reference = 307,
     Y_returning = 308,
     Y_rvalue = 309,
     Y_scope = 310,
     Y_to = 311,
     Y_user = 312,
     Y_user_defined = 313,
     Y_variable = 314,
     Y_wide = 315,
     Y_width = 316,
     Y_PREC_LESS_THAN_upc_layout_qualifier = 317,
     Y_COLON2 = 319,
     Y_COLON2_STAR = 321,
     Y_PLUS2 = 322,
     Y_MINUS2 = 323,
     Y_ARROW = 325,
     Y_TILDE = 326,
     Y_sizeof = 327,
     Y_EXCLAM = 328,
     Y_AMPER = 329,
     Y_ARROW_STAR = 332,
     Y_DOT_STAR = 333,
     Y_GREATER2 = 336,
     Y_LESS2 = 337,
     Y_LESS_EQUAL_GREATER = 339,
     Y_GREATER_EQUAL = 342,
     Y_LESS_EQUAL = 343,
     Y_EXCLAM_EQUAL = 345,
     Y_EQUAL2 = 346,
     Y_bit_and = 347,
     Y_CARET = 348,
     Y_PIPE = 349,
     Y_AMPER2 = 350,
     Y_PIPE2 = 351,
     Y_PIPE_EQUAL = 360,
     Y_CARET_EQUAL = 361,
     Y_GREATER2_EQUAL = 362,
     Y_LESS2_EQUAL = 363,
     Y_SLASH_EQUAL = 364,
     Y_MINUS_EQUAL = 365,
     Y_PLUS_EQUAL = 366,
     Y_STAR_EQUAL = 367,
     Y_AMPER_EQUAL = 368,
     Y_PERCENT_EQUAL = 369,
     Y_QMARK_COLON = 370,
     Y_auto_STORAGE = 371,
     Y_break = 372,
     Y_case = 373,
     Y_char = 374,
     Y_continue = 375,
     Y_default = 376,
     Y_do = 377,
     Y_double = 378,
     Y_else = 379,
     Y_extern = 380,
     Y_float = 381,
     Y_for = 382,
     Y_goto = 383,
     Y_if = 384,
     Y_int = 385,
     Y_long = 386,
     Y_register = 387,
     Y_return = 388,
     Y_short = 389,
     Y_static = 390,
     Y_struct = 391,
     Y_switch = 392,
     Y_typedef = 393,
     Y_union = 394,
     Y_unsigned = 395,
     Y_while = 396,
     Y_asm = 397,
     Y_const = 398,
     Y_ELLIPSIS = 399,
     Y_enum = 400,
     Y_signed = 401,
     Y_void = 402,
     Y_volatile = 403,
     Y_wchar_t = 404,
     Y__Bool = 405,
     Y__Complex = 406,
     Y__Imaginary = 407,
     Y_inline = 408,
     Y_restrict = 409,
     Y__Alignas = 410,
     Y__Alignof = 411,
     Y__Atomic_QUAL = 412,
     Y__Atomic_SPEC = 413,
     Y__Generic = 414,
     Y__Noreturn = 415,
     Y__Static_assert = 416,
     Y__Thread_local = 417,
     Y_thread = 418,
     Y_local = 419,
     Y_bool = 420,
     Y_catch = 421,
     Y_class = 422,
     Y_const_cast = 423,
     Y_CONSTRUCTOR_SNAME = 424,
     Y_delete = 425,
     Y_DESTRUCTOR_SNAME = 426,
     Y_dynamic_cast = 427,
     Y_explicit = 428,
     Y_false = 429,
     Y_friend = 430,
     Y_mutable = 431,
     Y_namespace = 432,
     Y_new = 433,
     Y_operator = 434,
     Y_OPERATOR_SNAME = 435,
     Y_private = 436,
     Y_protected = 437,
     Y_public = 438,
     Y_reinterpret_cast = 439,
     Y_static_cast = 440,
     Y_template = 441,
     Y_this = 442,
     Y_throw = 443,
     Y_true = 444,
     Y_try = 445,
     Y_typeid = 446,
     Y_typename = 447,
     Y_using = 448,
     Y_virtual = 449,
     Y_char16_t = 450,
     Y_char32_t = 451,
     Y__BitInt = 452,
     Y_reproducible = 453,
     Y_typeof = 454,
     Y_typeof_unqual = 455,
     Y_unsequenced = 456,
     Y_ATTR_BEGIN = 457,
     Y_alignas = 458,
     Y_alignof = 459,
     Y_auto_TYPE = 460,
     Y_carries = 461,
     Y_dependency = 462,
     Y_carries_dependency = 463,
     Y_constexpr = 464,
     Y_decltype = 465,
     Y_except = 466,
     Y_final = 467,
     Y_noexcept = 468,
     Y_nullptr = 469,
     Y_override = 470,
     Y_QUOTE2 = 471,
     Y_static_assert = 472,
     Y_thread_local = 473,
     Y_deprecated = 474,
     Y_discard = 475,
     Y_maybe_unused = 476,
     Y_maybe = 477,
     Y_unused = 478,
     Y_nodiscard = 479,
     Y_noreturn = 480,
     Y_char8_t = 481,
     Y_address = 482,
     Y_concept = 483,
     Y_consteval = 484,
     Y_constinit = 485,
     Y_co_await = 486,
     Y_co_return = 487,
     Y_co_yield = 488,
     Y_export = 489,
     Y_no_unique_address = 490,
     Y_requires = 491,
     Y_unique = 492,
     Y_EMC__Accum = 493,
     Y_EMC__Fract = 494,
     Y_EMC__Sat = 495,
     Y_UPC_relaxed = 496,
     Y_UPC_shared = 497,
     Y_UPC_strict = 498,
     Y_GNU___attribute__ = 499,
     Y_GNU___restrict = 500,
     Y_Apple___block = 501,
     Y_Apple_block = 502,
     Y_MSC___cdecl = 503,
     Y_MSC___clrcall = 504,
     Y_MSC___declspec = 505,
     Y_MSC___fastcall = 506,
     Y_MSC___stdcall = 507,
     Y_MSC___thiscall = 508,
     Y_MSC___vectorcall = 509,
     Y_CHAR_LIT = 510,
     Y_END = 511,
     Y_ERROR = 512,
     Y_GLOB = 513,
     Y_INT_LIT = 514,
     Y_NAME = 515,
     Y_SET_OPTION = 516,
     Y_STR_LIT = 517,
     Y_TYPEDEF_NAME = 518,
     Y_TYPEDEF_SNAME = 519,
     Y_LEXER_ERROR = 520
   };
#endif
/* Tokens.  */
#define Y_cast 258
#define Y_const_ENG 259
#define Y_declare 260
#define Y_define 261
#define Y_dynamic 262
#define Y_explain 263
#define Y_help 264
#define Y_no 265
#define Y_quit 266
#define Y_reinterpret 267
#define Y_set 268
#define Y_show 269
#define Y_aligned 270
#define Y_all 271
#define Y_array 272
#define Y_as 273
#define Y_bit 274
#define Y_bit_precise 275
#define Y_bits 276
#define Y_by 277
#define Y_bytes 278
#define Y_capturing 279
#define Y_commands 280
#define Y_constructor 281
#define Y_conversion 282
#define Y_copy 283
#define Y_defined 284
#define Y_destructor 285
#define Y_english 286
#define Y_evaluation 287
#define Y_expression 288
#define Y_floating 289
#define Y_function 290
#define Y_initialization 291
#define Y_into 292
#define Y_lambda 293
#define Y_length 294
#define Y_linkage 295
#define Y_literal 296
#define Y_member 297
#define Y_non_member 298
#define Y_of 299
#define Y_options 300
#define Y_point 301
#define Y_pointer 302
#define Y_precise 303
#define Y_precision 304
#define Y_predefined 305
#define Y_pure 306
#define Y_reference 307
#define Y_returning 308
#define Y_rvalue 309
#define Y_scope 310
#define Y_to 311
#define Y_user 312
#define Y_user_defined 313
#define Y_variable 314
#define Y_wide 315
#define Y_width 316
#define Y_PREC_LESS_THAN_upc_layout_qualifier 317
#define Y_COLON2 319
#define Y_COLON2_STAR 321
#define Y_PLUS2 322
#define Y_MINUS2 323
#define Y_ARROW 325
#define Y_TILDE 326
#define Y_sizeof 327
#define Y_EXCLAM 328
#define Y_AMPER 329
#define Y_ARROW_STAR 332
#define Y_DOT_STAR 333
#define Y_GREATER2 336
#define Y_LESS2 337
#define Y_LESS_EQUAL_GREATER 339
#define Y_GREATER_EQUAL 342
#define Y_LESS_EQUAL 343
#define Y_EXCLAM_EQUAL 345
#define Y_EQUAL2 346
#define Y_bit_and 347
#define Y_CARET 348
#define Y_PIPE 349
#define Y_AMPER2 350
#define Y_PIPE2 351
#define Y_PIPE_EQUAL 360
#define Y_CARET_EQUAL 361
#define Y_GREATER2_EQUAL 362
#define Y_LESS2_EQUAL 363
#define Y_SLASH_EQUAL 364
#define Y_MINUS_EQUAL 365
#define Y_PLUS_EQUAL 366
#define Y_STAR_EQUAL 367
#define Y_AMPER_EQUAL 368
#define Y_PERCENT_EQUAL 369
#define Y_QMARK_COLON 370
#define Y_auto_STORAGE 371
#define Y_break 372
#define Y_case 373
#define Y_char 374
#define Y_continue 375
#define Y_default 376
#define Y_do 377
#define Y_double 378
#define Y_else 379
#define Y_extern 380
#define Y_float 381
#define Y_for 382
#define Y_goto 383
#define Y_if 384
#define Y_int 385
#define Y_long 386
#define Y_register 387
#define Y_return 388
#define Y_short 389
#define Y_static 390
#define Y_struct 391
#define Y_switch 392
#define Y_typedef 393
#define Y_union 394
#define Y_unsigned 395
#define Y_while 396
#define Y_asm 397
#define Y_const 398
#define Y_ELLIPSIS 399
#define Y_enum 400
#define Y_signed 401
#define Y_void 402
#define Y_volatile 403
#define Y_wchar_t 404
#define Y__Bool 405
#define Y__Complex 406
#define Y__Imaginary 407
#define Y_inline 408
#define Y_restrict 409
#define Y__Alignas 410
#define Y__Alignof 411
#define Y__Atomic_QUAL 412
#define Y__Atomic_SPEC 413
#define Y__Generic 414
#define Y__Noreturn 415
#define Y__Static_assert 416
#define Y__Thread_local 417
#define Y_thread 418
#define Y_local 419
#define Y_bool 420
#define Y_catch 421
#define Y_class 422
#define Y_const_cast 423
#define Y_CONSTRUCTOR_SNAME 424
#define Y_delete 425
#define Y_DESTRUCTOR_SNAME 426
#define Y_dynamic_cast 427
#define Y_explicit 428
#define Y_false 429
#define Y_friend 430
#define Y_mutable 431
#define Y_namespace 432
#define Y_new 433
#define Y_operator 434
#define Y_OPERATOR_SNAME 435
#define Y_private 436
#define Y_protected 437
#define Y_public 438
#define Y_reinterpret_cast 439
#define Y_static_cast 440
#define Y_template 441
#define Y_this 442
#define Y_throw 443
#define Y_true 444
#define Y_try 445
#define Y_typeid 446
#define Y_typename 447
#define Y_using 448
#define Y_virtual 449
#define Y_char16_t 450
#define Y_char32_t 451
#define Y__BitInt 452
#define Y_reproducible 453
#define Y_typeof 454
#define Y_typeof_unqual 455
#define Y_unsequenced 456
#define Y_ATTR_BEGIN 457
#define Y_alignas 458
#define Y_alignof 459
#define Y_auto_TYPE 460
#define Y_carries 461
#define Y_dependency 462
#define Y_carries_dependency 463
#define Y_constexpr 464
#define Y_decltype 465
#define Y_except 466
#define Y_final 467
#define Y_noexcept 468
#define Y_nullptr 469
#define Y_override 470
#define Y_QUOTE2 471
#define Y_static_assert 472
#define Y_thread_local 473
#define Y_deprecated 474
#define Y_discard 475
#define Y_maybe_unused 476
#define Y_maybe 477
#define Y_unused 478
#define Y_nodiscard 479
#define Y_noreturn 480
#define Y_char8_t 481
#define Y_address 482
#define Y_concept 483
#define Y_consteval 484
#define Y_constinit 485
#define Y_co_await 486
#define Y_co_return 487
#define Y_co_yield 488
#define Y_export 489
#define Y_no_unique_address 490
#define Y_requires 491
#define Y_unique 492
#define Y_EMC__Accum 493
#define Y_EMC__Fract 494
#define Y_EMC__Sat 495
#define Y_UPC_relaxed 496
#define Y_UPC_shared 497
#define Y_UPC_strict 498
#define Y_GNU___attribute__ 499
#define Y_GNU___restrict 500
#define Y_Apple___block 501
#define Y_Apple_block 502
#define Y_MSC___cdecl 503
#define Y_MSC___clrcall 504
#define Y_MSC___declspec 505
#define Y_MSC___fastcall 506
#define Y_MSC___stdcall 507
#define Y_MSC___thiscall 508
#define Y_MSC___vectorcall 509
#define Y_CHAR_LIT 510
#define Y_END 511
#define Y_ERROR 512
#define Y_GLOB 513
#define Y_INT_LIT 514
#define Y_NAME 515
#define Y_SET_OPTION 516
#define Y_STR_LIT 517
#define Y_TYPEDEF_NAME 518
#define Y_TYPEDEF_SNAME 519
#define Y_LEXER_ERROR 520




/* Copy the first part of user declarations.  */
#line 31 "parser.y"

/** @endcond */

// local
#include "pjl_config.h"                 /* must go first */
#include "c_ast.h"
#include "c_ast_check.h"
#include "c_ast_util.h"
#include "c_keyword.h"
#include "c_lang.h"
#include "c_operator.h"
#include "c_sglob.h"
#include "c_sname.h"
#include "c_type.h"
#include "c_typedef.h"
#include "cdecl.h"
#include "cdecl_keyword.h"
#include "color.h"
#ifdef ENABLE_CDECL_DEBUG
#include "dump.h"
#endif /* ENABLE_CDECL_DEBUG */
#include "did_you_mean.h"
#include "english.h"
#include "gibberish.h"
#include "help.h"
#include "lexer.h"
#include "literals.h"
#include "options.h"
#include "print.h"
#include "set_options.h"
#include "slist.h"
#include "types.h"
#include "util.h"

/// @cond DOXYGEN_IGNORE

// standard
#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

// Silence these warnings for Bison-generated code.
#ifdef __GNUC__
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wconversion"
# pragma GCC diagnostic ignored "-Wredundant-decls"
# pragma GCC diagnostic ignored "-Wunreachable-code"
#endif /* __GNUC__ */

// Developer aid for tracing when Bison %destructors are called.
#if 0
#define DTRACE                    EPRINTF( "%d: destructor\n", __LINE__ )
#else
#define DTRACE                    NO_OP
#endif

#ifdef ENABLE_CDECL_DEBUG
#define IF_DEBUG(...) \
  BLOCK( if ( opt_cdecl_debug ) { __VA_ARGS__ } )
#else
#define IF_DEBUG(...)             NO_OP
#endif /* ENABLE_CDECL_DEBUG */

/// @endcond

///////////////////////////////////////////////////////////////////////////////

/**
 * @defgroup parser-group Parser
 * Helper macros, data structures, variables, functions, and the grammar for
 * C/C++ declarations.
 * @{
 */

/**
 * Calls #elaborate_error_dym() with #DYM_NONE.
 *
 * @param ... Arguments passed to fl_elaborate_error().
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  | Y_define error
 *    {
 *      elaborate_error( "name expected" );
 *    }
 * ```
 *
 * @sa elaborate_error_dym()
 * @sa keyword_expected()
 * @sa punct_expected()
 */
#define elaborate_error(...) \
  elaborate_error_dym( DYM_NONE, __VA_ARGS__ )

/**
 * Calls fl_elaborate_error() followed by #PARSE_ABORT().
 *
 * @param DYM_KINDS The bitwise-or of \ref dym_kind_t things possibly meant.
 * @param ... Arguments passed to fl_elaborate_error().
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  | error
 *    {
 *      elaborate_error_dym( DYM_COMMANDS, "unexpected token" );
 *    }
 * ```
 *
 * @sa elaborate_error()
 * @sa keyword_expected()
 * @sa punct_expected()
 */
#define elaborate_error_dym(DYM_KINDS,...) BLOCK( \
  fl_elaborate_error( __FILE__, __LINE__, (DYM_KINDS), __VA_ARGS__ ); PARSE_ABORT(); )

/**
 * Checks whether the type currently being declared (`enum`, `struct`,
 * `typedef`, or `union`) is nested within some other type (`struct` or
 * `union`) and whether the current language is C: if not, prints an error
 * message.
 *
 * @remarks In debug mode, also includes the file & line where the function was
 * called from in the error message.
 *
 * @param TYPE_LOC The location of the type declaration.
 * @return Returns `true` only if the type currently being declared is either
 * not nested or the current language is C++.
 *
 * @sa fl_is_nested_type_ok()
 */
#define is_nested_type_ok(TYPE_LOC) \
  fl_is_nested_type_ok( __FILE__, __LINE__, (TYPE_LOC) )

/**
 * Calls fl_keyword_expected() followed by #PARSE_ABORT().
 *
 * @param KEYWORD A keyword literal.
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  : Y_virtual
 *  | error
 *    {
 *      keyword_expected( L_virtual );
 *    }
 * ```
 *
 * @sa elaborate_error()
 * @sa elaborate_error_dym()
 * @sa punct_expected()
 */
#define keyword_expected(KEYWORD) BLOCK ( \
  fl_keyword_expected( __FILE__, __LINE__, (KEYWORD) ); PARSE_ABORT(); )

/**
 * Aborts the current parse after an error message has been printed.
 *
 * @sa #PARSE_ASSERT()
 */
#define PARSE_ABORT() \
  BLOCK( parse_cleanup( /*fatal_error=*/true ); YYABORT; )

/**
 * Evaluates \a EXPR: if `false`, calls #PARSE_ABORT().
 *
 * @param EXPR The expression to evalulate.
 */
#define PARSE_ASSERT(EXPR)        BLOCK( if ( !(EXPR) ) PARSE_ABORT(); )

/**
 * Calls fl_punct_expected() followed by #PARSE_ABORT().
 *
 * @param PUNCT The punctuation character that was expected.
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  : ','
 *  | error
 *    {
 *      punct_expected( ',' );
 *    }
 * ```
 *
 * @sa elaborate_error()
 * @sa elaborate_error_dym()
 * @sa keyword_expected()
 */
#define punct_expected(PUNCT) BLOCK( \
  fl_punct_expected( __FILE__, __LINE__, (PUNCT) ); PARSE_ABORT(); )

/**
 * Show all (as opposed to only those that are supported in the current
 * language) predefined, user, or both types.
 */
#define SHOW_ALL_TYPES            0x10u

/**
* Show only predefined types that are valid in the current language.
*/
#define SHOW_PREDEFINED_TYPES     (1u << 0)

/**
 * Show only user-defined types that were defined in the current language or
 * earlier.
 */
#define SHOW_USER_DEFINED_TYPES   (1u << 1)

/** @} */

///////////////////////////////////////////////////////////////////////////////

/**
 * @defgroup parser-dump-group Debugging Macros
 * Macros that are used to dump a trace during parsing when \ref
 * opt_cdecl_debug is `true`.
 * @ingroup parser-group
 * @{
 */

/**
 * Dumps an AST.
 *
 * @param KEY The key name to print.
 * @param AST The AST to dump.
 *
 * @sa #DUMP_AST_LIST()
 */
#define DUMP_AST(KEY,AST) IF_DEBUG( \
  DUMP_COMMA; c_ast_dump( (AST), /*indent=*/1, (KEY), stdout ); )

/**
 * Dumps an s_list of AST.
 *
 * @param KEY The key name to print.
 * @param AST_LIST The \ref slist of AST to dump.
 *
 * @sa #DUMP_AST()
 */
#define DUMP_AST_LIST(KEY,AST_LIST) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_ast_list_dump( &(AST_LIST), /*indent=*/1, stdout ); )

/**
 * Dumps a `bool`.
 *
 * @param KEY The key name to print.
 * @param BOOL The `bool` to dump.
 *
 * @sa #DUMP_KEY()
 */
#define DUMP_BOOL(KEY,BOOL)  IF_DEBUG(  \
  DUMP_KEY( KEY ": " ); bool_dump( (BOOL), stdout ); )

/**
 * Dumps a comma followed by a newline the _second_ and subsequent times it's
 * called used to separate items being dumped.
 */
#define DUMP_COMMA                fput_sep( ",\n", &dump_comma, stdout )

/**
 * Ends a dump block.
 *
 * @sa #DUMP_START()
 */
#define DUMP_END()                IF_DEBUG( PUTS( "\n}\n\n" ); )

/**
 * Possibly dumps a comma and a newline followed by the `printf()` arguments
 * &mdash; used for printing a key followed by a value.
 *
 * @param ... The `printf()` arguments.
 */
#define DUMP_KEY(...) IF_DEBUG( \
  DUMP_COMMA; PRINTF( "  " __VA_ARGS__ ); )

/**
 * Dumps an integer.
 *
 * @param KEY The key name to print.
 * @param NUM The integer to dump.
 *
 * @sa #DUMP_KEY()
 * @sa #DUMP_STR()
 */
#define DUMP_INT(KEY,NUM) \
  DUMP_KEY( KEY ": %d", STATIC_CAST( int, (NUM) ) )

/**
 * Dumps a scoped name.
 *
 * @param KEY The key name to print.
 * @param SNAME The scoped name to dump.
 *
 * @sa #DUMP_KEY()
 * @sa #DUMP_SNAME_LIST()
 * @sa #DUMP_STR()
 */
#define DUMP_SNAME(KEY,SNAME) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_sname_dump( &(SNAME), stdout ); )

/**
 * Dumps a list of scoped names.
 *
 * @param KEY The key name to print.
 * @param LIST The list of scoped names to dump.
 *
 * @sa #DUMP_KEY()
 * @sa #DUMP_SNAME()
 */
#define DUMP_SNAME_LIST(KEY,LIST) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_sname_list_dump( &(LIST), stdout ); )

#ifdef ENABLE_CDECL_DEBUG
/**
 * @def DUMP_START
 *
 * Starts a dump block.  The dump block _must_ end with #DUMP_END().  If a rule
 * has a result, it should be dumped as the final thing before the #DUMP_END()
 * repeating the name of the rule, e.g.:
 * ```
 *  DUMP_START( "rule",                 // <-- This rule name ...
 *              "subrule_1 name subrule_2" );
 *  DUMP_AST( "subrule_1", $1 );
 *  DUMP_STR( "name", $2 );
 *  DUMP_AST( "subrule_2", $3 );
 *  // ...
 *  DUMP_AST( "rule", $$ );             // <-- ... is repeated here.
 *  DUMP_END();
 * ```
 *
 * Whenever possible, an entire dump block should be completed before any
 * actions are taken as a result of a failed semantic check or other error
 * (typically, calling print_error() and #PARSE_ABORT()) so that the entire
 * block is dumped for debugging purposes first. If necessary, set a flag
 * within the dump block, then check it after, e.g.:
 * ```
 *  DUMP_START( "rule", "subrule_1 name subrule_2" );
 *  DUMP_AST( "subrule_1", $1 );
 *  DUMP_STR( "name", $2 );
 *  DUMP_AST( "subrule_2", $3 );
 *
 *  bool ok = true;
 *  if ( semantic_check_failed ) {
 *    // ...
 *    ok = false;
 *  }
 *
 *  DUMP_AST( "rule", $$ );
 *  DUMP_END();
 *
 *  if ( !ok ) {
 *    print_error( &@1, "...\n" );
 *    PARSE_ABORT();
 *  }
 * ```
 *
 * @param NAME The grammar production name.
 * @param RULE The grammar production rule.
 *
 * @sa #DUMP_AST
 * @sa #DUMP_AST_LIST
 * @sa #DUMP_BOOL
 * @sa #DUMP_END
 * @sa #DUMP_INT
 * @sa #DUMP_SNAME
 * @sa #DUMP_STR
 * @sa #DUMP_TID
 * @sa #DUMP_TYPE
 */
#define DUMP_START(NAME,RULE)         \
  bool dump_comma = false; IF_DEBUG(  \
  PUTS( NAME ": {\n  rule: " ); str_dump( (RULE), stdout ); PUTS( ",\n" ); )
#else
#define DUMP_START(NAME,RULE)     NO_OP
#endif

/**
 * Dumps a C string.
 *
 * @param KEY The key name to print.
 * @param STR The C string to dump.
 *
 * @sa #DUMP_INT()
 * @sa #DUMP_SNAME()
 */
#define DUMP_STR(KEY,STR) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); str_dump( (STR), stdout ); )

/**
 * Dumps a \ref c_tid_t.
 *
 * @param KEY The key name to print.
 * @param TID The \ref c_tid_t to dump.
 *
 * @sa #DUMP_TYPE()
 */
#define DUMP_TID(KEY,TID) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_tid_dump( (TID), stdout ); )

/**
 * Dumps a \ref c_type.
 *
 * @param KEY The key name to print.
 * @param TYPE The \ref c_type to dump.
 *
 * @sa #DUMP_TID()
 */
#define DUMP_TYPE(KEY,TYPE) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_type_dump( &(TYPE), stdout ); )

/** @} */

/**
 * Shorthand for calling unsupported() with \a LANG_MACRO.
 *
 * @param LANG_MACRO A `LANG_*` macro without the `LANG_` prefix.
 *
 * @sa unsupported()
 */
#define UNSUPPORTED(LANG_MACRO)   unsupported( LANG_##LANG_MACRO )

///////////////////////////////////////////////////////////////////////////////

/**
 * @addtogroup parser-group
 * @{
 */

/**
 * Inherited attributes.
 */
struct in_attr {
  c_alignas_t   align;            ///< Alignment, if any.
  unsigned      ast_depth;        ///< Parentheses nesting depth.
  c_sname_t     current_scope;    ///< C++ only: current scope, if any.
  bool          is_implicit_int;  ///< Created implicit `int` AST?
  bool          is_typename;      ///< C++ only: `typename` specified?
  c_operator_t const *operator;   ///< C++ only: current operator, if any.
  c_ast_list_t  type_ast_stack;   ///< Type AST stack.
  c_ast_t      *typedef_ast;      ///< AST of `typedef` being declared.
  c_ast_list_t  typedef_ast_list; ///< AST nodes of `typedef` being declared.
  rb_node_t    *typedef_rb;       ///< Red-black node for temporary `typedef`.
};
typedef struct in_attr in_attr_t;

/**
 * Information for show_type_visitor().
 */
struct show_type_info {
  unsigned  show_which;                 ///< Predefined, user, or both?
  unsigned  gib_flags;                  ///< Gibberish flags.
  c_sglob_t sglob;                      ///< Scoped glob to match, if any.
};
typedef struct show_type_info show_type_info_t;

// local functions
NODISCARD
static bool c_ast_free_if_placeholder( c_ast_t* );

PJL_PRINTF_LIKE_FUNC(4)
static void fl_elaborate_error( char const*, int, dym_kind_t, char const*,
                                ... );

// local variables
static c_ast_list_t   decl_ast_list;    ///< List of ASTs being declared.
static c_ast_list_t   gc_ast_list;      ///< c_ast nodes freed after parse.
static in_attr_t      in_attr;          ///< Inherited attributes.
static c_ast_list_t   typedef_ast_list; ///< List of ASTs for `typedef`s.

////////// inline functions ///////////////////////////////////////////////////

/**
 * Garbage-collect the AST nodes on \a ast_list but does _not_ free \a ast_list
 * itself.
 *
 * @param ast_list The AST list to free the nodes of.
 *
 * @sa c_ast_list_cleanup()
 * @sa c_ast_new_gc()
 * @sa c_ast_pair_new_gc()
 */
static inline void c_ast_list_gc( c_ast_list_t *ast_list ) {
  slist_cleanup( ast_list, POINTER_CAST( slist_free_fn_t, &c_ast_free ) );
}

/**
 * Creates a new AST and adds it to \ref gc_ast_list.
 *
 * @param kind The kind of AST to create.
 * @param loc A pointer to the token location data.
 * @return Returns a pointer to a new AST.
 *
 * @sa c_ast_pair_new_gc()
 */
NODISCARD
static inline c_ast_t* c_ast_new_gc( c_ast_kind_t kind, c_loc_t const *loc ) {
  return c_ast_new( kind, in_attr.ast_depth, loc, &gc_ast_list );
}

/**
 * Set our mode to deciphering gibberish into English.
 */
static inline void gibberish_to_english( void ) {
  cdecl_mode = CDECL_GIBBERISH_TO_ENGLISH;
  lexer_find &= ~LEXER_FIND_CDECL_KEYWORDS;
}

/**
 * Peeks at the type AST at the top of the
 * \ref in_attr.type_ast_stack "type AST inherited attribute stack".
 *
 * @return Returns said AST.
 *
 * @sa ia_type_ast_pop()
 * @sa ia_type_ast_push()
 */
NODISCARD
static inline c_ast_t* ia_type_ast_peek( void ) {
  return slist_front( &in_attr.type_ast_stack );
}

/**
 * Pops a type AST from the
 * \ref in_attr.type_ast_stack "type AST inherited attribute stack".
 *
 * @return Returns said AST.
 *
 * @sa ia_type_ast_peek()
 * @sa ia_type_ast_push()
 */
PJL_DISCARD
static inline c_ast_t* ia_type_ast_pop( void ) {
  return slist_pop_front( &in_attr.type_ast_stack );
}

/**
 * Pushes a type AST onto the
 * \ref in_attr.type_ast_stack "type AST inherited attribute  stack".
 *
 * @param ast The AST to push.
 *
 * @sa ia_type_ast_peek()
 * @sa ia_type_ast_pop()
 */
static inline void ia_type_ast_push( c_ast_t *ast ) {
  slist_push_front( &in_attr.type_ast_stack, ast );
}

/**
 * Gets a printable string of \ref lexer_token.
 *
 * @return Returns said string or NULL if \ref lexer_token is the empty string.
 */
NODISCARD
static inline char const* printable_token( void ) {
  switch ( lexer_token[0] ) {
    case '\0': return NULL;
    case '\n': return "\\n";
    default  : return lexer_token;
  } // switch
}

/**
 * Cleans-up all memory associated with \a sti but does _not_ free \a sti
 * itself.
 *
 * @param sti The \ref show_type_info to clean up.
 *
 * @sa sti_init()
 */
static inline void sti_cleanup( show_type_info_t *sti ) {
  c_sglob_cleanup( &sti->sglob );
  MEM_ZERO( sti );
}

/**
 * Checks if the current language is _not_ among \a lang_ids.
 *
 * @param lang_ids The bitwise-or of language(s).
 * @return Returns `true` only if **cdecl** has been initialized and \ref
 * opt_lang is _not_ among \a lang_ids.
 *
 * @sa #UNSUPPORTED()
 */
NODISCARD
static inline bool unsupported( c_lang_id_t lang_ids ) {
  return !opt_lang_is_any( lang_ids ) && cdecl_initialized;
}

////////// local functions ////////////////////////////////////////////////////

/**
 * Adds a type to the global set.
 *
 * @param type_ast The AST of the type to add.
 * @param gib_flags The gibberish flags to use; must only be one of
 * #C_GIB_NONE, #C_GIB_TYPEDEF, or #C_GIB_USING.
 * @return Returns `true` either if the type was added or it's equivalent to an
 * existing type; `false` if a different type already exists having the same
 * name.
 */
NODISCARD
static bool add_type( c_ast_t const *type_ast, unsigned gib_flags ) {
  assert( type_ast != NULL );

  c_ast_t const *const leaf_ast = c_ast_leaf( type_ast );
  if ( c_ast_is_tid_any( leaf_ast, TB_AUTO ) ) {
    print_error( &leaf_ast->loc,
      "\"%s\" not allowed in type definition\n",
      c_type_name_error( &leaf_ast->type )
    );
    return false;
  }

  rb_node_t const *const typedef_rb = c_typedef_add( type_ast, gib_flags );
  c_typedef_t const *const tdef = typedef_rb->data;

  if ( tdef->ast == type_ast ) {
    //
    // Type was added: we have to move the AST from the gc_ast_list so it won't
    // be garbage collected at the end of the parse to a separate
    // typedef_ast_list that's freed only at program termination.
    //
    // But first, free all orphaned placeholder AST nodes.  (For a non-type-
    // defining parse, this step isn't necessary since all nodes are freed at
    // the end of the parse anyway.)
    //
    slist_free_if(
      &gc_ast_list, POINTER_CAST( slist_pred_fn_t, &c_ast_free_if_placeholder )
    );
    slist_push_list_back( &typedef_ast_list, &gc_ast_list );
  }
  else {
    //
    // Type was NOT added because a previously declared type having the same
    // name was returned: check if the types are equal.
    //
    // In C, multiple typedef declarations having the same name are allowed
    // only if the types are equivalent:
    //
    //      typedef int T;
    //      typedef int T;                // OK
    //      typedef double T;             // error: types aren't equivalent
    //
    if ( !c_ast_equal( type_ast, tdef->ast ) ) {
      print_error( &type_ast->loc,
        "\"%s\": type redefinition with different type; original is: ",
        c_sname_full_name( &type_ast->sname )
      );
      print_type( tdef, stderr );
      return false;
    }
  }

  return true;
}

/**
 * Prints a warning that the attribute \a keyword syntax is not supported (and
 * ignored).
 *
 * @param loc The source location of \a keyword.
 * @param keyword The attribute syntax keyword, e.g., `__attribute__` or
 * `__declspec`.
 */
static void attr_syntax_not_supported( c_loc_t const *loc,
                                       char const *keyword ) {
  assert( loc != NULL );
  assert( keyword != NULL );

  print_warning( loc,
    "\"%s\" not supported by %s (ignoring)", keyword, CDECL
  );
  if ( OPT_LANG_IS( ATTRIBUTES ) )
    print_hint( "[[...]]" );
  else
    EPUTC( '\n' );
}

/**
 * A predicate function for slist_free_if() that checks whether \a ast is a
 * #K_PLACEHOLDER: if so, c_ast_free()s it.
 *
 * @param ast The AST to check.
 * @return Returns `true` only if \a ast is a #K_PLACEHOLDER.
 */
static bool c_ast_free_if_placeholder( c_ast_t *ast ) {
  if ( ast->kind == K_PLACEHOLDER ) {
    assert( c_ast_is_orphan( ast ) );
    c_ast_free( ast );
    return true;
  }
  return false;
}

/**
 * Checks whether `typename` is OK since the type's name is a qualified name.
 *
 * @param ast The AST to check.
 * @return Returns `true` only upon success.
 */
NODISCARD
bool c_ast_is_typename_ok( c_ast_t const *ast ) {
  c_ast_t const *const raw_ast = c_ast_untypedef( ast );
  if ( c_sname_count( &raw_ast->sname ) < 2 ) {
    print_error( &ast->loc, "qualified name expected after \"typename\"\n" );
    return false;
  }
  return true;
}

/**
 * Checks whether the type currently being declared (`enum`, `struct`,
 * `typedef`, or `union`) is nested within some other type (`struct` or
 * `union`) and whether the current language is C: if not, prints an error
 * message.
 *
 * @note It is unnecessary to check either when a `class` is being declared or
 * when a type is being declared within a `namespace` since those are not legal
 * in C anyway.
 *
 * @note This function isn't normally called directly; use the
 * #is_nested_type_ok() macro instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param type_loc The location of the type declaration.
 * @return Returns `true` only if the type currently being declared is either
 * not nested or the current language is C++.
 */
NODISCARD
static bool fl_is_nested_type_ok( char const *file, int line,
                                  c_loc_t const *type_loc ) {
  assert( type_loc != NULL );
  if ( !c_sname_empty( &in_attr.current_scope ) && OPT_LANG_IS( C_ANY ) ) {
    fl_print_error( file, line, type_loc, "nested types not supported in C\n" );
    return false;
  }
  return true;
}

/**
 * A special case of fl_elaborate_error() that prevents oddly worded error
 * messages where a C/C++ keyword is expected, but that keyword isn't a keyword
 * either until a later version of the language or in a different language;
 * hence, the lexer will return the keyword as the `Y_NAME` token instead of
 * the keyword token.
 *
 * For example, if fl_elaborate_error() were used for the following \b cdecl
 * command when the current language is C, you'd get the following:
 * ```
 * declare f as virtual function returning void
 *              ^
 * 14: syntax error: "virtual": "virtual" expected; not a keyword until C++98
 * ```
 * because it's really this:
 * ```
 * ... "virtual" [the name]": "virtual" [the token] expected ...
 * ```
 * and that looks odd.
 *
 * @note This function isn't normally called directly; use the
 * #keyword_expected() macro instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param keyword A keyword literal.
 *
 * @sa fl_elaborate_error()
 * @sa fl_punct_expected()
 * @sa yyerror()
 */
static void fl_keyword_expected( char const *file, int line,
                                 char const *keyword ) {
  assert( keyword != NULL );

  dym_kind_t dym_kinds = DYM_NONE;

  char const *const error_token = printable_token();
  if ( error_token != NULL ) {
    if ( strcmp( error_token, keyword ) == 0 ) {
      //
      // The error token is the expected keyword which means the lexer returned
      // it as a name and not the token which likely means it's not a C/C++
      // keyword until a later version of the current language.
      //
      c_keyword_t const *const ck =
        c_keyword_find( keyword, LANG_ANY, C_KW_CTX_DEFAULT );
      if ( ck != NULL ) {
        char const *const which_lang = c_lang_which( ck->lang_ids );
        if ( which_lang[0] != '\0' ) {
          EPRINTF( ": \"%s\" not supported%s\n", keyword, which_lang );
          return;
        }
      }
    }

    dym_kinds = cdecl_mode == CDECL_ENGLISH_TO_GIBBERISH ?
      DYM_CDECL_KEYWORDS : DYM_C_KEYWORDS;
  }

  fl_elaborate_error( file, line, dym_kinds, "\"%s\" expected", keyword );
}

/**
 * A special case of fl_elaborate_error() that prevents oddly worded error
 * messages when a punctuation character is expected by not doing keyword look-
 * ups of the error token.

 * For example, if fl_elaborate_error() were used for the following \b cdecl
 * command, you'd get the following:
 * ```
 * explain void f(int g const)
 *                      ^
 * 29: syntax error: "const": ',' expected ("const" is a keyword)
 * ```
 * and that looks odd since, if a punctuation character was expected, it seems
 * silly to point out that the encountered token is a keyword.
 *
 * @note This function isn't normally called directly; use the
 * #punct_expected() macro instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param punct The punctuation character that was expected.
 *
 * @sa fl_elaborate_error()
 * @sa fl_keyword_expected()
 * @sa yyerror()
 */
static void fl_punct_expected( char const *file, int line, char punct ) {
  EPUTS( ": " );
  print_debug_file_line( file, line );

  char const *const error_token = printable_token();
  if ( error_token != NULL )
    EPRINTF( "\"%s\": ", error_token );

  EPRINTF( "'%c' expected\n", punct );
}

/**
 * Cleans-up all resources used by \ref in_attr "inherited attributes".
 */
static void ia_cleanup( void ) {
  c_sname_cleanup( &in_attr.current_scope );
  // Do _not_ pass &c_ast_free for the 2nd argument! All AST nodes were already
  // free'd from the gc_ast_list in parse_cleanup(). Just free the slist nodes.
  slist_cleanup( &in_attr.type_ast_stack, /*free_fn=*/NULL );
  c_ast_list_gc( &in_attr.typedef_ast_list );
  MEM_ZERO( &in_attr );
}

/**
 * Joins \a type_ast and \a decl_ast into a single AST.
 *
 * @param type_ast The type AST.
 * @param decl_ast The declaration AST.
 * @return Returns the joined AST on success or NULL on error.
 */
NODISCARD
c_ast_t const* join_type_decl( c_ast_t *type_ast, c_ast_t *decl_ast ) {
  assert( type_ast != NULL );
  assert( decl_ast != NULL );

  if ( in_attr.is_typename && !c_ast_is_typename_ok( type_ast ) )
    return NULL;

  c_type_t type = c_ast_take_type_any( type_ast, &T_TS_TYPEDEF );

  if ( c_tid_is_any( type.stids, TS_TYPEDEF ) && decl_ast->kind == K_TYPEDEF ) {
    //
    // This is for a case like:
    //
    //      explain typedef int int32_t;
    //
    // that is: explaining an existing typedef.  In order to do that, we have
    // to un-typedef it so we explain the type that it's a typedef for.
    //
    c_ast_t const *const raw_ast = c_ast_untypedef( decl_ast );

    //
    // However, we also have to check whether the typedef being explained is
    // not equivalent to the existing typedef.  This is for a case like:
    //
    //      explain typedef char int32_t;
    //
    if ( !c_ast_equal( type_ast, raw_ast ) ) {
      print_error( &decl_ast->loc,
        "\"%s\": type redefinition with different type; original is: ",
        c_sname_full_name( &raw_ast->sname )
      );
      // Look-up the type so we can print it how it was originally defined.
      c_typedef_t const *const tdef = c_typedef_find_sname( &raw_ast->sname );
      assert( tdef != NULL );
      print_type( tdef, stderr );
      return NULL;
    }

    //
    // Because the raw_ast for the existing type is about to be combined with
    // type_ast, duplicate raw_ast first.
    //
    decl_ast = c_ast_dup( raw_ast, &gc_ast_list );
  }

  c_ast_t *const ast = c_ast_patch_placeholder( type_ast, decl_ast );
  c_type_t const tdef_type = c_ast_take_type_any( ast, &T_TS_TYPEDEF );
  c_type_or_eq( &type, &tdef_type );
  c_type_or_eq( &ast->type, &type );

  if ( in_attr.align.kind != C_ALIGNAS_NONE ) {
    ast->align = in_attr.align;
    if ( c_tid_is_any( type.stids, TS_TYPEDEF ) ) {
      //
      // We check for illegal aligned typedef here rather than in c_ast_check.c
      // because the "typedef-ness" needed to be removed previously before the
      // eventual call to c_ast_check().
      //
      print_error( &ast->align.loc, "typedef can not be aligned\n" );
      return NULL;
    }
  }

  if ( ast->kind == K_USER_DEF_CONVERSION &&
       c_sname_local_type( &ast->sname )->btids == TB_SCOPE ) {
    //
    // User-defined conversions don't have names, but they can still have a
    // scope.  Since only classes can have them, if the scope is still
    // TB_SCOPE, change it to TB_CLASS.
    //
    c_sname_set_local_type( &ast->sname, &C_TYPE_LIT_B( TB_CLASS ) );
  }

  return ast;
}

/**
 * Cleans up individial parse data after each parse.
 *
 * @param fatal_error Must be `true` only if a fatal semantic error has
 * occurred and `YYABORT` is about to be called to bail out of parsing by
 * returning from yyparse().
 */
static void parse_cleanup( bool fatal_error ) {
  cdecl_mode = CDECL_ENGLISH_TO_GIBBERISH;

  //
  // We need to reset the lexer differently depending on whether we completed a
  // parse with a fatal error.  If so, do a "hard" reset that also resets the
  // EOF flag of the lexer.
  //
  lexer_reset( /*hard_reset=*/fatal_error );

  // Do _not_ pass &c_ast_free for the 2nd argument! All AST nodes will be
  // free'd from the gc_ast_list below. Just free the slist nodes.
  slist_cleanup( &decl_ast_list, /*free_fn=*/NULL );

  c_ast_list_gc( &gc_ast_list );
  ia_cleanup();
}

/**
 * Implements the **cdecl** `quit` command.
 *
 * @note This should be marked `noreturn` but isn't since that would generate a
 * warning that a `break` in the Bison-generated code won't be executed.
 */
static void quit( void ) {
  exit( EX_OK );
}

/**
 * Shows (prints) the definition of \a tdef.
 *
 * @param tdef The \ref c_typedef to show.
 * @param flags The gibberish flags to use.
 */
static void show_type( c_typedef_t const *tdef, unsigned flags ) {
  assert( tdef != NULL );
  if ( flags == C_GIB_NONE ) {
    c_typedef_english( tdef, stdout );
  } else {
    if ( opt_semicolon )
      flags |= C_GIB_FINAL_SEMI;
    c_typedef_gibberish( tdef, flags, stdout );
  }
  PUTC( '\n' );
}

/**
 * A visitor function to show (print) \a tdef.
 *
 * @param tdef The \ref c_typedef to show.
 * @param data Optional data passed to the visitor: in this case, the flags of
 * which `typedef`s to print.
 * @return Always returns `false`.
 */
NODISCARD
static bool show_type_visitor( c_typedef_t const *tdef, void *data ) {
  assert( tdef != NULL );
  assert( data != NULL );

  show_type_info_t const *const sti = data;

  bool const show_in_lang =
    (sti->show_which & SHOW_ALL_TYPES) != 0 ||
    opt_lang_is_any( tdef->lang_ids );

  if ( show_in_lang ) {
    bool const show_it =
      ((tdef->is_predefined ?
        (sti->show_which & SHOW_PREDEFINED_TYPES  ) != 0 :
        (sti->show_which & SHOW_USER_DEFINED_TYPES) != 0)) &&
      (c_sglob_empty( &sti->sglob ) ||
       c_sname_match( &tdef->ast->sname, &sti->sglob ));

    if ( show_it )
      show_type( tdef, sti->gib_flags );
  }

  return false;
}

/**
 * Initializes a show_type_info_t.
 *
 * @param sti The \ref show_type_info to initialize.
 * @param show_which Which types to show: predefined, user, or both?
 * @param glob The glob string.  May be NULL.
 * @param gib_flags The gibberish flags to use.
 *
 * @sa sti_cleanup()
 */
static void sti_init( show_type_info_t *sti, unsigned show_which,
                      char const *glob, unsigned gib_flags ) {
  assert( sti != NULL );
  sti->show_which = show_which;
  sti->gib_flags = gib_flags;
  c_sglob_init( &sti->sglob );
  c_sglob_parse( glob, &sti->sglob );
}

/**
 * Prints a parsing error message to standard error.  This function is called
 * directly by Bison to print just `syntax error` (usually).
 *
 * @note A newline is _not_ printed since the error message will be appended to
 * by fl_elaborate_error().  For example, the parts of an error message are
 * printed by the functions shown:
 *
 *      42: syntax error: "int": "into" expected
 *      |--||----------||----------------------|
 *      |   |           |
 *      |   yyerror()   fl_elaborate_error()
 *      |
 *      print_loc()
 *
 * @param msg The error message to print.
 *
 * @sa fl_elaborate_error()
 * @sa fl_keyword_expected()
 * @sa fl_punct_expected()
 * @sa print_loc()
 */
static void yyerror( char const *msg ) {
  assert( msg != NULL );

  c_loc_t const loc = lexer_loc();
  print_loc( &loc );

  color_start( stderr, sgr_error );
  EPUTS( msg );                         // no newline
  color_end( stderr, sgr_error );

  //
  // A syntax error has occurred, but syntax errors aren't fatal since Bison
  // tries to recover.  We'll clean-up the current parse, but YYABORT won't be
  // called so we won't bail out of parsing by returning from yyparse(); hence,
  // parsing will continue.
  //
  parse_cleanup( /*fatal_error=*/false );
}

/** @} */

///////////////////////////////////////////////////////////////////////////////

/// @cond DOXYGEN_IGNORE



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 1133 "parser.y"
{
  c_alignas_t         align;
  c_ast_t            *ast;        // for the AST being built
  c_ast_list_t        ast_list;   // for declarations and function parameters
  c_ast_pair_t        ast_pair;   // for the AST being built
  c_cast_kind_t       cast_kind;  // C/C++ cast kind
  bool                flag;       // simple flag
  unsigned            flags;      // multipurpose bitwise flags
  cdecl_help_t        help;       // type of help to print
  int                 int_val;    // signed integer value
  slist_t             list;       // multipurpose list
  char const         *literal;    // token L_* literal (for new-style casts)
  char               *name;       // identifier name, cf. sname
  c_oper_id_t         oper_id;    // overloaded operator ID
  c_sname_t           sname;      // scoped identifier name, cf. name
  char               *str_val;    // quoted string value
  c_typedef_t const  *tdef;       // typedef
  c_tid_t             tid;        // built-ins, storage classes, & qualifiers
  c_type_t            type;       // complete type
  unsigned            uint_val;   // unsigned integer value
}
/* Line 193 of yacc.c.  */
#line 1706 "parser.c"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 1731 "parser.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   4803

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  284
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  374
/* YYNRULES -- Number of rules.  */
#define YYNRULES  939
/* YYNRULES -- Number of states.  */
#define YYNSTATES  1261

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   520

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    86,     2,     2,
      69,    70,    76,    88,   129,    87,    73,    85,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   269,   270,
      95,   110,    96,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    71,     2,    72,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   271,     2,   272,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    74,    75,    77,    78,    79,    80,
      81,    82,    83,    84,    89,    90,    91,    92,    93,    94,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     4,     7,    10,    13,    16,    19,    22,
      25,    27,    30,    33,    36,    39,    42,    44,    46,    51,
      56,    59,    62,    65,    68,    70,    75,    76,    83,    90,
     100,   103,   105,   108,   111,   115,   118,   121,   124,   126,
     128,   129,   132,   136,   140,   144,   146,   147,   149,   153,
     155,   158,   161,   165,   167,   168,   171,   173,   177,   178,
     181,   183,   185,   188,   190,   192,   194,   196,   198,   200,
     202,   204,   206,   209,   211,   213,   215,   217,   219,   222,
     227,   230,   233,   236,   239,   242,   245,   248,   251,   254,
     257,   260,   263,   264,   269,   272,   276,   279,   282,   284,
     287,   288,   290,   292,   294,   296,   298,   300,   302,   305,
     308,   310,   313,   314,   317,   320,   324,   329,   334,   340,
     343,   346,   348,   350,   352,   354,   356,   357,   359,   360,
     363,   365,   367,   368,   370,   372,   374,   376,   378,   379,
     386,   390,   391,   401,   403,   405,   407,   409,   410,   411,
     417,   422,   423,   430,   435,   437,   439,   444,   446,   448,
     450,   451,   452,   458,   459,   464,   465,   466,   472,   474,
     476,   478,   482,   486,   491,   493,   497,   501,   506,   508,
     510,   512,   513,   515,   518,   523,   525,   528,   531,   533,
     540,   541,   543,   547,   549,   551,   554,   556,   558,   560,
     563,   564,   568,   569,   570,   575,   577,   578,   582,   583,
     584,   591,   592,   597,   599,   601,   603,   605,   607,   609,
     610,   611,   620,   621,   623,   627,   629,   631,   633,   635,
     637,   639,   641,   643,   646,   648,   650,   652,   654,   656,
     658,   660,   663,   665,   667,   669,   673,   675,   679,   685,
     690,   696,   699,   703,   707,   708,   719,   728,   736,   743,
     752,   753,   761,   762,   766,   767,   770,   772,   774,   776,
     778,   779,   781,   783,   784,   786,   791,   795,   800,   802,
     804,   806,   807,   808,   813,   815,   816,   819,   822,   825,
     828,   830,   832,   833,   835,   839,   841,   842,   847,   849,
     851,   853,   855,   856,   861,   872,   873,   877,   880,   882,
     886,   887,   891,   894,   895,   899,   903,   904,   908,   911,
     914,   916,   917,   927,   937,   938,   940,   942,   944,   946,
     948,   950,   952,   954,   956,   958,   961,   962,   972,   979,
     980,   985,   986,   990,   991,   995,   996,  1000,  1001,  1003,
    1005,  1007,  1009,  1011,  1012,  1016,  1017,  1021,  1022,  1026,
    1028,  1031,  1033,  1034,  1036,  1039,  1041,  1043,  1045,  1047,
    1049,  1051,  1053,  1055,  1057,  1059,  1061,  1063,  1065,  1068,
    1071,  1073,  1075,  1077,  1079,  1080,  1087,  1089,  1094,  1096,
    1098,  1100,  1102,  1104,  1106,  1108,  1110,  1112,  1114,  1116,
    1118,  1120,  1122,  1124,  1126,  1128,  1130,  1132,  1136,  1141,
    1146,  1151,  1154,  1155,  1158,  1161,  1163,  1167,  1170,  1171,
    1173,  1176,  1178,  1180,  1182,  1184,  1186,  1188,  1190,  1192,
    1193,  1195,  1197,  1199,  1201,  1203,  1204,  1206,  1210,  1213,
    1216,  1218,  1220,  1222,  1224,  1226,  1229,  1231,  1233,  1235,
    1236,  1239,  1241,  1243,  1246,  1250,  1254,  1258,  1260,  1262,
    1264,  1266,  1268,  1270,  1272,  1274,  1276,  1278,  1280,  1282,
    1284,  1286,  1288,  1290,  1292,  1294,  1296,  1298,  1300,  1302,
    1303,  1305,  1306,  1314,  1316,  1317,  1321,  1322,  1324,  1328,
    1330,  1332,  1335,  1337,  1340,  1342,  1344,  1346,  1348,  1350,
    1352,  1353,  1357,  1358,  1360,  1362,  1364,  1365,  1367,  1370,
    1372,  1373,  1381,  1382,  1384,  1388,  1390,  1393,  1395,  1396,
    1400,  1401,  1403,  1407,  1409,  1411,  1413,  1415,  1417,  1421,
    1423,  1426,  1428,  1429,  1435,  1436,  1438,  1441,  1443,  1445,
    1447,  1449,  1456,  1463,  1464,  1466,  1468,  1469,  1471,  1473,
    1474,  1476,  1480,  1483,  1486,  1487,  1490,  1496,  1498,  1500,
    1502,  1504,  1506,  1508,  1510,  1512,  1519,  1520,  1522,  1526,
    1527,  1529,  1533,  1535,  1537,  1539,  1540,  1542,  1545,  1546,
    1548,  1551,  1554,  1557,  1558,  1560,  1563,  1565,  1567,  1569,
    1571,  1574,  1576,  1578,  1581,  1583,  1586,  1588,  1591,  1593,
    1595,  1599,  1601,  1603,  1605,  1607,  1609,  1612,  1614,  1616,
    1618,  1620,  1622,  1624,  1626,  1628,  1632,  1634,  1636,  1638,
    1640,  1643,  1645,  1647,  1649,  1651,  1654,  1656,  1658,  1660,
    1662,  1664,  1667,  1669,  1671,  1673,  1675,  1676,  1678,  1680,
    1682,  1684,  1686,  1688,  1691,  1693,  1695,  1697,  1699,  1701,
    1703,  1705,  1707,  1709,  1711,  1713,  1717,  1725,  1729,  1733,
    1735,  1738,  1745,  1749,  1751,  1753,  1756,  1758,  1759,  1761,
    1764,  1766,  1768,  1770,  1772,  1774,  1776,  1778,  1780,  1782,
    1784,  1786,  1788,  1791,  1793,  1795,  1797,  1799,  1802,  1804,
    1806,  1809,  1812,  1814,  1816,  1820,  1825,  1830,  1833,  1835,
    1838,  1842,  1843,  1845,  1848,  1852,  1853,  1857,  1860,  1862,
    1863,  1865,  1868,  1870,  1872,  1874,  1876,  1878,  1880,  1882,
    1884,  1886,  1888,  1890,  1891,  1893,  1895,  1897,  1899,  1901,
    1903,  1904,  1907,  1910,  1911,  1914,  1918,  1922,  1924,  1927,
    1928,  1931,  1933,  1935,  1936,  1938,  1941,  1944,  1946,  1948,
    1949,  1951,  1955,  1957,  1961,  1965,  1967,  1969,  1971,  1973,
    1975,  1977,  1979,  1981,  1983,  1985,  1987,  1988,  1990,  1992,
    1993,  1995,  1997,  1998,  2000,  2002,  2004,  2006,  2008,  2010,
    2012,  2014,  2016,  2018,  2020,  2022,  2024,  2026,  2028,  2032,
    2034,  2038,  2040,  2042,  2044,  2046,  2048,  2050,  2052,  2055,
    2057,  2059,  2061,  2063,  2065,  2067,  2069,  2071,  2073,  2075,
    2077,  2079,  2081,  2083,  2085,  2087,  2089,  2091,  2093,  2095,
    2097,  2099,  2101,  2103,  2105,  2107,  2109,  2111,  2114,  2116,
    2118,  2120,  2122,  2124,  2126,  2128,  2130,  2132,  2134,  2136,
    2138,  2140,  2142,  2144,  2146,  2149,  2153,  2154,  2156,  2158,
    2159,  2161,  2163,  2165,  2166,  2168,  2170,  2172,  2174,  2176,
    2177,  2179,  2181,  2183,  2185,  2187,  2189,  2191,  2193,  2195,
    2196,  2198,  2200,  2202,  2204,  2206,  2209,  2211,  2213,  2217,
    2220,  2222,  2223,  2225,  2227,  2229,  2230,  2232,  2234,  2236,
    2237,  2239,  2241,  2243,  2245,  2247,  2249,  2251,  2253,  2255,
    2257,  2259,  2261,  2263,  2265,  2267,  2269,  2271,  2273,  2275,
    2277,  2279,  2281,  2282,  2284,  2286,  2288,  2289,  2291,  2293,
    2295,  2297,  2299,  2301,  2303,  2304,  2306,  2308,  2310,  2311,
    2313,  2314,  2316,  2318,  2320,  2322,  2325,  2327,  2329,  2330
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     285,     0,    -1,    -1,   285,   286,    -1,   287,   645,    -1,
     289,   645,    -1,   304,   645,    -1,   305,   645,    -1,   308,
     645,    -1,   310,   645,    -1,   311,    -1,   312,   645,    -1,
     316,   645,    -1,   322,   645,    -1,   323,   645,    -1,   324,
     645,    -1,   645,    -1,     1,    -1,     3,   588,   594,   513,
      -1,   288,   587,   594,   513,    -1,   157,   598,    -1,     7,
     598,    -1,    12,   598,    -1,   149,   598,    -1,   329,    -1,
       5,   589,   593,   291,    -1,    -1,     5,   604,   290,   629,
     593,   526,    -1,     5,   301,    38,   294,   527,   533,    -1,
       5,   301,   482,   655,   603,   631,   629,   639,   513,    -1,
       5,     1,    -1,   513,    -1,   513,   292,    -1,   513,   300,
      -1,   293,   277,   597,    -1,   293,   513,    -1,   293,     1,
      -1,    15,   595,    -1,   169,    -1,   217,    -1,    -1,    24,
     295,    -1,    71,   296,    72,    -1,    71,   296,    72,    -1,
      69,   296,    70,    -1,     1,    -1,    -1,   297,    -1,   297,
     602,   298,    -1,   298,    -1,    28,   299,    -1,    52,   299,
      -1,    52,    56,   576,    -1,   356,    -1,    -1,    22,   605,
      -1,   135,    -1,    61,   617,   596,    -1,    -1,   301,   302,
      -1,   539,    -1,   303,    -1,     4,   541,    -1,   243,    -1,
     223,    -1,   244,    -1,   187,    -1,   248,    -1,   226,    -1,
     189,    -1,   167,    -1,   190,    -1,    10,   225,    -1,   227,
      -1,   229,    -1,   149,    -1,   202,    -1,   208,    -1,    51,
     656,    -1,     6,   587,   593,   513,    -1,   307,   325,    -1,
     307,   327,    -1,   307,   361,    -1,   307,   330,    -1,   307,
     336,    -1,   307,   388,    -1,   307,   387,    -1,   307,   389,
      -1,   307,   353,    -1,   307,   391,    -1,   307,   415,    -1,
     307,   360,    -1,    -1,   307,   206,   306,   361,    -1,   307,
     370,    -1,   307,   611,   372,    -1,   307,   580,    -1,   307,
       1,    -1,     8,    -1,     9,   309,    -1,    -1,    25,    -1,
      31,    -1,    45,    -1,     1,    -1,    11,    -1,   337,    -1,
      13,    -1,    13,   313,    -1,   313,   314,    -1,   314,    -1,
     279,   315,    -1,    -1,   110,   279,    -1,   110,     1,    -1,
      14,   574,   319,    -1,    14,   574,    18,   318,    -1,    14,
     320,   613,   319,    -1,    14,   320,   613,    18,   318,    -1,
      14,   278,    -1,    14,     1,    -1,    31,    -1,   152,    -1,
     207,    -1,   317,    -1,     1,    -1,    -1,   317,    -1,    -1,
      16,   321,    -1,    50,    -1,    57,    -1,    -1,    50,    -1,
      57,    -1,   360,    -1,   363,    -1,   371,    -1,    -1,    69,
     452,   326,   429,   640,   584,    -1,    69,   415,   640,    -1,
      -1,   329,   622,   452,   328,   429,   614,   621,   583,   640,
      -1,   182,    -1,   186,    -1,   198,    -1,   199,    -1,    -1,
      -1,   333,   331,   653,   332,   361,    -1,   335,   621,   277,
     640,    -1,    -1,   335,   621,   452,   334,   429,   640,    -1,
     335,   621,     1,    70,    -1,   169,    -1,   217,    -1,   156,
     621,   648,   640,    -1,   338,    -1,   341,    -1,   343,    -1,
      -1,    -1,   477,   339,   572,   340,   350,    -1,    -1,   468,
     342,   572,   469,    -1,    -1,    -1,   625,   344,   346,   345,
     349,    -1,   347,    -1,   348,    -1,     1,    -1,   347,    64,
     278,    -1,   347,    64,   574,    -1,   347,    64,   167,   576,
      -1,   278,    -1,   348,    64,   580,    -1,   348,    64,   574,
      -1,   348,    64,   167,   576,    -1,   574,    -1,   351,    -1,
       1,    -1,    -1,   351,    -1,   271,   272,    -1,   271,   352,
     644,   635,    -1,   337,    -1,   363,   643,    -1,   371,   643,
      -1,     1,    -1,    71,   354,    72,   357,   301,   358,    -1,
      -1,   355,    -1,   355,   602,   356,    -1,   356,    -1,    80,
      -1,    80,   278,    -1,   110,    -1,   278,    -1,   201,    -1,
      76,   649,    -1,    -1,    69,   404,    70,    -1,    -1,    -1,
      75,   452,   359,   429,    -1,   200,    -1,    -1,   452,   362,
     375,    -1,    -1,    -1,   152,   653,   364,   452,   365,   366,
      -1,    -1,   366,   129,   367,   369,    -1,   368,    -1,   379,
      -1,   368,    -1,     1,    -1,   426,    -1,   372,    -1,    -1,
      -1,   207,   373,   570,   487,   609,   452,   374,   429,    -1,
      -1,   376,    -1,   376,   129,   378,    -1,   377,    -1,   379,
      -1,   377,    -1,     1,    -1,   381,    -1,   412,    -1,   419,
      -1,   422,    -1,   525,   380,    -1,   390,    -1,   412,    -1,
     382,    -1,   385,    -1,   390,    -1,   409,    -1,   411,    -1,
     581,   497,    -1,   425,    -1,   426,    -1,   428,    -1,   381,
     383,   497,    -1,   384,    -1,    71,   479,   636,    -1,    71,
     479,   646,   277,   636,    -1,    71,   478,    76,   636,    -1,
      71,   149,   478,   277,   636,    -1,    71,   636,    -1,    71,
     277,   636,    -1,    71,     1,    72,    -1,    -1,    69,   105,
     386,   478,   379,   640,   621,   404,    70,   497,    -1,   657,
      77,   570,   621,   393,   398,   497,   402,    -1,   615,   183,
     621,   404,   393,   398,   497,    -1,   615,   608,   621,   393,
     398,   497,    -1,   381,    69,   404,   393,   397,   398,   400,
     402,    -1,    -1,   278,    69,   392,   404,    70,   398,   402,
      -1,    -1,    70,   394,   395,    -1,    -1,   395,   396,    -1,
     481,    -1,   226,    -1,   229,    -1,   259,    -1,    -1,    80,
      -1,   107,    -1,    -1,   227,    -1,   227,    69,   399,   640,
      -1,   202,   621,   640,    -1,   202,   621,   405,    70,    -1,
     188,    -1,   203,    -1,     1,    -1,    -1,    -1,    75,   452,
     401,   429,    -1,   498,    -1,    -1,   110,   135,    -1,   110,
     184,    -1,   110,   277,    -1,   110,     1,    -1,   405,    -1,
       1,    -1,    -1,   405,    -1,   405,   602,   408,    -1,   406,
      -1,    -1,   650,   452,   407,   429,    -1,   575,    -1,   158,
      -1,   406,    -1,     1,    -1,    -1,    69,   410,   379,   640,
      -1,   577,   193,   604,   621,   404,   393,   397,   398,   400,
     402,    -1,    -1,   414,   413,   379,    -1,    76,   478,    -1,
     416,    -1,   416,   129,   376,    -1,    -1,   418,   417,   379,
      -1,    76,   478,    -1,    -1,   421,   420,   379,    -1,   571,
      66,   482,    -1,    -1,   424,   423,   379,    -1,    80,   478,
      -1,   107,   478,    -1,   578,    -1,    -1,   577,   193,   452,
     427,   444,   621,   393,   398,   402,    -1,   577,   193,   634,
     576,   621,   403,    70,   398,   400,    -1,    -1,   430,    -1,
     431,    -1,   438,    -1,   440,    -1,   442,    -1,   432,    -1,
     433,    -1,   435,    -1,   436,    -1,   581,    -1,   429,   383,
      -1,    -1,    69,   105,   434,   478,   429,   640,   621,   404,
      70,    -1,   431,    69,   404,   393,   398,   400,    -1,    -1,
      69,   437,   429,   640,    -1,    -1,   414,   439,   429,    -1,
      -1,   421,   441,   429,    -1,    -1,   424,   443,   429,    -1,
      -1,   445,    -1,   446,    -1,   448,    -1,   450,    -1,   581,
      -1,    -1,   414,   447,   444,    -1,    -1,   421,   449,   444,
      -1,    -1,   424,   451,   444,    -1,   454,    -1,   454,   457,
      -1,   457,    -1,    -1,   454,    -1,   454,   455,    -1,   455,
      -1,   456,    -1,   480,    -1,   485,    -1,   488,    -1,   165,
      -1,   166,    -1,   145,    -1,   148,    -1,   160,    -1,   154,
      -1,   254,    -1,   146,    -1,   458,   453,    -1,   465,   482,
      -1,   459,    -1,   461,    -1,   578,    -1,   463,    -1,    -1,
     172,   621,   452,   460,   429,   640,    -1,   462,    -1,   211,
     621,   617,   640,    -1,   161,    -1,   219,    -1,   164,    -1,
     179,    -1,   133,    -1,   240,    -1,   209,    -1,   210,    -1,
     163,    -1,   144,    -1,   140,    -1,   137,    -1,   252,    -1,
     253,    -1,   464,    -1,   213,    -1,   214,    -1,   466,    -1,
     467,    -1,   477,   487,   572,    -1,   477,   487,   573,   271,
      -1,   468,   487,   572,   469,    -1,   468,   487,   573,   271,
      -1,   159,   475,    -1,    -1,   269,   470,    -1,   269,     1,
      -1,   472,    -1,   472,   474,   471,    -1,   474,   471,    -1,
      -1,   472,    -1,   472,   473,    -1,   473,    -1,   145,    -1,
     148,    -1,   160,    -1,   154,    -1,   461,    -1,   578,    -1,
     463,    -1,    -1,   476,    -1,   181,    -1,   150,    -1,   476,
      -1,   153,    -1,    -1,   479,    -1,   479,   480,   495,    -1,
     496,   480,    -1,   480,   495,    -1,   171,    -1,   481,    -1,
     483,    -1,   255,    -1,   256,    -1,   256,   484,    -1,   257,
      -1,   157,    -1,   162,    -1,    -1,   482,   481,    -1,   168,
      -1,   259,    -1,    71,    72,    -1,    71,   277,   636,    -1,
      71,    76,   636,    -1,    71,     1,    72,    -1,   130,    -1,
     260,    -1,   243,    -1,   223,    -1,   244,    -1,   187,    -1,
     248,    -1,   139,    -1,   610,    -1,   226,    -1,   189,    -1,
     167,    -1,   190,    -1,   486,    -1,   229,    -1,   149,    -1,
     152,    -1,   176,    -1,   232,    -1,   208,    -1,   174,    -1,
     239,    -1,    -1,   488,    -1,    -1,   216,    71,   489,   490,
     491,    72,   636,    -1,   496,    -1,    -1,   207,   576,   601,
      -1,    -1,   492,    -1,   492,   602,   493,    -1,   493,    -1,
     222,    -1,   233,   494,    -1,   235,    -1,   238,   494,    -1,
     239,    -1,   249,    -1,   212,    -1,   215,    -1,   580,    -1,
       1,    -1,    -1,    69,   648,   640,    -1,    -1,   496,    -1,
     498,    -1,   508,    -1,    -1,   498,    -1,   498,   499,    -1,
     499,    -1,    -1,   258,   500,   621,   621,   501,    70,   640,
      -1,    -1,   502,    -1,   502,   602,   503,    -1,   503,    -1,
     278,   504,    -1,     1,    -1,    -1,    69,   505,    70,    -1,
      -1,   506,    -1,   506,   602,   507,    -1,   507,    -1,   278,
      -1,   277,    -1,   273,    -1,   280,    -1,    69,   506,   640,
      -1,   283,    -1,   508,   509,    -1,   509,    -1,    -1,   264,
     510,   621,   511,    70,    -1,    -1,   512,    -1,   512,   503,
      -1,   503,    -1,   535,    -1,   550,    -1,   551,    -1,    17,
     646,   515,   517,   626,   513,    -1,    59,   518,   592,   515,
     626,   513,    -1,    -1,   516,    -1,   481,    -1,    -1,   277,
      -1,    76,    -1,    -1,    39,    -1,   261,   527,   533,    -1,
      26,   527,    -1,    30,   522,    -1,    -1,    69,   640,    -1,
     524,   623,    35,   527,   533,    -1,   532,    -1,   525,    -1,
     262,    -1,   263,    -1,   265,    -1,   266,    -1,   267,    -1,
     268,    -1,   536,   532,   623,   630,   527,   533,    -1,    -1,
     528,    -1,    69,   529,    70,    -1,    -1,   530,    -1,   530,
     602,   531,    -1,   513,    -1,   513,    -1,     1,    -1,    -1,
      52,    -1,    54,   637,    -1,    -1,   534,    -1,   638,   513,
      -1,   638,     1,    -1,   536,   546,    -1,    -1,   537,    -1,
     537,   538,    -1,   538,    -1,   539,    -1,   540,    -1,   544,
      -1,   220,   607,    -1,   222,    -1,   233,    -1,   236,   654,
      -1,   235,    -1,    10,   234,    -1,   238,    -1,    10,   147,
      -1,   174,    -1,   239,    -1,    10,   251,   591,    -1,   249,
      -1,   212,    -1,   215,    -1,   130,    -1,   260,    -1,     4,
     541,    -1,   243,    -1,   223,    -1,   244,    -1,   135,    -1,
     184,    -1,   187,    -1,   248,    -1,   139,    -1,   139,   542,
     543,    -1,   226,    -1,   189,    -1,   167,    -1,   190,    -1,
      10,   225,    -1,   227,    -1,   229,    -1,   149,    -1,   201,
      -1,   177,   620,    -1,   176,    -1,   232,    -1,   202,    -1,
     152,    -1,   208,    -1,    51,   656,    -1,    32,    -1,    33,
      -1,    36,    -1,   647,    -1,    -1,    40,    -1,   171,    -1,
     481,    -1,   483,    -1,   255,    -1,   256,    -1,   256,   545,
      -1,   257,    -1,   277,    -1,    76,    -1,   514,    -1,   519,
      -1,   520,    -1,   521,    -1,   523,    -1,   547,    -1,   548,
      -1,   552,    -1,    47,   651,   513,    -1,    47,   651,    42,
     626,   600,   587,   513,    -1,    47,   651,     1,    -1,   549,
     651,   513,    -1,    52,    -1,    54,   637,    -1,   655,   619,
     621,   529,    70,   533,    -1,   580,    18,   513,    -1,   586,
      -1,   158,    -1,   553,   556,    -1,   554,    -1,    -1,   554,
      -1,   554,   555,    -1,   555,    -1,   456,    -1,   557,    -1,
     562,    -1,   563,    -1,   578,    -1,   558,    -1,   559,    -1,
     161,    -1,   219,    -1,   164,    -1,   179,    -1,   133,   618,
      -1,   240,    -1,   209,    -1,   210,    -1,   163,    -1,    60,
     599,    -1,   144,    -1,   140,    -1,    34,   632,    -1,   137,
     633,    -1,   252,    -1,   253,    -1,   560,   277,   596,    -1,
     560,    69,   617,   640,    -1,   560,    61,   617,   596,    -1,
     560,     1,    -1,   211,    -1,    20,   616,    -1,    19,   561,
     616,    -1,    -1,    48,    -1,   477,   572,    -1,   468,   572,
     564,    -1,    -1,    44,   652,   565,    -1,   566,   568,    -1,
     567,    -1,    -1,   567,    -1,   567,   473,    -1,   473,    -1,
     557,    -1,   586,    -1,   278,    -1,   281,    -1,   569,    -1,
       1,    -1,   580,    -1,   590,    -1,   571,    -1,     1,    -1,
      -1,   571,    -1,   281,    -1,   282,    -1,   278,    -1,   278,
      -1,     1,    -1,    -1,   194,    64,    -1,   574,   579,    -1,
      -1,    64,   571,    -1,   580,    64,   278,    -1,   580,    64,
     574,    -1,   278,    -1,   580,   582,    -1,    -1,   269,   617,
      -1,   580,    -1,     1,    -1,    -1,   580,    -1,   571,   629,
      -1,   278,   629,    -1,   585,    -1,     1,    -1,    -1,   585,
      -1,   589,   129,   587,    -1,   585,    -1,   590,    64,   580,
      -1,   590,    64,   574,    -1,   574,    -1,   241,    -1,     1,
      -1,    17,    -1,     1,    -1,    18,    -1,     1,    -1,    18,
      -1,    37,    -1,    56,    -1,     1,    -1,    -1,    18,    -1,
      56,    -1,    -1,    19,    -1,    21,    -1,    -1,    23,    -1,
       3,    -1,     1,    -1,   133,    -1,     1,    -1,   477,    -1,
       1,    -1,   269,    -1,     1,    -1,   129,    -1,     1,    -1,
      27,    -1,     1,    -1,   245,    -1,   192,    -1,   192,    71,
     636,    -1,   184,    -1,   184,    71,   636,    -1,    79,    -1,
     102,    -1,    86,    -1,   127,    -1,    80,    -1,   107,    -1,
     126,    -1,    69,   640,    -1,    76,    -1,   125,    -1,    88,
      -1,    67,    -1,   124,    -1,   129,    -1,    87,    -1,    68,
      -1,   123,    -1,    75,    -1,    83,    -1,    73,    -1,    84,
      -1,    85,    -1,   122,    -1,    64,    -1,    95,    -1,    92,
      -1,   121,    -1,   100,    -1,    94,    -1,   110,    -1,   103,
      -1,    96,    -1,    91,    -1,   120,    -1,    99,    -1,   128,
      -1,    71,   636,    -1,   105,    -1,   119,    -1,   106,    -1,
     108,    -1,   118,    -1,    77,    -1,   135,    -1,     1,    -1,
      29,    -1,     1,    -1,   221,    -1,     1,    -1,   185,    -1,
     283,    -1,   110,    -1,     1,    -1,   139,   542,    -1,   139,
     542,   271,    -1,    -1,   610,    -1,   276,    -1,    -1,   612,
      -1,    96,    -1,     1,    -1,    -1,   167,    -1,   144,    -1,
       1,    -1,   277,    -1,     1,    -1,    -1,   277,    -1,    41,
      -1,     1,    -1,   178,    -1,     1,    -1,    69,    -1,     1,
      -1,    95,    -1,     1,    -1,    -1,    42,    -1,    43,    -1,
     191,    -1,     1,    -1,   191,    -1,   167,   624,    -1,    44,
      -1,     1,    -1,    44,   642,   572,    -1,   628,   627,    -1,
     627,    -1,    -1,   628,    -1,   193,    -1,     1,    -1,    -1,
     193,    -1,    46,    -1,     1,    -1,    -1,    49,    -1,   230,
      -1,     1,    -1,   272,    -1,     1,    -1,    72,    -1,     1,
      -1,    52,    -1,     1,    -1,    53,    -1,   147,    -1,   638,
      -1,     1,    -1,    70,    -1,     1,    -1,   477,    -1,   625,
      -1,    55,    -1,   641,    -1,     1,    -1,   270,    -1,     1,
      -1,    -1,   270,    -1,   270,    -1,   274,    -1,    -1,   149,
      -1,   280,    -1,   283,    -1,   647,    -1,     1,    -1,   201,
      -1,     1,    -1,    -1,   201,    -1,    56,    -1,     1,    -1,
      -1,   152,    -1,    -1,   206,    -1,   237,    -1,     1,    -1,
      58,    -1,    57,   606,    -1,   208,    -1,     1,    -1,    -1,
     208,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1807,  1807,  1809,  1818,  1819,  1820,  1821,  1822,  1823,
    1824,  1825,  1826,  1827,  1828,  1829,  1830,  1831,  1850,  1871,
    1904,  1905,  1906,  1907,  1908,  1917,  2046,  2045,  2089,  2120,
    2156,  2166,  2168,  2175,  2195,  2201,  2207,  2216,  2217,  2218,
    2222,  2223,  2227,  2234,  2238,  2242,  2249,  2250,  2254,  2268,
    2283,  2288,  2293,  2299,  2302,  2304,  2305,  2309,  2323,  2324,
    2342,  2343,  2364,  2368,  2369,  2370,  2371,  2372,  2373,  2374,
    2375,  2376,  2377,  2378,  2379,  2380,  2381,  2382,  2383,  2389,
    2440,  2445,  2450,  2455,  2460,  2465,  2470,  2475,  2480,  2485,
    2495,  2500,  2510,  2510,  2525,  2530,  2547,  2554,  2561,  2578,
    2582,  2583,  2584,  2585,  2586,  2595,  2601,  2607,  2611,  2615,
    2616,  2620,  2630,  2631,  2632,  2642,  2652,  2662,  2671,  2680,
    2709,  2718,  2719,  2720,  2734,  2735,  2745,  2746,  2750,  2751,
    2756,  2757,  2761,  2762,  2763,  2769,  2775,  2781,  2792,  2791,
    2829,  2836,  2835,  2878,  2879,  2880,  2881,  2891,  2892,  2891,
    2897,  2908,  2908,  2927,  2934,  2935,  2941,  2952,  2953,  2954,
    2962,  2967,  2961,  3021,  3020,  3064,  3068,  3063,  3132,  3133,
    3134,  3147,  3161,  3176,  3190,  3209,  3223,  3239,  3254,  3258,
    3259,  3265,  3267,  3271,  3272,  3276,  3277,  3278,  3279,  3288,
    3318,  3319,  3323,  3338,  3353,  3358,  3364,  3369,  3374,  3379,
    3387,  3388,  3392,  3393,  3393,  3412,  3422,  3422,  3432,  3438,
    3431,  3469,  3468,  3479,  3484,  3548,  3549,  3558,  3573,  3584,
    3588,  3583,  3672,  3711,  3715,  3716,  3721,  3810,  3811,  3818,
    3819,  3820,  3821,  3822,  3831,  3832,  3836,  3837,  3838,  3839,
    3840,  3841,  3845,  3846,  3847,  3854,  3882,  3887,  3893,  3899,
    3905,  3914,  3915,  3916,  3927,  3926,  3965,  4003,  4041,  4085,
    4228,  4227,  4324,  4323,  4342,  4343,  4359,  4360,  4361,  4369,
    4373,  4374,  4375,  4379,  4380,  4381,  4385,  4389,  4408,  4409,
    4410,  4417,  4419,  4419,  4470,  4477,  4478,  4479,  4480,  4488,
    4500,  4501,  4509,  4510,  4514,  4527,  4544,  4544,  4575,  4580,
    4592,  4593,  4603,  4602,  4627,  4681,  4681,  4700,  4720,  4721,
    4725,  4725,  4747,  4784,  4784,  4803,  4841,  4841,  4859,  4876,
    4897,  4987,  4986,  5035,  5080,  5081,  5085,  5086,  5087,  5088,
    5092,  5093,  5094,  5095,  5097,  5107,  5139,  5138,  5175,  5251,
    5250,  5293,  5293,  5312,  5312,  5332,  5332,  5358,  5359,  5363,
    5364,  5365,  5366,  5370,  5370,  5387,  5387,  5404,  5404,  5430,
    5465,  5480,  5484,  5485,  5489,  5503,  5507,  5531,  5532,  5533,
    5540,  5541,  5542,  5543,  5544,  5545,  5546,  5552,  5556,  5572,
    5589,  5590,  5591,  5592,  5599,  5598,  5647,  5658,  5673,  5674,
    5675,  5676,  5677,  5678,  5679,  5680,  5681,  5682,  5683,  5684,
    5685,  5686,  5690,  5698,  5699,  5705,  5706,  5710,  5731,  5744,
    5769,  5783,  5787,  5788,  5789,  5805,  5823,  5848,  5866,  5867,
    5871,  5886,  5890,  5891,  5892,  5893,  5897,  5898,  5899,  5905,
    5906,  5910,  5911,  5915,  5916,  5922,  5923,  5927,  5942,  5947,
    5954,  5955,  5956,  5957,  5958,  5959,  5960,  5964,  5965,  5969,
    5970,  5986,  6000,  6004,  6005,  6006,  6007,  6016,  6017,  6018,
    6019,  6020,  6021,  6022,  6023,  6024,  6025,  6026,  6027,  6028,
    6029,  6054,  6056,  6057,  6058,  6059,  6060,  6064,  6065,  6071,
    6072,  6077,  6076,  6100,  6106,  6108,  6118,  6119,  6123,  6137,
    6141,  6142,  6143,  6144,  6145,  6146,  6147,  6148,  6149,  6180,
    6186,  6188,  6197,  6199,  6203,  6204,  6207,  6209,  6213,  6214,
    6219,  6218,  6233,  6235,  6239,  6240,  6244,  6248,  6254,  6256,
    6259,  6261,  6265,  6266,  6270,  6271,  6272,  6273,  6274,  6275,
    6282,  6283,  6288,  6287,  6299,  6301,  6312,  6313,  6321,  6322,
    6323,  6329,  6355,  6378,  6379,  6383,  6387,  6388,  6389,  6392,
    6394,  6401,  6423,  6440,  6451,  6453,  6460,  6489,  6493,  6500,
    6501,  6502,  6503,  6504,  6505,  6512,  6550,  6551,  6555,  6569,
    6570,  6574,  6588,  6605,  6606,  6615,  6616,  6617,  6624,  6635,
    6639,  6650,  6659,  6678,  6679,  6683,  6698,  6702,  6703,  6704,
    6708,  6709,  6710,  6711,  6712,  6713,  6714,  6715,  6716,  6717,
    6718,  6719,  6720,  6721,  6725,  6726,  6727,  6731,  6732,  6733,
    6734,  6735,  6736,  6737,  6738,  6739,  6743,  6744,  6745,  6746,
    6747,  6748,  6749,  6751,  6752,  6753,  6754,  6755,  6756,  6757,
    6758,  6759,  6763,  6764,  6765,  6776,  6795,  6797,  6801,  6802,
    6803,  6804,  6805,  6806,  6807,  6811,  6812,  6816,  6817,  6818,
    6819,  6820,  6821,  6822,  6823,  6833,  6855,  6878,  6891,  6908,
    6913,  6922,  6961,  6985,  6990,  7007,  7029,  7049,  7050,  7054,
    7069,  7073,  7077,  7078,  7079,  7080,  7084,  7096,  7111,  7112,
    7113,  7114,  7115,  7127,  7128,  7129,  7130,  7131,  7132,  7133,
    7134,  7135,  7136,  7137,  7141,  7145,  7149,  7153,  7160,  7161,
    7162,  7165,  7167,  7171,  7188,  7207,  7208,  7215,  7233,  7248,
    7249,  7253,  7268,  7272,  7273,  7281,  7282,  7290,  7291,  7299,
    7300,  7304,  7305,  7313,  7314,  7318,  7319,  7323,  7337,  7338,
    7346,  7348,  7357,  7417,  7418,  7422,  7447,  7469,  7483,  7518,
    7519,  7533,  7534,  7542,  7543,  7547,  7566,  7595,  7596,  7604,
    7605,  7609,  7625,  7641,  7660,  7682,  7690,  7691,  7698,  7699,
    7706,  7726,  7733,  7734,  7735,  7736,  7742,  7744,  7745,  7748,
    7750,  7751,  7754,  7756,  7760,  7761,  7768,  7769,  7776,  7777,
    7784,  7785,  7792,  7793,  7800,  7801,  7808,  7809,  7810,  7811,
    7812,  7813,  7814,  7815,  7816,  7817,  7818,  7819,  7820,  7821,
    7822,  7823,  7824,  7825,  7826,  7827,  7828,  7829,  7830,  7831,
    7832,  7833,  7834,  7835,  7836,  7837,  7838,  7839,  7840,  7841,
    7842,  7843,  7844,  7845,  7846,  7847,  7848,  7849,  7850,  7851,
    7852,  7853,  7854,  7855,  7859,  7860,  7867,  7868,  7875,  7876,
    7883,  7884,  7892,  7893,  7900,  7901,  7911,  7912,  7916,  7928,
    7929,  7933,  7934,  7941,  7942,  7946,  7947,  7954,  7955,  7962,
    7963,  7967,  7968,  7975,  7976,  7983,  7984,  7991,  7992,  7999,
    8000,  8001,  8005,  8006,  8013,  8014,  8018,  8019,  8026,  8049,
    8059,  8063,  8064,  8068,  8069,  8075,  8077,  8081,  8082,  8087,
    8089,  8093,  8094,  8101,  8102,  8109,  8110,  8117,  8118,  8125,
    8126,  8130,  8131,  8138,  8139,  8146,  8147,  8148,  8152,  8153,
    8162,  8163,  8169,  8171,  8175,  8176,  8180,  8181,  8185,  8186,
    8194,  8195,  8203,  8204,  8211,  8212,  8216,  8217,  8223,  8225,
    8229,  8230,  8234,  8235,  8242,  8243,  8247,  8248,  8255,  8256
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "Y_cast", "Y_const_ENG", "Y_declare",
  "Y_define", "Y_dynamic", "Y_explain", "Y_help", "Y_no", "Y_quit",
  "Y_reinterpret", "Y_set", "Y_show", "Y_aligned", "Y_all", "Y_array",
  "Y_as", "Y_bit", "Y_bit_precise", "Y_bits", "Y_by", "Y_bytes",
  "Y_capturing", "Y_commands", "Y_constructor", "Y_conversion", "Y_copy",
  "Y_defined", "Y_destructor", "Y_english", "Y_evaluation", "Y_expression",
  "Y_floating", "Y_function", "Y_initialization", "Y_into", "Y_lambda",
  "Y_length", "Y_linkage", "Y_literal", "Y_member", "Y_non_member", "Y_of",
  "Y_options", "Y_point", "Y_pointer", "Y_precise", "Y_precision",
  "Y_predefined", "Y_pure", "Y_reference", "Y_returning", "Y_rvalue",
  "Y_scope", "Y_to", "Y_user", "Y_user_defined", "Y_variable", "Y_wide",
  "Y_width", "Y_PREC_LESS_THAN_upc_layout_qualifier", "\"::\"", "Y_COLON2",
  "\"::*\"", "Y_COLON2_STAR", "\"++\"", "\"--\"", "'('", "')'", "'['",
  "']'", "'.'", "\"->\"", "Y_ARROW", "'*'", "Y_TILDE", "Y_sizeof",
  "Y_EXCLAM", "Y_AMPER", "\".*\"", "\"->*\"", "Y_ARROW_STAR", "Y_DOT_STAR",
  "'/'", "'%'", "'-'", "'+'", "\"<<\"", "\">>\"", "Y_GREATER2", "Y_LESS2",
  "\"<=>\"", "Y_LESS_EQUAL_GREATER", "'<'", "'>'", "\"<=\"", "\">=\"",
  "Y_GREATER_EQUAL", "Y_LESS_EQUAL", "\"==\"", "Y_EXCLAM_EQUAL",
  "Y_EQUAL2", "Y_bit_and", "Y_CARET", "Y_PIPE", "Y_AMPER2", "Y_PIPE2",
  "\"?:\"", "'='", "\"%=\"", "\"*=\"", "\"+=\"", "\"-=\"", "\"/=\"",
  "\"<<=\"", "\">>=\"", "Y_PIPE_EQUAL", "Y_CARET_EQUAL",
  "Y_GREATER2_EQUAL", "Y_LESS2_EQUAL", "Y_SLASH_EQUAL", "Y_MINUS_EQUAL",
  "Y_PLUS_EQUAL", "Y_STAR_EQUAL", "Y_AMPER_EQUAL", "Y_PERCENT_EQUAL",
  "Y_QMARK_COLON", "','", "Y_auto_STORAGE", "Y_break", "Y_case", "Y_char",
  "Y_continue", "Y_default", "Y_do", "Y_double", "Y_else", "Y_extern",
  "Y_float", "Y_for", "Y_goto", "Y_if", "Y_int", "Y_long", "Y_register",
  "Y_return", "Y_short", "Y_static", "Y_struct", "Y_switch", "Y_typedef",
  "Y_union", "Y_unsigned", "Y_while", "Y_asm", "Y_const", "\"...\"",
  "Y_enum", "Y_signed", "Y_void", "Y_volatile", "Y_wchar_t", "Y__Bool",
  "Y__Complex", "Y__Imaginary", "Y_inline", "Y_restrict", "Y__Alignas",
  "Y__Alignof", "Y__Atomic_QUAL", "Y__Atomic_SPEC", "Y__Generic",
  "Y__Noreturn", "Y__Static_assert", "Y__Thread_local", "Y_thread",
  "Y_local", "Y_bool", "Y_catch", "Y_class", "Y_const_cast",
  "Y_CONSTRUCTOR_SNAME", "Y_delete", "Y_DESTRUCTOR_SNAME",
  "Y_dynamic_cast", "Y_explicit", "Y_false", "Y_friend", "Y_mutable",
  "Y_namespace", "Y_new", "Y_operator", "Y_OPERATOR_SNAME", "Y_private",
  "Y_protected", "Y_public", "Y_reinterpret_cast", "Y_static_cast",
  "Y_template", "Y_this", "Y_throw", "Y_true", "Y_try", "Y_typeid",
  "Y_typename", "Y_using", "Y_virtual", "Y_char16_t", "Y_char32_t",
  "Y__BitInt", "Y_reproducible", "Y_typeof", "Y_typeof_unqual",
  "Y_unsequenced", "Y_ATTR_BEGIN", "Y_alignas", "Y_alignof", "Y_auto_TYPE",
  "Y_carries", "Y_dependency", "Y_carries_dependency", "Y_constexpr",
  "Y_decltype", "Y_except", "Y_final", "Y_noexcept", "Y_nullptr",
  "Y_override", "Y_QUOTE2", "Y_static_assert", "Y_thread_local",
  "Y_deprecated", "Y_discard", "Y_maybe_unused", "Y_maybe", "Y_unused",
  "Y_nodiscard", "Y_noreturn", "Y_char8_t", "Y_address", "Y_concept",
  "Y_consteval", "Y_constinit", "Y_co_await", "Y_co_return", "Y_co_yield",
  "Y_export", "Y_no_unique_address", "Y_requires", "Y_unique",
  "Y_EMC__Accum", "Y_EMC__Fract", "Y_EMC__Sat", "Y_UPC_relaxed",
  "Y_UPC_shared", "Y_UPC_strict", "Y_GNU___attribute__",
  "Y_GNU___restrict", "Y_Apple___block", "Y_Apple_block", "Y_MSC___cdecl",
  "Y_MSC___clrcall", "Y_MSC___declspec", "Y_MSC___fastcall",
  "Y_MSC___stdcall", "Y_MSC___thiscall", "Y_MSC___vectorcall", "':'",
  "';'", "'{'", "'}'", "Y_CHAR_LIT", "Y_END", "Y_ERROR", "Y_GLOB",
  "Y_INT_LIT", "Y_NAME", "Y_SET_OPTION", "Y_STR_LIT", "Y_TYPEDEF_NAME",
  "Y_TYPEDEF_SNAME", "Y_LEXER_ERROR", "$accept", "command_list", "command",
  "cast_command", "new_style_cast_english", "declare_command", "@1",
  "alignas_or_width_decl_english_ast", "alignas_specifier_english",
  "aligned_english", "capturing_paren_capture_decl_list_english_opt",
  "paren_capture_decl_list_english", "capture_decl_list_english_opt",
  "capture_decl_list_english", "capture_decl_english_ast",
  "capture_default_opt", "width_specifier_english_uint",
  "storage_class_subset_english_type_opt",
  "storage_class_subset_english_type", "storage_class_subset_english_stid",
  "define_command", "explain_command", "@2", "explain", "help_command",
  "help_what_opt", "quit_command", "scoped_command", "set_command",
  "set_option_list", "set_option", "set_option_value_opt", "show_command",
  "show_format", "show_format_exp", "show_format_opt",
  "show_which_types_flags_opt", "predefined_or_user_flags_opt",
  "template_command", "typedef_command", "using_command",
  "c_style_cast_expr_c", "@3", "new_style_cast_expr_c", "@4",
  "new_style_cast_c", "aligned_declaration_c", "@5", "@6",
  "alignas_specifier_c", "@7", "alignas", "asm_declaration_c",
  "scoped_declaration_c", "class_struct_union_declaration_c", "@8", "@9",
  "enum_declaration_c", "@10", "namespace_declaration_c", "@11", "@12",
  "namespace_sname_c_exp", "namespace_sname_c",
  "namespace_typedef_sname_c", "brace_in_scope_declaration_c_exp",
  "brace_in_scope_declaration_c_opt", "brace_in_scope_declaration_c",
  "in_scope_declaration_c_exp", "lambda_declaration_c",
  "capture_decl_list_c_opt", "capture_decl_list_c", "capture_decl_c_ast",
  "lambda_param_c_ast_list_opt", "lambda_return_type_c_ast_opt", "@13",
  "template_declaration_c", "typed_declaration_c", "@14",
  "typedef_declaration_c", "@15", "@16", "typedef_decl_list_c", "@17",
  "typedef_decl_c", "typedef_decl_c_exp",
  "user_defined_conversion_declaration_c", "using_declaration_c",
  "using_decl_c_ast", "@18", "@19", "decl_list_c_opt", "decl_list_c",
  "decl_c", "decl_c_exp", "decl_c_astp", "msc_calling_convention_c_astp",
  "decl2_c_astp", "array_decl_c_astp", "array_size_c_ast",
  "array_size_c_int", "block_decl_c_astp", "@20",
  "destructor_declaration_c", "file_scope_constructor_declaration_c",
  "file_scope_destructor_declaration_c", "func_decl_c_astp",
  "pc99_func_or_constructor_declaration_c", "@21",
  "rparen_func_qualifier_list_c_stid_opt", "@22",
  "func_qualifier_list_c_stid_opt", "func_qualifier_c_stid",
  "func_ref_qualifier_c_stid_opt", "noexcept_c_stid_opt",
  "noexcept_bool_stid_exp", "trailing_return_type_c_ast_opt", "@23",
  "func_equals_c_stid_opt", "param_c_ast_list_exp", "param_c_ast_list_opt",
  "param_c_ast_list", "param_c_ast", "@24", "param_c_ast_exp",
  "nested_decl_c_astp", "@25", "oper_decl_c_astp", "pointer_decl_c_astp",
  "@26", "pointer_type_c_ast", "pc99_pointer_decl_list_c",
  "pc99_pointer_decl_c", "@27", "pc99_pointer_type_c_ast",
  "pointer_to_member_decl_c_astp", "@28", "pointer_to_member_type_c_ast",
  "reference_decl_c_astp", "@29", "reference_type_c_ast",
  "typedef_type_decl_c_ast", "user_defined_conversion_decl_c_astp", "@30",
  "user_defined_literal_decl_c_astp", "cast_c_astp_opt", "cast_c_astp",
  "cast2_c_astp", "array_cast_c_astp", "block_cast_c_astp", "@31",
  "func_cast_c_astp", "nested_cast_c_astp", "@32", "pointer_cast_c_astp",
  "@33", "pointer_to_member_cast_c_astp", "@34", "reference_cast_c_astp",
  "@35", "udc_decl_c_ast_opt", "udc_decl_c_ast", "pointer_udc_decl_c_ast",
  "@36", "pointer_to_member_udc_decl_c_ast", "@37",
  "reference_udc_decl_c_ast", "@38", "type_c_ast",
  "type_modifier_list_c_type_opt", "type_modifier_list_c_type",
  "type_modifier_c_type", "type_modifier_base_type",
  "east_modified_type_c_ast", "atomic_builtin_typedef_type_c_ast",
  "atomic_specifier_type_c_ast", "@39", "builtin_type_c_ast",
  "builtin_no_BitInt_c_btid", "typeof_type_c_ast", "typeof",
  "enum_class_struct_union_c_ast", "class_struct_union_c_ast",
  "enum_c_ast", "enum_btid", "enum_fixed_type_c_ast_opt",
  "enum_fixed_type_c_ast", "enum_fixed_type_modifier_list_btid_opt",
  "enum_fixed_type_modifier_list_btid", "enum_fixed_type_modifier_btid",
  "enum_unmodified_fixed_type_c_ast", "class_struct_btid_opt",
  "class_struct_btid", "class_struct_union_btid",
  "type_qualifier_list_c_stid_opt", "type_qualifier_list_c_stid",
  "type_qualifier_c_stid", "cv_qualifier_stid",
  "cv_qualifier_list_stid_opt", "restrict_qualifier_c_stid",
  "upc_layout_qualifier_c", "storage_class_c_type", "_Noreturn_atid",
  "attribute_specifier_list_c_atid_opt", "attribute_specifier_list_c_atid",
  "@40", "using_opt", "attribute_list_c_atid_opt", "attribute_list_c_atid",
  "attribute_c_atid_exp", "attribute_str_arg_c_opt",
  "gnu_or_msc_attribute_specifier_list_c_opt",
  "gnu_or_msc_attribute_specifier_list_c",
  "gnu_attribute_specifier_list_c_opt", "gnu_attribute_specifier_list_c",
  "gnu_attribute_specifier_c", "@41", "gnu_attribute_list_c_opt",
  "gnu_attribuet_list_c", "gnu_attribute_c_exp",
  "gnu_attribute_decl_arg_list_c_opt", "gnu_attribute_arg_list_c_opt",
  "gnu_attribute_arg_list_c", "gnu_attribute_arg_c",
  "msc_attribute_specifier_list_c", "msc_attribute_specifier_c", "@42",
  "msc_attribute_list_c_opt", "msc_attribuet_list_c", "decl_english_ast",
  "array_decl_english_ast", "array_qualifier_list_english_stid_opt",
  "array_qualifier_list_english_stid", "array_size_int_opt", "length_opt",
  "block_decl_english_ast", "constructor_decl_english_ast",
  "destructor_decl_english_ast", "parens_opt", "func_decl_english_ast",
  "func_qualifier_english_type_opt", "msc_calling_convention_atid",
  "oper_decl_english_ast", "paren_param_decl_list_english_opt",
  "paren_param_decl_list_english", "param_decl_list_english_opt",
  "param_decl_list_english", "decl_english_ast_exp",
  "ref_qualifier_english_stid_opt", "returning_english_ast_opt",
  "returning_english_ast", "qualified_decl_english_ast",
  "type_qualifier_list_english_type_opt",
  "type_qualifier_list_english_type", "type_qualifier_english_type",
  "attribute_english_atid", "storage_class_english_stid",
  "eval_expr_init_stid", "linkage_stid", "linkage_opt",
  "type_qualifier_english_stid", "upc_layout_qualifier_english",
  "qualifiable_decl_english_ast", "pointer_decl_english_ast",
  "reference_decl_english_ast", "reference_english_ast",
  "user_defined_literal_decl_english_ast", "var_decl_english_ast",
  "type_english_ast", "type_modifier_list_english_type_opt",
  "type_modifier_list_english_type", "type_modifier_english_type",
  "unmodified_type_english_ast", "builtin_type_english_ast",
  "builtin_no_BitInt_english_btid", "BitInt_english_int", "BitInt_english",
  "precise_opt", "class_struct_union_english_ast", "enum_english_ast",
  "of_type_enum_fixed_type_english_ast_opt", "enum_fixed_type_english_ast",
  "enum_fixed_type_modifier_list_english_btid_opt",
  "enum_fixed_type_modifier_list_english_btid",
  "enum_unmodified_fixed_type_english_ast", "any_name", "any_name_exp",
  "any_sname_c", "any_sname_c_exp", "any_sname_c_opt", "any_typedef",
  "name_ast", "name_exp", "oper_sname_c_opt", "typedef_type_c_ast",
  "sub_scope_sname_c_opt", "sname_c", "sname_c_ast",
  "bit_field_c_uint_opt", "sname_c_exp", "sname_c_opt", "sname_english",
  "sname_english_ast", "sname_english_exp", "sname_english_opt",
  "sname_list_english", "typedef_sname_c", "address_exp", "array_exp",
  "as_exp", "as_into_to_exp", "as_or_to_opt", "bits_opt", "bytes_opt",
  "cast_exp", "char_exp", "class_struct_union_btid_exp", "colon_exp",
  "comma_exp", "conversion_exp", "c_operator", "default_exp",
  "defined_exp", "dependency_exp", "destructor_sname", "equals_exp",
  "extern_linkage_c_stid", "extern_linkage_c_stid_opt", "glob", "glob_opt",
  "gt_exp", "inline_stid_opt", "int_exp", "int_lit_exp", "int_lit_opt",
  "literal_exp", "local_exp", "lparen_exp", "lt_exp",
  "member_or_non_member_flags_opt", "namespace_btid_exp", "namespace_type",
  "of_exp", "of_scope_english", "of_scope_list_english",
  "of_scope_list_english_opt", "operator_exp", "operator_opt", "point_exp",
  "precision_opt", "quote2_exp", "rbrace_exp", "rbracket_exp",
  "reference_exp", "returning", "returning_exp", "rparen_exp",
  "scope_english_type", "scope_english_type_exp", "semi_exp", "semi_opt",
  "semi_or_end", "static_stid_opt", "str_lit", "str_lit_exp", "this_exp",
  "this_stid_opt", "to_exp", "type_opt", "typename_flag_opt", "unused_exp",
  "user_defined", "virtual_stid_exp", "virtual_stid_opt", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    40,
      41,    91,    93,    46,   324,   325,    42,   326,   327,   328,
     329,   330,   331,   332,   333,    47,    37,    45,    43,   334,
     335,   336,   337,   338,   339,    60,    62,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
      61,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,    44,
     371,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,   446,   447,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,   498,   499,   500,
     501,   502,   503,   504,   505,   506,   507,   508,   509,    58,
      59,   123,   125,   510,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   284,   285,   285,   286,   286,   286,   286,   286,   286,
     286,   286,   286,   286,   286,   286,   286,   286,   287,   287,
     288,   288,   288,   288,   288,   289,   290,   289,   289,   289,
     289,   291,   291,   291,   292,   292,   292,   293,   293,   293,
     294,   294,   294,   295,   295,   295,   296,   296,   297,   297,
     298,   298,   298,   298,   299,   299,   299,   300,   301,   301,
     302,   302,   303,   303,   303,   303,   303,   303,   303,   303,
     303,   303,   303,   303,   303,   303,   303,   303,   303,   304,
     305,   305,   305,   305,   305,   305,   305,   305,   305,   305,
     305,   305,   306,   305,   305,   305,   305,   305,   307,   308,
     309,   309,   309,   309,   309,   310,   311,   312,   312,   313,
     313,   314,   315,   315,   315,   316,   316,   316,   316,   316,
     316,   317,   317,   317,   318,   318,   319,   319,   320,   320,
     320,   320,   321,   321,   321,   322,   323,   324,   326,   325,
     325,   328,   327,   329,   329,   329,   329,   331,   332,   330,
     333,   334,   333,   333,   335,   335,   336,   337,   337,   337,
     339,   340,   338,   342,   341,   344,   345,   343,   346,   346,
     346,   347,   347,   347,   347,   348,   348,   348,   348,   349,
     349,   350,   350,   351,   351,   352,   352,   352,   352,   353,
     354,   354,   355,   355,   356,   356,   356,   356,   356,   356,
     357,   357,   358,   359,   358,   360,   362,   361,   364,   365,
     363,   367,   366,   366,   368,   369,   369,   370,   371,   373,
     374,   372,   375,   375,   376,   376,   377,   378,   378,   379,
     379,   379,   379,   379,   380,   380,   381,   381,   381,   381,
     381,   381,   381,   381,   381,   382,   383,   383,   383,   383,
     383,   384,   384,   384,   386,   385,   387,   388,   389,   390,
     392,   391,   394,   393,   395,   395,   396,   396,   396,   396,
     397,   397,   397,   398,   398,   398,   398,   398,   399,   399,
     399,   400,   401,   400,   400,   402,   402,   402,   402,   402,
     403,   403,   404,   404,   405,   405,   407,   406,   406,   406,
     408,   408,   410,   409,   411,   413,   412,   414,   415,   415,
     417,   416,   418,   420,   419,   421,   423,   422,   424,   424,
     425,   427,   426,   428,   429,   429,   430,   430,   430,   430,
     431,   431,   431,   431,   431,   432,   434,   433,   435,   437,
     436,   439,   438,   441,   440,   443,   442,   444,   444,   445,
     445,   445,   445,   447,   446,   449,   448,   451,   450,   452,
     452,   452,   453,   453,   454,   454,   455,   455,   455,   455,
     456,   456,   456,   456,   456,   456,   456,   456,   457,   457,
     458,   458,   458,   458,   460,   459,   461,   461,   462,   462,
     462,   462,   462,   462,   462,   462,   462,   462,   462,   462,
     462,   462,   463,   464,   464,   465,   465,   466,   466,   467,
     467,   468,   469,   469,   469,   470,   470,   470,   471,   471,
     472,   472,   473,   473,   473,   473,   474,   474,   474,   475,
     475,   476,   476,   477,   477,   478,   478,   479,   479,   479,
     480,   480,   480,   480,   480,   480,   480,   481,   481,   482,
     482,   483,   483,   484,   484,   484,   484,   485,   485,   485,
     485,   485,   485,   485,   485,   485,   485,   485,   485,   485,
     485,   485,   485,   485,   485,   485,   485,   486,   486,   487,
     487,   489,   488,   488,   490,   490,   491,   491,   492,   492,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     494,   494,   495,   495,   496,   496,   497,   497,   498,   498,
     500,   499,   501,   501,   502,   502,   503,   503,   504,   504,
     505,   505,   506,   506,   507,   507,   507,   507,   507,   507,
     508,   508,   510,   509,   511,   511,   512,   512,   513,   513,
     513,   514,   514,   515,   515,   516,   517,   517,   517,   518,
     518,   519,   520,   521,   522,   522,   523,   524,   524,   525,
     525,   525,   525,   525,   525,   526,   527,   527,   528,   529,
     529,   530,   530,   531,   531,   532,   532,   532,   533,   533,
     534,   534,   535,   536,   536,   537,   537,   538,   538,   538,
     539,   539,   539,   539,   539,   539,   539,   539,   539,   539,
     539,   539,   539,   539,   540,   540,   540,   540,   540,   540,
     540,   540,   540,   540,   540,   540,   540,   540,   540,   540,
     540,   540,   540,   540,   540,   540,   540,   540,   540,   540,
     540,   540,   541,   541,   541,   542,   543,   543,   544,   544,
     544,   544,   544,   544,   544,   545,   545,   546,   546,   546,
     546,   546,   546,   546,   546,   547,   547,   547,   548,   549,
     549,   550,   551,   551,   551,   552,   552,   553,   553,   554,
     554,   555,   556,   556,   556,   556,   557,   557,   558,   558,
     558,   558,   558,   558,   558,   558,   558,   558,   558,   558,
     558,   558,   558,   558,   559,   559,   559,   559,   560,   560,
     560,   561,   561,   562,   563,   564,   564,   565,   565,   566,
     566,   567,   567,   568,   568,   569,   569,   570,   570,   571,
     571,   572,   572,   573,   573,   574,   574,   575,   576,   576,
     577,   577,   578,   579,   579,   580,   580,   580,   581,   582,
     582,   583,   583,   584,   584,   585,   586,   587,   587,   588,
     588,   589,   589,   590,   590,   590,   591,   591,   592,   592,
     593,   593,   594,   594,   594,   594,   595,   595,   595,   596,
     596,   596,   597,   597,   598,   598,   599,   599,   600,   600,
     601,   601,   602,   602,   603,   603,   604,   604,   604,   604,
     604,   604,   604,   604,   604,   604,   604,   604,   604,   604,
     604,   604,   604,   604,   604,   604,   604,   604,   604,   604,
     604,   604,   604,   604,   604,   604,   604,   604,   604,   604,
     604,   604,   604,   604,   604,   604,   604,   604,   604,   604,
     604,   604,   604,   604,   605,   605,   606,   606,   607,   607,
     608,   608,   609,   609,   610,   610,   611,   611,   612,   613,
     613,   614,   614,   615,   615,   616,   616,   617,   617,   618,
     618,   619,   619,   620,   620,   621,   621,   622,   622,   623,
     623,   623,   624,   624,   625,   625,   626,   626,   627,   628,
     628,   629,   629,   630,   630,   631,   631,   632,   632,   633,
     633,   634,   634,   635,   635,   636,   636,   637,   637,   638,
     638,   639,   639,   640,   640,   641,   641,   641,   642,   642,
     643,   643,   644,   644,   645,   645,   646,   646,   647,   647,
     648,   648,   649,   649,   650,   650,   651,   651,   652,   652,
     653,   653,   654,   654,   655,   655,   656,   656,   657,   657
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     2,     2,
       1,     2,     2,     2,     2,     2,     1,     1,     4,     4,
       2,     2,     2,     2,     1,     4,     0,     6,     6,     9,
       2,     1,     2,     2,     3,     2,     2,     2,     1,     1,
       0,     2,     3,     3,     3,     1,     0,     1,     3,     1,
       2,     2,     3,     1,     0,     2,     1,     3,     0,     2,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     2,     4,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     0,     4,     2,     3,     2,     2,     1,     2,
       0,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     2,     0,     2,     2,     3,     4,     4,     5,     2,
       2,     1,     1,     1,     1,     1,     0,     1,     0,     2,
       1,     1,     0,     1,     1,     1,     1,     1,     0,     6,
       3,     0,     9,     1,     1,     1,     1,     0,     0,     5,
       4,     0,     6,     4,     1,     1,     4,     1,     1,     1,
       0,     0,     5,     0,     4,     0,     0,     5,     1,     1,
       1,     3,     3,     4,     1,     3,     3,     4,     1,     1,
       1,     0,     1,     2,     4,     1,     2,     2,     1,     6,
       0,     1,     3,     1,     1,     2,     1,     1,     1,     2,
       0,     3,     0,     0,     4,     1,     0,     3,     0,     0,
       6,     0,     4,     1,     1,     1,     1,     1,     1,     0,
       0,     8,     0,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     3,     1,     3,     5,     4,
       5,     2,     3,     3,     0,    10,     8,     7,     6,     8,
       0,     7,     0,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     1,     0,     1,     4,     3,     4,     1,     1,
       1,     0,     0,     4,     1,     0,     2,     2,     2,     2,
       1,     1,     0,     1,     3,     1,     0,     4,     1,     1,
       1,     1,     0,     4,    10,     0,     3,     2,     1,     3,
       0,     3,     2,     0,     3,     3,     0,     3,     2,     2,
       1,     0,     9,     9,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     0,     9,     6,     0,
       4,     0,     3,     0,     3,     0,     3,     0,     1,     1,
       1,     1,     1,     0,     3,     0,     3,     0,     3,     1,
       2,     1,     0,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     0,     6,     1,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     4,     4,
       4,     2,     0,     2,     2,     1,     3,     2,     0,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     0,     1,     3,     2,     2,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     0,
       2,     1,     1,     2,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     0,     7,     1,     0,     3,     0,     1,     3,     1,
       1,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       0,     3,     0,     1,     1,     1,     0,     1,     2,     1,
       0,     7,     0,     1,     3,     1,     2,     1,     0,     3,
       0,     1,     3,     1,     1,     1,     1,     1,     3,     1,
       2,     1,     0,     5,     0,     1,     2,     1,     1,     1,
       1,     6,     6,     0,     1,     1,     0,     1,     1,     0,
       1,     3,     2,     2,     0,     2,     5,     1,     1,     1,
       1,     1,     1,     1,     1,     6,     0,     1,     3,     0,
       1,     3,     1,     1,     1,     0,     1,     2,     0,     1,
       2,     2,     2,     0,     1,     2,     1,     1,     1,     1,
       2,     1,     1,     2,     1,     2,     1,     2,     1,     1,
       3,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     7,     3,     3,     1,
       2,     6,     3,     1,     1,     2,     1,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     2,     1,     1,
       2,     2,     1,     1,     3,     4,     4,     2,     1,     2,
       3,     0,     1,     2,     3,     0,     3,     2,     1,     0,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       0,     2,     2,     0,     2,     3,     3,     1,     2,     0,
       2,     1,     1,     0,     1,     2,     2,     1,     1,     0,
       1,     3,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     0,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     0,     1,     1,     0,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     2,     1,     1,     3,     2,
       1,     0,     1,     1,     1,     0,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     0,     1,
       0,     1,     1,     1,     1,     2,     1,     1,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       2,     0,     1,    17,   749,     0,     0,     0,    98,     0,
     105,     0,   107,     0,     0,   432,   930,   434,     0,   429,
       0,   431,   143,   144,   874,   145,   146,   205,   219,   914,
     915,     3,     0,     0,     0,     0,     0,     0,     0,     0,
      10,     0,     0,     0,     0,     0,    24,   106,   157,   158,
     159,   135,   136,   137,   218,   163,   433,   160,   165,    16,
     737,   725,   726,   881,   755,   719,   750,     0,   720,    30,
     814,   802,   806,     0,     0,   810,   808,   799,   833,   791,
     795,   809,   811,   812,   793,   805,   801,   823,   816,   819,
     815,   822,   825,   818,   792,   821,   828,   830,   796,   831,
     820,   832,   829,   824,   817,   813,   807,   803,   800,   797,
     794,   826,   804,   789,   787,   786,   449,   752,     0,    26,
     748,   747,     0,   775,   774,    21,   104,   101,   102,   103,
      99,    22,   112,   108,   110,   120,   132,   130,   131,   119,
     849,   126,    23,   931,   208,    20,   411,   430,   873,   872,
     875,     0,     4,     0,     5,     6,     7,    97,     0,   190,
     435,   457,   392,   399,   464,   398,   397,   372,   377,   373,
     472,   473,   375,     0,   447,   374,   388,   448,   396,   390,
     370,   371,   468,   451,   154,   440,     0,   477,   474,   391,
     462,   467,   469,     0,    92,   476,   394,   395,     0,   403,
     404,     0,   155,   389,   460,   466,   471,   475,   478,   393,
     459,   461,   463,   400,   401,   376,   443,   444,   446,   510,
     452,   458,   532,   737,    80,    81,     0,    83,   147,     0,
      84,    88,    91,    82,    94,    86,    85,    87,    89,    90,
     308,   310,   217,   206,   359,   365,   366,   361,   362,   380,
     381,   386,   383,   402,   449,   405,   406,   479,   479,   367,
     441,   442,   368,   470,   369,   483,   504,   509,   505,   531,
     733,     0,   382,    96,   465,     0,     0,     0,     8,     9,
      11,    12,    13,    14,    15,     0,     0,     0,     0,   880,
     882,   745,     0,   765,   762,   763,   764,   583,     0,   904,
     903,   798,   896,   895,   827,     0,     0,     0,     0,    40,
       0,    75,    70,   598,    66,    69,    71,    76,    77,   602,
     603,     0,   591,    64,    68,    73,    74,   592,   594,     0,
     596,   599,    63,    65,    67,   601,    59,    61,     0,    60,
     761,   760,     0,   583,   881,   583,     0,   111,   109,   133,
     134,   129,   848,   850,   126,     0,   121,   122,   123,   127,
     115,     0,   718,   715,   716,   717,   479,   583,   468,   476,
       0,   138,   465,     0,   194,   196,   198,   197,     0,     0,
     193,   312,   436,   502,     0,   918,   919,   844,   635,   866,
     865,     0,     0,   731,     0,     0,   481,     0,   445,     0,
       0,   260,   868,   867,     0,   930,     0,   730,   730,   222,
     364,   360,   378,   363,   379,     0,   480,     0,   508,   530,
       0,   732,     0,    95,     0,   840,   841,     0,     0,   722,
     721,   412,   161,   170,   174,   166,   168,   169,   178,   909,
     907,   905,   906,   908,     0,   879,   735,   736,     0,     0,
       0,     0,   934,   604,   610,   614,   623,   629,   664,   618,
     638,   626,     0,   611,   612,   617,   619,   624,   628,   630,
     608,   616,   621,   622,   627,   607,   609,   613,   641,   642,
     644,   605,   881,   639,   640,    18,   538,   667,   584,   586,
     587,   588,   589,   539,   540,     0,   663,     0,   754,   753,
     790,   788,   632,   633,   634,    62,   597,    72,   595,     0,
       0,    46,   566,   937,   936,    78,   839,   838,   590,   933,
     932,   593,   450,     0,   751,    25,    31,     0,    79,   114,
     113,     0,   117,   125,   124,   116,   209,     0,    19,   140,
     324,   923,   922,   199,   195,   200,   783,   782,     0,   502,
     439,   503,   438,   845,   921,   920,     0,   384,    93,   858,
     857,     0,   484,     0,   453,     0,     0,     0,     0,   924,
     141,   148,     0,     0,   151,   302,   435,   435,   435,   559,
     560,   561,   562,   563,   564,   309,   225,   226,   229,   236,
     237,   238,   239,   240,   230,   305,   231,   313,   232,   316,
     242,   243,   244,   730,     0,   733,     0,   320,   739,   506,
     311,   207,   223,   721,   412,     0,   407,     0,   734,   321,
     924,     0,     0,     0,   164,   181,     0,     0,     0,   878,
     606,   620,   631,   837,   836,   935,   636,   864,   863,   625,
     646,   645,   643,   746,   916,   566,   554,     0,   576,     0,
     549,   566,   671,   647,   648,   649,   650,   651,   869,   558,
     557,   582,   652,   653,     0,   654,     0,   668,   670,   585,
     583,   862,   861,     0,   757,   756,   600,    45,    46,    46,
      41,    54,    54,     0,     0,    49,    53,   583,   578,   567,
     785,   784,   885,   766,     0,    38,    39,    32,     0,    33,
     583,   118,   730,   843,   842,     0,   339,   341,   343,   345,
       0,   325,   326,   330,   331,   332,   333,   327,   328,   329,
     334,   924,    58,   192,   437,   156,   324,   387,     0,     0,
     456,   455,   454,     0,   517,   518,   537,     0,     0,   299,
     925,   727,     0,     0,   295,   298,     0,   324,     0,   153,
     150,   324,   254,   730,   307,   318,   319,     0,   924,     0,
     506,   246,   730,   730,   730,   233,     0,   234,   235,   739,
     449,     0,     0,   738,   241,   507,   409,   410,   408,   347,
       0,   262,   273,     0,   414,   422,   423,   425,   424,   426,
     428,   413,   415,   421,   418,   427,     0,   162,   182,   180,
     167,   179,     0,   171,   172,     0,   176,   175,   637,   615,
     917,   543,   552,     0,   553,   927,   926,     0,   898,   897,
     577,   550,     0,   578,   870,   871,     0,   583,   701,     0,
       0,     0,   859,   889,   689,   688,   678,   686,   680,   681,
     684,   685,   698,   679,   683,   692,   693,     0,     0,   665,
     672,   676,   677,     0,   673,   674,   675,   669,   662,   583,
       0,     0,     0,    56,    50,     0,    51,    42,     0,   572,
       0,     0,   899,   900,    28,   579,     0,   886,   881,   767,
     768,    37,   769,    36,   772,    35,    27,   575,   210,   213,
     214,   220,   336,   324,   324,   324,   324,   335,   743,   924,
       0,   202,     0,   729,   728,     0,   499,   496,   497,   490,
     500,   492,   500,   494,   495,     0,     0,   489,   498,     0,
       0,   515,   520,   516,   533,   536,   273,     0,   296,     0,
     149,     0,   435,     0,   228,   227,   224,     0,   896,   435,
       0,     0,     0,   251,   245,   306,   314,   317,   315,   892,
     891,     0,     0,   740,   353,   355,   357,     0,   348,   349,
     350,   351,   352,   273,   264,     0,   274,   506,   273,   420,
     418,   417,   419,   188,   183,   185,   912,     0,     0,   173,
     177,   545,   546,   544,   555,   657,     0,   655,   759,   758,
     543,   551,   566,   658,   702,     0,   856,   855,   699,   888,
     887,   690,   777,   776,   687,   860,   682,   890,   691,   705,
     703,   697,     0,     0,   769,     0,    44,    43,   835,   834,
      55,    52,    48,   568,     0,   581,   580,     0,   770,   771,
      57,   773,    34,   576,     0,   869,   211,   324,   435,     0,
     342,   344,   346,   744,   139,     0,   201,     0,   189,   385,
     781,   780,   485,     0,   491,   493,     0,     0,     0,     0,
       0,   526,   525,   524,   527,   529,     0,     0,   523,   285,
     301,   300,   294,   324,   852,   851,     0,   152,   730,   303,
     270,   253,     0,   252,     0,   247,     0,   924,     0,   347,
     347,   347,     0,   506,   263,     0,     0,   258,   506,   416,
     913,     0,   911,   910,   186,   187,   548,   547,     0,   877,
     876,     0,     0,   578,   700,   928,   704,   769,     0,   694,
     578,   574,   573,   571,   902,   901,   583,   577,     0,     0,
     221,   324,   340,   273,   203,     0,   482,   488,   511,   514,
       0,   519,     0,     0,   261,   297,     0,     0,   271,   272,
     273,     0,   249,     0,     0,     0,   354,   356,   358,   273,
     257,   267,   268,   269,   265,   266,     0,   276,   280,   278,
     279,     0,   285,   894,   893,   184,   583,   779,   778,     0,
     583,   556,   929,   709,   696,   695,   661,    29,   884,   883,
     566,   216,   215,   212,     0,   281,   324,   501,   783,   528,
     522,   289,   286,   287,   288,   742,   741,     0,     0,   281,
     250,   248,   270,   291,     0,     0,   285,   277,   275,   256,
     541,   583,   542,   712,   706,     0,   710,   578,     0,     0,
     338,   284,   204,   142,   924,   285,   273,   273,   322,   656,
     881,   713,   707,   714,   711,   565,   924,   282,     0,   259,
     281,   281,     0,   324,   506,   285,   323,   337,   283,   255,
     304
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,    31,    32,    33,    34,   344,   525,   697,   698,
     512,   680,   683,   684,   685,   864,   699,   116,   336,   337,
      35,    36,   394,    37,    38,   130,    39,    40,    41,   133,
     134,   347,    42,   359,   535,   360,   140,   351,    43,    44,
      45,   224,   540,   225,   747,    46,   227,   405,   748,   228,
     751,   229,   230,    47,    48,   286,   625,    49,   285,    50,
     287,   626,   435,   436,   437,   800,   797,   798,   976,   231,
     378,   379,   686,   722,  1048,  1196,    51,   233,   409,    52,
     361,   702,   888,  1129,   889,  1193,   234,    53,    54,   151,
    1037,   611,   585,   586,   936,   587,   765,   588,   589,   897,
     761,   590,   932,   235,   236,   237,   591,   238,   569,   782,
     964,  1094,  1164,  1150,   967,  1171,  1230,  1253,  1144,  1214,
     742,   743,   744,  1073,  1072,   592,   753,   593,   594,   762,
     707,   239,   240,   408,   241,   596,   763,   708,   598,   764,
     709,   600,   601,   779,   602,   710,   711,   712,   713,   714,
    1038,   715,   716,   893,   717,   894,   718,   895,   719,   896,
     957,   958,   959,  1089,   960,  1090,   961,  1091,   243,   412,
     244,   245,   246,   247,   248,   249,   726,   250,   251,   252,
     253,   254,   255,   256,   257,   624,   791,   971,   972,   793,
     794,   146,    56,   258,   381,   382,   259,   260,   338,   261,
     398,   262,   263,   415,   264,   562,   729,   915,   916,   917,
    1054,   550,   265,   774,   266,   267,   399,   919,   920,   736,
     923,  1066,  1067,  1068,   268,   269,   400,   737,   738,   869,
     653,   982,   983,  1108,   822,   654,   655,   656,   814,   657,
     658,   603,   886,   688,   689,   870,   871,  1123,   660,   874,
     875,   486,   487,   488,   489,   490,   491,   505,   387,   809,
     492,   642,   661,   662,   663,   664,   493,   494,   665,   666,
     667,   668,   849,   850,   851,   852,   853,   995,   854,   855,
    1116,  1224,  1225,  1226,  1242,   365,   366,   604,   431,   615,
      64,   745,   905,   606,   272,   421,   608,   720,   773,  1207,
    1044,   121,   496,   122,    67,   118,    68,   676,   990,   343,
     297,   881,  1030,  1032,   125,  1004,  1179,  1052,   927,   692,
     119,  1020,   635,   518,   427,   705,   372,   275,   353,   354,
    1076,   276,   998,   561,  1006,   673,   639,   391,   404,   826,
     150,    58,  1111,   289,   290,   643,  1190,   878,  1001,  1008,
     952,  1175,   304,   820,   876,  1126,   301,   443,   444,  1104,
    1101,    59,   811,   388,   556,   543,   746,   817,  1183,   144,
     521,   497,   515,   277
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -1060
static const yytype_int16 yypact[] =
{
   -1060,  3717, -1060, -1060,   389,  2619,    71,   711, -1060,   127,
   -1060,   711,  -111,  1080,   711, -1060,   -31, -1060,   711,   357,
     115, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060,   407,    71,   407,   407,   407,  1085,   407,   407,
   -1060,   407,   407,   407,   407,   407, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060,   350, -1060,   420, -1060,   609,   435, -1060,
   -1060, -1060, -1060,   119,   118, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060,   473,   483, -1060,  4028, -1060,   204, -1060,
   -1060, -1060,   562, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060,   449,  -111, -1060, -1060,   447, -1060, -1060, -1060,
     290,   415, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060,    59, -1060,   609, -1060, -1060, -1060, -1060,  4269,    45,
     836, -1060, -1060, -1060,   430, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060,   134, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060,    -9, -1060, -1060, -1060,   134, -1060, -1060, -1060,
   -1060, -1060, -1060,   508, -1060,   513, -1060, -1060,   134, -1060,
   -1060,   534, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060,   542, -1060, -1060,
   -1060, -1060, -1060,   569, -1060, -1060,   422, -1060, -1060,   134,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
     522, -1060, -1060, -1060,  4408, -1060, -1060, -1060,  4539, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060,   -65,   -65, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060,   450, -1060,   404, -1060,
     599,   495, -1060,   420,   531,   533,   287,   619, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060,    84,    84,    93,   740, -1060,
     350, -1060,   417, -1060, -1060, -1060, -1060,  3456,   389, -1060,
   -1060, -1060, -1060, -1060, -1060,   118,   118,   669,   363,   431,
      69, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060,    68, -1060, -1060, -1060, -1060, -1060, -1060, -1060,    51,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,    76, -1060,
   -1060, -1060,    71,  3456,   350,  3456,    13, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060,   448,    95, -1060, -1060, -1060, -1060,
   -1060,  4408, -1060, -1060, -1060, -1060,   -65,  3456, -1060, -1060,
     119, -1060, -1060,    75,   461, -1060, -1060, -1060,   670,   135,
   -1060, -1060,   696,   225,   696, -1060, -1060,   476, -1060, -1060,
   -1060,    41,  4408, -1060,  4408,   108, -1060,   106, -1060,   134,
     134, -1060, -1060, -1060,  4408,   -31,  3191,  1677,  1677,   932,
   -1060, -1060, -1060,  4539,   369,    47, -1060,    47, -1060, -1060,
     389, -1060,  4408, -1060,   134, -1060, -1060,   134,    59, -1060,
   -1060,   480, -1060, -1060, -1060, -1060,   681,   686, -1060, -1060,
   -1060, -1060, -1060, -1060,    84, -1060, -1060, -1060,   669,   405,
      69,   438, -1060, -1060, -1060,   430, -1060, -1060, -1060, -1060,
   -1060, -1060,    87, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,   -11,
   -1060, -1060,   618, -1060, -1060, -1060, -1060,  4081,  3919, -1060,
   -1060, -1060, -1060, -1060, -1060,   468, -1060,   446, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,    58,
     137,   678,   687, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060,   185, -1060, -1060,    98,   562, -1060, -1060,
   -1060,    95, -1060, -1060, -1060, -1060, -1060,   240, -1060, -1060,
      22, -1060, -1060, -1060, -1060,   688, -1060, -1060,    45,   225,
   -1060, -1060, -1060, -1060, -1060, -1060,   119, -1060, -1060, -1060,
   -1060,   119,   556,   692, -1060,   118,   118,   134,    73,    36,
   -1060, -1060,   689,   119, -1060,   660,   836,   836,   836, -1060,
   -1060, -1060, -1060, -1060, -1060,   637, -1060, -1060,   646, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060,   499,   701,   656,   577, -1060,    18,   450,
   -1060, -1060,   637,   502,   480,   512, -1060,   514, -1060, -1060,
      36,   709,   134,   827, -1060,   516,    48,   -55,   314, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060,   744, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060,   640,   687,   722,   139,   159,   144,
     753,   687, -1060, -1060, -1060, -1060, -1060, -1060,   541, -1060,
   -1060, -1060, -1060, -1060,   139, -1060,  3769,  3611, -1060, -1060,
    3456, -1060, -1060,   134, -1060, -1060, -1060, -1060,   678,   678,
   -1060,   178,   101,   724,    99, -1060, -1060,  3328,   410, -1060,
   -1060, -1060,   604,   439,   108, -1060, -1060, -1060,  1571, -1060,
    3919, -1060,  1677, -1060, -1060,  4408,   695, -1060, -1060, -1060,
     608, -1060,   732, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060,    36, -1060, -1060, -1060, -1060,    22, -1060,    82,   747,
   -1060, -1060, -1060,    77, -1060,   737, -1060,   739,    78, -1060,
   -1060, -1060,   742,   394, -1060, -1060,  4408,    22,  4408, -1060,
   -1060,    22, -1060,  1677, -1060, -1060, -1060,   806,    36,  1436,
     450, -1060,  1677,  1677,  1677, -1060,   646,   652, -1060,    11,
   -1060,  1305,   108, -1060, -1060,   450, -1060, -1060, -1060,   552,
     709, -1060,   -40,   709, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060,  3606, -1060,   489, -1060,   309, -1060, -1060, -1060,
   -1060, -1060,    82, -1060, -1060,    82, -1060, -1060, -1060, -1060,
   -1060,   369, -1060,   119, -1060, -1060, -1060,  1840, -1060, -1060,
     169, -1060,   474,   410, -1060, -1060,   775,  3456,   766,    85,
     138,   123,   539,   768, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060,    84,    84, -1060,
   -1060, -1060, -1060,    92, -1060, -1060, -1060, -1060, -1060,  3328,
     750,   749,   100, -1060, -1060,    82, -1060, -1060,   678, -1060,
     754,   399, -1060, -1060, -1060, -1060,  2109, -1060,   350, -1060,
   -1060, -1060,   707, -1060,   802, -1060, -1060,   675,   697, -1060,
   -1060, -1060, -1060,    22,    22,    22,    22, -1060,   549,    36,
     761,  4149,   608, -1060, -1060,    62, -1060, -1060, -1060, -1060,
     763, -1060,   763, -1060, -1060,   765,   440, -1060,   420,   769,
     436, -1060,    -5, -1060, -1060, -1060,   -40,  2905, -1060,   117,
   -1060,   608,   836,   119, -1060, -1060, -1060,   709,   770,   836,
     118,   762,  1508, -1060, -1060, -1060, -1060, -1060,   369, -1060,
   -1060,   134,    82, -1060, -1060, -1060, -1060,   134, -1060, -1060,
   -1060, -1060, -1060,   -40, -1060,   134,   771,   450,   -40, -1060,
     489, -1060,   489, -1060, -1060, -1060,   571,    60,    60, -1060,
   -1060, -1060,    32, -1060, -1060, -1060,   429, -1060, -1060, -1060,
     369, -1060,   687, -1060, -1060,    85, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,   801,
   -1060, -1060,   108,   108,   707,   776, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060,  2378, -1060, -1060,    96, -1060, -1060,
   -1060, -1060, -1060, -1060,   144,   541, -1060,    22,   836,   608,
     785,   785,   785,   420, -1060,   709, -1060,  4408, -1060, -1060,
   -1060, -1060, -1060,    41, -1060, -1060,   118,   270,   119,   102,
      -5, -1060, -1060, -1060, -1060, -1060,   787,   457, -1060,   756,
   -1060, -1060, -1060,    22, -1060, -1060,   134, -1060,  1677, -1060,
     103, -1060,   591, -1060,   118, -1060,   597,    36,   134,   552,
     552,   552,   709,   450,   416,  2759,   129, -1060,   450, -1060,
   -1060,    50, -1060, -1060, -1060, -1060, -1060, -1060,   429, -1060,
   -1060,   243,   429,   410, -1060,   725, -1060,   707,   119, -1060,
     410, -1060, -1060, -1060, -1060, -1060,  3456, -1060,   114,   850,
     785,    22, -1060,   -40, -1060,   119, -1060, -1060, -1060, -1060,
     477, -1060,    -5,    66, -1060,   785,   104,   119, -1060, -1060,
     -40,   118, -1060,   118,   709,  3045, -1060, -1060, -1060,   -40,
   -1060, -1060, -1060, -1060, -1060, -1060,   479, -1060, -1060, -1060,
   -1060,   119,   756, -1060, -1060, -1060,  3456, -1060, -1060,    71,
    3456, -1060, -1060,   489, -1060, -1060, -1060, -1060, -1060, -1060,
     687, -1060, -1060, -1060,   608,    -7,    22, -1060,   532, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060,   420,   119,   134,    -7,
   -1060, -1060,   103, -1060,   808,   545,   756, -1060, -1060, -1060,
   -1060,  3456, -1060, -1060, -1060,  3774,  3264,   410,   134,  4408,
   -1060,   450,   785, -1060,    36,   756,   -40,   -40, -1060, -1060,
     350, -1060, -1060, -1060, -1060, -1060,    36, -1060,   810, -1060,
      -7,    -7,   811,    22,   450,   756, -1060, -1060, -1060, -1060,
   -1060
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060,    53, -1060,     8,   201, -1060,   162, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
     752, -1060, -1060,  -223,   358,   537, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060,   851, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060,   107, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060,   266, -1060, -1060,
   -1060, -1060,  -112, -1060, -1060, -1060,   859,  -357, -1060,   109,
   -1060, -1060, -1060, -1060,  -231, -1060, -1060,   110,   624, -1060,
   -1060, -1060,   491,   145, -1060,  -386, -1060,   308, -1060,  -507,
   -1060, -1060, -1060, -1060, -1060, -1060,   312, -1060, -1060,  -703,
   -1060, -1060, -1060,  -300,  -864, -1060, -1059, -1060, -1031, -1060,
    -594,  -958,   -10, -1060, -1060, -1060, -1060, -1060,   313, -1060,
    -354,   760, -1060, -1060, -1060, -1060, -1060,  -228, -1060, -1060,
    -146, -1060,   885, -1060, -1060,  -549, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
    -404, -1060, -1060, -1060, -1060, -1060, -1060, -1060,  -152, -1060,
     677,  -134,  -356,   684, -1060, -1060, -1060,  -406, -1060,  -405,
   -1060, -1060, -1060, -1060,     7,   315, -1060,   -37,   311,  -761,
     143, -1060,   917,     3,  -520,   179,  -124,  -272,  -227,  -256,
   -1060, -1060, -1060,  -136,   284, -1060, -1060, -1060, -1060,  -120,
      27,   391,  -128,  -714,  -597,  -261, -1060, -1060, -1060,  -695,
   -1060, -1060,  -119,  -200, -1060,   679, -1060, -1060, -1060,  -253,
   -1060,   -44, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060,   463, -1060,  -611, -1060,    89, -1060, -1060,    67,  -793,
   -1060, -1060,   258, -1060,   475,  -107, -1060,   518,   506, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060,   306, -1060,  -251, -1060, -1060, -1060, -1060, -1060, -1060,
   -1060, -1060, -1060, -1060, -1060, -1060,   548,    12,  -271,   560,
      -2, -1060,  -367,   941,   -73, -1060,    -4,  -242, -1060, -1060,
   -1060,   729,  -246,   -30, -1060, -1060, -1060, -1060, -1060,  -109,
     831, -1060,  -860, -1060,   630, -1060, -1060, -1060,  -358, -1060,
     218, -1060, -1060, -1060, -1060, -1060,   955, -1060, -1060, -1060,
   -1060, -1060,    -1,  -655, -1060, -1060, -1060,  -179, -1060,   -38,
   -1060,   714,  -401,   705, -1060,   -43, -1060, -1060, -1060, -1060,
   -1060, -1060,  -282,   -25,   -24, -1060,  -342, -1060, -1060,    33,
   -1060,  1016,    72,  -381,   -36, -1060, -1060,   346, -1060,   610,
   -1060,   680,   563, -1060
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -940
static const yytype_int16 yytable[] =
{
      65,    65,    65,   153,    57,   418,   371,   392,    55,   339,
     555,   141,   775,   345,   529,   432,    63,    63,    63,   395,
     291,   548,   610,   500,   501,   483,   780,   414,   539,    65,
     991,   969,   384,   273,   812,   270,   383,   558,   921,   882,
     823,   484,   554,   925,   485,    63,   944,   380,   429,   799,
     406,  1173,   519,   595,   595,   595,   754,   755,   756,   674,
     362,  1102,  1069,  1050,  1060,   640,   522,  1201,  1229,   516,
     513,   483,   120,   483,   734,   292,   541,   963,   734,   734,
     968,   760,   292,   903,  -719,   429,   996,   484,   637,   484,
     526,   706,   528,  1011,   433,   483,   533,  1124,   576,  1093,
     546,  1018,   577,   734,  1098,  1205,  -292,   563,  1106,   559,
     410,   484,   802,   693,   538,  1188,   148,   953,  1074,   302,
     299,   373,   417,   862,  1002,   374,   356,   900,   126,   578,
    1168,   652,   534,   451,   452,   389,   546,  1166,   677,   999,
     815,  1219,   522,  -534,   614,   818,   616,  -512,  -535,   872,
    1235,   201,   127,  1012,  1119,   375,   270,   865,   128,   694,
    -659,  1013,   965,   775,   937,   609,   609,   609,   132,   -47,
    -660,   -47,   129,   629,  -854,   143,  -854,   902,   564,   597,
     597,   597,   565,  1148,  1000,  1238,   690,   966,   759,   300,
     303,  1255,  1256,   219,   739,   816,   819,  1215,   929,   222,
     862,  1202,   931,   390,  1249,   340,   678,  -191,   679,   536,
    1149,   969,   691,  1075,   725,  -659,   483,   789,   790,   727,
     567,   568,   341,   803,  1260,  -660,    61,    62,   547,   997,
     537,   750,   484,   174,  1080,  1019,   863,   740,   177,   941,
     557,   703,   270,   873,  1177,   620,   376,   357,   621,   595,
    1203,   219,   570,  1097,   574,   551,  1003,  1184,   549,   760,
     552,   599,   599,   599,   547,   638,   641,   695,  1061,  1195,
     619,   906,  1062,  1063,  -854,  1064,   542,   514,  1065,   410,
     772,    65,    65,   731,   732,   438,  1209,   772,   520,   517,
     447,   441,   530,   495,   499,  1216,   498,   430,   430,   675,
      60,   527,   358,    61,    62,  1045,   149,  1189,   534,  1107,
     973,   652,   524,   863,   741,   696,   890,  1169,  -723,   796,
    1181,   385,  1174,   377,   386,    60,   868,  1186,    61,    62,
    1103,  1051,  1170,   342,   607,   607,   607,   363,    65,   495,
     364,   495,  1133,  1204,  1039,  1040,  1041,  1042,   595,    60,
     704,   735,    61,    62,    63,   735,   735,  1117,  1118,   270,
     904,   609,    60,   495,  1139,    61,    62,   933,   898,  1014,
     775,   434,  1250,  1251,    61,    62,   945,   946,   947,  1160,
     735,  1113,    60,   566,  1172,   560,   789,   790,   733,  1159,
     270,   930,   270,    15,   288,   546,    17,  -100,   483,   595,
     546,  -100,   270,   595,   270,   605,   605,   605,   595,   595,
     595,    65,  1078,    65,   484,   483,    65,   858,   700,  1082,
     270,   551,  1223,   402,    21,   954,   483,   613,   483,   613,
    1109,   484,   618,   355,  1245,   979,   723,   546,   980,   633,
      65,   546,   484,   783,   484,   885,   356,   671,   384,   384,
     384,  1212,   383,   383,   383,   510,   430,   879,   546,    15,
     609,    16,    17,   872,  -293,  1244,   531,   634,    19,  -570,
     424,   984,   425,  1110,   597,   988,    20,   943,  1198,   356,
     546,   805,   907,   219,   292,   908,   670,   672,  1130,   222,
      21,   989,   909,  1154,   859,   880,   775,   349,  1021,   298,
      24,   775,   511,   910,   350,   911,  -513,    15,   912,   913,
     506,   609,  -487,  1024,   418,   609,    28,   403,  1131,   914,
     609,   609,   609,   547,  1145,   597,   174,  -521,   547,   597,
     607,   177,   292,  -904,   597,   597,   597,   962,    21,   981,
    1259,   416,   416,   948,   305,   483,   546,   300,    60,  1217,
     795,   955,   506,   891,   306,   483,   599,   873,  1057,   346,
    1049,   484,  1059,   340,   987,   547,   352,   357,   575,   547,
     426,   484,   393,   174,   993,   576,  1009,  1010,   177,  1227,
     341,   974,  1194,   824,   825,  1088,   547,   483,   507,  1077,
    -939,  1079,    60,   856,   928,    61,    62,   508,  1231,   769,
     357,   270,  -904,   484,   483,   396,   547,   599,   547,   299,
     293,   599,  1231,   397,   509,  -290,   599,   599,   599,   619,
     484,   270,   358,  1026,   807,   804,   806,   294,   576,   607,
     631,   384,   577,   956,   785,   383,  -737,   786,   401,   508,
    1248,   131,  1161,   787,   142,  1162,   295,  1232,   145,   788,
     416,   407,  1252,  1231,  1231,   358,   509,   775,  1083,   578,
    1085,  -904,   288,   420,   270,   296,   495,    60,   222,   848,
      61,    62,   555,   847,   547,  1163,   522,    29,   300,   759,
     607,    30,  -737,   495,   607,  1156,  1157,  1158,   422,   607,
     607,   607,  1147,   193,   495,   446,   428,  1132,    61,    62,
     605,   502,   503,   270,  1258,   504,   681,  1176,   219,  1142,
     385,  1180,   123,   386,   124,   758,  1138,   759,   981,   795,
     420,  -238,  -755,  -238,   595,   918,  1028,  1033,  1029,  1034,
     682,   860,   861,    66,   117,   954,   954,   954,  -847,   544,
      28,   439,   545,   890,   270,   627,   270,   553,   906,   623,
     628,   605,   483,  1167,   373,   605,   687,   721,   374,   749,
     605,   605,   605,   728,   730,   752,   757,   770,   484,   270,
     771,  1122,  1087,  -724,  1136,   595,  1185,    60,  1092,   781,
      61,    62,  1142,   777,   808,   778,  1095,   796,   375,   810,
     270,   813,   821,  1197,   339,   440,   867,   877,  1199,    57,
     892,   899,  1152,    55,   384,  1208,   922,   934,   383,   924,
     992,   384,   926,   495,   994,   383,  1005,  1007,   549,  -486,
    1016,  1017,  1165,   495,  1023,  1031,  1036,    60,   784,  1218,
      60,  1046,  1053,    61,    62,  1027,   609,  1056,  1084,  1058,
    1096,  1100,  1081,    65,    65,  1115,  1120,   962,   962,   962,
     597,  1191,  1228,   174,   483,   495,   759,  1141,   177,   430,
     430,   955,   955,   955,   183,  1233,  1143,   185,  1151,  1210,
     484,  1211,   495,  1187,  1153,   575,  1022,  1182,  1237,   376,
    1254,  1257,   576,   866,   901,   348,   577,   609,   226,   701,
      15,   532,   801,    17,  1043,  1134,   232,  1146,  1192,   423,
     612,   597,   935,   975,   483,   977,   978,    20,   483,  1155,
     384,   766,  1236,   578,   383,   767,   768,  1071,   370,   575,
     484,    21,   242,  1220,   484,   413,   576,  1222,   411,   776,
     577,    24,   599,  1099,   792,   970,   147,  1137,   942,  1055,
     724,  1140,  1200,   956,   956,   956,  1112,   419,  1015,   483,
     659,   216,   217,   218,  1035,   220,   377,   578,   887,   907,
     162,   636,   908,   669,   163,   484,   630,   165,  1239,   909,
     418,   166,   785,   857,  1241,   786,   622,   617,   271,  1243,
     910,   787,   911,   599,   367,   912,   913,   788,   176,   951,
     178,   179,   274,   174,  1114,   445,   914,  1128,   177,  -730,
     193,   575,   442,  1125,   183,   607,   189,   185,   576,  1127,
     827,  1105,   577,   632,  1086,   571,     0,  1135,   523,     0,
     495,     0,     0,     0,     0,    60,     0,     0,     0,  1234,
       0,     0,     0,     0,     0,     0,   196,   197,   198,   578,
     199,   200,     0,  -730,   193,   270,   203,     0,   152,  1246,
     154,   155,   156,   918,   278,   279,   607,   280,   281,   282,
     283,   284,     0,     0,     0,     0,     0,   209,   579,   580,
       0,   581,   582,   583,   584,     0,   605,  1247,     0,   213,
     214,   135,     0,     0,    60,     0,   157,    61,    62,     0,
       0,   216,   217,   218,   219,   220,   136,     0,  -128,     0,
     222,     0,     0,     0,     0,     0,     0,     0,    61,    62,
       0,  -128,   579,   580,  1178,   581,   582,   583,   584,     0,
       0,     0,   495,     0,     0,  -730,   193,   605,    60,     0,
     137,    61,    62,     0,     0,     0,     0,   138,     0,     0,
       0,     0,  1206,     0,     0,     0,     0,     0,     0,  1221,
       0,     0,     0,     0,   158,     0,   159,     0,     0,     0,
       0,   160,  -938,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   495,     0,     0,    65,   495,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    63,     0,     0,   579,   580,     0,   581,   582,   583,
     584,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      60,     0,     0,    61,    62,   161,     0,   495,   162,     0,
       0,     0,   163,     0,   164,   165,     0,   270,     0,   166,
     167,   168,  -128,   169,   170,    15,     0,   171,    17,   172,
       0,   173,   174,     0,    19,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
       0,   188,     0,     0,   189,     0,    21,    22,  -853,     0,
    -853,    23,   190,     0,   191,   192,     0,     0,  -730,   193,
       0,     0,     0,    25,    26,    27,     0,  -128,     0,     0,
       0,   194,  -846,   195,   196,   197,   198,     0,   199,   200,
       0,   201,   202,     0,   203,     0,   949,     0,   204,     0,
       0,   205,     0,     0,   206,     0,     0,   207,     0,     0,
       0,     0,     0,     0,   208,   209,     0,     0,   210,   211,
       0,     0,     0,   212,     0,     0,     0,   213,   214,   215,
     216,   217,   218,   219,   220,   221,     0,     0,     0,   222,
    -128,     0,     0,     0,  -128,     0,  -128,     0,   139,     0,
       0,    61,    62,   223,     0,     0,    61,    62,  -853,    70,
       0,     0,    71,    72,    73,     0,    74,     0,    75,     0,
      76,    77,    78,     0,    79,    80,     0,     0,    81,    82,
      83,    84,    85,    86,     0,     0,    87,    88,     0,    89,
      90,    91,     0,     0,    92,    93,     0,    94,    95,     0,
      96,    97,    98,    99,     0,   100,     0,     0,     0,     0,
       0,     0,     0,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   161,     0,   938,   162,     0,
       0,     0,   163,     0,   164,   165,     0,     0,     0,   166,
     167,   168,     0,   169,   170,    15,     0,   171,    17,   172,
       0,     0,   174,     0,    19,   175,   176,   177,   178,   179,
     180,   181,   368,   183,     0,     0,   185,   186,     0,   187,
       0,   188,     0,     0,   189,     0,    21,     0,     0,   113,
       0,     0,   190,     0,   191,   192,     0,   114,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   303,   302,
       0,     0,  -435,   369,   196,   197,   198,     0,   199,   200,
       0,   201,     0,     0,   203,     0,     0,     0,   204,     0,
       0,   205,     0,     0,   206,   950,     0,   207,     0,     0,
       0,     0,     0,     0,   208,   209,     0,     0,   210,   211,
     115,     0,     0,   212,     0,     0,     0,   213,   214,   215,
     216,   217,   218,   219,   220,   221,     0,     0,     0,   222,
       0,     0,   883,     0,     0,   448,     0,     0,     0,     0,
     303,   449,     0,     0,  -436,   939,    61,    62,  -583,     0,
    -583,  -583,     0,   174,     0,     0,     0,  -583,   177,     0,
       0,  -583,     0,     0,   183,  -583,  -583,   185,     0,     0,
       0,     0,     0,  -583,  -583,     0,     0,     0,  -583,     0,
       0,     0,   450,  -583,     0,  -583,     0,     0,   451,   452,
    -583,  -583,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   810,     0,     0,
       0,     0,     0,     0,     0,   174,     0,     0,     0,     0,
     177,     0,     0,     0,     0,     0,   183,     0,     0,   185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   216,   217,   218,   219,   220,     0,     0,     0,     0,
     222,   453,     0,     0,  -583,     0,   454,     0,  -583,     0,
     455,  -583,     0,   940,     0,  -583,  -583,  -583,     0,  -583,
     456,  -583,     0,   457,  -583,  -583,     0,     0,   174,   458,
    -583,  -583,  -583,   177,  -583,  -583,  -583,  -583,   459,   183,
       0,     0,   460,     0,     0,   313,   575,   461,   462,     0,
    -583,     0,  -583,   576,     0,   463,     0,   577,   464,     0,
     465,   466,     0,   216,   217,   218,     0,   220,     0,     0,
       0,     0,   467,   468,     0,     0,     0,     0,     0,   469,
    -583,  -583,  -583,   319,   578,  -916,   320,     0,     0,     0,
    -583,   321,     0,   322,   470,     0,     0,   471,   472,     0,
     473,     0,     0,   474,   327,     0,   328,   329,     0,   330,
     331,  -583,     0,     0,   475,   476,     0,     0,     0,   477,
     335,     0,     0,  -583,  -583,  -583,   478,   479,   480,     0,
     220,   481,  -583,  -583,  -583,     0,  -583,  -583,  -583,  -583,
       0,   985,     0,     0,   448,     0,     0,     0,   884,   482,
     449,     0,  -583,  -583,     0,     0,     0,  -583,     0,  -583,
    -583,     0,     0,     0,     0,     0,  -583,     0,     0,     0,
    -583,   193,     0,     0,  -583,  -583,     0,     0,     0,     0,
       0,     0,   986,  -583,     0,     0,     0,  -583,     0,     0,
       0,   450,  -583,     0,  -583,     0,     0,   451,   452,  -583,
    -583,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   579,
     580,     0,   581,   582,   583,   584,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    60,     0,     0,    61,    62,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     453,     0,     0,  -583,     0,   454,     0,  -583,     0,   455,
    -583,     0,     0,     0,  -583,  -583,  -583,     0,  -583,   456,
    -583,     0,   457,  -583,  -583,     0,     0,   174,   458,  -583,
    -583,  -583,   177,  -583,  -583,  -583,  -583,   459,   183,     0,
       0,   460,     0,     0,   313,     0,   461,   462,     0,  -583,
       0,  -583,     0,     0,   463,     0,     0,   464,     0,   465,
     466,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   467,   468,     0,     0,     0,     0,     0,   469,  -583,
    -583,  -583,   319,     0,     0,   320,     0,     0,     0,  -583,
     321,     0,   322,   470,     0,     0,   471,   472,     0,   473,
       0,     0,   474,   327,     0,   328,   329,     0,   330,   331,
    -583,     0,     0,   475,   476,     0,     0,     0,   477,   335,
       0,     0,  -583,  -583,  -583,   478,   479,   480,     0,   220,
     481,  -583,  -583,  -583,     0,  -583,  -583,  -583,  -583,     0,
    1025,     0,     0,   448,     0,     0,     0,     0,   482,   449,
       0,  -583,  -583,     0,     0,     0,  -583,     0,  -583,  -583,
       0,     0,     0,     0,     0,  -583,     0,     0,     0,  -583,
       0,     0,     0,  -583,  -583,     0,     0,     0,     0,     0,
       0,  -583,  -583,     0,     0,     0,  -583,     0,     0,     0,
     450,  -583,     0,  -583,     0,     0,   451,   452,  -583,  -583,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   453,
       0,     0,  -583,     0,   454,     0,  -583,     0,   455,  -583,
       0,     0,     0,  -583,  -583,  -583,     0,  -583,   456,  -583,
       0,   457,  -583,  -583,     0,     0,   174,   458,  -583,  -583,
    -583,   177,  -583,  -583,  -583,  -583,   459,   183,     0,     0,
     460,     0,     0,   313,     0,   461,   462,     0,  -583,     0,
    -583,     0,     0,   463,     0,     0,   464,     0,   465,   466,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     467,   468,     0,     0,     0,     0,     0,   469,  -583,  -583,
    -583,   319,     0,     0,   320,     0,     0,     0,  -583,   321,
       0,   322,   470,     0,     0,   471,   472,     0,   473,     0,
       0,   474,   327,     0,   328,   329,     0,   330,   331,  -583,
       0,     0,   475,   476,     0,     0,     0,   477,   335,     0,
       0,  -583,  -583,  -583,   478,   479,   480,     0,   220,   481,
    -583,  -583,  -583,     0,  -583,  -583,  -583,  -583,     0,  1121,
       0,     0,   448,     0,     0,     0,     0,   482,   449,     0,
    -583,  -583,     0,     0,     0,  -583,     0,  -583,  -583,     0,
       0,     0,     0,     0,  -583,     0,     0,     0,  -583,     0,
       0,     0,  -583,  -583,     0,     0,     0,     0,     0,     0,
    -583,  -583,     0,     0,     0,  -583,     0,     0,     0,   450,
    -583,     0,  -583,     0,     0,   451,   452,  -583,  -583,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   453,     0,
       0,  -583,     0,   454,     0,  -583,     0,   455,  -583,     0,
       0,     0,  -583,  -583,  -583,     0,  -583,   456,  -583,     0,
     457,  -583,  -583,     0,     0,   174,   458,  -583,  -583,  -583,
     177,  -583,  -583,  -583,  -583,   459,   183,     0,     0,   460,
       0,     0,   313,     0,   461,   462,     0,  -583,     0,  -583,
       0,     0,   463,     0,     0,   464,     0,   465,   466,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   467,
     468,     0,     0,     0,     0,     0,   469,  -583,  -583,  -583,
     319,     0,     0,   320,     0,     0,     0,  -583,   321,     0,
     322,   470,     0,     0,   471,   472,     0,   473,     0,     0,
     474,   327,     0,   328,   329,     0,   330,   331,  -583,     0,
      69,   475,   476,   -58,     0,     0,   477,   335,     0,   -58,
    -583,  -583,  -583,   478,   479,   480,     0,   220,   481,  -583,
    -583,  -583,     0,  -583,  -583,  -583,  -583,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   482,   -58,     0,  -583,
    -583,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     -58,     0,     0,     0,     0,     0,   -58,   -58,     0,     0,
       0,     0,     0,    70,     0,     0,    71,    72,    73,     0,
      74,     0,    75,     0,    76,    77,    78,     0,    79,    80,
       0,     0,    81,    82,    83,    84,    85,    86,     0,     0,
      87,    88,     0,    89,    90,    91,     0,     0,    92,    93,
       0,    94,    95,     0,    96,    97,    98,    99,     0,   100,
       0,     0,     0,     0,     0,     0,     0,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     299,     0,     0,     0,     0,     0,     0,     0,   -58,     0,
       0,     0,     0,     0,     0,     0,   -58,     0,     0,     0,
       0,   -58,     0,     0,     0,     0,   -58,     0,     0,     0,
       0,     0,     0,   -58,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   113,     0,     0,   -58,     0,   -58,   -58,
       0,   114,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   -58,     0,     0,     0,     0,     0,   -58,     0,   300,
       0,   -58,     0,     0,   -58,     0,     0,     0,     0,   -58,
       0,   -58,   -58,     0,     0,   -58,   -58,     0,   -58,     0,
       0,     0,   -58,     0,   -58,   -58,     0,   -58,   -58,     0,
       0,     0,   -58,   -58,   115,     0,     0,   -58,   -58,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -924,
       0,     0,  -924,     0,     0,     0,  -924,    60,  -924,  -924,
      61,    62,     0,  -924,  -924,  -924,  1070,  -924,  -924,  -924,
       0,  -924,  -924,  -924,     0,     0,  -924,   739,  -924,  -924,
    -924,  -924,  -924,  -924,  -924,  -924,  -924,  -924,     0,     0,
    -924,  -924,     0,  -924,     0,  -924,     0,     0,  -924,     0,
    -924,     0,     0,     0,     0,     0,  -924,     0,  -924,  -924,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     740,     0,     0,     0,     0,     0,     0,  -924,  -924,  -924,
    -924,     0,  -924,  -924,     0,  -924,     0,     0,  -924,     0,
       0,     0,  -924,     0,     0,  -924,     0,     0,  -924,     0,
       0,  -924,     0,     0,     0,     0,     0,     0,  -924,  -924,
       0,     0,  -924,  -924,     0,     0,     0,  -924,     0,     0,
       0,  -924,  -924,  -924,  -924,  -924,  -924,  -924,  -924,  -924,
       0,     0,     0,  -924,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -924,     0,   741,  -924,     0,
    -924,  -924,  -924,     0,  -924,  -924,  1213,     0,     0,  -924,
    -924,  -924,     0,  -924,  -924,  -924,     0,  -924,  -924,  -924,
       0,     0,  -924,   739,  -924,  -924,  -924,  -924,  -924,  -924,
    -924,  -924,  -924,  -924,     0,     0,  -924,  -924,     0,  -924,
       0,  -924,     0,     0,  -924,     0,  -924,     0,     0,     0,
       0,     0,  -924,     0,  -924,  -924,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   740,     0,     0,     0,
       0,     0,     0,  -924,  -924,  -924,  -924,     0,  -924,  -924,
       0,  -924,     0,     0,  -924,     0,     0,     0,  -924,     0,
       0,  -924,     0,     0,  -924,     0,     0,  -924,     0,     0,
       0,     0,     0,     0,  -924,  -924,     0,     0,  -924,  -924,
       0,     0,     0,  -924,     0,     0,     0,  -924,  -924,  -924,
    -924,  -924,  -924,  -924,  -924,  -924,     0,     0,     0,  -924,
       0,     0,     0,     0,     0,  -924,     0,     0,  -924,     0,
       0,     0,  -924,   741,  -924,  -924,  -924,  -924,     0,  -924,
    -924,  -924,   572,  -924,  -924,  -924,     0,  -924,  -924,  -924,
       0,     0,  -924,   739,  -924,  -924,  -924,  -924,  -924,  -924,
    -924,  -924,  -924,  -924,     0,     0,  -924,  -924,     0,  -924,
       0,  -924,     0,     0,  -924,     0,  -924,     0,     0,     0,
       0,     0,  -924,     0,  -924,  -924,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   740,     0,     0,     0,
       0,     0,     0,  -924,  -924,  -924,  -924,     0,  -924,  -924,
       0,  -924,     0,     0,  -924,  -708,     0,     0,  -924,     0,
       0,  -924,     0,     0,  -924,     0,     0,  -924,     0,  -708,
       0,     0,     0,     0,  -924,  -924,     0,     0,  -924,  -924,
       0,     0,     0,  -924,     0,     0,     0,  -924,  -924,  -924,
    -924,  -924,  -924,  -924,  -924,  -924,     0,     0,     0,  -924,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   161,     0,   741,   162,  -708,  -924,  -924,   163,     0,
     164,   165,   448,     0,  -708,   166,   167,   168,   449,   169,
     170,    15,     0,   171,    17,   172,     0,     0,   174,     0,
      19,   175,   176,   177,   178,   179,   180,   181,   368,   183,
       0,     0,   185,   186,     0,   187,     0,   188,     0,     0,
     189,     0,    21,     0,     0,     0,     0,     0,   190,   450,
     191,   192,     0,     0,     0,   451,   452,     0,     0,     0,
       0,     0,     0,  -708,     0,     0,     0,     0,  -569,   369,
     196,   197,   198,     0,   199,   200,     0,   201,     0,   785,
     203,     0,   786,     0,   204,     0,     0,   205,   787,     0,
     206,     0,     0,   207,   788,     0,     0,     0,     0,     0,
     208,   209,     0,  -708,   210,   211,     0,     0,     0,   212,
       0,     0,     0,   213,   214,   215,   216,   217,   218,   219,
     220,   221,     0,     0,     0,   222,     0,     0,   453,     0,
     448,     0,     0,   454,     0,     0,   449,   455,   573,     0,
       0,     0,    61,    62,     0,     0,     0,   456,     0,     0,
     457,  -708,     0,     0,     0,   174,   458,     0,     0,     0,
     177,     0,     0,     0,     0,   459,   183,     0,     0,   460,
       0,     0,   313,     0,   461,   462,     0,   450,     0,     0,
       0,     0,   463,   451,   452,   464,     0,   465,   466,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   467,
     468,     0,     0,     0,  -708,     0,   469,     0,  -708,     0,
     319,     0,     0,   320,     0,     0,     0,     0,   321,     0,
     322,   470,     0,     0,   471,   472,     0,   473,     0,     0,
     474,   327,     0,   328,   329,     0,   330,   331,     0,     0,
       0,   475,   476,     0,     0,     0,   477,   335,     0,     0,
       0,     0,     0,   478,   479,   480,   453,   220,   481,     0,
       0,   454,     0,     0,     0,   455,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   456,   482,     0,   457,     0,
       0,     0,  -666,   174,   458,     0,     0,     0,   177,     0,
       0,     0,     0,   459,   183,     0,  -666,   460,     0,     0,
     313,     0,   461,   462,     0,     0,     0,     0,     0,     0,
     463,     0,     0,   464,     0,   465,   466,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   467,   468,     0,
       0,     0,     0,     0,   469,     0,     0,     0,   319,     0,
       0,   320,  -666,     0,     0,     0,   321,     0,   322,   470,
       0,  -666,   471,   472,     0,   473,     0,     0,   474,   327,
       0,   328,   329,     0,   330,   331,     0,     0,     0,   475,
     476,     0,     0,     0,   477,   335,     0,     0,     0,     0,
       0,   478,   479,   480,     0,   220,   481,     2,     3,     0,
       4,     0,     5,     6,     7,     8,     9,     0,    10,    11,
      12,    13,     0,     0,   482,     0,     0,     0,     0,   162,
    -666,     0,     0,   163,     0,     0,   165,     0,     0,     0,
     166,   785,     0,     0,   786,     0,   167,   168,     0,   169,
     787,     0,     0,     0,     0,   172,   788,   176,     0,   178,
     179,   175,     0,     0,     0,     0,   180,   181,     0,     0,
    -666,     0,     0,     0,     0,   189,     0,     0,   828,   829,
       0,     0,     0,   828,   829,     0,     0,     0,     0,     0,
       0,     0,     0,   830,     0,     0,     0,     0,   830,     0,
       0,     0,     0,     0,     0,   196,   197,   198,     0,   199,
     200,     0,     0,     0,     0,   203,     0,     0,  -666,   831,
       0,     0,     0,     0,   831,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   213,   214,
       0,     0,     0,     0,     0,   215,    14,    15,     0,    16,
      17,     0,     0,     0,    18,     0,    19,     0,     0,     0,
       0,  -666,     0,     0,    20,  -666,     0,    61,    62,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    21,    22,
       0,     0,   832,    23,     0,     0,   833,   832,    24,   834,
       0,   833,     0,   835,   834,    25,    26,    27,   835,    15,
       0,     0,    17,   448,    28,     0,     0,     0,    19,   449,
     836,     0,   837,   838,     0,   836,     0,   837,   838,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   839,     0,
      21,     0,     0,   839,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     450,     0,     0,     0,     0,     0,     0,     0,   840,   841,
     842,     0,     0,   840,   841,   842,     0,    29,   843,     0,
       0,    30,     0,   843,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   844,
       0,     0,     0,     0,   844,     0,     0,     0,     0,     0,
       0,   845,   846,     0,     0,     0,   845,   846,     0,     0,
       0,     0,   307,     0,     0,     0,     0,     0,   308,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   453,
      61,    62,  1240,     0,   454,     0,     0,     0,   455,     0,
       0,     0,     0,     0,     0,     0,   309,     0,   456,     0,
       0,   457,     0,     0,     0,     0,   174,     0,     0,   310,
       0,   177,     0,     0,     0,     0,   459,   183,     0,     0,
     460,     0,     0,   313,     0,   461,   462,     0,   644,     0,
       0,     0,     0,   463,     0,     0,   464,   645,   465,   466,
       0,   646,     0,     0,     0,     0,  -575,     0,     0,     0,
     467,   468,     0,  -575,  -575,     0,     0,   469,   647,     0,
       0,   319,     0,   648,   320,   649,     0,     0,     0,   321,
     650,   322,   470,     0,     0,   471,   472,     0,   473,     0,
       0,   474,   327,   307,   328,   329,     0,   330,   331,   308,
       0,     0,   475,   476,     0,     0,     0,   477,   335,     0,
       0,     0,     0,     0,   478,   479,   480,   311,   220,   481,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   312,     0,     0,     0,     0,
     310,     0,   313,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   314,     0,   315,   316,     0,
       0,     0,     0,     0,  1047,     0,   167,   168,     0,   169,
     317,     0,     0,     0,     0,   172,   318,     0,     0,     0,
     319,   175,     0,   320,     0,     0,   180,   181,   321,     0,
     322,   323,     0,     0,   324,   325,     0,   326,     0,     0,
       0,   327,     0,   328,   329,     0,   330,   331,     0,     0,
       0,   332,   333,     0,     0,     0,   334,   335,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,     0,     0,     0,
       0,     0,     0,   313,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,   314,     0,   315,   316,
       0,     0,   651,   579,   580,   160,   581,   582,   583,   584,
       0,   317,     0,     0,     0,     0,     0,   318,     0,     0,
       0,   319,     0,     0,   320,     0,     0,     0,     0,   321,
       0,   322,   323,     0,     0,   324,   325,     0,   326,     0,
       0,     0,   327,     0,   328,   329,     0,   330,   331,     0,
       0,     0,   332,   333,     0,     0,     0,   334,   335,   161,
       0,     0,   162,     0,     0,     0,   163,     0,   164,   165,
       0,     0,     0,   166,   167,   168,     0,   169,   170,    15,
       0,   171,    17,   172,     0,     0,   174,     0,    19,   175,
     176,   177,   178,   179,   180,   181,   368,   183,     0,     0,
     185,   186,     0,   187,     0,   188,     0,     0,   189,     0,
      21,     0,     0,     0,     0,     0,   190,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   369,   196,   197,
     198,     0,   199,   200,     0,   201,     0,     0,   203,     0,
       0,     0,   204,     0,     0,   205,     0,     0,   206,     0,
       0,   207,     0,     0,     0,     0,     0,     0,   208,   209,
       0,     0,   210,   211,     0,     0,     0,   212,     0,     0,
       0,   213,   214,   215,   216,   217,   218,   219,   220,   221,
       0,     0,     0,   222,     0,     0,     0,     0,   161,     0,
       0,   162,     0,     0,     0,   163,     0,   164,   165,     0,
      61,    62,   166,   167,   168,     0,   169,   170,    15,     0,
     171,    17,   172,     0,     0,   174,     0,    19,   175,   176,
     177,   178,   179,   180,   181,   368,   183,     0,     0,   185,
     186,     0,   187,     0,   188,     0,     0,   189,     0,    21,
       0,     0,     0,     0,     0,   190,     0,   191,   192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   369,   196,   197,   198,
       0,   199,   200,     0,   201,     0,     0,   203,     0,     0,
       0,   204,     0,     0,   205,     0,     0,   206,     0,     0,
     207,     0,     0,     0,     0,     0,     0,   208,   209,     0,
       0,   210,   211,     0,     0,     0,   212,     0,     0,     0,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   161,
       0,     0,   222,     0,     0,     0,     0,     0,   164,     0,
       0,     0,     0,     0,   167,   168,     0,   169,   170,    61,
      62,   171,     0,   172,     0,     0,   174,     0,     0,   175,
       0,   177,     0,     0,   180,   181,   368,   183,     0,     0,
     185,     0,     0,   187,     0,   188,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   190,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   369,     0,     0,
       0,     0,     0,     0,     0,   201,     0,     0,     0,     0,
       0,     0,   204,     0,     0,   205,     0,     0,   206,     0,
       0,   207,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,   210,   211,     0,     0,     0,   212,     0,     0,
       0,     0,     0,   215,   216,   217,   218,   219,   220,   221,
       0,     0,     0,   222
};

static const yytype_int16 yycheck[] =
{
       4,     5,     6,    33,     1,   266,   158,   186,     1,   116,
     391,    13,   609,   122,     1,   286,     4,     5,     6,   198,
      63,   379,   408,   305,   306,   297,   620,   254,   370,    33,
     823,   792,   160,    37,   645,    37,   160,   394,   733,   694,
     651,   297,     1,   738,   297,    33,   760,   159,     1,     1,
     229,     1,     1,   407,   408,   409,   576,   577,   578,     1,
       1,     1,   926,     1,    69,    76,   338,     1,    75,     1,
       1,   343,     1,   345,     1,    64,     1,   780,     1,     1,
     783,   588,    64,     1,    66,     1,     1,   343,     1,   345,
     343,    69,   345,     1,     1,   367,     1,     1,    76,   963,
       1,     1,    80,     1,   968,     1,    70,     1,    76,     1,
     244,   367,   167,    15,   367,     1,     1,   772,     1,     1,
       1,    76,   258,    22,     1,    80,    31,   721,     1,   107,
       1,   487,   355,    57,    58,     1,     1,  1095,     1,     1,
       1,  1172,   414,    70,   415,     1,   417,    70,    70,    53,
    1209,   216,    25,    61,  1014,   110,   158,    56,    31,    61,
       1,    69,   202,   760,   758,   407,   408,   409,   279,    70,
       1,    72,    45,   444,   183,   206,   185,   726,    72,   407,
     408,   409,    76,    80,    46,  1216,     1,   227,    71,    70,
      72,  1250,  1251,   258,   158,    56,    52,  1155,   747,   264,
      22,   135,   751,    69,  1235,     1,    69,    72,    71,   361,
     107,   972,    27,    96,   556,    56,   488,   623,   623,   561,
     399,   400,    18,   278,  1255,    56,   281,   282,   129,   144,
     366,   573,   488,   157,   937,   135,   135,   201,   162,   759,
     392,     1,   244,   147,     1,   424,   201,   152,   427,   603,
     184,   258,   404,   967,   406,   383,   133,  1117,   382,   766,
     384,   407,   408,   409,   129,   178,   277,   169,   273,  1133,
     422,     1,   277,   278,   283,   280,   201,   208,   283,   413,
     269,   285,   286,   565,   566,   287,  1150,   269,   237,   221,
     292,   288,   279,   297,   298,  1159,   298,   285,   286,   241,
     278,   344,   207,   281,   282,   899,   191,   193,   531,   277,
       1,   667,   342,   135,   278,   217,   702,   188,   271,   271,
    1113,   280,   272,   278,   283,   278,   684,  1120,   281,   282,
     270,   269,   203,   129,   407,   408,   409,   278,   342,   343,
     281,   345,  1045,   277,   893,   894,   895,   896,   702,   278,
     110,   278,   281,   282,   342,   278,   278,  1012,  1013,   361,
     278,   603,   278,   367,  1059,   281,   282,   753,   710,   277,
     967,   278,  1236,  1237,   281,   282,   762,   763,   764,  1093,
     278,   992,   278,   277,  1098,   277,   792,   792,   567,  1092,
     392,   748,   394,   150,    44,     1,   153,   270,   670,   753,
       1,   274,   404,   757,   406,   407,   408,   409,   762,   763,
     764,   415,   932,   417,   670,   687,   420,   670,   527,   939,
     422,   549,  1183,     1,   181,   779,   698,   415,   700,   417,
       1,   687,   420,    18,  1227,   802,   548,     1,   805,     1,
     444,     1,   698,   622,   700,   698,    31,     1,   576,   577,
     578,  1154,   576,   577,   578,    24,   444,    18,     1,   150,
     702,   152,   153,    53,    70,  1226,    18,    29,   159,    70,
     183,   813,   185,    44,   702,     1,   167,   759,     1,    31,
       1,   167,   212,   258,    64,   215,    18,    41,  1037,   264,
     181,    17,   222,  1087,   673,    56,  1093,    50,   865,    64,
     191,  1098,    71,   233,    57,   235,    70,   150,   238,   239,
     147,   753,    72,   871,   775,   757,   207,    95,  1038,   249,
     762,   763,   764,   129,  1073,   753,   157,    70,   129,   757,
     603,   162,    64,     1,   762,   763,   764,   779,   181,   811,
    1254,   257,   258,   770,    71,   817,     1,    70,   278,    70,
     623,   779,   147,   705,    71,   827,   702,   147,   916,   110,
     902,   817,   920,     1,   817,   129,   276,   152,    69,   129,
     283,   827,    64,   157,   827,    76,   847,   848,   162,  1190,
      18,   272,  1131,    42,    43,   952,   129,   859,   225,   931,
      77,   933,   278,   666,   746,   281,   282,   234,  1195,   603,
     152,   603,    70,   859,   876,    71,   129,   753,   129,     1,
       1,   757,  1209,    71,   251,    70,   762,   763,   764,   771,
     876,   623,   207,   876,   628,   627,   628,    18,    76,   702,
     225,   759,    80,   779,   145,   759,    18,   148,    69,   234,
    1234,    11,   226,   154,    14,   229,    37,  1196,    18,   160,
     366,   129,  1246,  1250,  1251,   207,   251,  1254,   940,   107,
     942,   129,    44,    64,   666,    56,   670,   278,   264,   666,
     281,   282,  1053,   666,   129,   259,   948,   270,    70,    71,
     753,   274,    64,   687,   757,  1089,  1090,  1091,   193,   762,
     763,   764,  1078,   194,   698,   278,    77,  1039,   281,   282,
     702,    32,    33,   705,  1253,    36,    28,  1108,   258,  1067,
     280,  1112,     1,   283,     3,    69,  1058,    71,   990,   792,
      64,    69,    66,    71,  1078,   729,    19,    52,    21,    54,
      52,   678,   679,     4,     5,  1089,  1090,  1091,   207,   278,
     207,     1,    72,  1129,   746,    64,   748,   271,     1,   269,
      64,   753,  1024,  1095,    76,   757,    69,    69,    80,    70,
     762,   763,   764,   207,    72,   105,   129,    66,  1024,   771,
     193,  1024,   951,   271,  1056,  1129,  1118,   278,   957,    70,
     281,   282,  1140,   271,    40,   271,   965,   271,   110,   149,
     792,    69,    39,  1135,   901,    55,    72,   193,  1140,   796,
     105,    69,  1084,   796,   932,  1147,    69,     1,   932,    70,
      35,   939,    70,   817,    48,   939,   277,    49,   942,    72,
      70,    72,  1094,   827,    70,    23,   129,   278,     1,  1171,
     278,    70,    69,   281,   282,   878,  1078,    72,    76,    70,
      69,   270,    72,   847,   848,    44,    70,  1089,  1090,  1091,
    1078,     1,  1194,   157,  1126,   859,    71,    70,   162,   847,
     848,  1089,  1090,  1091,   168,  1207,   110,   171,   277,  1151,
    1126,  1153,   876,  1126,   277,    69,   868,   152,    70,   201,
      70,    70,    76,   682,   722,   133,    80,  1129,    37,   531,
     150,   354,   626,   153,   898,  1047,    37,  1076,  1129,   275,
     409,  1129,   757,   796,  1176,   796,   796,   167,  1180,  1088,
    1038,   603,  1212,   107,  1038,   603,   603,   927,   158,    69,
    1176,   181,    37,  1176,  1180,   248,    76,  1180,   244,   614,
      80,   191,  1078,   970,   623,   792,    19,  1057,   759,   912,
     549,  1060,  1142,  1089,  1090,  1091,   990,   268,   859,  1221,
     487,   255,   256,   257,   887,   259,   278,   107,   700,   212,
     133,   455,   215,   488,   137,  1221,   448,   140,  1221,   222,
    1231,   144,   145,   667,  1225,   148,   428,   417,    37,  1225,
     233,   154,   235,  1129,   153,   238,   239,   160,   161,   771,
     163,   164,    37,   157,   995,   290,   249,  1035,   162,   193,
     194,    69,   288,  1027,   168,  1078,   179,   171,    76,  1034,
     664,   978,    80,   450,   942,   405,    -1,  1053,   338,    -1,
    1024,    -1,    -1,    -1,    -1,   278,    -1,    -1,    -1,  1208,
      -1,    -1,    -1,    -1,    -1,    -1,   209,   210,   211,   107,
     213,   214,    -1,   193,   194,  1047,   219,    -1,    32,  1228,
      34,    35,    36,  1057,    38,    39,  1129,    41,    42,    43,
      44,    45,    -1,    -1,    -1,    -1,    -1,   240,   262,   263,
      -1,   265,   266,   267,   268,    -1,  1078,  1229,    -1,   252,
     253,     1,    -1,    -1,   278,    -1,     1,   281,   282,    -1,
      -1,   255,   256,   257,   258,   259,    16,    -1,    18,    -1,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   281,   282,
      -1,    31,   262,   263,  1111,   265,   266,   267,   268,    -1,
      -1,    -1,  1126,    -1,    -1,   193,   194,  1129,   278,    -1,
      50,   281,   282,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,  1146,    -1,    -1,    -1,    -1,    -1,    -1,  1179,
      -1,    -1,    -1,    -1,    69,    -1,    71,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1176,    -1,    -1,  1179,  1180,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1179,    -1,    -1,   262,   263,    -1,   265,   266,   267,
     268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,    -1,    -1,   281,   282,   130,    -1,  1221,   133,    -1,
      -1,    -1,   137,    -1,   139,   140,    -1,  1229,    -1,   144,
     145,   146,   152,   148,   149,   150,    -1,   152,   153,   154,
      -1,   156,   157,    -1,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,    -1,   171,   172,    -1,   174,
      -1,   176,    -1,    -1,   179,    -1,   181,   182,   183,    -1,
     185,   186,   187,    -1,   189,   190,    -1,    -1,   193,   194,
      -1,    -1,    -1,   198,   199,   200,    -1,   207,    -1,    -1,
      -1,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
      -1,   216,   217,    -1,   219,    -1,     1,    -1,   223,    -1,
      -1,   226,    -1,    -1,   229,    -1,    -1,   232,    -1,    -1,
      -1,    -1,    -1,    -1,   239,   240,    -1,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,    -1,    -1,    -1,   264,
     270,    -1,    -1,    -1,   274,    -1,   276,    -1,   278,    -1,
      -1,   281,   282,   278,    -1,    -1,   281,   282,   283,    64,
      -1,    -1,    67,    68,    69,    -1,    71,    -1,    73,    -1,
      75,    76,    77,    -1,    79,    80,    -1,    -1,    83,    84,
      85,    86,    87,    88,    -1,    -1,    91,    92,    -1,    94,
      95,    96,    -1,    -1,    99,   100,    -1,   102,   103,    -1,
     105,   106,   107,   108,    -1,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,    -1,     1,   133,    -1,
      -1,    -1,   137,    -1,   139,   140,    -1,    -1,    -1,   144,
     145,   146,    -1,   148,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,    -1,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,    -1,    -1,   171,   172,    -1,   174,
      -1,   176,    -1,    -1,   179,    -1,   181,    -1,    -1,   184,
      -1,    -1,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,     1,
      -1,    -1,    76,   208,   209,   210,   211,    -1,   213,   214,
      -1,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,    -1,
      -1,   226,    -1,    -1,   229,   230,    -1,   232,    -1,    -1,
      -1,    -1,    -1,    -1,   239,   240,    -1,    -1,   243,   244,
     245,    -1,    -1,   248,    -1,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,    -1,    -1,    -1,   264,
      -1,    -1,     1,    -1,    -1,     4,    -1,    -1,    -1,    -1,
      72,    10,    -1,    -1,    76,   149,   281,   282,    17,    -1,
      19,    20,    -1,   157,    -1,    -1,    -1,    26,   162,    -1,
      -1,    30,    -1,    -1,   168,    34,    35,   171,    -1,    -1,
      -1,    -1,    -1,    42,    43,    -1,    -1,    -1,    47,    -1,
      -1,    -1,    51,    52,    -1,    54,    -1,    -1,    57,    58,
      59,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   157,    -1,    -1,    -1,    -1,
     162,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,   171,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   255,   256,   257,   258,   259,    -1,    -1,    -1,    -1,
     264,   130,    -1,    -1,   133,    -1,   135,    -1,   137,    -1,
     139,   140,    -1,   277,    -1,   144,   145,   146,    -1,   148,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
      -1,    -1,   171,    -1,    -1,   174,    69,   176,   177,    -1,
     179,    -1,   181,    76,    -1,   184,    -1,    80,   187,    -1,
     189,   190,    -1,   255,   256,   257,    -1,   259,    -1,    -1,
      -1,    -1,   201,   202,    -1,    -1,    -1,    -1,    -1,   208,
     209,   210,   211,   212,   107,   277,   215,    -1,    -1,    -1,
     219,   220,    -1,   222,   223,    -1,    -1,   226,   227,    -1,
     229,    -1,    -1,   232,   233,    -1,   235,   236,    -1,   238,
     239,   240,    -1,    -1,   243,   244,    -1,    -1,    -1,   248,
     249,    -1,    -1,   252,   253,   254,   255,   256,   257,    -1,
     259,   260,   261,   262,   263,    -1,   265,   266,   267,   268,
      -1,     1,    -1,    -1,     4,    -1,    -1,    -1,   277,   278,
      10,    -1,   281,   282,    -1,    -1,    -1,    17,    -1,    19,
      20,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,
      30,   194,    -1,    -1,    34,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    43,    -1,    -1,    -1,    47,    -1,    -1,
      -1,    51,    52,    -1,    54,    -1,    -1,    57,    58,    59,
      60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,
     263,    -1,   265,   266,   267,   268,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   278,    -1,    -1,   281,   282,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     130,    -1,    -1,   133,    -1,   135,    -1,   137,    -1,   139,
     140,    -1,    -1,    -1,   144,   145,   146,    -1,   148,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,    -1,
      -1,   171,    -1,    -1,   174,    -1,   176,   177,    -1,   179,
      -1,   181,    -1,    -1,   184,    -1,    -1,   187,    -1,   189,
     190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   201,   202,    -1,    -1,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,    -1,   215,    -1,    -1,    -1,   219,
     220,    -1,   222,   223,    -1,    -1,   226,   227,    -1,   229,
      -1,    -1,   232,   233,    -1,   235,   236,    -1,   238,   239,
     240,    -1,    -1,   243,   244,    -1,    -1,    -1,   248,   249,
      -1,    -1,   252,   253,   254,   255,   256,   257,    -1,   259,
     260,   261,   262,   263,    -1,   265,   266,   267,   268,    -1,
       1,    -1,    -1,     4,    -1,    -1,    -1,    -1,   278,    10,
      -1,   281,   282,    -1,    -1,    -1,    17,    -1,    19,    20,
      -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    30,
      -1,    -1,    -1,    34,    35,    -1,    -1,    -1,    -1,    -1,
      -1,    42,    43,    -1,    -1,    -1,    47,    -1,    -1,    -1,
      51,    52,    -1,    54,    -1,    -1,    57,    58,    59,    60,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,   133,    -1,   135,    -1,   137,    -1,   139,   140,
      -1,    -1,    -1,   144,   145,   146,    -1,   148,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,    -1,    -1,
     171,    -1,    -1,   174,    -1,   176,   177,    -1,   179,    -1,
     181,    -1,    -1,   184,    -1,    -1,   187,    -1,   189,   190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     201,   202,    -1,    -1,    -1,    -1,    -1,   208,   209,   210,
     211,   212,    -1,    -1,   215,    -1,    -1,    -1,   219,   220,
      -1,   222,   223,    -1,    -1,   226,   227,    -1,   229,    -1,
      -1,   232,   233,    -1,   235,   236,    -1,   238,   239,   240,
      -1,    -1,   243,   244,    -1,    -1,    -1,   248,   249,    -1,
      -1,   252,   253,   254,   255,   256,   257,    -1,   259,   260,
     261,   262,   263,    -1,   265,   266,   267,   268,    -1,     1,
      -1,    -1,     4,    -1,    -1,    -1,    -1,   278,    10,    -1,
     281,   282,    -1,    -1,    -1,    17,    -1,    19,    20,    -1,
      -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    30,    -1,
      -1,    -1,    34,    35,    -1,    -1,    -1,    -1,    -1,    -1,
      42,    43,    -1,    -1,    -1,    47,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    -1,    57,    58,    59,    60,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,    -1,   135,    -1,   137,    -1,   139,   140,    -1,
      -1,    -1,   144,   145,   146,    -1,   148,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,    -1,    -1,   171,
      -1,    -1,   174,    -1,   176,   177,    -1,   179,    -1,   181,
      -1,    -1,   184,    -1,    -1,   187,    -1,   189,   190,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   201,
     202,    -1,    -1,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,    -1,   215,    -1,    -1,    -1,   219,   220,    -1,
     222,   223,    -1,    -1,   226,   227,    -1,   229,    -1,    -1,
     232,   233,    -1,   235,   236,    -1,   238,   239,   240,    -1,
       1,   243,   244,     4,    -1,    -1,   248,   249,    -1,    10,
     252,   253,   254,   255,   256,   257,    -1,   259,   260,   261,
     262,   263,    -1,   265,   266,   267,   268,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   278,    38,    -1,   281,
     282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      51,    -1,    -1,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    -1,    67,    68,    69,    -1,
      71,    -1,    73,    -1,    75,    76,    77,    -1,    79,    80,
      -1,    -1,    83,    84,    85,    86,    87,    88,    -1,    -1,
      91,    92,    -1,    94,    95,    96,    -1,    -1,    99,   100,
      -1,   102,   103,    -1,   105,   106,   107,   108,    -1,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   157,    -1,    -1,    -1,
      -1,   162,    -1,    -1,    -1,    -1,   167,    -1,    -1,    -1,
      -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   184,    -1,    -1,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,   208,    -1,    70,
      -1,   212,    -1,    -1,   215,    -1,    -1,    -1,    -1,   220,
      -1,   222,   223,    -1,    -1,   226,   227,    -1,   229,    -1,
      -1,    -1,   233,    -1,   235,   236,    -1,   238,   239,    -1,
      -1,    -1,   243,   244,   245,    -1,    -1,   248,   249,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,   133,    -1,    -1,    -1,   137,   278,   139,   140,
     281,   282,    -1,   144,   145,   146,     1,   148,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,    -1,    -1,
     171,   172,    -1,   174,    -1,   176,    -1,    -1,   179,    -1,
     181,    -1,    -1,    -1,    -1,    -1,   187,    -1,   189,   190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,    -1,    -1,    -1,   208,   209,   210,
     211,    -1,   213,   214,    -1,   216,    -1,    -1,   219,    -1,
      -1,    -1,   223,    -1,    -1,   226,    -1,    -1,   229,    -1,
      -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,   239,   240,
      -1,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,    -1,
      -1,   252,   253,   254,   255,   256,   257,   258,   259,   260,
      -1,    -1,    -1,   264,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,   278,   133,    -1,
     281,   282,   137,    -1,   139,   140,     1,    -1,    -1,   144,
     145,   146,    -1,   148,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,    -1,    -1,   171,   172,    -1,   174,
      -1,   176,    -1,    -1,   179,    -1,   181,    -1,    -1,    -1,
      -1,    -1,   187,    -1,   189,   190,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,   213,   214,
      -1,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,    -1,
      -1,   226,    -1,    -1,   229,    -1,    -1,   232,    -1,    -1,
      -1,    -1,    -1,    -1,   239,   240,    -1,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,    -1,    -1,    -1,   264,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,   133,    -1,
      -1,    -1,   137,   278,   139,   140,   281,   282,    -1,   144,
     145,   146,     1,   148,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,    -1,    -1,   171,   172,    -1,   174,
      -1,   176,    -1,    -1,   179,    -1,   181,    -1,    -1,    -1,
      -1,    -1,   187,    -1,   189,   190,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,   213,   214,
      -1,   216,    -1,    -1,   219,     1,    -1,    -1,   223,    -1,
      -1,   226,    -1,    -1,   229,    -1,    -1,   232,    -1,    15,
      -1,    -1,    -1,    -1,   239,   240,    -1,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,    -1,    -1,   252,   253,   254,
     255,   256,   257,   258,   259,   260,    -1,    -1,    -1,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,    -1,   278,   133,    61,   281,   282,   137,    -1,
     139,   140,     4,    -1,    70,   144,   145,   146,    10,   148,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,    -1,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
      -1,    -1,   171,   172,    -1,   174,    -1,   176,    -1,    -1,
     179,    -1,   181,    -1,    -1,    -1,    -1,    -1,   187,    51,
     189,   190,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    -1,    -1,   129,    -1,    -1,    -1,    -1,    70,   208,
     209,   210,   211,    -1,   213,   214,    -1,   216,    -1,   145,
     219,    -1,   148,    -1,   223,    -1,    -1,   226,   154,    -1,
     229,    -1,    -1,   232,   160,    -1,    -1,    -1,    -1,    -1,
     239,   240,    -1,   169,   243,   244,    -1,    -1,    -1,   248,
      -1,    -1,    -1,   252,   253,   254,   255,   256,   257,   258,
     259,   260,    -1,    -1,    -1,   264,    -1,    -1,   130,    -1,
       4,    -1,    -1,   135,    -1,    -1,    10,   139,   277,    -1,
      -1,    -1,   281,   282,    -1,    -1,    -1,   149,    -1,    -1,
     152,   217,    -1,    -1,    -1,   157,   158,    -1,    -1,    -1,
     162,    -1,    -1,    -1,    -1,   167,   168,    -1,    -1,   171,
      -1,    -1,   174,    -1,   176,   177,    -1,    51,    -1,    -1,
      -1,    -1,   184,    57,    58,   187,    -1,   189,   190,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   201,
     202,    -1,    -1,    -1,   270,    -1,   208,    -1,   274,    -1,
     212,    -1,    -1,   215,    -1,    -1,    -1,    -1,   220,    -1,
     222,   223,    -1,    -1,   226,   227,    -1,   229,    -1,    -1,
     232,   233,    -1,   235,   236,    -1,   238,   239,    -1,    -1,
      -1,   243,   244,    -1,    -1,    -1,   248,   249,    -1,    -1,
      -1,    -1,    -1,   255,   256,   257,   130,   259,   260,    -1,
      -1,   135,    -1,    -1,    -1,   139,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   278,    -1,   152,    -1,
      -1,    -1,     1,   157,   158,    -1,    -1,    -1,   162,    -1,
      -1,    -1,    -1,   167,   168,    -1,    15,   171,    -1,    -1,
     174,    -1,   176,   177,    -1,    -1,    -1,    -1,    -1,    -1,
     184,    -1,    -1,   187,    -1,   189,   190,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   201,   202,    -1,
      -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,   212,    -1,
      -1,   215,    61,    -1,    -1,    -1,   220,    -1,   222,   223,
      -1,    70,   226,   227,    -1,   229,    -1,    -1,   232,   233,
      -1,   235,   236,    -1,   238,   239,    -1,    -1,    -1,   243,
     244,    -1,    -1,    -1,   248,   249,    -1,    -1,    -1,    -1,
      -1,   255,   256,   257,    -1,   259,   260,     0,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    11,    12,
      13,    14,    -1,    -1,   278,    -1,    -1,    -1,    -1,   133,
     129,    -1,    -1,   137,    -1,    -1,   140,    -1,    -1,    -1,
     144,   145,    -1,    -1,   148,    -1,   145,   146,    -1,   148,
     154,    -1,    -1,    -1,    -1,   154,   160,   161,    -1,   163,
     164,   160,    -1,    -1,    -1,    -1,   165,   166,    -1,    -1,
     169,    -1,    -1,    -1,    -1,   179,    -1,    -1,    19,    20,
      -1,    -1,    -1,    19,    20,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    -1,    -1,    -1,   209,   210,   211,    -1,   213,
     214,    -1,    -1,    -1,    -1,   219,    -1,    -1,   217,    60,
      -1,    -1,    -1,    -1,    60,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   252,   253,
      -1,    -1,    -1,    -1,    -1,   254,   149,   150,    -1,   152,
     153,    -1,    -1,    -1,   157,    -1,   159,    -1,    -1,    -1,
      -1,   270,    -1,    -1,   167,   274,    -1,   281,   282,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,   182,
      -1,    -1,   133,   186,    -1,    -1,   137,   133,   191,   140,
      -1,   137,    -1,   144,   140,   198,   199,   200,   144,   150,
      -1,    -1,   153,     4,   207,    -1,    -1,    -1,   159,    10,
     161,    -1,   163,   164,    -1,   161,    -1,   163,   164,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   179,    -1,
     181,    -1,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      51,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,   210,
     211,    -1,    -1,   209,   210,   211,    -1,   270,   219,    -1,
      -1,   274,    -1,   219,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,
      -1,    -1,    -1,    -1,   240,    -1,    -1,    -1,    -1,    -1,
      -1,   252,   253,    -1,    -1,    -1,   252,   253,    -1,    -1,
      -1,    -1,     4,    -1,    -1,    -1,    -1,    -1,    10,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
     281,   282,   278,    -1,   135,    -1,    -1,    -1,   139,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    38,    -1,   149,    -1,
      -1,   152,    -1,    -1,    -1,    -1,   157,    -1,    -1,    51,
      -1,   162,    -1,    -1,    -1,    -1,   167,   168,    -1,    -1,
     171,    -1,    -1,   174,    -1,   176,   177,    -1,    17,    -1,
      -1,    -1,    -1,   184,    -1,    -1,   187,    26,   189,   190,
      -1,    30,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,
     201,   202,    -1,    42,    43,    -1,    -1,   208,    47,    -1,
      -1,   212,    -1,    52,   215,    54,    -1,    -1,    -1,   220,
      59,   222,   223,    -1,    -1,   226,   227,    -1,   229,    -1,
      -1,   232,   233,     4,   235,   236,    -1,   238,   239,    10,
      -1,    -1,   243,   244,    -1,    -1,    -1,   248,   249,    -1,
      -1,    -1,    -1,    -1,   255,   256,   257,   149,   259,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   167,    -1,    -1,    -1,    -1,
      51,    -1,   174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   187,    -1,   189,   190,    -1,
      -1,    -1,    -1,    -1,    75,    -1,   145,   146,    -1,   148,
     202,    -1,    -1,    -1,    -1,   154,   208,    -1,    -1,    -1,
     212,   160,    -1,   215,    -1,    -1,   165,   166,   220,    -1,
     222,   223,    -1,    -1,   226,   227,    -1,   229,    -1,    -1,
      -1,   233,    -1,   235,   236,    -1,   238,   239,    -1,    -1,
      -1,   243,   244,    -1,    -1,    -1,   248,   249,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   167,    -1,    -1,    -1,
      -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   254,   187,    -1,   189,   190,
      -1,    -1,   261,   262,   263,    76,   265,   266,   267,   268,
      -1,   202,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,   212,    -1,    -1,   215,    -1,    -1,    -1,    -1,   220,
      -1,   222,   223,    -1,    -1,   226,   227,    -1,   229,    -1,
      -1,    -1,   233,    -1,   235,   236,    -1,   238,   239,    -1,
      -1,    -1,   243,   244,    -1,    -1,    -1,   248,   249,   130,
      -1,    -1,   133,    -1,    -1,    -1,   137,    -1,   139,   140,
      -1,    -1,    -1,   144,   145,   146,    -1,   148,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,    -1,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,    -1,    -1,
     171,   172,    -1,   174,    -1,   176,    -1,    -1,   179,    -1,
     181,    -1,    -1,    -1,    -1,    -1,   187,    -1,   189,   190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,   209,   210,
     211,    -1,   213,   214,    -1,   216,    -1,    -1,   219,    -1,
      -1,    -1,   223,    -1,    -1,   226,    -1,    -1,   229,    -1,
      -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,   239,   240,
      -1,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,    -1,
      -1,   252,   253,   254,   255,   256,   257,   258,   259,   260,
      -1,    -1,    -1,   264,    -1,    -1,    -1,    -1,   130,    -1,
      -1,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     281,   282,   144,   145,   146,    -1,   148,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,    -1,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,    -1,    -1,   171,
     172,    -1,   174,    -1,   176,    -1,    -1,   179,    -1,   181,
      -1,    -1,    -1,    -1,    -1,   187,    -1,   189,   190,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,   213,   214,    -1,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,    -1,    -1,   226,    -1,    -1,   229,    -1,    -1,
     232,    -1,    -1,    -1,    -1,    -1,    -1,   239,   240,    -1,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,    -1,    -1,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   130,
      -1,    -1,   264,    -1,    -1,    -1,    -1,    -1,   139,    -1,
      -1,    -1,    -1,    -1,   145,   146,    -1,   148,   149,   281,
     282,   152,    -1,   154,    -1,    -1,   157,    -1,    -1,   160,
      -1,   162,    -1,    -1,   165,   166,   167,   168,    -1,    -1,
     171,    -1,    -1,   174,    -1,   176,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   187,    -1,   189,   190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,
      -1,    -1,   223,    -1,    -1,   226,    -1,    -1,   229,    -1,
      -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,   239,    -1,
      -1,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,    -1,
      -1,    -1,    -1,   254,   255,   256,   257,   258,   259,   260,
      -1,    -1,    -1,   264
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,   285,     0,     1,     3,     5,     6,     7,     8,     9,
      11,    12,    13,    14,   149,   150,   152,   153,   157,   159,
     167,   181,   182,   186,   191,   198,   199,   200,   207,   270,
     274,   286,   287,   288,   289,   304,   305,   307,   308,   310,
     311,   312,   316,   322,   323,   324,   329,   337,   338,   341,
     343,   360,   363,   371,   372,   468,   476,   477,   625,   645,
     278,   281,   282,   571,   574,   580,   585,   588,   590,     1,
      64,    67,    68,    69,    71,    73,    75,    76,    77,    79,
      80,    83,    84,    85,    86,    87,    88,    91,    92,    94,
      95,    96,    99,   100,   102,   103,   105,   106,   107,   108,
     110,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   184,   192,   245,   301,   585,   589,   604,
       1,   585,   587,     1,     3,   598,     1,    25,    31,    45,
     309,   598,   279,   313,   314,     1,    16,    50,    57,   278,
     320,   574,   598,   206,   653,   598,   475,   476,     1,   191,
     624,   373,   645,   587,   645,   645,   645,     1,    69,    71,
      76,   130,   133,   137,   139,   140,   144,   145,   146,   148,
     149,   152,   154,   156,   157,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   171,   172,   174,   176,   179,
     187,   189,   190,   194,   206,   208,   209,   210,   211,   213,
     214,   216,   217,   219,   223,   226,   229,   232,   239,   240,
     243,   244,   248,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   264,   278,   325,   327,   329,   330,   333,   335,
     336,   353,   360,   361,   370,   387,   388,   389,   391,   415,
     416,   418,   426,   452,   454,   455,   456,   457,   458,   459,
     461,   462,   463,   464,   465,   466,   467,   468,   477,   480,
     481,   483,   485,   486,   488,   496,   498,   499,   508,   509,
     574,   577,   578,   580,   610,   611,   615,   657,   645,   645,
     645,   645,   645,   645,   645,   342,   339,   344,    44,   627,
     628,   629,    64,     1,    18,    37,    56,   594,    64,     1,
      70,   640,     1,    72,   636,    71,    71,     4,    10,    38,
      51,   149,   167,   174,   187,   189,   190,   202,   208,   212,
     215,   220,   222,   223,   226,   227,   229,   233,   235,   236,
     238,   239,   243,   244,   248,   249,   302,   303,   482,   539,
       1,    18,   129,   593,   290,   593,   110,   315,   314,    50,
      57,   321,   276,   612,   613,    18,    31,   152,   207,   317,
     319,   364,     1,   278,   281,   569,   570,   594,   167,   208,
     415,   452,   610,    76,    80,   110,   201,   278,   354,   355,
     356,   478,   479,   480,   496,   280,   283,   542,   647,     1,
      69,   621,   621,    64,   306,   621,    71,    71,   484,   500,
     510,    69,     1,    95,   622,   331,   621,   129,   417,   362,
     455,   457,   453,   454,   482,   487,   488,   487,   499,   509,
      64,   579,   193,   372,   183,   185,   283,   608,    77,     1,
     571,   572,   572,     1,   278,   346,   347,   348,   574,     1,
      55,   477,   625,   641,   642,   627,   278,   574,     4,    10,
      51,    57,    58,   130,   135,   139,   149,   152,   158,   167,
     171,   176,   177,   184,   187,   189,   190,   201,   202,   208,
     223,   226,   227,   229,   232,   243,   244,   248,   255,   256,
     257,   260,   278,   481,   483,   513,   535,   536,   537,   538,
     539,   540,   544,   550,   551,   580,   586,   655,   574,   580,
     636,   636,    32,    33,    36,   541,   147,   225,   234,   251,
      24,    71,   294,     1,   208,   656,     1,   221,   607,     1,
     237,   654,   481,   655,   587,   291,   513,   629,   513,     1,
     279,    18,   319,     1,   317,   318,   452,   487,   513,   640,
     326,     1,   201,   649,   278,    72,     1,   129,   602,   480,
     495,   496,   480,   271,     1,   647,   648,   452,   361,     1,
     277,   617,   489,     1,    72,    76,   277,   621,   621,   392,
     452,   653,     1,   277,   452,    69,    76,    80,   107,   262,
     263,   265,   266,   267,   268,   376,   377,   379,   381,   382,
     385,   390,   409,   411,   412,   414,   419,   421,   422,   424,
     425,   426,   428,   525,   571,   574,   577,   578,   580,   581,
     379,   375,   376,   571,   572,   573,   572,   573,   571,   452,
     621,   621,   570,   269,   469,   340,   345,    64,    64,   572,
     541,   225,   656,     1,    29,   606,   542,     1,   178,   620,
      76,   277,   545,   629,    17,    26,    30,    47,    52,    54,
      59,   261,   456,   514,   519,   520,   521,   523,   524,   525,
     532,   546,   547,   548,   549,   552,   553,   554,   555,   538,
      18,     1,    41,   619,     1,   241,   591,     1,    69,    71,
     295,    28,    52,   296,   297,   298,   356,    69,   527,   528,
       1,    27,   603,    15,    61,   169,   217,   292,   293,   300,
     593,   318,   365,     1,   110,   609,    69,   414,   421,   424,
     429,   430,   431,   432,   433,   435,   436,   438,   440,   442,
     581,    69,   357,   356,   495,   640,   460,   640,   207,   490,
      72,   636,   636,   621,     1,   278,   503,   511,   512,   158,
     201,   278,   404,   405,   406,   575,   650,   328,   332,    70,
     640,   334,   105,   410,   478,   478,   478,   129,    69,    71,
     383,   384,   413,   420,   423,   380,   381,   390,   412,   580,
      66,   193,   269,   582,   497,   498,   469,   271,   271,   427,
     404,    70,   393,   621,     1,   145,   148,   154,   160,   461,
     463,   470,   472,   473,   474,   578,   271,   350,   351,     1,
     349,   351,   167,   278,   574,   167,   574,   580,    40,   543,
     149,   646,   527,    69,   522,     1,    56,   651,     1,    52,
     637,    39,   518,   527,    42,    43,   623,   651,    19,    20,
      34,    60,   133,   137,   140,   144,   161,   163,   164,   179,
     209,   210,   211,   219,   240,   252,   253,   468,   477,   556,
     557,   558,   559,   560,   562,   563,   578,   555,   513,   621,
     296,   296,    22,   135,   299,    56,   299,    72,   602,   513,
     529,   530,    53,   147,   533,   534,   638,   193,   631,    18,
      56,   595,   617,     1,   277,   513,   526,   536,   366,   368,
     379,   452,   105,   437,   439,   441,   443,   383,   640,    69,
     404,   301,   429,     1,   278,   576,     1,   212,   215,   222,
     233,   235,   238,   239,   249,   491,   492,   493,   580,   501,
     502,   503,    69,   504,    70,   503,    70,   602,   452,   429,
     361,   429,   386,   379,     1,   377,   378,   404,     1,   149,
     277,   478,   479,   636,   497,   379,   379,   379,   482,     1,
     230,   604,   634,   617,   414,   421,   424,   444,   445,   446,
     448,   450,   581,   393,   394,   202,   227,   398,   393,   473,
     474,   471,   472,     1,   272,   337,   352,   363,   371,   576,
     576,   481,   515,   516,   640,     1,    42,   513,     1,    17,
     592,   533,    35,   513,    48,   561,     1,   144,   616,     1,
      46,   632,     1,   133,   599,   277,   618,    49,   633,   572,
     572,     1,    61,    69,   277,   529,    70,    72,     1,   135,
     605,   576,   298,    70,   602,     1,   513,   629,    19,    21,
     596,    23,   597,    52,    54,   532,   129,   374,   434,   429,
     429,   429,   429,   580,   584,   404,    70,    75,   358,   640,
       1,   269,   601,    69,   494,   494,    72,   602,    70,   602,
      69,   273,   277,   278,   280,   283,   505,   506,   507,   398,
       1,   406,   408,   407,     1,    96,   614,   640,   478,   640,
     393,    72,   478,   636,    76,   636,   646,   621,   576,   447,
     449,   451,   621,   398,   395,   621,    69,   497,   398,   471,
     270,   644,     1,   270,   643,   643,    76,   277,   517,     1,
      44,   626,   515,   527,   616,    44,   564,   617,   617,   596,
      70,     1,   513,   531,     1,   638,   639,   637,   623,   367,
     429,   478,   640,   393,   452,   648,   636,   493,   640,   503,
     506,    70,   602,   110,   402,   429,   621,   379,    80,   107,
     397,   277,   636,   277,   404,   621,   444,   444,   444,   393,
     497,   226,   229,   259,   396,   481,   405,   640,     1,   188,
     203,   399,   497,     1,   272,   635,   626,     1,   477,   600,
     626,   533,   152,   652,   596,   640,   533,   513,     1,   193,
     630,     1,   368,   369,   429,   398,   359,   640,     1,   640,
     507,     1,   135,   184,   277,     1,   580,   583,   640,   398,
     636,   636,   393,     1,   403,   405,   398,    70,   640,   402,
     513,   587,   513,   473,   565,   566,   567,   527,   640,    75,
     400,   498,   429,   640,   621,   400,   397,    70,   402,   513,
     278,   557,   568,   586,   473,   533,   621,   452,   404,   402,
     398,   398,   404,   401,    70,   400,   400,    70,   429,   497,
     402
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 183: /* "Y_CONSTRUCTOR_SNAME" */
#line 1797 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4872 "parser.c"
	break;
      case 185: /* "Y_DESTRUCTOR_SNAME" */
#line 1798 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4877 "parser.c"
	break;
      case 194: /* "Y_OPERATOR_SNAME" */
#line 1799 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4882 "parser.c"
	break;
      case 273: /* "Y_CHAR_LIT" */
#line 1775 "parser.y"
	{ DTRACE; FREE( (yyvaluep->str_val) ); };
#line 4887 "parser.c"
	break;
      case 276: /* "Y_GLOB" */
#line 1776 "parser.y"
	{ DTRACE; FREE( (yyvaluep->name) ); };
#line 4892 "parser.c"
	break;
      case 278: /* "Y_NAME" */
#line 1777 "parser.y"
	{ DTRACE; FREE( (yyvaluep->name) ); };
#line 4897 "parser.c"
	break;
      case 279: /* "Y_SET_OPTION" */
#line 1778 "parser.y"
	{ DTRACE; FREE( (yyvaluep->name) ); };
#line 4902 "parser.c"
	break;
      case 280: /* "Y_STR_LIT" */
#line 1779 "parser.y"
	{ DTRACE; FREE( (yyvaluep->str_val) ); };
#line 4907 "parser.c"
	break;
      case 315: /* "set_option_value_opt" */
#line 1772 "parser.y"
	{ DTRACE; FREE( (yyvaluep->str_val) ); };
#line 4912 "parser.c"
	break;
      case 403: /* "param_c_ast_list_exp" */
#line 1762 "parser.y"
	{ DTRACE; c_ast_list_cleanup( &(yyvaluep->ast_list) ); };
#line 4917 "parser.c"
	break;
      case 404: /* "param_c_ast_list_opt" */
#line 1763 "parser.y"
	{ DTRACE; c_ast_list_cleanup( &(yyvaluep->ast_list) ); };
#line 4922 "parser.c"
	break;
      case 405: /* "param_c_ast_list" */
#line 1761 "parser.y"
	{ DTRACE; c_ast_list_cleanup( &(yyvaluep->ast_list) ); };
#line 4927 "parser.c"
	break;
      case 527: /* "paren_param_decl_list_english_opt" */
#line 1765 "parser.y"
	{ DTRACE; c_ast_list_cleanup( &(yyvaluep->ast_list) ); };
#line 4932 "parser.c"
	break;
      case 528: /* "paren_param_decl_list_english" */
#line 1764 "parser.y"
	{ DTRACE; c_ast_list_cleanup( &(yyvaluep->ast_list) ); };
#line 4937 "parser.c"
	break;
      case 529: /* "param_decl_list_english_opt" */
#line 1760 "parser.y"
	{ DTRACE; c_ast_list_cleanup( &(yyvaluep->ast_list) ); };
#line 4942 "parser.c"
	break;
      case 530: /* "param_decl_list_english" */
#line 1759 "parser.y"
	{ DTRACE; c_ast_list_cleanup( &(yyvaluep->ast_list) ); };
#line 4947 "parser.c"
	break;
      case 569: /* "any_name" */
#line 1768 "parser.y"
	{ DTRACE; FREE( (yyvaluep->name) ); };
#line 4952 "parser.c"
	break;
      case 570: /* "any_name_exp" */
#line 1769 "parser.y"
	{ DTRACE; FREE( (yyvaluep->name) ); };
#line 4957 "parser.c"
	break;
      case 571: /* "any_sname_c" */
#line 1782 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4962 "parser.c"
	break;
      case 572: /* "any_sname_c_exp" */
#line 1783 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4967 "parser.c"
	break;
      case 573: /* "any_sname_c_opt" */
#line 1784 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4972 "parser.c"
	break;
      case 576: /* "name_exp" */
#line 1771 "parser.y"
	{ DTRACE; FREE( (yyvaluep->name) ); };
#line 4977 "parser.c"
	break;
      case 577: /* "oper_sname_c_opt" */
#line 1789 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4982 "parser.c"
	break;
      case 579: /* "sub_scope_sname_c_opt" */
#line 1795 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4987 "parser.c"
	break;
      case 580: /* "sname_c" */
#line 1790 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4992 "parser.c"
	break;
      case 583: /* "sname_c_exp" */
#line 1791 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 4997 "parser.c"
	break;
      case 584: /* "sname_c_opt" */
#line 1792 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5002 "parser.c"
	break;
      case 585: /* "sname_english" */
#line 1793 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5007 "parser.c"
	break;
      case 587: /* "sname_english_exp" */
#line 1794 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5012 "parser.c"
	break;
      case 589: /* "sname_list_english" */
#line 1802 "parser.y"
	{ DTRACE; c_sname_list_cleanup( &(yyvaluep->list) ); };
#line 5017 "parser.c"
	break;
      case 590: /* "typedef_sname_c" */
#line 1796 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5022 "parser.c"
	break;
      case 608: /* "destructor_sname" */
#line 1785 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5027 "parser.c"
	break;
      case 613: /* "glob_opt" */
#line 1770 "parser.y"
	{ DTRACE; FREE( (yyvaluep->name) ); };
#line 5032 "parser.c"
	break;
      case 627: /* "of_scope_english" */
#line 1786 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5037 "parser.c"
	break;
      case 628: /* "of_scope_list_english" */
#line 1787 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5042 "parser.c"
	break;
      case 629: /* "of_scope_list_english_opt" */
#line 1788 "parser.y"
	{ DTRACE; c_sname_cleanup( &(yyvaluep->sname) ); };
#line 5047 "parser.c"
	break;
      case 647: /* "str_lit" */
#line 1773 "parser.y"
	{ DTRACE; FREE( (yyvaluep->str_val) ); };
#line 5052 "parser.c"
	break;
      case 648: /* "str_lit_exp" */
#line 1774 "parser.y"
	{ DTRACE; FREE( (yyvaluep->str_val) ); };
#line 5057 "parser.c"
	break;

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 1810 "parser.y"
    { //
      // We get here only after a successful parse.
      //
      parse_cleanup( /*fatal_error=*/false );
    ;}
    break;

  case 17:
#line 1832 "parser.y"
    {
      if ( printable_token() != NULL )
        elaborate_error_dym( DYM_COMMANDS, "unexpected token" );
      else
        elaborate_error( "unexpected end of command" );
    ;}
    break;

  case 18:
#line 1851 "parser.y"
    {
      c_ast_t *const decl_ast = (yyvsp[(4) - (4)].ast);

      DUMP_START( "cast_command",
                  "CAST sname_english_opt as_into_to_exp decl_english_ast" );
      DUMP_SNAME( "sname_english_opt", (yyvsp[(2) - (4)].sname) );
      DUMP_AST( "decl_english_ast", decl_ast );
      DUMP_END();

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[(2) - (4)].sname) );
      cast_ast->cast.kind = C_CAST_C;
      cast_ast->cast.to_ast = decl_ast;
      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_gibberish( cast_ast, C_GIB_CAST, stdout );
    ;}
    break;

  case 19:
#line 1873 "parser.y"
    {
      c_cast_kind_t const cast_kind = (yyvsp[(1) - (4)].cast_kind);
      char const   *const cast_literal = c_cast_gibberish( cast_kind );
      c_ast_t      *const decl_ast = (yyvsp[(4) - (4)].ast);

      DUMP_START( "cast_command",
                  "new_style_cast_english CAST sname_english_exp "
                  "as_into_to_exp decl_english_ast" );
      DUMP_STR( "new_style_cast_english", cast_literal );
      DUMP_SNAME( "sname_english_exp", (yyvsp[(2) - (4)].sname) );
      DUMP_AST( "decl_english_ast", decl_ast );
      DUMP_END();

      if ( UNSUPPORTED( CPP_ANY ) ) {
        print_error( &(yylsp[(1) - (4)]),
          "%s not supported%s\n", cast_literal,
          C_LANG_WHICH( CPP_ANY )
        );
        PARSE_ABORT();
      }

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[(2) - (4)].sname) );
      cast_ast->cast.kind = cast_kind;
      cast_ast->cast.to_ast = decl_ast;
      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_gibberish( cast_ast, C_GIB_CAST, stdout );
    ;}
    break;

  case 20:
#line 1904 "parser.y"
    { (yyval.cast_kind) = C_CAST_CONST;        ;}
    break;

  case 21:
#line 1905 "parser.y"
    { (yyval.cast_kind) = C_CAST_DYNAMIC;      ;}
    break;

  case 22:
#line 1906 "parser.y"
    { (yyval.cast_kind) = C_CAST_REINTERPRET;  ;}
    break;

  case 23:
#line 1907 "parser.y"
    { (yyval.cast_kind) = C_CAST_STATIC;       ;}
    break;

  case 25:
#line 1918 "parser.y"
    {
      slist_t         sname_list = slist_move( &(yyvsp[(2) - (4)].list) );
      c_ast_t *const  decl_ast = (yyvsp[(4) - (4)].ast);

      if ( decl_ast->kind == K_NAME ) {
        //
        // This checks for a case like:
        //
        //      declare x as y
        //
        // i.e., declaring a variable name as another name (unknown type).
        // This can get this far due to the nature of the C/C++ grammar.
        //
        // This check has to be done now in the parser rather than later in the
        // AST because the name of the AST node needs to be set to the variable
        // name, but the AST node is itself a name and overwriting it would
        // lose information.
        //
        assert( !c_sname_empty( &decl_ast->sname ) );
        print_error_unknown_name( &(yylsp[(4) - (4)]), &decl_ast->sname );
        c_sname_list_cleanup( &sname_list );
        PARSE_ABORT();
      }

      DUMP_START( "declare_command",
                  "DECLARE sname_list_english AS "
                  "alignas_or_width_decl_english_ast" );
      DUMP_SNAME_LIST( "sname_list_english", sname_list );
      DUMP_AST( "alignas_or_width_decl_english_ast", decl_ast );

      decl_ast->loc = (yylsp[(2) - (4)]);

      DUMP_AST( "decl_english", decl_ast );
      DUMP_END();

      // To check the declaration, it needs a name: just dup the first one.
      c_sname_t temp_sname = c_sname_dup( slist_front( &sname_list ) );
      c_sname_set( &decl_ast->sname, &temp_sname );

      bool ok = c_ast_check( decl_ast );

      if ( ok ) {
        //
        // Ensure that none of the names aren't of a previously declared type:
        //
        //      cdecl> struct S
        //      cdecl> declare S as int // error: "S": previously declared
        //
        // This check is done now in the parser rather than later in the AST
        // since similar checks are also done here in the parser.
        //
        FOREACH_SLIST_NODE( sname_node, &sname_list ) {
          c_sname_t const *const sname = sname_node->data;
          c_typedef_t const *const tdef = c_typedef_find_sname( sname );
          if ( tdef != NULL ) {
            print_error( &decl_ast->loc,
              "\"%s\": previously declared as type: ",
              c_sname_full_name( sname )
            );
            print_type( tdef, stderr );
            ok = false;
            break;
          }
        } // for
      }

      if ( ok ) {
        unsigned gib_flags = C_GIB_DECL;
        if ( slist_len( &sname_list ) > 1 )
          gib_flags |= C_GIB_MULTI_DECL;
        bool const print_as_using = c_ast_print_as_using( decl_ast );
        if ( print_as_using && opt_semicolon ) {
          //
          // When declaring multiple types via the same "declare" as "using"
          // declarations, each type needs its own "using" declaration and
          // hence its own semicolon:
          //
          //      c++decl> declare I, J as type int
          //      using I = int;
          //      using J = int;
          //
          gib_flags |= C_GIB_FINAL_SEMI;
        }

        FOREACH_SLIST_NODE( sname_node, &sname_list ) {
          c_sname_t *const cur_sname = sname_node->data;
          c_sname_set( &decl_ast->sname, cur_sname );
          bool const is_last_sname = sname_node->next == NULL;
          if ( is_last_sname && opt_semicolon )
            gib_flags |= C_GIB_FINAL_SEMI;
          c_ast_gibberish( decl_ast, gib_flags, stdout );
          if ( is_last_sname )
            continue;
          if ( print_as_using ) {
            //
            // When declaring multiple types via the same "declare" as "using"
            // declarations, they need to be separated by newlines.  (The final
            // newine is handled below.)
            //
            PUTC( '\n' );
          }
          else {
            //
            // When declaring multiple types (not as "using" declarations) or
            // objects via the same "declare", the second and subsequent types
            // or objects must not have the type name printed -- and they also
            // need to be separated by commas.  For example, when printing:
            //
            //      cdecl> declare x, y as pointer to int
            //      int *x, *y;
            //
            // the gibberish for `y` must not print the `int` again.
            //
            gib_flags |= C_GIB_OMIT_TYPE;
            PUTS( ", " );
          }
        } // for
      }

      c_sname_list_cleanup( &sname_list );
      PARSE_ASSERT( ok );
      PUTC( '\n' );
    ;}
    break;

  case 26:
#line 2046 "parser.y"
    { //
      // This check is done now in the parser rather than later in the AST
      // since it yields a better error message since otherwise it would warn
      // that "operator" is a keyword in C++98 which skims right past the
      // bigger error that operator overloading isn't supported in C.
      //
      if ( UNSUPPORTED( CPP_ANY ) ) {
        print_error( &(yylsp[(2) - (2)]),
          "operator overloading not supported%s\n",
          C_LANG_WHICH( CPP_ANY )
        );
        PARSE_ABORT();
      }
      in_attr.operator = c_oper_get( (yyvsp[(2) - (2)].oper_id) );
    ;}
    break;

  case 27:
#line 2062 "parser.y"
    {
      c_ast_t *const oper_ast = (yyvsp[(6) - (6)].ast);

      DUMP_START( "declare_command",
                  "DECLARE c_operator of_scope_list_english_opt AS "
                  "oper_decl_english_ast" );
      DUMP_STR( "c_operator", oper_ast->oper.operator->literal );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[(4) - (6)].sname) );
      DUMP_AST( "oper_decl_english_ast", oper_ast );

      c_sname_set( &oper_ast->sname, &(yyvsp[(4) - (6)].sname) );
      oper_ast->loc = (yylsp[(2) - (6)]);

      DUMP_AST( "declare_command", oper_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( oper_ast ) );
      unsigned gib_flags = C_GIB_DECL;
      if ( opt_semicolon )
        gib_flags |= C_GIB_FINAL_SEMI;
      c_ast_gibberish( oper_ast, gib_flags, stdout );
      PUTC( '\n' );
    ;}
    break;

  case 28:
#line 2092 "parser.y"
    {
      DUMP_START( "declare_command",
                  "DECLARE storage_class_subset_english_type_opt "
                  "LAMBDA capturing_paren_capture_decl_list_english_opt "
                  "paren_param_decl_list_english_opt"
                  "returning_english_ast_opt" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[(2) - (6)].type) );
      DUMP_AST_LIST( "capturing_paren_capture_decl_list_english_opt", (yyvsp[(4) - (6)].ast_list) );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[(5) - (6)].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[(6) - (6)].ast) );

      c_ast_t *const lambda_ast = c_ast_new_gc( K_LAMBDA, &(yyloc) );
      lambda_ast->type = (yyvsp[(2) - (6)].type);
      lambda_ast->lambda.capture_ast_list = slist_move( &(yyvsp[(4) - (6)].ast_list) );
      lambda_ast->lambda.param_ast_list = slist_move( &(yyvsp[(5) - (6)].ast_list) );
      c_ast_set_parent( (yyvsp[(6) - (6)].ast), lambda_ast );

      DUMP_AST( "declare_command", lambda_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( lambda_ast ) );
      c_ast_gibberish( lambda_ast, C_GIB_DECL, stdout );
      PUTC( '\n' );
    ;}
    break;

  case 29:
#line 2123 "parser.y"
    {
      c_type_t const  storage_type = (yyvsp[(2) - (9)].type);
      c_tid_t  const  cv_qual_stid = (yyvsp[(3) - (9)].tid);
      c_ast_t *const  ret_ast = (yyvsp[(9) - (9)].ast);

      DUMP_START( "declare_command",
                  "DECLARE storage_class_subset_english_type_opt "
                  "cv_qualifier_list_stid_opt "
                  "USER-DEFINED CONVERSION OPERATOR "
                  "of_scope_list_english_opt "
                  "RETURNING decl_english_ast" );
      DUMP_TYPE( "storage_class_subset_english_type_opt",
                 storage_type );
      DUMP_TID( "cv_qualifier_list_stid_opt", cv_qual_stid );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[(7) - (9)].sname) );
      DUMP_AST( "decl_english_ast", ret_ast );

      c_ast_t *const udc_ast = c_ast_new_gc( K_USER_DEF_CONVERSION, &(yyloc) );
      c_sname_set( &udc_ast->sname, &(yyvsp[(7) - (9)].sname) );
      udc_ast->type = c_type_or( &storage_type, &C_TYPE_LIT_S( cv_qual_stid ) );
      c_ast_set_parent( ret_ast, udc_ast );

      DUMP_AST( "declare_command", udc_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( udc_ast ) );
      unsigned gib_flags = C_GIB_DECL;
      if ( opt_semicolon )
        gib_flags |= C_GIB_FINAL_SEMI;
      c_ast_gibberish( udc_ast, gib_flags, stdout );
      PUTC( '\n' );
    ;}
    break;

  case 30:
#line 2157 "parser.y"
    {
      if ( OPT_LANG_IS( CPP_ANY ) )
        elaborate_error( "name or operator expected" );
      else
        elaborate_error( "name expected" );
    ;}
    break;

  case 32:
#line 2169 "parser.y"
    {
      (yyval.ast) = (yyvsp[(1) - (2)].ast);
      (yyval.ast)->align = (yyvsp[(2) - (2)].align);
      (yyval.ast)->loc = (yyloc);
    ;}
    break;

  case 33:
#line 2176 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we need to use the builtin union member now.
      //
      if ( !c_ast_is_bit_field_kind( (yyvsp[(1) - (2)].ast) ) ) {
        print_error( &(yylsp[(2) - (2)]),
          "bit-fields can be only of integral %stypes\n",
          OPT_LANG_IS( enum_BITFIELDS ) ? "or enumeration " : ""
        );
        PARSE_ABORT();
      }

      (yyval.ast) = (yyvsp[(1) - (2)].ast);
      (yyval.ast)->loc = (yyloc);
      (yyval.ast)->bit_field.bit_width = (yyvsp[(2) - (2)].uint_val);
    ;}
    break;

  case 34:
#line 2196 "parser.y"
    {
      (yyval.align).kind = C_ALIGNAS_EXPR;
      (yyval.align).loc = (yylsp[(1) - (3)]);
      (yyval.align).expr = STATIC_CAST( unsigned, (yyvsp[(2) - (3)].int_val) );
    ;}
    break;

  case 35:
#line 2202 "parser.y"
    {
      (yyval.align).kind = C_ALIGNAS_TYPE;
      (yyval.align).loc = (yylsp[(1) - (2)]);
      (yyval.align).type_ast = (yyvsp[(2) - (2)].ast);
    ;}
    break;

  case 36:
#line 2208 "parser.y"
    {
      MEM_ZERO( &(yyval.align) );
      (yyval.align).loc = (yylsp[(1) - (2)]);
      elaborate_error( "integer or type expected" );
    ;}
    break;

  case 40:
#line 2222 "parser.y"
    { slist_init( &(yyval.ast_list) ); ;}
    break;

  case 41:
#line 2224 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[(2) - (2)].ast_list);
    ;}
    break;

  case 42:
#line 2228 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[(2) - (3)].ast_list);
    ;}
    break;

  case 43:
#line 2235 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[(2) - (3)].ast_list);
    ;}
    break;

  case 44:
#line 2239 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[(2) - (3)].ast_list);
    ;}
    break;

  case 45:
#line 2243 "parser.y"
    {
      elaborate_error( "'[' or '(' expected\n" );
    ;}
    break;

  case 46:
#line 2249 "parser.y"
    { slist_init( &(yyval.ast_list) ); ;}
    break;

  case 48:
#line 2255 "parser.y"
    {
      DUMP_START( "capture_decl_list_english",
                  "capture_decl_list_english ',' capture_decl_english_ast" );
      DUMP_AST_LIST( "capture_decl_list_english", (yyvsp[(1) - (3)].ast_list) );
      DUMP_AST( "capture_decl_english_ast", (yyvsp[(3) - (3)].ast) );

      (yyval.ast_list) = (yyvsp[(1) - (3)].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[(3) - (3)].ast) );

      DUMP_AST_LIST( "capture_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 49:
#line 2269 "parser.y"
    {
      DUMP_START( "capture_decl_list_english",
                  "capture_decl_english_ast" );
      DUMP_AST( "capture_decl_english_ast", (yyvsp[(1) - (1)].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[(1) - (1)].ast) );

      DUMP_AST_LIST( "capture_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 50:
#line 2284 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_COPY;
    ;}
    break;

  case 51:
#line 2289 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    ;}
    break;

  case 52:
#line 2294 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[(3) - (3)].name) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    ;}
    break;

  case 57:
#line 2310 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we use 0 to mean "no bit-field."
      //
      if ( (yyvsp[(2) - (3)].int_val) == 0 ) {
        print_error( &(yylsp[(2) - (3)]), "bit-field width must be > 0\n" );
        PARSE_ABORT();
      }
      (yyval.uint_val) = STATIC_CAST( unsigned, (yyvsp[(2) - (3)].int_val) );
    ;}
    break;

  case 58:
#line 2323 "parser.y"
    { (yyval.type) = T_NONE; ;}
    break;

  case 59:
#line 2326 "parser.y"
    {
      DUMP_START( "storage_class_subset_english_type_opt",
                  "storage_class_subset_english_type_opt "
                  "storage_class_subset_english_type" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[(1) - (2)].type) );
      DUMP_TYPE( "storage_class_subset_english_type", (yyvsp[(2) - (2)].type) );

      (yyval.type) = (yyvsp[(1) - (2)].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[(2) - (2)].type), &(yylsp[(2) - (2)]) ) );

      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyval.type) );
      DUMP_END();
    ;}
    break;

  case 60:
#line 2342 "parser.y"
    { (yyval.type) = C_TYPE_LIT_A( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 61:
#line 2344 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) );
    ;}
    break;

  case 62:
#line 2365 "parser.y"
    {
      (yyval.tid) = (yyvsp[(2) - (2)].tid);
    ;}
    break;

  case 72:
#line 2377 "parser.y"
    { (yyval.tid) = TS_NOEXCEPT; ;}
    break;

  case 78:
#line 2383 "parser.y"
    { (yyval.tid) = TS_PURE_VIRTUAL | (yyvsp[(2) - (2)].tid); ;}
    break;

  case 79:
#line 2390 "parser.y"
    {
      c_ast_t *const ast = (yyvsp[(4) - (4)].ast);

      DUMP_START( "define_command",
                  "DEFINE sname_english AS decl_english_ast" );
      DUMP_SNAME( "sname", (yyvsp[(2) - (4)].sname) );
      DUMP_AST( "decl_english_ast", ast );

      c_sname_set( &ast->sname, &(yyvsp[(2) - (4)].sname) );

      if ( ast->kind == K_NAME ) {      // see the comment in "declare_command"
        assert( !c_sname_empty( &ast->sname ) );
        print_error_unknown_name( &(yylsp[(4) - (4)]), &ast->sname );
        PARSE_ABORT();
      }

      //
      // Explicitly add TS_TYPEDEF to prohibit cases like:
      //
      //      define eint as extern int
      //      define rint as register int
      //      define sint as static int
      //      ...
      //
      //  i.e., a defined type with a storage class.  Once the semantic checks
      // pass, remove the TS_TYPEDEF.
      //
      PARSE_ASSERT(
        c_type_add( &ast->type, &T_TS_TYPEDEF, &(yylsp[(4) - (4)]) ) && c_ast_check( ast )
      );
      PJL_IGNORE_RV( c_ast_take_type_any( ast, &T_TS_TYPEDEF ) );

      if ( c_tid_is_any( ast->type.btids, TB_ANY_SCOPE ) )
        c_sname_set_local_type( &ast->sname, &ast->type );
      c_sname_fill_in_namespaces( &ast->sname );

      DUMP_AST( "defined.ast", ast );
      DUMP_END();

      PARSE_ASSERT( c_sname_check( &ast->sname, &(yylsp[(2) - (4)]) ) );
      PARSE_ASSERT( add_type( ast, C_GIB_NONE ) );
    ;}
    break;

  case 92:
#line 2510 "parser.y"
    { in_attr.is_typename = true; ;}
    break;

  case 95:
#line 2531 "parser.y"
    {
      DUMP_START( "explain_command",
                  "EXPLAIN extern_linkage_c_stid_opt using_decl_c_ast" );
      DUMP_TID( "extern_linkage_c_stid_opt", (yyvsp[(2) - (3)].tid) );
      DUMP_AST( "using_decl_c_ast", (yyvsp[(3) - (3)].ast) );
      DUMP_END();

      PARSE_ASSERT( c_type_add_tid( &(yyvsp[(3) - (3)].ast)->type, (yyvsp[(2) - (3)].tid), &(yylsp[(2) - (3)]) ) );
      PARSE_ASSERT( c_ast_check( (yyvsp[(3) - (3)].ast) ) );
      c_ast_english( (yyvsp[(3) - (3)].ast), stdout );
    ;}
    break;

  case 96:
#line 2548 "parser.y"
    {
      print_error_unknown_name( &(yylsp[(2) - (2)]), &(yyvsp[(2) - (2)].sname) );
      c_sname_cleanup( &(yyvsp[(2) - (2)].sname) );
      PARSE_ABORT();
    ;}
    break;

  case 97:
#line 2555 "parser.y"
    {
      elaborate_error( "cast or declaration expected" );
    ;}
    break;

  case 98:
#line 2562 "parser.y"
    { //
      // Set our mode to deciphering gibberish into English and specifically
      // tell the lexer to return cdecl keywords (e.g., "func") as ordinary
      // names, otherwise gibberish like:
      //
      //      int func(void);
      //
      // would result in a parser error.
      //
      gibberish_to_english();
    ;}
    break;

  case 99:
#line 2578 "parser.y"
    { print_help( (yyvsp[(2) - (2)].help) ); ;}
    break;

  case 100:
#line 2582 "parser.y"
    { (yyval.help) = CDECL_HELP_COMMANDS; ;}
    break;

  case 101:
#line 2583 "parser.y"
    { (yyval.help) = CDECL_HELP_COMMANDS; ;}
    break;

  case 102:
#line 2584 "parser.y"
    { (yyval.help) = CDECL_HELP_ENGLISH;  ;}
    break;

  case 103:
#line 2585 "parser.y"
    { (yyval.help) = CDECL_HELP_OPTIONS;  ;}
    break;

  case 104:
#line 2587 "parser.y"
    {
      elaborate_error( "\"commands\", \"english\", or \"options\" expected" );
    ;}
    break;

  case 105:
#line 2595 "parser.y"
    { quit(); ;}
    break;

  case 107:
#line 2608 "parser.y"
    {
      PARSE_ASSERT( set_option( NULL, NULL, NULL, NULL ) );
    ;}
    break;

  case 111:
#line 2621 "parser.y"
    {
      bool const ok = set_option( (yyvsp[(1) - (2)].name), &(yylsp[(1) - (2)]), (yyvsp[(2) - (2)].str_val), &(yylsp[(2) - (2)]) );
      free( (yyvsp[(1) - (2)].name) );
      free( (yyvsp[(2) - (2)].str_val) );
      PARSE_ASSERT( ok );
    ;}
    break;

  case 112:
#line 2630 "parser.y"
    { (yyval.str_val) = NULL; ;}
    break;

  case 113:
#line 2631 "parser.y"
    { (yyval.str_val) = (yyvsp[(2) - (2)].name); (yyloc) = (yylsp[(2) - (2)]); ;}
    break;

  case 114:
#line 2633 "parser.y"
    {
      (yyval.str_val) = NULL;
      elaborate_error( "option value expected" );
    ;}
    break;

  case 115:
#line 2643 "parser.y"
    {
      DUMP_START( "show_command", "SHOW any_typedef show_format_opt" );
      DUMP_AST( "any_typedef.ast", (yyvsp[(2) - (3)].tdef)->ast );
      DUMP_INT( "show_format_opt", (yyvsp[(3) - (3)].flags) );
      DUMP_END();

      show_type( (yyvsp[(2) - (3)].tdef), (yyvsp[(3) - (3)].flags) );
    ;}
    break;

  case 116:
#line 2653 "parser.y"
    {
      DUMP_START( "show_command", "SHOW any_typedef AS show_format_exp" );
      DUMP_AST( "any_typedef.ast", (yyvsp[(2) - (4)].tdef)->ast );
      DUMP_INT( "show_format_exp", (yyvsp[(4) - (4)].flags) );
      DUMP_END();

      show_type( (yyvsp[(2) - (4)].tdef), (yyvsp[(4) - (4)].flags) );
    ;}
    break;

  case 117:
#line 2663 "parser.y"
    {
      show_type_info_t sti;
      sti_init( &sti, (yyvsp[(2) - (4)].flags), (yyvsp[(3) - (4)].name), (yyvsp[(4) - (4)].flags) );
      c_typedef_visit( &show_type_visitor, &sti );
      sti_cleanup( &sti );
      free( (yyvsp[(3) - (4)].name) );
    ;}
    break;

  case 118:
#line 2672 "parser.y"
    {
      show_type_info_t sti;
      sti_init( &sti, (yyvsp[(2) - (5)].flags), (yyvsp[(3) - (5)].name), (yyvsp[(5) - (5)].flags) );
      c_typedef_visit( &show_type_visitor, &sti );
      sti_cleanup( &sti );
      free( (yyvsp[(3) - (5)].name) );
    ;}
    break;

  case 119:
#line 2681 "parser.y"
    {
      static char const *const TYPE_COMMANDS_KNR[] = {
        L_define, L_struct, L_typedef, L_union, NULL
      };
      static char const *const TYPE_COMMANDS_C[] = {
        L_define, L_enum, L_struct, L_typedef, L_union, NULL
      };
      static char const *const TYPE_COMMANDS_CPP_WITHOUT_USING[] = {
        L_class, L_define, L_enum, L_struct, L_typedef, L_union, NULL
      };
      static char const *const TYPE_COMMANDS_CPP_WITH_USING[] = {
        L_class, L_define, L_enum, L_struct, L_typedef, L_union, L_using, NULL
      };

      char const *const *const type_commands =
        OPT_LANG_IS( C_KNR )             ? TYPE_COMMANDS_KNR :
        OPT_LANG_IS( C_ANY )             ? TYPE_COMMANDS_C :
        OPT_LANG_IS( using_DECLARATION ) ? TYPE_COMMANDS_CPP_WITH_USING :
                                           TYPE_COMMANDS_CPP_WITHOUT_USING;

      print_error( &(yylsp[(2) - (2)]), "\"%s\": not defined as type via ", (yyvsp[(2) - (2)].name) );
      fput_list( stderr, type_commands, /*gets=*/NULL );
      print_suggestions( DYM_C_TYPES, (yyvsp[(2) - (2)].name) );
      EPUTC( '\n' );
      free( (yyvsp[(2) - (2)].name) );
      PARSE_ABORT();
    ;}
    break;

  case 120:
#line 2710 "parser.y"
    {
      elaborate_error(
        "type name or \"all\", \"predefined\", or \"user\" expected"
      );
    ;}
    break;

  case 121:
#line 2718 "parser.y"
    { (yyval.flags) = C_GIB_NONE; ;}
    break;

  case 122:
#line 2719 "parser.y"
    { (yyval.flags) = C_GIB_TYPEDEF; ;}
    break;

  case 123:
#line 2721 "parser.y"
    {
      if ( UNSUPPORTED( using_DECLARATION ) ) {
        print_error( &(yylsp[(1) - (1)]),
          "\"using\" not supported%s\n",
          C_LANG_WHICH( using_DECLARATION )
        );
        PARSE_ABORT();
      }
      (yyval.flags) = C_GIB_USING;
    ;}
    break;

  case 125:
#line 2736 "parser.y"
    {
      if ( OPT_LANG_IS( using_DECLARATION ) )
        elaborate_error( "\"english\", \"typedef\", or \"using\" expected" );
      else
        elaborate_error( "\"english\" or \"typedef\" expected" );
    ;}
    break;

  case 126:
#line 2745 "parser.y"
    { (yyval.flags) = C_GIB_NONE; ;}
    break;

  case 128:
#line 2750 "parser.y"
    { (yyval.flags) = SHOW_USER_DEFINED_TYPES; ;}
    break;

  case 129:
#line 2752 "parser.y"
    {
      (yyval.flags) = SHOW_ALL_TYPES |
           ((yyvsp[(2) - (2)].flags) != 0 ? (yyvsp[(2) - (2)].flags) : SHOW_PREDEFINED_TYPES | SHOW_USER_DEFINED_TYPES);
    ;}
    break;

  case 130:
#line 2756 "parser.y"
    { (yyval.flags) = SHOW_PREDEFINED_TYPES; ;}
    break;

  case 131:
#line 2757 "parser.y"
    { (yyval.flags) = SHOW_USER_DEFINED_TYPES; ;}
    break;

  case 132:
#line 2761 "parser.y"
    { (yyval.flags) = 0; ;}
    break;

  case 133:
#line 2762 "parser.y"
    { (yyval.flags) = SHOW_PREDEFINED_TYPES; ;}
    break;

  case 134:
#line 2763 "parser.y"
    { (yyval.flags) = SHOW_USER_DEFINED_TYPES; ;}
    break;

  case 138:
#line 2792 "parser.y"
    {
      ia_type_ast_push( (yyvsp[(2) - (2)].ast) );
    ;}
    break;

  case 139:
#line 2796 "parser.y"
    {
      ia_type_ast_pop();

      c_ast_t *const  type_ast = (yyvsp[(2) - (6)].ast);
      c_ast_t *const  decl_ast = (yyvsp[(4) - (6)].ast_pair).ast;

      DUMP_START( "explain_command",
                  "EXPLAIN '(' type_c_ast cast_c_astp_opt ')' sname_c_opt" );
      DUMP_AST( "type_c_ast", type_ast );
      DUMP_AST( "cast_c_astp_opt", decl_ast );
      DUMP_SNAME( "sname_c_opt", (yyvsp[(6) - (6)].sname) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[(6) - (6)].sname) );
      cast_ast->cast.kind = C_CAST_C;
      cast_ast->cast.to_ast = c_ast_patch_placeholder( type_ast, decl_ast );

      DUMP_AST( "explain_command", cast_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_english( cast_ast, stdout );
    ;}
    break;

  case 141:
#line 2836 "parser.y"
    {
      ia_type_ast_push( (yyvsp[(3) - (3)].ast) );
    ;}
    break;

  case 142:
#line 2840 "parser.y"
    {
      ia_type_ast_pop();

      c_cast_kind_t const cast_kind = (yyvsp[(1) - (9)].cast_kind);
      char const   *const cast_literal = c_cast_english( cast_kind );
      c_ast_t      *const type_ast = (yyvsp[(3) - (9)].ast);
      c_ast_t      *const decl_ast = (yyvsp[(5) - (9)].ast_pair).ast;

      DUMP_START( "explain_command",
                  "EXPLAIN new_style_cast_c"
                  "'<' type_c_ast cast_c_astp_opt '>' '(' sname ')'" );
      DUMP_STR( "new_style_cast_c", cast_literal );
      DUMP_AST( "type_c_ast", type_ast );
      DUMP_AST( "cast_c_astp_opt", decl_ast );
      DUMP_SNAME( "sname", (yyvsp[(8) - (9)].sname) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[(8) - (9)].sname) );
      cast_ast->cast.kind = cast_kind;
      cast_ast->cast.to_ast = c_ast_patch_placeholder( type_ast, decl_ast );

      DUMP_AST( "explain_command", cast_ast );
      DUMP_END();

      if ( UNSUPPORTED( CPP_ANY ) ) {
        print_error( &(yylsp[(1) - (9)]),
          "%s_cast not supported%s\n",
          cast_literal, C_LANG_WHICH( CPP_ANY )
        );
        PARSE_ABORT();
      }

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_english( cast_ast, stdout );
    ;}
    break;

  case 143:
#line 2878 "parser.y"
    { (yyval.cast_kind) = C_CAST_CONST;        ;}
    break;

  case 144:
#line 2879 "parser.y"
    { (yyval.cast_kind) = C_CAST_DYNAMIC;      ;}
    break;

  case 145:
#line 2880 "parser.y"
    { (yyval.cast_kind) = C_CAST_REINTERPRET;  ;}
    break;

  case 146:
#line 2881 "parser.y"
    { (yyval.cast_kind) = C_CAST_STATIC;       ;}
    break;

  case 147:
#line 2891 "parser.y"
    { in_attr.align = (yyvsp[(1) - (1)].align); ;}
    break;

  case 148:
#line 2892 "parser.y"
    { in_attr.is_typename = (yyvsp[(3) - (3)].flag); ;}
    break;

  case 150:
#line 2898 "parser.y"
    {
      DUMP_START( "alignas_specifier_c", "ALIGNAS '(' Y_INT_LIT ')'" );
      DUMP_INT( "INT_LIT", (yyvsp[(3) - (4)].int_val) );
      DUMP_END();

      (yyval.align).kind = C_ALIGNAS_EXPR;
      (yyval.align).loc = (yylsp[(1) - (4)]);
      (yyval.align).expr = STATIC_CAST( unsigned, (yyvsp[(3) - (4)].int_val) );
    ;}
    break;

  case 151:
#line 2908 "parser.y"
    { ia_type_ast_push( (yyvsp[(3) - (3)].ast) ); ;}
    break;

  case 152:
#line 2910 "parser.y"
    {
      ia_type_ast_pop();

      c_ast_t *const  type_ast = (yyvsp[(3) - (6)].ast);
      c_ast_t *const  cast_ast = (yyvsp[(5) - (6)].ast_pair).ast;

      DUMP_START( "alignas_specifier_c",
                  "ALIGNAS '(' type_c_ast cast_c_astp_opt ')'" );
      DUMP_AST( "type_c_ast", type_ast );
      DUMP_AST( "cast_c_astp_opt", cast_ast );
      DUMP_END();

      (yyval.align).kind = C_ALIGNAS_TYPE;
      (yyval.align).loc = (yylsp[(1) - (6)]);
      (yyval.align).type_ast = c_ast_patch_placeholder( type_ast, cast_ast );
    ;}
    break;

  case 153:
#line 2928 "parser.y"
    {
      elaborate_error( "integer or type expected" );
    ;}
    break;

  case 156:
#line 2942 "parser.y"
    {
      free( (yyvsp[(3) - (4)].str_val) );
      print_error( &(yylsp[(1) - (4)]), "asm declarations not supported by %s\n", CDECL );
      PARSE_ABORT();
    ;}
    break;

  case 160:
#line 2962 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[(1) - (1)]) ) );
      gibberish_to_english();           // see the comment in "explain"
    ;}
    break;

  case 161:
#line 2967 "parser.y"
    {
      c_tid_t const csu_btid = (yyvsp[(1) - (3)].tid);

      c_type_t const *const cur_type =
        c_sname_local_type( &in_attr.current_scope );
      if ( c_tid_is_any( cur_type->btids, TB_ANY_CLASS ) ) {
        char const *const cur_name =
          c_sname_local_name( &in_attr.current_scope );
        char const *const mbr_name = c_sname_local_name( &(yyvsp[(3) - (3)].sname) );
        if ( strcmp( mbr_name, cur_name ) == 0 ) {
          print_error( &(yylsp[(3) - (3)]),
            "\"%s\": member has the same name as its enclosing %s\n",
            mbr_name, c_type_name_c( cur_type )
          );
          c_sname_cleanup( &(yyvsp[(3) - (3)].sname) );
          PARSE_ABORT();
        }
      }

      DUMP_START( "class_struct_union_declaration_c",
                  "class_struct_union_btid sname '{' "
                  "in_scope_declaration_c_opt "
                  "'}' ';'" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_TID( "class_struct_union_btid", csu_btid );
      DUMP_SNAME( "any_sname_c", (yyvsp[(3) - (3)].sname) );

      c_sname_append_sname( &in_attr.current_scope, &(yyvsp[(3) - (3)].sname) );
      c_sname_set_local_type(
        &in_attr.current_scope, &C_TYPE_LIT_B( csu_btid )
      );
      PARSE_ASSERT( c_sname_check( &in_attr.current_scope, &(yylsp[(3) - (3)]) ) );

      c_ast_t *const csu_ast = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yylsp[(3) - (3)]) );
      csu_ast->sname = c_sname_dup( &in_attr.current_scope );
      c_sname_append_name(
        &csu_ast->csu.csu_sname,
        check_strdup( c_sname_local_name( &in_attr.current_scope ) )
      );
      csu_ast->type.btids = c_tid_check( csu_btid, C_TPID_BASE );

      DUMP_AST( "class_struct_union_declaration_c", csu_ast );
      DUMP_END();

      PARSE_ASSERT( add_type( csu_ast, C_GIB_TYPEDEF ) );
    ;}
    break;

  case 163:
#line 3021 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[(1) - (1)]) ) );
      gibberish_to_english();           // see the comment in "explain"
    ;}
    break;

  case 164:
#line 3026 "parser.y"
    {
      c_tid_t  const  enum_btid = (yyvsp[(1) - (4)].tid);
      c_ast_t *const  fixed_type_ast = (yyvsp[(4) - (4)].ast);

      DUMP_START( "enum_declaration_c", "enum_btid sname ';'" );
      DUMP_TID( "enum_btid", enum_btid );
      DUMP_SNAME( "any_sname_c", (yyvsp[(3) - (4)].sname) );
      DUMP_AST( "enum_fixed_type_c_ast_opt", fixed_type_ast );

      c_sname_t enum_sname = c_sname_dup( &in_attr.current_scope );
      c_sname_append_sname( &enum_sname, &(yyvsp[(3) - (4)].sname) );
      c_sname_set_local_type( &enum_sname, &C_TYPE_LIT_B( enum_btid ) );
      if ( !c_sname_check( &enum_sname, &(yylsp[(3) - (4)]) ) ) {
        c_sname_cleanup( &enum_sname );
        PARSE_ABORT();
      }

      c_ast_t *const enum_ast = c_ast_new_gc( K_ENUM, &(yylsp[(3) - (4)]) );
      enum_ast->sname = enum_sname;
      enum_ast->type.btids = c_tid_check( enum_btid, C_TPID_BASE );
      enum_ast->enum_.of_ast = fixed_type_ast;
      c_sname_append_name(
        &enum_ast->enum_.enum_sname,
        check_strdup( c_sname_local_name( &enum_sname ) )
      );

      DUMP_AST( "enum_declaration_c", enum_ast );
      DUMP_END();

      PARSE_ASSERT( add_type( enum_ast, C_GIB_TYPEDEF ) );
    ;}
    break;

  case 165:
#line 3064 "parser.y"
    {
      gibberish_to_english();           // see the comment in "explain"
    ;}
    break;

  case 166:
#line 3068 "parser.y"
    {
      c_type_t const ns_type = (yyvsp[(1) - (3)].type);

      DUMP_START( "namespace_declaration_c",
                  "namespace_type sname '{' "
                  "in_scope_declaration_c_opt "
                  "'}' [';']" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_TYPE( "namespace_type", ns_type );
      DUMP_SNAME( "any_sname_c", (yyvsp[(3) - (3)].sname) );
      DUMP_END();

      //
      // Nested namespace declarations are supported only in C++17 and later.
      // (However, we always allow them in configuration files.)
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the AST has no "memory" of how a namespace was
      // constructed.
      //
      if ( c_sname_count( &(yyvsp[(3) - (3)].sname) ) > 1 && UNSUPPORTED( NESTED_namespace ) ) {
        print_error( &(yylsp[(3) - (3)]),
          "nested namespace declarations not supported%s\n",
          C_LANG_WHICH( NESTED_namespace )
        );
        c_sname_cleanup( &(yyvsp[(3) - (3)].sname) );
        PARSE_ABORT();
      }

      //
      // The namespace type (plain namespace or inline namespace) has to be
      // split across the namespace sname: only the storage classes (for
      // TS_INLINE) has to be or'd with the first scope-type of the sname ...
      //
      c_type_t const *const sname_first_type = c_sname_first_type( &(yyvsp[(3) - (3)].sname) );
      c_sname_set_first_type(
        &(yyvsp[(3) - (3)].sname),
        &C_TYPE_LIT(
          sname_first_type->btids,
          sname_first_type->stids | ns_type.stids,
          sname_first_type->atids
        )
      );
      //
      // ... and only the base types (for TB_NAMESPACE) has to be or'd with the
      // local scope type of the sname.
      //
      c_type_t const *const sname_local_type = c_sname_local_type( &(yyvsp[(3) - (3)].sname) );
      c_sname_set_local_type(
        &(yyvsp[(3) - (3)].sname),
        &C_TYPE_LIT(
          sname_local_type->btids | ns_type.btids,
          sname_local_type->stids,
          sname_local_type->atids
        )
      );

      c_sname_append_sname( &in_attr.current_scope, &(yyvsp[(3) - (3)].sname) );
      PARSE_ASSERT( c_sname_check( &in_attr.current_scope, &(yylsp[(3) - (3)]) ) );
    ;}
    break;

  case 170:
#line 3135 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    ;}
    break;

  case 171:
#line 3148 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "sname_c '::' NAME" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_STR( "name", (yyvsp[(3) - (3)].name) );

      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[(3) - (3)].name) );
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_NAMESPACE ) );

      DUMP_SNAME( "namespace_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 172:
#line 3162 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "namespace_sname_c '::' any_typedef" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_AST( "any_typedef.ast", (yyvsp[(3) - (3)].tdef)->ast );

      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_NAMESPACE ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[(3) - (3)].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "namespace_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 173:
#line 3177 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "sname_c '::' NAME INLINE NAME" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[(1) - (4)].sname) );
      DUMP_STR( "name", (yyvsp[(4) - (4)].name) );

      (yyval.sname) = (yyvsp[(1) - (4)].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[(4) - (4)].name) );
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT( TB_NAMESPACE, (yyvsp[(3) - (4)].tid), TA_NONE ) );

      DUMP_SNAME( "namespace_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 174:
#line 3191 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "NAME" );
      DUMP_STR( "NAME", (yyvsp[(1) - (1)].name) );

      c_sname_init_name( &(yyval.sname), (yyvsp[(1) - (1)].name) );
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_NAMESPACE ) );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 175:
#line 3210 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' sname_c" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_SNAME( "sname_c", (yyvsp[(3) - (3)].sname) );

      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_append_sname( &(yyval.sname), &(yyvsp[(3) - (3)].sname) );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 176:
#line 3224 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' any_typedef" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_AST( "any_typedef", (yyvsp[(3) - (3)].tdef)->ast );

      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_set_local_type( &(yyval.sname), c_sname_local_type( &(yyvsp[(3) - (3)].tdef)->ast->sname ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[(3) - (3)].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 177:
#line 3240 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' INLINE NAME" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[(1) - (4)].sname) );
      DUMP_STR( "name", (yyvsp[(4) - (4)].name) );

      (yyval.sname) = (yyvsp[(1) - (4)].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[(4) - (4)].name) );
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT( TB_NAMESPACE, (yyvsp[(3) - (4)].tid), TA_NONE ) );

      DUMP_SNAME( "namespace_typedef_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 178:
#line 3254 "parser.y"
    { (yyval.sname) = c_sname_dup( &(yyvsp[(1) - (1)].tdef)->ast->sname ); ;}
    break;

  case 180:
#line 3260 "parser.y"
    {
      punct_expected( '{' );
    ;}
    break;

  case 188:
#line 3280 "parser.y"
    {
      elaborate_error( "declaration expected" );
    ;}
    break;

  case 189:
#line 3290 "parser.y"
    {
      c_ast_t *const ret_ast = (yyvsp[(6) - (6)].ast);
      c_type_t const type = (yyvsp[(5) - (6)].type);

      DUMP_START( "lambda_declaration_c",
                  "'[' capture_decl_list_c_opt ']' "
                  "lambda_param_c_ast_list_opt "
                  "lambda_return_type_c_ast_opt" );
      DUMP_AST_LIST( "capture_decl_list_c_opt", (yyvsp[(2) - (6)].ast_list) );
      DUMP_AST_LIST( "lambda_param_c_ast_list_opt", (yyvsp[(4) - (6)].ast_list) );
      DUMP_TYPE( "storage_class_subset_english_type_opt", type );
      DUMP_AST( "lambda_return_type_c_ast_opt", ret_ast );

      c_ast_t *const lambda_ast = c_ast_new_gc( K_LAMBDA, &(yyloc) );
      lambda_ast->type = type;
      lambda_ast->lambda.capture_ast_list = slist_move( &(yyvsp[(2) - (6)].ast_list) );
      lambda_ast->lambda.param_ast_list = slist_move( &(yyvsp[(4) - (6)].ast_list) );
      c_ast_set_parent( ret_ast, lambda_ast );

      DUMP_AST( "lambda_declaration_c", lambda_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( lambda_ast ) );
      c_ast_english( lambda_ast, stdout );
    ;}
    break;

  case 190:
#line 3318 "parser.y"
    { slist_init( &(yyval.ast_list) ); ;}
    break;

  case 192:
#line 3324 "parser.y"
    {
      DUMP_START( "capture_decl_list_c",
                  "capture_decl_list_c ',' "
                  "capture_decl_c_ast" );
      DUMP_AST_LIST( "capture_decl_list_c", (yyvsp[(1) - (3)].ast_list) );
      DUMP_AST( "capture_decl_c_ast", (yyvsp[(3) - (3)].ast) );

      (yyval.ast_list) = (yyvsp[(1) - (3)].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[(3) - (3)].ast) );

      DUMP_AST_LIST( "capture_decl_list_c", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 193:
#line 3339 "parser.y"
    {
      DUMP_START( "capture_decl_list_c",
                  "capture_decl_c_ast" );
      DUMP_AST( "capture_decl_c_ast", (yyvsp[(1) - (1)].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[(1) - (1)].ast) );

      DUMP_AST_LIST( "capture_decl_list_c", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 194:
#line 3354 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    ;}
    break;

  case 195:
#line 3359 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[(2) - (2)].name) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    ;}
    break;

  case 196:
#line 3365 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_COPY;
    ;}
    break;

  case 197:
#line 3370 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[(1) - (1)].name) );
    ;}
    break;

  case 198:
#line 3375 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_THIS;
    ;}
    break;

  case 199:
#line 3380 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_STAR_THIS;
    ;}
    break;

  case 200:
#line 3387 "parser.y"
    { slist_init( &(yyval.ast_list) ); ;}
    break;

  case 201:
#line 3388 "parser.y"
    { (yyval.ast_list) = (yyvsp[(2) - (3)].ast_list); ;}
    break;

  case 202:
#line 3392 "parser.y"
    { (yyval.ast) = NULL; ;}
    break;

  case 203:
#line 3393 "parser.y"
    { ia_type_ast_push( (yyvsp[(2) - (2)].ast) ); ;}
    break;

  case 204:
#line 3394 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "lambda_return_type_c_ast_opt",
                  "type_c_ast cast_c_astp_opt" );
      DUMP_AST( "type_c_ast", (yyvsp[(2) - (4)].ast) );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(4) - (4)].ast_pair).ast );

      (yyval.ast) = (yyvsp[(4) - (4)].ast_pair).ast != NULL ? (yyvsp[(4) - (4)].ast_pair).ast : (yyvsp[(2) - (4)].ast);

      DUMP_AST( "lambda_return_type_c_ast_opt", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 205:
#line 3413 "parser.y"
    {
      print_error( &(yylsp[(1) - (1)]), "template declarations not supported by %s\n", CDECL );
      PARSE_ABORT();
    ;}
    break;

  case 206:
#line 3422 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 207:
#line 3423 "parser.y"
    {
      ia_type_ast_pop();
    ;}
    break;

  case 208:
#line 3432 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[(1) - (2)]) ) );
      in_attr.is_typename = (yyvsp[(2) - (2)].flag);
      gibberish_to_english();           // see the comment in "explain"
    ;}
    break;

  case 209:
#line 3438 "parser.y"
    {
      c_ast_t *const type_ast = (yyvsp[(4) - (4)].ast);

      PARSE_ASSERT( !in_attr.is_typename || c_ast_is_typename_ok( type_ast ) );
      // see the comment in "define_command" about TS_TYPEDEF
      PARSE_ASSERT( c_type_add_tid( &type_ast->type, TS_TYPEDEF, &(yylsp[(4) - (4)]) ) );

      //
      // We have to keep a pristine copy of the AST for the base type of the
      // typedef being declared in case multiple types are defined in the same
      // typedef.  For example, given:
      //
      //      typedef int I, *PI;
      //              ^
      // the "int" is the base type that needs to get patched twice to form two
      // types: I and PI.  Hence, we keep a pristine copy and then duplicate it
      // so every type gets a pristine copy.
      //
      assert( slist_empty( &in_attr.typedef_ast_list ) );
      slist_push_list_back( &in_attr.typedef_ast_list, &gc_ast_list );
      in_attr.typedef_ast = type_ast;
      ia_type_ast_push( c_ast_dup( in_attr.typedef_ast, &gc_ast_list ) );
    ;}
    break;

  case 210:
#line 3462 "parser.y"
    {
      ia_type_ast_pop();
    ;}
    break;

  case 211:
#line 3469 "parser.y"
    { //
      // We're defining another type in the same typedef so we need to replace
      // the current type AST inherited attribute with a new duplicate of the
      // pristine one we kept earlier.
      //
      ia_type_ast_pop();
      ia_type_ast_push( c_ast_dup( in_attr.typedef_ast, &gc_ast_list ) );
    ;}
    break;

  case 214:
#line 3485 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();
      c_ast_t *const decl_ast = (yyvsp[(1) - (1)].ast_pair).ast;

      DUMP_START( "typedef_decl_c", "decl_c_astp" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "decl_c_astp", decl_ast );

      c_ast_t *typedef_ast;
      c_sname_t temp_sname;

      if ( decl_ast->kind == K_TYPEDEF ) {
        //
        // This is for either of the following cases:
        //
        //      typedef int int32_t;
        //      typedef int32_t int_least32_t;
        //
        // that is: any type name followed by an existing typedef name.
        //
        typedef_ast = type_ast;
        if ( c_sname_empty( &typedef_ast->sname ) )
          typedef_ast->sname = c_sname_dup( &decl_ast->tdef.for_ast->sname );
      }
      else {
        //
        // This is for either of the following cases:
        //
        //      typedef int foo;
        //      typedef int32_t foo;
        //
        // that is: any type name followed by a new name.
        //
        typedef_ast = c_ast_patch_placeholder( type_ast, decl_ast );
        temp_sname = c_ast_take_name( decl_ast );
        c_sname_set( &typedef_ast->sname, &temp_sname );
      }

      PARSE_ASSERT( c_ast_check( typedef_ast ) );
      // see the comment in "define_command" about TS_TYPEDEF
      PJL_IGNORE_RV( c_ast_take_type_any( typedef_ast, &T_TS_TYPEDEF ) );

      if ( c_sname_count( &typedef_ast->sname ) > 1 ) {
        print_error( &(yylsp[(1) - (1)]),
          "typedef names can not be scoped; "
          "use: namespace %s { typedef ... }\n",
          c_sname_scope_name( &typedef_ast->sname )
        );
        PARSE_ABORT();
      }

      temp_sname = c_sname_dup( &in_attr.current_scope );
      c_sname_prepend_sname( &typedef_ast->sname, &temp_sname );

      DUMP_AST( "typedef_decl_c", typedef_ast );
      DUMP_END();

      PARSE_ASSERT( add_type( typedef_ast, C_GIB_TYPEDEF  ) );
    ;}
    break;

  case 216:
#line 3550 "parser.y"
    {
      elaborate_error( "type expected" );
    ;}
    break;

  case 217:
#line 3559 "parser.y"
    {
      DUMP_START( "user_defined_conversion_declaration_c",
                  "user_defined_conversion_decl_c_astp" );
      DUMP_AST( "user_defined_conversion_declaration_c", (yyvsp[(1) - (1)].ast_pair).ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( (yyvsp[(1) - (1)].ast_pair).ast ) );
      c_ast_english( (yyvsp[(1) - (1)].ast_pair).ast, stdout );
    ;}
    break;

  case 218:
#line 3574 "parser.y"
    {
      // see the comment in "define_command" about TS_TYPEDEF
      PJL_IGNORE_RV( c_ast_take_type_any( (yyvsp[(1) - (1)].ast), &T_TS_TYPEDEF ) );

      PARSE_ASSERT( add_type( (yyvsp[(1) - (1)].ast), C_GIB_USING ) );
    ;}
    break;

  case 219:
#line 3584 "parser.y"
    {
      gibberish_to_english();           // see the comment in "explain"
    ;}
    break;

  case 220:
#line 3588 "parser.y"
    {
      // see the comment in "define_command" about TS_TYPEDEF
      if ( !c_type_add_tid( &(yyvsp[(6) - (6)].ast)->type, TS_TYPEDEF, &(yylsp[(6) - (6)]) ) ) {
        free( (yyvsp[(3) - (6)].name) );
        PARSE_ABORT();
      }
      ia_type_ast_push( (yyvsp[(6) - (6)].ast) );
    ;}
    break;

  case 221:
#line 3597 "parser.y"
    {
      ia_type_ast_pop();

      char const *const name = (yyvsp[(3) - (8)].name);
      c_tid_t     const atids = (yyvsp[(4) - (8)].tid);
      c_ast_t    *const type_ast = (yyvsp[(6) - (8)].ast);
      c_ast_t    *const cast_ast = (yyvsp[(8) - (8)].ast_pair).ast;

      DUMP_START( "using_decl_c_ast",
                  "USING any_name_exp attribute_specifier_list_c_atid_opt '=' "
                  "type_c_ast cast_c_astp_opt" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_STR( "any_name_exp", name );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", atids );
      DUMP_AST( "type_c_ast", type_ast );
      DUMP_AST( "cast_c_astp_opt", cast_ast );

      //
      // Ensure the type on the right-hand side doesn't have a name, e.g.:
      //
      //      using U = void (*F)();    // error
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the patched AST loses the name.
      //
      c_sname_t const *const sname = c_ast_find_name( cast_ast, C_VISIT_DOWN );
      if ( sname != NULL ) {
        print_error( &cast_ast->loc, "\"using\" type can not have a name\n" );
        FREE( name );
        PARSE_ABORT();
      }

      c_sname_t temp_sname = c_sname_dup( &in_attr.current_scope );
      c_sname_append_name( &temp_sname, name );

      (yyval.ast) = c_ast_patch_placeholder( type_ast, cast_ast );
      c_sname_set( &(yyval.ast)->sname, &temp_sname );
      (yyval.ast)->type.atids = c_tid_check( atids, C_TPID_ATTR );

      DUMP_AST( "using_decl_c_ast", (yyval.ast) );
      DUMP_END();

      //
      // Using declarations are supported only in C++11 and later.  (However,
      // we always allow them in configuration files.)
      //
      // This check has to be done now in the parser rather than later in the
      // AST because using declarations are treated like typedef declarations
      // and the AST has no "memory" that such a declaration was a using
      // declaration.
      //
      if ( UNSUPPORTED( using_DECLARATION ) ) {
        print_error( &(yylsp[(1) - (8)]),
          "\"using\" not supported%s\n",
          C_LANG_WHICH( using_DECLARATION )
        );
        PARSE_ABORT();
      }

      PARSE_ASSERT( c_ast_check( (yyval.ast) ) );
    ;}
    break;

  case 222:
#line 3672 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "decl_list_c_opt", "<empty>" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "decl_list_c_opt", type_ast );

      if ( (type_ast->kind & K_ENUM_CLASS_STRUCT_UNION) == 0 ) {
        //
        // The declaration is a non-ECSU type, e.g.:
        //
        //      int
        //
        c_loc_t const loc = lexer_loc();
        print_error( &loc, "declaration expected\n" );
        PARSE_ABORT();
      }

      c_sname_t const *const ecsu_sname = &type_ast->csu.csu_sname;
      assert( !c_sname_empty( ecsu_sname ) );

      if ( c_sname_count( ecsu_sname ) > 1 ) {
        print_error( &type_ast->loc,
          "forward declaration can not have a scoped name\n"
        );
        PARSE_ABORT();
      }

      c_sname_t temp_sname = c_sname_dup( ecsu_sname );
      c_sname_set( &type_ast->sname, &temp_sname );

      DUMP_AST( "decl_list_c_opt", type_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( type_ast ) );
      c_typedef_english( &C_TYPEDEF_AST_LIT( type_ast ), stdout );
      PUTC( '\n' );
    ;}
    break;

  case 226:
#line 3722 "parser.y"
    { //
      // The type has to be duplicated to guarantee a fresh type AST in case
      // we're doing multiple declarations, e.g.:
      //
      //    explain int *p, *q
      //
      c_ast_t *const type_ast = c_ast_dup( ia_type_ast_peek(), &gc_ast_list );
      c_ast_t *const decl_ast = (yyvsp[(1) - (1)].ast_pair).ast;

      DUMP_START( "decl_c", "decl_c_astp" );
      switch ( in_attr.align.kind ) {
        case C_ALIGNAS_NONE:
          break;
        case C_ALIGNAS_EXPR:
          DUMP_INT( "in_attr__alignas_specifier_c_expr", in_attr.align.expr );
          break;
        case C_ALIGNAS_TYPE:
          DUMP_AST(
            "in_attr__alignas_specifier_c_type_ast", in_attr.align.type_ast
          );
          break;
      } // switch
      DUMP_BOOL( "in_attr__typename_flag_opt", in_attr.is_typename );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "decl_c_astp", decl_ast );

      c_ast_t const *const ast = join_type_decl( type_ast, decl_ast );

      DUMP_AST( "decl_c", ast );
      DUMP_END();

      PARSE_ASSERT( ast != NULL );
      PARSE_ASSERT( c_ast_check( ast ) );

      if ( !c_sname_empty( &ast->sname ) ) {
        //
        // For declarations that have a name, ensure that it's not used more
        // than once in the same declaration in C++ or with different types in
        // C.  (In C, more than once with the same type are "tentative
        // definitions" and OK.)
        //
        //      int i, i;               // OK in C (same type); error in C++
        //      int j, *j;              // error (different types)
        //
        FOREACH_SLIST_NODE( node, &decl_ast_list ) {
          c_ast_t const *const prev_ast = node->data;
          if ( c_sname_cmp( &ast->sname, &prev_ast->sname ) != 0 )
            continue;
          if ( OPT_LANG_IS( CPP_ANY ) ) {
            print_error( &ast->loc,
              "\"%s\": redefinition\n",
              c_sname_full_name( &ast->sname )
            );
            PARSE_ABORT();
          }
          else if ( !c_ast_equal( ast, prev_ast ) ) {
            print_error( &ast->loc,
              "\"%s\": redefinition with different type\n",
              c_sname_full_name( &ast->sname )
            );
            PARSE_ABORT();
          }
        } // for
        slist_push_back( &decl_ast_list, CONST_CAST( void*, ast ) );
      }

      c_ast_english( ast, stdout );

      //
      // The type's AST takes on the name of the thing being declared, e.g.:
      //
      //      int x
      //
      // makes the type_ast (kind = "built-in type", type = "int") take on the
      // name of "x" so it'll be explained as:
      //
      //      declare x as int
      //
      // Once explained, the name must be cleared for the subsequent
      // declaration (if any) in the same declaration statement, e.g.:
      //
      //      int x, y
      //
      c_sname_cleanup( &type_ast->sname );
    ;}
    break;

  case 228:
#line 3812 "parser.y"
    {
      elaborate_error( "declaration expected" );
    ;}
    break;

  case 233:
#line 3823 "parser.y"
    {
      (yyval.ast_pair) = (yyvsp[(2) - (2)].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);
      (yyval.ast_pair).ast->type.atids |= (yyvsp[(1) - (2)].tid);
    ;}
    break;

  case 241:
#line 3842 "parser.y"
    {
      (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[(1) - (2)].ast), NULL };
    ;}
    break;

  case 242:
#line 3845 "parser.y"
    { (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[(1) - (1)].ast), NULL }; ;}
    break;

  case 245:
#line 3855 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();
      c_ast_t *const decl_ast = (yyvsp[(1) - (3)].ast_pair).ast;
      c_ast_t *const array_ast = (yyvsp[(2) - (3)].ast);

      DUMP_START( "array_decl_c_astp", "decl2_c_astp array_size_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "decl2_c_astp", decl_ast );
      DUMP_AST( "target_ast", (yyvsp[(1) - (3)].ast_pair).target_ast );
      DUMP_AST( "array_size_c_ast", array_ast );

      c_ast_set_parent( c_ast_new_gc( K_PLACEHOLDER, &(yylsp[(1) - (3)]) ), array_ast );

      if ( (yyvsp[(1) - (3)].ast_pair).target_ast != NULL ) {    // array-of or function-like-ret type
        (yyval.ast_pair).ast = decl_ast;
        (yyval.ast_pair).target_ast = c_ast_add_array( (yyvsp[(1) - (3)].ast_pair).target_ast, array_ast, type_ast );
      } else {
        (yyval.ast_pair).ast = c_ast_add_array( decl_ast, array_ast, type_ast );
        (yyval.ast_pair).target_ast = NULL;
      }

      DUMP_AST( "array_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 246:
#line 3883 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.size = (yyvsp[(1) - (1)].int_val);
    ;}
    break;

  case 247:
#line 3888 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.size = C_ARRAY_SIZE_NONE;
      (yyval.ast)->array.stids = c_tid_check( (yyvsp[(2) - (3)].tid), C_TPID_STORE );
    ;}
    break;

  case 248:
#line 3894 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.size = (yyvsp[(4) - (5)].int_val);
      (yyval.ast)->array.stids = c_tid_check( (yyvsp[(2) - (5)].tid) | (yyvsp[(3) - (5)].tid), C_TPID_STORE );
    ;}
    break;

  case 249:
#line 3900 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.size = C_ARRAY_SIZE_VARIABLE;
      (yyval.ast)->array.stids = c_tid_check( (yyvsp[(2) - (4)].tid), C_TPID_STORE );
    ;}
    break;

  case 250:
#line 3906 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.size = (yyvsp[(4) - (5)].int_val);
      (yyval.ast)->array.stids = c_tid_check( (yyvsp[(2) - (5)].tid) | (yyvsp[(3) - (5)].tid), C_TPID_STORE );
    ;}
    break;

  case 251:
#line 3914 "parser.y"
    { (yyval.int_val) = C_ARRAY_SIZE_NONE; ;}
    break;

  case 252:
#line 3915 "parser.y"
    { (yyval.int_val) = (yyvsp[(2) - (3)].int_val); ;}
    break;

  case 253:
#line 3917 "parser.y"
    {
      elaborate_error( "integer expected for array size" );
    ;}
    break;

  case 254:
#line 3927 "parser.y"
    { //
      // A block AST has to be the type inherited attribute for decl_c_astp so
      // we have to create it here.
      //
      ia_type_ast_push( c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) ) );
    ;}
    break;

  case 255:
#line 3935 "parser.y"
    {
      c_ast_t *const  block_ast = ia_type_ast_pop();
      c_ast_t *const  type_ast = ia_type_ast_peek();
      c_tid_t  const  type_qual_stids = (yyvsp[(4) - (10)].tid);
      c_ast_t *const  decl_ast = (yyvsp[(5) - (10)].ast_pair).ast;

      DUMP_START( "block_decl_c_astp",
                  "'(' '^' type_qualifier_list_c_stid_opt decl_c_astp ')' "
                  "'(' param_c_ast_list_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", type_qual_stids );
      DUMP_AST( "decl_c_astp", decl_ast );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[(8) - (10)].ast_list) );

      PARSE_ASSERT( c_type_add_tid( &block_ast->type, type_qual_stids, &(yylsp[(4) - (10)]) ) );
      block_ast->block.param_ast_list = slist_move( &(yyvsp[(8) - (10)].ast_list) );
      (yyval.ast_pair).ast = c_ast_add_func( decl_ast, block_ast, type_ast );
      (yyval.ast_pair).target_ast = block_ast->block.ret_ast;

      DUMP_AST( "block_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 256:
#line 3968 "parser.y"
    {
      c_tid_t     const virtual_stid = (yyvsp[(1) - (8)].tid);
      char const *const name = (yyvsp[(3) - (8)].name);
      c_tid_t     const func_qual_stids = (yyvsp[(5) - (8)].tid);
      c_tid_t     const noexcept_stid = (yyvsp[(6) - (8)].tid);
      c_tid_t     const func_equals_stid = (yyvsp[(8) - (8)].tid);

      DUMP_START( "destructor_declaration_c",
                  "virtual_opt '~' NAME '(' ')' func_qualifier_list_c_stid_opt "
                  "noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt "
                  "func_equals_c_stid_opt" );
      DUMP_TID( "virtual_stid_opt", virtual_stid );
      DUMP_STR( "any_name_exp", name );
      DUMP_TID( "func_qualifier_list_c_stid_opt", func_qual_stids );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );
      DUMP_TID( "func_equals_c_stid_opt", func_equals_stid );

      c_ast_t *const ast = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );
      c_sname_append_name( &ast->sname, name );
      ast->type.stids = c_tid_check(
        virtual_stid | func_qual_stids | noexcept_stid | func_equals_stid,
        C_TPID_STORE
      );

      DUMP_AST( "destructor_declaration_c", ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ast ) );
      c_ast_english( ast, stdout );
    ;}
    break;

  case 257:
#line 4006 "parser.y"
    {
      c_tid_t const inline_stid = (yyvsp[(1) - (7)].tid);
      c_tid_t const func_qual_stids = (yyvsp[(5) - (7)].tid);
      c_tid_t const noexcept_stid = (yyvsp[(6) - (7)].tid);

      DUMP_START( "file_scope_constructor_declaration_c",
                  "inline_opt CONSTRUCTOR_SNAME '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt" );
      DUMP_TID( "inline_stid_opt", inline_stid );
      DUMP_SNAME( "CONSTRUCTOR_SNAME", (yyvsp[(2) - (7)].sname) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[(4) - (7)].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", func_qual_stids );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );

      c_sname_set_scope_type( &(yyvsp[(2) - (7)].sname), &C_TYPE_LIT_B( TB_CLASS ) );

      c_ast_t *const ast = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      ast->sname = c_sname_move( &(yyvsp[(2) - (7)].sname) );
      ast->type.stids = c_tid_check(
        inline_stid | func_qual_stids | noexcept_stid,
        C_TPID_STORE
      );
      ast->ctor.param_ast_list = slist_move( &(yyvsp[(4) - (7)].ast_list) );

      DUMP_AST( "file_scope_constructor_declaration_c", ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ast ) );
      c_ast_english( ast, stdout );
    ;}
    break;

  case 258:
#line 4044 "parser.y"
    {
      c_tid_t const inline_stid = (yyvsp[(1) - (6)].tid);
      c_tid_t const func_qual_stids = (yyvsp[(4) - (6)].tid);
      c_tid_t const noexcept_stid = (yyvsp[(5) - (6)].tid);

      DUMP_START( "file_scope_destructor_declaration_c",
                  "inline_opt DESTRUCTOR_SNAME '(' ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt" );
      DUMP_TID( "inline_stid_opt", inline_stid );
      DUMP_SNAME( "DESTRUCTOR_SNAME", (yyvsp[(2) - (6)].sname) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", func_qual_stids );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );

      c_sname_set_scope_type( &(yyvsp[(2) - (6)].sname), &C_TYPE_LIT_B( TB_CLASS ) );

      c_ast_t *const ast = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );
      ast->sname = c_sname_move( &(yyvsp[(2) - (6)].sname) );
      ast->type.stids = c_tid_check(
        inline_stid | func_qual_stids | noexcept_stid,
        C_TPID_STORE
      );

      DUMP_AST( "file_scope_destructor_declaration_c", ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ast ) );
      c_ast_english( ast, stdout );
    ;}
    break;

  case 259:
#line 4088 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();
      c_ast_t *const decl2_ast = (yyvsp[(1) - (8)].ast_pair).ast;
      c_tid_t  const func_qual_stid = (yyvsp[(4) - (8)].tid);
      c_tid_t  const func_ref_qual_stid = (yyvsp[(5) - (8)].tid);
      c_tid_t  const noexcept_stid = (yyvsp[(6) - (8)].tid);
      c_ast_t *const trailing_ret_ast = (yyvsp[(7) - (8)].ast);
      c_tid_t  const func_equals_stid = (yyvsp[(8) - (8)].tid);

      DUMP_START( "func_decl_c_astp",
                  "decl2_c_astp '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt "
                  "func_ref_qualifier_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "decl2_c_astp", decl2_ast );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[(3) - (8)].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", func_qual_stid );
      DUMP_TID( "func_ref_qualifier_c_stid_opt", func_ref_qual_stid );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );
      DUMP_AST( "trailing_return_type_c_ast_opt", trailing_ret_ast );
      DUMP_TID( "func_equals_c_stid_opt", func_equals_stid );
      DUMP_AST( "target_ast", (yyvsp[(1) - (8)].ast_pair).target_ast );

      c_tid_t const func_stid =
        func_qual_stid | func_ref_qual_stid | noexcept_stid | func_equals_stid;

      //
      // Cdecl can't know for certain whether a "function" name is really a
      // constructor name because it:
      //
      //  1. Doesn't have the context of the surrounding class:
      //
      //          class T {
      //          public:
      //            T();                // <-- All cdecl usually has is this.
      //            // ...
      //          };
      //
      //  2. Can't check to see if the name is a typedef for a class, struct,
      //     or union (even though that would greatly help) since:
      //
      //          T(U);
      //
      //     could be either:
      //
      //      + A constructor of type T with a parameter of type U; or:
      //      + A variable named U of type T (with unnecessary parentheses).
      //
      // Hence, we have to infer which of a function or a constructor was
      // likely the one meant.  Assume the declaration is for a constructor
      // only if:
      //
      bool const assume_constructor =

        // + The current language is C++.
        OPT_LANG_IS( CPP_ANY ) &&

        // + The existing base type is none (because constructors don't have
        //   return types).
        type_ast->type.btids == TB_NONE &&

        // + The existing type does _not_ have any non-constructor storage
        //   classes.
        !c_tid_is_any( type_ast->type.stids, TS_FUNC_LIKE_NOT_CTOR ) &&

        ( // + The existing type has any constructor-only storage-class-like
          //   types (e.g., explicit).
          c_tid_is_any( type_ast->type.stids, TS_CONSTRUCTOR_ONLY ) ||

          // + Or the existing type only has storage-class-like types that may
          //   be applied to constructors.
          is_1n_bit_only_in_set(
            c_tid_no_tpid( type_ast->type.stids ),
            c_tid_no_tpid( TS_CONSTRUCTOR_DECL )
          )
        ) &&

        // + The new type does _not_ have any non-constructor storage classes.
        !c_tid_is_any( func_stid, TS_FUNC_LIKE_NOT_CTOR );

      c_ast_t *const func_ast =
        c_ast_new_gc( assume_constructor ? K_CONSTRUCTOR : K_FUNCTION, &(yyloc) );
      func_ast->type.stids = c_tid_check( func_stid, C_TPID_STORE );
      func_ast->func.param_ast_list = slist_move( &(yyvsp[(3) - (8)].ast_list) );

      if ( assume_constructor ) {
        assert( trailing_ret_ast == NULL );
        (yyval.ast_pair).ast = c_ast_add_func( decl2_ast, func_ast, /*ret_ast=*/NULL );
      }
      else if ( (yyvsp[(1) - (8)].ast_pair).target_ast != NULL ) {
        (yyval.ast_pair).ast = decl2_ast;
        PJL_IGNORE_RV( c_ast_add_func( (yyvsp[(1) - (8)].ast_pair).target_ast, func_ast, type_ast ) );
      }
      else {
        (yyval.ast_pair).ast = c_ast_add_func(
          decl2_ast,
          func_ast,
          trailing_ret_ast != NULL ? trailing_ret_ast : type_ast
        );
      }

      (yyval.ast_pair).target_ast = func_ast->func.ret_ast;

      c_tid_t const msc_call_atids = (yyval.ast_pair).ast->type.atids & TA_ANY_MSC_CALL;
      if ( msc_call_atids != TA_NONE ) {
        //
        // Microsoft calling conventions need to be moved from the pointer to
        // the function, e.g., change:
        //
        //      declare f as cdecl pointer to function returning void
        //
        // to:
        //
        //      declare f as pointer to cdecl function returning void
        //
        for ( c_ast_t const *ast = (yyval.ast_pair).ast;
              (ast = c_ast_unpointer( ast )) != NULL; ) {
          if ( ast->kind == K_FUNCTION ) {
            (yyval.ast_pair).ast->type.atids &= c_tid_compl( TA_ANY_MSC_CALL );
            CONST_CAST( c_ast_t*, ast )->type.atids |= msc_call_atids;
          }
        } // for
      }

      DUMP_AST( "func_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 260:
#line 4228 "parser.y"
    {
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        //
        // In C++, encountering a name followed by '(' declares an in-class
        // constructor.  That means NAME is the name of a class, so we have to
        // create a temporary class type for it so if it's used as the type of
        // a parameter, e.g.:
        //
        //      C(C const&)
        //
        // it'll be recognized as such.
        //
        c_ast_t *const csu_ast = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yylsp[(1) - (2)]) );
        csu_ast->type.btids = TB_CLASS;
        c_sname_init_name( &csu_ast->csu.csu_sname, check_strdup( (yyvsp[(1) - (2)].name) ) );
        csu_ast->sname = c_sname_dup( &csu_ast->csu.csu_sname );

        in_attr.typedef_rb = c_typedef_add( csu_ast, C_GIB_TYPEDEF );
        MAYBE_UNUSED c_typedef_t *const csu_tdef = in_attr.typedef_rb->data;
        assert( csu_tdef->ast == csu_ast );
      }
    ;}
    break;

  case 261:
#line 4251 "parser.y"
    {
      char const *const name = (yyvsp[(1) - (7)].name);
      c_tid_t     const noexcept_stid = (yyvsp[(6) - (7)].tid);
      c_tid_t     const func_equals_stid = (yyvsp[(7) - (7)].tid);

      DUMP_START( "pc99_func_or_constructor_declaration_c",
                  "NAME '(' param_c_ast_list_opt ')' noexcept_c_stid_opt "
                  "func_equals_c_stid_opt" );
      DUMP_STR( "NAME", name );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[(4) - (7)].ast_list) );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );
      DUMP_TID( "func_equals_c_stid_opt", func_equals_stid );

      c_ast_t *ast;

      if ( OPT_LANG_IS( CPP_ANY ) ) {
        //
        // Free the temporary typedef for the class.
        //
        // Note that we free only the typedef and not its AST; its AST will be
        // garbage collected.
        //
        free( c_typedef_remove( in_attr.typedef_rb ) );

        //
        // In C++, encountering a name followed by '(' declares an in-class
        // constructor.
        //
        ast = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      }
      else {
        if ( UNSUPPORTED( IMPLICIT_int ) ) {
          //
          // In C99 and later, implicit int is an error.  This check has to be
          // done now in the parser rather than later in the AST since the AST
          // would have no "memory" that the return type was implicitly int.
          //
          print_error( &(yylsp[(1) - (7)]),
            "implicit \"int\" functions are illegal%s\n",
            C_LANG_WHICH( IMPLICIT_int )
          );
          FREE( name );
          PARSE_ABORT();
        }

        //
        // In C prior to C99, encountering a name followed by '(' declares a
        // function that implicitly returns int:
        //
        //      power(x, n)             /* raise x to n-th power; n > 0 */
        //
        c_ast_t *const ret_ast = c_ast_new_gc( K_BUILTIN, &(yylsp[(1) - (7)]) );
        ret_ast->type.btids = TB_INT;

        ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
        ast->func.ret_ast = ret_ast;
      }

      c_sname_init_name( &ast->sname, name );
      ast->type.stids =
        c_tid_check( noexcept_stid | func_equals_stid, C_TPID_STORE );
      ast->func.param_ast_list = slist_move( &(yyvsp[(4) - (7)].ast_list) );

      DUMP_AST( "pc99_func_or_constructor_declaration_c", ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ast ) );
      c_ast_english( ast, stdout );
    ;}
    break;

  case 262:
#line 4324 "parser.y"
    {
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        //
        // Both "final" and "override" are matched only within member function
        // declarations.  Now that ')' has been parsed, we're within one, so
        // set the keyword context to C_KW_CTX_MBR_FUNC.
        //
        lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
      }
    ;}
    break;

  case 263:
#line 4335 "parser.y"
    {
      lexer_keyword_ctx = C_KW_CTX_DEFAULT;
      (yyval.tid) = (yyvsp[(3) - (3)].tid);
    ;}
    break;

  case 264:
#line 4342 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 265:
#line 4344 "parser.y"
    {
      DUMP_START( "func_qualifier_list_c_stid_opt",
                  "func_qualifier_list_c_stid_opt func_qualifier_c_stid" );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[(1) - (2)].tid) );
      DUMP_TID( "func_qualifier_c_stid", (yyvsp[(2) - (2)].tid) );

      (yyval.tid) = (yyvsp[(1) - (2)].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[(2) - (2)].tid), &(yylsp[(2) - (2)]) ) );

      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyval.tid) );
      DUMP_END();
    ;}
    break;

  case 270:
#line 4373 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 271:
#line 4374 "parser.y"
    { (yyval.tid) = TS_REFERENCE; ;}
    break;

  case 272:
#line 4375 "parser.y"
    { (yyval.tid) = TS_RVALUE_REFERENCE; ;}
    break;

  case 273:
#line 4379 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 275:
#line 4382 "parser.y"
    {
      (yyval.tid) = (yyvsp[(3) - (4)].tid);
    ;}
    break;

  case 276:
#line 4386 "parser.y"
    {
      (yyval.tid) = (yyvsp[(1) - (3)].tid);
    ;}
    break;

  case 277:
#line 4390 "parser.y"
    {
      c_ast_list_cleanup( &(yyvsp[(3) - (4)].ast_list) );

      if ( OPT_LANG_IS( throw ) ) {
        print_error( &(yylsp[(3) - (4)]),
          "dynamic exception specifications not supported by %s\n", CDECL
        );
      } else {
        print_error( &(yylsp[(3) - (4)]),
          "dynamic exception specifications not supported%s\n",
          C_LANG_WHICH( throw )
        );
      }
      PARSE_ABORT();
    ;}
    break;

  case 280:
#line 4411 "parser.y"
    {
      elaborate_error( "\"true\" or \"false\" expected" );
    ;}
    break;

  case 281:
#line 4417 "parser.y"
    { (yyval.ast) = NULL; ;}
    break;

  case 282:
#line 4419 "parser.y"
    { ia_type_ast_push( (yyvsp[(2) - (2)].ast) ); ;}
    break;

  case 283:
#line 4420 "parser.y"
    {
      ia_type_ast_pop();
      c_ast_t const *const ret_ast = ia_type_ast_peek();

      DUMP_START( "trailing_return_type_c_ast_opt",
                  "type_c_ast cast_c_astp_opt" );
      DUMP_AST( "in_attr__type_c_ast", ret_ast );
      DUMP_AST( "type_c_ast", (yyvsp[(2) - (4)].ast) );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(4) - (4)].ast_pair).ast );

      (yyval.ast) = (yyvsp[(4) - (4)].ast_pair).ast != NULL ? (yyvsp[(4) - (4)].ast_pair).ast : (yyvsp[(2) - (4)].ast);

      DUMP_AST( "trailing_return_type_c_ast_opt", (yyval.ast) );
      DUMP_END();

      //
      // The function trailing return-type syntax is supported only in C++11
      // and later.  This check has to be done now in the parser rather than
      // later in the AST because the AST has no "memory" of where the return-
      // type came from.
      //
      if ( UNSUPPORTED( TRAILING_RETURN_TYPE ) ) {
        print_error( &(yylsp[(1) - (4)]),
          "trailing return type not supported%s\n",
          C_LANG_WHICH( TRAILING_RETURN_TYPE )
        );
        PARSE_ABORT();
      }

      //
      // Ensure that a function using the C++11 trailing return type syntax
      // starts with "auto":
      //
      //      void f() -> int
      //      ^
      //      error: must be "auto"
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the "auto" is just a syntactic return-type placeholder in
      // C++11 and the AST node for the placeholder is discarded and never made
      // part of the AST.
      //
      if ( ret_ast->type.btids != TB_AUTO ) {
        print_error( &ret_ast->loc,
          "function with trailing return type must only specify \"auto\"\n"
        );
        PARSE_ABORT();
      }
    ;}
    break;

  case 284:
#line 4471 "parser.y"
    {
      (yyval.ast) = NULL;
    ;}
    break;

  case 285:
#line 4477 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 286:
#line 4478 "parser.y"
    { (yyval.tid) = (yyvsp[(2) - (2)].tid); ;}
    break;

  case 287:
#line 4479 "parser.y"
    { (yyval.tid) = (yyvsp[(2) - (2)].tid); ;}
    break;

  case 288:
#line 4481 "parser.y"
    {
      if ( (yyvsp[(2) - (2)].int_val) != 0 ) {
        print_error( &(yylsp[(2) - (2)]), "'0' expected\n" );
        PARSE_ABORT();
      }
      (yyval.tid) = TS_PURE_VIRTUAL;
    ;}
    break;

  case 289:
#line 4489 "parser.y"
    {
      if ( OPT_LANG_IS( default_delete_FUNC ) )
        elaborate_error( "'0', \"default\", or \"delete\" expected" );
      else
        elaborate_error( "'0' expected" );
    ;}
    break;

  case 291:
#line 4502 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      elaborate_error( "parameter list expected" );
    ;}
    break;

  case 292:
#line 4509 "parser.y"
    { slist_init( &(yyval.ast_list) ); ;}
    break;

  case 294:
#line 4515 "parser.y"
    {
      DUMP_START( "param_c_ast_list", "param_c_ast_list ',' param_c_ast" );
      DUMP_AST_LIST( "param_c_ast_list", (yyvsp[(1) - (3)].ast_list) );
      DUMP_AST( "param_c_ast", (yyvsp[(3) - (3)].ast) );

      (yyval.ast_list) = (yyvsp[(1) - (3)].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[(3) - (3)].ast) );

      DUMP_AST_LIST( "param_c_ast_list", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 295:
#line 4528 "parser.y"
    {
      DUMP_START( "param_c_ast_list", "param_c_ast" );
      DUMP_AST( "param_c_ast", (yyvsp[(1) - (1)].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[(1) - (1)].ast) );

      DUMP_AST_LIST( "param_c_ast_list", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 296:
#line 4544 "parser.y"
    { ia_type_ast_push( (yyvsp[(2) - (2)].ast) ); ;}
    break;

  case 297:
#line 4545 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "param_c_ast", "this_stid_opt type_c_ast cast_c_astp_opt" );
      DUMP_TID( "this_stid_opt", (yyvsp[(1) - (4)].tid) );
      DUMP_AST( "type_c_ast", (yyvsp[(2) - (4)].ast) );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(4) - (4)].ast_pair).ast );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[(2) - (4)].ast), (yyvsp[(4) - (4)].ast_pair).ast );

      if ( (yyval.ast)->kind == K_FUNCTION ) {
        //
        // From the C11 standard, section 6.3.2.1(4):
        //
        //    [A] function designator with type "function returning type" is
        //    converted to an expression that has type "pointer to function
        //    returning type."
        //
        (yyval.ast) = c_ast_pointer( (yyval.ast), &gc_ast_list );
      }

      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[(1) - (4)].tid), &(yylsp[(1) - (4)]) ) );

      DUMP_AST( "param_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 299:
#line 4581 "parser.y"
    {
      DUMP_START( "param_c_ast", "..." );

      (yyval.ast) = c_ast_new_gc( K_VARIADIC, &(yyloc) );

      DUMP_AST( "param_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 301:
#line 4594 "parser.y"
    {
      elaborate_error( "parameter declaration expected" );
    ;}
    break;

  case 302:
#line 4603 "parser.y"
    {
      ia_type_ast_push( c_ast_new_gc( K_PLACEHOLDER, &(yyloc) ) );
      ++in_attr.ast_depth;
    ;}
    break;

  case 303:
#line 4608 "parser.y"
    {
      ia_type_ast_pop();
      --in_attr.ast_depth;

      DUMP_START( "nested_decl_c_astp", "'(' decl_c_astp ')'" );
      DUMP_AST( "decl_c_astp", (yyvsp[(3) - (4)].ast_pair).ast );

      (yyval.ast_pair) = (yyvsp[(3) - (4)].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST( "nested_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 304:
#line 4630 "parser.y"
    {
      c_tid_t      const        func_qualifier_stid = (yyvsp[(6) - (10)].tid);
      c_tid_t      const        func_ref_qualifier_stid = (yyvsp[(7) - (10)].tid);
      c_tid_t      const        func_equals_stid = (yyvsp[(10) - (10)].tid);
      c_tid_t      const        noexcept_stid = (yyvsp[(8) - (10)].tid);
      c_oper_id_t  const        oper_id = (yyvsp[(3) - (10)].oper_id);
      c_operator_t const *const operator = c_oper_get( oper_id );
      c_ast_t            *const trailing_ret_ast = (yyvsp[(9) - (10)].ast);
      c_ast_t            *const type_ast = ia_type_ast_peek();

      DUMP_START( "oper_decl_c_astp",
                  "oper_sname_c_opt OPERATOR c_operator "
                  "'(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt "
                  "func_ref_qualifier_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[(1) - (10)].sname) );
      DUMP_STR( "c_operator", operator->literal );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[(5) - (10)].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", func_qualifier_stid );
      DUMP_TID( "func_ref_qualifier_c_stid_opt", func_ref_qualifier_stid );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );
      DUMP_AST( "trailing_return_type_c_ast_opt", trailing_ret_ast );
      DUMP_TID( "func_equals_c_stid_opt", func_equals_stid );

      c_tid_t const oper_stid =
        func_qualifier_stid | func_ref_qualifier_stid | noexcept_stid |
        func_equals_stid;

      c_ast_t *const oper_ast = c_ast_new_gc( K_OPERATOR, &(yyloc) );
      oper_ast->sname = c_sname_move( &(yyvsp[(1) - (10)].sname) );
      oper_ast->type.stids = c_tid_check( oper_stid, C_TPID_STORE );
      oper_ast->oper.param_ast_list = slist_move( &(yyvsp[(5) - (10)].ast_list) );
      oper_ast->oper.operator = operator;

      c_ast_t *const ret_ast = trailing_ret_ast != NULL ?
        trailing_ret_ast : type_ast;

      (yyval.ast_pair).ast = c_ast_add_func( type_ast, oper_ast, ret_ast );
      (yyval.ast_pair).target_ast = oper_ast->oper.ret_ast;

      DUMP_AST( "oper_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 305:
#line 4681 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 306:
#line 4682 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_decl_c_astp", "pointer_type_c_ast decl_c_astp" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "decl_c_astp", (yyvsp[(3) - (3)].ast_pair).ast );

      PJL_IGNORE_RV( c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast_pair).ast ) );
      (yyval.ast_pair) = (yyvsp[(3) - (3)].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST( "pointer_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 307:
#line 4701 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "pointer_type_c_ast", "* type_qualifier_list_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[(2) - (2)].tid) );

      (yyval.ast) = c_ast_new_gc( K_POINTER, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[(2) - (2)].tid), C_TPID_STORE );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "pointer_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 310:
#line 4725 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 311:
#line 4726 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pc99_pointer_decl_c",
                  "pc99_pointer_type_c_ast decl_c_astp" );
      DUMP_AST( "pc99_pointer_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "decl_c_astp", (yyvsp[(3) - (3)].ast_pair).ast );

      PJL_IGNORE_RV( c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast_pair).ast ) );
      c_ast_t *const ast = (yyvsp[(3) - (3)].ast_pair).ast;
      ast->loc = (yyloc);

      DUMP_AST( "pc99_pointer_decl_c", ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ast ) );
      c_ast_english( ast, stdout );
    ;}
    break;

  case 312:
#line 4748 "parser.y"
    {
      if ( OPT_LANG_IS( C_ANY ) && UNSUPPORTED( IMPLICIT_int ) ) {
        //
        // In C99 and later, implicit int is an error.  This check has to be
        // done now in the parser rather than later in the AST since the AST
        // would have no "memory" that the return type was implicitly int.
        //
        print_error( &(yylsp[(1) - (2)]),
          "implicit \"int\" is illegal%s\n",
          C_LANG_WHICH( IMPLICIT_int )
        );
        PARSE_ABORT();
      }

      DUMP_START( "pc99_pointer_type_c_ast",
                  "* type_qualifier_list_c_stid_opt" );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[(2) - (2)].tid) );

      if ( false_set( &in_attr.is_implicit_int ) ) {
        c_ast_t *const int_ast = c_ast_new_gc( K_BUILTIN, &(yylsp[(1) - (2)]) );
        int_ast->type.btids = TB_INT;
        ia_type_ast_push( int_ast );
      }

      c_ast_t *const type_ast = c_ast_dup( ia_type_ast_peek(), &gc_ast_list );
      (yyval.ast) = c_ast_pointer( type_ast, &gc_ast_list );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[(2) - (2)].tid), C_TPID_STORE );

      DUMP_AST( "pc99_pointer_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 313:
#line 4784 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 314:
#line 4785 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_decl_c_astp",
                  "pointer_to_member_type_c_ast decl_c_astp" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "decl_c_astp", (yyvsp[(3) - (3)].ast_pair).ast );

      (yyval.ast_pair) = (yyvsp[(3) - (3)].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST( "pointer_to_member_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 315:
#line 4804 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "pointer_to_member_type_c_ast",
                  "sname '::*' cv_qualifier_list_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "sname", (yyvsp[(1) - (3)].sname) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[(3) - (3)].tid) );

      (yyval.ast) = c_ast_new_gc( K_POINTER_TO_MEMBER, &(yyloc) );

      c_type_t scope_type = *c_sname_local_type( &(yyvsp[(1) - (3)].sname) );
      if ( !c_tid_is_any( scope_type.btids, TB_ANY_SCOPE ) ) {
        //
        // The sname has no scope-type, but we now know there's a pointer-to-
        // member of it, so it must be a class.  (It could alternatively be a
        // struct, but we have no context to know, so just pick class because
        // it's more C++-like.)
        //
        scope_type.btids = TB_CLASS;
        c_sname_set_local_type( &(yyvsp[(1) - (3)].sname), &scope_type );
      }

      // adopt sname's scope-type for the AST
      (yyval.ast)->type = c_type_or( &C_TYPE_LIT_S( (yyvsp[(3) - (3)].tid) ), &scope_type );

      (yyval.ast)->ptr_mbr.class_sname = c_sname_move( &(yyvsp[(1) - (3)].sname) );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "pointer_to_member_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 316:
#line 4841 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 317:
#line 4842 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_decl_c_astp", "reference_type_c_ast decl_c_astp" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "decl_c_astp", (yyvsp[(3) - (3)].ast_pair).ast );

      (yyval.ast_pair) = (yyvsp[(3) - (3)].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST( "reference_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 318:
#line 4860 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "reference_type_c_ast", "&" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[(2) - (2)].tid) );

      (yyval.ast) = c_ast_new_gc( K_REFERENCE, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[(2) - (2)].tid), C_TPID_STORE );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "reference_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 319:
#line 4877 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "reference_type_c_ast", "&&" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[(2) - (2)].tid) );

      (yyval.ast) = c_ast_new_gc( K_RVALUE_REFERENCE, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[(2) - (2)].tid), C_TPID_STORE );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "reference_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 320:
#line 4898 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "typedef_type_decl_c_ast", "typedef_type_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "typedef_type_c_ast", (yyvsp[(1) - (1)].ast) );

      if ( c_tid_is_any( type_ast->type.stids, TS_TYPEDEF ) ) {
        //
        // If we're defining a type, return the type as-is.
        //
        (yyval.ast) = (yyvsp[(1) - (1)].ast);
      }
      else {
        //
        // Otherwise, return the type that it's typedef'd as.
        //
        c_ast_t const *const raw_ast = c_ast_untypedef( (yyvsp[(1) - (1)].ast) );

        //
        // But first ensure the name isn't of a previously declared type:
        //
        //      cdecl> struct S
        //      cdecl> explain int S    // error: "S": previously declared
        //
        // Note that typedef_type_c_ast is like:
        // ```
        // typedef_type_c_ast = {
        //   sname = "",
        //   ...
        //   kind = "typedef",
        //   ...
        //   type = "none" (btid = 0x10000001, stid = 0x2, atid = 0x4),
        //   for_ast = {
        //     sname = "S" (struct),
        //     ...
        //     kind = "enum, struct, or union",
        //     ...
        //     type = "struct" (btid = 0x800001, stid = 0x2, atid = 0x4),
        //     csu_sname = "S" (none)
        //   }
        // }
        // ```
        // That is, typedef_type_c_ast has no name itself (at this point), but
        // the raw type, of course, does, so it's that name we have to check.
        //
        // This check has to be done now in the parser rather than later in the
        // AST since if this declaration were joined with a type (like `int`
        // above), the type information would be lost and we'd get this from
        // above:
        //
        //      declare S as structure S          // wrong
        //
        // Additionally, we also get here when the typedef name is used as part
        // of longer name, e.g., `S::x`:
        //
        //      c++decl> explain int S::x
        //      declare x of structure S as int   // correct
        //
        // but that name isn't of a previously declared type, so it's OK.
        //
        c_typedef_t const *const tdef = c_typedef_find_sname( &raw_ast->sname );
        if ( tdef != NULL ) {
          print_error(
            &(yyvsp[(1) - (1)].ast)->loc,
            "\"%s\": previously declared as type: ",
            c_sname_full_name( &raw_ast->sname )
          );
          print_type( tdef, stderr );
          PARSE_ABORT();
        }

        //
        // We have to duplicate the type to set the current location.
        //
        (yyval.ast) = c_ast_dup( raw_ast, &gc_ast_list );
        (yyval.ast)->loc = (yyvsp[(1) - (1)].ast)->loc;
      }

      DUMP_AST( "typedef_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 321:
#line 4987 "parser.y"
    {
      ia_type_ast_push( (yyvsp[(3) - (3)].ast) );
    ;}
    break;

  case 322:
#line 4992 "parser.y"
    {
      ia_type_ast_pop();

      c_ast_t *const  type_ast = ia_type_ast_peek();
      c_ast_t *const  conv_ast = (yyvsp[(3) - (9)].ast);
      c_ast_t *const  udc_ast = (yyvsp[(5) - (9)].ast);
      c_tid_t  const  func_qual_stids = (yyvsp[(7) - (9)].tid);
      c_tid_t  const  noexcept_stid = (yyvsp[(8) - (9)].tid);
      c_tid_t  const  func_equals_stid = (yyvsp[(9) - (9)].tid);

      DUMP_START( "user_defined_conversion_decl_c_astp",
                  "oper_sname_c_opt OPERATOR "
                  "type_c_ast udc_decl_c_ast_opt '(' ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[(1) - (9)].sname) );
      DUMP_AST( "type_c_ast", conv_ast );
      DUMP_AST( "udc_decl_c_ast_opt", udc_ast );
      DUMP_TID( "func_qualifier_list_c_stid_opt", func_qual_stids );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );
      DUMP_TID( "func_equals_c_stid_opt", func_equals_stid );

      (yyval.ast_pair).ast = c_ast_new_gc( K_USER_DEF_CONVERSION, &(yyloc) );
      (yyval.ast_pair).ast->sname = c_sname_move( &(yyvsp[(1) - (9)].sname) );
      (yyval.ast_pair).ast->type.stids = c_tid_check(
        func_qual_stids | noexcept_stid | func_equals_stid,
        C_TPID_STORE
      );
      if ( type_ast != NULL )
        c_type_or_eq( &(yyval.ast_pair).ast->type, &type_ast->type );
      (yyval.ast_pair).ast->udef_conv.conv_ast = udc_ast != NULL ? udc_ast : conv_ast;
      (yyval.ast_pair).target_ast = (yyval.ast_pair).ast->udef_conv.conv_ast;

      DUMP_AST( "user_defined_conversion_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 323:
#line 5038 "parser.y"
    {
      char const *const name = (yyvsp[(4) - (9)].name);
      c_tid_t     const noexcept_stid = (yyvsp[(8) - (9)].tid);
      c_ast_t    *const trailing_ret_ast = (yyvsp[(9) - (9)].ast);
      c_ast_t    *const type_ast = ia_type_ast_peek();

      DUMP_START( "user_defined_literal_decl_c_astp",
                  "oper_sname_c_opt OPERATOR \"\" "
                  "'(' param_c_ast_list_exp ')' noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[(1) - (9)].sname) );
      DUMP_STR( "name", name );
      DUMP_AST_LIST( "param_c_ast_list_exp", (yyvsp[(6) - (9)].ast_list) );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );
      DUMP_AST( "trailing_return_type_c_ast_opt", trailing_ret_ast );

      c_sname_set( &type_ast->sname, &(yyvsp[(1) - (9)].sname) );
      c_sname_append_name( &type_ast->sname, name );

      c_ast_t *const udl_ast = c_ast_new_gc( K_USER_DEF_LITERAL, &(yyloc) );
      udl_ast->type.stids = c_tid_check( noexcept_stid, C_TPID_STORE );
      udl_ast->udef_lit.param_ast_list = slist_move( &(yyvsp[(6) - (9)].ast_list) );

      (yyval.ast_pair).ast = c_ast_add_func(
        type_ast,
        udl_ast,
        trailing_ret_ast != NULL ? trailing_ret_ast : type_ast
      );

      (yyval.ast_pair).target_ast = udl_ast->udef_lit.ret_ast;

      DUMP_AST( "user_defined_literal_decl_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 324:
#line 5080 "parser.y"
    { (yyval.ast_pair) = (c_ast_pair_t){ NULL, NULL }; ;}
    break;

  case 334:
#line 5097 "parser.y"
    { (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[(1) - (1)].ast), NULL }; ;}
    break;

  case 335:
#line 5108 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();
      c_ast_t *const array_ast = (yyvsp[(2) - (2)].ast);

      DUMP_START( "array_cast_c_astp", "cast_c_astp_opt array_size_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(1) - (2)].ast_pair).ast );
      DUMP_AST( "target_ast", (yyvsp[(1) - (2)].ast_pair).target_ast );
      DUMP_AST( "array_size_c_ast", array_ast );

      c_ast_set_parent( c_ast_new_gc( K_PLACEHOLDER, &(yylsp[(1) - (2)]) ), array_ast );

      if ( (yyvsp[(1) - (2)].ast_pair).target_ast != NULL ) {    // array-of or function-like-ret type
        (yyval.ast_pair).ast = (yyvsp[(1) - (2)].ast_pair).ast;
        (yyval.ast_pair).target_ast = c_ast_add_array( (yyvsp[(1) - (2)].ast_pair).target_ast, array_ast, type_ast );
      } else {
        c_ast_t *const ast = (yyvsp[(1) - (2)].ast_pair).ast != NULL ? (yyvsp[(1) - (2)].ast_pair).ast : type_ast;
        (yyval.ast_pair).ast = c_ast_add_array( ast, array_ast, type_ast );
        (yyval.ast_pair).target_ast = NULL;
      }

      DUMP_AST( "array_cast_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 336:
#line 5139 "parser.y"
    { //
      // A block AST has to be the type inherited attribute for cast_c_astp_opt
      // so we have to create it here.
      //
      ia_type_ast_push( c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) ) );
    ;}
    break;

  case 337:
#line 5147 "parser.y"
    {
      c_ast_t *const  block_ast = ia_type_ast_pop();
      c_ast_t *const  type_ast = ia_type_ast_peek();
      c_tid_t  const  type_qual_stids = (yyvsp[(4) - (9)].tid);
      c_ast_t *const  cast_ast = (yyvsp[(5) - (9)].ast_pair).ast;

      DUMP_START( "block_cast_c_astp",
                  "'(' '^' type_qualifier_list_c_stid_opt cast_c_astp_opt ')' "
                  "'(' param_c_ast_list_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", type_qual_stids );
      DUMP_AST( "cast_c_astp_opt", cast_ast );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[(8) - (9)].ast_list) );

      PARSE_ASSERT( c_type_add_tid( &block_ast->type, type_qual_stids, &(yylsp[(4) - (9)]) ) );
      block_ast->block.param_ast_list = slist_move( &(yyvsp[(8) - (9)].ast_list) );
      (yyval.ast_pair).ast = c_ast_add_func( cast_ast, block_ast, type_ast );
      (yyval.ast_pair).target_ast = block_ast->block.ret_ast;

      DUMP_AST( "block_cast_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 338:
#line 5177 "parser.y"
    {
      c_ast_t *const cast2_c_ast = (yyvsp[(1) - (6)].ast_pair).ast;
      c_tid_t  const func_ref_qualifier_stid = (yyvsp[(4) - (6)].tid);
      c_tid_t  const noexcept_stid = (yyvsp[(5) - (6)].tid);
      c_ast_t *      ret_ast = ia_type_ast_peek();
      c_ast_t *const trailing_ret_ast = (yyvsp[(6) - (6)].ast);

      DUMP_START( "func_cast_c_astp",
                  "cast2_c_astp '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt" );
      DUMP_AST( "in_attr__type_c_ast", ret_ast );
      DUMP_AST( "cast2_c_ast", cast2_c_ast );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[(3) - (6)].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", func_ref_qualifier_stid );
      DUMP_AST( "trailing_return_type_c_ast_opt", trailing_ret_ast );
      DUMP_TID( "noexcept_c_stid_opt", noexcept_stid );
      DUMP_AST( "target_ast", (yyvsp[(1) - (6)].ast_pair).target_ast );

      if ( cast2_c_ast->kind == K_FUNCTION ) {
        //
        // This is for a case like:
        //
        //      void f( int () () )
        //              |   |  |
        //              |   |  func
        //              |   |
        //              |   cast2_c_ast (func)
        //              |
        //              ret_ast
        //
        // We replace ret_ast with cast2_c_ast:
        //
        //      void f( int() () )
        //              |     |
        //              |     func
        //              |
        //              ret_ast <- cast2_c_ast (func)
        //
        // that is, a "function returning function returning int" -- which is
        // illegal (since functions can't return functions) and will be caught
        // by c_ast_check_ret_type().
        //
        ret_ast = cast2_c_ast;
      }

      c_ast_t *const func_ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
      c_tid_t const func_stid = func_ref_qualifier_stid | noexcept_stid;
      func_ast->type.stids = c_tid_check( func_stid, C_TPID_STORE );
      func_ast->func.param_ast_list = slist_move( &(yyvsp[(3) - (6)].ast_list) );

      if ( (yyvsp[(1) - (6)].ast_pair).target_ast != NULL ) {
        (yyval.ast_pair).ast = cast2_c_ast;
        PJL_IGNORE_RV( c_ast_add_func( (yyvsp[(1) - (6)].ast_pair).target_ast, func_ast, ret_ast ) );
      }
      else {
        (yyval.ast_pair).ast = c_ast_add_func(
          cast2_c_ast,
          func_ast,
          trailing_ret_ast != NULL ? trailing_ret_ast : ret_ast
        );
      }

      (yyval.ast_pair).target_ast = func_ast->func.ret_ast;

      DUMP_AST( "func_cast_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 339:
#line 5251 "parser.y"
    {
      ia_type_ast_push( c_ast_new_gc( K_PLACEHOLDER, &(yyloc) ) );
      ++in_attr.ast_depth;
    ;}
    break;

  case 340:
#line 5256 "parser.y"
    {
      ia_type_ast_pop();
      --in_attr.ast_depth;

      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "nested_cast_c_astp", "'(' cast_c_astp_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(3) - (4)].ast_pair).ast );

      (yyval.ast_pair) = (yyvsp[(3) - (4)].ast_pair);

      if ( (yyval.ast_pair).ast == NULL ) {
        //
        // This is for a case like:
        //
        //      void f( int() )
        //                 ^^
        //
        // where the unnamed parameter is a "function returning int".  (In
        // param_c_ast, this will be converted into a "pointer to function
        // returning int".)
        //
        (yyval.ast_pair).ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
        c_ast_set_parent( type_ast, (yyval.ast_pair).ast );
      } else {
        (yyval.ast_pair).ast->loc = (yyloc);
      }

      DUMP_AST( "nested_cast_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 341:
#line 5293 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 342:
#line 5294 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_cast_c_astp", "pointer_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(3) - (3)].ast_pair).ast );

      (yyval.ast_pair).ast = c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast_pair).ast );
      (yyval.ast_pair).target_ast = (yyvsp[(3) - (3)].ast_pair).target_ast;

      DUMP_AST( "pointer_cast_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 343:
#line 5312 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 344:
#line 5313 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_cast_c_astp",
                  "pointer_to_member_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(3) - (3)].ast_pair).ast );

      (yyval.ast_pair).ast = c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast_pair).ast );
      (yyval.ast_pair).target_ast = (yyvsp[(3) - (3)].ast_pair).target_ast;

      DUMP_AST( "pointer_to_member_cast_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 345:
#line 5332 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 346:
#line 5333 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_cast_c_astp",
                  "reference_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "cast_c_astp_opt", (yyvsp[(3) - (3)].ast_pair).ast );

      (yyval.ast_pair).ast = c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast_pair).ast );
      (yyval.ast_pair).target_ast = (yyvsp[(3) - (3)].ast_pair).target_ast;

      DUMP_AST( "reference_cast_c_astp", (yyval.ast_pair).ast );
      DUMP_END();
    ;}
    break;

  case 347:
#line 5358 "parser.y"
    { (yyval.ast) = NULL; ;}
    break;

  case 353:
#line 5370 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 354:
#line 5371 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_udc_decl_c_ast",
                  "pointer_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[(3) - (3)].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast) );

      DUMP_AST( "pointer_udc_decl_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 355:
#line 5387 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 356:
#line 5388 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_udc_decl_c_ast",
                  "pointer_to_member_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[(3) - (3)].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast) );

      DUMP_AST( "pointer_to_member_udc_decl_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 357:
#line 5404 "parser.y"
    { ia_type_ast_push( (yyvsp[(1) - (1)].ast) ); ;}
    break;

  case 358:
#line 5405 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_udc_decl_c_ast",
                  "reference_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[(3) - (3)].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[(1) - (3)].ast), (yyvsp[(3) - (3)].ast) );

      DUMP_AST( "reference_udc_decl_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 359:
#line 5431 "parser.y"
    {
      DUMP_START( "type_c_ast", "type_modifier_list_c_type" );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[(1) - (1)].type) );

      //
      // Prior to C99, typeless declarations are implicitly int, so we set it
      // here.  In C99 and later, however, implicit int is an error, so we
      // don't set it here and c_ast_check() will catch the error later.
      //
      // Note that type modifiers, e.g., unsigned, count as a type since that
      // means unsigned int; however, neither qualifiers, e.g., const, nor
      // storage classes, e.g., register, by themselves count as a type:
      //
      //      unsigned i;   // legal in C99
      //      const    j;   // illegal in C99
      //      register k;   // illegal in C99
      //
      c_type_t type = OPT_LANG_IS( IMPLICIT_int ) ?
        C_TYPE_LIT_B( TB_INT ) : T_NONE;

      PARSE_ASSERT( c_type_add( &type, &(yyvsp[(1) - (1)].type), &(yylsp[(1) - (1)]) ) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type = type;

      DUMP_AST( "type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 360:
#line 5466 "parser.y"
    {
      DUMP_START( "type_c_ast",
                  "type_modifier_list_c_type east_modified_type_c_ast " );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[(1) - (2)].type) );
      DUMP_AST( "east_modified_type_c_ast", (yyvsp[(2) - (2)].ast) );

      (yyval.ast) = (yyvsp[(2) - (2)].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[(1) - (2)].type), &(yylsp[(1) - (2)]) ) );

      DUMP_AST( "type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 362:
#line 5484 "parser.y"
    { (yyval.type) = T_NONE; ;}
    break;

  case 364:
#line 5490 "parser.y"
    {
      DUMP_START( "type_modifier_list_c_type",
                  "type_modifier_list_c_type type_modifier_c_type" );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[(1) - (2)].type) );
      DUMP_TYPE( "type_modifier_c_type", (yyvsp[(2) - (2)].type) );

      (yyval.type) = (yyvsp[(1) - (2)].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[(2) - (2)].type), &(yylsp[(2) - (2)]) ) );

      DUMP_TYPE( "type_modifier_list_c_type", (yyval.type) );
      DUMP_END();
    ;}
    break;

  case 366:
#line 5508 "parser.y"
    {
      (yyval.type) = (yyvsp[(1) - (1)].type);
      //
      // This is for a case like:
      //
      //      explain typedef unsigned long size_t
      //
      // that is: explain a redefinition of a typedef'd type with the same type
      // that contains only one or more type_modifier_base_type.  The problem
      // is that, without an east_modified_type_c_ast (like int), the parser
      // would ordinarily take the typedef'd type (here, the size_t) as part of
      // the type_c_ast and then be out of tokens for the decl_c_astp -- at
      // which time it'll complain.
      //
      // Since type modifiers can't apply to a typedef'd type (e.g., "long
      // size_t" is illegal), we tell the lexer not to return either
      // Y_TYPEDEF_NAME or Y_TYPEDEF_SNAME if we encounter at least one type
      // modifier (except "register" since it's is really a storage class --
      // see the comment in type_modifier_base_type about "register").
      //
      if ( (yyval.type).stids != TS_REGISTER )
        lexer_find &= ~LEXER_FIND_TYPES;
    ;}
    break;

  case 367:
#line 5531 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 369:
#line 5534 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_A( (yyvsp[(1) - (1)].tid) );
    ;}
    break;

  case 370:
#line 5540 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 371:
#line 5541 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 372:
#line 5542 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 373:
#line 5543 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 374:
#line 5544 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 375:
#line 5545 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 376:
#line 5546 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 377:
#line 5552 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 378:
#line 5557 "parser.y"
    {
      DUMP_START( "east_modified_type_c_ast",
                  "atomic_builtin_typedef_type_c_ast "
                  "type_modifier_list_c_type_opt" );
      DUMP_AST( "atomic_builtin_typedef_type_c_ast", (yyvsp[(1) - (2)].ast) );
      DUMP_TYPE( "type_modifier_list_c_type_opt", (yyvsp[(2) - (2)].type) );

      (yyval.ast) = (yyvsp[(1) - (2)].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[(2) - (2)].type), &(yylsp[(2) - (2)]) ) );

      DUMP_AST( "type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 379:
#line 5573 "parser.y"
    {
      DUMP_START( "east_modified_type_c_ast",
                  "enum_class_struct_union_c_ast cv_qualifier_list_stid_opt" );
      DUMP_AST( "enum_class_struct_union_c_ast", (yyvsp[(1) - (2)].ast) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[(2) - (2)].tid) );

      (yyval.ast) = (yyvsp[(1) - (2)].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[(2) - (2)].tid), &(yylsp[(2) - (2)]) ) );

      DUMP_AST( "east_modified_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 384:
#line 5599 "parser.y"
    {
      ia_type_ast_push( (yyvsp[(3) - (3)].ast) );
    ;}
    break;

  case 385:
#line 5603 "parser.y"
    {
      ia_type_ast_pop();

      c_ast_t *const type_ast = (yyvsp[(3) - (6)].ast);
      c_ast_t *const cast_ast = (yyvsp[(5) - (6)].ast_pair).ast;

      DUMP_START( "atomic_specifier_type_c_ast",
                  "ATOMIC '(' type_c_ast cast_c_astp_opt ')'" );
      DUMP_AST( "type_c_ast", type_ast );
      DUMP_AST( "cast_c_astp_opt", cast_ast );

      (yyval.ast) = cast_ast != NULL ? cast_ast : type_ast;
      (yyval.ast)->loc = (yyloc);

      //
      // Ensure the _Atomic() specifier type doesn't have either a storage
      // class or attributes:
      //
      //      const _Atomic(int) x;     // OK
      //      _Atomic(const int) y;     // error
      //
      // This check has to be done now in the parser rather than later in the
      // AST since the type would be stored as "atomic const int" either way so
      // the AST has no "memory" of which it was.
      //
      if ( (yyval.ast)->type.stids != TS_NONE || (yyval.ast)->type.atids != TA_NONE ) {
        static c_type_t const TSA_ANY = { TB_NONE, TS_ANY, TA_ANY };
        c_type_t const error_type = c_type_and( &(yyval.ast)->type, &TSA_ANY );
        print_error( &(yylsp[(3) - (6)]),
          "_Atomic can not be of \"%s\"\n", c_type_name_c( &error_type )
        );
        PARSE_ABORT();
      }

      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, TS_ATOMIC, &(yylsp[(1) - (6)]) ) );

      DUMP_AST( "atomic_specifier_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 386:
#line 5648 "parser.y"
    {
      DUMP_START( "builtin_type_c_ast", "builtin_no_BitInt_c_btid" );
      DUMP_TID( "builtin_no_BitInt_c_btid", (yyvsp[(1) - (1)].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[(1) - (1)].tid), C_TPID_BASE );

      DUMP_AST( "builtin_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 387:
#line 5659 "parser.y"
    {
      DUMP_START( "builtin_type_c_ast", "_BitInt '(' int_lit_exp ')'" );
      DUMP_INT( "int", (yyvsp[(3) - (4)].int_val) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = TB_BITINT;
      (yyval.ast)->builtin.BitInt.width = STATIC_CAST( unsigned, (yyvsp[(3) - (4)].int_val) );

      DUMP_AST( "builtin_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 402:
#line 5691 "parser.y"
    {
      print_error( &(yylsp[(1) - (1)]), "typeof declarations not supported by %s\n", CDECL );
      PARSE_ABORT();
    ;}
    break;

  case 407:
#line 5711 "parser.y"
    {
      c_tid_t  const  csu_tid = (yyvsp[(1) - (3)].tid);
      c_tid_t  const  atids = (yyvsp[(2) - (3)].tid);

      DUMP_START( "enum_class_struct_union_c_ast",
                  "class_struct_union_btid "
                  "attribute_specifier_list_c_atid_opt sname" );
      DUMP_TID( "class_struct_union_btid", csu_tid );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", atids );
      DUMP_SNAME( "any_sname_c", (yyvsp[(3) - (3)].sname) );

      (yyval.ast) = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( csu_tid, C_TPID_BASE );
      (yyval.ast)->type.atids = c_tid_check( atids, C_TPID_ATTR );
      (yyval.ast)->csu.csu_sname = c_sname_move( &(yyvsp[(3) - (3)].sname) );

      DUMP_AST( "class_struct_union_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 408:
#line 5733 "parser.y"
    {
      print_error( &(yylsp[(4) - (4)]),
        "explaining %s declarations not supported by %s\n",
        c_tid_name_c( (yyvsp[(1) - (4)].tid) ), CDECL
      );
      c_sname_cleanup( &(yyvsp[(3) - (4)].sname) );
      PARSE_ABORT();
    ;}
    break;

  case 409:
#line 5746 "parser.y"
    {
      c_tid_t  const  enum_btid = (yyvsp[(1) - (4)].tid);
      c_tid_t  const  atids = (yyvsp[(2) - (4)].tid);
      c_ast_t *const  fixed_type_ast = (yyvsp[(4) - (4)].ast);

      DUMP_START( "enum_c_ast",
                  "enum_btid attribute_specifier_list_c_atid_opt sname "
                  "enum_fixed_type_c_ast_opt" );
      DUMP_TID( "enum_btid", enum_btid );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", atids );
      DUMP_SNAME( "any_sname_c", (yyvsp[(3) - (4)].sname) );
      DUMP_AST( "enum_fixed_type_c_ast_opt", fixed_type_ast );

      (yyval.ast) = c_ast_new_gc( K_ENUM, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( enum_btid, C_TPID_BASE );
      (yyval.ast)->type.atids = c_tid_check( atids, C_TPID_ATTR );
      (yyval.ast)->enum_.of_ast = fixed_type_ast;
      (yyval.ast)->enum_.enum_sname = c_sname_move( &(yyvsp[(3) - (4)].sname) );

      DUMP_AST( "enum_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 410:
#line 5770 "parser.y"
    {
      print_error( &(yylsp[(4) - (4)]),
        "explaining %s declarations not supported by %s\n",
        c_tid_name_c( (yyvsp[(1) - (4)].tid) ), CDECL
      );
      c_sname_cleanup( &(yyvsp[(3) - (4)].sname) );
      PARSE_ABORT();
    ;}
    break;

  case 411:
#line 5783 "parser.y"
    { (yyval.tid) = (yyvsp[(1) - (2)].tid) | (yyvsp[(2) - (2)].tid); ;}
    break;

  case 412:
#line 5787 "parser.y"
    { (yyval.ast) = NULL; ;}
    break;

  case 413:
#line 5788 "parser.y"
    { (yyval.ast) = (yyvsp[(2) - (2)].ast); ;}
    break;

  case 414:
#line 5790 "parser.y"
    {
      elaborate_error( "type name expected" );
    ;}
    break;

  case 415:
#line 5806 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_fixed_type_modifier_list_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[(1) - (1)].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yylsp[(1) - (1)]) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[(1) - (1)].tid), C_TPID_BASE );

      DUMP_AST( "enum_fixed_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 416:
#line 5825 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_fixed_type_modifier_list_btid "
                  "enum_unmodified_fixed_type_c_ast "
                  "enum_fixed_type_modifier_list_btid_opt" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[(1) - (3)].tid) );
      DUMP_AST( "enum_unmodified_fixed_type_c_ast", (yyvsp[(2) - (3)].ast) );
      DUMP_TID( "enum_fixed_type_modifier_list_btid_opt", (yyvsp[(3) - (3)].tid) );

      (yyval.ast) = (yyvsp[(2) - (3)].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[(1) - (3)].tid), &(yylsp[(1) - (3)]) ) );
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[(3) - (3)].tid), &(yylsp[(3) - (3)]) ) );

      DUMP_AST( "enum_fixed_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 417:
#line 5849 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_unmodified_fixed_type_c_ast "
                  "enum_fixed_type_modifier_list_btid_opt" );
      DUMP_AST( "enum_unmodified_fixed_type_c_ast", (yyvsp[(1) - (2)].ast) );
      DUMP_TID( "enum_fixed_type_modifier_list_btid_opt", (yyvsp[(2) - (2)].tid) );

      (yyval.ast) = (yyvsp[(1) - (2)].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[(2) - (2)].tid), &(yylsp[(2) - (2)]) ) );

      DUMP_AST( "enum_fixed_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 418:
#line 5866 "parser.y"
    { (yyval.tid) = TB_NONE; ;}
    break;

  case 420:
#line 5872 "parser.y"
    {
      DUMP_START( "enum_fixed_type_modifier_list_btid",
                  "enum_fixed_type_modifier_list_btid "
                  "enum_fixed_type_modifier_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[(1) - (2)].tid) );
      DUMP_TID( "enum_fixed_type_modifier_btid", (yyvsp[(2) - (2)].tid) );

      (yyval.tid) = (yyvsp[(1) - (2)].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[(2) - (2)].tid), &(yylsp[(2) - (2)]) ) );

      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyval.tid) );
      DUMP_END();
    ;}
    break;

  case 429:
#line 5905 "parser.y"
    { (yyval.tid) = TB_NONE; ;}
    break;

  case 435:
#line 5922 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 437:
#line 5929 "parser.y"
    {
      DUMP_START( "type_qualifier_list_c_stid",
                  "type_qualifier_list_c_stid type_qualifier_c_stid" );
      DUMP_TID( "type_qualifier_list_c_stid", (yyvsp[(1) - (3)].tid) );
      DUMP_TID( "type_qualifier_c_stid", (yyvsp[(2) - (3)].tid) );

      (yyval.tid) = (yyvsp[(1) - (3)].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[(2) - (3)].tid), &(yylsp[(2) - (3)]) ) );

      DUMP_TID( "type_qualifier_list_c_stid", (yyval.tid) );
      DUMP_END();
    ;}
    break;

  case 438:
#line 5943 "parser.y"
    {
      (yyval.tid) = (yyvsp[(2) - (2)].tid);
    ;}
    break;

  case 439:
#line 5948 "parser.y"
    {
      (yyval.tid) = (yyvsp[(1) - (2)].tid);
    ;}
    break;

  case 449:
#line 5969 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 450:
#line 5971 "parser.y"
    {
      DUMP_START( "cv_qualifier_list_stid_opt",
                  "cv_qualifier_list_stid_opt cv_qualifier_stid" );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[(1) - (2)].tid) );
      DUMP_TID( "cv_qualifier_stid", (yyvsp[(2) - (2)].tid) );

      (yyval.tid) = (yyvsp[(1) - (2)].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[(2) - (2)].tid), &(yylsp[(2) - (2)]) ) );

      DUMP_TID( "cv_qualifier_list_stid_opt", (yyval.tid) );
      DUMP_END();
    ;}
    break;

  case 451:
#line 5987 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since both "restrict" and "__restrict" map to TS_RESTRICT and the
      // AST has no "memory" of which it was.
      //
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        print_error( &(yylsp[(1) - (1)]),
          "\"restrict\" not supported in C++; use \"%s\" instead\n",
          L_GNU___restrict
        );
        PARSE_ABORT();
      }
    ;}
    break;

  case 456:
#line 6008 "parser.y"
    {
      elaborate_error( "one of nothing, integer, or '*' expected" );
    ;}
    break;

  case 457:
#line 6016 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 458:
#line 6017 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 459:
#line 6018 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 460:
#line 6019 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 461:
#line 6020 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 462:
#line 6021 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 463:
#line 6022 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 464:
#line 6023 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 465:
#line 6024 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 466:
#line 6025 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 467:
#line 6026 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 468:
#line 6027 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 469:
#line 6028 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 470:
#line 6030 "parser.y"
    {
      //
      // These checks have to be done now in the parser rather than later in
      // the AST because the _Noreturn keyword is mapped to the [[noreturn]]
      // attribute and the AST has no "memory" that it was _Noreturn.
      //
      if ( UNSUPPORTED( _Noreturn ) ) {
        print_error( &(yylsp[(1) - (1)]),
          "\"%s\" keyword not supported%s",
          lexer_token, C_LANG_WHICH( _Noreturn )
        );
        print_hint( "[[noreturn]]" );
        PARSE_ABORT();
      }
      if ( OPT_LANG_IS( C_MIN(23)) ) {
        print_warning( &(yylsp[(1) - (1)]),
          "\"%s\" is deprecated%s",
          lexer_token, C_LANG_WHICH( C_MAX(17) )
        );
        print_hint( "[[noreturn]]" );
      }

      (yyval.type) = C_TYPE_LIT_A( (yyvsp[(1) - (1)].tid) );
    ;}
    break;

  case 471:
#line 6054 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 472:
#line 6056 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 473:
#line 6057 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 474:
#line 6058 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 475:
#line 6059 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 476:
#line 6060 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 479:
#line 6071 "parser.y"
    { (yyval.tid) = TA_NONE; ;}
    break;

  case 481:
#line 6077 "parser.y"
    {
      if ( UNSUPPORTED( ATTRIBUTES ) ) {
        print_error( &(yylsp[(1) - (2)]),
          "\"[[\" attribute syntax not supported%s\n",
          C_LANG_WHICH( ATTRIBUTES )
        );
        PARSE_ABORT();
      }
      lexer_keyword_ctx = C_KW_CTX_ATTRIBUTE;
    ;}
    break;

  case 482:
#line 6088 "parser.y"
    {
      lexer_keyword_ctx = C_KW_CTX_DEFAULT;

      DUMP_START( "attribute_specifier_list_c_atid",
                  "'[[' using_opt attribute_list_c_atid_opt ']]'" );
      DUMP_TID( "attribute_list_c_atid_opt", (yyvsp[(5) - (7)].tid) );

      (yyval.tid) = (yyvsp[(5) - (7)].tid);

      DUMP_END();
    ;}
    break;

  case 483:
#line 6101 "parser.y"
    {
      (yyval.tid) = TA_NONE;
    ;}
    break;

  case 485:
#line 6109 "parser.y"
    {
      print_warning( &(yylsp[(1) - (3)]),
        "\"using\" in attributes not supported by %s (ignoring)\n", CDECL
      );
      free( (yyvsp[(2) - (3)].name) );
    ;}
    break;

  case 486:
#line 6118 "parser.y"
    { (yyval.tid) = TA_NONE; ;}
    break;

  case 488:
#line 6124 "parser.y"
    {
      DUMP_START( "attribute_list_c_atid",
                  "attribute_list_c_atid , attribute_c_atid" );
      DUMP_TID( "attribute_list_c_atid", (yyvsp[(1) - (3)].tid) );
      DUMP_TID( "attribute_c_atid_exp", (yyvsp[(3) - (3)].tid) );

      (yyval.tid) = (yyvsp[(1) - (3)].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[(3) - (3)].tid), &(yylsp[(3) - (3)]) ) );

      DUMP_TID( "attribute_list_c_atid", (yyval.tid) );
      DUMP_END();
    ;}
    break;

  case 498:
#line 6150 "parser.y"
    {
      if ( c_sname_count( &(yyvsp[(1) - (1)].sname) ) > 1 ) {
        print_warning( &(yylsp[(1) - (1)]),
          "\"%s\": namespaced attributes not supported by %s\n",
          c_sname_full_name( &(yyvsp[(1) - (1)].sname) ), CDECL
        );
      }
      else {
        char const *adj = "unknown";
        c_lang_id_t lang_ids = LANG_NONE;

        char const *const name = c_sname_local_name( &(yyvsp[(1) - (1)].sname) );
        c_keyword_t const *const ck =
          c_keyword_find( name, c_lang_newer( opt_lang ), C_KW_CTX_ATTRIBUTE );
        if ( ck != NULL && c_tid_tpid( ck->tid ) == C_TPID_ATTR ) {
          adj = "unsupported";
          lang_ids = ck->lang_ids;
        }
        print_warning( &(yylsp[(1) - (1)]),
          "\"%s\": %s attribute%s",
          name, adj, c_lang_which( lang_ids )
        );

        print_suggestions( DYM_C_ATTRIBUTES, name );
        EPUTC( '\n' );
      }

      (yyval.tid) = TA_NONE;
      c_sname_cleanup( &(yyvsp[(1) - (1)].sname) );
    ;}
    break;

  case 499:
#line 6181 "parser.y"
    {
      elaborate_error_dym( DYM_C_ATTRIBUTES, "attribute name expected" );
    ;}
    break;

  case 501:
#line 6189 "parser.y"
    {
      print_warning( &(yylsp[(1) - (3)]),
        "attribute arguments not supported by %s (ignoring)\n", CDECL
      );
      free( (yyvsp[(2) - (3)].str_val) );
    ;}
    break;

  case 510:
#line 6219 "parser.y"
    {
      attr_syntax_not_supported( &(yylsp[(1) - (1)]), L_GNU___attribute__ );
      //
      // Temporariy disabling finding keywords allows GNU attributes that are C
      // keywords (e.g., const) to be found as ordinary string literals.
      //
      lexer_find &= ~LEXER_FIND_C_KEYWORDS;
    ;}
    break;

  case 511:
#line 6228 "parser.y"
    {
      lexer_find |= LEXER_FIND_C_KEYWORDS;
    ;}
    break;

  case 516:
#line 6245 "parser.y"
    {
      free( (yyvsp[(1) - (2)].name) );
    ;}
    break;

  case 517:
#line 6249 "parser.y"
    {
      elaborate_error( "attribute name expected" );
    ;}
    break;

  case 524:
#line 6270 "parser.y"
    { free( (yyvsp[(1) - (1)].name) ); ;}
    break;

  case 526:
#line 6272 "parser.y"
    { free( (yyvsp[(1) - (1)].str_val) ); ;}
    break;

  case 527:
#line 6273 "parser.y"
    { free( (yyvsp[(1) - (1)].str_val) ); ;}
    break;

  case 529:
#line 6276 "parser.y"
    {
      PARSE_ABORT();
    ;}
    break;

  case 532:
#line 6288 "parser.y"
    {
      attr_syntax_not_supported( &(yylsp[(1) - (1)]), L_MSC___declspec );
      // See comment in gnu_attribute_specifier_c.
      lexer_find &= ~LEXER_FIND_C_KEYWORDS;
    ;}
    break;

  case 533:
#line 6294 "parser.y"
    {
      lexer_find |= LEXER_FIND_C_KEYWORDS;
    ;}
    break;

  case 541:
#line 6331 "parser.y"
    {
      c_tid_t  const  static_stid = (yyvsp[(2) - (6)].tid);
      c_tid_t  const  array_qual_stids = (yyvsp[(3) - (6)].tid);
      int      const  array_size = (yyvsp[(4) - (6)].int_val);
      c_ast_t *const  decl_ast = (yyvsp[(6) - (6)].ast);

      DUMP_START( "array_decl_english_ast",
                  "ARRAY static_stid_opt array_qualifier_list_english_stid_opt "
                  "array_size_num_opt OF decl_english_ast" );
      DUMP_TID( "static_stid_opt", static_stid );
      DUMP_TID( "array_qualifier_list_english_stid_opt", array_qual_stids );
      DUMP_INT( "array_size_int_opt", array_size );
      DUMP_AST( "decl_english_ast", decl_ast );

      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.size = array_size;
      (yyval.ast)->array.stids =
        c_tid_check( static_stid | array_qual_stids, C_TPID_STORE );
      c_ast_set_parent( decl_ast, (yyval.ast) );

      DUMP_AST( "array_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 542:
#line 6357 "parser.y"
    {
      c_tid_t  const  array_qual_stids = (yyvsp[(4) - (6)].tid);
      c_ast_t *const  decl_ast = (yyvsp[(6) - (6)].ast);

      DUMP_START( "array_decl_english_ast",
                  "VARIABLE LENGTH ARRAY array_qualifier_list_english_stid_opt "
                  "OF decl_english_ast" );
      DUMP_TID( "array_qualifier_list_english_stid_opt", array_qual_stids );
      DUMP_AST( "decl_english_ast", decl_ast );

      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.size = C_ARRAY_SIZE_VARIABLE;
      (yyval.ast)->array.stids = c_tid_check( array_qual_stids, C_TPID_STORE );
      c_ast_set_parent( decl_ast, (yyval.ast) );

      DUMP_AST( "array_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 543:
#line 6378 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 546:
#line 6387 "parser.y"
    { (yyval.int_val) = C_ARRAY_SIZE_NONE; ;}
    break;

  case 548:
#line 6389 "parser.y"
    { (yyval.int_val) = C_ARRAY_SIZE_VARIABLE; ;}
    break;

  case 551:
#line 6402 "parser.y"
    {
      c_ast_t *const ret_ast = (yyvsp[(3) - (3)].ast);

      DUMP_START( "block_decl_english_ast",
                  "BLOCK paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[(2) - (3)].ast_list) );
      DUMP_AST( "returning_english_ast_opt", ret_ast );

      (yyval.ast) = c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) );
      (yyval.ast)->block.param_ast_list = slist_move( &(yyvsp[(2) - (3)].ast_list) );
      c_ast_set_parent( ret_ast, (yyval.ast) );

      DUMP_AST( "block_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 552:
#line 6424 "parser.y"
    {
      DUMP_START( "constructor_decl_english_ast",
                  "CONSTRUCTOR paren_param_decl_list_english_opt" );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[(2) - (2)].ast_list) );

      (yyval.ast) = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      (yyval.ast)->ctor.param_ast_list = slist_move( &(yyvsp[(2) - (2)].ast_list) );

      DUMP_AST( "constructor_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 553:
#line 6441 "parser.y"
    {
      DUMP_START( "destructor_decl_english_ast", "DESTRUCTOR" );

      (yyval.ast) = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );

      DUMP_AST( "destructor_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 556:
#line 6462 "parser.y"
    {
      c_type_t const  func_qual_type = (yyvsp[(1) - (5)].type);
      unsigned const  flags = (yyvsp[(2) - (5)].flags);
      c_ast_t *const  ret_ast = (yyvsp[(5) - (5)].ast);

      DUMP_START( "func_decl_english_ast",
                  "ref_qualifier_english_stid_opt "
                  "member_or_non_member_flags_opt "
                  "FUNCTION paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_TYPE( "func_qualifier_english_type_opt", func_qual_type );
      DUMP_INT( "member_or_non_member_flags_opt", flags );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[(4) - (5)].ast_list) );
      DUMP_AST( "returning_english_ast_opt", ret_ast );

      (yyval.ast) = c_ast_new_gc( K_FUNCTION, &(yyloc) );
      (yyval.ast)->type = func_qual_type;
      (yyval.ast)->func.param_ast_list = slist_move( &(yyvsp[(4) - (5)].ast_list) );
      (yyval.ast)->func.flags = flags;
      c_ast_set_parent( ret_ast, (yyval.ast) );

      DUMP_AST( "func_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 557:
#line 6490 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) );
    ;}
    break;

  case 558:
#line 6494 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_A( (yyvsp[(1) - (1)].tid) );
    ;}
    break;

  case 565:
#line 6515 "parser.y"
    {
      c_type_t const  qual_type = (yyvsp[(1) - (6)].type);
      c_tid_t  const  ref_qual_stid = (yyvsp[(2) - (6)].tid);
      unsigned const  flags = (yyvsp[(3) - (6)].flags);
      c_ast_t *const  ret_ast = (yyvsp[(6) - (6)].ast);

      DUMP_START( "oper_decl_english_ast",
                  "type_qualifier_list_english_type_opt "
                  "ref_qualifier_english_stid_opt "
                  "member_or_non_member_flags_opt "
                  "OPERATOR paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_STR( "in_attr__operator", in_attr.operator->literal );
      DUMP_TYPE( "type_qualifier_list_english_type_opt", qual_type );
      DUMP_TID( "ref_qualifier_english_stid_opt", ref_qual_stid );
      DUMP_INT( "member_or_non_member_flags_opt", flags );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[(5) - (6)].ast_list) );
      DUMP_AST( "returning_english_ast_opt", ret_ast );

      (yyval.ast) = c_ast_new_gc( K_OPERATOR, &(yyloc) );
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &qual_type, &(yylsp[(1) - (6)]) ) );
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, ref_qual_stid, &(yylsp[(2) - (6)]) ) );
      (yyval.ast)->oper.operator = in_attr.operator;
      (yyval.ast)->oper.param_ast_list = slist_move( &(yyvsp[(5) - (6)].ast_list) );
      (yyval.ast)->oper.flags = flags;
      c_ast_set_parent( ret_ast, (yyval.ast) );

      DUMP_AST( "oper_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 566:
#line 6550 "parser.y"
    { slist_init( &(yyval.ast_list) ); ;}
    break;

  case 568:
#line 6556 "parser.y"
    {
      DUMP_START( "paren_param_decl_list_english",
                  "'(' param_decl_list_english_opt ')'" );
      DUMP_AST_LIST( "param_decl_list_english_opt", (yyvsp[(2) - (3)].ast_list) );

      (yyval.ast_list) = (yyvsp[(2) - (3)].ast_list);

      DUMP_AST_LIST( "paren_param_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 569:
#line 6569 "parser.y"
    { slist_init( &(yyval.ast_list) ); ;}
    break;

  case 571:
#line 6575 "parser.y"
    {
      DUMP_START( "param_decl_list_english",
                  "param_decl_list_english ',' decl_english_ast" );
      DUMP_AST_LIST( "param_decl_list_english", (yyvsp[(1) - (3)].ast_list) );
      DUMP_AST( "decl_english_ast", (yyvsp[(3) - (3)].ast) );

      (yyval.ast_list) = (yyvsp[(1) - (3)].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[(3) - (3)].ast) );

      DUMP_AST_LIST( "param_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 572:
#line 6589 "parser.y"
    {
      DUMP_START( "param_decl_list_english", "decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[(1) - (1)].ast) );

      if ( (yyvsp[(1) - (1)].ast)->kind == K_FUNCTION )     // see the comment in param_c_ast
        (yyvsp[(1) - (1)].ast) = c_ast_pointer( (yyvsp[(1) - (1)].ast), &gc_ast_list );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[(1) - (1)].ast) );

      DUMP_AST_LIST( "param_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    ;}
    break;

  case 574:
#line 6607 "parser.y"
    {
      elaborate_error( "declaration expected" );
    ;}
    break;

  case 575:
#line 6615 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 576:
#line 6616 "parser.y"
    { (yyval.tid) = TS_REFERENCE; ;}
    break;

  case 577:
#line 6617 "parser.y"
    { (yyval.tid) = TS_RVALUE_REFERENCE; ;}
    break;

  case 578:
#line 6624 "parser.y"
    {
      DUMP_START( "returning_english_ast_opt", "<empty>" );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      // see the comment in "type_c_ast"
      (yyval.ast)->type.btids = OPT_LANG_IS( IMPLICIT_int ) ? TB_INT : TB_VOID;

      DUMP_AST( "returning_english_ast_opt", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 580:
#line 6640 "parser.y"
    {
      DUMP_START( "returning_english_ast", "RETURNING decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[(2) - (2)].ast) );

      (yyval.ast) = (yyvsp[(2) - (2)].ast);

      DUMP_AST( "returning_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 581:
#line 6651 "parser.y"
    {
      elaborate_error( "English expected after \"returning\"" );
    ;}
    break;

  case 582:
#line 6660 "parser.y"
    {
      DUMP_START( "qualified_decl_english_ast",
                  "type_qualifier_list_english_type_opt "
                  "qualifiable_decl_english_ast" );
      DUMP_TYPE( "type_qualifier_list_english_type_opt", (yyvsp[(1) - (2)].type) );
      DUMP_AST( "qualifiable_decl_english_ast", (yyvsp[(2) - (2)].ast) );

      (yyval.ast) = (yyvsp[(2) - (2)].ast);
      if ( !c_type_is_none( &(yyvsp[(1) - (2)].type) ) )
        (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[(1) - (2)].type), &(yylsp[(1) - (2)]) ) );

      DUMP_AST( "qualified_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 583:
#line 6678 "parser.y"
    { (yyval.type) = T_NONE; ;}
    break;

  case 585:
#line 6684 "parser.y"
    {
      DUMP_START( "type_qualifier_list_english_type",
                  "type_qualifier_list_english_type "
                  "type_qualifier_english_type" );
      DUMP_TYPE( "type_qualifier_list_english_type", (yyvsp[(1) - (2)].type) );
      DUMP_TYPE( "type_qualifier_english_type", (yyvsp[(2) - (2)].type) );

      (yyval.type) = (yyvsp[(1) - (2)].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[(2) - (2)].type), &(yylsp[(2) - (2)]) ) );

      DUMP_TYPE( "type_qualifier_list_english_type", (yyval.type) );
      DUMP_END();
    ;}
    break;

  case 587:
#line 6702 "parser.y"
    { (yyval.type) = C_TYPE_LIT_A( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 588:
#line 6703 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 589:
#line 6704 "parser.y"
    { (yyval.type) = C_TYPE_LIT_S( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 590:
#line 6708 "parser.y"
    { (yyval.tid) = TA_CARRIES_DEPENDENCY; ;}
    break;

  case 593:
#line 6711 "parser.y"
    { (yyval.tid) = TA_MAYBE_UNUSED; ;}
    break;

  case 595:
#line 6713 "parser.y"
    { (yyval.tid) = TA_NODISCARD; ;}
    break;

  case 597:
#line 6715 "parser.y"
    { (yyval.tid) = TA_NORETURN; ;}
    break;

  case 600:
#line 6718 "parser.y"
    { (yyval.tid) = TA_NO_UNIQUE_ADDRESS; ;}
    break;

  case 606:
#line 6728 "parser.y"
    {
      (yyval.tid) = (yyvsp[(2) - (2)].tid);
    ;}
    break;

  case 615:
#line 6740 "parser.y"
    {
      (yyval.tid) = (yyvsp[(2) - (3)].tid);
    ;}
    break;

  case 620:
#line 6747 "parser.y"
    { (yyval.tid) = TS_NOEXCEPT; ;}
    break;

  case 625:
#line 6753 "parser.y"
    { (yyval.tid) = TS_THREAD_LOCAL; ;}
    break;

  case 631:
#line 6759 "parser.y"
    { (yyval.tid) = TS_PURE_VIRTUAL | (yyvsp[(2) - (2)].tid); ;}
    break;

  case 632:
#line 6763 "parser.y"
    { (yyval.tid) = TS_CONSTEVAL; ;}
    break;

  case 633:
#line 6764 "parser.y"
    { (yyval.tid) = TS_CONSTEXPR; ;}
    break;

  case 634:
#line 6765 "parser.y"
    { (yyval.tid) = TS_CONSTINIT; ;}
    break;

  case 635:
#line 6777 "parser.y"
    {
      bool ok = true;

      if ( strcmp( (yyvsp[(1) - (1)].str_val), "C" ) == 0 )
        (yyval.tid) = TS_EXTERN_C;
      else if ( strcmp( (yyvsp[(1) - (1)].str_val), "C++" ) == 0 )
        (yyval.tid) = TS_NONE;
      else {
        print_error( &(yylsp[(1) - (1)]), "\"%s\": unknown linkage language", (yyvsp[(1) - (1)].str_val) );
        print_hint( "\"C\" or \"C++\"" );
        ok = false;
      }

      free( (yyvsp[(1) - (1)].str_val) );
      PARSE_ASSERT( ok );
    ;}
    break;

  case 655:
#line 6834 "parser.y"
    {
      DUMP_START( "pointer_decl_english_ast", "POINTER TO decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[(3) - (3)].ast) );

      if ( (yyvsp[(3) - (3)].ast)->kind == K_NAME ) {       // see the comment in "declare_command"
        assert( !c_sname_empty( &(yyvsp[(3) - (3)].ast)->sname ) );
        print_error_unknown_name( &(yylsp[(3) - (3)]), &(yyvsp[(3) - (3)].ast)->sname );
        PARSE_ABORT();
      }

      (yyval.ast) = c_ast_new_gc( K_POINTER, &(yyloc) );
      c_ast_set_parent( (yyvsp[(3) - (3)].ast), (yyval.ast) );

      DUMP_AST( "pointer_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 656:
#line 6857 "parser.y"
    {
      c_tid_t  const  csu_btid = (yyvsp[(5) - (7)].tid);
      c_ast_t *const  decl_ast = (yyvsp[(7) - (7)].ast);

      DUMP_START( "pointer_to_member_decl_english",
                  "POINTER TO MEMBER OF "
                  "class_struct_union_btid_exp "
                  "sname_english decl_english_ast" );
      DUMP_TID( "class_struct_union_btid_exp", csu_btid );
      DUMP_SNAME( "sname_english_exp", (yyvsp[(6) - (7)].sname) );
      DUMP_AST( "decl_english_ast", decl_ast );

      (yyval.ast) = c_ast_new_gc( K_POINTER_TO_MEMBER, &(yyloc) );
      (yyval.ast)->ptr_mbr.class_sname = c_sname_move( &(yyvsp[(6) - (7)].sname) );
      c_ast_set_parent( decl_ast, (yyval.ast) );
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, csu_btid, &(yylsp[(5) - (7)]) ) );

      DUMP_AST( "pointer_to_member_decl_english", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 657:
#line 6879 "parser.y"
    {
      if ( OPT_LANG_IS( CPP_ANY ) )
        elaborate_error( "type name or \"member\" expected" );
      else
        elaborate_error( "type name expected" );
    ;}
    break;

  case 658:
#line 6892 "parser.y"
    {
      DUMP_START( "reference_decl_english_ast",
                  "reference_english_ast TO decl_english_ast" );
      DUMP_AST( "reference_english_ast", (yyvsp[(1) - (3)].ast) );
      DUMP_AST( "decl_english_ast", (yyvsp[(3) - (3)].ast) );

      (yyval.ast) = (yyvsp[(1) - (3)].ast);
      (yyval.ast)->loc = (yyloc);
      c_ast_set_parent( (yyvsp[(3) - (3)].ast), (yyval.ast) );

      DUMP_AST( "reference_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 659:
#line 6909 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_REFERENCE, &(yyloc) );
    ;}
    break;

  case 660:
#line 6914 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_RVALUE_REFERENCE, &(yyloc) );
    ;}
    break;

  case 661:
#line 6924 "parser.y"
    { //
      // User-defined literals are supported only in C++11 and later.
      // (However, we always allow them in configuration files.)
      //
      // This check is better to do now in the parser rather than later in the
      // AST because it has to be done in fewer places in the code plus gives a
      // better error location.
      //
      if ( UNSUPPORTED( USER_DEFINED_LITERAL ) ) {
        print_error( &(yylsp[(1) - (6)]),
          "user-defined literal not supported%s\n",
          C_LANG_WHICH( USER_DEFINED_LITERAL )
        );
        PARSE_ABORT();
      }

      DUMP_START( "user_defined_literal_decl_english_ast",
                  "USER-DEFINED LITERAL '(' param_decl_list_english_opt ')' "
                  "returning_english_ast_opt" );
      DUMP_AST_LIST( "param_decl_list_english_opt", (yyvsp[(4) - (6)].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[(6) - (6)].ast) );

      (yyval.ast) = c_ast_new_gc( K_USER_DEF_LITERAL, &(yyloc) );
      (yyval.ast)->udef_lit.param_ast_list = slist_move( &(yyvsp[(4) - (6)].ast_list) );
      c_ast_set_parent( (yyvsp[(6) - (6)].ast), (yyval.ast) );

      DUMP_AST( "user_defined_literal_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 662:
#line 6962 "parser.y"
    {
      DUMP_START( "var_decl_english_ast", "NAME AS decl_english_ast" );
      DUMP_SNAME( "sname", (yyvsp[(1) - (3)].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[(3) - (3)].ast) );

      if ( (yyvsp[(3) - (3)].ast)->kind == K_NAME ) {       // see the comment in "declare_command"
        assert( !c_sname_empty( &(yyvsp[(3) - (3)].ast)->sname ) );
        print_error_unknown_name( &(yylsp[(3) - (3)]), &(yyvsp[(3) - (3)].ast)->sname );
        c_sname_cleanup( &(yyvsp[(1) - (3)].sname) );
        PARSE_ABORT();
      }

      (yyval.ast) = (yyvsp[(3) - (3)].ast);
      (yyval.ast)->loc = (yyloc);
      c_sname_set( &(yyval.ast)->sname, &(yyvsp[(1) - (3)].sname) );

      DUMP_AST( "var_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 664:
#line 6991 "parser.y"
    {
      DUMP_START( "var_decl_english_ast", "..." );

      (yyval.ast) = c_ast_new_gc( K_VARIADIC, &(yyloc) );

      DUMP_AST( "var_decl_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 665:
#line 7008 "parser.y"
    {
      DUMP_START( "type_english_ast",
                  "type_modifier_list_english_type_opt "
                  "unmodified_type_english_ast" );
      DUMP_TYPE( "type_modifier_list_english_type_opt", (yyvsp[(1) - (2)].type) );
      DUMP_AST( "unmodified_type_english_ast", (yyvsp[(2) - (2)].ast) );

      (yyval.ast) = (yyvsp[(2) - (2)].ast);
      if ( !c_type_is_none( &(yyvsp[(1) - (2)].type) ) ) {
        // Set the AST's location to the entire rule only if the leading
        // optional rule is actually present, otherwise @$ refers to a column
        // before $2.
        (yyval.ast)->loc = (yyloc);
        PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[(1) - (2)].type), &(yylsp[(1) - (2)]) ) );
      }

      DUMP_AST( "type_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 666:
#line 7030 "parser.y"
    {
      DUMP_START( "type_english_ast", "type_modifier_list_english_type" );
      DUMP_TYPE( "type_modifier_list_english_type", (yyvsp[(1) - (1)].type) );

      // see the comment in "type_c_ast"
      c_type_t type =
        C_TYPE_LIT_B( OPT_LANG_IS( IMPLICIT_int ) ? TB_INT : TB_NONE );

      PARSE_ASSERT( c_type_add( &type, &(yyvsp[(1) - (1)].type), &(yylsp[(1) - (1)]) ) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type = type;

      DUMP_AST( "type_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 667:
#line 7049 "parser.y"
    { (yyval.type) = T_NONE; ;}
    break;

  case 669:
#line 7055 "parser.y"
    {
      DUMP_START( "type_modifier_list_english_type",
                  "type_modifier_list_english_type "
                  "type_modifier_english_type" );
      DUMP_TYPE( "type_modifier_list_english_type", (yyvsp[(1) - (2)].type) );
      DUMP_TYPE( "type_modifier_english_type", (yyvsp[(2) - (2)].type) );

      (yyval.type) = (yyvsp[(1) - (2)].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[(2) - (2)].type), &(yylsp[(2) - (2)]) ) );

      DUMP_TYPE( "type_modifier_list_english_type", (yyval.type) );
      DUMP_END();
    ;}
    break;

  case 676:
#line 7085 "parser.y"
    {
      DUMP_START( "builtin_type_english_ast",
                  "builtin_no_BitInt_english_btid" );
      DUMP_TID( "builtin_no_BitInt_english_btid", (yyvsp[(1) - (1)].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[(1) - (1)].tid), C_TPID_BASE );

      DUMP_AST( "builtin_type_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 677:
#line 7097 "parser.y"
    {
      DUMP_START( "builtin_type_english_ast", "BitInt_english_int" );
      DUMP_INT( "int", (yyvsp[(1) - (1)].int_val) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = TB_BITINT;
      (yyval.ast)->builtin.BitInt.width = STATIC_CAST( unsigned, (yyvsp[(1) - (1)].int_val) );

      DUMP_AST( "builtin_type_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 682:
#line 7116 "parser.y"
    {
      switch ( (yyvsp[(2) - (2)].int_val) ) {
        case  0: (yyval.tid) = TB_CHAR    ; break;
        case  8: (yyval.tid) = TB_CHAR8_T ; break;
        case 16: (yyval.tid) = TB_CHAR16_T; break;
        case 32: (yyval.tid) = TB_CHAR32_T; break;
        default:
          print_error( &(yylsp[(2) - (2)]), "bits must be one of 8, 16, or 32\n" );
          PARSE_ABORT();
      } // switch
    ;}
    break;

  case 687:
#line 7131 "parser.y"
    { (yyval.tid) = TB_WCHAR_T; ;}
    break;

  case 690:
#line 7134 "parser.y"
    { (yyval.tid) = TB_FLOAT; ;}
    break;

  case 691:
#line 7135 "parser.y"
    { (yyval.tid) = TB_DOUBLE; ;}
    break;

  case 694:
#line 7142 "parser.y"
    {
      (yyval.int_val) = (yyvsp[(2) - (3)].int_val);
    ;}
    break;

  case 695:
#line 7146 "parser.y"
    {
      (yyval.int_val) = (yyvsp[(3) - (4)].int_val);
    ;}
    break;

  case 696:
#line 7150 "parser.y"
    {
      (yyval.int_val) = (yyvsp[(3) - (4)].int_val);
    ;}
    break;

  case 697:
#line 7154 "parser.y"
    {
      elaborate_error( "integer literal, '(', or \"width\" expected" );
    ;}
    break;

  case 703:
#line 7172 "parser.y"
    {
      DUMP_START( "class_struct_union_english_ast",
                  "class_struct_union_btid sname" );
      DUMP_TID( "class_struct_union_btid", (yyvsp[(1) - (2)].tid) );
      DUMP_SNAME( "sname", (yyvsp[(2) - (2)].sname) );

      (yyval.ast) = c_ast_new_gc( (yyvsp[(1) - (2)].tid) == TB_ENUM ? K_ENUM : K_CLASS_STRUCT_UNION, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[(1) - (2)].tid), C_TPID_BASE );
      (yyval.ast)->csu.csu_sname = c_sname_move( &(yyvsp[(2) - (2)].sname) );

      DUMP_AST( "enum_class_struct_union_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 704:
#line 7189 "parser.y"
    {
      DUMP_START( "enum_english_ast",
                  "enum_btid sname of_type_enum_fixed_type_english_ast_opt" );
      DUMP_TID( "enum_btid", (yyvsp[(1) - (3)].tid) );
      DUMP_SNAME( "sname", (yyvsp[(2) - (3)].sname) );
      DUMP_AST( "enum_fixed_type_english_ast", (yyvsp[(3) - (3)].ast) );

      (yyval.ast) = c_ast_new_gc(  K_ENUM, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[(1) - (3)].tid), C_TPID_BASE );
      (yyval.ast)->enum_.of_ast = (yyvsp[(3) - (3)].ast);
      (yyval.ast)->enum_.enum_sname = c_sname_move( &(yyvsp[(2) - (3)].sname) );

      DUMP_AST( "enum_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 705:
#line 7207 "parser.y"
    { (yyval.ast) = NULL; ;}
    break;

  case 706:
#line 7209 "parser.y"
    {
      (yyval.ast) = (yyvsp[(3) - (3)].ast);
    ;}
    break;

  case 707:
#line 7217 "parser.y"
    {
      DUMP_START( "enum_fixed_type_english_ast",
                  "enum_fixed_type_modifier_list_stid" );
      DUMP_TID( "enum_fixed_type_modifier_list_stid", (yyvsp[(1) - (2)].tid) );
      DUMP_AST( "enum_unmodified_fixed_type_english_ast", (yyvsp[(2) - (2)].ast) );

      (yyval.ast) = (yyvsp[(2) - (2)].ast);
      if ( (yyvsp[(1) - (2)].tid) != TB_NONE ) {            // See comment in type_english_ast.
        (yyval.ast)->loc = (yyloc);
        PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[(1) - (2)].tid), &(yylsp[(1) - (2)]) ) );
      }

      DUMP_AST( "enum_fixed_type_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 708:
#line 7234 "parser.y"
    {
      DUMP_START( "enum_fixed_type_english_ast",
                  "enum_fixed_type_modifier_list_english_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyvsp[(1) - (1)].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[(1) - (1)].tid), C_TPID_BASE );

      DUMP_AST( "enum_fixed_type_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 709:
#line 7248 "parser.y"
    { (yyval.tid) = TB_NONE; ;}
    break;

  case 711:
#line 7254 "parser.y"
    {
      DUMP_START( "enum_fixed_type_modifier_list_english_btid",
                  "enum_fixed_type_modifier_list_english_btid "
                  "enum_fixed_type_modifier_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyvsp[(1) - (2)].tid) );
      DUMP_TID( "enum_fixed_type_modifier_btid", (yyvsp[(2) - (2)].tid) );

      (yyval.tid) = (yyvsp[(1) - (2)].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[(2) - (2)].tid), &(yylsp[(2) - (2)]) ) );

      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyval.tid) );
      DUMP_END();
    ;}
    break;

  case 716:
#line 7283 "parser.y"
    {
      assert( c_sname_count( &(yyvsp[(1) - (1)].tdef)->ast->sname ) == 1 );
      (yyval.name) = check_strdup( c_sname_local_name( &(yyvsp[(1) - (1)].tdef)->ast->sname ) );
    ;}
    break;

  case 718:
#line 7292 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error( "name expected" );
    ;}
    break;

  case 722:
#line 7306 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    ;}
    break;

  case 723:
#line 7313 "parser.y"
    { c_sname_init( &(yyval.sname) ); ;}
    break;

  case 727:
#line 7324 "parser.y"
    {
      DUMP_START( "name_ast", "NAME" );
      DUMP_STR( "NAME", (yyvsp[(1) - (1)].name) );

      (yyval.ast) = c_ast_new_gc( K_NAME, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[(1) - (1)].name) );

      DUMP_AST( "name_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 729:
#line 7339 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error( "name expected" );
    ;}
    break;

  case 730:
#line 7346 "parser.y"
    { c_sname_init( &(yyval.sname) ); ;}
    break;

  case 731:
#line 7349 "parser.y"
    {
      (yyval.sname) = (yyvsp[(1) - (2)].sname);
      if ( c_type_is_none( c_sname_local_type( &(yyval.sname) ) ) )
        c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_SCOPE ) );
    ;}
    break;

  case 732:
#line 7358 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();
      c_ast_t const *type_for_ast = (yyvsp[(1) - (2)].tdef)->ast;

      DUMP_START( "typedef_type_c_ast", "any_typedef" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "any_typedef.ast", type_for_ast );
      DUMP_SNAME( "sub_scope_sname_c_opt", (yyvsp[(2) - (2)].sname) );

      if ( c_sname_empty( &(yyvsp[(2) - (2)].sname) ) ) {
ttntd:  (yyval.ast) = c_ast_new_gc( K_TYPEDEF, &(yyloc) );
        (yyval.ast)->type.btids = TB_TYPEDEF;
        (yyval.ast)->tdef.for_ast = type_for_ast;
      }
      else {
        c_sname_t temp_name = c_sname_dup( &(yyvsp[(1) - (2)].tdef)->ast->sname );
        c_sname_append_sname( &temp_name, &(yyvsp[(2) - (2)].sname) );

        if ( type_ast == NULL ) {
          //
          // This is for a case like:
          //
          //      define S as struct S
          //      explain S::T x
          //
          // that is: a typedef'd type followed by ::T where T is an unknown
          // name used as a type. Just assume the T is a type and create a name
          // for it.
          //
          c_ast_t *const name_ast = c_ast_new_gc( K_NAME, &(yylsp[(2) - (2)]) );
          c_sname_set( &name_ast->sname, &temp_name );
          type_for_ast = name_ast;
          goto ttntd;
        }

        //
        // Otherwise, this is for cases like:
        //
        //  1. A typedef'd type used for a scope:
        //
        //          define S as struct S
        //          explain int S::x
        //
        //  2. A typedef'd type used for an intermediate scope:
        //
        //          define S as struct S
        //          define T as struct T
        //          explain int S::T::x
        //
        (yyval.ast) = type_ast;
        c_sname_set( &(yyval.ast)->sname, &temp_name );
      }

      DUMP_AST( "typedef_type_c_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 733:
#line 7417 "parser.y"
    { c_sname_init( &(yyval.sname) ); ;}
    break;

  case 734:
#line 7418 "parser.y"
    { (yyval.sname) = (yyvsp[(2) - (2)].sname); ;}
    break;

  case 735:
#line 7423 "parser.y"
    {
      // see the comment in "of_scope_english"
      if ( UNSUPPORTED( CPP_ANY ) ) {
        print_error( &(yylsp[(2) - (3)]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( CPP_ANY )
        );
        c_sname_cleanup( &(yyvsp[(1) - (3)].sname) );
        free( (yyvsp[(3) - (3)].name) );
        PARSE_ABORT();
      }

      DUMP_START( "sname_c", "sname_c '::' NAME" );
      DUMP_SNAME( "sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_STR( "name", (yyvsp[(3) - (3)].name) );

      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_SCOPE ) );
      c_sname_append_name( &(yyval.sname), (yyvsp[(3) - (3)].name) );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 736:
#line 7448 "parser.y"
    { //
      // This is for a case like:
      //
      //      define S::int8_t as char
      //
      // that is: the type int8_t is an existing type in no scope being defined
      // as a distinct type in a new scope.
      //
      DUMP_START( "sname_c", "sname_c '::' any_typedef" );
      DUMP_SNAME( "sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_AST( "any_typedef.ast", (yyvsp[(3) - (3)].tdef)->ast );

      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_SCOPE ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[(3) - (3)].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 737:
#line 7470 "parser.y"
    {
      DUMP_START( "sname_c", "NAME" );
      DUMP_STR( "NAME", (yyvsp[(1) - (1)].name) );

      c_sname_init_name( &(yyval.sname), (yyvsp[(1) - (1)].name) );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 738:
#line 7484 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();
      unsigned const bit_width = STATIC_CAST( unsigned, (yyvsp[(2) - (2)].uint_val) );

      DUMP_START( "sname_c_ast", "sname_c" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "sname", (yyvsp[(1) - (2)].sname) );
      DUMP_INT( "bit_field_c_uint_opt", bit_width );

      (yyval.ast) = type_ast;
      c_sname_set( &(yyval.ast)->sname, &(yyvsp[(1) - (2)].sname) );

      bool ok = true;
      //
      // This check has to be done now in the parser rather than later in the
      // AST since we need to use the builtin union member now.
      //
      if ( bit_width != 0 && (ok = c_ast_is_bit_field_kind( (yyval.ast) )) )
        (yyval.ast)->bit_field.bit_width = bit_width;

      DUMP_AST( "sname_c_ast", (yyval.ast) );
      DUMP_END();

      if ( !ok ) {
        print_error( &(yylsp[(2) - (2)]),
          "bit-fields can be only of integral %stypes\n",
          OPT_LANG_IS( enum_BITFIELDS ) ? "or enumeration " : ""
        );
        PARSE_ABORT();
      }
    ;}
    break;

  case 739:
#line 7518 "parser.y"
    { (yyval.uint_val) = 0; ;}
    break;

  case 740:
#line 7520 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we use 0 to mean "no bit-field."
      //
      if ( (yyvsp[(2) - (2)].int_val) == 0 ) {
        print_error( &(yylsp[(2) - (2)]), "bit-field width must be > 0\n" );
        PARSE_ABORT();
      }
      (yyval.uint_val) = STATIC_CAST( unsigned, (yyvsp[(2) - (2)].int_val) );
    ;}
    break;

  case 742:
#line 7535 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    ;}
    break;

  case 743:
#line 7542 "parser.y"
    { c_sname_init( &(yyval.sname) ); ;}
    break;

  case 745:
#line 7548 "parser.y"
    {
      DUMP_START( "sname_english", "any_sname_c of_scope_list_english_opt" );
      DUMP_SNAME( "any_sname_c", (yyvsp[(1) - (2)].sname) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[(2) - (2)].sname) );

      c_type_t const *local_type = c_sname_local_type( &(yyvsp[(2) - (2)].sname) );
      if ( c_type_is_none( local_type ) )
        local_type = c_sname_local_type( &(yyvsp[(1) - (2)].sname) );
      (yyval.sname) = (yyvsp[(2) - (2)].sname);
      c_sname_append_sname( &(yyval.sname), &(yyvsp[(1) - (2)].sname) );
      c_sname_set_local_type( &(yyval.sname), local_type );

      DUMP_SNAME( "sname_english", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 746:
#line 7567 "parser.y"
    {
      DUMP_START( "sname_english_ast", "NAME of_scope_list_english_opt" );
      DUMP_STR( "NAME", (yyvsp[(1) - (2)].name) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[(2) - (2)].sname) );

      c_sname_t sname = c_sname_move( &(yyvsp[(2) - (2)].sname) );
      c_sname_append_name( &sname, (yyvsp[(1) - (2)].name) );

      //
      // See if the full name is the name of a typedef'd type.
      //
      c_typedef_t const *const tdef = c_typedef_find_sname( &sname );
      if ( tdef != NULL ) {
        (yyval.ast) = c_ast_new_gc( K_TYPEDEF, &(yyloc) );
        (yyval.ast)->type.btids = TB_TYPEDEF;
        (yyval.ast)->tdef.for_ast = tdef->ast;
        c_sname_cleanup( &sname );
      } else {
        (yyval.ast) = c_ast_new_gc( K_NAME, &(yyloc) );
        c_sname_set( &(yyval.ast)->sname, &sname );
      }

      DUMP_AST( "sname_english_ast", (yyval.ast) );
      DUMP_END();
    ;}
    break;

  case 748:
#line 7597 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    ;}
    break;

  case 749:
#line 7604 "parser.y"
    { c_sname_init( &(yyval.sname) ); ;}
    break;

  case 751:
#line 7610 "parser.y"
    {
      DUMP_START( "sname_list_english",
                  "sname_list_english ',' sname_english" );
      DUMP_SNAME_LIST( "sname_list_english", (yyvsp[(1) - (3)].list) );
      DUMP_SNAME( "sname_english", (yyvsp[(3) - (3)].sname) );

      (yyval.list) = (yyvsp[(1) - (3)].list);
      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[(3) - (3)].sname) );
      slist_push_back( &(yyval.list), temp_sname );

      DUMP_SNAME_LIST( "sname_list_english", (yyval.list) );
      DUMP_END();
    ;}
    break;

  case 752:
#line 7626 "parser.y"
    {
      DUMP_START( "sname_list_english", "sname_english" );
      DUMP_SNAME( "sname_english", (yyvsp[(1) - (1)].sname) );

      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[(1) - (1)].sname) );
      slist_init( &(yyval.list) );
      slist_push_back( &(yyval.list), temp_sname );

      DUMP_SNAME_LIST( "sname_list_english", (yyval.list) );
      DUMP_END();
    ;}
    break;

  case 753:
#line 7642 "parser.y"
    {
      DUMP_START( "typedef_sname_c", "typedef_sname_c '::' sname_c" );
      DUMP_SNAME( "typedef_sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_SNAME( "sname_c", (yyvsp[(3) - (3)].sname) );

      //
      // This is for a case like:
      //
      //      define S as struct S
      //      define S::T as struct T
      //
      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_append_sname( &(yyval.sname), &(yyvsp[(3) - (3)].sname) );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 754:
#line 7661 "parser.y"
    {
      DUMP_START( "typedef_sname_c", "typedef_sname_c '::' any_typedef" );
      DUMP_SNAME( "typedef_sname_c", (yyvsp[(1) - (3)].sname) );
      DUMP_AST( "any_typedef", (yyvsp[(3) - (3)].tdef)->ast );

      //
      // This is for a case like:
      //
      //      define S as struct S
      //      define T as struct T
      //      define S::T as struct S_T
      //
      (yyval.sname) = (yyvsp[(1) - (3)].sname);
      c_sname_set_local_type( &(yyval.sname), c_sname_local_type( &(yyvsp[(3) - (3)].tdef)->ast->sname ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[(3) - (3)].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    ;}
    break;

  case 755:
#line 7682 "parser.y"
    { (yyval.sname) = c_sname_dup( &(yyvsp[(1) - (1)].tdef)->ast->sname ); ;}
    break;

  case 757:
#line 7692 "parser.y"
    {
      keyword_expected( L_address );
    ;}
    break;

  case 759:
#line 7700 "parser.y"
    {
      keyword_expected( L_array );
    ;}
    break;

  case 760:
#line 7707 "parser.y"
    {
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        //
        // For either "declare" or "define", neither "override" nor "final"
        // must be matched initially to allow for cases like:
        //
        //      c++decl> declare final as int
        //      int final;
        //
        // (which is legal).  However, in C++, after parsing "as", the keyword
        // context has to be set to C_KW_CTX_MBR_FUNC to be able to match
        // "override" and "final", e.g.:
        //
        //      c++decl> declare f as final function
        //      void f() final;
        //
        lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
      }
    ;}
    break;

  case 761:
#line 7727 "parser.y"
    {
      keyword_expected( L_as );
    ;}
    break;

  case 765:
#line 7737 "parser.y"
    {
      elaborate_error( "\"as\", \"into\", or \"to\" expected" );
    ;}
    break;

  case 775:
#line 7762 "parser.y"
    {
      keyword_expected( L_cast );
    ;}
    break;

  case 777:
#line 7770 "parser.y"
    {
      keyword_expected( L_char );
    ;}
    break;

  case 779:
#line 7778 "parser.y"
    {
      elaborate_error( "\"class\", \"struct\", or \"union\" expected" );
    ;}
    break;

  case 781:
#line 7786 "parser.y"
    {
      punct_expected( ':' );
    ;}
    break;

  case 783:
#line 7794 "parser.y"
    {
      punct_expected( ',' );
    ;}
    break;

  case 785:
#line 7802 "parser.y"
    {
      keyword_expected( L_conversion );
    ;}
    break;

  case 786:
#line 7808 "parser.y"
    { (yyval.oper_id) = C_OP_CO_AWAIT          ; ;}
    break;

  case 787:
#line 7809 "parser.y"
    { (yyval.oper_id) = C_OP_NEW               ; ;}
    break;

  case 788:
#line 7810 "parser.y"
    { (yyval.oper_id) = C_OP_NEW_ARRAY         ; ;}
    break;

  case 789:
#line 7811 "parser.y"
    { (yyval.oper_id) = C_OP_DELETE            ; ;}
    break;

  case 790:
#line 7812 "parser.y"
    { (yyval.oper_id) = C_OP_DELETE_ARRAY      ; ;}
    break;

  case 791:
#line 7813 "parser.y"
    { (yyval.oper_id) = C_OP_EXCLAM            ; ;}
    break;

  case 792:
#line 7814 "parser.y"
    { (yyval.oper_id) = C_OP_EXCLAM_EQUAL      ; ;}
    break;

  case 793:
#line 7815 "parser.y"
    { (yyval.oper_id) = C_OP_PERCENT           ; ;}
    break;

  case 794:
#line 7816 "parser.y"
    { (yyval.oper_id) = C_OP_PERCENT_EQUAL     ; ;}
    break;

  case 795:
#line 7817 "parser.y"
    { (yyval.oper_id) = C_OP_AMPER             ; ;}
    break;

  case 796:
#line 7818 "parser.y"
    { (yyval.oper_id) = C_OP_AMPER2            ; ;}
    break;

  case 797:
#line 7819 "parser.y"
    { (yyval.oper_id) = C_OP_AMPER_EQUAL       ; ;}
    break;

  case 798:
#line 7820 "parser.y"
    { (yyval.oper_id) = C_OP_PARENS            ; ;}
    break;

  case 799:
#line 7821 "parser.y"
    { (yyval.oper_id) = C_OP_STAR              ; ;}
    break;

  case 800:
#line 7822 "parser.y"
    { (yyval.oper_id) = C_OP_STAR_EQUAL        ; ;}
    break;

  case 801:
#line 7823 "parser.y"
    { (yyval.oper_id) = C_OP_PLUS              ; ;}
    break;

  case 802:
#line 7824 "parser.y"
    { (yyval.oper_id) = C_OP_PLUS2             ; ;}
    break;

  case 803:
#line 7825 "parser.y"
    { (yyval.oper_id) = C_OP_PLUS_EQUAL        ; ;}
    break;

  case 804:
#line 7826 "parser.y"
    { (yyval.oper_id) = C_OP_COMMA             ; ;}
    break;

  case 805:
#line 7827 "parser.y"
    { (yyval.oper_id) = C_OP_MINUS             ; ;}
    break;

  case 806:
#line 7828 "parser.y"
    { (yyval.oper_id) = C_OP_MINUS2            ; ;}
    break;

  case 807:
#line 7829 "parser.y"
    { (yyval.oper_id) = C_OP_MINUS_EQUAL       ; ;}
    break;

  case 808:
#line 7830 "parser.y"
    { (yyval.oper_id) = C_OP_ARROW             ; ;}
    break;

  case 809:
#line 7831 "parser.y"
    { (yyval.oper_id) = C_OP_ARROW_STAR        ; ;}
    break;

  case 810:
#line 7832 "parser.y"
    { (yyval.oper_id) = C_OP_DOT               ; ;}
    break;

  case 811:
#line 7833 "parser.y"
    { (yyval.oper_id) = C_OP_DOT_STAR          ; ;}
    break;

  case 812:
#line 7834 "parser.y"
    { (yyval.oper_id) = C_OP_SLASH             ; ;}
    break;

  case 813:
#line 7835 "parser.y"
    { (yyval.oper_id) = C_OP_SLASH_EQUAL       ; ;}
    break;

  case 814:
#line 7836 "parser.y"
    { (yyval.oper_id) = C_OP_COLON2            ; ;}
    break;

  case 815:
#line 7837 "parser.y"
    { (yyval.oper_id) = C_OP_LESS              ; ;}
    break;

  case 816:
#line 7838 "parser.y"
    { (yyval.oper_id) = C_OP_LESS2             ; ;}
    break;

  case 817:
#line 7839 "parser.y"
    { (yyval.oper_id) = C_OP_LESS2_EQUAL       ; ;}
    break;

  case 818:
#line 7840 "parser.y"
    { (yyval.oper_id) = C_OP_LESS_EQUAL        ; ;}
    break;

  case 819:
#line 7841 "parser.y"
    { (yyval.oper_id) = C_OP_LESS_EQUAL_GREATER; ;}
    break;

  case 820:
#line 7842 "parser.y"
    { (yyval.oper_id) = C_OP_EQUAL             ; ;}
    break;

  case 821:
#line 7843 "parser.y"
    { (yyval.oper_id) = C_OP_EQUAL2            ; ;}
    break;

  case 822:
#line 7844 "parser.y"
    { (yyval.oper_id) = C_OP_GREATER           ; ;}
    break;

  case 823:
#line 7845 "parser.y"
    { (yyval.oper_id) = C_OP_GREATER2          ; ;}
    break;

  case 824:
#line 7846 "parser.y"
    { (yyval.oper_id) = C_OP_GREATER2_EQUAL    ; ;}
    break;

  case 825:
#line 7847 "parser.y"
    { (yyval.oper_id) = C_OP_GREATER_EQUAL     ; ;}
    break;

  case 826:
#line 7848 "parser.y"
    { (yyval.oper_id) = C_OP_QMARK_COLON       ; ;}
    break;

  case 827:
#line 7849 "parser.y"
    { (yyval.oper_id) = C_OP_BRACKETS          ; ;}
    break;

  case 828:
#line 7850 "parser.y"
    { (yyval.oper_id) = C_OP_CARET             ; ;}
    break;

  case 829:
#line 7851 "parser.y"
    { (yyval.oper_id) = C_OP_CARET_EQUAL       ; ;}
    break;

  case 830:
#line 7852 "parser.y"
    { (yyval.oper_id) = C_OP_PIPE              ; ;}
    break;

  case 831:
#line 7853 "parser.y"
    { (yyval.oper_id) = C_OP_PIPE2             ; ;}
    break;

  case 832:
#line 7854 "parser.y"
    { (yyval.oper_id) = C_OP_PIPE_EQUAL        ; ;}
    break;

  case 833:
#line 7855 "parser.y"
    { (yyval.oper_id) = C_OP_TILDE             ; ;}
    break;

  case 835:
#line 7861 "parser.y"
    {
      keyword_expected( L_default );
    ;}
    break;

  case 837:
#line 7869 "parser.y"
    {
      keyword_expected( L_defined );
    ;}
    break;

  case 839:
#line 7877 "parser.y"
    {
      keyword_expected( L_dependency );
    ;}
    break;

  case 841:
#line 7885 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      PARSE_ABORT();
    ;}
    break;

  case 843:
#line 7894 "parser.y"
    {
      punct_expected( '=' );
    ;}
    break;

  case 844:
#line 7900 "parser.y"
    { (yyval.tid) = (yyvsp[(2) - (2)].tid); ;}
    break;

  case 845:
#line 7902 "parser.y"
    {
      print_error( &(yylsp[(3) - (3)]),
        "scoped linkage declarations not supported by %s\n", CDECL
      );
      PARSE_ABORT();
    ;}
    break;

  case 846:
#line 7911 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 848:
#line 7917 "parser.y"
    {
      if ( OPT_LANG_IS( C_ANY ) && strchr( (yyvsp[(1) - (1)].name), ':' ) != NULL ) {
        print_error( &(yylsp[(1) - (1)]), "scoped names not supported in C\n" );
        free( (yyvsp[(1) - (1)].name) );
        PARSE_ABORT();
      }
      (yyval.name) = (yyvsp[(1) - (1)].name);
    ;}
    break;

  case 849:
#line 7928 "parser.y"
    { (yyval.name) = NULL; ;}
    break;

  case 852:
#line 7935 "parser.y"
    {
      punct_expected( '>' );
    ;}
    break;

  case 853:
#line 7941 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 856:
#line 7948 "parser.y"
    {
      elaborate_error( "int[eger] expected" );
    ;}
    break;

  case 858:
#line 7956 "parser.y"
    {
      elaborate_error( "integer literal expected" );
    ;}
    break;

  case 859:
#line 7962 "parser.y"
    { (yyval.int_val) = 0; ;}
    break;

  case 862:
#line 7969 "parser.y"
    {
      keyword_expected( L_literal );
    ;}
    break;

  case 864:
#line 7977 "parser.y"
    {
      keyword_expected( L_local );
    ;}
    break;

  case 866:
#line 7985 "parser.y"
    {
      punct_expected( '(' );
    ;}
    break;

  case 868:
#line 7993 "parser.y"
    {
      punct_expected( '<' );
    ;}
    break;

  case 869:
#line 7999 "parser.y"
    { (yyval.flags) = C_FUNC_UNSPECIFIED; ;}
    break;

  case 870:
#line 8000 "parser.y"
    { (yyval.flags) = C_FUNC_MEMBER     ; ;}
    break;

  case 871:
#line 8001 "parser.y"
    { (yyval.flags) = C_FUNC_NON_MEMBER ; ;}
    break;

  case 873:
#line 8007 "parser.y"
    {
      keyword_expected( L_namespace );
    ;}
    break;

  case 874:
#line 8013 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 875:
#line 8014 "parser.y"
    { (yyval.type) = C_TYPE_LIT( (yyvsp[(2) - (2)].tid), (yyvsp[(1) - (2)].tid), TA_NONE ); ;}
    break;

  case 877:
#line 8020 "parser.y"
    {
      keyword_expected( L_of );
    ;}
    break;

  case 878:
#line 8027 "parser.y"
    { //
      // Scoped names are supported only in C++.  (However, we always allow
      // them in configuration files.)
      //
      // This check is better to do now in the parser rather than later in the
      // AST because it has to be done in fewer places in the code plus gives a
      // better error location.
      //
      if ( UNSUPPORTED( CPP_ANY ) ) {
        print_error( &(yylsp[(2) - (3)]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( CPP_ANY )
        );
        c_sname_cleanup( &(yyvsp[(3) - (3)].sname) );
        PARSE_ABORT();
      }
      (yyval.sname) = (yyvsp[(3) - (3)].sname);
      c_sname_set_local_type( &(yyval.sname), &(yyvsp[(2) - (3)].type) );
    ;}
    break;

  case 879:
#line 8050 "parser.y"
    {
      (yyval.sname) = (yyvsp[(2) - (2)].sname);                          // "of scope X of scope Y" means Y::X
      c_sname_append_sname( &(yyval.sname), &(yyvsp[(1) - (2)].sname) );
      c_sname_fill_in_namespaces( &(yyval.sname) );
      if ( !c_sname_check( &(yyval.sname), &(yylsp[(1) - (2)]) ) ) {
        c_sname_cleanup( &(yyval.sname) );
        PARSE_ABORT();
      }
    ;}
    break;

  case 881:
#line 8063 "parser.y"
    { c_sname_init( &(yyval.sname) ); ;}
    break;

  case 884:
#line 8070 "parser.y"
    {
      keyword_expected( L_operator );
    ;}
    break;

  case 888:
#line 8083 "parser.y"
    {
      keyword_expected( L_point );
    ;}
    break;

  case 892:
#line 8095 "parser.y"
    {
      elaborate_error( "\"\" expected" );
    ;}
    break;

  case 894:
#line 8103 "parser.y"
    {
      punct_expected( '}' );
    ;}
    break;

  case 896:
#line 8111 "parser.y"
    {
      punct_expected( ']' );
    ;}
    break;

  case 898:
#line 8119 "parser.y"
    {
      keyword_expected( L_reference );
    ;}
    break;

  case 902:
#line 8132 "parser.y"
    {
      keyword_expected( L_returning );
    ;}
    break;

  case 904:
#line 8140 "parser.y"
    {
      punct_expected( ')' );
    ;}
    break;

  case 905:
#line 8146 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( (yyvsp[(1) - (1)].tid) ); ;}
    break;

  case 907:
#line 8148 "parser.y"
    { (yyval.type) = C_TYPE_LIT_B( TB_SCOPE ); ;}
    break;

  case 909:
#line 8154 "parser.y"
    {
      elaborate_error(
        "\"class\", \"namespace\", \"scope\", \"struct\", or \"union\" expected"
      );
    ;}
    break;

  case 911:
#line 8164 "parser.y"
    {
      punct_expected( ';' );
    ;}
    break;

  case 916:
#line 8180 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 919:
#line 8187 "parser.y"
    {
      (yyval.str_val) = NULL;
      PARSE_ABORT();
    ;}
    break;

  case 921:
#line 8196 "parser.y"
    {
      (yyval.str_val) = NULL;
      elaborate_error( "string literal expected" );
    ;}
    break;

  case 923:
#line 8205 "parser.y"
    {
      keyword_expected( L_this );
    ;}
    break;

  case 924:
#line 8211 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;

  case 927:
#line 8218 "parser.y"
    {
      keyword_expected( L_to );
    ;}
    break;

  case 930:
#line 8229 "parser.y"
    { (yyval.flag) = false; ;}
    break;

  case 931:
#line 8230 "parser.y"
    { (yyval.flag) = true; ;}
    break;

  case 933:
#line 8236 "parser.y"
    {
      keyword_expected( L_unused );
    ;}
    break;

  case 937:
#line 8249 "parser.y"
    {
      keyword_expected( L_virtual );
    ;}
    break;

  case 938:
#line 8255 "parser.y"
    { (yyval.tid) = TS_NONE; ;}
    break;


/* Line 1267 of yacc.c.  */
#line 11679 "parser.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, &yylloc);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 8259 "parser.y"


/// @endcond

// Re-enable warnings.
#ifdef __GNUC__
# pragma GCC diagnostic pop
#endif /* __GNUC__ */

/**
 * @addtogroup parser-group
 * @{
 */

////////// local functions ////////////////////////////////////////////////////

/**
 * Prints an additional parsing error message including a newline to standard
 * error that continues from where yyerror() left off.  Additionally:
 *
 * + If the printable_token() isn't NULL:
 *     + Checks to see if it's a keyword: if it is, mentions that it's a
 *       keyword in the error message.
 *     + May print "did you mean ...?" \a dym_kinds suggestions.
 *
 * + In debug mode, also prints the file & line where the function was called
 *   from as well as the ID of the lookahead token, if any.
 *
 * @note This function isn't normally called directly; use the
 * #elaborate_error() macro instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param dym_kinds The bitwise-or of the kind(s) of things possibly meant.
 * @param format A `printf()` style format string.
 * @param ... Arguments to print.
 *
 * @sa fl_keyword_expected()
 * @sa fl_punct_expected()
 * @sa yyerror()
 */
PJL_PRINTF_LIKE_FUNC(4)
static void fl_elaborate_error( char const *file, int line,
                                dym_kind_t dym_kinds, char const *format,
                                ... ) {
  assert( format != NULL );

  EPUTS( ": " );
  print_debug_file_line( file, line );

  char const *const error_token = printable_token();
  if ( error_token != NULL ) {
    EPRINTF( "\"%s\"", error_token );
#ifdef ENABLE_CDECL_DEBUG
    if ( opt_cdecl_debug ) {
      switch ( yychar ) {
        case YYEMPTY:
          EPUTS( " [<empty>]" );
          break;
        case YYEOF:
          EPUTS( " [<EOF>]" );
          break;
        default:
          EPRINTF( " [%d]", yychar );
      } // switch
    }
#endif /* ENABLE_CDECL_DEBUG */
    EPUTS( ": " );
  }

  va_list args;
  va_start( args, format );
  vfprintf( stderr, format, args );
  va_end( args );

  if ( error_token != NULL ) {
    c_keyword_t const *const ck =
      c_keyword_find( error_token, LANG_ANY, C_KW_CTX_DEFAULT );
    if ( ck != NULL ) {
      c_lang_id_t const oldest_lang = c_lang_oldest( ck->lang_ids );
      if ( oldest_lang > opt_lang )
        EPRINTF( "; not a keyword until %s", c_lang_name( oldest_lang ) );
      else
        EPRINTF( " (\"%s\" is a keyword)", error_token );
    }
    else if ( cdecl_mode == CDECL_ENGLISH_TO_GIBBERISH ) {
      cdecl_keyword_t const *const cdk = cdecl_keyword_find( error_token );
      if ( cdk != NULL )
        EPRINTF( " (\"%s\" is a cdecl keyword)", error_token );
    }

    print_suggestions( dym_kinds, error_token );
  }

  EPUTC( '\n' );
}

////////// extern functions ///////////////////////////////////////////////////

void parser_cleanup( void ) {
  c_ast_list_gc( &typedef_ast_list );
}

///////////////////////////////////////////////////////////////////////////////

/** @} */

/* vim:set et sw=2 ts=2: */

