/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class PDisplayStyle {
    private Graphics g;
    private Font font;
    private FontMetrics fm;
    private int wid;
    private int indent;
    private int indentDel;
    private int pitch;
    private int spaceWidth;
    private boolean measureMode;
    private int x;
    private int y;
    public static final int drawStyle_onerow = 0;
    public static final int drawStyle_multirow = 1;

    private void init(int wid_) {
        this.font = new Font("Serif", 0, 12);
        this.g.setFont(this.font);
        this.fm = this.g.getFontMetrics();
        this.wid = wid_;
        this.pitch = this.fm.getHeight();
        this.spaceWidth = this.fm.stringWidth(" ");
        this.indentDel = 2 * this.pitch;
        this.x = this.indent = 10;
        this.y = this.pitch;
        this.measureMode = false;
    }

    public PDisplayStyle(Graphics g_, int wid_, boolean forMeasure) {
        this.g = g_;
        this.init(wid_);
        this.g = null;
    }

    public PDisplayStyle(Graphics g_, int wid_) {
        this.g = g_;
        this.init(wid_);
        this.g.setFont(this.font);
    }

    public int getRowHeight() {
        return this.pitch;
    }

    public int getWidth(String s) {
        return this.fm.stringWidth(s) + this.spaceWidth;
    }

    private int measureWidth(PAbstract obj) {
        this.measureMode = true;
        int saved_x = this.x;
        int saved_y = this.y;
        this.x = 0;
        this.y = 0;
        obj.draw(this, 0);
        int w = this.x;
        this.x = saved_x;
        this.y = saved_y;
        this.measureMode = false;
        return w;
    }

    public int getDrawStyle(PAbstract obj) {
        int drawStyle = 0;
        if (this.measureMode) {
            return drawStyle;
        }
        int w = this.measureWidth(obj);
        if (this.x + w >= this.wid) {
            if (this.x != this.indent) {
                this.newRow();
            }
            if (this.x + w >= this.wid) {
                drawStyle = 1;
            }
        }
        return drawStyle;
    }

    public boolean drawString(String s) {
        if (this.x >= this.wid) {
            return false;
        }
        int w = this.getWidth(s);
        if (this.x + w >= this.wid) {
            if (!this.measureMode && this.g != null) {
                this.g.drawString("...", this.x, this.y);
            }
            this.x = this.wid;
            return false;
        }
        if (!this.measureMode && this.g != null) {
            this.g.drawString(s, this.x, this.y);
        }
        this.x += w;
        return true;
    }

    public void newRow() {
        this.y += this.pitch;
        this.x = this.indent;
    }

    public void addIndent(int del) {
        this.indent += this.indentDel * del;
        this.newRow();
    }

    public int getHeight() {
        return this.y + this.pitch;
    }
}

