// Copyright (c) Tailscale Inc & AUTHORS
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale.com/cmd/cloner; DO NOT EDIT.

package types

import (
	"database/sql"
	"net/netip"
	"time"

	"gorm.io/gorm"
	"tailscale.com/tailcfg"
	"tailscale.com/types/key"
	"tailscale.com/types/ptr"
)

// Clone makes a deep copy of User.
// The result aliases no memory with the original.
func (src *User) Clone() *User {
	if src == nil {
		return nil
	}
	dst := new(User)
	*dst = *src
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _UserCloneNeedsRegeneration = User(struct {
	gorm.Model
	Name               string
	DisplayName        string
	Email              string
	ProviderIdentifier sql.NullString
	Provider           string
	ProfilePicURL      string
}{})

// Clone makes a deep copy of Node.
// The result aliases no memory with the original.
func (src *Node) Clone() *Node {
	if src == nil {
		return nil
	}
	dst := new(Node)
	*dst = *src
	dst.Endpoints = append(src.Endpoints[:0:0], src.Endpoints...)
	dst.Hostinfo = src.Hostinfo.Clone()
	if dst.IPv4 != nil {
		dst.IPv4 = ptr.To(*src.IPv4)
	}
	if dst.IPv6 != nil {
		dst.IPv6 = ptr.To(*src.IPv6)
	}
	dst.ForcedTags = append(src.ForcedTags[:0:0], src.ForcedTags...)
	if dst.AuthKeyID != nil {
		dst.AuthKeyID = ptr.To(*src.AuthKeyID)
	}
	dst.AuthKey = src.AuthKey.Clone()
	if dst.Expiry != nil {
		dst.Expiry = ptr.To(*src.Expiry)
	}
	if dst.LastSeen != nil {
		dst.LastSeen = ptr.To(*src.LastSeen)
	}
	dst.ApprovedRoutes = append(src.ApprovedRoutes[:0:0], src.ApprovedRoutes...)
	if dst.DeletedAt != nil {
		dst.DeletedAt = ptr.To(*src.DeletedAt)
	}
	if dst.IsOnline != nil {
		dst.IsOnline = ptr.To(*src.IsOnline)
	}
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _NodeCloneNeedsRegeneration = Node(struct {
	ID             NodeID
	MachineKey     key.MachinePublic
	NodeKey        key.NodePublic
	DiscoKey       key.DiscoPublic
	Endpoints      []netip.AddrPort
	Hostinfo       *tailcfg.Hostinfo
	IPv4           *netip.Addr
	IPv6           *netip.Addr
	Hostname       string
	GivenName      string
	UserID         uint
	User           User
	RegisterMethod string
	ForcedTags     []string
	AuthKeyID      *uint64
	AuthKey        *PreAuthKey
	Expiry         *time.Time
	LastSeen       *time.Time
	ApprovedRoutes []netip.Prefix
	CreatedAt      time.Time
	UpdatedAt      time.Time
	DeletedAt      *time.Time
	IsOnline       *bool
}{})

// Clone makes a deep copy of PreAuthKey.
// The result aliases no memory with the original.
func (src *PreAuthKey) Clone() *PreAuthKey {
	if src == nil {
		return nil
	}
	dst := new(PreAuthKey)
	*dst = *src
	dst.Tags = append(src.Tags[:0:0], src.Tags...)
	if dst.CreatedAt != nil {
		dst.CreatedAt = ptr.To(*src.CreatedAt)
	}
	if dst.Expiration != nil {
		dst.Expiration = ptr.To(*src.Expiration)
	}
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _PreAuthKeyCloneNeedsRegeneration = PreAuthKey(struct {
	ID         uint64
	Key        string
	UserID     uint
	User       User
	Reusable   bool
	Ephemeral  bool
	Used       bool
	Tags       []string
	CreatedAt  *time.Time
	Expiration *time.Time
}{})
