package models
import (
    "errors"
)
// Malware execution status
type WindowsMalwareExecutionState int

const (
    // Unknown
    UNKNOWN_WINDOWSMALWAREEXECUTIONSTATE WindowsMalwareExecutionState = iota
    // Blocked
    BLOCKED_WINDOWSMALWAREEXECUTIONSTATE
    // Allowed
    ALLOWED_WINDOWSMALWAREEXECUTIONSTATE
    // Running
    RUNNING_WINDOWSMALWAREEXECUTIONSTATE
    // Not running
    NOTRUNNING_WINDOWSMALWAREEXECUTIONSTATE
)

func (i WindowsMalwareExecutionState) String() string {
    return []string{"unknown", "blocked", "allowed", "running", "notRunning"}[i]
}
func ParseWindowsMalwareExecutionState(v string) (any, error) {
    result := UNKNOWN_WINDOWSMALWAREEXECUTIONSTATE
    switch v {
        case "unknown":
            result = UNKNOWN_WINDOWSMALWAREEXECUTIONSTATE
        case "blocked":
            result = BLOCKED_WINDOWSMALWAREEXECUTIONSTATE
        case "allowed":
            result = ALLOWED_WINDOWSMALWAREEXECUTIONSTATE
        case "running":
            result = RUNNING_WINDOWSMALWAREEXECUTIONSTATE
        case "notRunning":
            result = NOTRUNNING_WINDOWSMALWAREEXECUTIONSTATE
        default:
            return 0, errors.New("Unknown WindowsMalwareExecutionState value: " + v)
    }
    return &result, nil
}
func SerializeWindowsMalwareExecutionState(values []WindowsMalwareExecutionState) []string {
    result := make([]string, len(values))
    for i, v := range values {
        result[i] = v.String()
    }
    return result
}
