#![allow(dead_code, unused_imports)]
// Copyright 2016-2024 dbus-secret-service Contributors
//
// Licensed under the Apache License, Version 2.0, <LICENSE-APACHE or
// http://apache.org/licenses/LICENSE-2.0> or the MIT license <LICENSE-MIT or
// http://opensource.org/licenses/MIT>, at your option. This file may not be
// copied, modified, or distributed except according to those terms.

// This code generated by dbus-codegen-rust from xml generated by
// using dbus-send to introspect a prompt object path.
// Generation command without --file argument:
// `dbus-codegen-rust -i org.freedesktop.Secret. --interfaces=org.freedesktop.Secret.Prompt -c blocking`
// See https://github.com/diwic/dbus-rs
use dbus;
use dbus::arg;
use dbus::blocking;

pub trait Prompt {
    fn prompt(&self, window_id: &str) -> Result<(), dbus::Error>;
    fn dismiss(&self) -> Result<(), dbus::Error>;
}

#[derive(Debug)]
pub struct PromptCompleted {
    pub dismissed: bool,
    pub result: arg::Variant<Box<dyn arg::RefArg + 'static>>,
}

impl arg::AppendAll for PromptCompleted {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.dismissed, i);
        arg::RefArg::append(&self.result, i);
    }
}

impl arg::ReadAll for PromptCompleted {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(PromptCompleted {
            dismissed: i.read()?,
            result: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for PromptCompleted {
    const NAME: &'static str = "Completed";
    const INTERFACE: &'static str = "org.freedesktop.Secret.Prompt";
}

impl<T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> Prompt
    for blocking::Proxy<'_, C>
{
    fn prompt(&self, window_id: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.Secret.Prompt", "Prompt", (window_id,))
    }

    fn dismiss(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.Secret.Prompt", "Dismiss", ())
    }
}
