/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SimpleExclusiveLock
implements DBPExclusiveResource {
    private static final String TASK_GLOBAL = "#global";
    private final Map<String, Lock> locks = new HashMap<String, Lock>();

    @Override
    public Object acquireExclusiveLock() {
        return this.acquireTaskLock(TASK_GLOBAL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object acquireTaskLock(@NotNull String taskName, boolean checkDup) {
        Lock lock;
        Thread curThread = Thread.currentThread();
        SimpleExclusiveLock simpleExclusiveLock = this;
        synchronized (simpleExclusiveLock) {
            lock = this.locks.get(taskName);
            if (lock == null) {
                lock = new Lock();
                this.locks.put(taskName, lock);
            }
        }
        boolean taskRunning = false;
        while (true) {
            SimpleExclusiveLock simpleExclusiveLock2 = this;
            synchronized (simpleExclusiveLock2) {
                if (lock.lockThread == curThread || lock.lockThread == null) {
                    if (checkDup && taskRunning) {
                        return TASK_PROCESED;
                    }
                    lock.lockThread = curThread;
                    ++lock.lockCount;
                    return curThread;
                }
            }
            taskRunning = true;
            if (DBWorkbench.getPlatformUI().readAndDispatchEvents()) continue;
            RuntimeUtils.pause(50);
        }
    }

    @Override
    public void releaseExclusiveLock(@NotNull Object lock) {
        this.releaseTaskLock(TASK_GLOBAL, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTaskLock(@NotNull String taskName, @NotNull Object lockObj) {
        SimpleExclusiveLock simpleExclusiveLock = this;
        synchronized (simpleExclusiveLock) {
            Lock lock = this.locks.get(taskName);
            if (lock == null) {
                throw new IllegalArgumentException("Wrong task name: " + taskName);
            }
            if (lock.lockThread != lockObj) {
                throw new IllegalArgumentException("Wrong exclusive lock passed");
            }
            --lock.lockCount;
            if (lock.lockCount == 0) {
                lock.lockThread = null;
            } else if (lock.lockCount < 0) {
                throw new IllegalStateException("Internal error: negative lock count. Restart application.");
            }
        }
    }

    private static class Lock {
        private volatile Thread lockThread;
        private int lockCount = 0;

        private Lock() {
        }
    }
}

