/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1OID;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.Sequence;
import com.ca.commons.security.cert.extensions.IssuerAltName;
import com.ca.commons.security.cert.extensions.V3Extension;
import java.util.Hashtable;

public class AuthorityInfoAccess
implements V3Extension {
    String value = null;
    static Hashtable acc = new Hashtable();

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for AuthorityInfoAccess");
        }
        for (int i = 0; i < asn1object.size(); ++i) {
            if (!(asn1object.getComponent(i) instanceof Sequence)) {
                throw new Exception("AuthorityInfoAccess component is not sequence");
            }
            Sequence seq = (Sequence)asn1object.getComponent(i);
            for (int j = 0; j < seq.size(); ++j) {
                ASN1Object nextComp = seq.getComponent(j);
                if (j == 0) {
                    String accMethod = (String)acc.get(nextComp.getValue());
                    if (accMethod == null) {
                        accMethod = "Unidentified";
                    }
                    if (this.value == null) {
                        this.value = "Access Method: " + accMethod;
                        continue;
                    }
                    this.value = this.value + "\n" + "Access Method: " + accMethod;
                    continue;
                }
                if (j != 1) continue;
                this.value = this.value == null ? IssuerAltName.getGNameString(nextComp) : this.value + "\n" + IssuerAltName.getGNameString(nextComp);
            }
        }
    }

    public String toString() {
        return this.value;
    }

    static {
        acc.put(ASN1OID.authInfoAccessOCSP, "On-line Certificate Status Protocol");
    }
}

