/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1OID;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.V3Extension;

public class ExtendedKeyUsage
implements V3Extension {
    String value = null;

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for ExtendedKeyUsage");
        }
        for (int i = 0; i < asn1object.size(); ++i) {
            Object pur = asn1object.getComponent(i).getValue();
            if (!(pur instanceof String)) continue;
            String spur = (String)pur;
            if ((spur = ASN1OID.getName(spur)) == null) continue;
            this.value = this.value == null ? spur : this.value + "\n" + spur;
        }
    }

    public String toString() {
        return this.value;
    }
}

