/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.directory.jxplorer.JXConfig;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ConfirmDialog
extends JDialog
implements ActionListener {
    CBPanel display;
    JCheckBox showAgain;
    Properties myProperties = JXConfig.myProperties;
    String binaryProperty = "";
    CBButton OK;
    CBButton Cancel;
    boolean userResponse = false;
    private static Logger log = Logger.getLogger(ConfirmDialog.class.getName());

    public ConfirmDialog(String Msg, String binaryProperty, Frame parent) {
        super(parent);
        this.binaryProperty = binaryProperty;
        this.setSize(new Dimension(300, 120));
        this.display = new CBPanel();
        this.getContentPane().add(this.display);
        this.display.addln(new JLabel(Msg));
        JPanel buttons = new JPanel();
        this.OK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click here to confirm."));
        buttons.add(this.OK);
        this.Cancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to cancel."));
        buttons.add(this.Cancel);
        this.display.addln(buttons);
        this.OK.addActionListener(this);
        this.Cancel.addActionListener(this);
        if (this.myProperties != null && binaryProperty != null && this.myProperties.getProperty(binaryProperty) != null) {
            this.showAgain = new JCheckBox(CBIntText.get("show this dialog every time"), true);
            this.display.addln(this.showAgain);
            this.showAgain.addActionListener(this);
        } else {
            this.showAgain = null;
        }
        this.setVisible(false);
    }

    public boolean getUserResponse() {
        System.out.println("binary prop " + this.binaryProperty);
        System.out.println("myProperties " + (this.myProperties != null));
        if ("false".equals(this.myProperties.getProperty(this.binaryProperty))) {
            return true;
        }
        if (this.showAgain == null) {
            return true;
        }
        this.showAgain.setSelected(true);
        this.setVisible(true);
        this.showAgain.setSelected(true);
        this.startModal();
        this.showAgain.setSelected(true);
        return this.userResponse;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.showAgain) {
            this.myProperties.setProperty(this.binaryProperty, String.valueOf(this.showAgain.isSelected()));
            this.showAgain.repaint();
        } else if (ev.getSource() == this.OK) {
            this.userResponse = true;
            this.stopModal();
            this.setVisible(false);
        } else if (ev.getSource() == this.Cancel) {
            this.userResponse = false;
            this.stopModal();
            this.setVisible(false);
        }
    }

    synchronized void startModal() {
        if (this.isVisible() && !this.isShowing()) {
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.isVisible()) continue;
                parent.setVisible(true);
            }
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object src = event.getSource();
                    if (src instanceof Component) {
                        ((Component)src).dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        ((MenuComponent)src).dispatchEvent(event);
                        continue;
                    }
                    log.warning("unable to dispatch event: " + event);
                }
            } else {
                while (this.isVisible()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void stopModal() {
        this.notifyAll();
    }
}

