/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.NameUtility;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeNameAndType;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class AttributeTableModel
extends AbstractTableModel {
    int noRows = 0;
    DXEntry oldEntry;
    ArrayList<AttributeNameAndType> attributeTypes = new ArrayList();
    ArrayList<AttributeValue> attributeValues = new ArrayList();
    int numberNamingValues;
    String[] namingTypes;
    String[] namingRawValues;

    public int getRDNSize() {
        return this.numberNamingValues;
    }

    public Class getColumnClass(int c) {
        return c == 1 ? AttributeValue.class : AttributeNameAndType.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.noRows;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        if (col == 1) {
            if (aValue instanceof AttributeValue) {
                this.attributeValues.set(row, (AttributeValue)aValue);
            } else {
                this.attributeValues.get(row).update(aValue);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public String getStringValueAt(int row, int col) {
        String s = this.getValueAt(row, col).toString();
        if (s == null || s.length() == 0) {
            s = " ";
        }
        return s;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return col == 0 ? this.attributeTypes.get(row) : this.attributeValues.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (col > 1) {
            return false;
        }
        AttributeNameAndType att = this.attributeTypes.get(row);
        if (att.toString().equalsIgnoreCase("objectclass")) {
            return false;
        }
        return !att.isOperational();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "attribute type" : "value";
    }

    public void reset() {
        for (int i = 0; i < this.attributeValues.size(); ++i) {
            this.attributeValues.get(i).reset();
        }
        RDN rdn = this.oldEntry.getRDN();
        if (!rdn.equals(this.getRDN())) {
            this.setRDN(rdn);
        }
        this.fireChange();
    }

    public void clear() {
        this.noRows = 0;
        this.attributeTypes.clear();
        this.attributeValues.clear();
        this.fireChange();
    }

    public void insertAttributes(DXEntry entry) {
        if (entry == null) {
            return;
        }
        this.oldEntry = entry;
        this.noRows = 0;
        this.attributeTypes.clear();
        this.attributeValues.clear();
        try {
            RDN rdn = entry.getRDN();
            this.setRDN(rdn);
            DXNamingEnumeration mandatory = (DXNamingEnumeration)entry.getMandatory();
            while (mandatory.hasMore()) {
                this.insertAttribute((DXAttribute)mandatory.next(), 1);
            }
            DXNamingEnumeration active = (DXNamingEnumeration)entry.getAllNonNull();
            active.sort();
            while (active.hasMore()) {
                DXAttribute temp = (DXAttribute)active.next();
                if (mandatory.contains(temp) || temp.size() <= 0 || temp.get() == null) continue;
                this.insertAttribute(temp, 0);
            }
            DXNamingEnumeration possible = (DXNamingEnumeration)entry.getAll();
            possible.sort();
            while (possible.hasMore()) {
                DXAttribute temp = (DXAttribute)possible.next();
                if (mandatory.contains(temp) || temp.size() != 0 && temp.get() != null) continue;
                this.insertAttribute(temp, 0);
            }
            this.fireChange();
        }
        catch (NamingException e) {
            System.err.println("Naming Exception in AttributeTableModel: " + e);
        }
        catch (Exception e2) {
            System.err.println("Unexpected Exception in AttributeTableModel: " + e2);
            e2.printStackTrace();
        }
    }

    protected void setRDN(RDN rdn) {
        this.numberNamingValues = rdn.size();
        this.namingTypes = new String[this.numberNamingValues];
        this.namingRawValues = new String[this.numberNamingValues];
        for (int i = 0; i < this.numberNamingValues; ++i) {
            this.namingTypes[i] = rdn.getAttID(i);
            this.namingRawValues[i] = rdn.getRawVal(i);
        }
    }

    public void insertOperationalAttribute(DXAttribute att) {
        this.attributeTypes.add(0, new AttributeNameAndType(att.getID(), 3));
        try {
            String val = att.get().toString();
            this.attributeValues.add(0, new AttributeValue(att, val, false));
        }
        catch (NamingException e) {
            this.attributeValues.add(0, new AttributeValue(att, "error"));
        }
        ++this.noRows;
    }

    public void removeOperationalAttributes() {
        for (int i = this.attributeTypes.size() - 1; i >= 0; --i) {
            if (!this.attributeTypes.get(i).isOperational()) continue;
            this.attributeTypes.remove(i);
            this.attributeValues.remove(i);
            --this.noRows;
        }
    }

    public void insertAttribute(DXAttribute att, int type) throws NamingException {
        if (att == null) {
            return;
        }
        String ID2 = att.getID();
        if (att.size() == 0) {
            this.addAttribute(new AttributeValue(att, null), type);
        } else {
            String namingValue = this.getAnyNamingValue(ID2);
            if (namingValue != null && !att.isString()) {
                throw new NamingException("Binary naming attributes not supported in JXplorer: can't use attribute " + ID2 + " to name an entry");
            }
            Object[] vals = att.getValues();
            if (att.isString()) {
                Arrays.sort(vals, new Comparator<Object>(){

                    @Override
                    public int compare(Object str1, Object str2) {
                        return String.CASE_INSENSITIVE_ORDER.compare(str1.toString(), str2.toString());
                    }
                });
            }
            for (int i = 0; i < att.size(); ++i) {
                AttributeValue newAV = new AttributeValue(att, vals[i]);
                if (namingValue != null && newAV.getStringValue().equalsIgnoreCase(namingValue)) {
                    newAV.setNamingStatus(true);
                }
                this.addAttribute(newAV, type);
            }
        }
    }

    private String getAnyNamingValue(String ID2) {
        for (int i = 0; i < this.numberNamingValues; ++i) {
            if (!ID2.equalsIgnoreCase(this.namingTypes[i])) continue;
            return this.namingRawValues[i];
        }
        return null;
    }

    public void addAttribute(AttributeValue val, int type) {
        AttributeNameAndType newAtt = new AttributeNameAndType(val.getID(), type == 1);
        this.attributeTypes.add(newAtt);
        this.attributeValues.add(val);
        ++this.noRows;
    }

    public void addAttribute(AttributeValue val, int type, int indexPos) {
        AttributeNameAndType newAtt = new AttributeNameAndType(val.getID(), type == 1);
        this.attributeTypes.add(indexPos, newAtt);
        this.attributeValues.add(indexPos, val);
        ++this.noRows;
    }

    public void deleteAttribute(String ID2, int indexPos) {
        if (this.attributeTypes.get(indexPos).toString().equals(ID2)) {
            this.attributeValues.get(indexPos).update(new String(""));
        } else {
            System.err.println("Internal error: attempt to delete attribute with invalid ID in AttributeTableModel\n att name = " + this.attributeTypes.get(indexPos).toString() + " ID = " + ID2);
        }
    }

    public void fireChange() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public DXEntry getOldEntry() {
        return this.oldEntry;
    }

    public RDN getRDN() {
        String rdn = "";
        for (int i = 0; i < this.attributeValues.size(); ++i) {
            AttributeValue entryValue = this.attributeValues.get(i);
            if (!entryValue.isNaming()) continue;
            if (rdn.length() > 0) {
                rdn = rdn + "+";
            }
            rdn = rdn + this.attributeTypes.get(i).toString() + "=" + NameUtility.escape(entryValue.getStringValue());
        }
        if ("".equals(rdn)) {
            rdn = this.oldEntry.getRDN().toString();
        }
        return new RDN(rdn);
    }

    public DXEntry getNewEntry() {
        DN newDN = new DN(this.oldEntry.getDN());
        RDN newRDN = this.getRDN();
        newDN.setRDN(newRDN, newDN.size() - 1);
        DXEntry newEntry = new DXEntry(newDN);
        for (int i = 0; i < this.attributeTypes.size(); ++i) {
            String attString;
            AttributeValue currentAttributeValue = this.attributeValues.get(i);
            if (currentAttributeValue.isEmpty()) continue;
            String id = this.attributeTypes.get(i).toString();
            Object value = currentAttributeValue.value();
            if (value != null && value instanceof String && ((attString = (String)value).length() == 0 || attString.equals(" "))) {
                value = null;
            }
            if (value == null) continue;
            BasicAttribute currentAttribute = newEntry.get(id);
            if (currentAttribute == null) {
                currentAttribute = new BasicAttribute(id);
            }
            currentAttribute.add(value);
            newEntry.put(currentAttribute);
        }
        if (this.oldEntry.getStatus() == 1) {
            newEntry.setStatus(1);
        }
        return newEntry;
    }

    public Attribute getAttribute(String ID2) {
        BasicAttribute returnAtt = new BasicAttribute(ID2);
        for (int i = 0; i < this.attributeTypes.size(); ++i) {
            String attString;
            if (!ID2.equals(this.attributeTypes.get(i).toString())) continue;
            Object o = this.attributeValues.get(i).value();
            if (o != null && o instanceof String && ((attString = (String)o).length() == 0 || attString.equals(" "))) {
                o = null;
            }
            if (o == null) continue;
            returnAtt.add(o);
        }
        return returnAtt;
    }

    public boolean isMandatory(String attributeTypeName) {
        for (int i = 0; i < this.attributeTypes.size(); ++i) {
            if (!this.attributeTypes.get(i).toString().equals(attributeTypeName)) continue;
            return this.attributeTypes.get(i).isMandatory();
        }
        System.err.println("unable to find type name " + attributeTypeName);
        return false;
    }

    public boolean checkMandatoryAttributesSet() {
        String ID2 = "";
        boolean inDoubt = false;
        int i = 0;
        while (i < this.noRows) {
            AttributeNameAndType type = this.attributeTypes.get(i);
            if (type.isMandatory()) {
                ID2 = type.toString();
                inDoubt = true;
                AttributeNameAndType testType = type;
                while (ID2.equals(testType.toString()) && i < this.noRows) {
                    AttributeValue value;
                    if (inDoubt && !(value = this.attributeValues.get(i)).isEmpty()) {
                        inDoubt = false;
                    }
                    if (++i >= this.noRows) continue;
                    testType = this.attributeTypes.get(i);
                }
                if (!inDoubt) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removeNamingComponent(AttributeNameAndType currentType, AttributeValue currentValue) {
        try {
            int i;
            String type = currentType.getName();
            String value = currentValue.getStringValue();
            if ("".equals(type) || "".equals(value)) {
                return;
            }
            if (this.numberNamingValues == 1) {
                return;
            }
            for (i = 0; i < this.numberNamingValues; ++i) {
                if (!type.equals(this.namingTypes[i]) || !value.equals(this.namingRawValues[i])) continue;
                int removeRow = i;
                this.namingTypes = AttributeTableModel.removeRowFromArray(this.namingTypes, removeRow);
                this.namingRawValues = AttributeTableModel.removeRowFromArray(this.namingRawValues, removeRow);
                --this.numberNamingValues;
                break;
            }
            for (i = 0; i < this.attributeValues.size(); ++i) {
                AttributeValue attval = this.attributeValues.get(i);
                if (!attval.getID().equals(type) || !attval.getStringValue().equals(value)) continue;
                attval.setNamingStatus(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected static String[] removeRowFromArray(String[] array, int removeRow) {
        int originalLength = array.length;
        if (removeRow < 0 || removeRow >= originalLength) {
            return array;
        }
        String[] temp = new String[array.length - 1];
        if (removeRow > 0) {
            System.arraycopy(array, 0, temp, 0, removeRow);
        }
        if (removeRow < originalLength - 1) {
            System.arraycopy(array, removeRow + 1, temp, removeRow, originalLength - removeRow - 1);
        }
        return temp;
    }

    public void dumpNamingArrays() {
        System.out.println("dump naming array");
        for (int i = 0; i < this.numberNamingValues; ++i) {
            System.out.println(i + " type        " + this.namingTypes[i]);
            System.out.println(i + " value       " + this.namingRawValues[i]);
        }
    }

    public void addNamingComponent(AttributeNameAndType currentType, AttributeValue currentValue) {
        String type = currentType.getName();
        String value = currentValue.getStringValue();
        if ("".equals(type) || "".equals(value)) {
            return;
        }
        String[] tempTypes = new String[this.numberNamingValues + 1];
        String[] tempRawValues = new String[this.numberNamingValues + 1];
        System.arraycopy(this.namingTypes, 0, tempTypes, 0, this.numberNamingValues);
        System.arraycopy(this.namingRawValues, 0, tempRawValues, 0, this.numberNamingValues);
        tempTypes[this.numberNamingValues] = type;
        tempRawValues[this.numberNamingValues] = value;
        ++this.numberNamingValues;
        this.namingTypes = tempTypes;
        this.namingRawValues = tempRawValues;
        currentValue.setNamingStatus(true);
    }

    public boolean changedByUser() {
        for (int i = 0; i < this.attributeValues.size(); ++i) {
            if (!this.attributeValues.get(i).changed()) continue;
            return true;
        }
        return false;
    }
}

