# Configuration

JerryScript provides a large number of configuration options which can be used to enable or disable specific features, allowing users to fine tune the engine to best suit their needs.
A configuration option's value can be changed either by providing specific C preprocessor definitions, by adding CMake definitions, or by using the arguments of the `tools/build.py` script.
This document lists the available configuration options, shows the configuration name for C, CMake, and python, and provides a brief description that explains the effect of the options.


### Amalgamated build

Enables the amalgamated build process, which aggregates the contents of each source file per library
(i.e., JerryScript's core, port, and math libraries), and uses these combined files to compile the project.
This process can provide comparable results to link-time optimization, and can be useful when LTO is not available otherwise.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `<none>`                                     |
| CMake:  | `-DENABLE_AMALGAM=ON/OFF`                    |
| Python: | `--amalgam=ON/OFF`                           |

See also: [Amalgamated sources](#amalgamated-sources)

### Jerry debugger

Enables debugger support in the engine, which can be used to debug running JavaScript code. For more information on using the debugger see [Debugger](07.DEBUGGER.md).
The debugger is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_DEBUGGER=0/1`                       |
| CMake:  | `-DJERRY_DEBUGGER=ON/OFF`                    |
| Python: | `--jerry-debugger=ON/OFF`                    |

### Line information

By default, all source code information is discarded after parsing is complete. This option can be used to augment the created bytecode to provide line information during runtime,
that can be used by the debugger to identify the currently executed source context. See [Debugger](07.DEBUGGER.md).

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_LINE_INFO=0/1`                      |
| CMake:  | `-DJERRY_LINE_INFO=ON/OFF`                   |
| Python: | `--line-info=ON/OFF`                         |

### Profiles

This option can be used to enable/disable available JavaScript language features by providing profile files. Profile files contain a list of C definitions that configure each individual feature.
The `path` value for CMake and Python arguments should be a file path to the profile file, or one of `es.next` or `minimal`, which are the pre-defined profiles.
To see how a profile file should be created, or what configuration options are available in C, see the profile [README](https://github.com/jerryscript-project/jerryscript/blob/master/jerry-core/profiles/README.md).

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `<see description>`                          |
| CMake:  | `-DJERRY_PROFILE="path"`                     |
| Python: | `--profile="path"`                           |

### Promise callback

Enables Promise event notification support. This feature allows setting a user callback, which is called when certain Promise related events occur such as
creating a new Promise, resolving a Promise with a value, etc.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_PROMISE_CALLBACK=0/1`               |
| CMake:  | `-DJERRY_PROMISE_CALLBACK=ON/OFF`            |
| Python: | `--promise-callback=ON/OFF`                  |

### External context

Enables external context support in the engine. By default, JerryScript uses a statically allocated context to store the current state of the engine internals.
When this option is enabled, an externally allocated memory region can be provided through the port API to the engine, to be used as the context.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_EXTERNAL_CONTEXT=0/1`               |
| CMake:  | `-DJERRY_EXTERNAL_CONTEXT=ON/OFF`            |
| Python: | `--external-context=ON/OFF`                  |

### Snapshot execution

This option can be used to enable snapshot execution in the engine.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_SNAPSHOT_EXEC=0/1`                  |
| CMake:  | `-DJERRY_SNAPSHOT_EXEC=ON/OFF`               |
| Python: | `--snapshot-exec=ON/OFF`                     |

### Snapshot saving

This option can be used to enable snapshot saving in the engine.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_SNAPSHOT_SAVE=0/1`                  |
| CMake:  | `-DJERRY_SNAPSHOT_SAVE=ON/OFF`               |
| Python: | `--snapshot-save=ON/OFF`                     |

### Jerry parser

This option can be used to enable or disable the parser. When the parser is disabled all features that depend on source parsing are unavailable (eg. `jerry_parse`, `eval`, Function constructor).
This option can be useful in combination with the snapshot feature. The parser is enabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_PARSER=0/1`                         |
| CMake:  | `-DJERRY_PARSER=ON/OFF`                      |
| Python: | `--js-parser=ON/OFF`                         |

### Dump bytecode

This option can be used to display created bytecode in a human readable format. See [Internals](04.INTERNALS.md#byte-code) for more details.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_PARSER_DUMP_BYTE_CODE=0/1`          |
| CMake:  | `-DJERRY_PARSER_DUMP_BYTE_CODE=ON/OFF`       |
| Python: | `--show-opcodes=ON/OFF`                      |

### Dump RegExp bytecode

This option can be used to display created RegExp bytecode in a human readable format. The RegExp bytecode is different from the bytecode used by the virtual machine.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_REGEXP_DUMP_BYTE_CODE=0/1`          |
| CMake:  | `-DJERRY_REGEXP_DUMP_BYTE_CODE=ON/OFF`       |
| Python: | `--show-regexp-opcodes=ON/OFF`               |

### Strict RegExp

This option can be used to enable strict RegExp mode. The standard RegExp syntax is a lot stricter than what is common in current JavaScript implementations.
When enabled, this flag disables all of the non-standard, quality-of-life RegExp features, that are implemented to provide compatibility with other commonly used engines.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_REGEXP_STRICT_MODE=0/1`             |
| CMake:  | `-DJERRY_REGEXP_STRICT_MODE=ON/OFF`          |
| Python: | `--regexp-strict-mode=ON/OFF`                |

### Error messages

Enables error messages for thrown Error objects. By default, error messages are omitted to reduce memory usage.
Enabling this feature provides detailed error messages where available, like line information for Syntax errors, variable names for Reference errors, Type/Range error messages for built-in routines, etc.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_ERROR_MESSAGES=0/1`                 |
| CMake:  | `-DJERRY_ERROR_MESSAGES=ON/OFF`              |
| Python: | `--error-messages=ON/OFF`                    |

### Logging

This option can be used to enable log messages during runtime. When enabled the engine will use the `jerry_port_log` port API function to print relevant log messages.
This feature is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_LOGGING=0/1`                        |
| CMake:  | `-DJERRY_LOGGING=ON/OFF`                     |
| Python: | `--logging=ON/OFF`                           |

### LCache

This option enables the LCache, allowing faster access to object properties. The LCache uses a statically allocated hash-map, which increases memory consumption.
See [Internals](04.INTERNALS.md#lcache) for further details.
This option is enabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_LCACHE=0/1`                         |
| CMake:  | `<none>`                                     |
| Python: | `<none>`                                     |

### Property hashmaps

This option enables the creation of hashmaps for object properties, which allows faster property access, at the cost of increased memory consumption.
See [Internals](04.INTERNALS.md#property-hashmap) for further details.
This option is enabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_PROPERTY_HASHMAP=0/1`               |
| CMake:  | `<none>`                                     |
| Python: | `<none>`                                     |

### Memory statistics

This option can be used to provide memory usage statistics either upon engine termination, or during runtime using the `jerry_heap_stats` jerry API function.
The feature can create a significant performance overhead, and should only be used for measurement purposes. This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_MEM_STATS=0/1`                      |
| CMake:  | `-DJERRY_MEM_STATS=ON/OFF`                   |
| Python: | `--mem-stats=ON/OFF`                         |

### Heap size

This option can be used to adjust the size of the internal heap, represented in kilobytes. The provided value should be an integer. Values larger than 512 require 32-bit compressed pointers to be enabled.
The default value is 512.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_GLOBAL_HEAP_SIZE=(int)`             |
| CMake:  | `-DJERRY_GLOBAL_HEAP_SIZE=(int)`             |
| Python: | `--mem-heap=(int)`                           |

### Garbage collection limit

This option can be used to adjust the maximum allowed heap usage increase until triggering the next garbage collection, in bytes.
When the total allocated memory size reaches the current gc limit, garbage collection will be triggered to try and reduce clutter from unreachable objects.
If the total allocated memory can't be reduced below the current limit, then the limit will be increased by the amount specified via this option.
Similarly, when the total allocated memory goes well below the current gc limit, the limit is reduced by this amount.
The default value is 1/32 of the total heap size, but not greater than 8192 bytes.
A value of 0 will use the default value.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_GC_LIMIT=(int)`                     |
| CMake:  | `-DJERRY_GC_LIMIT=(int)`                     |
| Python: | `--gc-limit=(int)`                           |

### GC mark recursion limit

This option can be used to adjust the maximum recursion depth during the GC mark phase. The provided value should be an integer, which represents the allowed number of recursive calls. Increasing the depth of the recursion reduces the time of GC cycles, however increases stack usage.
A value of 0 will prevent any recursive GC calls.

| Options |                                                   |
|---------|---------------------------------------------------|
| C:      | `-DJERRY_GC_MARK_LIMIT=(int)`                     |
| CMake:  | `-DJERRY_GC_MARK_LIMIT=(int)`                     |
| Python: | `--gc-mark-limit=(int)`                           |

### Stack limit

This option can be used to cap the stack usage of the engine, and prevent stack overflows due to recursion. The provided value should be an integer, which represents the allowed stack usage in kilobytes.
The default value is 0 (unlimited).

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_STACK_LIMIT=(int)`                  |
| CMake:  | `-DJERRY_STACK_LIMIT=(int)`                  |
| Python: | `--stack-limit=(int)`                        |

### 32-bit compressed pointers

Enables 32-bit pointers instead of the default 16-bit compressed pointers. This allows the engine to use a much larger heap, but also comes with slightly increased memory usage, as objects can't be packed as tightly.
This option must be enabled when using the system allocator.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_CPOINTER_32_BIT=0/1`                |
| CMake:  | `-DJERRY_CPOINTER_32_BIT=ON/OFF`             |
| Python: | `--cpointer-32bit=ON/OFF`                    |

### System allocator

This option enables the use of malloc/free instead of the internal JerryScript allocator. This feature requires 32-bit compressed pointers, and is unsupported on 64-bit architectures.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_SYSTEM_ALLOCATOR=0/1`               |
| CMake:  | `-DJERRY_SYSTEM_ALLOCATOR=ON/OFF`            |
| Python: | `--system-allocator=ON/OFF`                  |

### Valgrind support

This option enables valgrind support for the internal allocator. When enabled, valgrind will be able to properly identify allocated memory regions, and report leaks or out-of-bounds memory accesses.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_VALGRIND=0/1`                       |
| CMake:  | `-DJERRY_VALGRIND=ON/OFF`                    |
| Python: | `--valgrind=ON/OFF`                          |

### Memory stress test

This option can be used to stress test memory management, by running garbage collection before every allocation attempt.
This option is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_MEM_GC_BEFORE_EACH_ALLOC=0/1`       |
| CMake:  | `-DJERRY_MEM_GC_BEFORE_EACH_ALLOC=ON/OFF`    |
| Python: | `--mem-stress-test=ON/OFF`                   |

### MSVC CRT

This option enables the use of the MSVC CRT library and is disabled by default.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `<none>`                                     |
| CMake:  | `-DENABLE_STATIC_CRT=ON/OFF`                 |
| Python: | `--static-crt=ON/OFF`                        |

### Architecture

Specify the platform name if it is supported by the generator.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `<none>`                                     |
| CMake:  | `-A (string)`                                |
| Python: | `--arch=(string)`                            |

### Tostring function

Enable function toString.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_FUNCTION_TO_STRING=0/1`             |
| CMake:  | `-DJERRY_FUNCTION_TO_STRING=ON/OFF`          |
| Python: | `--function-to-string=ON/OFF`                |


### VM throw

Enable VM throw.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_VM_THROW=0/1`                       |
| CMake:  | `-DJERRY_VM_THROW=ON/OFF`                    |
| Python: | `--vm-throw=ON/OFF`                          |


### Promise callback

Enable Promise callback.

| Options |                                              |
|---------|----------------------------------------------|
| C:      | `-DJERRY_PROMISE_CALLBACK=0/1`               |
| CMake:  | `-DJERRY_PROMISE_CALLBACK=ON/OFF`            |
| Python: | `--promise-callback=ON/OFF`                  |


# Amalgamated sources

The sources of JerryScript can be combined into a handful of files to allow their easy integration
in other projects. To achieve this, the following command can be executed to create a set of files
into the `amalgam` directory:

```sh
$ python tools/amalgam.py --output-dir amalgam --jerry-core --jerry-port --jerry-math
```

(Note: In the example above, the command is executed from the project's root directory, but that is
not mandatory.)

The command creates the following files in the `amalgam` dir:

* `jerryscript.c`
* `jerryscript.h`
* `jerryscript-config.h`
* `jerryscript-port.c`
* `jerryscript-math.c`
* `math.h`

**Important**: the `jerryscript-config.h` contains the configurations mentioned above and
should be adapted to the required use-case. See the file contents for more details and for the
default configuration. (Note: This config file is created from the the `jerry-core/config.h` file.)

These files can be directly compiled with an application using the JerryScript API.
E.g., using a command similar to the one below:

```sh
$ gcc -Wall -o demo_app demo_app.c amalgam/jerryscript.c amalgam/jerryscript-port.c amalgam/jerryscript-math.c -Iamalgam/
```

(Note: The headers must be available on the include path.)

This approach is also under the hood of the [amalgamated build](#amalgamated-build) process.

# Target specific information

## x86 with GCC

When building for Intel 32 bit architecture it is possible that GCC uses conservative options, thus assuming the most
basic floating-point support (that is it does not generate SSE or others instructions).
However this could lead to loss off precision and/or different results than what is required by the JavaScript standard
in regards of floating-point values and arithmetic.

To resolve this precision problem it is advised to use at least SSE2.
To do this with GCC please provide the `-mfpmath=sse -msse2` options during build.

These options can also be specified via the `build.py` script:

```sh
$ ./tools/build.py --compile-flag=-mfpmath=sse --compile-flag=-msse2 --compile-flag=-m32
```
