/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CODONNY98_H
#define CODONNY98_H

#include "codonyn98.h"

enum NSSITE_TYPE {
	ONE_RATIO, // one w for all sites
	NEUTRAL,  // two classes, w0 = 0 and w1 = 1
	NEARLY_NEUTRAL, // two classes, w1 = 1 and w0 = free
	SELECTION, // 3 classes, w0 = 0, w1 = 1 and w2 = free
	NEARLY_SELECTION, // 3 classes, w1 = 1 and w0, w2 = free
	DISCRETE   // n classes, unconstrained
	};

/**
Codon-baed Nielsen Yang 98 is an extended model of Yang Nielsen 98
which allows heterogenous nonsynonymous/synonymous ratio among sites
@author Bui Quang Minh
*/
class CodonNY98 : public CodonYN98 {
public:
	/** constructor
		@param classes number of classes for nonsynonymous/synonymous ratio 
	*/
	CodonNY98(int classes, NSSITE_TYPE nstype, double *ratio_val, double *prob_val);

	/**
		all things are inited here
	*/
	virtual void init ();


	/**
		Reinitialize
	*/
	void reInit ();

	/**
		Reinitialize a specific class
	*/
	void reInit (int classNo);

	/**
		compute negative log likelihood
	*/
	virtual double cmpNegLogLi (double value);

	/**
		the target function which needs to be optimized
	*/
	virtual double targetFunk(double[]);
	
	
	/**
		the approximated derivative function
		@param x the input vector x
		@param dfx the derivative at x
		@return the function value at x
	*/
	//virtual double derivativeFunk(double x[], double dfx[]); 
	
	/**
		check of range of parameters
	*/
	virtual bool checkRange(double x[]);

	/**
		check the propotion sum of variables to be <= 1.0
	*/
	bool checkProportionSum(double x[]);
	
	/**
		return TRUE if values is at the boundary
		only sum proprotion checked
	*/
	virtual bool atBoundary(double x[]);

	/**
		return TRUE if values is at the boundary, full check
	*/
	bool paramAtBoundary();
	
	/**
		return TRUE if at the first stage of the parameter estimation
	*/
	bool pamFirstStage();
	
	
	/**
		return the number of dimensions
	*/
	virtual int getNDim();
	
	/**
		pack the data to the vector x
	*/
	virtual void packData( double x[], double lower[], double upper[], bool bound_check[]);
	
	/**
		unpack data from vector x
	*/
	virtual void unpackData(double x[]);
	
	/**
		check direction of the search and fix it if neccesary
	*/
	//virtual void checkDirection(double x[], double dir[]);
	
	/**
		optimize parameters
	*/
	virtual bool optPam ();

	/**
		get the Ns/Sy Ratio of a class
	*/
	double getNsSyRatio(int classNo);

	/*
		calc total number of substitutions for 1 site class
	*/
	double calcTotalSubst();
		
	/*
		calc the total number of substitutions for all site classes
	*/
	void calcTotalNumSubst();
	
	~CodonNY98 ();

	double nsSyRatioVec[MAX_NUM_CLASS];
	double nsSyProbVec[MAX_NUM_CLASS];
	PAM_TYPE nsSyRatioType[MAX_NUM_CLASS];
	PAM_TYPE nsSyProbType[MAX_NUM_CLASS];
	double total_subst[MAX_NUM_CLASS];
	
protected:
	int nsSyClasses;
	int actClassNo; // active class to optimize parameters
	NSSITE_TYPE ns_type;
};

#endif

