/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SIMANNEAL_H
#define SIMANNEAL_H

const double ERROR_X = 1.0e-4;

/**
Class implements Simulated Annealing algorithm for multidimensional optimization
Taken from Numerical Recipes in C, 1992.
@author Bui Quang Minh
*/
class SimAnneal {
public:

	SimAnneal();

	/**
		the target function which needs to be optimized
		@param x the input vector x
		@return the function value at x
	*/
	virtual double targetFunk(double x[]) { return 0.0; }

	/**
		the approximated derivative function
		@param x the input vector x
		@param dfx the derivative at x
		@return the function value at x
	*/
	virtual double derivativeFunk(double x[], double dfx[]);
	
	/**
		check of range of parameters
	*/
	virtual bool checkRange(double x[]) { return true; }

	/**
		return TRUE if values is at the boundary
	*/
	virtual bool atBoundary(double x[]) { return false; }

	/**
		return the number of dimensions
	*/
	virtual int getNDim() { return 0; }
	
	/**
		pack the data to the vector x
	*/
	virtual void packData( double x[], double lower[], double upper[], bool bound_check[]) {  }
	
	/**
		unpack data from vector x
	*/
	virtual void unpackData(double x[]) { }

	/**
		check direction of the search and fix it if neccesary
	*/
	//virtual void checkDirection(double x[], double dir[]) {}
		
	double amotsa(double **p, double y[], double psum[], int ndim, double pb[],
	              double *yb, int ihi, double *yhi, double fac, double lower[], double upper[]);

	/**
		run the Simulated Annealing optimization
	*/
	void amebsa(double **p, double y[], int ndim, double pb[], double *yb, double ftol,
	              int *iter, double temptr, double lower[], double upper[]);

	virtual ~SimAnneal();

	/**
		main function 
	*/
	double simulatedAnnealing(int vnum, double *variables, double *lower_bound, double *upper_bound);
	
	void initSchedule();
	
	/**
		return the new temperature
	*/
	void coolingSchedule();

	bool stopAnnealing();
	
protected:
	int total_move, cur_move, increment_move;
	double init_temperature, temperature;
		
};

double ran1(long *idum);
double *vector(long nl, long nh);
void nrerror(const char error_text[]);
void free_vector(double *v, long nl, long nh);
double **matrix(long nrl, long nrh, long ncl, long nch);
void free_matrix(double **m, long nrl, long nrh, long ncl, long nch);
void fixBound(double x[], double lower[], double upper[], int n);


#endif
