package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateConfigRulesReport invokes the config.GenerateConfigRulesReport API synchronously
func (client *Client) GenerateConfigRulesReport(request *GenerateConfigRulesReportRequest) (response *GenerateConfigRulesReportResponse, err error) {
	response = CreateGenerateConfigRulesReportResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateConfigRulesReportWithChan invokes the config.GenerateConfigRulesReport API asynchronously
func (client *Client) GenerateConfigRulesReportWithChan(request *GenerateConfigRulesReportRequest) (<-chan *GenerateConfigRulesReportResponse, <-chan error) {
	responseChan := make(chan *GenerateConfigRulesReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateConfigRulesReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateConfigRulesReportWithCallback invokes the config.GenerateConfigRulesReport API asynchronously
func (client *Client) GenerateConfigRulesReportWithCallback(request *GenerateConfigRulesReportRequest, callback func(response *GenerateConfigRulesReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateConfigRulesReportResponse
		var err error
		defer close(result)
		response, err = client.GenerateConfigRulesReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateConfigRulesReportRequest is the request struct for api GenerateConfigRulesReport
type GenerateConfigRulesReportRequest struct {
	*requests.RpcRequest
	ClientToken   string `position:"Body" name:"ClientToken"`
	ConfigRuleIds string `position:"Body" name:"ConfigRuleIds"`
}

// GenerateConfigRulesReportResponse is the response struct for api GenerateConfigRulesReport
type GenerateConfigRulesReportResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ReportId  string `json:"ReportId" xml:"ReportId"`
}

// CreateGenerateConfigRulesReportRequest creates a request to invoke GenerateConfigRulesReport API
func CreateGenerateConfigRulesReportRequest() (request *GenerateConfigRulesReportRequest) {
	request = &GenerateConfigRulesReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GenerateConfigRulesReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateConfigRulesReportResponse creates a response to parse from GenerateConfigRulesReport response
func CreateGenerateConfigRulesReportResponse() (response *GenerateConfigRulesReportResponse) {
	response = &GenerateConfigRulesReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
